The subdirectories in this directory contain Python scripts to run various 
"experiments" using Glimmer/CISM.  Some details about the experiments and how
to run them are given in the `README.md` files found in each subdirectory
and they are summarized in the documentation.

This directory also contains two Python source files:

netCDF.py 
=========

`netCDF.py` is a "module" (that is, code that is meant to be used by other Python
programs, not run by itself) that allows the Python scripts in the 
subdirectories to use whichever of the three python netCDF file packages,
Scientific.IO.NetCDF, netCDF4, or pycdf, that the user has installed.  There 
are links to this module in each of the subdirectories, but is is also
included in this directory for reference.

Of the three python netCDF file packages, pycdf is __NOT__ recommended.  There have
been problems with some versions of this module on some computers.  If you run 
`netCDF.py` by entering the following on a command line

```sh
python netCDF.py
```

a line should be output telling you which netCDF package will be used when  
running the Glimmer/CISM scripts on your computer.

viewNetCDF.py
=============

`viewNetCDF.py` is a script for viewing the netCDF files that are read and/or
written by Glimmer/CISM.  There are other tools available for doing this, such
as ncview; You may (or may not) prefer `viewNetCDF.py`; it works better on some
systems than others.  To run `viewNetCDF.py` enter the following on a command 
line:

```sh
python viewNetCDF.py filename.nc
```

where `filename.nc` is the name of the netCDF file that you want to view.  Left 
click on a variable name that appears in the list at the top left of the 
Graphical User Interface (GUI) that appears, then left click on the "plot" 
button.  In addition to the options displayed on the GUI there are some 
options "hidden" in a pop-up menu that appears if you right click on the GUI.
