      module mo_lin_matrix
      use chem_mods, only: veclen
      private
      public :: linmat
      contains
      subroutine linmat01( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,536) = -( rxt(k,20) + het_rates(k,1) )
         mat(k,547) = -( rxt(k,21) + het_rates(k,2) )
         mat(k,1) = -( het_rates(k,4) )
         mat(k,2) = -( het_rates(k,5) )
         mat(k,858) = -( het_rates(k,6) )
         mat(k,86) = -( het_rates(k,7) )
         mat(k,273) = -( rxt(k,22) + het_rates(k,8) )
         mat(k,92) = -( rxt(k,23) + het_rates(k,9) )
         mat(k,279) = -( rxt(k,24) + het_rates(k,10) )
         mat(k,342) = -( rxt(k,25) + het_rates(k,11) )
         mat(k,274) = .500_r8*rxt(k,22)
         mat(k,93) = rxt(k,23)
         mat(k,491) = .200_r8*rxt(k,71)
         mat(k,587) = .060_r8*rxt(k,73)
         mat(k,197) = -( rxt(k,26) + het_rates(k,12) )
         mat(k,490) = .200_r8*rxt(k,71)
         mat(k,585) = .200_r8*rxt(k,73)
         mat(k,501) = -( rxt(k,27) + het_rates(k,13) )
         mat(k,156) = rxt(k,47)
         mat(k,924) = rxt(k,57)
         mat(k,493) = .200_r8*rxt(k,71)
         mat(k,588) = .150_r8*rxt(k,73)
         mat(k,225) = -( rxt(k,28) + het_rates(k,14) )
         mat(k,586) = .210_r8*rxt(k,73)
         mat(k,163) = -( het_rates(k,15) )
         mat(k,259) = -( het_rates(k,16) )
         mat(k,1352) = -( het_rates(k,17) )
         mat(k,167) = rxt(k,75)
         mat(k,2006) = rxt(k,76)
         mat(k,440) = rxt(k,78)
         mat(k,754) = rxt(k,100)
         mat(k,656) = rxt(k,106)
         mat(k,1565) = rxt(k,240)*y(k,34) + rxt(k,266)*y(k,35) &
                      + 3.000_r8*rxt(k,267)*y(k,55) + 2.000_r8*rxt(k,268)*y(k,78) &
                      + 2.000_r8*rxt(k,289)*y(k,41) + rxt(k,290)*y(k,43)
         mat(k,1539) = 2.000_r8*rxt(k,277)*y(k,41) + rxt(k,279)*y(k,43) &
                      + 3.000_r8*rxt(k,284)*y(k,55)
         mat(k,1713) = 2.000_r8*rxt(k,278)*y(k,41) + rxt(k,280)*y(k,43) &
                      + 3.000_r8*rxt(k,285)*y(k,55)
         mat(k,166) = -( rxt(k,75) + het_rates(k,18) )
         mat(k,2019) = -( rxt(k,76) + het_rates(k,19) )
         mat(k,445) = rxt(k,77)
         mat(k,438) = -( rxt(k,77) + rxt(k,78) + rxt(k,550) + rxt(k,553) + rxt(k,558) &
                 + het_rates(k,20) )
         mat(k,169) = -( het_rates(k,22) )
         mat(k,240) = rxt(k,29)
         mat(k,241) = -( rxt(k,29) + het_rates(k,23) )
         mat(k,200) = -( het_rates(k,24) )
         mat(k,450) = -( het_rates(k,25) )
         mat(k,177) = -( het_rates(k,26) )
         mat(k,246) = -( rxt(k,30) + het_rates(k,27) )
         mat(k,206) = -( het_rates(k,28) )
         mat(k,943) = -( het_rates(k,29) )
         mat(k,1245) = .700_r8*rxt(k,56)
         mat(k,303) = -( rxt(k,31) + het_rates(k,30) )
         mat(k,55) = -( het_rates(k,31) )
         mat(k,181) = -( rxt(k,32) + het_rates(k,32) )
         mat(k,1849) = -( rxt(k,33) + rxt(k,34) + het_rates(k,42) )
         mat(k,543) = .100_r8*rxt(k,20)
         mat(k,555) = .100_r8*rxt(k,21)
         mat(k,312) = rxt(k,39)
         mat(k,963) = rxt(k,44)
         mat(k,976) = .330_r8*rxt(k,46)
         mat(k,995) = rxt(k,48)
         mat(k,583) = .690_r8*rxt(k,50)
         mat(k,1147) = 1.340_r8*rxt(k,51)
         mat(k,773) = rxt(k,58)
         mat(k,435) = rxt(k,63)
         mat(k,295) = rxt(k,64)
         mat(k,488) = .375_r8*rxt(k,66)
         mat(k,373) = .400_r8*rxt(k,68)
         mat(k,988) = .680_r8*rxt(k,70)
         mat(k,332) = rxt(k,309)
         mat(k,348) = 2.000_r8*rxt(k,339)
         mat(k,1574) = rxt(k,312)*y(k,54) + rxt(k,313)*y(k,54)
         mat(k,1076) = -( rxt(k,35) + het_rates(k,45) )
         mat(k,540) = .400_r8*rxt(k,20)
         mat(k,552) = .400_r8*rxt(k,21)
         mat(k,248) = rxt(k,30)
         mat(k,972) = .330_r8*rxt(k,46)
         mat(k,222) = rxt(k,54)
         mat(k,433) = rxt(k,63)
         mat(k,52) = -( het_rates(k,47) )
         mat(k,898) = -( rxt(k,36) + het_rates(k,48) )
         mat(k,539) = .250_r8*rxt(k,20)
         mat(k,551) = .250_r8*rxt(k,21)
         mat(k,305) = .820_r8*rxt(k,31)
         mat(k,966) = .170_r8*rxt(k,46)
         mat(k,482) = .300_r8*rxt(k,66)
         mat(k,369) = .050_r8*rxt(k,68)
         mat(k,981) = .500_r8*rxt(k,70)
         mat(k,1152) = -( rxt(k,37) + het_rates(k,49) )
         mat(k,282) = .180_r8*rxt(k,24)
         mat(k,227) = rxt(k,28)
         mat(k,498) = .400_r8*rxt(k,71)
         mat(k,596) = .540_r8*rxt(k,73)
         mat(k,318) = .510_r8*rxt(k,74)
         mat(k,446) = -( het_rates(k,50) )
         mat(k,406) = -( rxt(k,38) + het_rates(k,51) )
         mat(k,708) = -( het_rates(k,52) )
         mat(k,309) = -( rxt(k,39) + het_rates(k,53) )
         mat(k,1543) = -( rxt(k,215)*y(k,54) + rxt(k,277)*y(k,41) + rxt(k,279)*y(k,43) &
                      + rxt(k,282)*y(k,46) + rxt(k,284)*y(k,55) + het_rates(k,56) )
         mat(k,168) = rxt(k,75)
         mat(k,80) = 2.000_r8*rxt(k,92)
         mat(k,47) = 2.000_r8*rxt(k,93)
         mat(k,2131) = rxt(k,94)
         mat(k,908) = rxt(k,95)
         mat(k,103) = rxt(k,98)
         mat(k,1339) = rxt(k,104)
         mat(k,764) = rxt(k,107)
         mat(k,1569) = 4.000_r8*rxt(k,239)*y(k,33) + rxt(k,240)*y(k,34) &
                      + 2.000_r8*rxt(k,241)*y(k,36) + 2.000_r8*rxt(k,242)*y(k,37) &
                      + 2.000_r8*rxt(k,243)*y(k,38) + rxt(k,244)*y(k,39) &
                      + 2.000_r8*rxt(k,245)*y(k,40) + rxt(k,291)*y(k,82) &
                      + rxt(k,292)*y(k,83) + rxt(k,293)*y(k,84)
         mat(k,1717) = 3.000_r8*rxt(k,281)*y(k,44) + rxt(k,283)*y(k,46) &
                      + rxt(k,286)*y(k,82) + rxt(k,287)*y(k,83) + rxt(k,288)*y(k,84)
         mat(k,79) = -( rxt(k,92) + het_rates(k,57) )
         mat(k,46) = -( rxt(k,93) + rxt(k,249) + het_rates(k,58) )
         mat(k,2143) = -( rxt(k,94) + het_rates(k,59) )
         mat(k,914) = rxt(k,96)
         mat(k,234) = rxt(k,108)
         mat(k,48) = 2.000_r8*rxt(k,249)
         mat(k,906) = -( rxt(k,95) + rxt(k,96) + rxt(k,552) + rxt(k,557) + rxt(k,563) &
                 + het_rates(k,60) )
         mat(k,997) = -( het_rates(k,62) )
         mat(k,94) = 1.500_r8*rxt(k,23)
         mat(k,281) = .450_r8*rxt(k,24)
         mat(k,503) = .600_r8*rxt(k,27)
         mat(k,226) = rxt(k,28)
         mat(k,1837) = rxt(k,33) + rxt(k,34)
         mat(k,1075) = rxt(k,35)
         mat(k,1151) = rxt(k,37)
         mat(k,961) = rxt(k,44)
         mat(k,799) = 2.000_r8*rxt(k,45)
         mat(k,970) = .330_r8*rxt(k,46)
         mat(k,1139) = 1.340_r8*rxt(k,52)
         mat(k,1247) = .700_r8*rxt(k,56)
         mat(k,127) = 1.500_r8*rxt(k,65)
         mat(k,485) = .250_r8*rxt(k,66)
         mat(k,918) = rxt(k,69)
         mat(k,983) = 1.700_r8*rxt(k,70)
         mat(k,254) = rxt(k,137)
         mat(k,1534) = rxt(k,282)*y(k,46)
         mat(k,518) = rxt(k,577)*y(k,63)
         mat(k,59) = -( rxt(k,97) + het_rates(k,64) )
         mat(k,1557) = rxt(k,240)*y(k,34) + rxt(k,242)*y(k,37) &
                      + 2.000_r8*rxt(k,243)*y(k,38) + 2.000_r8*rxt(k,244)*y(k,39) &
                      + rxt(k,245)*y(k,40) + rxt(k,266)*y(k,35) &
                      + 2.000_r8*rxt(k,268)*y(k,78) + rxt(k,292)*y(k,83) &
                      + rxt(k,293)*y(k,84)
         mat(k,1593) = rxt(k,287)*y(k,83) + rxt(k,288)*y(k,84)
         mat(k,101) = -( rxt(k,98) + het_rates(k,65) )
         mat(k,1559) = rxt(k,241)*y(k,36) + rxt(k,242)*y(k,37) + rxt(k,291)*y(k,82)
         mat(k,1598) = rxt(k,286)*y(k,82)
         mat(k,121) = -( het_rates(k,66) )
         mat(k,191) = -( het_rates(k,67) )
         mat(k,3) = -( het_rates(k,68) )
         mat(k,4) = -( het_rates(k,69) )
         mat(k,5) = -( het_rates(k,70) )
         mat(k,62) = -( rxt(k,43) + het_rates(k,72) )
         mat(k,673) = -( rxt(k,271)*y(k,54) + het_rates(k,73) )
         mat(k,60) = 2.000_r8*rxt(k,97)
         mat(k,102) = rxt(k,98)
         mat(k,153) = rxt(k,105)
         mat(k,1561) = rxt(k,244)*y(k,39) + rxt(k,266)*y(k,35)
         mat(k,960) = -( rxt(k,44) + het_rates(k,74) )
         mat(k,967) = .330_r8*rxt(k,46)
         mat(k,483) = .250_r8*rxt(k,66)
         mat(k,798) = -( rxt(k,45) + rxt(k,520) + het_rates(k,75) )
         mat(k,276) = rxt(k,22)
         mat(k,280) = .130_r8*rxt(k,24)
         mat(k,237) = .700_r8*rxt(k,62)
         mat(k,497) = .600_r8*rxt(k,71)
         mat(k,593) = .340_r8*rxt(k,73)
         mat(k,317) = .170_r8*rxt(k,74)
         mat(k,1928) = -( het_rates(k,76) )
         mat(k,2164) = 2.000_r8*rxt(k,2) + rxt(k,3)
         mat(k,1851) = 2.000_r8*rxt(k,33)
         mat(k,313) = rxt(k,39)
         mat(k,758) = rxt(k,100)
         mat(k,1344) = rxt(k,104)
         mat(k,154) = rxt(k,105)
         mat(k,1576) = rxt(k,312)*y(k,54)
         mat(k,1104) = -( het_rates(k,77) )
         mat(k,2150) = rxt(k,1)
         mat(k,1838) = rxt(k,34)
         mat(k,1563) = rxt(k,313)*y(k,54)
         mat(k,474) = -( rxt(k,4) + het_rates(k,79) )
         mat(k,2052) = .500_r8*rxt(k,521)
         mat(k,65) = -( rxt(k,136) + het_rates(k,80) )
         mat(k,753) = -( rxt(k,100) + het_rates(k,81) )
         mat(k,1337) = -( rxt(k,104) + het_rates(k,85) )
         mat(k,1538) = rxt(k,215)*y(k,54) + rxt(k,277)*y(k,41) + rxt(k,279)*y(k,43) &
                      + 2.000_r8*rxt(k,282)*y(k,46) + rxt(k,284)*y(k,55)
         mat(k,105) = -( het_rates(k,86) )
         mat(k,712) = -( het_rates(k,87) )
         mat(k,152) = -( rxt(k,105) + het_rates(k,88) )
         mat(k,672) = rxt(k,271)*y(k,54)
         mat(k,1951) = -( rxt(k,9) + het_rates(k,89) )
         mat(k,977) = rxt(k,522)
         mat(k,511) = rxt(k,523)
         mat(k,428) = rxt(k,524)
         mat(k,189) = 2.000_r8*rxt(k,525) + 2.000_r8*rxt(k,548) + 2.000_r8*rxt(k,551) &
                      + 2.000_r8*rxt(k,562)
         mat(k,271) = rxt(k,526)
         mat(k,936) = rxt(k,527)
         mat(k,1993) = .500_r8*rxt(k,529)
         mat(k,1909) = rxt(k,530)
         mat(k,289) = rxt(k,531)
         mat(k,161) = rxt(k,532)
         mat(k,524) = rxt(k,533)
         mat(k,443) = rxt(k,550) + rxt(k,553) + rxt(k,558)
         mat(k,912) = rxt(k,552) + rxt(k,557) + rxt(k,563)
      end do
      end subroutine linmat01
      subroutine linmat02( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,361) = -( rxt(k,10) + rxt(k,11) + rxt(k,212) + het_rates(k,90) )
         mat(k,654) = -( rxt(k,106) + het_rates(k,91) )
         mat(k,439) = rxt(k,550) + rxt(k,553) + rxt(k,558)
         mat(k,762) = -( rxt(k,107) + het_rates(k,92) )
         mat(k,905) = rxt(k,552) + rxt(k,557) + rxt(k,563)
         mat(k,968) = -( rxt(k,46) + rxt(k,522) + het_rates(k,93) )
         mat(k,155) = -( rxt(k,47) + het_rates(k,94) )
         mat(k,1188) = rxt(k,413)
         mat(k,991) = -( rxt(k,48) + het_rates(k,95) )
         mat(k,969) = .170_r8*rxt(k,46)
         mat(k,212) = -( het_rates(k,96) )
         mat(k,68) = -( het_rates(k,97) )
         mat(k,781) = -( het_rates(k,98) )
         mat(k,505) = -( rxt(k,523) + het_rates(k,99) )
         mat(k,422) = -( rxt(k,524) + het_rates(k,100) )
         mat(k,1124) = -( het_rates(k,101) )
         mat(k,297) = -( rxt(k,49) + het_rates(k,102) )
         mat(k,578) = -( rxt(k,50) + het_rates(k,103) )
         mat(k,298) = rxt(k,49)
         mat(k,39) = -( het_rates(k,104) )
         mat(k,1140) = -( rxt(k,51) + rxt(k,52) + het_rates(k,105) )
         mat(k,580) = .288_r8*rxt(k,50)
         mat(k,215) = -( het_rates(k,106) )
         mat(k,417) = -( rxt(k,53) + het_rates(k,107) )
         mat(k,535) = .800_r8*rxt(k,20)
         mat(k,546) = .800_r8*rxt(k,21)
         mat(k,220) = -( rxt(k,54) + het_rates(k,108) )
         mat(k,466) = -( rxt(k,55) + rxt(k,395) + het_rates(k,109) )
         mat(k,820) = -( het_rates(k,110) )
         mat(k,1251) = -( rxt(k,56) + het_rates(k,111) )
         mat(k,581) = .402_r8*rxt(k,50)
         mat(k,744) = -( rxt(k,111) + het_rates(k,112) )
         mat(k,1475) = rxt(k,15)
         mat(k,517) = rxt(k,578)
         mat(k,185) = -( rxt(k,13) + rxt(k,14) + rxt(k,213) + rxt(k,525) + rxt(k,548) &
                      + rxt(k,551) + rxt(k,562) + het_rates(k,114) )
         mat(k,267) = -( rxt(k,526) + het_rates(k,115) )
         mat(k,928) = -( rxt(k,57) + rxt(k,527) + het_rates(k,116) )
         mat(k,6) = -( het_rates(k,117) )
         mat(k,7) = -( het_rates(k,118) )
         mat(k,8) = -( het_rates(k,119) )
         mat(k,49) = -( het_rates(k,120) )
         mat(k,9) = -( rxt(k,528) + het_rates(k,121) )
         mat(k,1507) = -( rxt(k,15) + rxt(k,16) + het_rates(k,124) )
         mat(k,186) = rxt(k,14)
         mat(k,1984) = rxt(k,17) + .500_r8*rxt(k,529)
         mat(k,1900) = rxt(k,19)
         mat(k,686) = rxt(k,575)
         mat(k,1568) = 2.000_r8*rxt(k,206)*y(k,113)
         mat(k,1994) = -( rxt(k,17) + rxt(k,529) + het_rates(k,125) )
         mat(k,1952) = rxt(k,9)
         mat(k,365) = rxt(k,11) + rxt(k,212)
         mat(k,190) = rxt(k,13) + rxt(k,213)
         mat(k,1910) = rxt(k,18)
         mat(k,544) = rxt(k,20)
         mat(k,978) = rxt(k,46)
         mat(k,301) = rxt(k,49)
         mat(k,472) = rxt(k,55) + rxt(k,395)
         mat(k,937) = rxt(k,57)
         mat(k,774) = rxt(k,58)
         mat(k,290) = rxt(k,59)
         mat(k,162) = rxt(k,60)
         mat(k,356) = .600_r8*rxt(k,61) + rxt(k,346)
         mat(k,525) = rxt(k,67)
         mat(k,444) = rxt(k,77)
         mat(k,913) = rxt(k,96)
         mat(k,73) = rxt(k,470)
         mat(k,1907) = -( rxt(k,18) + rxt(k,19) + rxt(k,530) + het_rates(k,126) )
         mat(k,364) = rxt(k,10)
         mat(k,188) = rxt(k,13) + rxt(k,14) + rxt(k,213)
         mat(k,355) = .400_r8*rxt(k,61)
         mat(k,442) = rxt(k,78)
         mat(k,911) = rxt(k,95)
         mat(k,769) = -( rxt(k,58) + het_rates(k,127) )
         mat(k,285) = -( rxt(k,59) + rxt(k,531) + het_rates(k,128) )
         mat(k,10) = -( het_rates(k,129) )
         mat(k,11) = -( het_rates(k,130) )
         mat(k,12) = -( het_rates(k,131) )
         mat(k,13) = -( het_rates(k,132) )
         mat(k,1824) = -( rxt(k,120) + rxt(k,121) + rxt(k,122) + rxt(k,123) + rxt(k,124) &
                      + rxt(k,125) + het_rates(k,133) )
         mat(k,2161) = rxt(k,2)
         mat(k,1433) = 2.000_r8*rxt(k,5) + rxt(k,6) + rxt(k,127) + rxt(k,128) + rxt(k,129) &
                      + rxt(k,131) + rxt(k,132) + rxt(k,133) + 2.000_r8*rxt(k,134) &
                      + 2.000_r8*rxt(k,135)
         mat(k,1783) = rxt(k,8)
         mat(k,187) = rxt(k,14)
         mat(k,1512) = rxt(k,15)
         mat(k,1989) = rxt(k,17)
         mat(k,1905) = rxt(k,18)
         mat(k,2013) = rxt(k,76)
         mat(k,2135) = rxt(k,94)
         mat(k,233) = rxt(k,108)
         mat(k,1325) = rxt(k,138)
         mat(k,895) = rxt(k,139)
         mat(k,175) = rxt(k,140)
         mat(k,1573) = rxt(k,155)
         mat(k,1427) = -( rxt(k,5) + rxt(k,6) + rxt(k,126) + rxt(k,127) + rxt(k,128) &
                      + rxt(k,129) + rxt(k,130) + rxt(k,131) + rxt(k,132) + rxt(k,133) &
                      + rxt(k,134) + rxt(k,135) + het_rates(k,134) )
         mat(k,1777) = rxt(k,8)
         mat(k,1899) = rxt(k,19)
         mat(k,75) = rxt(k,151) + rxt(k,159)
         mat(k,78) = rxt(k,152)
         mat(k,1567) = rxt(k,207)*y(k,113)
         mat(k,1782) = -( rxt(k,7) + rxt(k,8) + het_rates(k,135) )
         mat(k,230) = -( rxt(k,108) + het_rates(k,137) )
         mat(k,251) = -( rxt(k,137) + het_rates(k,138) )
         mat(k,160) = -( rxt(k,60) + rxt(k,532) + het_rates(k,139) )
         mat(k,350) = -( rxt(k,61) + rxt(k,346) + het_rates(k,140) )
         mat(k,71) = -( rxt(k,470) + het_rates(k,141) )
         mat(k,357) = -( het_rates(k,142) )
         mat(k,182) = rxt(k,32)
         mat(k,96) = -( het_rates(k,143) )
         mat(k,235) = -( rxt(k,62) + het_rates(k,144) )
         mat(k,14) = -( het_rates(k,145) )
         mat(k,15) = -( het_rates(k,146) )
         mat(k,430) = -( rxt(k,63) + het_rates(k,147) )
         mat(k,291) = -( rxt(k,64) + het_rates(k,148) )
         mat(k,600) = -( het_rates(k,149) )
         mat(k,252) = rxt(k,137)
         mat(k,1316) = rxt(k,138)
         mat(k,1318) = -( rxt(k,138) + het_rates(k,151) )
         mat(k,893) = rxt(k,139)
         mat(k,892) = -( rxt(k,139) + het_rates(k,152) )
         mat(k,174) = rxt(k,140)
         mat(k,173) = -( rxt(k,140) + het_rates(k,153) )
         mat(k,66) = rxt(k,136)
         mat(k,16) = -( het_rates(k,154) )
         mat(k,17) = -( het_rates(k,155) )
         mat(k,18) = -( het_rates(k,156) )
         mat(k,19) = -( rxt(k,141) + het_rates(k,157) )
         mat(k,20) = -( rxt(k,142) + het_rates(k,158) )
         mat(k,21) = -( rxt(k,143) + het_rates(k,159) )
         mat(k,22) = -( rxt(k,144) + het_rates(k,160) )
         mat(k,23) = -( rxt(k,145) + het_rates(k,161) )
         mat(k,24) = -( rxt(k,146) + het_rates(k,162) )
         mat(k,25) = -( rxt(k,147) + het_rates(k,163) )
         mat(k,26) = -( rxt(k,148) + het_rates(k,164) )
         mat(k,27) = -( rxt(k,149) + het_rates(k,165) )
         mat(k,28) = -( rxt(k,150) + het_rates(k,166) )
         mat(k,29) = -( het_rates(k,167) )
         mat(k,797) = rxt(k,520)
         mat(k,30) = -( het_rates(k,168) )
         mat(k,31) = -( het_rates(k,169) )
         mat(k,32) = -( het_rates(k,170) )
         mat(k,33) = -( het_rates(k,171) )
         mat(k,45) = -( het_rates(k,173) )
         mat(k,126) = -( rxt(k,65) + het_rates(k,174) )
         mat(k,481) = -( rxt(k,66) + het_rates(k,175) )
         mat(k,521) = -( rxt(k,67) + rxt(k,533) + het_rates(k,176) )
         mat(k,368) = -( rxt(k,68) + het_rates(k,177) )
         mat(k,916) = -( rxt(k,69) + het_rates(k,178) )
         mat(k,286) = rxt(k,59)
         mat(k,522) = rxt(k,67)
         mat(k,370) = rxt(k,68)
         mat(k,982) = -( rxt(k,70) + het_rates(k,179) )
         mat(k,484) = rxt(k,66)
         mat(k,917) = rxt(k,69)
         mat(k,492) = -( rxt(k,71) + het_rates(k,180) )
         mat(k,114) = -( het_rates(k,181) )
         mat(k,130) = -( rxt(k,72) + het_rates(k,182) )
         mat(k,139) = -( het_rates(k,183) )
         mat(k,589) = -( rxt(k,73) + het_rates(k,184) )
         mat(k,147) = -( het_rates(k,185) )
         mat(k,315) = -( rxt(k,74) + het_rates(k,186) )
         mat(k,400) = -( het_rates(k,189) )
         mat(k,72) = rxt(k,470)
         mat(k,880) = -( het_rates(k,190) )
         mat(k,377) = -( het_rates(k,191) )
         mat(k,323) = -( het_rates(k,192) )
         mat(k,840) = -( het_rates(k,193) )
         mat(k,419) = rxt(k,53)
         mat(k,728) = -( het_rates(k,194) )
         mat(k,529) = -( het_rates(k,195) )
         mat(k,1302) = -( het_rates(k,196) )
         mat(k,283) = .130_r8*rxt(k,24)
         mat(k,228) = rxt(k,28)
         mat(k,900) = rxt(k,36)
         mat(k,1153) = rxt(k,37)
         mat(k,973) = .330_r8*rxt(k,46)
         mat(k,993) = rxt(k,48)
         mat(k,1144) = 1.340_r8*rxt(k,51)
         mat(k,420) = rxt(k,53)
         mat(k,223) = rxt(k,54)
         mat(k,1253) = .300_r8*rxt(k,56)
         mat(k,771) = rxt(k,58)
         mat(k,351) = .600_r8*rxt(k,61) + rxt(k,346)
         mat(k,293) = rxt(k,64)
         mat(k,128) = .500_r8*rxt(k,65)
         mat(k,985) = .650_r8*rxt(k,70)
         mat(k,1396) = -( het_rates(k,197) )
         mat(k,1078) = rxt(k,35)
         mat(k,901) = rxt(k,36)
         mat(k,408) = rxt(k,38)
         mat(k,1254) = .300_r8*rxt(k,56)
         mat(k,352) = .400_r8*rxt(k,61)
         mat(k,1540) = rxt(k,215)*y(k,54)
         mat(k,675) = rxt(k,271)*y(k,54)
         mat(k,1714) = rxt(k,304)*y(k,54)
         mat(k,1566) = rxt(k,311)*y(k,54)
      end do
      end subroutine linmat02
      subroutine linmat03( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,645) = -( het_rates(k,198) )
         mat(k,198) = .600_r8*rxt(k,26)
         mat(k,701) = -( het_rates(k,199) )
         mat(k,1471) = rxt(k,16)
         mat(k,743) = rxt(k,111)
         mat(k,1806) = rxt(k,120) + rxt(k,121) + rxt(k,122) + rxt(k,123) + rxt(k,124) &
                      + rxt(k,125)
         mat(k,1420) = rxt(k,126) + rxt(k,127) + rxt(k,128) + rxt(k,129) + rxt(k,130) &
                      + rxt(k,131) + rxt(k,132) + rxt(k,133)
         mat(k,458) = -( het_rates(k,200) )
         mat(k,345) = -( rxt(k,339) + het_rates(k,201) )
         mat(k,63) = rxt(k,43)
         mat(k,664) = -( het_rates(k,202) )
         mat(k,2115) = -( rxt(k,521) + het_rates(k,203) )
         mat(k,366) = rxt(k,11) + rxt(k,212)
         mat(k,545) = rxt(k,20)
         mat(k,556) = .900_r8*rxt(k,21)
         mat(k,278) = rxt(k,22)
         mat(k,95) = 1.500_r8*rxt(k,23)
         mat(k,284) = .560_r8*rxt(k,24)
         mat(k,344) = rxt(k,25)
         mat(k,199) = .600_r8*rxt(k,26)
         mat(k,504) = .600_r8*rxt(k,27)
         mat(k,229) = rxt(k,28)
         mat(k,245) = rxt(k,29)
         mat(k,250) = rxt(k,30)
         mat(k,307) = rxt(k,31)
         mat(k,1083) = rxt(k,35)
         mat(k,1158) = rxt(k,37)
         mat(k,964) = 2.000_r8*rxt(k,44)
         mat(k,801) = 2.000_r8*rxt(k,45)
         mat(k,979) = .670_r8*rxt(k,46)
         mat(k,159) = rxt(k,47)
         mat(k,996) = rxt(k,48)
         mat(k,302) = rxt(k,49)
         mat(k,584) = rxt(k,50)
         mat(k,1149) = 1.340_r8*rxt(k,51) + .660_r8*rxt(k,52)
         mat(k,938) = rxt(k,57)
         mat(k,239) = rxt(k,62)
         mat(k,436) = rxt(k,63)
         mat(k,129) = rxt(k,65)
         mat(k,489) = rxt(k,66)
         mat(k,526) = rxt(k,67)
         mat(k,374) = rxt(k,68)
         mat(k,923) = rxt(k,69)
         mat(k,989) = 1.200_r8*rxt(k,70)
         mat(k,500) = rxt(k,71)
         mat(k,599) = rxt(k,73)
         mat(k,320) = rxt(k,74)
         mat(k,334) = rxt(k,309)
         mat(k,349) = rxt(k,339)
         mat(k,1220) = rxt(k,413)
         mat(k,1554) = rxt(k,279)*y(k,43) + rxt(k,282)*y(k,46)
         mat(k,1728) = rxt(k,280)*y(k,43) + rxt(k,283)*y(k,46)
         mat(k,1580) = rxt(k,312)*y(k,54)
         mat(k,329) = -( rxt(k,309) + het_rates(k,204) )
         mat(k,1172) = -( het_rates(k,205) )
         mat(k,1206) = -( rxt(k,413) + het_rates(k,206) )
         mat(k,1231) = -( het_rates(k,207) )
         mat(k,607) = -( het_rates(k,208) )
         mat(k,343) = .600_r8*rxt(k,25)
         mat(k,1271) = -( het_rates(k,209) )
         mat(k,1143) = .660_r8*rxt(k,51)
         mat(k,468) = rxt(k,55) + rxt(k,395)
         mat(k,803) = -( het_rates(k,210) )
         mat(k,502) = .600_r8*rxt(k,27)
         mat(k,558) = -( het_rates(k,211) )
         mat(k,412) = -( het_rates(k,212) )
         mat(k,567) = -( het_rates(k,213) )
         mat(k,690) = -( het_rates(k,214) )
         mat(k,1470) = rxt(k,16)
         mat(k,682) = rxt(k,575)
         mat(k,516) = rxt(k,578)
         mat(k,384) = -( het_rates(k,215) )
         mat(k,739) = rxt(k,111)
         mat(k,1049) = -( het_rates(k,216) )
         mat(k,1570) = -( rxt(k,155) + rxt(k,206)*y(k,113) + rxt(k,207)*y(k,113) &
                      + rxt(k,239)*y(k,33) + rxt(k,240)*y(k,34) + rxt(k,241)*y(k,36) &
                      + rxt(k,242)*y(k,37) + rxt(k,243)*y(k,38) + rxt(k,244)*y(k,39) &
                      + rxt(k,245)*y(k,40) + rxt(k,266)*y(k,35) + rxt(k,267)*y(k,55) &
                      + rxt(k,268)*y(k,78) + rxt(k,289)*y(k,41) + rxt(k,290)*y(k,43) &
                      + rxt(k,291)*y(k,82) + rxt(k,292)*y(k,83) + rxt(k,293)*y(k,84) &
                      + rxt(k,311)*y(k,54) + rxt(k,312)*y(k,54) + rxt(k,313)*y(k,54) &
                 + het_rates(k,217) )
         mat(k,2158) = rxt(k,1)
         mat(k,1430) = rxt(k,6)
         mat(k,1780) = rxt(k,7)
         mat(k,74) = -( rxt(k,151) + rxt(k,159) + het_rates(k,218) )
         mat(k,1736) = rxt(k,7)
         mat(k,76) = rxt(k,163) + rxt(k,162)*y(k,63)
         mat(k,77) = -( rxt(k,152) + rxt(k,163) + rxt(k,162)*y(k,63) + het_rates(k,219) )
         mat(k,681) = -( rxt(k,575) + het_rates(k,220) )
         mat(k,1418) = rxt(k,126) + rxt(k,130)
         mat(k,515) = rxt(k,577)*y(k,63)
         mat(k,1719) = -( rxt(k,278)*y(k,41) + rxt(k,280)*y(k,43) + rxt(k,281)*y(k,44) &
                      + rxt(k,283)*y(k,46) + rxt(k,285)*y(k,55) + rxt(k,286)*y(k,82) &
                      + rxt(k,287)*y(k,83) + rxt(k,288)*y(k,84) + rxt(k,304)*y(k,54) &
                 + het_rates(k,221) )
         mat(k,2159) = rxt(k,3)
         mat(k,477) = 2.000_r8*rxt(k,4)
         mat(k,1945) = rxt(k,9)
         mat(k,363) = rxt(k,10)
         mat(k,554) = rxt(k,21)
         mat(k,277) = rxt(k,22)
         mat(k,244) = rxt(k,29)
         mat(k,249) = rxt(k,30)
         mat(k,306) = rxt(k,31)
         mat(k,184) = rxt(k,32)
         mat(k,409) = rxt(k,38)
         mat(k,311) = rxt(k,39)
         mat(k,64) = rxt(k,43)
         mat(k,158) = rxt(k,47)
         mat(k,224) = rxt(k,54)
         mat(k,288) = rxt(k,59)
         mat(k,238) = rxt(k,62)
         mat(k,434) = rxt(k,63)
         mat(k,294) = rxt(k,64)
         mat(k,487) = rxt(k,66)
         mat(k,372) = rxt(k,68)
         mat(k,499) = rxt(k,71)
         mat(k,132) = rxt(k,72)
         mat(k,598) = rxt(k,73)
         mat(k,319) = rxt(k,74)
         mat(k,658) = rxt(k,106)
         mat(k,765) = rxt(k,107)
         mat(k,1987) = .500_r8*rxt(k,529)
         mat(k,1571) = rxt(k,311)*y(k,54)
         mat(k,514) = -( rxt(k,578) + rxt(k,577)*y(k,63) + het_rates(k,222) )
         mat(k,1800) = rxt(k,120) + rxt(k,121) + rxt(k,122) + rxt(k,123) + rxt(k,124) &
                      + rxt(k,125)
         mat(k,1415) = rxt(k,127) + rxt(k,128) + rxt(k,129) + rxt(k,131) + rxt(k,132) &
                      + rxt(k,133)
         mat(k,336) = -( het_rates(k,223) )
         mat(k,717) = -( het_rates(k,224) )
         mat(k,1065) = -( het_rates(k,225) )
         mat(k,984) = .150_r8*rxt(k,70)
         mat(k,1030) = -( het_rates(k,226) )
         mat(k,1008) = -( het_rates(k,227) )
         mat(k,618) = -( het_rates(k,228) )
         mat(k,1091) = -( het_rates(k,229) )
         mat(k,634) = -( het_rates(k,230) )
         mat(k,392) = -( het_rates(k,231) )
         mat(k,2170) = -( rxt(k,1) + rxt(k,2) + rxt(k,3) + het_rates(k,232) )
         mat(k,67) = rxt(k,136)
         mat(k,1730) = rxt(k,278)*y(k,41) + rxt(k,280)*y(k,43) + rxt(k,281)*y(k,44) &
                      + rxt(k,283)*y(k,46) + rxt(k,288)*y(k,84) + rxt(k,304)*y(k,54)
      end do
      end subroutine linmat03
      subroutine linmat( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
      call linmat01( avec_len, mat, y, rxt, het_rates )
      call linmat02( avec_len, mat, y, rxt, het_rates )
      call linmat03( avec_len, mat, y, rxt, het_rates )
      end subroutine linmat
      end module mo_lin_matrix
