      module mo_lu_solve
      use chem_mods, only: veclen
      private
      public :: lu_slv
      contains
      subroutine lu_slv01( avec_len, lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: lu(veclen,max(1,nzcnt))
      real(r8), intent(inout) :: b(veclen,clscnt4)
!-----------------------------------------------------------------------
! ... Local variables
!-----------------------------------------------------------------------
      integer :: k
!-----------------------------------------------------------------------
! ... solve L * y = b
!-----------------------------------------------------------------------
      do k = 1,avec_len
         b(k,40) = b(k,40) - lu(k,2) * b(k,1)
         b(k,41) = b(k,41) - lu(k,3) * b(k,1)
         b(k,21) = b(k,21) - lu(k,5) * b(k,2)
         b(k,42) = b(k,42) - lu(k,6) * b(k,2)
         b(k,41) = b(k,41) - lu(k,8) * b(k,3)
         b(k,48) = b(k,48) - lu(k,9) * b(k,3)
         b(k,32) = b(k,32) - lu(k,11) * b(k,4)
         b(k,32) = b(k,32) - lu(k,14) * b(k,5)
         b(k,40) = b(k,40) - lu(k,16) * b(k,6)
         b(k,21) = b(k,21) - lu(k,18) * b(k,7)
         b(k,40) = b(k,40) - lu(k,19) * b(k,7)
         b(k,42) = b(k,42) - lu(k,20) * b(k,7)
         b(k,40) = b(k,40) - lu(k,22) * b(k,8)
         b(k,43) = b(k,43) - lu(k,23) * b(k,8)
         b(k,21) = b(k,21) - lu(k,25) * b(k,9)
         b(k,36) = b(k,36) - lu(k,26) * b(k,9)
         b(k,31) = b(k,31) - lu(k,28) * b(k,10)
         b(k,37) = b(k,37) - lu(k,29) * b(k,10)
         b(k,38) = b(k,38) - lu(k,30) * b(k,10)
         b(k,45) = b(k,45) - lu(k,31) * b(k,10)
         b(k,48) = b(k,48) - lu(k,32) * b(k,10)
         b(k,33) = b(k,33) - lu(k,34) * b(k,11)
         b(k,35) = b(k,35) - lu(k,35) * b(k,11)
         b(k,36) = b(k,36) - lu(k,36) * b(k,11)
         b(k,44) = b(k,44) - lu(k,37) * b(k,11)
         b(k,46) = b(k,46) - lu(k,38) * b(k,11)
         b(k,32) = b(k,32) - lu(k,40) * b(k,12)
         b(k,33) = b(k,33) - lu(k,41) * b(k,12)
         b(k,37) = b(k,37) - lu(k,42) * b(k,12)
         b(k,45) = b(k,45) - lu(k,43) * b(k,12)
         b(k,46) = b(k,46) - lu(k,44) * b(k,12)
         b(k,47) = b(k,47) - lu(k,45) * b(k,12)
         b(k,14) = b(k,14) - lu(k,47) * b(k,13)
         b(k,18) = b(k,18) - lu(k,48) * b(k,13)
         b(k,24) = b(k,24) - lu(k,49) * b(k,13)
         b(k,25) = b(k,25) - lu(k,50) * b(k,13)
         b(k,38) = b(k,38) - lu(k,51) * b(k,13)
         b(k,48) = b(k,48) - lu(k,52) * b(k,13)
         b(k,18) = b(k,18) - lu(k,54) * b(k,14)
         b(k,25) = b(k,25) - lu(k,55) * b(k,14)
         b(k,26) = b(k,26) - lu(k,56) * b(k,14)
         b(k,32) = b(k,32) - lu(k,57) * b(k,14)
         b(k,48) = b(k,48) - lu(k,58) * b(k,14)
         b(k,20) = b(k,20) - lu(k,60) * b(k,15)
         b(k,31) = b(k,31) - lu(k,61) * b(k,15)
         b(k,37) = b(k,37) - lu(k,62) * b(k,15)
         b(k,39) = b(k,39) - lu(k,63) * b(k,15)
         b(k,43) = b(k,43) - lu(k,64) * b(k,15)
         b(k,45) = b(k,45) - lu(k,65) * b(k,15)
         b(k,48) = b(k,48) - lu(k,66) * b(k,15)
         b(k,36) = b(k,36) - lu(k,68) * b(k,16)
         b(k,46) = b(k,46) - lu(k,69) * b(k,16)
         b(k,47) = b(k,47) - lu(k,70) * b(k,16)
         b(k,33) = b(k,33) - lu(k,72) * b(k,17)
         b(k,34) = b(k,34) - lu(k,73) * b(k,17)
         b(k,40) = b(k,40) - lu(k,74) * b(k,17)
         b(k,46) = b(k,46) - lu(k,75) * b(k,17)
         b(k,47) = b(k,47) - lu(k,76) * b(k,17)
         b(k,48) = b(k,48) - lu(k,77) * b(k,17)
         b(k,19) = b(k,19) - lu(k,79) * b(k,18)
         b(k,25) = b(k,25) - lu(k,80) * b(k,18)
         b(k,26) = b(k,26) - lu(k,81) * b(k,18)
         b(k,27) = b(k,27) - lu(k,82) * b(k,18)
         b(k,28) = b(k,28) - lu(k,83) * b(k,18)
         b(k,29) = b(k,29) - lu(k,84) * b(k,18)
         b(k,32) = b(k,32) - lu(k,85) * b(k,18)
         b(k,48) = b(k,48) - lu(k,86) * b(k,18)
         b(k,27) = b(k,27) - lu(k,88) * b(k,19)
         b(k,28) = b(k,28) - lu(k,89) * b(k,19)
         b(k,29) = b(k,29) - lu(k,90) * b(k,19)
         b(k,48) = b(k,48) - lu(k,91) * b(k,19)
         b(k,33) = b(k,33) - lu(k,94) * b(k,20)
         b(k,34) = b(k,34) - lu(k,95) * b(k,20)
         b(k,39) = b(k,39) - lu(k,96) * b(k,20)
         b(k,40) = b(k,40) - lu(k,97) * b(k,20)
         b(k,43) = b(k,43) - lu(k,98) * b(k,20)
         b(k,46) = b(k,46) - lu(k,99) * b(k,20)
         b(k,48) = b(k,48) - lu(k,100) * b(k,20)
         b(k,31) = b(k,31) - lu(k,103) * b(k,21)
         b(k,33) = b(k,33) - lu(k,104) * b(k,21)
         b(k,36) = b(k,36) - lu(k,105) * b(k,21)
         b(k,37) = b(k,37) - lu(k,106) * b(k,21)
         b(k,44) = b(k,44) - lu(k,107) * b(k,21)
         b(k,46) = b(k,46) - lu(k,108) * b(k,21)
         b(k,49) = b(k,49) - lu(k,109) * b(k,21)
         b(k,33) = b(k,33) - lu(k,112) * b(k,22)
         b(k,34) = b(k,34) - lu(k,113) * b(k,22)
         b(k,40) = b(k,40) - lu(k,114) * b(k,22)
         b(k,41) = b(k,41) - lu(k,115) * b(k,22)
         b(k,46) = b(k,46) - lu(k,116) * b(k,22)
         b(k,48) = b(k,48) - lu(k,117) * b(k,22)
         b(k,33) = b(k,33) - lu(k,119) * b(k,23)
         b(k,36) = b(k,36) - lu(k,120) * b(k,23)
         b(k,39) = b(k,39) - lu(k,121) * b(k,23)
         b(k,42) = b(k,42) - lu(k,122) * b(k,23)
         b(k,43) = b(k,43) - lu(k,123) * b(k,23)
         b(k,46) = b(k,46) - lu(k,124) * b(k,23)
         b(k,48) = b(k,48) - lu(k,125) * b(k,23)
         b(k,25) = b(k,25) - lu(k,128) * b(k,24)
         b(k,26) = b(k,26) - lu(k,129) * b(k,24)
         b(k,27) = b(k,27) - lu(k,130) * b(k,24)
         b(k,28) = b(k,28) - lu(k,131) * b(k,24)
         b(k,29) = b(k,29) - lu(k,132) * b(k,24)
         b(k,32) = b(k,32) - lu(k,133) * b(k,24)
         b(k,48) = b(k,48) - lu(k,134) * b(k,24)
         b(k,26) = b(k,26) - lu(k,139) * b(k,25)
         b(k,27) = b(k,27) - lu(k,140) * b(k,25)
         b(k,28) = b(k,28) - lu(k,141) * b(k,25)
         b(k,29) = b(k,29) - lu(k,142) * b(k,25)
         b(k,32) = b(k,32) - lu(k,143) * b(k,25)
         b(k,36) = b(k,36) - lu(k,144) * b(k,25)
         b(k,46) = b(k,46) - lu(k,145) * b(k,25)
         b(k,47) = b(k,47) - lu(k,146) * b(k,25)
         b(k,48) = b(k,48) - lu(k,147) * b(k,25)
         b(k,27) = b(k,27) - lu(k,150) * b(k,26)
         b(k,28) = b(k,28) - lu(k,151) * b(k,26)
         b(k,29) = b(k,29) - lu(k,152) * b(k,26)
         b(k,32) = b(k,32) - lu(k,153) * b(k,26)
         b(k,38) = b(k,38) - lu(k,154) * b(k,26)
         b(k,42) = b(k,42) - lu(k,155) * b(k,26)
         b(k,48) = b(k,48) - lu(k,156) * b(k,26)
         b(k,28) = b(k,28) - lu(k,165) * b(k,27)
         b(k,29) = b(k,29) - lu(k,166) * b(k,27)
         b(k,32) = b(k,32) - lu(k,167) * b(k,27)
         b(k,36) = b(k,36) - lu(k,168) * b(k,27)
         b(k,38) = b(k,38) - lu(k,169) * b(k,27)
         b(k,42) = b(k,42) - lu(k,170) * b(k,27)
         b(k,46) = b(k,46) - lu(k,171) * b(k,27)
         b(k,47) = b(k,47) - lu(k,172) * b(k,27)
         b(k,48) = b(k,48) - lu(k,173) * b(k,27)
         b(k,29) = b(k,29) - lu(k,179) * b(k,28)
         b(k,32) = b(k,32) - lu(k,180) * b(k,28)
         b(k,36) = b(k,36) - lu(k,181) * b(k,28)
         b(k,38) = b(k,38) - lu(k,182) * b(k,28)
         b(k,42) = b(k,42) - lu(k,183) * b(k,28)
         b(k,46) = b(k,46) - lu(k,184) * b(k,28)
         b(k,47) = b(k,47) - lu(k,185) * b(k,28)
         b(k,48) = b(k,48) - lu(k,186) * b(k,28)
         b(k,32) = b(k,32) - lu(k,194) * b(k,29)
         b(k,36) = b(k,36) - lu(k,195) * b(k,29)
         b(k,38) = b(k,38) - lu(k,196) * b(k,29)
         b(k,42) = b(k,42) - lu(k,197) * b(k,29)
         b(k,45) = b(k,45) - lu(k,198) * b(k,29)
         b(k,46) = b(k,46) - lu(k,199) * b(k,29)
         b(k,47) = b(k,47) - lu(k,200) * b(k,29)
         b(k,48) = b(k,48) - lu(k,201) * b(k,29)
         b(k,31) = b(k,31) - lu(k,205) * b(k,30)
         b(k,33) = b(k,33) - lu(k,206) * b(k,30)
         b(k,34) = b(k,34) - lu(k,207) * b(k,30)
         b(k,37) = b(k,37) - lu(k,208) * b(k,30)
         b(k,40) = b(k,40) - lu(k,209) * b(k,30)
         b(k,41) = b(k,41) - lu(k,210) * b(k,30)
         b(k,45) = b(k,45) - lu(k,211) * b(k,30)
         b(k,46) = b(k,46) - lu(k,212) * b(k,30)
         b(k,48) = b(k,48) - lu(k,213) * b(k,30)
         b(k,33) = b(k,33) - lu(k,217) * b(k,31)
         b(k,36) = b(k,36) - lu(k,218) * b(k,31)
         b(k,37) = b(k,37) - lu(k,219) * b(k,31)
         b(k,44) = b(k,44) - lu(k,220) * b(k,31)
         b(k,45) = b(k,45) - lu(k,221) * b(k,31)
         b(k,46) = b(k,46) - lu(k,222) * b(k,31)
         b(k,49) = b(k,49) - lu(k,223) * b(k,31)
         b(k,36) = b(k,36) - lu(k,237) * b(k,32)
         b(k,38) = b(k,38) - lu(k,238) * b(k,32)
         b(k,42) = b(k,42) - lu(k,239) * b(k,32)
         b(k,45) = b(k,45) - lu(k,240) * b(k,32)
         b(k,46) = b(k,46) - lu(k,241) * b(k,32)
         b(k,47) = b(k,47) - lu(k,242) * b(k,32)
         b(k,48) = b(k,48) - lu(k,243) * b(k,32)
         b(k,50) = b(k,50) - lu(k,244) * b(k,32)
         b(k,36) = b(k,36) - lu(k,249) * b(k,33)
         b(k,37) = b(k,37) - lu(k,250) * b(k,33)
         b(k,42) = b(k,42) - lu(k,251) * b(k,33)
         b(k,44) = b(k,44) - lu(k,252) * b(k,33)
         b(k,45) = b(k,45) - lu(k,253) * b(k,33)
         b(k,46) = b(k,46) - lu(k,254) * b(k,33)
         b(k,48) = b(k,48) - lu(k,255) * b(k,33)
         b(k,49) = b(k,49) - lu(k,256) * b(k,33)
         b(k,36) = b(k,36) - lu(k,265) * b(k,34)
         b(k,37) = b(k,37) - lu(k,266) * b(k,34)
         b(k,39) = b(k,39) - lu(k,267) * b(k,34)
         b(k,40) = b(k,40) - lu(k,268) * b(k,34)
         b(k,41) = b(k,41) - lu(k,269) * b(k,34)
         b(k,42) = b(k,42) - lu(k,270) * b(k,34)
         b(k,43) = b(k,43) - lu(k,271) * b(k,34)
         b(k,44) = b(k,44) - lu(k,272) * b(k,34)
         b(k,45) = b(k,45) - lu(k,273) * b(k,34)
         b(k,46) = b(k,46) - lu(k,274) * b(k,34)
         b(k,48) = b(k,48) - lu(k,275) * b(k,34)
         b(k,49) = b(k,49) - lu(k,276) * b(k,34)
         b(k,36) = b(k,36) - lu(k,283) * b(k,35)
         b(k,37) = b(k,37) - lu(k,284) * b(k,35)
         b(k,39) = b(k,39) - lu(k,285) * b(k,35)
         b(k,40) = b(k,40) - lu(k,286) * b(k,35)
         b(k,41) = b(k,41) - lu(k,287) * b(k,35)
         b(k,42) = b(k,42) - lu(k,288) * b(k,35)
         b(k,43) = b(k,43) - lu(k,289) * b(k,35)
         b(k,44) = b(k,44) - lu(k,290) * b(k,35)
         b(k,45) = b(k,45) - lu(k,291) * b(k,35)
         b(k,46) = b(k,46) - lu(k,292) * b(k,35)
         b(k,47) = b(k,47) - lu(k,293) * b(k,35)
         b(k,48) = b(k,48) - lu(k,294) * b(k,35)
         b(k,49) = b(k,49) - lu(k,295) * b(k,35)
      end do
      end subroutine lu_slv01
      subroutine lu_slv02( avec_len, lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: lu(veclen,max(1,nzcnt))
      real(r8), intent(inout) :: b(veclen,clscnt4)
!-----------------------------------------------------------------------
! ... Local variables
!-----------------------------------------------------------------------
      integer :: k
!-----------------------------------------------------------------------
! ... solve L * y = b
!-----------------------------------------------------------------------
      do k = 1,avec_len
         b(k,37) = b(k,37) - lu(k,299) * b(k,36)
         b(k,38) = b(k,38) - lu(k,300) * b(k,36)
         b(k,42) = b(k,42) - lu(k,301) * b(k,36)
         b(k,44) = b(k,44) - lu(k,302) * b(k,36)
         b(k,45) = b(k,45) - lu(k,303) * b(k,36)
         b(k,46) = b(k,46) - lu(k,304) * b(k,36)
         b(k,47) = b(k,47) - lu(k,305) * b(k,36)
         b(k,48) = b(k,48) - lu(k,306) * b(k,36)
         b(k,49) = b(k,49) - lu(k,307) * b(k,36)
         b(k,50) = b(k,50) - lu(k,308) * b(k,36)
         b(k,38) = b(k,38) - lu(k,317) * b(k,37)
         b(k,39) = b(k,39) - lu(k,318) * b(k,37)
         b(k,40) = b(k,40) - lu(k,319) * b(k,37)
         b(k,41) = b(k,41) - lu(k,320) * b(k,37)
         b(k,42) = b(k,42) - lu(k,321) * b(k,37)
         b(k,43) = b(k,43) - lu(k,322) * b(k,37)
         b(k,44) = b(k,44) - lu(k,323) * b(k,37)
         b(k,45) = b(k,45) - lu(k,324) * b(k,37)
         b(k,46) = b(k,46) - lu(k,325) * b(k,37)
         b(k,47) = b(k,47) - lu(k,326) * b(k,37)
         b(k,48) = b(k,48) - lu(k,327) * b(k,37)
         b(k,49) = b(k,49) - lu(k,328) * b(k,37)
         b(k,50) = b(k,50) - lu(k,329) * b(k,37)
         b(k,39) = b(k,39) - lu(k,340) * b(k,38)
         b(k,40) = b(k,40) - lu(k,341) * b(k,38)
         b(k,41) = b(k,41) - lu(k,342) * b(k,38)
         b(k,42) = b(k,42) - lu(k,343) * b(k,38)
         b(k,43) = b(k,43) - lu(k,344) * b(k,38)
         b(k,44) = b(k,44) - lu(k,345) * b(k,38)
         b(k,45) = b(k,45) - lu(k,346) * b(k,38)
         b(k,46) = b(k,46) - lu(k,347) * b(k,38)
         b(k,47) = b(k,47) - lu(k,348) * b(k,38)
         b(k,48) = b(k,48) - lu(k,349) * b(k,38)
         b(k,49) = b(k,49) - lu(k,350) * b(k,38)
         b(k,50) = b(k,50) - lu(k,351) * b(k,38)
         b(k,40) = b(k,40) - lu(k,364) * b(k,39)
         b(k,41) = b(k,41) - lu(k,365) * b(k,39)
         b(k,42) = b(k,42) - lu(k,366) * b(k,39)
         b(k,43) = b(k,43) - lu(k,367) * b(k,39)
         b(k,44) = b(k,44) - lu(k,368) * b(k,39)
         b(k,45) = b(k,45) - lu(k,369) * b(k,39)
         b(k,46) = b(k,46) - lu(k,370) * b(k,39)
         b(k,47) = b(k,47) - lu(k,371) * b(k,39)
         b(k,48) = b(k,48) - lu(k,372) * b(k,39)
         b(k,49) = b(k,49) - lu(k,373) * b(k,39)
         b(k,50) = b(k,50) - lu(k,374) * b(k,39)
         b(k,41) = b(k,41) - lu(k,390) * b(k,40)
         b(k,42) = b(k,42) - lu(k,391) * b(k,40)
         b(k,43) = b(k,43) - lu(k,392) * b(k,40)
         b(k,44) = b(k,44) - lu(k,393) * b(k,40)
         b(k,45) = b(k,45) - lu(k,394) * b(k,40)
         b(k,46) = b(k,46) - lu(k,395) * b(k,40)
         b(k,47) = b(k,47) - lu(k,396) * b(k,40)
         b(k,48) = b(k,48) - lu(k,397) * b(k,40)
         b(k,49) = b(k,49) - lu(k,398) * b(k,40)
         b(k,50) = b(k,50) - lu(k,399) * b(k,40)
         b(k,42) = b(k,42) - lu(k,417) * b(k,41)
         b(k,43) = b(k,43) - lu(k,418) * b(k,41)
         b(k,44) = b(k,44) - lu(k,419) * b(k,41)
         b(k,45) = b(k,45) - lu(k,420) * b(k,41)
         b(k,46) = b(k,46) - lu(k,421) * b(k,41)
         b(k,47) = b(k,47) - lu(k,422) * b(k,41)
         b(k,48) = b(k,48) - lu(k,423) * b(k,41)
         b(k,49) = b(k,49) - lu(k,424) * b(k,41)
         b(k,50) = b(k,50) - lu(k,425) * b(k,41)
         b(k,43) = b(k,43) - lu(k,443) * b(k,42)
         b(k,44) = b(k,44) - lu(k,444) * b(k,42)
         b(k,45) = b(k,45) - lu(k,445) * b(k,42)
         b(k,46) = b(k,46) - lu(k,446) * b(k,42)
         b(k,47) = b(k,47) - lu(k,447) * b(k,42)
         b(k,48) = b(k,48) - lu(k,448) * b(k,42)
         b(k,49) = b(k,49) - lu(k,449) * b(k,42)
         b(k,50) = b(k,50) - lu(k,450) * b(k,42)
         b(k,44) = b(k,44) - lu(k,464) * b(k,43)
         b(k,45) = b(k,45) - lu(k,465) * b(k,43)
         b(k,46) = b(k,46) - lu(k,466) * b(k,43)
         b(k,47) = b(k,47) - lu(k,467) * b(k,43)
         b(k,48) = b(k,48) - lu(k,468) * b(k,43)
         b(k,49) = b(k,49) - lu(k,469) * b(k,43)
         b(k,50) = b(k,50) - lu(k,470) * b(k,43)
         b(k,45) = b(k,45) - lu(k,484) * b(k,44)
         b(k,46) = b(k,46) - lu(k,485) * b(k,44)
         b(k,47) = b(k,47) - lu(k,486) * b(k,44)
         b(k,48) = b(k,48) - lu(k,487) * b(k,44)
         b(k,49) = b(k,49) - lu(k,488) * b(k,44)
         b(k,50) = b(k,50) - lu(k,489) * b(k,44)
         b(k,46) = b(k,46) - lu(k,510) * b(k,45)
         b(k,47) = b(k,47) - lu(k,511) * b(k,45)
         b(k,48) = b(k,48) - lu(k,512) * b(k,45)
         b(k,49) = b(k,49) - lu(k,513) * b(k,45)
         b(k,50) = b(k,50) - lu(k,514) * b(k,45)
         b(k,47) = b(k,47) - lu(k,542) * b(k,46)
         b(k,48) = b(k,48) - lu(k,543) * b(k,46)
         b(k,49) = b(k,49) - lu(k,544) * b(k,46)
         b(k,50) = b(k,50) - lu(k,545) * b(k,46)
         b(k,48) = b(k,48) - lu(k,568) * b(k,47)
         b(k,49) = b(k,49) - lu(k,569) * b(k,47)
         b(k,50) = b(k,50) - lu(k,570) * b(k,47)
         b(k,49) = b(k,49) - lu(k,608) * b(k,48)
         b(k,50) = b(k,50) - lu(k,609) * b(k,48)
         b(k,50) = b(k,50) - lu(k,629) * b(k,49)
      end do
      end subroutine lu_slv02
      subroutine lu_slv03( avec_len, lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: lu(veclen,max(1,nzcnt))
      real(r8), intent(inout) :: b(veclen,clscnt4)
!-----------------------------------------------------------------------
! ... Local variables
!-----------------------------------------------------------------------
      integer :: k
!-----------------------------------------------------------------------
! ... solve L * y = b
!-----------------------------------------------------------------------
      do k = 1,avec_len
!-----------------------------------------------------------------------
! ... Solve U * x = y
!-----------------------------------------------------------------------
         b(k,50) = b(k,50) * lu(k,647)
         b(k,49) = b(k,49) - lu(k,646) * b(k,50)
         b(k,48) = b(k,48) - lu(k,645) * b(k,50)
         b(k,47) = b(k,47) - lu(k,644) * b(k,50)
         b(k,46) = b(k,46) - lu(k,643) * b(k,50)
         b(k,45) = b(k,45) - lu(k,642) * b(k,50)
         b(k,44) = b(k,44) - lu(k,641) * b(k,50)
         b(k,43) = b(k,43) - lu(k,640) * b(k,50)
         b(k,42) = b(k,42) - lu(k,639) * b(k,50)
         b(k,41) = b(k,41) - lu(k,638) * b(k,50)
         b(k,40) = b(k,40) - lu(k,637) * b(k,50)
         b(k,39) = b(k,39) - lu(k,636) * b(k,50)
         b(k,38) = b(k,38) - lu(k,635) * b(k,50)
         b(k,37) = b(k,37) - lu(k,634) * b(k,50)
         b(k,36) = b(k,36) - lu(k,633) * b(k,50)
         b(k,32) = b(k,32) - lu(k,632) * b(k,50)
         b(k,5) = b(k,5) - lu(k,631) * b(k,50)
         b(k,4) = b(k,4) - lu(k,630) * b(k,50)
         b(k,49) = b(k,49) * lu(k,628)
         b(k,48) = b(k,48) - lu(k,627) * b(k,49)
         b(k,47) = b(k,47) - lu(k,626) * b(k,49)
         b(k,46) = b(k,46) - lu(k,625) * b(k,49)
         b(k,45) = b(k,45) - lu(k,624) * b(k,49)
         b(k,44) = b(k,44) - lu(k,623) * b(k,49)
         b(k,43) = b(k,43) - lu(k,622) * b(k,49)
         b(k,42) = b(k,42) - lu(k,621) * b(k,49)
         b(k,41) = b(k,41) - lu(k,620) * b(k,49)
         b(k,40) = b(k,40) - lu(k,619) * b(k,49)
         b(k,39) = b(k,39) - lu(k,618) * b(k,49)
         b(k,38) = b(k,38) - lu(k,617) * b(k,49)
         b(k,37) = b(k,37) - lu(k,616) * b(k,49)
         b(k,36) = b(k,36) - lu(k,615) * b(k,49)
         b(k,34) = b(k,34) - lu(k,614) * b(k,49)
         b(k,33) = b(k,33) - lu(k,613) * b(k,49)
         b(k,31) = b(k,31) - lu(k,612) * b(k,49)
         b(k,21) = b(k,21) - lu(k,611) * b(k,49)
         b(k,9) = b(k,9) - lu(k,610) * b(k,49)
         b(k,48) = b(k,48) * lu(k,607)
         b(k,47) = b(k,47) - lu(k,606) * b(k,48)
         b(k,46) = b(k,46) - lu(k,605) * b(k,48)
         b(k,45) = b(k,45) - lu(k,604) * b(k,48)
         b(k,44) = b(k,44) - lu(k,603) * b(k,48)
         b(k,43) = b(k,43) - lu(k,602) * b(k,48)
         b(k,42) = b(k,42) - lu(k,601) * b(k,48)
         b(k,41) = b(k,41) - lu(k,600) * b(k,48)
         b(k,40) = b(k,40) - lu(k,599) * b(k,48)
         b(k,39) = b(k,39) - lu(k,598) * b(k,48)
         b(k,38) = b(k,38) - lu(k,597) * b(k,48)
         b(k,37) = b(k,37) - lu(k,596) * b(k,48)
         b(k,36) = b(k,36) - lu(k,595) * b(k,48)
         b(k,35) = b(k,35) - lu(k,594) * b(k,48)
         b(k,34) = b(k,34) - lu(k,593) * b(k,48)
         b(k,33) = b(k,33) - lu(k,592) * b(k,48)
         b(k,32) = b(k,32) - lu(k,591) * b(k,48)
         b(k,31) = b(k,31) - lu(k,590) * b(k,48)
         b(k,30) = b(k,30) - lu(k,589) * b(k,48)
         b(k,29) = b(k,29) - lu(k,588) * b(k,48)
         b(k,28) = b(k,28) - lu(k,587) * b(k,48)
         b(k,27) = b(k,27) - lu(k,586) * b(k,48)
         b(k,26) = b(k,26) - lu(k,585) * b(k,48)
         b(k,25) = b(k,25) - lu(k,584) * b(k,48)
         b(k,24) = b(k,24) - lu(k,583) * b(k,48)
         b(k,23) = b(k,23) - lu(k,582) * b(k,48)
         b(k,22) = b(k,22) - lu(k,581) * b(k,48)
         b(k,20) = b(k,20) - lu(k,580) * b(k,48)
         b(k,19) = b(k,19) - lu(k,579) * b(k,48)
         b(k,18) = b(k,18) - lu(k,578) * b(k,48)
         b(k,17) = b(k,17) - lu(k,577) * b(k,48)
         b(k,16) = b(k,16) - lu(k,576) * b(k,48)
         b(k,15) = b(k,15) - lu(k,575) * b(k,48)
         b(k,14) = b(k,14) - lu(k,574) * b(k,48)
         b(k,13) = b(k,13) - lu(k,573) * b(k,48)
         b(k,5) = b(k,5) - lu(k,572) * b(k,48)
         b(k,4) = b(k,4) - lu(k,571) * b(k,48)
         b(k,47) = b(k,47) * lu(k,567)
         b(k,46) = b(k,46) - lu(k,566) * b(k,47)
         b(k,45) = b(k,45) - lu(k,565) * b(k,47)
         b(k,44) = b(k,44) - lu(k,564) * b(k,47)
         b(k,43) = b(k,43) - lu(k,563) * b(k,47)
         b(k,42) = b(k,42) - lu(k,562) * b(k,47)
         b(k,41) = b(k,41) - lu(k,561) * b(k,47)
         b(k,40) = b(k,40) - lu(k,560) * b(k,47)
         b(k,39) = b(k,39) - lu(k,559) * b(k,47)
         b(k,38) = b(k,38) - lu(k,558) * b(k,47)
         b(k,37) = b(k,37) - lu(k,557) * b(k,47)
         b(k,36) = b(k,36) - lu(k,556) * b(k,47)
         b(k,35) = b(k,35) - lu(k,555) * b(k,47)
         b(k,34) = b(k,34) - lu(k,554) * b(k,47)
         b(k,33) = b(k,33) - lu(k,553) * b(k,47)
         b(k,32) = b(k,32) - lu(k,552) * b(k,47)
         b(k,23) = b(k,23) - lu(k,551) * b(k,47)
         b(k,22) = b(k,22) - lu(k,550) * b(k,47)
         b(k,20) = b(k,20) - lu(k,549) * b(k,47)
         b(k,17) = b(k,17) - lu(k,548) * b(k,47)
         b(k,12) = b(k,12) - lu(k,547) * b(k,47)
         b(k,11) = b(k,11) - lu(k,546) * b(k,47)
         b(k,46) = b(k,46) * lu(k,541)
         b(k,45) = b(k,45) - lu(k,540) * b(k,46)
         b(k,44) = b(k,44) - lu(k,539) * b(k,46)
         b(k,43) = b(k,43) - lu(k,538) * b(k,46)
         b(k,42) = b(k,42) - lu(k,537) * b(k,46)
         b(k,41) = b(k,41) - lu(k,536) * b(k,46)
         b(k,40) = b(k,40) - lu(k,535) * b(k,46)
         b(k,39) = b(k,39) - lu(k,534) * b(k,46)
         b(k,38) = b(k,38) - lu(k,533) * b(k,46)
         b(k,37) = b(k,37) - lu(k,532) * b(k,46)
         b(k,36) = b(k,36) - lu(k,531) * b(k,46)
         b(k,35) = b(k,35) - lu(k,530) * b(k,46)
         b(k,34) = b(k,34) - lu(k,529) * b(k,46)
         b(k,33) = b(k,33) - lu(k,528) * b(k,46)
         b(k,32) = b(k,32) - lu(k,527) * b(k,46)
         b(k,31) = b(k,31) - lu(k,526) * b(k,46)
         b(k,30) = b(k,30) - lu(k,525) * b(k,46)
         b(k,29) = b(k,29) - lu(k,524) * b(k,46)
         b(k,23) = b(k,23) - lu(k,523) * b(k,46)
         b(k,22) = b(k,22) - lu(k,522) * b(k,46)
         b(k,21) = b(k,21) - lu(k,521) * b(k,46)
         b(k,17) = b(k,17) - lu(k,520) * b(k,46)
         b(k,16) = b(k,16) - lu(k,519) * b(k,46)
         b(k,12) = b(k,12) - lu(k,518) * b(k,46)
         b(k,11) = b(k,11) - lu(k,517) * b(k,46)
         b(k,7) = b(k,7) - lu(k,516) * b(k,46)
         b(k,2) = b(k,2) - lu(k,515) * b(k,46)
         b(k,45) = b(k,45) * lu(k,509)
         b(k,44) = b(k,44) - lu(k,508) * b(k,45)
         b(k,43) = b(k,43) - lu(k,507) * b(k,45)
         b(k,42) = b(k,42) - lu(k,506) * b(k,45)
         b(k,41) = b(k,41) - lu(k,505) * b(k,45)
         b(k,40) = b(k,40) - lu(k,504) * b(k,45)
         b(k,39) = b(k,39) - lu(k,503) * b(k,45)
         b(k,38) = b(k,38) - lu(k,502) * b(k,45)
         b(k,37) = b(k,37) - lu(k,501) * b(k,45)
         b(k,36) = b(k,36) - lu(k,500) * b(k,45)
         b(k,34) = b(k,34) - lu(k,499) * b(k,45)
         b(k,33) = b(k,33) - lu(k,498) * b(k,45)
         b(k,32) = b(k,32) - lu(k,497) * b(k,45)
         b(k,31) = b(k,31) - lu(k,496) * b(k,45)
         b(k,30) = b(k,30) - lu(k,495) * b(k,45)
         b(k,29) = b(k,29) - lu(k,494) * b(k,45)
         b(k,20) = b(k,20) - lu(k,493) * b(k,45)
         b(k,15) = b(k,15) - lu(k,492) * b(k,45)
         b(k,12) = b(k,12) - lu(k,491) * b(k,45)
         b(k,10) = b(k,10) - lu(k,490) * b(k,45)
         b(k,44) = b(k,44) * lu(k,483)
         b(k,43) = b(k,43) - lu(k,482) * b(k,44)
         b(k,42) = b(k,42) - lu(k,481) * b(k,44)
         b(k,41) = b(k,41) - lu(k,480) * b(k,44)
         b(k,40) = b(k,40) - lu(k,479) * b(k,44)
         b(k,39) = b(k,39) - lu(k,478) * b(k,44)
         b(k,38) = b(k,38) - lu(k,477) * b(k,44)
         b(k,37) = b(k,37) - lu(k,476) * b(k,44)
         b(k,36) = b(k,36) - lu(k,475) * b(k,44)
         b(k,35) = b(k,35) - lu(k,474) * b(k,44)
         b(k,33) = b(k,33) - lu(k,473) * b(k,44)
         b(k,32) = b(k,32) - lu(k,472) * b(k,44)
         b(k,11) = b(k,11) - lu(k,471) * b(k,44)
         b(k,43) = b(k,43) * lu(k,463)
         b(k,42) = b(k,42) - lu(k,462) * b(k,43)
         b(k,41) = b(k,41) - lu(k,461) * b(k,43)
         b(k,40) = b(k,40) - lu(k,460) * b(k,43)
         b(k,39) = b(k,39) - lu(k,459) * b(k,43)
         b(k,38) = b(k,38) - lu(k,458) * b(k,43)
         b(k,37) = b(k,37) - lu(k,457) * b(k,43)
         b(k,36) = b(k,36) - lu(k,456) * b(k,43)
         b(k,35) = b(k,35) - lu(k,455) * b(k,43)
         b(k,33) = b(k,33) - lu(k,454) * b(k,43)
         b(k,32) = b(k,32) - lu(k,453) * b(k,43)
         b(k,23) = b(k,23) - lu(k,452) * b(k,43)
         b(k,16) = b(k,16) - lu(k,451) * b(k,43)
         b(k,42) = b(k,42) * lu(k,442)
         b(k,41) = b(k,41) - lu(k,441) * b(k,42)
         b(k,40) = b(k,40) - lu(k,440) * b(k,42)
         b(k,39) = b(k,39) - lu(k,439) * b(k,42)
         b(k,38) = b(k,38) - lu(k,438) * b(k,42)
         b(k,37) = b(k,37) - lu(k,437) * b(k,42)
         b(k,36) = b(k,36) - lu(k,436) * b(k,42)
         b(k,35) = b(k,35) - lu(k,435) * b(k,42)
         b(k,34) = b(k,34) - lu(k,434) * b(k,42)
         b(k,33) = b(k,33) - lu(k,433) * b(k,42)
         b(k,32) = b(k,32) - lu(k,432) * b(k,42)
         b(k,31) = b(k,31) - lu(k,431) * b(k,42)
         b(k,23) = b(k,23) - lu(k,430) * b(k,42)
         b(k,21) = b(k,21) - lu(k,429) * b(k,42)
         b(k,7) = b(k,7) - lu(k,428) * b(k,42)
         b(k,5) = b(k,5) - lu(k,427) * b(k,42)
         b(k,2) = b(k,2) - lu(k,426) * b(k,42)
         b(k,41) = b(k,41) * lu(k,416)
         b(k,40) = b(k,40) - lu(k,415) * b(k,41)
         b(k,39) = b(k,39) - lu(k,414) * b(k,41)
         b(k,38) = b(k,38) - lu(k,413) * b(k,41)
         b(k,37) = b(k,37) - lu(k,412) * b(k,41)
         b(k,36) = b(k,36) - lu(k,411) * b(k,41)
         b(k,35) = b(k,35) - lu(k,410) * b(k,41)
         b(k,34) = b(k,34) - lu(k,409) * b(k,41)
         b(k,33) = b(k,33) - lu(k,408) * b(k,41)
         b(k,32) = b(k,32) - lu(k,407) * b(k,41)
         b(k,31) = b(k,31) - lu(k,406) * b(k,41)
         b(k,30) = b(k,30) - lu(k,405) * b(k,41)
         b(k,22) = b(k,22) - lu(k,404) * b(k,41)
         b(k,8) = b(k,8) - lu(k,403) * b(k,41)
         b(k,6) = b(k,6) - lu(k,402) * b(k,41)
         b(k,3) = b(k,3) - lu(k,401) * b(k,41)
         b(k,1) = b(k,1) - lu(k,400) * b(k,41)
      end do
      end subroutine lu_slv03
      subroutine lu_slv04( avec_len, lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: lu(veclen,max(1,nzcnt))
      real(r8), intent(inout) :: b(veclen,clscnt4)
!-----------------------------------------------------------------------
! ... Local variables
!-----------------------------------------------------------------------
      integer :: k
!-----------------------------------------------------------------------
! ... solve L * y = b
!-----------------------------------------------------------------------
      do k = 1,avec_len
         b(k,40) = b(k,40) * lu(k,389)
         b(k,39) = b(k,39) - lu(k,388) * b(k,40)
         b(k,38) = b(k,38) - lu(k,387) * b(k,40)
         b(k,37) = b(k,37) - lu(k,386) * b(k,40)
         b(k,36) = b(k,36) - lu(k,385) * b(k,40)
         b(k,35) = b(k,35) - lu(k,384) * b(k,40)
         b(k,34) = b(k,34) - lu(k,383) * b(k,40)
         b(k,33) = b(k,33) - lu(k,382) * b(k,40)
         b(k,32) = b(k,32) - lu(k,381) * b(k,40)
         b(k,31) = b(k,31) - lu(k,380) * b(k,40)
         b(k,30) = b(k,30) - lu(k,379) * b(k,40)
         b(k,22) = b(k,22) - lu(k,378) * b(k,40)
         b(k,17) = b(k,17) - lu(k,377) * b(k,40)
         b(k,16) = b(k,16) - lu(k,376) * b(k,40)
         b(k,6) = b(k,6) - lu(k,375) * b(k,40)
         b(k,39) = b(k,39) * lu(k,363)
         b(k,38) = b(k,38) - lu(k,362) * b(k,39)
         b(k,37) = b(k,37) - lu(k,361) * b(k,39)
         b(k,36) = b(k,36) - lu(k,360) * b(k,39)
         b(k,34) = b(k,34) - lu(k,359) * b(k,39)
         b(k,33) = b(k,33) - lu(k,358) * b(k,39)
         b(k,32) = b(k,32) - lu(k,357) * b(k,39)
         b(k,31) = b(k,31) - lu(k,356) * b(k,39)
         b(k,20) = b(k,20) - lu(k,355) * b(k,39)
         b(k,15) = b(k,15) - lu(k,354) * b(k,39)
         b(k,8) = b(k,8) - lu(k,353) * b(k,39)
         b(k,3) = b(k,3) - lu(k,352) * b(k,39)
         b(k,38) = b(k,38) * lu(k,339)
         b(k,37) = b(k,37) - lu(k,338) * b(k,38)
         b(k,36) = b(k,36) - lu(k,337) * b(k,38)
         b(k,35) = b(k,35) - lu(k,336) * b(k,38)
         b(k,32) = b(k,32) - lu(k,335) * b(k,38)
         b(k,29) = b(k,29) - lu(k,334) * b(k,38)
         b(k,28) = b(k,28) - lu(k,333) * b(k,38)
         b(k,27) = b(k,27) - lu(k,332) * b(k,38)
         b(k,26) = b(k,26) - lu(k,331) * b(k,38)
         b(k,19) = b(k,19) - lu(k,330) * b(k,38)
         b(k,37) = b(k,37) * lu(k,316)
         b(k,36) = b(k,36) - lu(k,315) * b(k,37)
         b(k,35) = b(k,35) - lu(k,314) * b(k,37)
         b(k,33) = b(k,33) - lu(k,313) * b(k,37)
         b(k,32) = b(k,32) - lu(k,312) * b(k,37)
         b(k,31) = b(k,31) - lu(k,311) * b(k,37)
         b(k,16) = b(k,16) - lu(k,310) * b(k,37)
         b(k,10) = b(k,10) - lu(k,309) * b(k,37)
         b(k,36) = b(k,36) * lu(k,298)
         b(k,33) = b(k,33) - lu(k,297) * b(k,36)
         b(k,32) = b(k,32) - lu(k,296) * b(k,36)
         b(k,35) = b(k,35) * lu(k,282)
         b(k,34) = b(k,34) - lu(k,281) * b(k,35)
         b(k,33) = b(k,33) - lu(k,280) * b(k,35)
         b(k,31) = b(k,31) - lu(k,279) * b(k,35)
         b(k,23) = b(k,23) - lu(k,278) * b(k,35)
         b(k,16) = b(k,16) - lu(k,277) * b(k,35)
         b(k,34) = b(k,34) * lu(k,264)
         b(k,33) = b(k,33) - lu(k,263) * b(k,34)
         b(k,31) = b(k,31) - lu(k,262) * b(k,34)
         b(k,30) = b(k,30) - lu(k,261) * b(k,34)
         b(k,22) = b(k,22) - lu(k,260) * b(k,34)
         b(k,20) = b(k,20) - lu(k,259) * b(k,34)
         b(k,8) = b(k,8) - lu(k,258) * b(k,34)
         b(k,6) = b(k,6) - lu(k,257) * b(k,34)
         b(k,33) = b(k,33) * lu(k,248)
         b(k,31) = b(k,31) - lu(k,247) * b(k,33)
         b(k,21) = b(k,21) - lu(k,246) * b(k,33)
         b(k,9) = b(k,9) - lu(k,245) * b(k,33)
         b(k,32) = b(k,32) * lu(k,236)
         b(k,29) = b(k,29) - lu(k,235) * b(k,32)
         b(k,28) = b(k,28) - lu(k,234) * b(k,32)
         b(k,27) = b(k,27) - lu(k,233) * b(k,32)
         b(k,26) = b(k,26) - lu(k,232) * b(k,32)
         b(k,25) = b(k,25) - lu(k,231) * b(k,32)
         b(k,24) = b(k,24) - lu(k,230) * b(k,32)
         b(k,19) = b(k,19) - lu(k,229) * b(k,32)
         b(k,18) = b(k,18) - lu(k,228) * b(k,32)
         b(k,14) = b(k,14) - lu(k,227) * b(k,32)
         b(k,13) = b(k,13) - lu(k,226) * b(k,32)
         b(k,5) = b(k,5) - lu(k,225) * b(k,32)
         b(k,4) = b(k,4) - lu(k,224) * b(k,32)
         b(k,31) = b(k,31) * lu(k,216)
         b(k,21) = b(k,21) - lu(k,215) * b(k,31)
         b(k,9) = b(k,9) - lu(k,214) * b(k,31)
         b(k,30) = b(k,30) * lu(k,204)
         b(k,22) = b(k,22) - lu(k,203) * b(k,30)
         b(k,6) = b(k,6) - lu(k,202) * b(k,30)
         b(k,29) = b(k,29) * lu(k,193)
         b(k,28) = b(k,28) - lu(k,192) * b(k,29)
         b(k,27) = b(k,27) - lu(k,191) * b(k,29)
         b(k,26) = b(k,26) - lu(k,190) * b(k,29)
         b(k,25) = b(k,25) - lu(k,189) * b(k,29)
         b(k,24) = b(k,24) - lu(k,188) * b(k,29)
         b(k,19) = b(k,19) - lu(k,187) * b(k,29)
         b(k,28) = b(k,28) * lu(k,178)
         b(k,27) = b(k,27) - lu(k,177) * b(k,28)
         b(k,26) = b(k,26) - lu(k,176) * b(k,28)
         b(k,25) = b(k,25) - lu(k,175) * b(k,28)
         b(k,24) = b(k,24) - lu(k,174) * b(k,28)
         b(k,27) = b(k,27) * lu(k,164)
         b(k,26) = b(k,26) - lu(k,163) * b(k,27)
         b(k,25) = b(k,25) - lu(k,162) * b(k,27)
         b(k,24) = b(k,24) - lu(k,161) * b(k,27)
         b(k,19) = b(k,19) - lu(k,160) * b(k,27)
         b(k,18) = b(k,18) - lu(k,159) * b(k,27)
         b(k,14) = b(k,14) - lu(k,158) * b(k,27)
         b(k,13) = b(k,13) - lu(k,157) * b(k,27)
         b(k,26) = b(k,26) * lu(k,149)
         b(k,19) = b(k,19) - lu(k,148) * b(k,26)
         b(k,25) = b(k,25) * lu(k,138)
         b(k,24) = b(k,24) - lu(k,137) * b(k,25)
         b(k,19) = b(k,19) - lu(k,136) * b(k,25)
         b(k,16) = b(k,16) - lu(k,135) * b(k,25)
         b(k,24) = b(k,24) * lu(k,127)
         b(k,19) = b(k,19) - lu(k,126) * b(k,24)
         b(k,23) = b(k,23) * lu(k,118)
         b(k,22) = b(k,22) * lu(k,111)
         b(k,6) = b(k,6) - lu(k,110) * b(k,22)
         b(k,21) = b(k,21) * lu(k,102)
         b(k,9) = b(k,9) - lu(k,101) * b(k,21)
         b(k,20) = b(k,20) * lu(k,93)
         b(k,8) = b(k,8) - lu(k,92) * b(k,20)
         b(k,19) = b(k,19) * lu(k,87)
         b(k,18) = b(k,18) * lu(k,78)
         b(k,17) = b(k,17) * lu(k,71)
         b(k,16) = b(k,16) * lu(k,67)
         b(k,15) = b(k,15) * lu(k,59)
         b(k,14) = b(k,14) * lu(k,53)
         b(k,13) = b(k,13) * lu(k,46)
         b(k,12) = b(k,12) * lu(k,39)
         b(k,11) = b(k,11) * lu(k,33)
         b(k,10) = b(k,10) * lu(k,27)
         b(k,9) = b(k,9) * lu(k,24)
         b(k,8) = b(k,8) * lu(k,21)
         b(k,7) = b(k,7) * lu(k,17)
         b(k,6) = b(k,6) * lu(k,15)
         b(k,5) = b(k,5) * lu(k,13)
         b(k,4) = b(k,4) - lu(k,12) * b(k,5)
         b(k,4) = b(k,4) * lu(k,10)
         b(k,3) = b(k,3) * lu(k,7)
         b(k,2) = b(k,2) * lu(k,4)
         b(k,1) = b(k,1) * lu(k,1)
      end do
      end subroutine lu_slv04
      subroutine lu_slv( avec_len, lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: lu(veclen,max(1,nzcnt))
      real(r8), intent(inout) :: b(veclen,clscnt4)
      call lu_slv01( avec_len, lu, b )
      call lu_slv02( avec_len, lu, b )
      call lu_slv03( avec_len, lu, b )
      call lu_slv04( avec_len, lu, b )
      end subroutine lu_slv
      end module mo_lu_solve
