      module mo_lin_matrix
      use chem_mods, only: veclen
      private
      public :: linmat
      contains
      subroutine linmat01( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,566) = -( rxt(k,19) + het_rates(k,1) )
         mat(k,577) = -( rxt(k,20) + het_rates(k,2) )
         mat(k,1) = -( het_rates(k,4) )
         mat(k,2) = -( het_rates(k,5) )
         mat(k,831) = -( het_rates(k,6) )
         mat(k,123) = -( het_rates(k,7) )
         mat(k,346) = -( rxt(k,21) + het_rates(k,8) )
         mat(k,129) = -( rxt(k,22) + het_rates(k,9) )
         mat(k,334) = -( rxt(k,23) + het_rates(k,10) )
         mat(k,397) = -( rxt(k,24) + het_rates(k,11) )
         mat(k,347) = .500_r8*rxt(k,21)
         mat(k,130) = rxt(k,22)
         mat(k,537) = .200_r8*rxt(k,70)
         mat(k,605) = .060_r8*rxt(k,72)
         mat(k,228) = -( rxt(k,25) + het_rates(k,12) )
         mat(k,536) = .200_r8*rxt(k,70)
         mat(k,603) = .200_r8*rxt(k,72)
         mat(k,547) = -( rxt(k,26) + het_rates(k,13) )
         mat(k,204) = rxt(k,46)
         mat(k,908) = rxt(k,56)
         mat(k,539) = .200_r8*rxt(k,70)
         mat(k,606) = .150_r8*rxt(k,72)
         mat(k,255) = -( rxt(k,27) + het_rates(k,14) )
         mat(k,604) = .210_r8*rxt(k,72)
         mat(k,194) = -( het_rates(k,15) )
         mat(k,294) = -( het_rates(k,16) )
         mat(k,1294) = -( het_rates(k,17) )
         mat(k,198) = rxt(k,74)
         mat(k,1946) = rxt(k,75)
         mat(k,505) = rxt(k,77)
         mat(k,721) = rxt(k,99)
         mat(k,685) = rxt(k,105)
         mat(k,1532) = rxt(k,220)*y(k,34) + rxt(k,246)*y(k,35) &
                      + 3.000_r8*rxt(k,247)*y(k,55) + 2.000_r8*rxt(k,248)*y(k,78) &
                      + 2.000_r8*rxt(k,269)*y(k,41) + rxt(k,270)*y(k,43)
         mat(k,2036) = 2.000_r8*rxt(k,257)*y(k,41) + rxt(k,259)*y(k,43) &
                      + 3.000_r8*rxt(k,264)*y(k,55)
         mat(k,1691) = 2.000_r8*rxt(k,258)*y(k,41) + rxt(k,260)*y(k,43) &
                      + 3.000_r8*rxt(k,265)*y(k,55)
         mat(k,197) = -( rxt(k,74) + het_rates(k,18) )
         mat(k,1959) = -( rxt(k,75) + het_rates(k,19) )
         mat(k,509) = rxt(k,76)
         mat(k,503) = -( rxt(k,76) + rxt(k,77) + rxt(k,532) + rxt(k,535) + rxt(k,540) &
                 + het_rates(k,20) )
         mat(k,200) = -( het_rates(k,22) )
         mat(k,270) = rxt(k,28)
         mat(k,271) = -( rxt(k,28) + het_rates(k,23) )
         mat(k,237) = -( het_rates(k,24) )
         mat(k,487) = -( het_rates(k,25) )
         mat(k,216) = -( het_rates(k,26) )
         mat(k,276) = -( rxt(k,29) + het_rates(k,27) )
         mat(k,243) = -( het_rates(k,28) )
         mat(k,893) = -( het_rates(k,29) )
         mat(k,1169) = .700_r8*rxt(k,55)
         mat(k,340) = -( rxt(k,30) + het_rates(k,30) )
         mat(k,99) = -( het_rates(k,31) )
         mat(k,220) = -( rxt(k,31) + het_rates(k,32) )
         mat(k,1722) = -( rxt(k,32) + rxt(k,33) + het_rates(k,42) )
         mat(k,574) = .100_r8*rxt(k,19)
         mat(k,586) = .100_r8*rxt(k,20)
         mat(k,355) = rxt(k,38)
         mat(k,928) = rxt(k,43)
         mat(k,941) = .330_r8*rxt(k,45)
         mat(k,964) = rxt(k,47)
         mat(k,602) = .690_r8*rxt(k,49)
         mat(k,1112) = 1.340_r8*rxt(k,50)
         mat(k,751) = rxt(k,57)
         mat(k,465) = rxt(k,62)
         mat(k,320) = rxt(k,63)
         mat(k,535) = .375_r8*rxt(k,65)
         mat(k,417) = .400_r8*rxt(k,67)
         mat(k,952) = .680_r8*rxt(k,69)
         mat(k,388) = rxt(k,289)
         mat(k,227) = 2.000_r8*rxt(k,319)
         mat(k,1540) = rxt(k,292)*y(k,54) + rxt(k,293)*y(k,54)
         mat(k,1040) = -( rxt(k,34) + het_rates(k,45) )
         mat(k,570) = .400_r8*rxt(k,19)
         mat(k,582) = .400_r8*rxt(k,20)
         mat(k,278) = rxt(k,29)
         mat(k,936) = .330_r8*rxt(k,45)
         mat(k,286) = rxt(k,53)
         mat(k,462) = rxt(k,62)
         mat(k,93) = -( het_rates(k,47) )
         mat(k,863) = -( rxt(k,35) + het_rates(k,48) )
         mat(k,569) = .250_r8*rxt(k,19)
         mat(k,581) = .250_r8*rxt(k,20)
         mat(k,342) = .820_r8*rxt(k,30)
         mat(k,930) = .170_r8*rxt(k,45)
         mat(k,528) = .300_r8*rxt(k,65)
         mat(k,412) = .050_r8*rxt(k,67)
         mat(k,945) = .500_r8*rxt(k,69)
         mat(k,1116) = -( rxt(k,36) + het_rates(k,49) )
         mat(k,337) = .180_r8*rxt(k,23)
         mat(k,257) = rxt(k,27)
         mat(k,544) = .400_r8*rxt(k,70)
         mat(k,614) = .540_r8*rxt(k,72)
         mat(k,373) = .510_r8*rxt(k,73)
         mat(k,467) = -( het_rates(k,50) )
         mat(k,435) = -( rxt(k,37) + het_rates(k,51) )
         mat(k,701) = -( het_rates(k,52) )
         mat(k,352) = -( rxt(k,38) + het_rates(k,53) )
         mat(k,2052) = -( rxt(k,195)*y(k,54) + rxt(k,257)*y(k,41) + rxt(k,259)*y(k,43) &
                      + rxt(k,262)*y(k,46) + rxt(k,264)*y(k,55) + het_rates(k,56) )
         mat(k,199) = rxt(k,74)
         mat(k,139) = 2.000_r8*rxt(k,91)
         mat(k,98) = 2.000_r8*rxt(k,92)
         mat(k,1988) = rxt(k,93)
         mat(k,879) = rxt(k,95)
         mat(k,143) = rxt(k,97)
         mat(k,1430) = rxt(k,103)
         mat(k,734) = rxt(k,106)
         mat(k,1548) = 4.000_r8*rxt(k,219)*y(k,33) + rxt(k,220)*y(k,34) &
                      + 2.000_r8*rxt(k,221)*y(k,36) + 2.000_r8*rxt(k,222)*y(k,37) &
                      + 2.000_r8*rxt(k,223)*y(k,38) + rxt(k,224)*y(k,39) &
                      + 2.000_r8*rxt(k,225)*y(k,40) + rxt(k,271)*y(k,82) &
                      + rxt(k,272)*y(k,83) + rxt(k,273)*y(k,84)
         mat(k,1707) = 3.000_r8*rxt(k,261)*y(k,44) + rxt(k,263)*y(k,46) &
                      + rxt(k,266)*y(k,82) + rxt(k,267)*y(k,83) + rxt(k,268)*y(k,84)
         mat(k,138) = -( rxt(k,91) + het_rates(k,57) )
         mat(k,96) = -( rxt(k,92) + rxt(k,229) + het_rates(k,58) )
         mat(k,1986) = -( rxt(k,93) + het_rates(k,59) )
         mat(k,877) = rxt(k,94)
         mat(k,263) = rxt(k,107)
         mat(k,97) = 2.000_r8*rxt(k,229)
         mat(k,871) = -( rxt(k,94) + rxt(k,95) + rxt(k,534) + rxt(k,539) + rxt(k,545) &
                 + het_rates(k,60) )
         mat(k,955) = -( het_rates(k,62) )
         mat(k,131) = 1.500_r8*rxt(k,22)
         mat(k,336) = .450_r8*rxt(k,23)
         mat(k,549) = .600_r8*rxt(k,26)
         mat(k,256) = rxt(k,27)
         mat(k,1712) = rxt(k,32) + rxt(k,33)
         mat(k,1039) = rxt(k,34)
         mat(k,1115) = rxt(k,36)
         mat(k,925) = rxt(k,43)
         mat(k,793) = 2.000_r8*rxt(k,44)
         mat(k,933) = .330_r8*rxt(k,45)
         mat(k,1103) = 1.340_r8*rxt(k,51)
         mat(k,1170) = .700_r8*rxt(k,55)
         mat(k,166) = 1.500_r8*rxt(k,64)
         mat(k,531) = .250_r8*rxt(k,65)
         mat(k,883) = rxt(k,68)
         mat(k,947) = 1.700_r8*rxt(k,69)
         mat(k,305) = rxt(k,110)
         mat(k,2032) = rxt(k,262)*y(k,46)
         mat(k,109) = -( rxt(k,96) + het_rates(k,64) )
         mat(k,1526) = rxt(k,220)*y(k,34) + rxt(k,222)*y(k,37) &
                      + 2.000_r8*rxt(k,223)*y(k,38) + 2.000_r8*rxt(k,224)*y(k,39) &
                      + rxt(k,225)*y(k,40) + rxt(k,246)*y(k,35) &
                      + 2.000_r8*rxt(k,248)*y(k,78) + rxt(k,272)*y(k,83) &
                      + rxt(k,273)*y(k,84)
         mat(k,1573) = rxt(k,267)*y(k,83) + rxt(k,268)*y(k,84)
         mat(k,140) = -( rxt(k,97) + het_rates(k,65) )
         mat(k,1527) = rxt(k,221)*y(k,36) + rxt(k,222)*y(k,37) + rxt(k,271)*y(k,82)
         mat(k,1577) = rxt(k,266)*y(k,82)
         mat(k,160) = -( het_rates(k,66) )
         mat(k,249) = -( het_rates(k,67) )
         mat(k,3) = -( het_rates(k,68) )
         mat(k,4) = -( het_rates(k,69) )
         mat(k,5) = -( het_rates(k,70) )
         mat(k,112) = -( rxt(k,42) + het_rates(k,72) )
         mat(k,693) = -( rxt(k,251)*y(k,54) + het_rates(k,73) )
         mat(k,110) = 2.000_r8*rxt(k,96)
         mat(k,141) = rxt(k,97)
         mat(k,209) = rxt(k,104)
         mat(k,1529) = rxt(k,224)*y(k,39) + rxt(k,246)*y(k,35)
         mat(k,924) = -( rxt(k,43) + het_rates(k,74) )
         mat(k,931) = .330_r8*rxt(k,45)
         mat(k,529) = .250_r8*rxt(k,65)
         mat(k,225) = rxt(k,320)
         mat(k,792) = -( rxt(k,44) + rxt(k,500) + het_rates(k,75) )
         mat(k,349) = rxt(k,21)
         mat(k,335) = .130_r8*rxt(k,23)
         mat(k,267) = .700_r8*rxt(k,61)
         mat(k,543) = .600_r8*rxt(k,70)
         mat(k,612) = .340_r8*rxt(k,72)
         mat(k,372) = .170_r8*rxt(k,73)
         mat(k,1320) = -( rxt(k,157) + het_rates(k,76) )
         mat(k,2063) = rxt(k,2) + 2.000_r8*rxt(k,3)
         mat(k,1716) = 2.000_r8*rxt(k,32)
         mat(k,353) = rxt(k,38)
         mat(k,722) = rxt(k,99)
         mat(k,1417) = rxt(k,103)
         mat(k,210) = rxt(k,104)
         mat(k,1534) = rxt(k,292)*y(k,54)
         mat(k,1051) = -( het_rates(k,77) )
         mat(k,2059) = rxt(k,1)
         mat(k,1713) = rxt(k,33)
         mat(k,1531) = rxt(k,293)*y(k,54)
         mat(k,520) = -( rxt(k,4) + het_rates(k,79) )
         mat(k,1461) = .500_r8*rxt(k,501)
         mat(k,115) = -( rxt(k,109) + het_rates(k,80) )
         mat(k,720) = -( rxt(k,99) + het_rates(k,81) )
         mat(k,1418) = -( rxt(k,103) + het_rates(k,85) )
         mat(k,2040) = rxt(k,195)*y(k,54) + rxt(k,257)*y(k,41) + rxt(k,259)*y(k,43) &
                      + 2.000_r8*rxt(k,262)*y(k,46) + rxt(k,264)*y(k,55)
         mat(k,144) = -( het_rates(k,86) )
         mat(k,705) = -( het_rates(k,87) )
         mat(k,208) = -( rxt(k,104) + het_rates(k,88) )
         mat(k,692) = rxt(k,251)*y(k,54)
         mat(k,1307) = -( rxt(k,9) + het_rates(k,89) )
         mat(k,938) = rxt(k,502)
         mat(k,515) = rxt(k,503)
         mat(k,476) = rxt(k,504)
         mat(k,232) = 2.000_r8*rxt(k,505) + 2.000_r8*rxt(k,530) + 2.000_r8*rxt(k,533) &
                      + 2.000_r8*rxt(k,544)
         mat(k,313) = rxt(k,506)
         mat(k,916) = rxt(k,507)
         mat(k,1756) = .500_r8*rxt(k,509)
         mat(k,1813) = rxt(k,510)
         mat(k,331) = rxt(k,511)
         mat(k,192) = rxt(k,512)
         mat(k,553) = rxt(k,513)
         mat(k,506) = rxt(k,532) + rxt(k,535) + rxt(k,540)
         mat(k,872) = rxt(k,534) + rxt(k,539) + rxt(k,545)
      end do
      end subroutine linmat01
      subroutine linmat02( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,358) = -( rxt(k,10) + rxt(k,11) + rxt(k,192) + het_rates(k,90) )
         mat(k,684) = -( rxt(k,105) + het_rates(k,91) )
         mat(k,504) = rxt(k,532) + rxt(k,535) + rxt(k,540)
         mat(k,729) = -( rxt(k,106) + het_rates(k,92) )
         mat(k,870) = rxt(k,534) + rxt(k,539) + rxt(k,545)
         mat(k,932) = -( rxt(k,45) + rxt(k,502) + het_rates(k,93) )
         mat(k,203) = -( rxt(k,46) + het_rates(k,94) )
         mat(k,1210) = rxt(k,393)
         mat(k,959) = -( rxt(k,47) + het_rates(k,95) )
         mat(k,934) = .170_r8*rxt(k,45)
         mat(k,281) = -( het_rates(k,96) )
         mat(k,103) = -( het_rates(k,97) )
         mat(k,766) = -( het_rates(k,98) )
         mat(k,511) = -( rxt(k,503) + het_rates(k,99) )
         mat(k,471) = -( rxt(k,504) + het_rates(k,100) )
         mat(k,1088) = -( het_rates(k,101) )
         mat(k,322) = -( rxt(k,48) + het_rates(k,102) )
         mat(k,596) = -( rxt(k,49) + het_rates(k,103) )
         mat(k,323) = rxt(k,48)
         mat(k,61) = -( het_rates(k,104) )
         mat(k,77) = -( het_rates(k,105) )
         mat(k,1104) = -( rxt(k,50) + rxt(k,51) + het_rates(k,106) )
         mat(k,598) = .288_r8*rxt(k,49)
         mat(k,289) = -( het_rates(k,107) )
         mat(k,447) = -( rxt(k,52) + het_rates(k,108) )
         mat(k,565) = .800_r8*rxt(k,19)
         mat(k,576) = .800_r8*rxt(k,20)
         mat(k,284) = -( rxt(k,53) + het_rates(k,109) )
         mat(k,479) = -( rxt(k,54) + rxt(k,375) + het_rates(k,110) )
         mat(k,805) = -( het_rates(k,111) )
         mat(k,1174) = -( rxt(k,55) + het_rates(k,112) )
         mat(k,599) = .402_r8*rxt(k,49)
         mat(k,364) = -( rxt(k,174) + het_rates(k,113) )
         mat(k,1338) = rxt(k,15)
         mat(k,231) = -( rxt(k,13) + rxt(k,14) + rxt(k,193) + rxt(k,505) + rxt(k,530) &
                      + rxt(k,533) + rxt(k,544) + het_rates(k,115) )
         mat(k,310) = -( rxt(k,506) + het_rates(k,116) )
         mat(k,912) = -( rxt(k,56) + rxt(k,507) + het_rates(k,117) )
         mat(k,6) = -( het_rates(k,118) )
         mat(k,7) = -( het_rates(k,119) )
         mat(k,8) = -( het_rates(k,120) )
         mat(k,90) = -( het_rates(k,121) )
         mat(k,9) = -( rxt(k,508) + het_rates(k,122) )
         mat(k,1395) = -( rxt(k,15) + het_rates(k,123) )
         mat(k,233) = rxt(k,13)
         mat(k,1758) = rxt(k,16) + .500_r8*rxt(k,509)
         mat(k,1815) = rxt(k,17)
         mat(k,366) = rxt(k,174)
         mat(k,1535) = 2.000_r8*rxt(k,186)*y(k,114)
         mat(k,1764) = -( rxt(k,16) + rxt(k,509) + het_rates(k,124) )
         mat(k,1312) = rxt(k,9)
         mat(k,361) = rxt(k,11) + rxt(k,192)
         mat(k,234) = rxt(k,14) + rxt(k,193)
         mat(k,1821) = rxt(k,18)
         mat(k,575) = rxt(k,19)
         mat(k,942) = rxt(k,45)
         mat(k,327) = rxt(k,48)
         mat(k,485) = rxt(k,54) + rxt(k,375)
         mat(k,921) = rxt(k,56)
         mat(k,752) = rxt(k,57)
         mat(k,333) = rxt(k,58)
         mat(k,193) = rxt(k,59)
         mat(k,408) = .600_r8*rxt(k,60) + rxt(k,326)
         mat(k,556) = rxt(k,66)
         mat(k,507) = rxt(k,76)
         mat(k,875) = rxt(k,94)
         mat(k,108) = rxt(k,450)
         mat(k,1822) = -( rxt(k,17) + rxt(k,18) + rxt(k,510) + het_rates(k,125) )
         mat(k,362) = rxt(k,10)
         mat(k,235) = rxt(k,13) + rxt(k,14) + rxt(k,193)
         mat(k,409) = .400_r8*rxt(k,60)
         mat(k,508) = rxt(k,77)
         mat(k,876) = rxt(k,95)
         mat(k,747) = -( rxt(k,57) + het_rates(k,126) )
         mat(k,328) = -( rxt(k,58) + rxt(k,511) + het_rates(k,127) )
         mat(k,10) = -( het_rates(k,128) )
         mat(k,11) = -( het_rates(k,129) )
         mat(k,12) = -( het_rates(k,130) )
         mat(k,13) = -( het_rates(k,131) )
         mat(k,2017) = -( rxt(k,151) + het_rates(k,132) )
         mat(k,2076) = rxt(k,3)
         mat(k,1937) = rxt(k,8)
         mat(k,236) = rxt(k,13)
         mat(k,1407) = rxt(k,15)
         mat(k,1770) = rxt(k,16)
         mat(k,1827) = rxt(k,18)
         mat(k,1961) = rxt(k,75)
         mat(k,1987) = rxt(k,93)
         mat(k,264) = rxt(k,107)
         mat(k,1137) = rxt(k,111) + rxt(k,492)
         mat(k,758) = rxt(k,112)
         mat(k,214) = rxt(k,113)
         mat(k,1547) = rxt(k,146) + rxt(k,147)
         mat(k,369) = rxt(k,174)
         mat(k,446) = rxt(k,486)
         mat(k,1934) = -( rxt(k,7) + rxt(k,8) + het_rates(k,133) )
         mat(k,2014) = rxt(k,151)
         mat(k,260) = -( rxt(k,107) + het_rates(k,135) )
         mat(k,302) = -( rxt(k,110) + het_rates(k,136) )
         mat(k,191) = -( rxt(k,59) + rxt(k,512) + het_rates(k,137) )
         mat(k,404) = -( rxt(k,60) + rxt(k,326) + het_rates(k,138) )
         mat(k,106) = -( rxt(k,450) + het_rates(k,139) )
         mat(k,400) = -( het_rates(k,140) )
         mat(k,221) = rxt(k,31)
         mat(k,133) = -( het_rates(k,141) )
         mat(k,265) = -( rxt(k,61) + het_rates(k,142) )
         mat(k,14) = -( het_rates(k,143) )
         mat(k,15) = -( het_rates(k,144) )
         mat(k,16) = -( het_rates(k,145) )
         mat(k,17) = -( het_rates(k,146) )
         mat(k,459) = -( rxt(k,62) + het_rates(k,147) )
         mat(k,316) = -( rxt(k,63) + het_rates(k,148) )
         mat(k,441) = -( rxt(k,486) + het_rates(k,149) )
         mat(k,303) = rxt(k,110)
         mat(k,1125) = rxt(k,111)
         mat(k,1127) = -( rxt(k,111) + rxt(k,492) + het_rates(k,151) )
         mat(k,755) = rxt(k,112)
         mat(k,442) = rxt(k,486)
         mat(k,754) = -( rxt(k,112) + het_rates(k,152) )
         mat(k,213) = rxt(k,113)
         mat(k,1126) = rxt(k,492)
         mat(k,212) = -( rxt(k,113) + het_rates(k,153) )
         mat(k,116) = rxt(k,109)
         mat(k,18) = -( het_rates(k,154) )
         mat(k,19) = -( het_rates(k,155) )
         mat(k,20) = -( het_rates(k,156) )
         mat(k,21) = -( rxt(k,114) + het_rates(k,157) )
         mat(k,22) = -( rxt(k,115) + het_rates(k,158) )
         mat(k,23) = -( rxt(k,116) + het_rates(k,159) )
         mat(k,24) = -( rxt(k,117) + het_rates(k,160) )
         mat(k,25) = -( rxt(k,118) + het_rates(k,161) )
         mat(k,26) = -( rxt(k,119) + het_rates(k,162) )
         mat(k,27) = -( rxt(k,120) + het_rates(k,163) )
         mat(k,28) = -( rxt(k,121) + het_rates(k,164) )
         mat(k,29) = -( rxt(k,122) + het_rates(k,165) )
         mat(k,30) = -( rxt(k,123) + het_rates(k,166) )
         mat(k,31) = -( rxt(k,124) + het_rates(k,167) )
         mat(k,32) = -( rxt(k,125) + het_rates(k,168) )
         mat(k,33) = -( rxt(k,126) + het_rates(k,169) )
         mat(k,34) = -( rxt(k,127) + het_rates(k,170) )
         mat(k,35) = -( rxt(k,128) + het_rates(k,171) )
         mat(k,36) = -( rxt(k,129) + het_rates(k,172) )
         mat(k,37) = -( rxt(k,130) + het_rates(k,173) )
         mat(k,38) = -( rxt(k,131) + het_rates(k,174) )
         mat(k,39) = -( rxt(k,132) + het_rates(k,175) )
         mat(k,40) = -( rxt(k,133) + het_rates(k,176) )
         mat(k,41) = -( rxt(k,134) + het_rates(k,177) )
         mat(k,42) = -( rxt(k,135) + het_rates(k,178) )
         mat(k,43) = -( rxt(k,136) + het_rates(k,179) )
         mat(k,44) = -( rxt(k,137) + het_rates(k,180) )
         mat(k,45) = -( rxt(k,138) + het_rates(k,181) )
         mat(k,46) = -( rxt(k,139) + het_rates(k,182) )
         mat(k,47) = -( rxt(k,140) + het_rates(k,183) )
         mat(k,48) = -( rxt(k,141) + het_rates(k,184) )
         mat(k,49) = -( rxt(k,142) + het_rates(k,185) )
         mat(k,50) = -( rxt(k,143) + het_rates(k,186) )
         mat(k,51) = -( het_rates(k,187) )
         mat(k,52) = -( het_rates(k,188) )
         mat(k,53) = -( het_rates(k,189) )
         mat(k,54) = -( het_rates(k,190) )
         mat(k,55) = -( het_rates(k,191) )
         mat(k,62) = -( het_rates(k,192) )
         mat(k,791) = rxt(k,500)
         mat(k,63) = -( het_rates(k,193) )
         mat(k,64) = -( het_rates(k,194) )
         mat(k,65) = -( het_rates(k,195) )
         mat(k,66) = -( het_rates(k,196) )
         mat(k,67) = -( het_rates(k,197) )
         mat(k,68) = -( het_rates(k,198) )
         mat(k,69) = -( het_rates(k,199) )
         mat(k,70) = -( het_rates(k,200) )
         mat(k,71) = -( het_rates(k,201) )
         mat(k,83) = -( het_rates(k,202) )
         mat(k,89) = -( het_rates(k,203) )
         mat(k,165) = -( rxt(k,64) + het_rates(k,204) )
         mat(k,527) = -( rxt(k,65) + het_rates(k,205) )
         mat(k,551) = -( rxt(k,66) + rxt(k,513) + het_rates(k,206) )
         mat(k,411) = -( rxt(k,67) + het_rates(k,207) )
         mat(k,881) = -( rxt(k,68) + het_rates(k,208) )
         mat(k,329) = rxt(k,58)
         mat(k,552) = rxt(k,66)
         mat(k,413) = rxt(k,67)
         mat(k,946) = -( rxt(k,69) + het_rates(k,209) )
         mat(k,530) = rxt(k,65)
         mat(k,882) = rxt(k,68)
         mat(k,538) = -( rxt(k,70) + het_rates(k,210) )
         mat(k,153) = -( het_rates(k,211) )
         mat(k,169) = -( rxt(k,71) + het_rates(k,212) )
         mat(k,178) = -( het_rates(k,213) )
         mat(k,607) = -( rxt(k,72) + het_rates(k,214) )
         mat(k,186) = -( het_rates(k,215) )
         mat(k,370) = -( rxt(k,73) + het_rates(k,216) )
         mat(k,453) = -( het_rates(k,219) )
         mat(k,107) = rxt(k,450)
         mat(k,853) = -( het_rates(k,220) )
         mat(k,420) = -( het_rates(k,221) )
         mat(k,378) = -( het_rates(k,222) )
         mat(k,739) = -( het_rates(k,223) )
         mat(k,449) = rxt(k,52)
         mat(k,710) = -( het_rates(k,224) )
         mat(k,559) = -( het_rates(k,225) )
      end do
      end subroutine linmat02
      subroutine linmat03( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,1280) = -( het_rates(k,226) )
         mat(k,338) = .130_r8*rxt(k,23)
         mat(k,258) = rxt(k,27)
         mat(k,865) = rxt(k,35)
         mat(k,1117) = rxt(k,36)
         mat(k,937) = .330_r8*rxt(k,45)
         mat(k,961) = rxt(k,47)
         mat(k,1108) = 1.340_r8*rxt(k,50)
         mat(k,450) = rxt(k,52)
         mat(k,287) = rxt(k,53)
         mat(k,1176) = .300_r8*rxt(k,55)
         mat(k,749) = rxt(k,57)
         mat(k,405) = .600_r8*rxt(k,60) + rxt(k,326)
         mat(k,318) = rxt(k,63)
         mat(k,167) = .500_r8*rxt(k,64)
         mat(k,949) = .650_r8*rxt(k,69)
         mat(k,1873) = -( het_rates(k,227) )
         mat(k,1047) = rxt(k,34)
         mat(k,867) = rxt(k,35)
         mat(k,439) = rxt(k,37)
         mat(k,1185) = .300_r8*rxt(k,55)
         mat(k,410) = .400_r8*rxt(k,60)
         mat(k,2047) = rxt(k,195)*y(k,54)
         mat(k,699) = rxt(k,251)*y(k,54)
         mat(k,1702) = rxt(k,284)*y(k,54)
         mat(k,1543) = rxt(k,291)*y(k,54)
         mat(k,665) = -( het_rates(k,228) )
         mat(k,229) = .600_r8*rxt(k,25)
         mat(k,495) = -( het_rates(k,229) )
         mat(k,224) = -( rxt(k,319) + rxt(k,320) + het_rates(k,230) )
         mat(k,113) = rxt(k,42)
         mat(k,620) = -( het_rates(k,231) )
         mat(k,1513) = -( rxt(k,501) + het_rates(k,232) )
         mat(k,359) = rxt(k,11) + rxt(k,192)
         mat(k,572) = rxt(k,19)
         mat(k,584) = .900_r8*rxt(k,20)
         mat(k,350) = rxt(k,21)
         mat(k,132) = 1.500_r8*rxt(k,22)
         mat(k,339) = .560_r8*rxt(k,23)
         mat(k,399) = rxt(k,24)
         mat(k,230) = .600_r8*rxt(k,25)
         mat(k,550) = .600_r8*rxt(k,26)
         mat(k,259) = rxt(k,27)
         mat(k,274) = rxt(k,28)
         mat(k,279) = rxt(k,29)
         mat(k,343) = rxt(k,30)
         mat(k,1044) = rxt(k,34)
         mat(k,1120) = rxt(k,36)
         mat(k,926) = 2.000_r8*rxt(k,43)
         mat(k,794) = 2.000_r8*rxt(k,44)
         mat(k,939) = .670_r8*rxt(k,45)
         mat(k,206) = rxt(k,46)
         mat(k,962) = rxt(k,47)
         mat(k,325) = rxt(k,48)
         mat(k,600) = rxt(k,49)
         mat(k,1110) = 1.340_r8*rxt(k,50) + .660_r8*rxt(k,51)
         mat(k,918) = rxt(k,56)
         mat(k,268) = rxt(k,61)
         mat(k,463) = rxt(k,62)
         mat(k,168) = rxt(k,64)
         mat(k,533) = rxt(k,65)
         mat(k,554) = rxt(k,66)
         mat(k,415) = rxt(k,67)
         mat(k,886) = rxt(k,68)
         mat(k,950) = 1.200_r8*rxt(k,69)
         mat(k,545) = rxt(k,70)
         mat(k,616) = rxt(k,72)
         mat(k,374) = rxt(k,73)
         mat(k,1322) = rxt(k,157)
         mat(k,387) = rxt(k,289)
         mat(k,226) = rxt(k,319) + rxt(k,320)
         mat(k,1236) = rxt(k,393)
         mat(k,2041) = rxt(k,259)*y(k,43) + rxt(k,262)*y(k,46)
         mat(k,1696) = rxt(k,260)*y(k,43) + rxt(k,263)*y(k,46)
         mat(k,1537) = rxt(k,292)*y(k,54)
         mat(k,384) = -( rxt(k,289) + het_rates(k,233) )
         mat(k,1152) = -( het_rates(k,234) )
         mat(k,1230) = -( rxt(k,393) + het_rates(k,235) )
         mat(k,1197) = -( het_rates(k,236) )
         mat(k,627) = -( het_rates(k,237) )
         mat(k,398) = .600_r8*rxt(k,24)
         mat(k,1249) = -( het_rates(k,238) )
         mat(k,1107) = .660_r8*rxt(k,50)
         mat(k,481) = rxt(k,54) + rxt(k,375)
         mat(k,782) = -( het_rates(k,239) )
         mat(k,548) = .600_r8*rxt(k,26)
         mat(k,588) = -( het_rates(k,240) )
         mat(k,1013) = -( het_rates(k,241) )
         mat(k,1538) = -( rxt(k,146) + rxt(k,147) + rxt(k,186)*y(k,114) &
                      + rxt(k,187)*y(k,114) + rxt(k,219)*y(k,33) + rxt(k,220)*y(k,34) &
                      + rxt(k,221)*y(k,36) + rxt(k,222)*y(k,37) + rxt(k,223)*y(k,38) &
                      + rxt(k,224)*y(k,39) + rxt(k,225)*y(k,40) + rxt(k,246)*y(k,35) &
                      + rxt(k,247)*y(k,55) + rxt(k,248)*y(k,78) + rxt(k,269)*y(k,41) &
                      + rxt(k,270)*y(k,43) + rxt(k,271)*y(k,82) + rxt(k,272)*y(k,83) &
                      + rxt(k,273)*y(k,84) + rxt(k,291)*y(k,54) + rxt(k,292)*y(k,54) &
                      + rxt(k,293)*y(k,54) + het_rates(k,242) )
         mat(k,2067) = rxt(k,1)
         mat(k,1928) = rxt(k,7)
         mat(k,1698) = -( rxt(k,258)*y(k,41) + rxt(k,260)*y(k,43) + rxt(k,261)*y(k,44) &
                      + rxt(k,263)*y(k,46) + rxt(k,265)*y(k,55) + rxt(k,266)*y(k,82) &
                      + rxt(k,267)*y(k,83) + rxt(k,268)*y(k,84) + rxt(k,284)*y(k,54) &
                 + het_rates(k,243) )
         mat(k,2068) = rxt(k,2)
         mat(k,523) = 2.000_r8*rxt(k,4)
         mat(k,1311) = rxt(k,9)
         mat(k,360) = rxt(k,10)
         mat(k,585) = rxt(k,20)
         mat(k,351) = rxt(k,21)
         mat(k,275) = rxt(k,28)
         mat(k,280) = rxt(k,29)
         mat(k,344) = rxt(k,30)
         mat(k,223) = rxt(k,31)
         mat(k,437) = rxt(k,37)
         mat(k,354) = rxt(k,38)
         mat(k,114) = rxt(k,42)
         mat(k,207) = rxt(k,46)
         mat(k,288) = rxt(k,53)
         mat(k,332) = rxt(k,58)
         mat(k,269) = rxt(k,61)
         mat(k,464) = rxt(k,62)
         mat(k,319) = rxt(k,63)
         mat(k,534) = rxt(k,65)
         mat(k,416) = rxt(k,67)
         mat(k,546) = rxt(k,70)
         mat(k,171) = rxt(k,71)
         mat(k,617) = rxt(k,72)
         mat(k,375) = rxt(k,73)
         mat(k,687) = rxt(k,105)
         mat(k,731) = rxt(k,106)
         mat(k,1762) = .500_r8*rxt(k,509)
         mat(k,1539) = rxt(k,291)*y(k,54)
         mat(k,391) = -( het_rates(k,244) )
         mat(k,674) = -( het_rates(k,245) )
         mat(k,1029) = -( het_rates(k,246) )
         mat(k,948) = .150_r8*rxt(k,69)
         mat(k,994) = -( het_rates(k,247) )
         mat(k,972) = -( het_rates(k,248) )
         mat(k,638) = -( het_rates(k,249) )
         mat(k,1068) = -( het_rates(k,250) )
         mat(k,654) = -( het_rates(k,251) )
         mat(k,428) = -( het_rates(k,252) )
         mat(k,2078) = -( rxt(k,1) + rxt(k,2) + rxt(k,3) + het_rates(k,253) )
         mat(k,117) = rxt(k,109)
         mat(k,1708) = rxt(k,258)*y(k,41) + rxt(k,260)*y(k,43) + rxt(k,261)*y(k,44) &
                      + rxt(k,263)*y(k,46) + rxt(k,268)*y(k,84) + rxt(k,284)*y(k,54)
      end do
      end subroutine linmat03
      subroutine linmat( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
      call linmat01( avec_len, mat, y, rxt, het_rates )
      call linmat02( avec_len, mat, y, rxt, het_rates )
      call linmat03( avec_len, mat, y, rxt, het_rates )
      end subroutine linmat
      end module mo_lin_matrix
