
      module mo_sim_dat

      private
      public :: set_sim_dat

      contains

      subroutine set_sim_dat

      use chem_mods,     only : clscnt, cls_rxt_cnt, clsmap, permute, adv_mass, fix_mass, crb_mass
      use chem_mods,     only : diag_map
      use chem_mods,     only : phtcnt, rxt_tag_cnt, rxt_tag_lst, rxt_tag_map
      use chem_mods,     only : pht_alias_lst, pht_alias_mult
      use chem_mods,     only : extfrc_lst, inv_lst, slvd_lst
      use chem_mods,     only : enthalpy_cnt, cph_enthalpy, cph_rid, num_rnts, rxntot
      use cam_abortutils,only : endrun
      use mo_tracname,   only : solsym
      use chem_mods,     only : frc_from_dataset
      use chem_mods,     only : is_scalar, is_vector
      use shr_kind_mod,  only : r8 => shr_kind_r8
      use cam_logfile,   only : iulog

      implicit none

!--------------------------------------------------------------
!      ... local variables
!--------------------------------------------------------------
      integer :: ios

      is_scalar = .false.
      is_vector = .true.

      clscnt(:) = (/     31,     0,     0,   286,     0 /)

      cls_rxt_cnt(:,1) = (/    133,    61,     0,    31 /)
      cls_rxt_cnt(:,4) = (/     23,   264,   613,   286 /)

      solsym(:317) = (/ 'ALKNIT          ','ALKOOH          ','AOA_NH          ','APIN            ','bc_a1           ', &
                        'bc_a4           ','BCARY           ','BENZENE         ','BENZOOH         ','BEPOMUC         ', &
                        'BIGALD1         ','BIGALD2         ','BIGALD3         ','BIGALD4         ','BIGALK          ', &
                        'BIGENE          ','BPIN            ','BR              ','BRCL            ','BRO             ', &
                        'BRONO2          ','BRY             ','BZALD           ','BZOOH           ','C2H2            ', &
                        'C2H4            ','C2H5OH          ','C2H5OOH         ','C2H6            ','C3H6            ', &
                        'C3H7OOH         ','C3H8            ','C6H5OOH         ','CCL4            ','CF2CLBR         ', &
                        'CF3BR           ','CFC11           ','CFC113          ','CFC114          ','CFC115          ', &
                        'CFC12           ','CH2BR2          ','CH2O            ','CH3BR           ','CH3CCL3         ', &
                        'CH3CHO          ','CH3CL           ','CH3CN           ','CH3COCH3        ','CH3COCHO        ', &
                        'CH3COOH         ','CH3COOOH        ','CH3OH           ','CH3OOH          ','CH4             ', &
                        'CHBR3           ','CL              ','CL2             ','CL2O2           ','CLO             ', &
                        'CLONO2          ','CLY             ','CO              ','CO2             ','COF2            ', &
                        'COFCL           ','CRESOL          ','DHPMPAL         ','DMS             ','dst_a1          ', &
                        'dst_a2          ','dst_a3          ','E90             ','EOOH            ','F               ', &
                        'GLYALD          ','GLYOXAL         ','H               ','H2              ','H2402           ', &
                        'H2O2            ','H2SO4           ','HBR             ','HCFC141B        ','HCFC142B        ', &
                        'HCFC22          ','HCL             ','HCN             ','HCOCH2OOH       ','HCOOH           ', &
                        'HF              ','HMHP            ','HNO3            ','HO2NO2          ','HOBR            ', &
                        'HOCL            ','HONITR          ','HPALD1          ','HPALD4          ','HPALDB1C        ', &
                        'HPALDB4C        ','HYAC            ','HYDRALD         ','HYPERACET       ','ICHE            ', &
                        'IEPOX           ','INHEB           ','INHED           ','ISOP            ','ISOPFDN         ', &
                        'ISOPFDNC        ','ISOPFNC         ','ISOPFNP         ','ISOPHFP         ','ISOPN1D         ', &
                        'ISOPN2B         ','ISOPN3B         ','ISOPN4D         ','ISOPNBNO3       ','ISOPNOOHB       ', &
                        'ISOPNOOHD       ','ISOPOH          ','ISOPOOH         ','IVOC            ','LIMON           ', &
                        'MACR            ','MACRN           ','MACROOH         ','MEK             ','MEKOOH          ', &
                        'MPAN            ','MVK             ','MVKN            ','MVKOOH          ','MYRC            ', &
                        'N               ','N2O             ','N2O5            ','NC4CHO          ','ncl_a1          ', &
                        'ncl_a2          ','ncl_a3          ','NH3             ','NH4             ','NH_5            ', &
                        'NH_50           ','NO              ','NO2             ','NO3             ','NO3CH2CHO       ', &
                        'NOA             ','num_a1          ','num_a2          ','num_a3          ','num_a4          ', &
                        'O               ','O3              ','O3S             ','OCLO            ','OCS             ', &
                        'ONITR           ','PAN             ','PBZNIT          ','PHENO           ','PHENOL          ', &
                        'PHENOOH         ','pom_a1          ','pom_a4          ','POOH            ','ROOH            ', &
                        'S               ','SF6             ','SO              ','SO2             ','SO3             ', &
                        'so4_a1          ','so4_a2          ','so4_a3          ','soa1_a1         ','soa1_a2         ', &
                        'soa2_a1         ','soa2_a2         ','soa3_a1         ','soa3_a2         ','soa4_a1         ', &
                        'soa4_a2         ','soa5_a1         ','soa5_a2         ','SOAG0           ','SOAG1           ', &
                        'SOAG2           ','SOAG3           ','SOAG4           ','SQTN            ','ST80_25         ', &
                        'SVOC            ','TEPOMUC         ','TERP1OOH        ','TERP2AOOH       ','TERPA           ', &
                        'TERPA2          ','TERPA2PAN       ','TERPA3          ','TERPA3PAN       ','TERPACID        ', &
                        'TERPACID2       ','TERPACID3       ','TERPAPAN        ','TERPDHDP        ','TERPF1          ', &
                        'TERPF2          ','TERPFDN         ','TERPHFN         ','TERPK           ','TERPNPS         ', &
                        'TERPNPS1        ','TERPNPT         ','TERPNPT1        ','TERPNS          ','TERPNS1         ', &
                        'TERPNT          ','TERPNT1         ','TERPOOH         ','TERPOOHL        ','TOLOOH          ', &
                        'TOLUENE         ','XYLENES         ','XYLENOOH        ','XYLOL           ','XYLOLOOH        ', &
                        'NHDEP           ','NDEP            ','ACBZO2          ','ALKO2           ','APINNO3         ', &
                        'APINO2          ','APINO2VBS       ','BCARYNO3        ','BCARYO2         ','BCARYO2VBS      ', &
                        'BENZO2          ','BENZO2VBS       ','BPINNO3         ','BPINO2          ','BPINO2VBS       ', &
                        'BZOO            ','C2H5O2          ','C3H7O2          ','C6H5O2          ','CH3CO3          ', &
                        'CH3O2           ','DICARBO2        ','ENEO2           ','EO              ','EO2             ', &
                        'HO2             ','HOCH2OO         ','IEPOXOO         ','ISOPB1O2        ','ISOPB4O2        ', &
                        'ISOPC1C         ','ISOPC1T         ','ISOPC4C         ','ISOPC4T         ','ISOPED1O2       ', &
                        'ISOPED4O2       ','ISOPN1DO2       ','ISOPN2BO2       ','ISOPN3BO2       ','ISOPN4DO2       ', &
                        'ISOPNBNO3O2     ','ISOPNO3         ','ISOPNOOHBO2     ','ISOPNOOHDO2     ','ISOPO2VBS       ', &
                        'ISOPZD1O2       ','ISOPZD4O2       ','IVOCO2VBS       ','LIMONNO3        ','LIMONO2         ', &
                        'LIMONO2VBS      ','MACRO2          ','MALO2           ','MCO3            ','MDIALO2         ', &
                        'MEKO2           ','MVKO2           ','MYRCNO3         ','MYRCO2          ','MYRCO2VBS       ', &
                        'NC4CHOO2        ','O1D             ','OH              ','PHENO2          ','PO2             ', &
                        'RO2             ','TERP1OOHO2      ','TERP2OOHO2      ','TERPA1O2        ','TERPA2CO3       ', &
                        'TERPA2O2        ','TERPA3CO3       ','TERPA3O2        ','TERPA4O2        ','TERPACO3        ', &
                        'TERPF1O2        ','TERPF2O2        ','TERPNPS1O2      ','TERPNPT1O2      ','TERPNS1O2       ', &
                        'TERPNT1O2       ','TOLO2           ','TOLUO2VBS       ','XYLENO2         ','XYLEO2VBS       ', &
                        'XYLOLO2         ','H2O             ' /)

      adv_mass(:317) = (/   133.141340_r8,   104.142600_r8,    28.010400_r8,   136.228400_r8,    12.011000_r8, &
                             12.011000_r8,   204.342600_r8,    78.110400_r8,   160.122200_r8,   126.108600_r8, &
                             84.072400_r8,    98.098200_r8,    98.098200_r8,   112.124000_r8,    72.143800_r8, &
                             56.103200_r8,   136.228400_r8,    79.904000_r8,   115.356700_r8,    95.903400_r8, &
                            141.908940_r8,    99.716850_r8,   106.120800_r8,   124.135000_r8,    26.036800_r8, &
                             28.051600_r8,    46.065800_r8,    62.065200_r8,    30.066400_r8,    42.077400_r8, &
                             76.091000_r8,    44.092200_r8,   110.109200_r8,   153.821800_r8,   165.364506_r8, &
                            148.910210_r8,   137.367503_r8,   187.375310_r8,   170.921013_r8,   154.466716_r8, &
                            120.913206_r8,   173.833800_r8,    30.025200_r8,    94.937200_r8,   133.402300_r8, &
                             44.051000_r8,    50.485900_r8,    41.050940_r8,    58.076800_r8,    72.061400_r8, &
                             60.050400_r8,    76.049800_r8,    32.040000_r8,    48.039400_r8,    16.040600_r8, &
                            252.730400_r8,    35.452700_r8,    70.905400_r8,   102.904200_r8,    51.452100_r8, &
                             97.457640_r8,   100.916850_r8,    28.010400_r8,    44.009800_r8,    66.007206_r8, &
                             82.461503_r8,   108.135600_r8,   136.100200_r8,    62.132400_r8,   135.064039_r8, &
                            135.064039_r8,   135.064039_r8,    28.010400_r8,    78.064600_r8,    18.998403_r8, &
                             60.050400_r8,    58.035600_r8,     1.007400_r8,     2.014800_r8,   259.823613_r8, &
                             34.013600_r8,    98.078400_r8,    80.911400_r8,   116.948003_r8,   100.493706_r8, &
                             86.467906_r8,    36.460100_r8,    27.025140_r8,    76.049800_r8,    46.024600_r8, &
                             20.005803_r8,    64.038800_r8,    63.012340_r8,    79.011740_r8,    96.910800_r8, &
                             52.459500_r8,   135.114940_r8,   116.112400_r8,   116.112400_r8,   116.112400_r8, &
                            116.112400_r8,    74.076200_r8,   100.113000_r8,    90.075600_r8,   116.112400_r8, &
                            118.127200_r8,   163.125340_r8,   163.125340_r8,    68.114200_r8,   226.137680_r8, &
                            224.122880_r8,   195.124140_r8,   197.138940_r8,   150.126000_r8,   147.125940_r8, &
                            147.125940_r8,   147.125940_r8,   147.125940_r8,   147.125940_r8,   163.125340_r8, &
                            163.125340_r8,   102.127800_r8,   118.127200_r8,   184.350200_r8,   136.228400_r8, &
                             70.087800_r8,   149.099540_r8,   120.100800_r8,    72.102600_r8,   104.101400_r8, &
                            147.084740_r8,    70.087800_r8,   149.099540_r8,   120.100800_r8,   136.228400_r8, &
                             14.006740_r8,    44.012880_r8,   108.010480_r8,   145.111140_r8,    58.442468_r8, &
                             58.442468_r8,    58.442468_r8,    17.028940_r8,    18.036340_r8,    28.010400_r8, &
                             28.010400_r8,    30.006140_r8,    46.005540_r8,    62.004940_r8,   105.048540_r8, &
                            119.074340_r8,     1.007400_r8,     1.007400_r8,     1.007400_r8,     1.007400_r8, &
                             15.999400_r8,    47.998200_r8,    47.998200_r8,    67.451500_r8,    60.076400_r8, &
                            133.100140_r8,   121.047940_r8,   183.117740_r8,    93.102400_r8,    94.109800_r8, &
                            176.121600_r8,    12.011000_r8,    12.011000_r8,    92.090400_r8,    90.075600_r8, &
                             32.066000_r8,   146.056419_r8,    48.065400_r8,    64.064800_r8,    80.064200_r8, &
                            115.107340_r8,   115.107340_r8,   115.107340_r8,   250.445000_r8,   250.445000_r8, &
                            250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8, &
                            250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8, &
                            250.445000_r8,   250.445000_r8,   250.445000_r8,   283.354340_r8,    28.010400_r8, &
                            310.582400_r8,   140.134400_r8,   186.241400_r8,   186.241400_r8,   168.227200_r8, &
                            154.201400_r8,   231.198340_r8,   170.200800_r8,   247.197740_r8,   200.226000_r8, &
                            186.200200_r8,   202.199600_r8,   245.224140_r8,   236.254400_r8,   168.227200_r8, &
                            110.150400_r8,   294.251880_r8,   265.253140_r8,   138.202000_r8,   231.239540_r8, &
                            231.239540_r8,   231.239540_r8,   231.239540_r8,   215.240140_r8,   215.240140_r8, &
                            215.240140_r8,   215.240140_r8,   186.241400_r8,   218.240200_r8,   174.148000_r8, &
                             92.136200_r8,   106.162000_r8,   188.173800_r8,   122.161400_r8,   204.173200_r8, &
                             14.006740_r8,    14.006740_r8,   137.112200_r8,   103.135200_r8,   230.232140_r8, &
                            185.234000_r8,   185.234000_r8,   298.346340_r8,   253.348200_r8,   253.348200_r8, &
                            159.114800_r8,   159.114800_r8,   230.232140_r8,   185.234000_r8,   185.234000_r8, &
                            123.127600_r8,    61.057800_r8,    75.083600_r8,   109.101800_r8,    75.042400_r8, &
                             47.032000_r8,   129.089600_r8,   105.108800_r8,    61.057800_r8,    77.057200_r8, &
                             33.006200_r8,    63.031400_r8,   149.118600_r8,   117.119800_r8,   117.119800_r8, &
                             85.121000_r8,    85.121000_r8,    85.121000_r8,    85.121000_r8,   117.119800_r8, &
                            117.119800_r8,   196.131540_r8,   196.131540_r8,   196.131540_r8,   196.131540_r8, &
                            196.131540_r8,   162.117940_r8,   212.130940_r8,   212.130940_r8,   117.119800_r8, &
                            117.119800_r8,   117.119800_r8,   233.355800_r8,   230.232140_r8,   185.234000_r8, &
                            185.234000_r8,   119.093400_r8,   115.063800_r8,   101.079200_r8,   117.078600_r8, &
                            103.094000_r8,   119.093400_r8,   230.232140_r8,   185.234000_r8,   185.234000_r8, &
                            194.116740_r8,    15.999400_r8,    17.006800_r8,   175.114200_r8,    91.083000_r8, &
                             89.068200_r8,   235.247000_r8,   235.247000_r8,   171.208200_r8,   185.192800_r8, &
                            187.207600_r8,   201.192200_r8,   203.207000_r8,   161.129600_r8,   199.218600_r8, &
                            217.232800_r8,   159.156000_r8,   280.245140_r8,   280.245140_r8,   264.245740_r8, &
                            264.245740_r8,   173.140600_r8,   173.140600_r8,   187.166400_r8,   187.166400_r8, &
                            203.165800_r8,    18.014200_r8 /)

      crb_mass(:317) = (/    60.055000_r8,    60.055000_r8,    12.011000_r8,   120.110000_r8,    12.011000_r8, &
                             12.011000_r8,   180.165000_r8,    72.066000_r8,    72.066000_r8,    72.066000_r8, &
                             48.044000_r8,    60.055000_r8,    60.055000_r8,    72.066000_r8,    60.055000_r8, &
                             48.044000_r8,   120.110000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    84.077000_r8,    84.077000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    72.066000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    24.022000_r8, &
                             24.022000_r8,    12.011000_r8,    24.022000_r8,    36.033000_r8,    36.033000_r8, &
                             24.022000_r8,    24.022000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    84.077000_r8,    48.044000_r8,    24.022000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    12.011000_r8,    24.022000_r8,     0.000000_r8, &
                             24.022000_r8,    24.022000_r8,     0.000000_r8,     0.000000_r8,    24.022000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,    24.022000_r8,    24.022000_r8, &
                             12.011000_r8,     0.000000_r8,    12.011000_r8,    24.022000_r8,    12.011000_r8, &
                              0.000000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    48.044000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    36.033000_r8,    60.055000_r8,    36.033000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,   156.143000_r8,   120.110000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,   120.110000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,    60.055000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    24.022000_r8, &
                             36.033000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                             48.044000_r8,    24.022000_r8,    84.077000_r8,    72.066000_r8,    72.066000_r8, &
                             72.066000_r8,    12.011000_r8,    12.011000_r8,    36.033000_r8,    36.033000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,   180.165000_r8,   180.165000_r8, &
                            180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8, &
                            180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8, &
                            180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8,    12.011000_r8, &
                            264.242000_r8,    84.077000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                            108.099000_r8,   108.099000_r8,   108.099000_r8,   108.099000_r8,   120.110000_r8, &
                            108.099000_r8,   108.099000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                             84.077000_r8,   120.110000_r8,   120.110000_r8,   108.099000_r8,   120.110000_r8, &
                            120.110000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                            120.110000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8,    84.077000_r8, &
                             84.077000_r8,    96.088000_r8,    96.088000_r8,    96.088000_r8,    96.088000_r8, &
                              0.000000_r8,     0.000000_r8,    84.077000_r8,    60.055000_r8,   120.110000_r8, &
                            120.110000_r8,   120.110000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8, &
                             72.066000_r8,    72.066000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                             84.077000_r8,    24.022000_r8,    36.033000_r8,    72.066000_r8,    24.022000_r8, &
                             12.011000_r8,    60.055000_r8,    48.044000_r8,    24.022000_r8,    24.022000_r8, &
                              0.000000_r8,    12.011000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,   156.143000_r8,   120.110000_r8,   120.110000_r8, &
                            120.110000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                             60.055000_r8,     0.000000_r8,     0.000000_r8,    72.066000_r8,    36.033000_r8, &
                             36.033000_r8,   120.110000_r8,   120.110000_r8,   108.099000_r8,   108.099000_r8, &
                            108.099000_r8,   108.099000_r8,   108.099000_r8,    72.066000_r8,   120.110000_r8, &
                            120.110000_r8,    84.077000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                            120.110000_r8,    84.077000_r8,    84.077000_r8,    96.088000_r8,    96.088000_r8, &
                             96.088000_r8,     0.000000_r8 /)

      fix_mass(:  3) = (/ 0.00000000_r8, 31.9988000_r8, 28.0134800_r8 /)

      clsmap(: 31,1) = (/    3,  22,  34,  35,  36,  37,  38,  39,  40,  41, &
                            42,  44,  45,  47,  55,  56,  62,  64,  73,  80, &
                            84,  85,  86, 137, 145, 146, 158, 172, 195, 231, &
                           232 /)
      clsmap(:286,4) = (/    1,   2,   4,   5,   6,   7,   8,   9,  10,  11, &
                            12,  13,  14,  15,  16,  17,  18,  19,  20,  21, &
                            23,  24,  25,  26,  27,  28,  29,  30,  31,  32, &
                            33,  43,  46,  48,  49,  50,  51,  52,  53,  54, &
                            57,  58,  59,  60,  61,  63,  65,  66,  67,  68, &
                            69,  70,  71,  72,  74,  75,  76,  77,  78,  79, &
                            81,  82,  83,  87,  88,  89,  90,  91,  92,  93, &
                            94,  95,  96,  97,  98,  99, 100, 101, 102, 103, &
                           104, 105, 106, 107, 108, 109, 110, 111, 112, 113, &
                           114, 115, 116, 117, 118, 119, 120, 121, 122, 123, &
                           124, 125, 126, 127, 128, 129, 130, 131, 132, 133, &
                           134, 135, 136, 138, 139, 140, 141, 142, 143, 144, &
                           147, 148, 149, 150, 151, 152, 153, 154, 155, 156, &
                           157, 159, 160, 161, 162, 163, 164, 165, 166, 167, &
                           168, 169, 170, 171, 173, 174, 175, 176, 177, 178, &
                           179, 180, 181, 182, 183, 184, 185, 186, 187, 188, &
                           189, 190, 191, 192, 193, 194, 196, 197, 198, 199, &
                           200, 201, 202, 203, 204, 205, 206, 207, 208, 209, &
                           210, 211, 212, 213, 214, 215, 216, 217, 218, 219, &
                           220, 221, 222, 223, 224, 225, 226, 227, 228, 229, &
                           230, 233, 234, 235, 236, 237, 238, 239, 240, 241, &
                           242, 243, 244, 245, 246, 247, 248, 249, 250, 251, &
                           252, 253, 254, 255, 256, 257, 258, 259, 260, 261, &
                           262, 263, 264, 265, 266, 267, 268, 269, 270, 271, &
                           272, 273, 274, 275, 276, 277, 278, 279, 280, 281, &
                           282, 283, 284, 285, 286, 287, 288, 289, 290, 291, &
                           292, 293, 294, 295, 296, 297, 298, 299, 300, 301, &
                           302, 303, 304, 305, 306, 307, 308, 309, 310, 311, &
                           312, 313, 314, 315, 316, 317 /)

      permute(:286,4) = (/  140, 141, 185,   1,   2, 163,  56,  96,  57, 106, &
                             83,  97,  87,  61,  94, 171, 233,  69, 284, 122, &
                             70,  90,  84, 123,  76,  91,  85, 195,  99,  50, &
                             77, 278, 203,  48, 251, 240, 128, 119, 209, 104, &
                            285,  55,  49, 277, 196, 223,  53,  62,  64, 132, &
                             81,   3,   4,   5,  51, 167, 218, 193, 271, 215, &
                            208,  52, 180, 283,  59, 149, 187,  68, 186, 270, &
                            103, 168, 182, 165, 130, 131, 112, 113, 228, 234, &
                            158, 198, 157, 111, 184, 202, 222, 178, 230, 206, &
                            143, 243, 133, 120, 244, 139, 181, 216, 156, 242, &
                             42, 172, 236, 229, 205, 116,  86, 108, 241, 238, &
                            210, 148,  95,  82, 245,   6,   7,   8,  47,   9, &
                            272, 281, 274, 201, 207,  10,  11,  12,  13, 280, &
                            273,  88,  93,  60, 109,  54, 110,  58,  89,  14, &
                             15, 121,  98, 117, 221, 191,  75,  16,  17,  18, &
                             19,  20,  21,  22,  23,  24,  25,  26,  27,  28, &
                             29,  30,  31,  32,  33,  34,  35,  65, 253, 107, &
                            254, 192, 124, 231, 125, 126,  78,  79, 100,  92, &
                            262, 261, 190, 164, 175, 166, 134, 179, 144, 217, &
                            226, 213, 227, 135, 127, 138,  63,  66, 150,  67, &
                            101, 118, 188, 250, 255,  36, 247, 249,  37, 114, &
                             38, 259, 256,  39, 102, 199, 173, 137, 269, 279, &
                            155, 129,  80, 151, 276, 136, 214, 239, 235,  71, &
                             72,  73,  74, 224, 225, 176, 183, 174, 177, 204, &
                            246, 194, 200,  40, 237, 232,  41, 258, 252,  43, &
                            212, 152, 220, 159, 142, 211, 260, 257,  44, 219, &
                            275, 282, 105, 160, 197, 161, 169, 263, 266, 265, &
                            267, 248, 264, 268, 145, 162, 189, 170, 146, 147, &
                            153,  45, 154,  46, 115, 286 /)

      diag_map(:286) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                            11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                            21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                            31,  32,  33,  34,  40,  46,  52,  58,  64,  70, &
                            76,  78,  84,  90,  96, 102, 103, 106, 109, 112, &
                           116, 119, 122, 125, 128, 131, 137, 141, 146, 150, &
                           153, 156, 161, 168, 173, 179, 187, 192, 195, 198, &
                           201, 204, 207, 210, 214, 218, 222, 226, 230, 234, &
                           238, 244, 250, 253, 259, 265, 270, 275, 280, 286, &
                           291, 296, 300, 308, 316, 322, 328, 332, 338, 344, &
                           350, 358, 364, 370, 377, 383, 386, 391, 398, 405, &
                           409, 419, 426, 435, 443, 450, 455, 462, 468, 474, &
                           482, 490, 498, 506, 514, 522, 526, 530, 534, 542, &
                           554, 566, 573, 582, 589, 593, 604, 613, 623, 634, &
                           645, 656, 663, 671, 680, 688, 696, 710, 721, 731, &
                           744, 751, 762, 778, 789, 797, 802, 807, 812, 822, &
                           834, 843, 859, 871, 876, 888, 897, 906, 917, 926, &
                           941, 961, 975, 985, 995, 999,1010,1021,1032,1039, &
                          1048,1064,1071,1083,1102,1118,1124,1132,1144,1154, &
                          1161,1167,1176,1180,1197,1213,1224,1236,1243,1255, &
                          1270,1285,1305,1315,1329,1336,1343,1349,1356,1360, &
                          1370,1383,1396,1404,1416,1439,1463,1469,1480,1497, &
                          1513,1529,1540,1550,1571,1590,1603,1611,1620,1635, &
                          1645,1667,1685,1700,1729,1751,1780,1801,1829,1845, &
                          1863,1896,1930,1964,1993,2034,2053,2072,2096,2119, &
                          2141,2156,2179,2193,2214,2243,2271,2303,2332,2364, &
                          2392,2420,2445,2467,2489,2532,2579,2627,2699,2717, &
                          2730,2885,2987,3080,3105,3285,3312,3337,3429,3460, &
                          3511,3752,3775,3800,3836,3862 /)

      extfrc_lst(: 17) = (/ 'so4_a2          ','NO              ','NO2             ','SO2             ','SVOC            ', &
                            'pom_a1          ','pom_a4          ','so4_a1          ','CO              ','bc_a1           ', &
                            'bc_a4           ','num_a1          ','num_a2          ','num_a4          ','OH              ', &
                            'N               ','AOA_NH          ' /)

      frc_from_dataset(: 17) = (/ .true., .true., .true., .true., .true., &
                                  .true., .true., .true., .true., .true., &
                                  .true., .true., .true., .true., .false., &
                                  .false., .false. /)

      inv_lst(:  3) = (/ 'M               ', 'O2              ', 'N2              ' /)

      slvd_lst(: 84) = (/ 'ACBZO2          ', 'ALKO2           ', 'APINNO3         ', 'APINO2          ', 'APINO2VBS       ', &
                          'BCARYNO3        ', 'BCARYO2         ', 'BCARYO2VBS      ', 'BENZO2          ', 'BENZO2VBS       ', &
                          'BPINNO3         ', 'BPINO2          ', 'BPINO2VBS       ', 'BZOO            ', 'C2H5O2          ', &
                          'C3H7O2          ', 'C6H5O2          ', 'CH3CO3          ', 'CH3O2           ', 'DICARBO2        ', &
                          'ENEO2           ', 'EO              ', 'EO2             ', 'HO2             ', 'HOCH2OO         ', &
                          'IEPOXOO         ', 'ISOPB1O2        ', 'ISOPB4O2        ', 'ISOPC1C         ', 'ISOPC1T         ', &
                          'ISOPC4C         ', 'ISOPC4T         ', 'ISOPED1O2       ', 'ISOPED4O2       ', 'ISOPN1DO2       ', &
                          'ISOPN2BO2       ', 'ISOPN3BO2       ', 'ISOPN4DO2       ', 'ISOPNBNO3O2     ', 'ISOPNO3         ', &
                          'ISOPNOOHBO2     ', 'ISOPNOOHDO2     ', 'ISOPO2VBS       ', 'ISOPZD1O2       ', 'ISOPZD4O2       ', &
                          'IVOCO2VBS       ', 'LIMONNO3        ', 'LIMONO2         ', 'LIMONO2VBS      ', 'MACRO2          ', &
                          'MALO2           ', 'MCO3            ', 'MDIALO2         ', 'MEKO2           ', 'MVKO2           ', &
                          'MYRCNO3         ', 'MYRCO2          ', 'MYRCO2VBS       ', 'NC4CHOO2        ', 'O1D             ', &
                          'OH              ', 'PHENO2          ', 'PO2             ', 'RO2             ', 'TERP1OOHO2      ', &
                          'TERP2OOHO2      ', 'TERPA1O2        ', 'TERPA2CO3       ', 'TERPA2O2        ', 'TERPA3CO3       ', &
                          'TERPA3O2        ', 'TERPA4O2        ', 'TERPACO3        ', 'TERPF1O2        ', 'TERPF2O2        ', &
                          'TERPNPS1O2      ', 'TERPNPT1O2      ', 'TERPNS1O2       ', 'TERPNT1O2       ', 'TOLO2           ', &
                          'TOLUO2VBS       ', 'XYLENO2         ', 'XYLEO2VBS       ', 'XYLOLO2         ' /)

      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(     1:   200) = (/ 'jh2o_b                          ', 'jh2o_a                          ', &
                                      'jh2o_c                          ', 'jh2o2                           ', &
                                      'jo2_a                           ', 'jo2_b                           ', &
                                      'jo3_a                           ', 'jo3_b                           ', &
                                      'jhno3                           ', 'jho2no2_a                       ', &
                                      'jho2no2_b                       ', 'jn2o                            ', &
                                      'jn2o5_a                         ', 'jn2o5_b                         ', &
                                      'jno                             ', 'jno2                            ', &
                                      'jno3_b                          ', 'jno3_a                          ', &
                                      'jalknit                         ', 'jalkooh                         ', &
                                      'jbenzooh                        ', 'jbepomuc                        ', &
                                      'jbigald1                        ', 'jbigald2                        ', &
                                      'jbigald3                        ', 'jbigald4                        ', &
                                      'jbzooh                          ', 'jc2h5ooh                        ', &
                                      'jc3h7ooh                        ', 'jc6h5ooh                        ', &
                                      'jch2o_a                         ', 'jch2o_b                         ', &
                                      'jch3cho                         ', 'jacet                           ', &
                                      'jmgly                           ', 'jch3co3h                        ', &
                                      'jch3ooh                         ', 'jch4_a                          ', &
                                      'jch4_b                          ', 'jco2                            ', &
                                      'jdhpmpal                        ', 'jeooh                           ', &
                                      'jglyald                         ', 'jglyoxal                        ', &
                                      'jhcoch2ooh                      ', 'jhmhp                           ', &
                                      'jhonitr                         ', 'jhpald1                         ', &
                                      'jhpald4                         ', 'jhpaldb1c                       ', &
                                      'jhpaldb4c                       ', 'jhyac                           ', &
                                      'jhydrald_b                      ', 'jhydrald_a                      ', &
                                      'jhyperacet_c                    ', 'jhyperacet_p                    ', &
                                      'jinheb                          ', 'jinhed                          ', &
                                      'jisopfdn                        ', 'jisopfdnc                       ', &
                                      'jisopfnc                        ', 'jisopfnp                        ', &
                                      'jisophfp                        ', 'jisopn1d                        ', &
                                      'jisopn2b                        ', 'jisopn3b                        ', &
                                      'jisopn4d                        ', 'jisopnbno3                      ', &
                                      'jisopnoohb                      ', 'jisopnoohd                      ', &
                                      'jisopooh                        ', 'jmacr_b                         ', &
                                      'jmacr_a                         ', 'jmacrn                          ', &
                                      'jmacrooh                        ', 'jmek                            ', &
                                      'jmekooh                         ', 'jmpan                           ', &
                                      'jmvk                            ', 'jmvkn                           ', &
                                      'jmvkooh                         ', 'jnc4cho                         ', &
                                      'jno3ch2cho                      ', 'jnoa                            ', &
                                      'jonitr                          ', 'jpan                            ', &
                                      'jphenooh                        ', 'jpooh                           ', &
                                      'jrooh                           ', 'jtepomuc                        ', &
                                      'jterp1ooh                       ', 'jterp2aooh                      ', &
                                      'jterpa                          ', 'jterpa2                         ', &
                                      'jterpa2pan                      ', 'jterpa3                         ', &
                                      'jterpa3pan                      ', 'jterpacid                       ', &
                                      'jterpacid2                      ', 'jterpacid3                      ', &
                                      'jterpapan                       ', 'jterpdhdp                       ', &
                                      'jterpfdn                        ', 'jterphfn                        ', &
                                      'jterpnps                        ', 'jterpnps1                       ', &
                                      'jterpnpt                        ', 'jterpnpt1                       ', &
                                      'jterpns                         ', 'jterpns1                        ', &
                                      'jterpnt                         ', 'jterpnt1                        ', &
                                      'jterpooh                        ', 'jterpoohl                       ', &
                                      'jtolooh                         ', 'jxylenooh                       ', &
                                      'jxylolooh                       ', 'jbrcl                           ', &
                                      'jbro                            ', 'jbrono2_b                       ', &
                                      'jbrono2_a                       ', 'jccl4                           ', &
                                      'jcf2clbr                        ', 'jcf3br                          ', &
                                      'jcfcl3                          ', 'jcfc113                         ', &
                                      'jcfc114                         ', 'jcfc115                         ', &
                                      'jcf2cl2                         ', 'jch2br2                         ', &
                                      'jch3br                          ', 'jch3ccl3                        ', &
                                      'jch3cl                          ', 'jchbr3                          ', &
                                      'jcl2                            ', 'jcl2o2                          ', &
                                      'jclo                            ', 'jclono2_a                       ', &
                                      'jclono2_b                       ', 'jcof2                           ', &
                                      'jcofcl                          ', 'jh2402                          ', &
                                      'jhbr                            ', 'jhcfc141b                       ', &
                                      'jhcfc142b                       ', 'jhcfc22                         ', &
                                      'jhcl                            ', 'jhf                             ', &
                                      'jhobr                           ', 'jhocl                           ', &
                                      'joclo                           ', 'jsf6                            ', &
                                      'jh2so4                          ', 'jocs                            ', &
                                      'jso                             ', 'jso2                            ', &
                                      'jso3                            ', 'jsoa1_a1                        ', &
                                      'jsoa1_a2                        ', 'jsoa2_a1                        ', &
                                      'jsoa2_a2                        ', 'jsoa3_a1                        ', &
                                      'jsoa3_a2                        ', 'jsoa4_a1                        ', &
                                      'jsoa4_a2                        ', 'jsoa5_a1                        ', &
                                      'jsoa5_a2                        ', 'O1D_H2                          ', &
                                      'O1D_H2O                         ', 'O1D_N2                          ', &
                                      'O1D_O2ab                        ', 'O1D_O3                          ', &
                                      'O_O3                            ', 'usr_O_O                         ', &
                                      'usr_O_O2                        ', 'H2_O                            ', &
                                      'H2O2_O                          ', 'H_HO2                           ', &
                                      'H_HO2a                          ', 'H_HO2b                          ', &
                                      'H_O2                            ', 'HO2_O                           ', &
                                      'HO2_O3                          ', 'H_O3                            ', &
                                      'OH_H2                           ', 'OH_H2O2                         ', &
                                      'OH_HO2                          ', 'OH_O                            ', &
                                      'OH_O3                           ', 'OH_OH                           ', &
                                      'OH_OH_M                         ', 'usr_HO2_HO2                     ', &
                                      'HO2NO2_OH                       ', 'N_NO                            ', &
                                      'N_NO2a                          ', 'N_NO2b                          ', &
                                      'N_NO2c                          ', 'N_O2                            ', &
                                      'NO2_O                           ', 'NO2_O3                          ' /)
      rxt_tag_lst(   201:   400) = (/ 'NO2_O_M                         ', 'NO3_HO2                         ', &
                                      'NO3_NO                          ', 'NO3_O                           ', &
                                      'NO3_OH                          ', 'N_OH                            ', &
                                      'NO_HO2                          ', 'NO_O3                           ', &
                                      'NO_O_M                          ', 'O1D_N2Oa                        ', &
                                      'O1D_N2Ob                        ', 'tag_NO2_HO2                     ', &
                                      'tag_NO2_NO3                     ', 'tag_NO2_OH                      ', &
                                      'usr_HNO3_OH                     ', 'usr_HO2NO2_M                    ', &
                                      'usr_N2O5_M                      ', 'CL_CH2O                         ', &
                                      'CL_CH4                          ', 'CL_H2                           ', &
                                      'CL_H2O2                         ', 'CL_HO2a                         ', &
                                      'CL_HO2b                         ', 'CL_O3                           ', &
                                      'CLO_CH3O2                       ', 'CLO_CLOa                        ', &
                                      'CLO_CLOb                        ', 'CLO_CLOc                        ', &
                                      'CLO_HO2                         ', 'CLO_NO                          ', &
                                      'CLONO2_CL                       ', 'CLO_NO2_M                       ', &
                                      'CLONO2_O                        ', 'CLONO2_OH                       ', &
                                      'CLO_O                           ', 'CLO_OHa                         ', &
                                      'CLO_OHb                         ', 'HCL_O                           ', &
                                      'HCL_OH                          ', 'HOCL_CL                         ', &
                                      'HOCL_O                          ', 'HOCL_OH                         ', &
                                      'O1D_CCL4                        ', 'O1D_CF2CLBR                     ', &
                                      'O1D_CFC11                       ', 'O1D_CFC113                      ', &
                                      'O1D_CFC114                      ', 'O1D_CFC115                      ', &
                                      'O1D_CFC12                       ', 'O1D_HCLa                        ', &
                                      'O1D_HCLb                        ', 'tag_CLO_CLO_M                   ', &
                                      'usr_CL2O2_M                     ', 'BR_CH2O                         ', &
                                      'BR_HO2                          ', 'BR_O3                           ', &
                                      'BRO_BRO                         ', 'BRO_CLOa                        ', &
                                      'BRO_CLOb                        ', 'BRO_CLOc                        ', &
                                      'BRO_HO2                         ', 'BRO_NO                          ', &
                                      'BRO_NO2_M                       ', 'BRONO2_O                        ', &
                                      'BRO_O                           ', 'BRO_OH                          ', &
                                      'HBR_O                           ', 'HBR_OH                          ', &
                                      'HOBR_O                          ', 'O1D_CF3BR                       ', &
                                      'O1D_CHBR3                       ', 'O1D_H2402                       ', &
                                      'O1D_HBRa                        ', 'O1D_HBRb                        ', &
                                      'F_CH4                           ', 'F_H2                            ', &
                                      'F_H2O                           ', 'F_HNO3                          ', &
                                      'O1D_COF2                        ', 'O1D_COFCL                       ', &
                                      'CH2BR2_CL                       ', 'CH2BR2_OH                       ', &
                                      'CH3BR_CL                        ', 'CH3BR_OH                        ', &
                                      'CH3CCL3_OH                      ', 'CH3CL_CL                        ', &
                                      'CH3CL_OH                        ', 'CHBR3_CL                        ', &
                                      'CHBR3_OH                        ', 'HCFC141B_OH                     ', &
                                      'HCFC142B_OH                     ', 'HCFC22_OH                       ', &
                                      'O1D_CH2BR2                      ', 'O1D_CH3BR                       ', &
                                      'O1D_HCFC141B                    ', 'O1D_HCFC142B                    ', &
                                      'O1D_HCFC22                      ', 'CH2O_HO2                        ', &
                                      'CH2O_NO3                        ', 'CH2O_O                          ', &
                                      'CH2O_OH                         ', 'CH3O2_CH3O2a                    ', &
                                      'CH3O2_CH3O2b                    ', 'CH3O2_HO2                       ', &
                                      'CH3O2_NO                        ', 'CH3OH_OH                        ', &
                                      'CH3OOH_OH                       ', 'CH4_OH                          ', &
                                      'CO_OH_M                         ', 'HCN_OH                          ', &
                                      'HCOOH_OH                        ', 'HMHP_OH                         ', &
                                      'HOCH2OO_HO2                     ', 'HOCH2OO_M                       ', &
                                      'HOCH2OO_NO                      ', 'O1D_CH4a                        ', &
                                      'O1D_CH4b                        ', 'O1D_CH4c                        ', &
                                      'O1D_HCN                         ', 'usr_CO_OH_b                     ', &
                                      'C2H2_CL_M                       ', 'C2H2_OH_M                       ', &
                                      'C2H4_CL_M                       ', 'C2H4_O3                         ', &
                                      'C2H5O2_C2H5O2                   ', 'C2H5O2_CH3O2                    ', &
                                      'C2H5O2_HO2                      ', 'C2H5O2_NO                       ', &
                                      'C2H5OH_OH                       ', 'C2H5OOH_OH                      ', &
                                      'C2H6_CL                         ', 'C2H6_OH                         ', &
                                      'CH3CHO_NO3                      ', 'CH3CHO_OH                       ', &
                                      'CH3CN_OH                        ', 'CH3CO3_CH3CO3                   ', &
                                      'CH3CO3_CH3O2                    ', 'CH3CO3_HO2                      ', &
                                      'CH3CO3_NO                       ', 'CH3COOH_OH                      ', &
                                      'CH3COOOH_OH                     ', 'EO2_HO2                         ', &
                                      'EO2_NO                          ', 'EO_M                            ', &
                                      'EO_O2                           ', 'GLYALD_OH                       ', &
                                      'GLYOXAL_OH                      ', 'HCOCH2OOH_OH                    ', &
                                      'NO3CH2CHO_OH                    ', 'PAN_OH                          ', &
                                      'tag_C2H4_OH                     ', 'tag_CH3CO3_NO2                  ', &
                                      'usr_PAN_M                       ', 'C3H6_NO3                        ', &
                                      'C3H6_O3                         ', 'C3H7O2_CH3O2                    ', &
                                      'C3H7O2_HO2                      ', 'C3H7O2_NO                       ', &
                                      'C3H7OOH_OH                      ', 'C3H8_OH                         ', &
                                      'CH3COCHO_NO3                    ', 'CH3COCHO_OH                     ', &
                                      'HYAC_OH                         ', 'HYPERACET_OH                    ', &
                                      'NOA_OH                          ', 'PO2_HO2                         ', &
                                      'PO2_NO                          ', 'POOH_OH                         ', &
                                      'RO2_CH3O2                       ', 'RO2_HO2                         ', &
                                      'RO2_NO                          ', 'ROOH_OH                         ', &
                                      'tag_C3H6_OH                     ', 'usr_CH3COCH3_OH                 ', &
                                      'BIGENE_NO3                      ', 'BIGENE_OH                       ', &
                                      'DHPMPAL_OH                      ', 'ENEO2_NO                        ', &
                                      'ENEO2_NOb                       ', 'HONITR_OH                       ', &
                                      'MACRN_OH                        ', 'MACRO2_CH3CO3                   ', &
                                      'MACRO2_CH3O2                    ', 'MACRO2_HO2                      ', &
                                      'MACRO2_isom                     ', 'MACR_O3                         ', &
                                      'MACR_OH                         ', 'MACROOH_OH                      ', &
                                      'MCO3_CH3CO3                     ', 'MCO3_CH3O2                      ', &
                                      'MCO3_HO2                        ', 'MCO3_MCO3                       ', &
                                      'MCO3_NO                         ', 'MCO3_NO3                        ', &
                                      'MEKO2_HO2                       ', 'MEKO2_NO                        ', &
                                      'MEK_OH                          ', 'MEKOOH_OH                       ', &
                                      'MPAN_OH_M                       ', 'MVKN_OH                         ' /)
      rxt_tag_lst(   401:   600) = (/ 'MVKO2_CH3CO3                    ', 'MVKO2_CH3O2                     ', &
                                      'MVKO2_HO2                       ', 'MVK_O3                          ', &
                                      'MVK_OH                          ', 'MVKOOH_OH                       ', &
                                      'tag_MCO3_NO2                    ', 'usr_MPAN_M                      ', &
                                      'ALKNIT_OH                       ', 'ALKO2_HO2                       ', &
                                      'ALKO2_NO                        ', 'ALKO2_NOb                       ', &
                                      'ALKOOH_OH                       ', 'BIGALK_OH                       ', &
                                      'HPALD1_OH                       ', 'HPALD4_OH                       ', &
                                      'HPALDB1C_OH                     ', 'HPALDB4C_OH                     ', &
                                      'HYDRALD_OH                      ', 'ICHE_OH                         ', &
                                      'IEPOX_OH                        ', 'IEPOXOO_HO2                     ', &
                                      'INHEB_OH                        ', 'INHED_OH                        ', &
                                      'ISOPB1O2_CH3CO3                 ', 'ISOPB1O2_CH3O2                  ', &
                                      'ISOPB1O2_HO2                    ', 'ISOPB1O2_I                      ', &
                                      'ISOPB1O2_M_C                    ', 'ISOPB1O2_M_T                    ', &
                                      'ISOPB4O2_CH3CO3                 ', 'ISOPB4O2_CH3O2                  ', &
                                      'ISOPB4O2_HO2                    ', 'ISOPB4O2_I                      ', &
                                      'ISOPB4O2_M_C                    ', 'ISOPB4O2_M_T                    ', &
                                      'ISOPC1C_O2_B                    ', 'ISOPC1C_O2_D                    ', &
                                      'ISOPC1T_O2_B                    ', 'ISOPC1T_O2_D                    ', &
                                      'ISOPC4C_O2_B                    ', 'ISOPC4C_O2_D                    ', &
                                      'ISOPC4T_O2_B                    ', 'ISOPC4T_O2_D                    ', &
                                      'ISOPED1O2_CH3CO3                ', 'ISOPED1O2_CH3O2                 ', &
                                      'ISOPED1O2_HO2                   ', 'ISOPED1O2_M_C                   ', &
                                      'ISOPED4O2_CH3CO3                ', 'ISOPED4O2_CH3O2                 ', &
                                      'ISOPED4O2_HO2                   ', 'ISOPED4O2_M                     ', &
                                      'ISOPFDNC_OH                     ', 'ISOPFDN_OH                      ', &
                                      'ISOPFNC_OH                      ', 'ISOPFNP_OH                      ', &
                                      'ISOPHFP_OH                      ', 'ISOPN1DO2_HO2                   ', &
                                      'ISOPN1DO2_I                     ', 'ISOPN1D_O3                      ', &
                                      'ISOPN1D_OH                      ', 'ISOPN2BO2_HO2                   ', &
                                      'ISOPN2BO2_I                     ', 'ISOPN2B_OH                      ', &
                                      'ISOPN3BO2_HO2                   ', 'ISOPN3BO2_I                     ', &
                                      'ISOPN3B_OH                      ', 'ISOPN4DO2_HO2                   ', &
                                      'ISOPN4DO2_I                     ', 'ISOPN4D_O3                      ', &
                                      'ISOPN4D_OH                      ', 'ISOPNBNO3O2_HO2                 ', &
                                      'ISOPNBNO3_OH                    ', 'ISOP_NO3                        ', &
                                      'ISOPNO3_CH3CO3                  ', 'ISOPNO3_CH3O2                   ', &
                                      'ISOPNO3_HO2                     ', 'ISOPNO3_ISOPNO3                 ', &
                                      'ISOPNO3_NO3                     ', 'ISOPNOOHBO2_HO2                 ', &
                                      'ISOPNOOHBO2_I                   ', 'ISOPNOOHB_OH                    ', &
                                      'ISOPNOOHDO2_HO2                 ', 'ISOPNOOHDO2_I                   ', &
                                      'ISOPNOOHD_O3                    ', 'ISOPNOOHD_OH                    ', &
                                      'ISOP_O3                         ', 'ISOP_OH                         ', &
                                      'ISOPOH_OH                       ', 'ISOPOOH_OH_abs                  ', &
                                      'ISOPOOH_OH_add                  ', 'ISOPZD1O2_CH3CO3                ', &
                                      'ISOPZD1O2_CH3O2                 ', 'ISOPZD1O2_HO2                   ', &
                                      'ISOPZD1O2_M                     ', 'ISOPZD4O2_CH3CO3                ', &
                                      'ISOPZD4O2_CH3O2                 ', 'ISOPZD4O2_HO2                   ', &
                                      'ISOPZD4O2_M_C                   ', 'NC4CHOO2_HO2                    ', &
                                      'NC4CHOO2_isom                   ', 'NC4CHO_O3                       ', &
                                      'NC4CHO_OH                       ', 'usr_IEPOXOO_NOa                 ', &
                                      'usr_IEPOXOO_NOn                 ', 'usr_ISOPB1O2_NOa                ', &
                                      'usr_ISOPB1O2_NOn                ', 'usr_ISOPB4O2_NOa                ', &
                                      'usr_ISOPB4O2_NOn                ', 'usr_ISOPED1O2_NOa               ', &
                                      'usr_ISOPED1O2_NOn               ', 'usr_ISOPED4O2_NOa               ', &
                                      'usr_ISOPED4O2_NOn               ', 'usr_ISOPN1DO2_NOa               ', &
                                      'usr_ISOPN1DO2_NOn               ', 'usr_ISOPN2BO2_NOa               ', &
                                      'usr_ISOPN2BO2_NOn               ', 'usr_ISOPN3BO2_NOa               ', &
                                      'usr_ISOPN3BO2_NOn               ', 'usr_ISOPN4DO2_NOa               ', &
                                      'usr_ISOPN4DO2_NOn               ', 'usr_ISOPNBNO3O2_NOa             ', &
                                      'usr_ISOPNBNO3O2_NOn             ', 'usr_ISOPNO3_NOa                 ', &
                                      'usr_ISOPNO3_NOn                 ', 'usr_ISOPNOOHBO2_NOa             ', &
                                      'usr_ISOPNOOHBO2_NOn             ', 'usr_ISOPNOOHDO2_NOa             ', &
                                      'usr_ISOPNOOHDO2_NOn             ', 'usr_ISOPZD1O2                   ', &
                                      'usr_ISOPZD1O2_NOa               ', 'usr_ISOPZD1O2_NOn               ', &
                                      'usr_ISOPZD4O2                   ', 'usr_ISOPZD4O2_NOa               ', &
                                      'usr_ISOPZD4O2_NOn               ', 'usr_MACRO2_NOa                  ', &
                                      'usr_MACRO2_NOn                  ', 'usr_MVKO2_NOa                   ', &
                                      'usr_MVKO2_NOn                   ', 'usr_NC4CHOO2_NOa                ', &
                                      'usr_NC4CHOO2_NOn                ', 'ACBZO2_HO2                      ', &
                                      'ACBZO2_NO                       ', 'BENZENE_OH                      ', &
                                      'BENZO2_HO2                      ', 'BENZO2_NO                       ', &
                                      'BENZOOH_OH                      ', 'BZALD_OH                        ', &
                                      'BZOO_HO2                        ', 'BZOOH_OH                        ', &
                                      'BZOO_NO                         ', 'C6H5O2_HO2                      ', &
                                      'C6H5O2_NO                       ', 'C6H5OOH_OH                      ', &
                                      'CRESOL_OH                       ', 'DICARBO2_HO2                    ', &
                                      'DICARBO2_NO                     ', 'DICARBO2_NO2                    ', &
                                      'MALO2_HO2                       ', 'MALO2_NO                        ', &
                                      'MALO2_NO2                       ', 'MDIALO2_HO2                     ', &
                                      'MDIALO2_NO                      ', 'MDIALO2_NO2                     ', &
                                      'PHENO2_HO2                      ', 'PHENO2_NO                       ', &
                                      'PHENOL_OH                       ', 'PHENO_NO2                       ', &
                                      'PHENO_O3                        ', 'PHENOOH_OH                      ', &
                                      'tag_ACBZO2_NO2                  ', 'TOLO2_HO2                       ', &
                                      'TOLO2_NO                        ', 'TOLOOH_OH                       ', &
                                      'TOLUENE_OH                      ', 'usr_PBZNIT_M                    ', &
                                      'XYLENES_OH                      ', 'XYLENO2_HO2                     ', &
                                      'XYLENO2_NO                      ', 'XYLENOOH_OH                     ', &
                                      'XYLOLO2_HO2                     ', 'XYLOLO2_NO                      ', &
                                      'XYLOL_OH                        ', 'XYLOLOOH_OH                     ', &
                                      'APIN_NO3                        ', 'APINNO3_APINNO3                 ', &
                                      'APINNO3_CH3CO3                  ', 'APINNO3_CH3O2                   ', &
                                      'APINNO3_HO2                     ', 'APINNO3_NO                      ', &
                                      'APINNO3_NO3                     ', 'APINNO3_TERPA2CO3               ', &
                                      'APINNO3_TERPA3CO3               ', 'APINNO3_TERPACO3                ', &
                                      'APINO2_CH3CO3                   ', 'APINO2_CH3O2                    ', &
                                      'APINO2_HO2                      ', 'APINO2_NO                       ', &
                                      'APINO2_NO3                      ', 'APINO2_TERPA2CO3                ' /)
      rxt_tag_lst(   601:   800) = (/ 'APINO2_TERPA3CO3                ', 'APINO2_TERPACO3                 ', &
                                      'APIN_O3                         ', 'APIN_OH                         ', &
                                      'BCARY_NO3                       ', 'BCARYNO3_BCARYNO3               ', &
                                      'BCARYNO3_CH3CO3                 ', 'BCARYNO3_CH3O2                  ', &
                                      'BCARYNO3_HO2                    ', 'BCARYNO3_NO                     ', &
                                      'BCARYNO3_NO3                    ', 'BCARYNO3_TERPA2CO3              ', &
                                      'BCARYNO3_TERPA3CO3              ', 'BCARYNO3_TERPACO3               ', &
                                      'BCARYO2_CH3CO3                  ', 'BCARYO2_CH3O2                   ', &
                                      'BCARYO2_HO2                     ', 'BCARYO2_NO                      ', &
                                      'BCARYO2_NO3                     ', 'BCARYO2_TERPA2CO3               ', &
                                      'BCARYO2_TERPA3CO3               ', 'BCARYO2_TERPACO3                ', &
                                      'BCARY_O3                        ', 'BCARY_OH                        ', &
                                      'BPIN_NO3                        ', 'BPINNO3_BPINNO3                 ', &
                                      'BPINNO3_CH3CO3                  ', 'BPINNO3_CH3O2                   ', &
                                      'BPINNO3_HO2                     ', 'BPINNO3_NO                      ', &
                                      'BPINNO3_NO3                     ', 'BPINNO3_TERPA2CO3               ', &
                                      'BPINNO3_TERPA3CO3               ', 'BPINNO3_TERPACO3                ', &
                                      'BPINO2_CH3CO3                   ', 'BPINO2_CH3O2                    ', &
                                      'BPINO2_HO2                      ', 'BPINO2_NO                       ', &
                                      'BPINO2_NO3                      ', 'BPINO2_TERPA2CO3                ', &
                                      'BPINO2_TERPA3CO3                ', 'BPINO2_TERPACO3                 ', &
                                      'BPIN_O3                         ', 'BPIN_OH                         ', &
                                      'LIMON_NO3                       ', 'LIMONNO3_CH3CO3                 ', &
                                      'LIMONNO3_CH3O2                  ', 'LIMONNO3_HO2                    ', &
                                      'LIMONNO3_LIMONNO3               ', 'LIMONNO3_NO                     ', &
                                      'LIMONNO3_NO3                    ', 'LIMONNO3_TERPA2CO3              ', &
                                      'LIMONNO3_TERPA3CO3              ', 'LIMONNO3_TERPACO3               ', &
                                      'LIMONO2_CH3CO3                  ', 'LIMONO2_CH3O2                   ', &
                                      'LIMONO2_HO2                     ', 'LIMONO2_NO                      ', &
                                      'LIMONO2_NO3                     ', 'LIMONO2_TERPA2CO3               ', &
                                      'LIMONO2_TERPA3CO3               ', 'LIMONO2_TERPACO3                ', &
                                      'LIMON_O3                        ', 'LIMON_OH                        ', &
                                      'MYRC_NO3                        ', 'MYRCNO3_CH3CO3                  ', &
                                      'MYRCNO3_CH3O2                   ', 'MYRCNO3_HO2                     ', &
                                      'MYRCNO3_MYRCNO3                 ', 'MYRCNO3_NO                      ', &
                                      'MYRCNO3_NO3                     ', 'MYRCNO3_TERPA2CO3               ', &
                                      'MYRCNO3_TERPA3CO3               ', 'MYRCNO3_TERPACO3                ', &
                                      'MYRCO2_CH3CO3                   ', 'MYRCO2_CH3O2                    ', &
                                      'MYRCO2_HO2                      ', 'MYRCO2_NO                       ', &
                                      'MYRCO2_NO3                      ', 'MYRCO2_TERPA2CO3                ', &
                                      'MYRCO2_TERPA3CO3                ', 'MYRCO2_TERPACO3                 ', &
                                      'MYRC_O3                         ', 'MYRC_OH                         ', &
                                      'tag_TERPA2CO3_NO2               ', 'tag_TERPA3CO3_NO2               ', &
                                      'tag_TERPACO3_NO2                ', 'TERP1OOHO2_HO2                  ', &
                                      'TERP1OOHO2_NO                   ', 'TERP1OOH_OH                     ', &
                                      'TERP2AOOH_OH                    ', 'TERP2OOHO2_HO2                  ', &
                                      'TERP2OOHO2_NO                   ', 'TERPA1O2_CH3CO3                 ', &
                                      'TERPA1O2_CH3O2                  ', 'TERPA1O2_HO2                    ', &
                                      'TERPA1O2_NO                     ', 'TERPA1O2_NO3                    ', &
                                      'TERPA1O2_TERPA2CO3              ', 'TERPA1O2_TERPA3CO3              ', &
                                      'TERPA1O2_TERPACO3               ', 'TERPA2CO3_CH3CO3                ', &
                                      'TERPA2CO3_CH3O2                 ', 'TERPA2CO3_HO2                   ', &
                                      'TERPA2CO3_NO                    ', 'TERPA2CO3_NO3                   ', &
                                      'TERPA2CO3_TERPA2CO3             ', 'TERPA2CO3_TERPACO3              ', &
                                      'TERPA2_NO3                      ', 'TERPA2O2_CH3CO3                 ', &
                                      'TERPA2O2_CH3O2                  ', 'TERPA2O2_HO2                    ', &
                                      'TERPA2O2_NO                     ', 'TERPA2O2_NO3                    ', &
                                      'TERPA2O2_TERPA2CO3              ', 'TERPA2O2_TERPA3CO3              ', &
                                      'TERPA2O2_TERPACO3               ', 'TERPA2_OH                       ', &
                                      'TERPA2PAN_OH                    ', 'TERPA3CO3_CH3CO3                ', &
                                      'TERPA3CO3_CH3O2                 ', 'TERPA3CO3_HO2                   ', &
                                      'TERPA3CO3_NO                    ', 'TERPA3CO3_NO3                   ', &
                                      'TERPA3CO3_TERPA2CO3             ', 'TERPA3CO3_TERPA3CO3             ', &
                                      'TERPA3CO3_TERPACO3              ', 'TERPA3_NO3                      ', &
                                      'TERPA3O2_CH3CO3                 ', 'TERPA3O2_CH3O2                  ', &
                                      'TERPA3O2_HO2                    ', 'TERPA3O2_NO                     ', &
                                      'TERPA3O2_NO3                    ', 'TERPA3O2_TERPA2CO3              ', &
                                      'TERPA3O2_TERPA3CO3              ', 'TERPA3O2_TERPACO3               ', &
                                      'TERPA3_OH                       ', 'TERPA3PAN_OH                    ', &
                                      'TERPA4O2_CH3CO3                 ', 'TERPA4O2_CH3O2                  ', &
                                      'TERPA4O2_HO2                    ', 'TERPA4O2_NO                     ', &
                                      'TERPA4O2_NO3                    ', 'TERPA4O2_TERPA2CO3              ', &
                                      'TERPA4O2_TERPA3CO3              ', 'TERPA4O2_TERPACO3               ', &
                                      'TERPACID2_OH                    ', 'TERPACID3_OH                    ', &
                                      'TERPACID_OH                     ', 'TERPACO3_CH3CO3                 ', &
                                      'TERPACO3_CH3O2                  ', 'TERPACO3_HO2                    ', &
                                      'TERPACO3_NO                     ', 'TERPACO3_NO3                    ', &
                                      'TERPACO3_TERPACO3               ', 'TERPA_NO3                       ', &
                                      'TERPA_OH                        ', 'TERPAPAN_OH                     ', &
                                      'TERPDHDP_OH                     ', 'TERPF1_NO3                      ', &
                                      'TERPF1O2_HO2                    ', 'TERPF1O2_NO                     ', &
                                      'TERPF1_O3                       ', 'TERPF1_OH                       ', &
                                      'TERPF2_NO3                      ', 'TERPF2O2_HO2                    ', &
                                      'TERPF2O2_NO                     ', 'TERPF2_O3                       ', &
                                      'TERPF2_OH                       ', 'TERPFDN_OH                      ', &
                                      'TERPHFN_OH                      ', 'TERPK_OH                        ', &
                                      'TERPNPS1O2_HO2                  ', 'TERPNPS1O2_NO                   ', &
                                      'TERPNPS1_OH                     ', 'TERPNPS_OH                      ', &
                                      'TERPNPT1O2_HO2                  ', 'TERPNPT1O2_NO                   ', &
                                      'TERPNPT1_OH                     ', 'TERPNPT_OH                      ', &
                                      'TERPNS1O2_HO2                   ', 'TERPNS1O2_NO                    ', &
                                      'TERPNS1_OH                      ', 'TERPNS_OH                       ', &
                                      'TERPNT1O2_HO2                   ', 'TERPNT1O2_NO                    ', &
                                      'TERPNT1_OH                      ', 'TERPNT_OH                       ', &
                                      'TERPOOHL_OH                     ', 'TERPOOH_OH                      ', &
                                      'usr_TERPA2PAN_M                 ', 'usr_TERPA3PAN_M                 ', &
                                      'usr_TERPAPAN_M                  ', 'DMS_NO3                         ', &
                                      'DMS_OHa                         ', 'OCS_O                           ', &
                                      'OCS_OH                          ', 'S_O2                            ', &
                                      'S_O3                            ', 'SO_BRO                          ' /)
      rxt_tag_lst(   801:   905) = (/ 'SO_CLO                          ', 'S_OH                            ', &
                                      'SO_NO2                          ', 'SO_O2                           ', &
                                      'SO_O3                           ', 'SO_OCLO                         ', &
                                      'SO_OH                           ', 'usr_DMS_OH                      ', &
                                      'usr_SO2_OH                      ', 'usr_SO3_H2O                     ', &
                                      'NH3_OH                          ', 'usr_GLYOXAL_aer                 ', &
                                      'usr_HO2_aer                     ', 'usr_HONITR_aer                  ', &
                                      'usr_ICHE_aer                    ', 'usr_IEPOX_aer                   ', &
                                      'usr_INHEB_aer                   ', 'usr_INHED_aer                   ', &
                                      'usr_INOOHD_aer                  ', 'usr_ISOPFDN_aer                 ', &
                                      'usr_ISOPFDNC_aer                ', 'usr_ISOPFNC_aer                 ', &
                                      'usr_ISOPFNP_aer                 ', 'usr_ISOPHFP_aer                 ', &
                                      'usr_ISOPN1D_aer                 ', 'usr_ISOPN2B_aer                 ', &
                                      'usr_ISOPN4D_aer                 ', 'usr_N2O5_aer                    ', &
                                      'usr_NC4CHO_aer                  ', 'usr_NH4_strat_tau               ', &
                                      'usr_NO2_aer                     ', 'usr_NO3_aer                     ', &
                                      'usr_ONITR_aer                   ', 'usr_SQTN_aer                    ', &
                                      'usr_TERPDHDP_aer                ', 'usr_TERPFDN_aer                 ', &
                                      'usr_TERPHFN_aer                 ', 'usr_TERPNPT1_aer                ', &
                                      'usr_TERPNPT_aer                 ', 'usr_TERPNT1_aer                 ', &
                                      'usr_TERPNT_aer                  ', 'APIN_NO3_vbs                    ', &
                                      'APINO2_HO2_vbs                  ', 'APINO2_NO_vbs                   ', &
                                      'APIN_O3_vbs                     ', 'APIN_OH_vbs                     ', &
                                      'BCARY_NO3_vbs                   ', 'BCARYO2_HO2_vbs                 ', &
                                      'BCARYO2_NO_vbs                  ', 'BCARY_O3_vbs                    ', &
                                      'BCARY_OH_vbs                    ', 'BENZENE_OH_vbs                  ', &
                                      'BENZO2_HO2_vbs                  ', 'BENZO2_NO_vbs                   ', &
                                      'BPIN_NO3_vbs                    ', 'BPINO2_HO2_vbs                  ', &
                                      'BPINO2_NO_vbs                   ', 'BPIN_O3_vbs                     ', &
                                      'BPIN_OH_vbs                     ', 'ISOP_NO3_vbs                    ', &
                                      'ISOPO2_HO2_vbs                  ', 'ISOPO2_NO_vbs                   ', &
                                      'ISOP_O3_vbs                     ', 'ISOP_OH_vbs                     ', &
                                      'IVOCO2_HO2_vbs                  ', 'IVOCO2_NO_vbs                   ', &
                                      'IVOC_OH_vbs                     ', 'LIMON_NO3_vbs                   ', &
                                      'LIMONO2_HO2_vbs                 ', 'LIMONO2_NO_vbs                  ', &
                                      'LIMON_O3_vbs                    ', 'LIMON_OH_vbs                    ', &
                                      'MYRC_NO3_vbs                    ', 'MYRCO2_HO2_vbs                  ', &
                                      'MYRCO2_NO_vbs                   ', 'MYRC_O3_vbs                     ', &
                                      'MYRC_OH_vbs                     ', 'SVOC_OH                         ', &
                                      'TOLUENE_OH_vbs                  ', 'TOLUO2_HO2_vbs                  ', &
                                      'TOLUO2_NO_vbs                   ', 'XYLENES_OH_vbs                  ', &
                                      'XYLEO2_HO2_vbs                  ', 'XYLEO2_NO_vbs                   ', &
                                      'het1                            ', 'het10                           ', &
                                      'het11                           ', 'het12                           ', &
                                      'het13                           ', 'het14                           ', &
                                      'het15                           ', 'het16                           ', &
                                      'het17                           ', 'het2                            ', &
                                      'het3                            ', 'het4                            ', &
                                      'het5                            ', 'het6                            ', &
                                      'het7                            ', 'het8                            ', &
                                      'het9                            ', 'E90_tau                         ', &
                                      'NH_50_tau                       ', 'NH_5_tau                        ', &
                                      'ST80_25_tau                     ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                                       11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                                       21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                                       31,  32,  33,  34,  35,  36,  37,  38,  39,  40, &
                                       41,  42,  43,  44,  45,  46,  47,  48,  49,  50, &
                                       51,  52,  53,  54,  55,  56,  57,  58,  59,  60, &
                                       61,  62,  63,  64,  65,  66,  67,  68,  69,  70, &
                                       71,  72,  73,  74,  75,  76,  77,  78,  79,  80, &
                                       81,  82,  83,  84,  85,  86,  87,  88,  89,  90, &
                                       91,  92,  93,  94,  95,  96,  97,  98,  99, 100, &
                                      101, 102, 103, 104, 105, 106, 107, 108, 109, 110, &
                                      111, 112, 113, 114, 115, 116, 117, 118, 119, 120, &
                                      121, 122, 123, 124, 125, 126, 127, 128, 129, 130, &
                                      131, 132, 133, 134, 135, 136, 137, 138, 139, 140, &
                                      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, &
                                      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, &
                                      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, &
                                      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, &
                                      181, 182, 183, 184, 185, 186, 187, 188, 189, 190, &
                                      191, 192, 193, 194, 195, 196, 197, 198, 199, 200, &
                                      201, 202, 203, 204, 205, 206, 207, 208, 209, 210, &
                                      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, &
                                      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, &
                                      231, 232, 233, 234, 235, 236, 237, 238, 239, 240, &
                                      241, 242, 243, 244, 245, 246, 247, 248, 249, 250, &
                                      251, 252, 253, 254, 255, 256, 257, 258, 259, 260, &
                                      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, &
                                      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, &
                                      281, 282, 283, 284, 285, 286, 287, 288, 289, 290, &
                                      291, 292, 293, 294, 295, 296, 297, 298, 299, 300, &
                                      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, &
                                      311, 312, 313, 314, 315, 316, 317, 318, 319, 320, &
                                      321, 322, 323, 324, 325, 326, 327, 328, 329, 330, &
                                      331, 332, 333, 334, 335, 336, 337, 338, 339, 340, &
                                      341, 342, 343, 344, 345, 346, 347, 348, 349, 350, &
                                      351, 352, 353, 354, 355, 356, 357, 358, 359, 360, &
                                      361, 362, 363, 364, 365, 366, 367, 368, 369, 370, &
                                      371, 372, 373, 374, 375, 376, 377, 378, 379, 380, &
                                      381, 382, 383, 384, 385, 386, 387, 388, 389, 390, &
                                      391, 392, 393, 394, 395, 396, 397, 398, 399, 400, &
                                      401, 402, 403, 404, 405, 406, 407, 408, 409, 410, &
                                      411, 412, 413, 414, 415, 416, 417, 418, 419, 420, &
                                      421, 422, 423, 424, 425, 426, 427, 428, 429, 430, &
                                      431, 432, 433, 434, 435, 436, 437, 438, 439, 440, &
                                      441, 442, 443, 444, 445, 446, 447, 448, 449, 450, &
                                      451, 452, 453, 454, 455, 456, 457, 458, 459, 460, &
                                      461, 462, 463, 464, 465, 466, 467, 468, 469, 470, &
                                      471, 472, 473, 474, 475, 476, 477, 478, 479, 480, &
                                      481, 482, 483, 484, 485, 486, 487, 488, 489, 490, &
                                      491, 492, 493, 494, 495, 496, 497, 498, 499, 500, &
                                      501, 502, 503, 504, 505, 506, 507, 508, 509, 510, &
                                      511, 512, 513, 514, 515, 516, 517, 518, 519, 520, &
                                      521, 522, 523, 524, 525, 526, 527, 528, 529, 530, &
                                      531, 532, 533, 534, 535, 536, 537, 538, 539, 540, &
                                      541, 542, 543, 544, 545, 546, 547, 548, 549, 550, &
                                      551, 552, 553, 554, 555, 556, 557, 558, 559, 560, &
                                      561, 562, 563, 564, 565, 566, 567, 568, 569, 570, &
                                      571, 572, 573, 574, 575, 576, 577, 578, 579, 580, &
                                      581, 582, 583, 584, 585, 586, 587, 588, 589, 590, &
                                      591, 592, 593, 594, 595, 596, 597, 598, 599, 600, &
                                      601, 602, 603, 604, 605, 606, 607, 608, 609, 610, &
                                      611, 612, 613, 614, 615, 616, 617, 618, 619, 620, &
                                      621, 622, 623, 624, 625, 626, 627, 628, 629, 630, &
                                      631, 632, 633, 634, 635, 636, 637, 638, 639, 640, &
                                      641, 642, 643, 644, 645, 646, 647, 648, 649, 650, &
                                      651, 652, 653, 654, 655, 656, 657, 658, 659, 660, &
                                      661, 662, 663, 664, 665, 666, 667, 668, 669, 670, &
                                      671, 672, 673, 674, 675, 676, 677, 678, 679, 680, &
                                      681, 682, 683, 684, 685, 686, 687, 688, 689, 690, &
                                      691, 692, 693, 694, 695, 696, 697, 698, 699, 700, &
                                      701, 702, 703, 704, 705, 706, 707, 708, 709, 710, &
                                      711, 712, 713, 714, 715, 716, 717, 718, 719, 720, &
                                      721, 722, 723, 724, 725, 726, 727, 728, 729, 730, &
                                      731, 732, 733, 734, 735, 736, 737, 738, 739, 740, &
                                      741, 742, 743, 744, 745, 746, 747, 748, 749, 750, &
                                      751, 752, 753, 754, 755, 756, 757, 758, 759, 760, &
                                      761, 762, 763, 764, 765, 766, 767, 768, 769, 770, &
                                      771, 772, 773, 774, 775, 776, 777, 778, 779, 780, &
                                      781, 782, 783, 784, 785, 786, 787, 788, 789, 790, &
                                      791, 792, 793, 794, 795, 796, 797, 798, 799, 800, &
                                      801, 802, 803, 804, 805, 806, 807, 808, 809, 810, &
                                      811, 812, 813, 814, 815, 816, 817, 818, 819, 820, &
                                      821, 822, 823, 824, 825, 826, 827, 828, 829, 830, &
                                      831, 832, 833, 834, 835, 836, 837, 838, 839, 840, &
                                      841, 842, 843, 844, 845, 846, 847, 848, 849, 850, &
                                      851, 852, 853, 854, 855, 856, 857, 858, 859, 860, &
                                      861, 862, 863, 864, 865, 866, 867, 868, 869, 870, &
                                      871, 872, 873, 874, 875, 876, 877, 878, 879, 880, &
                                      881, 882, 883, 884, 885, 886, 887, 888, 889, 890, &
                                      891, 892, 893, 894, 895, 896, 897, 898, 899, 900, &
                                      901, 902, 903, 904, 905 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ '                ', '                ', '                ', '                ', &
                              'userdefined     ', 'userdefined     ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', 'userdefined     ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ' /)
      pht_alias_lst(:,2) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jno2            ', 'jno2            ', 'jno2            ', &
                              'jno2            ', 'jno2            ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', '                ', &
                              '                ', '                ', '                ', 'jh2o2           ', &
                              '                ', '                ', '                ', '                ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', 'jmgly           ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch2o_a         ', 'jmacr_a         ', &
                              'jmacr_a         ', 'jch3ooh         ', 'jch3ooh         ', '                ', &
                              'jmacr_b         ', 'jmacr_a         ', 'jacet           ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch2o_a         ', &
                              'jch2o_a         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', '                ', &
                              '                ', 'jch2o_a         ', 'jch3ooh         ', 'jacet           ', &
                              'jch3ooh         ', 'jpan            ', '                ', 'jch2o_a         ', &
                              'jch3ooh         ', 'jch2o_a         ', 'jch2o_a         ', 'jch2o_a         ', &
                              'jch3cho         ', '                ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jno2            ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3cho         ', 'jch3cho         ', 'jpan            ', 'jch3cho         ', &
                              'jpan            ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jpan            ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', 'jno2            ', 'jno2            ', 'jno2            ', &
                              'jno2            ', 'jno2            ', 'jno2            ', 'jno2            ', &
                              'jno2            ', 'jno2            ', 'jno2            ' /)
      pht_alias_mult(:,1) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8 /)
      pht_alias_mult(:,2) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, .10_r8, .14_r8, .20_r8, .20_r8, &
                          .006_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          0.28_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          4.62_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          0.75_r8, 1._r8, 110.0_r8, 110.0_r8, 4.62_r8, &
                          4.62_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 10.0_r8, &
                          10.0_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 5.8_r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1.26_r8, &
                          1._r8, 9.2_r8, 4.3_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, .10_r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 0.71_r8, 0.71_r8, 0.71_r8, &
                          1._r8, 2.0_r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, .0004_r8, .0004_r8, .0004_r8, &
                          .0004_r8, .0004_r8, .0004_r8, .0004_r8, .0004_r8, &
                          .0004_r8, .0004_r8 /)
      allocate( cph_enthalpy(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_enthalpy; error = ',ios
         call endrun
      end if
      allocate( cph_rid(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_rid; error = ',ios
         call endrun
      end if
      cph_rid(:)      = (/             170,            173,            174,            175,            178, &
                                       181,            182,            183,            184,            187, &
                                       188,            189,            192,            194,            198, &
                                       199,            207,            208 /)
      cph_enthalpy(:) = (/   189.810000_r8,  392.190000_r8,  493.580000_r8,  101.390000_r8,  232.590000_r8, &
                             203.400000_r8,  226.580000_r8,  120.100000_r8,  194.710000_r8,  293.620000_r8, &
                              67.670000_r8,  165.300000_r8,  165.510000_r8,  313.750000_r8,  133.750000_r8, &
                             193.020000_r8,   34.470000_r8,  199.170000_r8 /)
      allocate( num_rnts(rxntot-phtcnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate num_rnts; error = ',ios
         call endrun
      end if
      num_rnts(:) = (/      2,     2,     2,     2,     2,     2,     3,     3,     2,     2, &
                            2,     2,     2,     3,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     3,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     3,     2,     2,     2,     2,     2,     2, &
                            2,     3,     2,     2,     3,     3,     3,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     3,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     3,     3,     2,     2,     2,     1,     2,     2,     2, &
                            2,     2,     2,     3,     3,     3,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     1,     2,     2,     2, &
                            2,     2,     2,     3,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     3,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     1,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     3,     2,     2,     2,     2,     2,     2,     2,     3, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            1,     1,     1,     2,     2,     2,     1,     1,     1,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            1,     2,     2,     2,     1,     2,     2,     2,     2,     2, &
                            2,     1,     2,     2,     2,     1,     2,     2,     1,     2, &
                            2,     1,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     1,     2,     2,     1,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     1,     2,     2, &
                            2,     1,     2,     1,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     1,     2,     2,     1,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            3,     2,     2,     3,     2,     2,     3,     2,     2,     2, &
                            2,     2,     2,     3,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     3,     3,     3, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     1,     1,     1,     1,     1,     1, &
                            1,     1,     1,     1,     1,     1,     1,     1,     1,     1, &
                            1,     1,     1,     1,     1,     1,     1,     1,     1,     1, &
                            1,     1,     1,     1,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     1,     2,     1, &
                            1,     1,     1,     2,     2,     2,     1,     1,     2,     2, &
                            2,     1,     1,     2,     1,     1,     1,     1 /)

      end subroutine set_sim_dat

      end module mo_sim_dat
