      module mo_nln_matrix
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only: veclen
      private
      public :: nlnmat
      contains
      subroutine nlnmat01( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,634) = -(rxt(k,409)*y(k,293))
         mat(k,3612) = -rxt(k,409)*y(k,1)
         mat(k,2778) = rxt(k,412)*y(k,234)
         mat(k,1129) = rxt(k,412)*y(k,147)
         mat(k,645) = -(rxt(k,413)*y(k,293))
         mat(k,3613) = -rxt(k,413)*y(k,2)
         mat(k,1130) = rxt(k,410)*y(k,256)
         mat(k,3167) = rxt(k,410)*y(k,234)
         mat(k,1102) = -(rxt(k,585)*y(k,149) + rxt(k,603)*y(k,157) + rxt(k,604) &
                      *y(k,293))
         mat(k,3013) = -rxt(k,585)*y(k,4)
         mat(k,2920) = -rxt(k,603)*y(k,4)
         mat(k,3656) = -rxt(k,604)*y(k,4)
         mat(k,859) = -(rxt(k,605)*y(k,149) + rxt(k,623)*y(k,157) + rxt(k,624) &
                      *y(k,293))
         mat(k,3008) = -rxt(k,605)*y(k,7)
         mat(k,2916) = -rxt(k,623)*y(k,7)
         mat(k,3635) = -rxt(k,624)*y(k,7)
         mat(k,131) = -(rxt(k,544)*y(k,293))
         mat(k,3538) = -rxt(k,544)*y(k,8)
         mat(k,322) = -(rxt(k,547)*y(k,293))
         mat(k,3571) = -rxt(k,547)*y(k,9)
         mat(k,433) = rxt(k,545)*y(k,256)
         mat(k,3143) = rxt(k,545)*y(k,241)
         mat(k,132) = .120_r8*rxt(k,544)*y(k,293)
         mat(k,3539) = .120_r8*rxt(k,544)*y(k,8)
         mat(k,2766) = .500_r8*rxt(k,546)*y(k,241) + .200_r8*rxt(k,573)*y(k,312) &
                      + .060_r8*rxt(k,579)*y(k,314)
         mat(k,434) = .500_r8*rxt(k,546)*y(k,147)
         mat(k,759) = .200_r8*rxt(k,573)*y(k,147)
         mat(k,775) = .060_r8*rxt(k,579)*y(k,147)
         mat(k,2760) = .200_r8*rxt(k,573)*y(k,312) + .200_r8*rxt(k,579)*y(k,314)
         mat(k,757) = .200_r8*rxt(k,573)*y(k,147)
         mat(k,772) = .200_r8*rxt(k,579)*y(k,147)
         mat(k,2763) = .200_r8*rxt(k,573)*y(k,312) + .150_r8*rxt(k,579)*y(k,314)
         mat(k,758) = .200_r8*rxt(k,573)*y(k,147)
         mat(k,774) = .150_r8*rxt(k,579)*y(k,147)
         mat(k,2761) = .210_r8*rxt(k,579)*y(k,314)
         mat(k,773) = .210_r8*rxt(k,579)*y(k,147)
         mat(k,153) = -(rxt(k,414)*y(k,293))
         mat(k,3543) = -rxt(k,414)*y(k,15)
         mat(k,940) = .190_r8*rxt(k,643)*y(k,157)
         mat(k,2905) = .190_r8*rxt(k,643)*y(k,17)
         mat(k,308) = -(rxt(k,375)*y(k,149) + rxt(k,376)*y(k,293))
         mat(k,3005) = -rxt(k,375)*y(k,16)
         mat(k,3569) = -rxt(k,376)*y(k,16)
         mat(k,941) = -(rxt(k,625)*y(k,149) + rxt(k,643)*y(k,157) + rxt(k,644) &
                      *y(k,293))
         mat(k,3010) = -rxt(k,625)*y(k,17)
         mat(k,2917) = -rxt(k,643)*y(k,17)
         mat(k,3642) = -rxt(k,644)*y(k,17)
         mat(k,1685) = -(rxt(k,254)*y(k,43) + rxt(k,255)*y(k,256) + rxt(k,256) &
                      *y(k,157))
         mat(k,3328) = -rxt(k,254)*y(k,18)
         mat(k,3242) = -rxt(k,255)*y(k,18)
         mat(k,2948) = -rxt(k,256)*y(k,18)
         mat(k,3785) = 4.000_r8*rxt(k,257)*y(k,20) + (rxt(k,258)+rxt(k,259))*y(k,60) &
                      + rxt(k,262)*y(k,147) + rxt(k,265)*y(k,156) + rxt(k,800) &
                      *y(k,173) + rxt(k,266)*y(k,293)
         mat(k,3304) = (rxt(k,258)+rxt(k,259))*y(k,20)
         mat(k,1040) = rxt(k,267)*y(k,156) + rxt(k,273)*y(k,292) + rxt(k,268)*y(k,293)
         mat(k,2846) = rxt(k,262)*y(k,20)
         mat(k,3449) = rxt(k,265)*y(k,20) + rxt(k,267)*y(k,83)
         mat(k,1514) = rxt(k,800)*y(k,20)
         mat(k,3099) = rxt(k,273)*y(k,83)
         mat(k,3704) = rxt(k,266)*y(k,20) + rxt(k,268)*y(k,83)
         mat(k,3779) = rxt(k,260)*y(k,60)
         mat(k,3298) = rxt(k,260)*y(k,20)
         mat(k,3758) = (rxt(k,893)+rxt(k,898))*y(k,95)
         mat(k,905) = (rxt(k,893)+rxt(k,898))*y(k,87)
         mat(k,3800) = -(4._r8*rxt(k,257)*y(k,20) + (rxt(k,258) + rxt(k,259) + rxt(k,260) &
                      ) * y(k,60) + rxt(k,261)*y(k,256) + rxt(k,262)*y(k,147) &
                      + rxt(k,263)*y(k,148) + rxt(k,265)*y(k,156) + rxt(k,266) &
                      *y(k,293) + rxt(k,800)*y(k,173))
         mat(k,3319) = -(rxt(k,258) + rxt(k,259) + rxt(k,260)) * y(k,20)
         mat(k,3293) = -rxt(k,261)*y(k,20)
         mat(k,2897) = -rxt(k,262)*y(k,20)
         mat(k,3514) = -rxt(k,263)*y(k,20)
         mat(k,3464) = -rxt(k,265)*y(k,20)
         mat(k,3754) = -rxt(k,266)*y(k,20)
         mat(k,1523) = -rxt(k,800)*y(k,20)
         mat(k,1693) = rxt(k,256)*y(k,157)
         mat(k,497) = rxt(k,264)*y(k,156)
         mat(k,1045) = rxt(k,274)*y(k,292)
         mat(k,911) = rxt(k,269)*y(k,156)
         mat(k,3464) = mat(k,3464) + rxt(k,264)*y(k,21) + rxt(k,269)*y(k,95)
         mat(k,2998) = rxt(k,256)*y(k,18)
         mat(k,3114) = rxt(k,274)*y(k,83)
         mat(k,490) = -(rxt(k,264)*y(k,156))
         mat(k,3439) = -rxt(k,264)*y(k,21)
         mat(k,3781) = rxt(k,263)*y(k,148)
         mat(k,3476) = rxt(k,263)*y(k,20)
         mat(k,198) = -(rxt(k,548)*y(k,293))
         mat(k,3550) = -rxt(k,548)*y(k,23)
         mat(k,2758) = rxt(k,551)*y(k,246)
         mat(k,356) = rxt(k,551)*y(k,147)
         mat(k,286) = -(rxt(k,550)*y(k,293))
         mat(k,3565) = -rxt(k,550)*y(k,24)
         mat(k,357) = rxt(k,549)*y(k,256)
         mat(k,3140) = rxt(k,549)*y(k,246)
         mat(k,253) = -(rxt(k,321)*y(k,57) + rxt(k,322)*y(k,293))
         mat(k,3804) = -rxt(k,321)*y(k,25)
         mat(k,3561) = -rxt(k,322)*y(k,25)
         mat(k,498) = -(rxt(k,323)*y(k,57) + rxt(k,324)*y(k,157) + rxt(k,351)*y(k,293))
         mat(k,3806) = -rxt(k,323)*y(k,26)
         mat(k,2908) = -rxt(k,324)*y(k,26)
         mat(k,3596) = -rxt(k,351)*y(k,26)
         mat(k,218) = -(rxt(k,329)*y(k,293))
         mat(k,3556) = -rxt(k,329)*y(k,27)
         mat(k,1241) = .800_r8*rxt(k,325)*y(k,247) + .200_r8*rxt(k,326)*y(k,251)
         mat(k,3347) = .200_r8*rxt(k,326)*y(k,247)
         mat(k,291) = -(rxt(k,330)*y(k,293))
         mat(k,3566) = -rxt(k,330)*y(k,28)
         mat(k,1242) = rxt(k,327)*y(k,256)
         mat(k,3141) = rxt(k,327)*y(k,247)
         mat(k,259) = -(rxt(k,331)*y(k,57) + rxt(k,332)*y(k,293))
         mat(k,3805) = -rxt(k,331)*y(k,29)
         mat(k,3562) = -rxt(k,332)*y(k,29)
         mat(k,1197) = -(rxt(k,354)*y(k,149) + rxt(k,355)*y(k,157) + rxt(k,373) &
                      *y(k,293))
         mat(k,3019) = -rxt(k,354)*y(k,30)
         mat(k,2927) = -rxt(k,355)*y(k,30)
         mat(k,3666) = -rxt(k,373)*y(k,30)
         mat(k,338) = -(rxt(k,359)*y(k,293))
         mat(k,3573) = -rxt(k,359)*y(k,31)
         mat(k,974) = rxt(k,357)*y(k,256)
         mat(k,3145) = rxt(k,357)*y(k,248)
         mat(k,112) = -(rxt(k,360)*y(k,293))
         mat(k,3536) = -rxt(k,360)*y(k,32)
         mat(k,222) = -(rxt(k,554)*y(k,293))
         mat(k,3557) = -rxt(k,554)*y(k,33)
         mat(k,602) = rxt(k,552)*y(k,256)
         mat(k,3134) = rxt(k,552)*y(k,249)
         mat(k,3337) = -(rxt(k,218)*y(k,57) + rxt(k,254)*y(k,18) + rxt(k,298)*y(k,256) &
                      + rxt(k,299)*y(k,149) + rxt(k,300)*y(k,156) + rxt(k,301) &
                      *y(k,293))
         mat(k,3829) = -rxt(k,218)*y(k,43)
         mat(k,1690) = -rxt(k,254)*y(k,43)
         mat(k,3287) = -rxt(k,298)*y(k,43)
         mat(k,3084) = -rxt(k,299)*y(k,43)
         mat(k,3458) = -rxt(k,300)*y(k,43)
         mat(k,3748) = -rxt(k,301)*y(k,43)
         mat(k,641) = .400_r8*rxt(k,409)*y(k,293)
         mat(k,1116) = .270_r8*rxt(k,603)*y(k,157)
         mat(k,869) = .080_r8*rxt(k,623)*y(k,157)
         mat(k,313) = .500_r8*rxt(k,375)*y(k,149)
         mat(k,952) = .810_r8*rxt(k,643)*y(k,157)
         mat(k,504) = rxt(k,324)*y(k,157)
         mat(k,1206) = .500_r8*rxt(k,355)*y(k,157)
         mat(k,470) = .500_r8*rxt(k,341)*y(k,293)
         mat(k,1358) = rxt(k,306)*y(k,293)
         mat(k,372) = .300_r8*rxt(k,307)*y(k,293)
         mat(k,3313) = rxt(k,225)*y(k,251)
         mat(k,1472) = .800_r8*rxt(k,346)*y(k,293)
         mat(k,725) = .110_r8*rxt(k,348)*y(k,293)
         mat(k,1121) = .500_r8*rxt(k,312)*y(k,293)
         mat(k,810) = .300_r8*rxt(k,364)*y(k,293)
         mat(k,1240) = .500_r8*rxt(k,420)*y(k,293)
         mat(k,416) = .400_r8*rxt(k,423)*y(k,293)
         mat(k,1092) = .590_r8*rxt(k,424)*y(k,293)
         mat(k,1301) = 1.010_r8*rxt(k,487)*y(k,157)
         mat(k,972) = .330_r8*rxt(k,663)*y(k,157)
         mat(k,1760) = .120_r8*rxt(k,386)*y(k,157)
         mat(k,1871) = .600_r8*rxt(k,404)*y(k,157)
         mat(k,719) = .390_r8*rxt(k,683)*y(k,157)
         mat(k,2891) = .100_r8*rxt(k,411)*y(k,234) + .210_r8*rxt(k,598)*y(k,236) &
                      + .020_r8*rxt(k,630)*y(k,243) + .490_r8*rxt(k,638)*y(k,244) &
                      + rxt(k,305)*y(k,251) + .500_r8*rxt(k,378)*y(k,253) &
                      + .500_r8*rxt(k,343)*y(k,255) + rxt(k,506)*y(k,259) + rxt(k,508) &
                      *y(k,260) + .060_r8*rxt(k,514)*y(k,267) + .270_r8*rxt(k,516) &
                      *y(k,268) + rxt(k,518)*y(k,269) + .130_r8*rxt(k,520)*y(k,270) &
                      + .330_r8*rxt(k,522)*y(k,271) + .460_r8*rxt(k,524)*y(k,272) &
                      + .530_r8*rxt(k,526)*y(k,273) + .040_r8*rxt(k,528)*y(k,274) &
                      + .430_r8*rxt(k,658)*y(k,280) + .140_r8*rxt(k,536)*y(k,282) &
                      + rxt(k,393)*y(k,284) + .240_r8*rxt(k,538)*y(k,287) &
                      + .040_r8*rxt(k,670)*y(k,288) + .300_r8*rxt(k,678)*y(k,289) &
                      + rxt(k,367)*y(k,295) + rxt(k,371)*y(k,296) + .310_r8*rxt(k,689) &
                      *y(k,297) + 1.820_r8*rxt(k,742)*y(k,304) + .310_r8*rxt(k,762) &
                      *y(k,306)
         mat(k,3084) = mat(k,3084) + .500_r8*rxt(k,375)*y(k,16) + .440_r8*rxt(k,760) &
                      *y(k,210) + .500_r8*rxt(k,765)*y(k,211) + .270_r8*rxt(k,599) &
                      *y(k,236) + .020_r8*rxt(k,631)*y(k,243) + .650_r8*rxt(k,639) &
                      *y(k,244) + .460_r8*rxt(k,479)*y(k,272) + .560_r8*rxt(k,659) &
                      *y(k,280) + rxt(k,394)*y(k,284) + .040_r8*rxt(k,671)*y(k,288) &
                      + .420_r8*rxt(k,679)*y(k,289) + 2.000_r8*rxt(k,743)*y(k,304)
         mat(k,1273) = rxt(k,349)*y(k,293)
         mat(k,2992) = .270_r8*rxt(k,603)*y(k,4) + .080_r8*rxt(k,623)*y(k,7) &
                      + .810_r8*rxt(k,643)*y(k,17) + rxt(k,324)*y(k,26) &
                      + .500_r8*rxt(k,355)*y(k,30) + 1.010_r8*rxt(k,487)*y(k,109) &
                      + .330_r8*rxt(k,663)*y(k,125) + .120_r8*rxt(k,386)*y(k,126) &
                      + .600_r8*rxt(k,404)*y(k,132) + .390_r8*rxt(k,683)*y(k,135) &
                      + .620_r8*rxt(k,763)*y(k,210) + .340_r8*rxt(k,768)*y(k,211)
         mat(k,401) = rxt(k,350)*y(k,293)
         mat(k,511) = 2.000_r8*rxt(k,719)*y(k,293)
         mat(k,519) = rxt(k,738)*y(k,293)
         mat(k,2432) = .440_r8*rxt(k,760)*y(k,149) + .620_r8*rxt(k,763)*y(k,157)
         mat(k,2405) = .500_r8*rxt(k,765)*y(k,149) + .340_r8*rxt(k,768)*y(k,157)
         mat(k,1139) = .100_r8*rxt(k,411)*y(k,147)
         mat(k,2132) = .950_r8*rxt(k,588)*y(k,251)
         mat(k,2228) = .210_r8*rxt(k,598)*y(k,147) + .270_r8*rxt(k,599)*y(k,149) &
                      + .270_r8*rxt(k,595)*y(k,250) + .830_r8*rxt(k,596)*y(k,251) &
                      + .080_r8*rxt(k,597)*y(k,256) + .270_r8*rxt(k,600)*y(k,300) &
                      + .270_r8*rxt(k,601)*y(k,302) + .270_r8*rxt(k,602)*y(k,305)
         mat(k,2065) = .950_r8*rxt(k,608)*y(k,251)
         mat(k,2110) = .750_r8*rxt(k,616)*y(k,251)
         mat(k,2345) = .020_r8*rxt(k,630)*y(k,147) + .020_r8*rxt(k,631)*y(k,149) &
                      + .080_r8*rxt(k,626)*y(k,243) + .020_r8*rxt(k,627)*y(k,250) &
                      + .990_r8*rxt(k,628)*y(k,251) + .020_r8*rxt(k,629)*y(k,256) &
                      + .020_r8*rxt(k,632)*y(k,300) + .020_r8*rxt(k,633)*y(k,302) &
                      + .020_r8*rxt(k,634)*y(k,305)
         mat(k,2257) = .490_r8*rxt(k,638)*y(k,147) + .650_r8*rxt(k,639)*y(k,149) &
                      + .650_r8*rxt(k,635)*y(k,250) + 1.400_r8*rxt(k,636)*y(k,251) &
                      + .030_r8*rxt(k,637)*y(k,256) + .650_r8*rxt(k,640)*y(k,300) &
                      + .650_r8*rxt(k,641)*y(k,302) + .650_r8*rxt(k,642)*y(k,305)
         mat(k,1248) = .700_r8*rxt(k,326)*y(k,251)
         mat(k,980) = rxt(k,356)*y(k,251)
         mat(k,2706) = .270_r8*rxt(k,595)*y(k,236) + .020_r8*rxt(k,627)*y(k,243) &
                      + .650_r8*rxt(k,635)*y(k,244) + rxt(k,337)*y(k,251) + rxt(k,425) &
                      *y(k,259) + rxt(k,431)*y(k,260) + .460_r8*rxt(k,475)*y(k,272) &
                      + .560_r8*rxt(k,655)*y(k,280) + .140_r8*rxt(k,382)*y(k,282) &
                      + rxt(k,389)*y(k,284) + .250_r8*rxt(k,401)*y(k,287) &
                      + .040_r8*rxt(k,666)*y(k,288) + .420_r8*rxt(k,675)*y(k,289) &
                      + 2.000_r8*rxt(k,739)*y(k,304)
         mat(k,3428) = rxt(k,225)*y(k,60) + rxt(k,305)*y(k,147) + .950_r8*rxt(k,588) &
                      *y(k,235) + .830_r8*rxt(k,596)*y(k,236) + .950_r8*rxt(k,608) &
                      *y(k,238) + .750_r8*rxt(k,616)*y(k,239) + .990_r8*rxt(k,628) &
                      *y(k,243) + 1.400_r8*rxt(k,636)*y(k,244) + .700_r8*rxt(k,326) &
                      *y(k,247) + rxt(k,356)*y(k,248) + rxt(k,337)*y(k,250) + ( &
                      + 4.000_r8*rxt(k,302)+2.000_r8*rxt(k,303))*y(k,251) &
                      + 1.750_r8*rxt(k,426)*y(k,259) + 1.250_r8*rxt(k,432)*y(k,260) &
                      + .750_r8*rxt(k,446)*y(k,265) + .750_r8*rxt(k,450)*y(k,266) &
                      + .710_r8*rxt(k,476)*y(k,272) + .750_r8*rxt(k,493)*y(k,276) &
                      + .750_r8*rxt(k,497)*y(k,277) + .910_r8*rxt(k,647)*y(k,279) &
                      + 1.030_r8*rxt(k,656)*y(k,280) + 1.100_r8*rxt(k,383)*y(k,282) &
                      + 2.000_r8*rxt(k,390)*y(k,284) + .870_r8*rxt(k,402)*y(k,287) &
                      + .980_r8*rxt(k,667)*y(k,288) + .750_r8*rxt(k,676)*y(k,289) &
                      + .800_r8*rxt(k,369)*y(k,296) + .750_r8*rxt(k,695)*y(k,299) &
                      + rxt(k,703)*y(k,300) + rxt(k,711)*y(k,301) + rxt(k,721) &
                      *y(k,302) + rxt(k,730)*y(k,303) + 3.000_r8*rxt(k,740)*y(k,304) &
                      + rxt(k,751)*y(k,305)
         mat(k,540) = .500_r8*rxt(k,378)*y(k,147)
         mat(k,748) = .500_r8*rxt(k,343)*y(k,147)
         mat(k,3287) = mat(k,3287) + .080_r8*rxt(k,597)*y(k,236) + .020_r8*rxt(k,629) &
                      *y(k,243) + .030_r8*rxt(k,637)*y(k,244) + .060_r8*rxt(k,427) &
                      *y(k,259) + .060_r8*rxt(k,433)*y(k,260) + .030_r8*rxt(k,458) &
                      *y(k,267) + .060_r8*rxt(k,462)*y(k,268) + .600_r8*rxt(k,465) &
                      *y(k,269) + .060_r8*rxt(k,468)*y(k,270) + .100_r8*rxt(k,472) &
                      *y(k,271) + .240_r8*rxt(k,477)*y(k,272) + .170_r8*rxt(k,480) &
                      *y(k,273) + .030_r8*rxt(k,483)*y(k,274) + .060_r8*rxt(k,657) &
                      *y(k,280) + .080_r8*rxt(k,384)*y(k,282) + .490_r8*rxt(k,391) &
                      *y(k,284) + .050_r8*rxt(k,403)*y(k,287) + .020_r8*rxt(k,668) &
                      *y(k,288) + .040_r8*rxt(k,677)*y(k,289) + .150_r8*rxt(k,370) &
                      *y(k,296) + .080_r8*rxt(k,688)*y(k,297) + 1.060_r8*rxt(k,741) &
                      *y(k,304) + .040_r8*rxt(k,761)*y(k,306)
         mat(k,1839) = rxt(k,506)*y(k,147) + rxt(k,425)*y(k,250) + 1.750_r8*rxt(k,426) &
                      *y(k,251) + .060_r8*rxt(k,427)*y(k,256)
         mat(k,1741) = rxt(k,508)*y(k,147) + rxt(k,431)*y(k,250) + 1.250_r8*rxt(k,432) &
                      *y(k,251) + .060_r8*rxt(k,433)*y(k,256)
         mat(k,1561) = .750_r8*rxt(k,446)*y(k,251)
         mat(k,1582) = .750_r8*rxt(k,450)*y(k,251)
         mat(k,1007) = .060_r8*rxt(k,514)*y(k,147) + .030_r8*rxt(k,458)*y(k,256)
         mat(k,1080) = .270_r8*rxt(k,516)*y(k,147) + .060_r8*rxt(k,462)*y(k,256)
         mat(k,992) = rxt(k,518)*y(k,147) + .600_r8*rxt(k,465)*y(k,256)
         mat(k,1018) = .130_r8*rxt(k,520)*y(k,147) + .060_r8*rxt(k,468)*y(k,256)
         mat(k,1326) = .330_r8*rxt(k,522)*y(k,147) + .100_r8*rxt(k,472)*y(k,256)
         mat(k,2043) = .460_r8*rxt(k,524)*y(k,147) + .460_r8*rxt(k,479)*y(k,149) &
                      + .460_r8*rxt(k,475)*y(k,250) + .710_r8*rxt(k,476)*y(k,251) &
                      + .240_r8*rxt(k,477)*y(k,256) + .320_r8*rxt(k,478)*y(k,272)
         mat(k,1191) = .530_r8*rxt(k,526)*y(k,147) + .170_r8*rxt(k,480)*y(k,256)
         mat(k,1267) = .040_r8*rxt(k,528)*y(k,147) + .030_r8*rxt(k,483)*y(k,256)
         mat(k,1791) = .750_r8*rxt(k,493)*y(k,251)
         mat(k,1679) = .750_r8*rxt(k,497)*y(k,251)
         mat(k,2318) = .910_r8*rxt(k,647)*y(k,251)
         mat(k,2171) = .430_r8*rxt(k,658)*y(k,147) + .560_r8*rxt(k,659)*y(k,149) &
                      + .560_r8*rxt(k,655)*y(k,250) + 1.030_r8*rxt(k,656)*y(k,251) &
                      + .060_r8*rxt(k,657)*y(k,256) + .560_r8*rxt(k,660)*y(k,300) &
                      + .560_r8*rxt(k,661)*y(k,302) + .560_r8*rxt(k,662)*y(k,305)
         mat(k,1392) = .140_r8*rxt(k,536)*y(k,147) + .140_r8*rxt(k,382)*y(k,250) &
                      + 1.100_r8*rxt(k,383)*y(k,251) + .080_r8*rxt(k,384)*y(k,256)
         mat(k,1505) = rxt(k,393)*y(k,147) + rxt(k,394)*y(k,149) + rxt(k,389)*y(k,250) &
                      + 2.000_r8*rxt(k,390)*y(k,251) + .490_r8*rxt(k,391)*y(k,256) &
                      + 4.000_r8*rxt(k,392)*y(k,284)
         mat(k,1378) = .240_r8*rxt(k,538)*y(k,147) + .250_r8*rxt(k,401)*y(k,250) &
                      + .870_r8*rxt(k,402)*y(k,251) + .050_r8*rxt(k,403)*y(k,256)
         mat(k,2379) = .040_r8*rxt(k,670)*y(k,147) + .040_r8*rxt(k,671)*y(k,149) &
                      + .040_r8*rxt(k,666)*y(k,250) + .980_r8*rxt(k,667)*y(k,251) &
                      + .020_r8*rxt(k,668)*y(k,256) + .120_r8*rxt(k,669)*y(k,288) &
                      + .040_r8*rxt(k,672)*y(k,300) + .040_r8*rxt(k,673)*y(k,302) &
                      + .040_r8*rxt(k,674)*y(k,305)
         mat(k,2286) = .300_r8*rxt(k,678)*y(k,147) + .420_r8*rxt(k,679)*y(k,149) &
                      + .420_r8*rxt(k,675)*y(k,250) + .750_r8*rxt(k,676)*y(k,251) &
                      + .040_r8*rxt(k,677)*y(k,256) + .420_r8*rxt(k,680)*y(k,300) &
                      + .420_r8*rxt(k,681)*y(k,302) + .420_r8*rxt(k,682)*y(k,305)
         mat(k,3748) = mat(k,3748) + .400_r8*rxt(k,409)*y(k,1) + .500_r8*rxt(k,341) &
                      *y(k,52) + rxt(k,306)*y(k,53) + .300_r8*rxt(k,307)*y(k,54) &
                      + .800_r8*rxt(k,346)*y(k,76) + .110_r8*rxt(k,348)*y(k,89) &
                      + .500_r8*rxt(k,312)*y(k,92) + .300_r8*rxt(k,364)*y(k,104) &
                      + .500_r8*rxt(k,420)*y(k,105) + .400_r8*rxt(k,423)*y(k,107) &
                      + .590_r8*rxt(k,424)*y(k,108) + rxt(k,349)*y(k,150) + rxt(k,350) &
                      *y(k,162) + 2.000_r8*rxt(k,719)*y(k,202) + rxt(k,738)*y(k,204)
         mat(k,827) = rxt(k,367)*y(k,147)
         mat(k,1231) = rxt(k,371)*y(k,147) + .800_r8*rxt(k,369)*y(k,251) &
                      + .150_r8*rxt(k,370)*y(k,256)
         mat(k,840) = .310_r8*rxt(k,689)*y(k,147) + .080_r8*rxt(k,688)*y(k,256)
         mat(k,2457) = .750_r8*rxt(k,695)*y(k,251)
         mat(k,2542) = .270_r8*rxt(k,600)*y(k,236) + .020_r8*rxt(k,632)*y(k,243) &
                      + .650_r8*rxt(k,640)*y(k,244) + rxt(k,703)*y(k,251) &
                      + .560_r8*rxt(k,660)*y(k,280) + .040_r8*rxt(k,672)*y(k,288) &
                      + .420_r8*rxt(k,680)*y(k,289) + 2.000_r8*rxt(k,744)*y(k,304)
         mat(k,2499) = rxt(k,711)*y(k,251)
         mat(k,2588) = .270_r8*rxt(k,601)*y(k,236) + .020_r8*rxt(k,633)*y(k,243) &
                      + .650_r8*rxt(k,641)*y(k,244) + rxt(k,721)*y(k,251) &
                      + .560_r8*rxt(k,661)*y(k,280) + .040_r8*rxt(k,673)*y(k,288) &
                      + .420_r8*rxt(k,681)*y(k,289) + 2.000_r8*rxt(k,745)*y(k,304)
         mat(k,2087) = rxt(k,730)*y(k,251)
         mat(k,2478) = 1.820_r8*rxt(k,742)*y(k,147) + 2.000_r8*rxt(k,743)*y(k,149) &
                      + 2.000_r8*rxt(k,739)*y(k,250) + 3.000_r8*rxt(k,740)*y(k,251) &
                      + 1.060_r8*rxt(k,741)*y(k,256) + 2.000_r8*rxt(k,744)*y(k,300) &
                      + 2.000_r8*rxt(k,745)*y(k,302) + 2.000_r8*rxt(k,746)*y(k,305)
         mat(k,2635) = .270_r8*rxt(k,602)*y(k,236) + .020_r8*rxt(k,634)*y(k,243) &
                      + .650_r8*rxt(k,642)*y(k,244) + rxt(k,751)*y(k,251) &
                      + .560_r8*rxt(k,662)*y(k,280) + .040_r8*rxt(k,674)*y(k,288) &
                      + .420_r8*rxt(k,682)*y(k,289) + 2.000_r8*rxt(k,746)*y(k,304)
         mat(k,685) = .310_r8*rxt(k,762)*y(k,147) + .040_r8*rxt(k,761)*y(k,256)
      end do
      end subroutine nlnmat01
      subroutine nlnmat02( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,1305) = -(rxt(k,333)*y(k,149) + rxt(k,334)*y(k,293))
         mat(k,3022) = -rxt(k,333)*y(k,46)
         mat(k,3674) = -rxt(k,334)*y(k,46)
         mat(k,637) = .800_r8*rxt(k,409)*y(k,293)
         mat(k,310) = rxt(k,375)*y(k,149)
         mat(k,219) = rxt(k,329)*y(k,293)
         mat(k,293) = .500_r8*rxt(k,330)*y(k,293)
         mat(k,1198) = .500_r8*rxt(k,355)*y(k,157)
         mat(k,1855) = .100_r8*rxt(k,404)*y(k,157)
         mat(k,2820) = .400_r8*rxt(k,411)*y(k,234) + rxt(k,328)*y(k,247) &
                      + .270_r8*rxt(k,358)*y(k,248) + rxt(k,378)*y(k,253) + rxt(k,396) &
                      *y(k,286) + rxt(k,367)*y(k,295)
         mat(k,3022) = mat(k,3022) + rxt(k,375)*y(k,16)
         mat(k,2931) = .500_r8*rxt(k,355)*y(k,30) + .100_r8*rxt(k,404)*y(k,132)
         mat(k,1134) = .400_r8*rxt(k,411)*y(k,147)
         mat(k,1244) = rxt(k,328)*y(k,147) + 3.200_r8*rxt(k,325)*y(k,247) &
                      + .800_r8*rxt(k,326)*y(k,251)
         mat(k,976) = .270_r8*rxt(k,358)*y(k,147)
         mat(k,3359) = .800_r8*rxt(k,326)*y(k,247)
         mat(k,536) = rxt(k,378)*y(k,147)
         mat(k,3213) = .200_r8*rxt(k,395)*y(k,286)
         mat(k,657) = rxt(k,396)*y(k,147) + .200_r8*rxt(k,395)*y(k,256)
         mat(k,3674) = mat(k,3674) + .800_r8*rxt(k,409)*y(k,1) + rxt(k,329)*y(k,27) &
                      + .500_r8*rxt(k,330)*y(k,28)
         mat(k,823) = rxt(k,367)*y(k,147)
         mat(k,106) = -(rxt(k,335)*y(k,293))
         mat(k,3535) = -rxt(k,335)*y(k,48)
         mat(k,2141) = -(rxt(k,374)*y(k,293))
         mat(k,3721) = -rxt(k,374)*y(k,49)
         mat(k,638) = .800_r8*rxt(k,409)*y(k,293)
         mat(k,311) = .500_r8*rxt(k,375)*y(k,149)
         mat(k,712) = .250_r8*rxt(k,683)*y(k,157)
         mat(k,2864) = .250_r8*rxt(k,411)*y(k,234) + .090_r8*rxt(k,598)*y(k,236) &
                      + .080_r8*rxt(k,638)*y(k,244) + .820_r8*rxt(k,358)*y(k,248) &
                      + .500_r8*rxt(k,378)*y(k,253) + .850_r8*rxt(k,670)*y(k,288) &
                      + .330_r8*rxt(k,678)*y(k,289) + .700_r8*rxt(k,732)*y(k,303)
         mat(k,3057) = .500_r8*rxt(k,375)*y(k,16) + .120_r8*rxt(k,599)*y(k,236) &
                      + .110_r8*rxt(k,639)*y(k,244) + .910_r8*rxt(k,671)*y(k,288) &
                      + .460_r8*rxt(k,679)*y(k,289) + rxt(k,733)*y(k,303)
         mat(k,2965) = .250_r8*rxt(k,683)*y(k,135)
         mat(k,508) = rxt(k,719)*y(k,293)
         mat(k,1135) = .250_r8*rxt(k,411)*y(k,147)
         mat(k,2211) = .090_r8*rxt(k,598)*y(k,147) + .120_r8*rxt(k,599)*y(k,149) &
                      + .120_r8*rxt(k,595)*y(k,250) + .060_r8*rxt(k,596)*y(k,251) &
                      + .060_r8*rxt(k,597)*y(k,256) + .120_r8*rxt(k,600)*y(k,300) &
                      + .120_r8*rxt(k,601)*y(k,302) + .120_r8*rxt(k,602)*y(k,305)
         mat(k,2240) = .080_r8*rxt(k,638)*y(k,147) + .110_r8*rxt(k,639)*y(k,149) &
                      + .110_r8*rxt(k,635)*y(k,250) + .080_r8*rxt(k,636)*y(k,251) &
                      + .110_r8*rxt(k,640)*y(k,300) + .110_r8*rxt(k,641)*y(k,302) &
                      + .110_r8*rxt(k,642)*y(k,305)
         mat(k,977) = .820_r8*rxt(k,358)*y(k,147) + .820_r8*rxt(k,356)*y(k,251)
         mat(k,2681) = .120_r8*rxt(k,595)*y(k,236) + .110_r8*rxt(k,635)*y(k,244) &
                      + .910_r8*rxt(k,666)*y(k,288) + .460_r8*rxt(k,675)*y(k,289) &
                      + rxt(k,729)*y(k,303)
         mat(k,3401) = .060_r8*rxt(k,596)*y(k,236) + .080_r8*rxt(k,636)*y(k,244) &
                      + .820_r8*rxt(k,356)*y(k,248) + .100_r8*rxt(k,383)*y(k,282) &
                      + .740_r8*rxt(k,667)*y(k,288) + rxt(k,730)*y(k,303)
         mat(k,537) = .500_r8*rxt(k,378)*y(k,147)
         mat(k,3260) = .060_r8*rxt(k,597)*y(k,236) + .460_r8*rxt(k,668)*y(k,288) &
                      + .050_r8*rxt(k,677)*y(k,289) + .150_r8*rxt(k,731)*y(k,303)
         mat(k,1388) = .100_r8*rxt(k,383)*y(k,251)
         mat(k,2361) = .850_r8*rxt(k,670)*y(k,147) + .910_r8*rxt(k,671)*y(k,149) &
                      + .910_r8*rxt(k,666)*y(k,250) + .740_r8*rxt(k,667)*y(k,251) &
                      + .460_r8*rxt(k,668)*y(k,256) + 2.960_r8*rxt(k,669)*y(k,288) &
                      + .910_r8*rxt(k,672)*y(k,300) + .910_r8*rxt(k,673)*y(k,302) &
                      + .910_r8*rxt(k,674)*y(k,305)
         mat(k,2268) = .330_r8*rxt(k,678)*y(k,147) + .460_r8*rxt(k,679)*y(k,149) &
                      + .460_r8*rxt(k,675)*y(k,250) + .050_r8*rxt(k,677)*y(k,256) &
                      + .460_r8*rxt(k,680)*y(k,300) + .460_r8*rxt(k,681)*y(k,302) &
                      + .460_r8*rxt(k,682)*y(k,305)
         mat(k,3721) = mat(k,3721) + .800_r8*rxt(k,409)*y(k,1) + rxt(k,719)*y(k,202)
         mat(k,2517) = .120_r8*rxt(k,600)*y(k,236) + .110_r8*rxt(k,640)*y(k,244) &
                      + .910_r8*rxt(k,672)*y(k,288) + .460_r8*rxt(k,680)*y(k,289) &
                      + rxt(k,734)*y(k,303)
         mat(k,2563) = .120_r8*rxt(k,601)*y(k,236) + .110_r8*rxt(k,641)*y(k,244) &
                      + .910_r8*rxt(k,673)*y(k,288) + .460_r8*rxt(k,681)*y(k,289) &
                      + rxt(k,735)*y(k,303)
         mat(k,2073) = .700_r8*rxt(k,732)*y(k,147) + rxt(k,733)*y(k,149) + rxt(k,729) &
                      *y(k,250) + rxt(k,730)*y(k,251) + .150_r8*rxt(k,731)*y(k,256) &
                      + rxt(k,734)*y(k,300) + rxt(k,735)*y(k,302) + rxt(k,736) &
                      *y(k,305)
         mat(k,2610) = .120_r8*rxt(k,602)*y(k,236) + .110_r8*rxt(k,642)*y(k,244) &
                      + .910_r8*rxt(k,674)*y(k,288) + .460_r8*rxt(k,682)*y(k,289) &
                      + rxt(k,736)*y(k,303)
         mat(k,1845) = -(rxt(k,361)*y(k,149) + rxt(k,362)*y(k,293))
         mat(k,3046) = -rxt(k,361)*y(k,50)
         mat(k,3711) = -rxt(k,362)*y(k,50)
         mat(k,548) = .380_r8*rxt(k,415)*y(k,293)
         mat(k,561) = .030_r8*rxt(k,416)*y(k,293)
         mat(k,1612) = rxt(k,363)*y(k,293)
         mat(k,1702) = .460_r8*rxt(k,419)*y(k,293)
         mat(k,808) = .700_r8*rxt(k,364)*y(k,293)
         mat(k,1239) = .500_r8*rxt(k,420)*y(k,293)
         mat(k,413) = .400_r8*rxt(k,423)*y(k,293)
         mat(k,668) = .720_r8*rxt(k,457)*y(k,293)
         mat(k,1929) = .170_r8*rxt(k,460)*y(k,157)
         mat(k,1963) = .170_r8*rxt(k,470)*y(k,157)
         mat(k,1448) = .170_r8*rxt(k,485)*y(k,157)
         mat(k,1752) = .880_r8*rxt(k,386)*y(k,157)
         mat(k,1862) = .500_r8*rxt(k,404)*y(k,157)
         mat(k,1363) = .440_r8*rxt(k,406)*y(k,293)
         mat(k,1992) = .340_r8*rxt(k,502)*y(k,157)
         mat(k,2853) = .170_r8*rxt(k,557)*y(k,252) + .710_r8*rxt(k,504)*y(k,258) &
                      + .140_r8*rxt(k,536)*y(k,282) + .170_r8*rxt(k,563)*y(k,285) &
                      + .240_r8*rxt(k,538)*y(k,287) + .120_r8*rxt(k,540)*y(k,291) &
                      + .400_r8*rxt(k,573)*y(k,312) + .540_r8*rxt(k,579)*y(k,314) &
                      + .510_r8*rxt(k,582)*y(k,316)
         mat(k,1344) = rxt(k,365)*y(k,293)
         mat(k,2955) = .170_r8*rxt(k,460)*y(k,115) + .170_r8*rxt(k,470)*y(k,118) &
                      + .170_r8*rxt(k,485)*y(k,121) + .880_r8*rxt(k,386)*y(k,126) &
                      + .500_r8*rxt(k,404)*y(k,132) + .340_r8*rxt(k,502)*y(k,139)
         mat(k,2670) = .140_r8*rxt(k,382)*y(k,282) + .250_r8*rxt(k,401)*y(k,287)
         mat(k,3390) = .120_r8*rxt(k,402)*y(k,287) + .500_r8*rxt(k,369)*y(k,296)
         mat(k,791) = .170_r8*rxt(k,557)*y(k,147) + .070_r8*rxt(k,556)*y(k,256)
         mat(k,3249) = .070_r8*rxt(k,556)*y(k,252) + .460_r8*rxt(k,422)*y(k,258) &
                      + .080_r8*rxt(k,384)*y(k,282) + .070_r8*rxt(k,562)*y(k,285) &
                      + .050_r8*rxt(k,403)*y(k,287) + .100_r8*rxt(k,500)*y(k,291)
         mat(k,1409) = .710_r8*rxt(k,504)*y(k,147) + .460_r8*rxt(k,422)*y(k,256)
         mat(k,1387) = .140_r8*rxt(k,536)*y(k,147) + .140_r8*rxt(k,382)*y(k,250) &
                      + .080_r8*rxt(k,384)*y(k,256)
         mat(k,815) = .170_r8*rxt(k,563)*y(k,147) + .070_r8*rxt(k,562)*y(k,256)
         mat(k,1374) = .240_r8*rxt(k,538)*y(k,147) + .250_r8*rxt(k,401)*y(k,250) &
                      + .120_r8*rxt(k,402)*y(k,251) + .050_r8*rxt(k,403)*y(k,256)
         mat(k,1486) = .120_r8*rxt(k,540)*y(k,147) + .100_r8*rxt(k,500)*y(k,256)
         mat(k,3711) = mat(k,3711) + .380_r8*rxt(k,415)*y(k,98) + .030_r8*rxt(k,416) &
                      *y(k,99) + rxt(k,363)*y(k,102) + .460_r8*rxt(k,419)*y(k,103) &
                      + .700_r8*rxt(k,364)*y(k,104) + .500_r8*rxt(k,420)*y(k,105) &
                      + .400_r8*rxt(k,423)*y(k,107) + .720_r8*rxt(k,457)*y(k,114) &
                      + .440_r8*rxt(k,406)*y(k,134) + rxt(k,365)*y(k,151)
         mat(k,1227) = .500_r8*rxt(k,369)*y(k,251)
         mat(k,767) = .400_r8*rxt(k,573)*y(k,147)
         mat(k,783) = .540_r8*rxt(k,579)*y(k,147)
         mat(k,445) = .510_r8*rxt(k,582)*y(k,147)
         mat(k,530) = -(rxt(k,340)*y(k,293))
         mat(k,3601) = -rxt(k,340)*y(k,51)
         mat(k,1194) = .120_r8*rxt(k,355)*y(k,157)
         mat(k,2910) = .120_r8*rxt(k,355)*y(k,30)
         mat(k,2645) = .100_r8*rxt(k,337)*y(k,251) + .150_r8*rxt(k,338)*y(k,256)
         mat(k,3349) = .100_r8*rxt(k,337)*y(k,250)
         mat(k,3161) = .150_r8*rxt(k,338)*y(k,250) + .150_r8*rxt(k,391)*y(k,284)
         mat(k,1496) = .150_r8*rxt(k,391)*y(k,256)
         mat(k,468) = -(rxt(k,341)*y(k,293))
         mat(k,3593) = -rxt(k,341)*y(k,52)
         mat(k,2644) = .360_r8*rxt(k,338)*y(k,256)
         mat(k,3157) = .360_r8*rxt(k,338)*y(k,250) + .360_r8*rxt(k,391)*y(k,284)
         mat(k,1495) = .360_r8*rxt(k,391)*y(k,256)
         mat(k,1356) = -(rxt(k,306)*y(k,293))
         mat(k,3680) = -rxt(k,306)*y(k,53)
         mat(k,2116) = .050_r8*rxt(k,588)*y(k,251)
         mat(k,2205) = .170_r8*rxt(k,596)*y(k,251)
         mat(k,2052) = .050_r8*rxt(k,608)*y(k,251)
         mat(k,2094) = .250_r8*rxt(k,616)*y(k,251)
         mat(k,2327) = .030_r8*rxt(k,628)*y(k,251)
         mat(k,1245) = .300_r8*rxt(k,326)*y(k,251)
         mat(k,3364) = .050_r8*rxt(k,588)*y(k,235) + .170_r8*rxt(k,596)*y(k,236) &
                      + .050_r8*rxt(k,608)*y(k,238) + .250_r8*rxt(k,616)*y(k,239) &
                      + .030_r8*rxt(k,628)*y(k,243) + .300_r8*rxt(k,326)*y(k,247) &
                      + 2.000_r8*rxt(k,303)*y(k,251) + .250_r8*rxt(k,432)*y(k,260) &
                      + .250_r8*rxt(k,446)*y(k,265) + .250_r8*rxt(k,450)*y(k,266) &
                      + .360_r8*rxt(k,476)*y(k,272) + .250_r8*rxt(k,493)*y(k,276) &
                      + .250_r8*rxt(k,497)*y(k,277) + .090_r8*rxt(k,647)*y(k,279) &
                      + .250_r8*rxt(k,656)*y(k,280) + .250_r8*rxt(k,402)*y(k,287) &
                      + .050_r8*rxt(k,667)*y(k,288) + .250_r8*rxt(k,676)*y(k,289) &
                      + .500_r8*rxt(k,369)*y(k,296) + .250_r8*rxt(k,695)*y(k,299)
         mat(k,1718) = .250_r8*rxt(k,432)*y(k,251)
         mat(k,1546) = .250_r8*rxt(k,446)*y(k,251)
         mat(k,1568) = .250_r8*rxt(k,450)*y(k,251)
         mat(k,2018) = .360_r8*rxt(k,476)*y(k,251)
         mat(k,1773) = .250_r8*rxt(k,493)*y(k,251)
         mat(k,1661) = .250_r8*rxt(k,497)*y(k,251)
         mat(k,2297) = .090_r8*rxt(k,647)*y(k,251)
         mat(k,2153) = .250_r8*rxt(k,656)*y(k,251)
         mat(k,1368) = .250_r8*rxt(k,402)*y(k,251)
         mat(k,2356) = .050_r8*rxt(k,667)*y(k,251)
         mat(k,2264) = .250_r8*rxt(k,676)*y(k,251)
         mat(k,1225) = .500_r8*rxt(k,369)*y(k,251)
         mat(k,2441) = .250_r8*rxt(k,695)*y(k,251)
         mat(k,370) = -(rxt(k,307)*y(k,293))
         mat(k,3578) = -rxt(k,307)*y(k,54)
         mat(k,3348) = rxt(k,304)*y(k,256)
         mat(k,3149) = rxt(k,304)*y(k,251)
         mat(k,3836) = -(rxt(k,218)*y(k,43) + rxt(k,220)*y(k,79) + rxt(k,221)*y(k,81) &
                      + (rxt(k,222) + rxt(k,223)) * y(k,256) + rxt(k,224)*y(k,157) &
                      + rxt(k,231)*y(k,61) + rxt(k,240)*y(k,96) + rxt(k,331)*y(k,29))
         mat(k,3344) = -rxt(k,218)*y(k,57)
         mat(k,1425) = -rxt(k,220)*y(k,57)
         mat(k,1354) = -rxt(k,221)*y(k,57)
         mat(k,3294) = -(rxt(k,222) + rxt(k,223)) * y(k,57)
         mat(k,2999) = -rxt(k,224)*y(k,57)
         mat(k,1221) = -rxt(k,231)*y(k,57)
         mat(k,1069) = -rxt(k,240)*y(k,57)
         mat(k,263) = -rxt(k,331)*y(k,57)
         mat(k,3801) = rxt(k,259)*y(k,60)
         mat(k,3320) = rxt(k,259)*y(k,20) + (4.000_r8*rxt(k,226)+2.000_r8*rxt(k,228)) &
                      *y(k,60) + rxt(k,230)*y(k,147) + rxt(k,235)*y(k,156) &
                      + rxt(k,801)*y(k,173) + rxt(k,225)*y(k,251) + rxt(k,236) &
                      *y(k,293)
         mat(k,159) = rxt(k,280)*y(k,292)
         mat(k,3777) = rxt(k,238)*y(k,156) + rxt(k,250)*y(k,292) + rxt(k,239)*y(k,293)
         mat(k,2898) = rxt(k,230)*y(k,60)
         mat(k,3465) = rxt(k,235)*y(k,60) + rxt(k,238)*y(k,87)
         mat(k,1524) = rxt(k,801)*y(k,60)
         mat(k,3435) = rxt(k,225)*y(k,60)
         mat(k,3115) = rxt(k,280)*y(k,66) + rxt(k,250)*y(k,87)
         mat(k,3755) = rxt(k,236)*y(k,60) + rxt(k,239)*y(k,87)
      end do
      end subroutine nlnmat02
      subroutine nlnmat03( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,3803) = rxt(k,231)*y(k,61)
         mat(k,3297) = 2.000_r8*rxt(k,227)*y(k,60)
         mat(k,1211) = rxt(k,231)*y(k,57) + (rxt(k,891)+rxt(k,896)+rxt(k,901))*y(k,87)
         mat(k,3757) = (rxt(k,891)+rxt(k,896)+rxt(k,901))*y(k,61) + (rxt(k,886) &
                       +rxt(k,892)+rxt(k,897))*y(k,96)
         mat(k,1063) = (rxt(k,886)+rxt(k,892)+rxt(k,897))*y(k,87)
         mat(k,3296) = 2.000_r8*rxt(k,252)*y(k,60)
         mat(k,3312) = -(rxt(k,225)*y(k,251) + (4._r8*rxt(k,226) + 4._r8*rxt(k,227) &
                      + 4._r8*rxt(k,228) + 4._r8*rxt(k,252)) * y(k,60) + rxt(k,229) &
                      *y(k,256) + rxt(k,230)*y(k,147) + rxt(k,232)*y(k,148) + rxt(k,235) &
                      *y(k,156) + (rxt(k,236) + rxt(k,237)) * y(k,293) + (rxt(k,258) &
                      + rxt(k,259) + rxt(k,260)) * y(k,20) + rxt(k,801)*y(k,173))
         mat(k,3427) = -rxt(k,225)*y(k,60)
         mat(k,3286) = -rxt(k,229)*y(k,60)
         mat(k,2890) = -rxt(k,230)*y(k,60)
         mat(k,3507) = -rxt(k,232)*y(k,60)
         mat(k,3457) = -rxt(k,235)*y(k,60)
         mat(k,3747) = -(rxt(k,236) + rxt(k,237)) * y(k,60)
         mat(k,3793) = -(rxt(k,258) + rxt(k,259) + rxt(k,260)) * y(k,60)
         mat(k,1519) = -rxt(k,801)*y(k,60)
         mat(k,3828) = rxt(k,240)*y(k,96) + rxt(k,224)*y(k,157) + rxt(k,223)*y(k,256)
         mat(k,1216) = rxt(k,233)*y(k,156)
         mat(k,3769) = rxt(k,251)*y(k,292)
         mat(k,1065) = rxt(k,240)*y(k,57) + rxt(k,241)*y(k,156) + rxt(k,242)*y(k,293)
         mat(k,3457) = mat(k,3457) + rxt(k,233)*y(k,61) + rxt(k,241)*y(k,96)
         mat(k,2991) = rxt(k,224)*y(k,57)
         mat(k,278) = rxt(k,806)*y(k,173)
         mat(k,1519) = mat(k,1519) + rxt(k,806)*y(k,159)
         mat(k,3286) = mat(k,3286) + rxt(k,223)*y(k,57)
         mat(k,3107) = rxt(k,251)*y(k,87)
         mat(k,3747) = mat(k,3747) + rxt(k,242)*y(k,96)
         mat(k,1213) = -(rxt(k,231)*y(k,57) + rxt(k,233)*y(k,156) + rxt(k,234) &
                      *y(k,293) + (rxt(k,891) + rxt(k,896) + rxt(k,901)) * y(k,87))
         mat(k,3811) = -rxt(k,231)*y(k,61)
         mat(k,3444) = -rxt(k,233)*y(k,61)
         mat(k,3667) = -rxt(k,234)*y(k,61)
         mat(k,3761) = -(rxt(k,891) + rxt(k,896) + rxt(k,901)) * y(k,61)
         mat(k,3302) = rxt(k,232)*y(k,148)
         mat(k,3487) = rxt(k,232)*y(k,60)
         mat(k,1540) = -((rxt(k,309) + rxt(k,320)) * y(k,293))
         mat(k,3694) = -(rxt(k,309) + rxt(k,320)) * y(k,63)
         mat(k,1105) = .170_r8*rxt(k,603)*y(k,157)
         mat(k,1684) = rxt(k,254)*y(k,43)
         mat(k,256) = .350_r8*rxt(k,322)*y(k,293)
         mat(k,501) = .630_r8*rxt(k,324)*y(k,157)
         mat(k,1200) = .560_r8*rxt(k,355)*y(k,157)
         mat(k,3327) = rxt(k,254)*y(k,18) + rxt(k,218)*y(k,57) + rxt(k,299)*y(k,149) &
                      + rxt(k,300)*y(k,156) + rxt(k,301)*y(k,293)
         mat(k,1844) = rxt(k,361)*y(k,149) + rxt(k,362)*y(k,293)
         mat(k,3818) = rxt(k,218)*y(k,43)
         mat(k,568) = rxt(k,377)*y(k,293)
         mat(k,1177) = rxt(k,347)*y(k,293)
         mat(k,723) = .110_r8*rxt(k,348)*y(k,293)
         mat(k,547) = 1.060_r8*rxt(k,415)*y(k,293)
         mat(k,559) = .760_r8*rxt(k,416)*y(k,293)
         mat(k,422) = .420_r8*rxt(k,417)*y(k,293)
         mat(k,429) = .230_r8*rxt(k,418)*y(k,293)
         mat(k,1697) = rxt(k,419)*y(k,293)
         mat(k,1237) = 1.500_r8*rxt(k,420)*y(k,293)
         mat(k,1087) = .350_r8*rxt(k,424)*y(k,293)
         mat(k,1287) = .350_r8*rxt(k,487)*y(k,157)
         mat(k,1024) = rxt(k,453)*y(k,293)
         mat(k,1632) = rxt(k,455)*y(k,293)
         mat(k,666) = 2.000_r8*rxt(k,457)*y(k,293)
         mat(k,1923) = .060_r8*rxt(k,461)*y(k,293)
         mat(k,1957) = .040_r8*rxt(k,471)*y(k,293)
         mat(k,1748) = .650_r8*rxt(k,386)*y(k,157)
         mat(k,1618) = rxt(k,381)*y(k,293)
         mat(k,1330) = rxt(k,388)*y(k,293)
         mat(k,393) = .250_r8*rxt(k,399)*y(k,293)
         mat(k,1859) = .560_r8*rxt(k,404)*y(k,157)
         mat(k,1800) = .500_r8*rxt(k,400)*y(k,293)
         mat(k,1362) = 1.560_r8*rxt(k,406)*y(k,293)
         mat(k,1986) = .300_r8*rxt(k,502)*y(k,157) + .630_r8*rxt(k,503)*y(k,293)
         mat(k,2836) = .170_r8*rxt(k,557)*y(k,252) + .400_r8*rxt(k,504)*y(k,258) &
                      + .550_r8*rxt(k,510)*y(k,265) + .550_r8*rxt(k,512)*y(k,266) &
                      + .550_r8*rxt(k,531)*y(k,276) + .550_r8*rxt(k,534)*y(k,277) &
                      + .860_r8*rxt(k,536)*y(k,282) + .400_r8*rxt(k,560)*y(k,283) &
                      + .650_r8*rxt(k,393)*y(k,284) + .350_r8*rxt(k,563)*y(k,285) &
                      + .750_r8*rxt(k,540)*y(k,291) + .910_r8*rxt(k,742)*y(k,304)
         mat(k,3031) = rxt(k,299)*y(k,43) + rxt(k,361)*y(k,50) + .650_r8*rxt(k,394) &
                      *y(k,284) + rxt(k,743)*y(k,304)
         mat(k,3448) = rxt(k,300)*y(k,43) + rxt(k,796)*y(k,160)
         mat(k,2940) = .170_r8*rxt(k,603)*y(k,4) + .630_r8*rxt(k,324)*y(k,26) &
                      + .560_r8*rxt(k,355)*y(k,30) + .350_r8*rxt(k,487)*y(k,109) &
                      + .650_r8*rxt(k,386)*y(k,126) + .560_r8*rxt(k,404)*y(k,132) &
                      + .300_r8*rxt(k,502)*y(k,139)
         mat(k,304) = rxt(k,796)*y(k,156) + rxt(k,797)*y(k,293)
         mat(k,507) = 2.000_r8*rxt(k,719)*y(k,293)
         mat(k,515) = rxt(k,738)*y(k,293)
         mat(k,346) = rxt(k,758)*y(k,293)
         mat(k,2655) = .550_r8*rxt(k,445)*y(k,265) + .550_r8*rxt(k,449)*y(k,266) &
                      + .550_r8*rxt(k,492)*y(k,276) + .550_r8*rxt(k,496)*y(k,277) &
                      + .860_r8*rxt(k,382)*y(k,282) + .650_r8*rxt(k,389)*y(k,284) &
                      + rxt(k,739)*y(k,304)
         mat(k,3374) = .280_r8*rxt(k,446)*y(k,265) + .280_r8*rxt(k,450)*y(k,266) &
                      + .280_r8*rxt(k,493)*y(k,276) + .280_r8*rxt(k,497)*y(k,277) &
                      + .900_r8*rxt(k,383)*y(k,282) + .650_r8*rxt(k,390)*y(k,284) &
                      + rxt(k,402)*y(k,287) + rxt(k,740)*y(k,304)
         mat(k,790) = .170_r8*rxt(k,557)*y(k,147) + .070_r8*rxt(k,556)*y(k,256)
         mat(k,3232) = .070_r8*rxt(k,556)*y(k,252) + .260_r8*rxt(k,422)*y(k,258) &
                      + .510_r8*rxt(k,384)*y(k,282) + .160_r8*rxt(k,559)*y(k,283) &
                      + .320_r8*rxt(k,391)*y(k,284) + .140_r8*rxt(k,562)*y(k,285) &
                      + .260_r8*rxt(k,403)*y(k,287) + .600_r8*rxt(k,500)*y(k,291) &
                      + .530_r8*rxt(k,741)*y(k,304)
         mat(k,1406) = .400_r8*rxt(k,504)*y(k,147) + .260_r8*rxt(k,422)*y(k,256)
         mat(k,1549) = .550_r8*rxt(k,510)*y(k,147) + .550_r8*rxt(k,445)*y(k,250) &
                      + .280_r8*rxt(k,446)*y(k,251)
         mat(k,1570) = .550_r8*rxt(k,512)*y(k,147) + .550_r8*rxt(k,449)*y(k,250) &
                      + .280_r8*rxt(k,450)*y(k,251)
         mat(k,1777) = .550_r8*rxt(k,531)*y(k,147) + .550_r8*rxt(k,492)*y(k,250) &
                      + .280_r8*rxt(k,493)*y(k,251)
         mat(k,1664) = .550_r8*rxt(k,534)*y(k,147) + .550_r8*rxt(k,496)*y(k,250) &
                      + .280_r8*rxt(k,497)*y(k,251)
         mat(k,1384) = .860_r8*rxt(k,536)*y(k,147) + .860_r8*rxt(k,382)*y(k,250) &
                      + .900_r8*rxt(k,383)*y(k,251) + .510_r8*rxt(k,384)*y(k,256)
         mat(k,753) = .400_r8*rxt(k,560)*y(k,147) + .160_r8*rxt(k,559)*y(k,256)
         mat(k,1498) = .650_r8*rxt(k,393)*y(k,147) + .650_r8*rxt(k,394)*y(k,149) &
                      + .650_r8*rxt(k,389)*y(k,250) + .650_r8*rxt(k,390)*y(k,251) &
                      + .320_r8*rxt(k,391)*y(k,256) + 2.600_r8*rxt(k,392)*y(k,284)
         mat(k,814) = .350_r8*rxt(k,563)*y(k,147) + .140_r8*rxt(k,562)*y(k,256)
         mat(k,1372) = rxt(k,402)*y(k,251) + .260_r8*rxt(k,403)*y(k,256)
         mat(k,1481) = .750_r8*rxt(k,540)*y(k,147) + .600_r8*rxt(k,500)*y(k,256)
         mat(k,3694) = mat(k,3694) + .350_r8*rxt(k,322)*y(k,25) + rxt(k,301)*y(k,43) &
                      + rxt(k,362)*y(k,50) + rxt(k,377)*y(k,68) + rxt(k,347)*y(k,77) &
                      + .110_r8*rxt(k,348)*y(k,89) + 1.060_r8*rxt(k,415)*y(k,98) &
                      + .760_r8*rxt(k,416)*y(k,99) + .420_r8*rxt(k,417)*y(k,100) &
                      + .230_r8*rxt(k,418)*y(k,101) + rxt(k,419)*y(k,103) &
                      + 1.500_r8*rxt(k,420)*y(k,105) + .350_r8*rxt(k,424)*y(k,108) &
                      + rxt(k,453)*y(k,111) + rxt(k,455)*y(k,112) &
                      + 2.000_r8*rxt(k,457)*y(k,114) + .060_r8*rxt(k,461)*y(k,115) &
                      + .040_r8*rxt(k,471)*y(k,118) + rxt(k,381)*y(k,127) + rxt(k,388) &
                      *y(k,128) + .250_r8*rxt(k,399)*y(k,131) + .500_r8*rxt(k,400) &
                      *y(k,133) + 1.560_r8*rxt(k,406)*y(k,134) + .630_r8*rxt(k,503) &
                      *y(k,139) + rxt(k,797)*y(k,160) + 2.000_r8*rxt(k,719)*y(k,202) &
                      + rxt(k,738)*y(k,204) + rxt(k,758)*y(k,208)
         mat(k,2509) = rxt(k,744)*y(k,304)
         mat(k,2555) = rxt(k,745)*y(k,304)
         mat(k,2463) = .910_r8*rxt(k,742)*y(k,147) + rxt(k,743)*y(k,149) + rxt(k,739) &
                      *y(k,250) + rxt(k,740)*y(k,251) + .530_r8*rxt(k,741)*y(k,256) &
                      + rxt(k,744)*y(k,300) + rxt(k,745)*y(k,302) + rxt(k,746) &
                      *y(k,305)
         mat(k,2602) = rxt(k,746)*y(k,304)
         mat(k,122) = -(rxt(k,279)*y(k,292))
         mat(k,3093) = -rxt(k,279)*y(k,65)
         mat(k,156) = -(rxt(k,280)*y(k,292))
         mat(k,3095) = -rxt(k,280)*y(k,66)
         mat(k,168) = -(rxt(k,555)*y(k,293))
         mat(k,3546) = -rxt(k,555)*y(k,67)
         mat(k,162) = .180_r8*rxt(k,575)*y(k,293)
         mat(k,3546) = mat(k,3546) + .180_r8*rxt(k,575)*y(k,226)
         mat(k,566) = -(rxt(k,377)*y(k,293))
         mat(k,3605) = -rxt(k,377)*y(k,68)
         mat(k,543) = .070_r8*rxt(k,415)*y(k,293)
         mat(k,555) = .170_r8*rxt(k,416)*y(k,293)
         mat(k,3605) = mat(k,3605) + .070_r8*rxt(k,415)*y(k,98) + .170_r8*rxt(k,416) &
                      *y(k,99)
         mat(k,238) = -(rxt(k,794)*y(k,149) + (rxt(k,795) + rxt(k,808)) * y(k,293))
         mat(k,3003) = -rxt(k,794)*y(k,69)
         mat(k,3560) = -(rxt(k,795) + rxt(k,808)) * y(k,69)
         mat(k,742) = rxt(k,342)*y(k,256)
         mat(k,3133) = rxt(k,342)*y(k,255)
         mat(k,897) = -(rxt(k,276)*y(k,79) + rxt(k,277)*y(k,317) + rxt(k,278)*y(k,93))
         mat(k,1415) = -rxt(k,276)*y(k,75)
         mat(k,3841) = -rxt(k,277)*y(k,75)
         mat(k,2715) = -rxt(k,278)*y(k,75)
         mat(k,123) = 2.000_r8*rxt(k,279)*y(k,292)
         mat(k,157) = rxt(k,280)*y(k,292)
         mat(k,3096) = 2.000_r8*rxt(k,279)*y(k,65) + rxt(k,280)*y(k,66)
         mat(k,1469) = -(rxt(k,346)*y(k,293))
         mat(k,3689) = -rxt(k,346)*y(k,76)
         mat(k,1921) = .830_r8*rxt(k,460)*y(k,157)
         mat(k,798) = rxt(k,489)*y(k,293)
         mat(k,1885) = .070_r8*rxt(k,491)*y(k,293)
         mat(k,2832) = .570_r8*rxt(k,504)*y(k,258) + .940_r8*rxt(k,514)*y(k,267) &
                      + .730_r8*rxt(k,516)*y(k,268) + .340_r8*rxt(k,522)*y(k,271) &
                      + .400_r8*rxt(k,526)*y(k,273) + .760_r8*rxt(k,538)*y(k,287)
         mat(k,2936) = .830_r8*rxt(k,460)*y(k,115)
         mat(k,2653) = .750_r8*rxt(k,401)*y(k,287)
         mat(k,3370) = .380_r8*rxt(k,402)*y(k,287)
         mat(k,3228) = .370_r8*rxt(k,422)*y(k,258) + .550_r8*rxt(k,458)*y(k,267) &
                      + .460_r8*rxt(k,462)*y(k,268) + .150_r8*rxt(k,472)*y(k,271) &
                      + .280_r8*rxt(k,480)*y(k,273) + .360_r8*rxt(k,403)*y(k,287)
         mat(k,1405) = .570_r8*rxt(k,504)*y(k,147) + .370_r8*rxt(k,422)*y(k,256)
         mat(k,1002) = .940_r8*rxt(k,514)*y(k,147) + .550_r8*rxt(k,458)*y(k,256)
         mat(k,1073) = .730_r8*rxt(k,516)*y(k,147) + .460_r8*rxt(k,462)*y(k,256)
         mat(k,1318) = .340_r8*rxt(k,522)*y(k,147) + .150_r8*rxt(k,472)*y(k,256)
         mat(k,1184) = .400_r8*rxt(k,526)*y(k,147) + .280_r8*rxt(k,480)*y(k,256)
         mat(k,1371) = .760_r8*rxt(k,538)*y(k,147) + .750_r8*rxt(k,401)*y(k,250) &
                      + .380_r8*rxt(k,402)*y(k,251) + .360_r8*rxt(k,403)*y(k,256)
         mat(k,3689) = mat(k,3689) + rxt(k,489)*y(k,122) + .070_r8*rxt(k,491)*y(k,123)
         mat(k,1176) = -(rxt(k,347)*y(k,293))
         mat(k,3664) = -rxt(k,347)*y(k,77)
         mat(k,255) = .650_r8*rxt(k,322)*y(k,293)
         mat(k,1468) = .200_r8*rxt(k,346)*y(k,293)
         mat(k,722) = .890_r8*rxt(k,348)*y(k,293)
         mat(k,1914) = .170_r8*rxt(k,460)*y(k,157)
         mat(k,1948) = .170_r8*rxt(k,470)*y(k,157)
         mat(k,1431) = .170_r8*rxt(k,485)*y(k,157)
         mat(k,1980) = .660_r8*rxt(k,502)*y(k,157)
         mat(k,2813) = rxt(k,546)*y(k,241) + .230_r8*rxt(k,504)*y(k,258) &
                      + .400_r8*rxt(k,560)*y(k,283) + .170_r8*rxt(k,563)*y(k,285) &
                      + .130_r8*rxt(k,540)*y(k,291) + .700_r8*rxt(k,566)*y(k,294) &
                      + .600_r8*rxt(k,573)*y(k,312) + .340_r8*rxt(k,579)*y(k,314) &
                      + .170_r8*rxt(k,582)*y(k,316)
         mat(k,2926) = .170_r8*rxt(k,460)*y(k,115) + .170_r8*rxt(k,470)*y(k,118) &
                      + .170_r8*rxt(k,485)*y(k,121) + .660_r8*rxt(k,502)*y(k,139)
         mat(k,437) = rxt(k,546)*y(k,147)
         mat(k,3206) = .150_r8*rxt(k,422)*y(k,258) + .160_r8*rxt(k,559)*y(k,283) &
                      + .070_r8*rxt(k,562)*y(k,285) + .100_r8*rxt(k,500)*y(k,291)
         mat(k,1403) = .230_r8*rxt(k,504)*y(k,147) + .150_r8*rxt(k,422)*y(k,256)
         mat(k,752) = .400_r8*rxt(k,560)*y(k,147) + .160_r8*rxt(k,559)*y(k,256)
         mat(k,813) = .170_r8*rxt(k,563)*y(k,147) + .070_r8*rxt(k,562)*y(k,256)
         mat(k,1475) = .130_r8*rxt(k,540)*y(k,147) + .100_r8*rxt(k,500)*y(k,256)
         mat(k,3664) = mat(k,3664) + .650_r8*rxt(k,322)*y(k,25) + .200_r8*rxt(k,346) &
                      *y(k,76) + .890_r8*rxt(k,348)*y(k,89)
         mat(k,378) = .700_r8*rxt(k,566)*y(k,147)
         mat(k,765) = .600_r8*rxt(k,573)*y(k,147)
         mat(k,781) = .340_r8*rxt(k,579)*y(k,147)
         mat(k,444) = .170_r8*rxt(k,582)*y(k,147)
      end do
      end subroutine nlnmat03
      subroutine nlnmat04( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,2730) = -((rxt(k,178) + rxt(k,179) + rxt(k,180)) * y(k,256) + rxt(k,184) &
                      *y(k,157))
         mat(k,3280) = -(rxt(k,178) + rxt(k,179) + rxt(k,180)) * y(k,78)
         mat(k,2985) = -rxt(k,184)*y(k,78)
         mat(k,3330) = rxt(k,301)*y(k,293)
         mat(k,3822) = rxt(k,220)*y(k,79)
         mat(k,1541) = rxt(k,320)*y(k,293)
         mat(k,900) = rxt(k,276)*y(k,79)
         mat(k,1418) = rxt(k,220)*y(k,57) + rxt(k,276)*y(k,75) + rxt(k,176)*y(k,156) &
                      + rxt(k,168)*y(k,292) + rxt(k,185)*y(k,293)
         mat(k,1041) = rxt(k,274)*y(k,292)
         mat(k,3764) = rxt(k,251)*y(k,292)
         mat(k,317) = rxt(k,206)*y(k,293)
         mat(k,3451) = rxt(k,176)*y(k,79) + rxt(k,188)*y(k,293)
         mat(k,305) = rxt(k,797)*y(k,293)
         mat(k,457) = rxt(k,802)*y(k,293)
         mat(k,1515) = rxt(k,807)*y(k,293)
         mat(k,3101) = rxt(k,168)*y(k,79) + rxt(k,274)*y(k,83) + rxt(k,251)*y(k,87)
         mat(k,3741) = rxt(k,301)*y(k,43) + rxt(k,320)*y(k,63) + rxt(k,185)*y(k,79) &
                      + rxt(k,206)*y(k,136) + rxt(k,188)*y(k,156) + rxt(k,797) &
                      *y(k,160) + rxt(k,802)*y(k,171) + rxt(k,807)*y(k,173)
         mat(k,1416) = -(rxt(k,168)*y(k,292) + rxt(k,176)*y(k,156) + rxt(k,185) &
                      *y(k,293) + rxt(k,220)*y(k,57) + rxt(k,276)*y(k,75))
         mat(k,3098) = -rxt(k,168)*y(k,79)
         mat(k,3446) = -rxt(k,176)*y(k,79)
         mat(k,3686) = -rxt(k,185)*y(k,79)
         mat(k,3816) = -rxt(k,220)*y(k,79)
         mat(k,898) = -rxt(k,276)*y(k,79)
         mat(k,2728) = rxt(k,178)*y(k,256)
         mat(k,3225) = rxt(k,178)*y(k,78)
         mat(k,1349) = -(rxt(k,177)*y(k,156) + rxt(k,186)*y(k,293) + rxt(k,221) &
                      *y(k,57))
         mat(k,3445) = -rxt(k,177)*y(k,81)
         mat(k,3679) = -rxt(k,186)*y(k,81)
         mat(k,3814) = -rxt(k,221)*y(k,81)
         mat(k,1104) = .220_r8*rxt(k,603)*y(k,157)
         mat(k,860) = .170_r8*rxt(k,623)*y(k,157)
         mat(k,946) = .320_r8*rxt(k,643)*y(k,157)
         mat(k,1286) = .030_r8*rxt(k,487)*y(k,157)
         mat(k,1919) = .660_r8*rxt(k,460)*y(k,157)
         mat(k,1952) = .660_r8*rxt(k,470)*y(k,157)
         mat(k,1437) = .660_r8*rxt(k,485)*y(k,157)
         mat(k,962) = .330_r8*rxt(k,663)*y(k,157)
         mat(k,1984) = .660_r8*rxt(k,502)*y(k,157)
         mat(k,2933) = .220_r8*rxt(k,603)*y(k,4) + .170_r8*rxt(k,623)*y(k,7) &
                      + .320_r8*rxt(k,643)*y(k,17) + .030_r8*rxt(k,487)*y(k,109) &
                      + .660_r8*rxt(k,460)*y(k,115) + .660_r8*rxt(k,470)*y(k,118) &
                      + .660_r8*rxt(k,485)*y(k,121) + .330_r8*rxt(k,663)*y(k,125) &
                      + .660_r8*rxt(k,502)*y(k,139) + .020_r8*rxt(k,763)*y(k,210) &
                      + .040_r8*rxt(k,768)*y(k,211)
         mat(k,2416) = .020_r8*rxt(k,763)*y(k,157)
         mat(k,2387) = .040_r8*rxt(k,768)*y(k,157)
         mat(k,3218) = 2.000_r8*rxt(k,192)*y(k,256)
         mat(k,3679) = mat(k,3679) + 2.000_r8*rxt(k,191)*y(k,293)
         mat(k,213) = rxt(k,810)*y(k,317)
         mat(k,3838) = rxt(k,810)*y(k,175)
         mat(k,1039) = -(rxt(k,267)*y(k,156) + rxt(k,268)*y(k,293) + (rxt(k,273) &
                      + rxt(k,274)) * y(k,292))
         mat(k,3441) = -rxt(k,267)*y(k,83)
         mat(k,3651) = -rxt(k,268)*y(k,83)
         mat(k,3097) = -(rxt(k,273) + rxt(k,274)) * y(k,83)
         mat(k,1683) = rxt(k,254)*y(k,43) + rxt(k,255)*y(k,256)
         mat(k,3323) = rxt(k,254)*y(k,18)
         mat(k,3197) = rxt(k,255)*y(k,18)
         mat(k,3775) = -(rxt(k,238)*y(k,156) + rxt(k,239)*y(k,293) + (rxt(k,250) &
                      + rxt(k,251)) * y(k,292) + (rxt(k,886) + rxt(k,892) + rxt(k,897) &
                      ) * y(k,96) + (rxt(k,891) + rxt(k,896) + rxt(k,901)) * y(k,61) &
                      + (rxt(k,893) + rxt(k,898)) * y(k,95))
         mat(k,3463) = -rxt(k,238)*y(k,87)
         mat(k,3753) = -rxt(k,239)*y(k,87)
         mat(k,3113) = -(rxt(k,250) + rxt(k,251)) * y(k,87)
         mat(k,1068) = -(rxt(k,886) + rxt(k,892) + rxt(k,897)) * y(k,87)
         mat(k,1220) = -(rxt(k,891) + rxt(k,896) + rxt(k,901)) * y(k,87)
         mat(k,910) = -(rxt(k,893) + rxt(k,898)) * y(k,87)
         mat(k,262) = rxt(k,331)*y(k,57)
         mat(k,3342) = rxt(k,218)*y(k,57)
         mat(k,3834) = rxt(k,331)*y(k,29) + rxt(k,218)*y(k,43) + rxt(k,220)*y(k,79) &
                      + rxt(k,221)*y(k,81) + rxt(k,240)*y(k,96) + rxt(k,222)*y(k,256)
         mat(k,3318) = rxt(k,237)*y(k,293)
         mat(k,1424) = rxt(k,220)*y(k,57)
         mat(k,1353) = rxt(k,221)*y(k,57)
         mat(k,1068) = mat(k,1068) + rxt(k,240)*y(k,57)
         mat(k,3292) = rxt(k,222)*y(k,57)
         mat(k,3753) = mat(k,3753) + rxt(k,237)*y(k,60)
         mat(k,146) = -(rxt(k,310)*y(k,293) + rxt(k,319)*y(k,292))
         mat(k,3541) = -rxt(k,310)*y(k,88)
         mat(k,3094) = -rxt(k,319)*y(k,88)
         mat(k,721) = -(rxt(k,348)*y(k,293))
         mat(k,3621) = -rxt(k,348)*y(k,89)
         mat(k,1427) = .700_r8*rxt(k,485)*y(k,157)
         mat(k,2783) = .810_r8*rxt(k,528)*y(k,274)
         mat(k,2913) = .700_r8*rxt(k,485)*y(k,121)
         mat(k,3174) = .680_r8*rxt(k,483)*y(k,274)
         mat(k,1252) = .810_r8*rxt(k,528)*y(k,147) + .680_r8*rxt(k,483)*y(k,256)
         mat(k,1124) = -(rxt(k,311)*y(k,293))
         mat(k,3658) = -rxt(k,311)*y(k,90)
         mat(k,944) = .080_r8*rxt(k,643)*y(k,157)
         mat(k,254) = .350_r8*rxt(k,322)*y(k,293)
         mat(k,500) = .370_r8*rxt(k,324)*y(k,157)
         mat(k,1196) = .120_r8*rxt(k,355)*y(k,157)
         mat(k,1119) = .500_r8*rxt(k,312)*y(k,293)
         mat(k,410) = .400_r8*rxt(k,423)*y(k,293)
         mat(k,1284) = .220_r8*rxt(k,487)*y(k,157)
         mat(k,1745) = .330_r8*rxt(k,386)*y(k,157)
         mat(k,1853) = .120_r8*rxt(k,404)*y(k,157)
         mat(k,2809) = rxt(k,315)*y(k,257)
         mat(k,2922) = .080_r8*rxt(k,643)*y(k,17) + .370_r8*rxt(k,324)*y(k,26) &
                      + .120_r8*rxt(k,355)*y(k,30) + .220_r8*rxt(k,487)*y(k,109) &
                      + .330_r8*rxt(k,386)*y(k,126) + .120_r8*rxt(k,404)*y(k,132) &
                      + .150_r8*rxt(k,763)*y(k,210) + .260_r8*rxt(k,768)*y(k,211)
         mat(k,2415) = .150_r8*rxt(k,763)*y(k,157)
         mat(k,2386) = .260_r8*rxt(k,768)*y(k,157)
         mat(k,3202) = .500_r8*rxt(k,313)*y(k,257)
         mat(k,595) = rxt(k,315)*y(k,147) + .500_r8*rxt(k,313)*y(k,256)
         mat(k,3658) = mat(k,3658) + .350_r8*rxt(k,322)*y(k,25) + .500_r8*rxt(k,312) &
                      *y(k,92) + .400_r8*rxt(k,423)*y(k,107)
         mat(k,896) = rxt(k,276)*y(k,79) + rxt(k,278)*y(k,93) + rxt(k,277)*y(k,317)
         mat(k,1414) = rxt(k,276)*y(k,75)
         mat(k,2714) = rxt(k,278)*y(k,75)
         mat(k,3839) = rxt(k,277)*y(k,75)
         mat(k,1118) = -(rxt(k,312)*y(k,293))
         mat(k,3657) = -rxt(k,312)*y(k,92)
         mat(k,943) = .110_r8*rxt(k,643)*y(k,157)
         mat(k,1283) = .330_r8*rxt(k,487)*y(k,157)
         mat(k,2921) = .110_r8*rxt(k,643)*y(k,17) + .330_r8*rxt(k,487)*y(k,109) &
                      + .230_r8*rxt(k,763)*y(k,210) + .400_r8*rxt(k,768)*y(k,211)
         mat(k,2414) = .230_r8*rxt(k,763)*y(k,157)
         mat(k,2385) = .400_r8*rxt(k,768)*y(k,157)
         mat(k,3201) = .500_r8*rxt(k,313)*y(k,257)
         mat(k,594) = .500_r8*rxt(k,313)*y(k,256)
         mat(k,2717) = -(rxt(k,215)*y(k,293) + rxt(k,278)*y(k,75))
         mat(k,3740) = -rxt(k,215)*y(k,93)
         mat(k,899) = -rxt(k,278)*y(k,93)
         mat(k,3329) = rxt(k,299)*y(k,149)
         mat(k,1308) = rxt(k,333)*y(k,149)
         mat(k,1847) = rxt(k,361)*y(k,149)
         mat(k,1214) = (rxt(k,891)+rxt(k,896)+rxt(k,901))*y(k,87)
         mat(k,240) = rxt(k,794)*y(k,149)
         mat(k,3763) = (rxt(k,891)+rxt(k,896)+rxt(k,901))*y(k,61)
         mat(k,3500) = rxt(k,214)*y(k,293)
         mat(k,3076) = rxt(k,299)*y(k,43) + rxt(k,333)*y(k,46) + rxt(k,361)*y(k,50) &
                      + rxt(k,794)*y(k,69) + rxt(k,756)*y(k,200) + rxt(k,709)*y(k,201) &
                      + rxt(k,728)*y(k,203)
         mat(k,2197) = rxt(k,756)*y(k,149)
         mat(k,1171) = rxt(k,709)*y(k,149)
         mat(k,1648) = rxt(k,728)*y(k,149)
         mat(k,3740) = mat(k,3740) + rxt(k,214)*y(k,148)
         mat(k,364) = -(rxt(k,193)*y(k,293))
         mat(k,3577) = -rxt(k,193)*y(k,94)
         mat(k,3471) = rxt(k,212)*y(k,256)
         mat(k,3148) = rxt(k,212)*y(k,148)
         mat(k,906) = -(rxt(k,269)*y(k,156) + (rxt(k,893) + rxt(k,898)) * y(k,87))
         mat(k,3440) = -rxt(k,269)*y(k,95)
         mat(k,3759) = -(rxt(k,893) + rxt(k,898)) * y(k,95)
         mat(k,3782) = rxt(k,261)*y(k,256)
         mat(k,3188) = rxt(k,261)*y(k,20)
         mat(k,1064) = -(rxt(k,240)*y(k,57) + rxt(k,241)*y(k,156) + rxt(k,242) &
                      *y(k,293) + (rxt(k,886) + rxt(k,892) + rxt(k,897)) * y(k,87))
         mat(k,3808) = -rxt(k,240)*y(k,96)
         mat(k,3442) = -rxt(k,241)*y(k,96)
         mat(k,3653) = -rxt(k,242)*y(k,96)
         mat(k,3760) = -(rxt(k,886) + rxt(k,892) + rxt(k,897)) * y(k,96)
         mat(k,3300) = rxt(k,229)*y(k,256)
         mat(k,1212) = rxt(k,234)*y(k,293)
         mat(k,3199) = rxt(k,229)*y(k,60)
         mat(k,3653) = mat(k,3653) + rxt(k,234)*y(k,61)
         mat(k,876) = -(rxt(k,380)*y(k,293))
         mat(k,3637) = -rxt(k,380)*y(k,97)
         mat(k,2796) = rxt(k,379)*y(k,253)
         mat(k,535) = rxt(k,379)*y(k,147)
         mat(k,542) = -(rxt(k,415)*y(k,293))
         mat(k,3603) = -rxt(k,415)*y(k,98)
         mat(k,554) = -(rxt(k,416)*y(k,293))
         mat(k,3604) = -rxt(k,416)*y(k,99)
         mat(k,419) = -(rxt(k,417)*y(k,293))
         mat(k,3586) = -rxt(k,417)*y(k,100)
         mat(k,1876) = .090_r8*rxt(k,490)*y(k,293)
         mat(k,3586) = mat(k,3586) + .090_r8*rxt(k,490)*y(k,123)
         mat(k,426) = -(rxt(k,418)*y(k,293))
         mat(k,3587) = -rxt(k,418)*y(k,101)
         mat(k,1877) = .090_r8*rxt(k,490)*y(k,293)
         mat(k,3587) = mat(k,3587) + .090_r8*rxt(k,490)*y(k,123)
         mat(k,1611) = -(rxt(k,363)*y(k,293))
         mat(k,3699) = -rxt(k,363)*y(k,102)
         mat(k,1698) = .220_r8*rxt(k,419)*y(k,293)
         mat(k,1238) = .500_r8*rxt(k,420)*y(k,293)
         mat(k,1088) = .190_r8*rxt(k,424)*y(k,293)
         mat(k,667) = .280_r8*rxt(k,457)*y(k,293)
         mat(k,1958) = .830_r8*rxt(k,470)*y(k,157)
         mat(k,799) = rxt(k,489)*y(k,293)
         mat(k,1887) = .070_r8*rxt(k,491)*y(k,293)
         mat(k,1619) = .500_r8*rxt(k,381)*y(k,293)
         mat(k,1331) = rxt(k,388)*y(k,293)
         mat(k,394) = .250_r8*rxt(k,399)*y(k,293)
         mat(k,711) = .180_r8*rxt(k,683)*y(k,157)
         mat(k,2841) = .290_r8*rxt(k,504)*y(k,258) + .730_r8*rxt(k,516)*y(k,268) &
                      + .870_r8*rxt(k,520)*y(k,270) + .330_r8*rxt(k,522)*y(k,271) &
                      + .070_r8*rxt(k,526)*y(k,273) + .860_r8*rxt(k,536)*y(k,282)
         mat(k,2943) = .830_r8*rxt(k,470)*y(k,118) + .180_r8*rxt(k,683)*y(k,135)
         mat(k,485) = .500_r8*rxt(k,368)*y(k,293)
         mat(k,2660) = .860_r8*rxt(k,382)*y(k,282)
         mat(k,3379) = .900_r8*rxt(k,383)*y(k,282) + .200_r8*rxt(k,369)*y(k,296)
         mat(k,3237) = .190_r8*rxt(k,422)*y(k,258) + .460_r8*rxt(k,462)*y(k,268) &
                      + .440_r8*rxt(k,468)*y(k,270) + .150_r8*rxt(k,472)*y(k,271) &
                      + .060_r8*rxt(k,480)*y(k,273) + .510_r8*rxt(k,384)*y(k,282)
         mat(k,1407) = .290_r8*rxt(k,504)*y(k,147) + .190_r8*rxt(k,422)*y(k,256)
         mat(k,1075) = .730_r8*rxt(k,516)*y(k,147) + .460_r8*rxt(k,462)*y(k,256)
         mat(k,1014) = .870_r8*rxt(k,520)*y(k,147) + .440_r8*rxt(k,468)*y(k,256)
         mat(k,1321) = .330_r8*rxt(k,522)*y(k,147) + .150_r8*rxt(k,472)*y(k,256)
         mat(k,1186) = .070_r8*rxt(k,526)*y(k,147) + .060_r8*rxt(k,480)*y(k,256)
         mat(k,1385) = .860_r8*rxt(k,536)*y(k,147) + .860_r8*rxt(k,382)*y(k,250) &
                      + .900_r8*rxt(k,383)*y(k,251) + .510_r8*rxt(k,384)*y(k,256)
         mat(k,3699) = mat(k,3699) + .220_r8*rxt(k,419)*y(k,103) + .500_r8*rxt(k,420) &
                      *y(k,105) + .190_r8*rxt(k,424)*y(k,108) + .280_r8*rxt(k,457) &
                      *y(k,114) + rxt(k,489)*y(k,122) + .070_r8*rxt(k,491)*y(k,123) &
                      + .500_r8*rxt(k,381)*y(k,127) + rxt(k,388)*y(k,128) &
                      + .250_r8*rxt(k,399)*y(k,131) + .500_r8*rxt(k,368)*y(k,169)
         mat(k,1226) = .200_r8*rxt(k,369)*y(k,251)
      end do
      end subroutine nlnmat04
      subroutine nlnmat05( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,1700) = -(rxt(k,419)*y(k,293))
         mat(k,3705) = -rxt(k,419)*y(k,103)
         mat(k,1889) = .130_r8*rxt(k,490)*y(k,293)
         mat(k,2847) = .450_r8*rxt(k,510)*y(k,265) + .450_r8*rxt(k,512)*y(k,266) &
                      + .450_r8*rxt(k,531)*y(k,276) + .450_r8*rxt(k,534)*y(k,277)
         mat(k,2664) = .450_r8*rxt(k,445)*y(k,265) + .450_r8*rxt(k,449)*y(k,266) &
                      + .450_r8*rxt(k,492)*y(k,276) + .450_r8*rxt(k,496)*y(k,277)
         mat(k,3384) = .250_r8*rxt(k,432)*y(k,260) + .470_r8*rxt(k,446)*y(k,265) &
                      + .470_r8*rxt(k,450)*y(k,266) + .470_r8*rxt(k,493)*y(k,276) &
                      + .470_r8*rxt(k,497)*y(k,277)
         mat(k,1728) = .250_r8*rxt(k,432)*y(k,251)
         mat(k,1552) = .450_r8*rxt(k,510)*y(k,147) + .450_r8*rxt(k,445)*y(k,250) &
                      + .470_r8*rxt(k,446)*y(k,251)
         mat(k,1573) = .450_r8*rxt(k,512)*y(k,147) + .450_r8*rxt(k,449)*y(k,250) &
                      + .470_r8*rxt(k,450)*y(k,251)
         mat(k,1779) = .450_r8*rxt(k,531)*y(k,147) + .450_r8*rxt(k,492)*y(k,250) &
                      + .470_r8*rxt(k,493)*y(k,251)
         mat(k,1668) = .450_r8*rxt(k,534)*y(k,147) + .450_r8*rxt(k,496)*y(k,250) &
                      + .470_r8*rxt(k,497)*y(k,251)
         mat(k,3705) = mat(k,3705) + .130_r8*rxt(k,490)*y(k,123)
         mat(k,807) = -(rxt(k,364)*y(k,293))
         mat(k,3630) = -rxt(k,364)*y(k,104)
         mat(k,567) = rxt(k,377)*y(k,293)
         mat(k,556) = .150_r8*rxt(k,416)*y(k,293)
         mat(k,1429) = .130_r8*rxt(k,485)*y(k,157)
         mat(k,2790) = .150_r8*rxt(k,528)*y(k,274)
         mat(k,2915) = .130_r8*rxt(k,485)*y(k,121)
         mat(k,3181) = .120_r8*rxt(k,483)*y(k,274)
         mat(k,1253) = .150_r8*rxt(k,528)*y(k,147) + .120_r8*rxt(k,483)*y(k,256)
         mat(k,3630) = mat(k,3630) + rxt(k,377)*y(k,68) + .150_r8*rxt(k,416)*y(k,99)
         mat(k,1236) = -(rxt(k,420)*y(k,293))
         mat(k,3669) = -rxt(k,420)*y(k,105)
         mat(k,545) = .080_r8*rxt(k,415)*y(k,293)
         mat(k,557) = .180_r8*rxt(k,416)*y(k,293)
         mat(k,420) = .580_r8*rxt(k,417)*y(k,293)
         mat(k,427) = .770_r8*rxt(k,418)*y(k,293)
         mat(k,803) = .190_r8*rxt(k,421)*y(k,293)
         mat(k,1981) = .040_r8*rxt(k,503)*y(k,293)
         mat(k,3669) = mat(k,3669) + .080_r8*rxt(k,415)*y(k,98) + .180_r8*rxt(k,416) &
                      *y(k,99) + .580_r8*rxt(k,417)*y(k,100) + .770_r8*rxt(k,418) &
                      *y(k,101) + .190_r8*rxt(k,421)*y(k,106) + .040_r8*rxt(k,503) &
                      *y(k,139)
         mat(k,802) = -(rxt(k,421)*y(k,293))
         mat(k,3629) = -rxt(k,421)*y(k,106)
         mat(k,1912) = .080_r8*rxt(k,461)*y(k,293)
         mat(k,574) = .150_r8*rxt(k,464)*y(k,293)
         mat(k,475) = .130_r8*rxt(k,467)*y(k,293)
         mat(k,1946) = .040_r8*rxt(k,471)*y(k,293)
         mat(k,1428) = .070_r8*rxt(k,486)*y(k,293)
         mat(k,1879) = .850_r8*rxt(k,491)*y(k,293)
         mat(k,3629) = mat(k,3629) + .080_r8*rxt(k,461)*y(k,115) + .150_r8*rxt(k,464) &
                      *y(k,116) + .130_r8*rxt(k,467)*y(k,117) + .040_r8*rxt(k,471) &
                      *y(k,118) + .070_r8*rxt(k,486)*y(k,121) + .850_r8*rxt(k,491) &
                      *y(k,123)
         mat(k,409) = -(rxt(k,423)*y(k,293))
         mat(k,3585) = -rxt(k,423)*y(k,107)
         mat(k,409) = mat(k,409) + .200_r8*rxt(k,423)*y(k,293)
         mat(k,1047) = .400_r8*rxt(k,482)*y(k,293)
         mat(k,3585) = mat(k,3585) + .200_r8*rxt(k,423)*y(k,107) + .400_r8*rxt(k,482) &
                      *y(k,120)
         mat(k,1083) = -(rxt(k,424)*y(k,293))
         mat(k,3655) = -rxt(k,424)*y(k,108)
         mat(k,1083) = mat(k,1083) + .060_r8*rxt(k,424)*y(k,293)
         mat(k,624) = .030_r8*rxt(k,473)*y(k,293)
         mat(k,1430) = .200_r8*rxt(k,486)*y(k,293)
         mat(k,3655) = mat(k,3655) + .060_r8*rxt(k,424)*y(k,108) + .030_r8*rxt(k,473) &
                      *y(k,119) + .200_r8*rxt(k,486)*y(k,121)
         mat(k,1285) = -(rxt(k,474)*y(k,149) + rxt(k,487)*y(k,157) + rxt(k,488) &
                      *y(k,293))
         mat(k,3021) = -rxt(k,474)*y(k,109)
         mat(k,2930) = -rxt(k,487)*y(k,109)
         mat(k,3673) = -rxt(k,488)*y(k,109)
         mat(k,1529) = -(rxt(k,454)*y(k,293))
         mat(k,3693) = -rxt(k,454)*y(k,110)
         mat(k,2835) = rxt(k,515)*y(k,267) + rxt(k,517)*y(k,268) + rxt(k,519)*y(k,269) &
                      + rxt(k,521)*y(k,270) + rxt(k,523)*y(k,271) + rxt(k,525) &
                      *y(k,272) + rxt(k,527)*y(k,273) + rxt(k,529)*y(k,274)
         mat(k,1003) = rxt(k,515)*y(k,147)
         mat(k,1074) = rxt(k,517)*y(k,147)
         mat(k,987) = rxt(k,519)*y(k,147)
         mat(k,1013) = rxt(k,521)*y(k,147)
         mat(k,1319) = rxt(k,523)*y(k,147)
         mat(k,2022) = rxt(k,525)*y(k,147)
         mat(k,1185) = rxt(k,527)*y(k,147)
         mat(k,1259) = rxt(k,529)*y(k,147)
         mat(k,1021) = -(rxt(k,453)*y(k,293))
         mat(k,3649) = -rxt(k,453)*y(k,111)
         mat(k,1526) = rxt(k,454)*y(k,293)
         mat(k,2805) = rxt(k,541)*y(k,291)
         mat(k,1474) = rxt(k,541)*y(k,147)
         mat(k,3649) = mat(k,3649) + rxt(k,454)*y(k,110)
         mat(k,1635) = -(rxt(k,455)*y(k,293))
         mat(k,3701) = -rxt(k,455)*y(k,112)
         mat(k,1339) = rxt(k,456)*y(k,293)
         mat(k,2843) = rxt(k,505)*y(k,258)
         mat(k,1408) = rxt(k,505)*y(k,147)
         mat(k,3701) = mat(k,3701) + rxt(k,456)*y(k,113)
         mat(k,1336) = -(rxt(k,456)*y(k,293))
         mat(k,3677) = -rxt(k,456)*y(k,113)
         mat(k,3216) = .420_r8*rxt(k,458)*y(k,267) + .480_r8*rxt(k,462)*y(k,268) &
                      + .400_r8*rxt(k,465)*y(k,269) + .500_r8*rxt(k,468)*y(k,270) &
                      + .600_r8*rxt(k,472)*y(k,271) + .490_r8*rxt(k,480)*y(k,273) &
                      + .170_r8*rxt(k,483)*y(k,274) + .200_r8*rxt(k,500)*y(k,291)
         mat(k,1000) = .420_r8*rxt(k,458)*y(k,256)
         mat(k,1072) = .480_r8*rxt(k,462)*y(k,256)
         mat(k,986) = .400_r8*rxt(k,465)*y(k,256)
         mat(k,1012) = .500_r8*rxt(k,468)*y(k,256)
         mat(k,1316) = .600_r8*rxt(k,472)*y(k,256)
         mat(k,1182) = .490_r8*rxt(k,480)*y(k,256)
         mat(k,1257) = .170_r8*rxt(k,483)*y(k,256)
         mat(k,1477) = .200_r8*rxt(k,500)*y(k,256)
         mat(k,663) = -(rxt(k,457)*y(k,293))
         mat(k,3615) = -rxt(k,457)*y(k,114)
         mat(k,1878) = .080_r8*rxt(k,491)*y(k,293)
         mat(k,3169) = .350_r8*rxt(k,422)*y(k,258)
         mat(k,1402) = .350_r8*rxt(k,422)*y(k,256)
         mat(k,3615) = mat(k,3615) + .080_r8*rxt(k,491)*y(k,123)
         mat(k,1930) = -(rxt(k,460)*y(k,157) + rxt(k,461)*y(k,293))
         mat(k,2958) = -rxt(k,460)*y(k,115)
         mat(k,3714) = -rxt(k,461)*y(k,115)
         mat(k,2856) = rxt(k,513)*y(k,266) + rxt(k,535)*y(k,277)
         mat(k,3393) = .280_r8*rxt(k,476)*y(k,272)
         mat(k,1577) = rxt(k,513)*y(k,147)
         mat(k,2031) = .280_r8*rxt(k,476)*y(k,251) + 1.060_r8*rxt(k,478)*y(k,272)
         mat(k,1673) = rxt(k,535)*y(k,147)
         mat(k,573) = -(rxt(k,464)*y(k,293))
         mat(k,3606) = -rxt(k,464)*y(k,116)
         mat(k,2775) = rxt(k,507)*y(k,259)
         mat(k,1812) = rxt(k,507)*y(k,147)
         mat(k,474) = -(rxt(k,467)*y(k,293))
         mat(k,3594) = -rxt(k,467)*y(k,117)
         mat(k,2772) = rxt(k,509)*y(k,260)
         mat(k,1712) = rxt(k,509)*y(k,147)
         mat(k,1964) = -(rxt(k,470)*y(k,157) + rxt(k,471)*y(k,293))
         mat(k,2959) = -rxt(k,470)*y(k,118)
         mat(k,3715) = -rxt(k,471)*y(k,118)
         mat(k,2857) = rxt(k,511)*y(k,265) + rxt(k,532)*y(k,276)
         mat(k,3394) = .050_r8*rxt(k,476)*y(k,272)
         mat(k,1556) = rxt(k,511)*y(k,147)
         mat(k,2032) = .050_r8*rxt(k,476)*y(k,251) + .180_r8*rxt(k,478)*y(k,272)
         mat(k,1786) = rxt(k,532)*y(k,147)
         mat(k,623) = -(rxt(k,473)*y(k,293))
         mat(k,3611) = -rxt(k,473)*y(k,119)
         mat(k,3350) = .070_r8*rxt(k,476)*y(k,272)
         mat(k,2008) = .070_r8*rxt(k,476)*y(k,251) + .300_r8*rxt(k,478)*y(k,272)
         mat(k,1048) = -(rxt(k,482)*y(k,293))
         mat(k,3652) = -rxt(k,482)*y(k,120)
         mat(k,3198) = .230_r8*rxt(k,477)*y(k,272)
         mat(k,2009) = .230_r8*rxt(k,477)*y(k,256)
         mat(k,1439) = -(rxt(k,485)*y(k,157) + rxt(k,486)*y(k,293))
         mat(k,2935) = -rxt(k,485)*y(k,121)
         mat(k,3687) = -rxt(k,486)*y(k,121)
         mat(k,3226) = .530_r8*rxt(k,477)*y(k,272)
         mat(k,2019) = .530_r8*rxt(k,477)*y(k,256)
         mat(k,797) = -(rxt(k,489)*y(k,293))
         mat(k,3628) = -rxt(k,489)*y(k,122)
         mat(k,3351) = .250_r8*rxt(k,426)*y(k,259) + .250_r8*rxt(k,432)*y(k,260) &
                      + .250_r8*rxt(k,446)*y(k,265) + .250_r8*rxt(k,450)*y(k,266) &
                      + .250_r8*rxt(k,493)*y(k,276) + .250_r8*rxt(k,497)*y(k,277)
         mat(k,1813) = .250_r8*rxt(k,426)*y(k,251)
         mat(k,1713) = .250_r8*rxt(k,432)*y(k,251)
         mat(k,1545) = .250_r8*rxt(k,446)*y(k,251)
         mat(k,1566) = .250_r8*rxt(k,450)*y(k,251)
         mat(k,1769) = .250_r8*rxt(k,493)*y(k,251)
         mat(k,1657) = .250_r8*rxt(k,497)*y(k,251)
         mat(k,1896) = -((rxt(k,490) + rxt(k,491)) * y(k,293))
         mat(k,3713) = -(rxt(k,490) + rxt(k,491)) * y(k,123)
         mat(k,3251) = .940_r8*rxt(k,427)*y(k,259) + .940_r8*rxt(k,433)*y(k,260) &
                      + rxt(k,447)*y(k,265) + rxt(k,451)*y(k,266) + rxt(k,494) &
                      *y(k,276) + rxt(k,498)*y(k,277)
         mat(k,1832) = .940_r8*rxt(k,427)*y(k,256)
         mat(k,1733) = .940_r8*rxt(k,433)*y(k,256)
         mat(k,1555) = rxt(k,447)*y(k,256)
         mat(k,1576) = rxt(k,451)*y(k,256)
         mat(k,1785) = rxt(k,494)*y(k,256)
         mat(k,1672) = rxt(k,498)*y(k,256)
         mat(k,78) = -(rxt(k,867)*y(k,293))
         mat(k,3529) = -rxt(k,867)*y(k,124)
         mat(k,961) = -(rxt(k,645)*y(k,149) + rxt(k,663)*y(k,157) + rxt(k,664) &
                      *y(k,293))
         mat(k,3011) = -rxt(k,645)*y(k,125)
         mat(k,2918) = -rxt(k,663)*y(k,125)
         mat(k,3643) = -rxt(k,664)*y(k,125)
         mat(k,1751) = -(rxt(k,386)*y(k,157) + rxt(k,387)*y(k,293))
         mat(k,2951) = -rxt(k,386)*y(k,126)
         mat(k,3707) = -rxt(k,387)*y(k,126)
         mat(k,560) = .350_r8*rxt(k,416)*y(k,293)
         mat(k,430) = .140_r8*rxt(k,418)*y(k,293)
         mat(k,1292) = .410_r8*rxt(k,487)*y(k,157)
         mat(k,2849) = rxt(k,508)*y(k,260) + .040_r8*rxt(k,524)*y(k,272)
         mat(k,3042) = .040_r8*rxt(k,479)*y(k,272)
         mat(k,2951) = mat(k,2951) + .410_r8*rxt(k,487)*y(k,109)
         mat(k,2666) = rxt(k,431)*y(k,260) + .040_r8*rxt(k,475)*y(k,272)
         mat(k,3386) = .500_r8*rxt(k,432)*y(k,260) + .020_r8*rxt(k,476)*y(k,272)
         mat(k,3245) = .060_r8*rxt(k,433)*y(k,260) + .020_r8*rxt(k,477)*y(k,272)
         mat(k,1730) = rxt(k,508)*y(k,147) + rxt(k,431)*y(k,250) + .500_r8*rxt(k,432) &
                      *y(k,251) + .060_r8*rxt(k,433)*y(k,256)
         mat(k,2027) = .040_r8*rxt(k,524)*y(k,147) + .040_r8*rxt(k,479)*y(k,149) &
                      + .040_r8*rxt(k,475)*y(k,250) + .020_r8*rxt(k,476)*y(k,251) &
                      + .020_r8*rxt(k,477)*y(k,256) + .320_r8*rxt(k,478)*y(k,272)
         mat(k,3707) = mat(k,3707) + .350_r8*rxt(k,416)*y(k,99) + .140_r8*rxt(k,418) &
                      *y(k,101)
      end do
      end subroutine nlnmat05
      subroutine nlnmat06( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,1620) = -(rxt(k,381)*y(k,293))
         mat(k,3700) = -rxt(k,381)*y(k,127)
         mat(k,1026) = .500_r8*rxt(k,453)*y(k,293)
         mat(k,1634) = .250_r8*rxt(k,455)*y(k,293)
         mat(k,1925) = .060_r8*rxt(k,461)*y(k,293)
         mat(k,1988) = .240_r8*rxt(k,503)*y(k,293)
         mat(k,2842) = .060_r8*rxt(k,514)*y(k,267) + .270_r8*rxt(k,516)*y(k,268) &
                      + .210_r8*rxt(k,522)*y(k,271) + .490_r8*rxt(k,526)*y(k,273) &
                      + .020_r8*rxt(k,528)*y(k,274) + rxt(k,537)*y(k,282) &
                      + .390_r8*rxt(k,540)*y(k,291)
         mat(k,3238) = .030_r8*rxt(k,458)*y(k,267) + .060_r8*rxt(k,462)*y(k,268) &
                      + .060_r8*rxt(k,472)*y(k,271) + .150_r8*rxt(k,480)*y(k,273) &
                      + .020_r8*rxt(k,483)*y(k,274) + .290_r8*rxt(k,500)*y(k,291)
         mat(k,1004) = .060_r8*rxt(k,514)*y(k,147) + .030_r8*rxt(k,458)*y(k,256)
         mat(k,1076) = .270_r8*rxt(k,516)*y(k,147) + .060_r8*rxt(k,462)*y(k,256)
         mat(k,1322) = .210_r8*rxt(k,522)*y(k,147) + .060_r8*rxt(k,472)*y(k,256)
         mat(k,1187) = .490_r8*rxt(k,526)*y(k,147) + .150_r8*rxt(k,480)*y(k,256)
         mat(k,1261) = .020_r8*rxt(k,528)*y(k,147) + .020_r8*rxt(k,483)*y(k,256)
         mat(k,1386) = rxt(k,537)*y(k,147)
         mat(k,1483) = .390_r8*rxt(k,540)*y(k,147) + .290_r8*rxt(k,500)*y(k,256)
         mat(k,3700) = mat(k,3700) + .500_r8*rxt(k,453)*y(k,111) + .250_r8*rxt(k,455) &
                      *y(k,112) + .060_r8*rxt(k,461)*y(k,115) + .240_r8*rxt(k,503) &
                      *y(k,139)
         mat(k,1329) = -(rxt(k,388)*y(k,293))
         mat(k,3676) = -rxt(k,388)*y(k,128)
         mat(k,428) = .090_r8*rxt(k,418)*y(k,293)
         mat(k,1629) = .250_r8*rxt(k,455)*y(k,293)
         mat(k,2822) = .550_r8*rxt(k,512)*y(k,266) + .550_r8*rxt(k,534)*y(k,277)
         mat(k,2647) = .550_r8*rxt(k,449)*y(k,266) + .550_r8*rxt(k,496)*y(k,277)
         mat(k,3361) = .280_r8*rxt(k,450)*y(k,266) + .280_r8*rxt(k,497)*y(k,277)
         mat(k,3215) = .410_r8*rxt(k,384)*y(k,282)
         mat(k,1567) = .550_r8*rxt(k,512)*y(k,147) + .550_r8*rxt(k,449)*y(k,250) &
                      + .280_r8*rxt(k,450)*y(k,251)
         mat(k,1660) = .550_r8*rxt(k,534)*y(k,147) + .550_r8*rxt(k,496)*y(k,250) &
                      + .280_r8*rxt(k,497)*y(k,251)
         mat(k,1382) = .410_r8*rxt(k,384)*y(k,256)
         mat(k,3676) = mat(k,3676) + .090_r8*rxt(k,418)*y(k,101) + .250_r8*rxt(k,455) &
                      *y(k,112)
         mat(k,450) = -(rxt(k,397)*y(k,293))
         mat(k,3590) = -rxt(k,397)*y(k,129)
         mat(k,2770) = .800_r8*rxt(k,411)*y(k,234)
         mat(k,1128) = .800_r8*rxt(k,411)*y(k,147)
         mat(k,265) = -(rxt(k,398)*y(k,293))
         mat(k,3563) = -rxt(k,398)*y(k,130)
         mat(k,3138) = .800_r8*rxt(k,395)*y(k,286)
         mat(k,655) = .800_r8*rxt(k,395)*y(k,256)
         mat(k,391) = -(rxt(k,399)*y(k,293))
         mat(k,3582) = -rxt(k,399)*y(k,131)
         mat(k,3472) = rxt(k,407)*y(k,284)
         mat(k,1494) = rxt(k,407)*y(k,148)
         mat(k,1863) = -(rxt(k,404)*y(k,157) + rxt(k,405)*y(k,293))
         mat(k,2956) = -rxt(k,404)*y(k,132)
         mat(k,3712) = -rxt(k,405)*y(k,132)
         mat(k,549) = .350_r8*rxt(k,415)*y(k,293)
         mat(k,423) = .230_r8*rxt(k,417)*y(k,293)
         mat(k,1295) = .170_r8*rxt(k,487)*y(k,157)
         mat(k,2854) = rxt(k,506)*y(k,259) + .420_r8*rxt(k,524)*y(k,272)
         mat(k,3047) = .420_r8*rxt(k,479)*y(k,272)
         mat(k,2956) = mat(k,2956) + .170_r8*rxt(k,487)*y(k,109)
         mat(k,2671) = rxt(k,425)*y(k,259) + .420_r8*rxt(k,475)*y(k,272)
         mat(k,3391) = .750_r8*rxt(k,426)*y(k,259) + .050_r8*rxt(k,476)*y(k,272)
         mat(k,3250) = .060_r8*rxt(k,427)*y(k,259) + .220_r8*rxt(k,477)*y(k,272)
         mat(k,1831) = rxt(k,506)*y(k,147) + rxt(k,425)*y(k,250) + .750_r8*rxt(k,426) &
                      *y(k,251) + .060_r8*rxt(k,427)*y(k,256)
         mat(k,2030) = .420_r8*rxt(k,524)*y(k,147) + .420_r8*rxt(k,479)*y(k,149) &
                      + .420_r8*rxt(k,475)*y(k,250) + .050_r8*rxt(k,476)*y(k,251) &
                      + .220_r8*rxt(k,477)*y(k,256)
         mat(k,3712) = mat(k,3712) + .350_r8*rxt(k,415)*y(k,98) + .230_r8*rxt(k,417) &
                      *y(k,100)
         mat(k,1801) = -(rxt(k,400)*y(k,293))
         mat(k,3709) = -rxt(k,400)*y(k,133)
         mat(k,1089) = .050_r8*rxt(k,424)*y(k,293)
         mat(k,1027) = .500_r8*rxt(k,453)*y(k,293)
         mat(k,1636) = .250_r8*rxt(k,455)*y(k,293)
         mat(k,1962) = .040_r8*rxt(k,471)*y(k,293)
         mat(k,1991) = .040_r8*rxt(k,503)*y(k,293)
         mat(k,2851) = rxt(k,518)*y(k,269) + .130_r8*rxt(k,520)*y(k,270) &
                      + .120_r8*rxt(k,522)*y(k,271) + .040_r8*rxt(k,526)*y(k,273) &
                      + .020_r8*rxt(k,528)*y(k,274) + rxt(k,539)*y(k,287) &
                      + .360_r8*rxt(k,540)*y(k,291)
         mat(k,3247) = .600_r8*rxt(k,465)*y(k,269) + .060_r8*rxt(k,468)*y(k,270) &
                      + .040_r8*rxt(k,472)*y(k,271) + .020_r8*rxt(k,480)*y(k,273) &
                      + .010_r8*rxt(k,483)*y(k,274) + .310_r8*rxt(k,500)*y(k,291)
         mat(k,989) = rxt(k,518)*y(k,147) + .600_r8*rxt(k,465)*y(k,256)
         mat(k,1015) = .130_r8*rxt(k,520)*y(k,147) + .060_r8*rxt(k,468)*y(k,256)
         mat(k,1323) = .120_r8*rxt(k,522)*y(k,147) + .040_r8*rxt(k,472)*y(k,256)
         mat(k,1188) = .040_r8*rxt(k,526)*y(k,147) + .020_r8*rxt(k,480)*y(k,256)
         mat(k,1262) = .020_r8*rxt(k,528)*y(k,147) + .010_r8*rxt(k,483)*y(k,256)
         mat(k,1373) = rxt(k,539)*y(k,147)
         mat(k,1485) = .360_r8*rxt(k,540)*y(k,147) + .310_r8*rxt(k,500)*y(k,256)
         mat(k,3709) = mat(k,3709) + .050_r8*rxt(k,424)*y(k,108) + .500_r8*rxt(k,453) &
                      *y(k,111) + .250_r8*rxt(k,455)*y(k,112) + .040_r8*rxt(k,471) &
                      *y(k,118) + .040_r8*rxt(k,503)*y(k,139)
         mat(k,1360) = -(rxt(k,406)*y(k,293))
         mat(k,3681) = -rxt(k,406)*y(k,134)
         mat(k,421) = .190_r8*rxt(k,417)*y(k,293)
         mat(k,1630) = .250_r8*rxt(k,455)*y(k,293)
         mat(k,2826) = .550_r8*rxt(k,510)*y(k,265) + .550_r8*rxt(k,531)*y(k,276)
         mat(k,2648) = .550_r8*rxt(k,445)*y(k,265) + .550_r8*rxt(k,492)*y(k,276)
         mat(k,3365) = .280_r8*rxt(k,446)*y(k,265) + .280_r8*rxt(k,493)*y(k,276)
         mat(k,3220) = .460_r8*rxt(k,403)*y(k,287)
         mat(k,1547) = .550_r8*rxt(k,510)*y(k,147) + .550_r8*rxt(k,445)*y(k,250) &
                      + .280_r8*rxt(k,446)*y(k,251)
         mat(k,1774) = .550_r8*rxt(k,531)*y(k,147) + .550_r8*rxt(k,492)*y(k,250) &
                      + .280_r8*rxt(k,493)*y(k,251)
         mat(k,1369) = .460_r8*rxt(k,403)*y(k,256)
         mat(k,3681) = mat(k,3681) + .190_r8*rxt(k,417)*y(k,100) + .250_r8*rxt(k,455) &
                      *y(k,112)
         mat(k,710) = -(rxt(k,665)*y(k,149) + rxt(k,683)*y(k,157) + rxt(k,684) &
                      *y(k,293))
         mat(k,3007) = -rxt(k,665)*y(k,135)
         mat(k,2912) = -rxt(k,683)*y(k,135)
         mat(k,3620) = -rxt(k,684)*y(k,135)
         mat(k,316) = -(rxt(k,194)*y(k,147) + (rxt(k,195) + rxt(k,196) + rxt(k,197) &
                      ) * y(k,148) + rxt(k,206)*y(k,293))
         mat(k,2762) = -rxt(k,194)*y(k,136)
         mat(k,3469) = -(rxt(k,195) + rxt(k,196) + rxt(k,197)) * y(k,136)
         mat(k,3570) = -rxt(k,206)*y(k,136)
         mat(k,3468) = rxt(k,213)*y(k,149)
         mat(k,3004) = rxt(k,213)*y(k,148)
         mat(k,1993) = -(rxt(k,502)*y(k,157) + rxt(k,503)*y(k,293))
         mat(k,2960) = -rxt(k,502)*y(k,139)
         mat(k,3716) = -rxt(k,503)*y(k,139)
         mat(k,1931) = .040_r8*rxt(k,461)*y(k,293)
         mat(k,1965) = .030_r8*rxt(k,471)*y(k,293)
         mat(k,628) = .050_r8*rxt(k,473)*y(k,293)
         mat(k,1056) = .020_r8*rxt(k,482)*y(k,293)
         mat(k,1449) = .090_r8*rxt(k,486)*y(k,293)
         mat(k,2858) = .540_r8*rxt(k,524)*y(k,272)
         mat(k,3051) = .540_r8*rxt(k,479)*y(k,272)
         mat(k,2675) = .540_r8*rxt(k,475)*y(k,272)
         mat(k,3395) = .530_r8*rxt(k,476)*y(k,272)
         mat(k,2033) = .540_r8*rxt(k,524)*y(k,147) + .540_r8*rxt(k,479)*y(k,149) &
                      + .540_r8*rxt(k,475)*y(k,250) + .530_r8*rxt(k,476)*y(k,251) &
                      + 2.140_r8*rxt(k,478)*y(k,272)
         mat(k,3716) = mat(k,3716) + .040_r8*rxt(k,461)*y(k,115) + .030_r8*rxt(k,471) &
                      *y(k,118) + .050_r8*rxt(k,473)*y(k,119) + .020_r8*rxt(k,482) &
                      *y(k,120) + .090_r8*rxt(k,486)*y(k,121)
         mat(k,103) = -(rxt(k,811)*y(k,293))
         mat(k,3534) = -rxt(k,811)*y(k,143)
         mat(k,2885) = -(rxt(k,194)*y(k,136) + rxt(k,203)*y(k,149) + rxt(k,207) &
                      *y(k,256) + rxt(k,208)*y(k,157) + rxt(k,209)*y(k,156) + rxt(k,230) &
                      *y(k,60) + rxt(k,262)*y(k,20) + rxt(k,305)*y(k,251) + rxt(k,315) &
                      *y(k,257) + rxt(k,328)*y(k,247) + rxt(k,339)*y(k,250) + rxt(k,343) &
                      *y(k,255) + rxt(k,358)*y(k,248) + rxt(k,367)*y(k,295) + rxt(k,371) &
                      *y(k,296) + (rxt(k,378) + rxt(k,379)) * y(k,253) + rxt(k,393) &
                      *y(k,284) + rxt(k,396)*y(k,286) + (rxt(k,411) + rxt(k,412) &
                      ) * y(k,234) + (rxt(k,504) + rxt(k,505)) * y(k,258) + (rxt(k,506) &
                      + rxt(k,507)) * y(k,259) + (rxt(k,508) + rxt(k,509)) * y(k,260) &
                      + (rxt(k,510) + rxt(k,511)) * y(k,265) + (rxt(k,512) + rxt(k,513) &
                      ) * y(k,266) + (rxt(k,514) + rxt(k,515)) * y(k,267) + (rxt(k,516) &
                      + rxt(k,517)) * y(k,268) + (rxt(k,518) + rxt(k,519)) * y(k,269) &
                      + (rxt(k,520) + rxt(k,521)) * y(k,270) + (rxt(k,522) + rxt(k,523) &
                      ) * y(k,271) + (rxt(k,524) + rxt(k,525)) * y(k,272) + (rxt(k,526) &
                      + rxt(k,527)) * y(k,273) + (rxt(k,528) + rxt(k,529)) * y(k,274) &
                      + (rxt(k,531) + rxt(k,532)) * y(k,276) + (rxt(k,534) + rxt(k,535) &
                      ) * y(k,277) + (rxt(k,536) + rxt(k,537)) * y(k,282) + (rxt(k,538) &
                      + rxt(k,539)) * y(k,287) + (rxt(k,540) + rxt(k,541)) * y(k,291) &
                      + rxt(k,543)*y(k,233) + rxt(k,546)*y(k,241) + rxt(k,551) &
                      *y(k,246) + rxt(k,553)*y(k,249) + rxt(k,557)*y(k,252) + rxt(k,560) &
                      *y(k,283) + rxt(k,563)*y(k,285) + rxt(k,566)*y(k,294) + rxt(k,573) &
                      *y(k,312) + rxt(k,579)*y(k,314) + rxt(k,582)*y(k,316) + rxt(k,590) &
                      *y(k,235) + rxt(k,598)*y(k,236) + rxt(k,610)*y(k,238) + rxt(k,618) &
                      *y(k,239) + rxt(k,630)*y(k,243) + rxt(k,638)*y(k,244) + rxt(k,650) &
                      *y(k,279) + rxt(k,658)*y(k,280) + rxt(k,670)*y(k,288) + rxt(k,678) &
                      *y(k,289) + rxt(k,689)*y(k,297) + rxt(k,693)*y(k,298) + rxt(k,697) &
                      *y(k,299) + rxt(k,705)*y(k,300) + rxt(k,713)*y(k,301) + rxt(k,723) &
                      *y(k,302) + rxt(k,732)*y(k,303) + rxt(k,742)*y(k,304) + rxt(k,753) &
                      *y(k,305) + rxt(k,762)*y(k,306) + rxt(k,767)*y(k,307) + rxt(k,774) &
                      *y(k,308) + rxt(k,778)*y(k,309) + rxt(k,782)*y(k,310) + rxt(k,786) &
                      *y(k,311))
         mat(k,318) = -rxt(k,194)*y(k,147)
         mat(k,3078) = -rxt(k,203)*y(k,147)
         mat(k,3281) = -rxt(k,207)*y(k,147)
         mat(k,2986) = -rxt(k,208)*y(k,147)
         mat(k,3452) = -rxt(k,209)*y(k,147)
         mat(k,3307) = -rxt(k,230)*y(k,147)
         mat(k,3788) = -rxt(k,262)*y(k,147)
         mat(k,3422) = -rxt(k,305)*y(k,147)
         mat(k,596) = -rxt(k,315)*y(k,147)
         mat(k,1246) = -rxt(k,328)*y(k,147)
         mat(k,2702) = -rxt(k,339)*y(k,147)
         mat(k,746) = -rxt(k,343)*y(k,147)
         mat(k,978) = -rxt(k,358)*y(k,147)
         mat(k,825) = -rxt(k,367)*y(k,147)
         mat(k,1229) = -rxt(k,371)*y(k,147)
         mat(k,538) = -(rxt(k,378) + rxt(k,379)) * y(k,147)
         mat(k,1501) = -rxt(k,393)*y(k,147)
         mat(k,659) = -rxt(k,396)*y(k,147)
         mat(k,1137) = -(rxt(k,411) + rxt(k,412)) * y(k,147)
         mat(k,1410) = -(rxt(k,504) + rxt(k,505)) * y(k,147)
         mat(k,1837) = -(rxt(k,506) + rxt(k,507)) * y(k,147)
         mat(k,1739) = -(rxt(k,508) + rxt(k,509)) * y(k,147)
         mat(k,1559) = -(rxt(k,510) + rxt(k,511)) * y(k,147)
         mat(k,1580) = -(rxt(k,512) + rxt(k,513)) * y(k,147)
         mat(k,1005) = -(rxt(k,514) + rxt(k,515)) * y(k,147)
         mat(k,1078) = -(rxt(k,516) + rxt(k,517)) * y(k,147)
         mat(k,990) = -(rxt(k,518) + rxt(k,519)) * y(k,147)
         mat(k,1016) = -(rxt(k,520) + rxt(k,521)) * y(k,147)
         mat(k,1324) = -(rxt(k,522) + rxt(k,523)) * y(k,147)
         mat(k,2039) = -(rxt(k,524) + rxt(k,525)) * y(k,147)
         mat(k,1189) = -(rxt(k,526) + rxt(k,527)) * y(k,147)
         mat(k,1265) = -(rxt(k,528) + rxt(k,529)) * y(k,147)
         mat(k,1789) = -(rxt(k,531) + rxt(k,532)) * y(k,147)
         mat(k,1677) = -(rxt(k,534) + rxt(k,535)) * y(k,147)
         mat(k,1390) = -(rxt(k,536) + rxt(k,537)) * y(k,147)
         mat(k,1376) = -(rxt(k,538) + rxt(k,539)) * y(k,147)
         mat(k,1489) = -(rxt(k,540) + rxt(k,541)) * y(k,147)
         mat(k,464) = -rxt(k,543)*y(k,147)
         mat(k,438) = -rxt(k,546)*y(k,147)
         mat(k,360) = -rxt(k,551)*y(k,147)
         mat(k,605) = -rxt(k,553)*y(k,147)
         mat(k,792) = -rxt(k,557)*y(k,147)
         mat(k,754) = -rxt(k,560)*y(k,147)
         mat(k,816) = -rxt(k,563)*y(k,147)
         mat(k,379) = -rxt(k,566)*y(k,147)
         mat(k,768) = -rxt(k,573)*y(k,147)
         mat(k,785) = -rxt(k,579)*y(k,147)
         mat(k,446) = -rxt(k,582)*y(k,147)
         mat(k,2129) = -rxt(k,590)*y(k,147)
         mat(k,2225) = -rxt(k,598)*y(k,147)
         mat(k,2062) = -rxt(k,610)*y(k,147)
         mat(k,2107) = -rxt(k,618)*y(k,147)
         mat(k,2342) = -rxt(k,630)*y(k,147)
         mat(k,2254) = -rxt(k,638)*y(k,147)
         mat(k,2315) = -rxt(k,650)*y(k,147)
         mat(k,2168) = -rxt(k,658)*y(k,147)
         mat(k,2376) = -rxt(k,670)*y(k,147)
         mat(k,2283) = -rxt(k,678)*y(k,147)
         mat(k,838) = -rxt(k,689)*y(k,147)
         mat(k,921) = -rxt(k,693)*y(k,147)
         mat(k,2454) = -rxt(k,697)*y(k,147)
         mat(k,2538) = -rxt(k,705)*y(k,147)
         mat(k,2496) = -rxt(k,713)*y(k,147)
         mat(k,2584) = -rxt(k,723)*y(k,147)
         mat(k,2084) = -rxt(k,732)*y(k,147)
         mat(k,2475) = -rxt(k,742)*y(k,147)
         mat(k,2631) = -rxt(k,753)*y(k,147)
         mat(k,683) = -rxt(k,762)*y(k,147)
         mat(k,848) = -rxt(k,767)*y(k,147)
         mat(k,1149) = -rxt(k,774)*y(k,147)
         mat(k,930) = -rxt(k,778)*y(k,147)
         mat(k,692) = -rxt(k,782)*y(k,147)
         mat(k,700) = -rxt(k,786)*y(k,147)
         mat(k,318) = mat(k,318) + 2.000_r8*rxt(k,196)*y(k,148) + rxt(k,206)*y(k,293)
         mat(k,3502) = 2.000_r8*rxt(k,196)*y(k,136) + rxt(k,199)*y(k,156) + rxt(k,803) &
                      *y(k,173)
         mat(k,3452) = mat(k,3452) + rxt(k,199)*y(k,148)
         mat(k,1516) = rxt(k,803)*y(k,148)
         mat(k,3742) = rxt(k,206)*y(k,136)
      end do
      end subroutine nlnmat06
      subroutine nlnmat07( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,3511) = -((rxt(k,195) + rxt(k,196) + rxt(k,197)) * y(k,136) + (rxt(k,199) &
                      + rxt(k,201)) * y(k,156) + rxt(k,200)*y(k,157) + rxt(k,212) &
                      *y(k,256) + rxt(k,213)*y(k,149) + rxt(k,214)*y(k,293) + rxt(k,232) &
                      *y(k,60) + rxt(k,263)*y(k,20) + rxt(k,352)*y(k,250) + rxt(k,407) &
                      *y(k,284) + rxt(k,558)*y(k,252) + rxt(k,561)*y(k,283) + rxt(k,564) &
                      *y(k,285) + rxt(k,568)*y(k,164) + rxt(k,571)*y(k,233) + rxt(k,685) &
                      *y(k,300) + rxt(k,686)*y(k,302) + rxt(k,687)*y(k,305) + rxt(k,803) &
                      *y(k,173))
         mat(k,320) = -(rxt(k,195) + rxt(k,196) + rxt(k,197)) * y(k,148)
         mat(k,3461) = -(rxt(k,199) + rxt(k,201)) * y(k,148)
         mat(k,2995) = -rxt(k,200)*y(k,148)
         mat(k,3290) = -rxt(k,212)*y(k,148)
         mat(k,3087) = -rxt(k,213)*y(k,148)
         mat(k,3751) = -rxt(k,214)*y(k,148)
         mat(k,3316) = -rxt(k,232)*y(k,148)
         mat(k,3797) = -rxt(k,263)*y(k,148)
         mat(k,2709) = -rxt(k,352)*y(k,148)
         mat(k,1507) = -rxt(k,407)*y(k,148)
         mat(k,795) = -rxt(k,558)*y(k,148)
         mat(k,756) = -rxt(k,561)*y(k,148)
         mat(k,819) = -rxt(k,564)*y(k,148)
         mat(k,408) = -rxt(k,568)*y(k,148)
         mat(k,466) = -rxt(k,571)*y(k,148)
         mat(k,2545) = -rxt(k,685)*y(k,148)
         mat(k,2591) = -rxt(k,686)*y(k,148)
         mat(k,2638) = -rxt(k,687)*y(k,148)
         mat(k,1521) = -rxt(k,803)*y(k,148)
         mat(k,642) = rxt(k,409)*y(k,293)
         mat(k,314) = rxt(k,375)*y(k,149)
         mat(k,3797) = mat(k,3797) + rxt(k,262)*y(k,147)
         mat(k,3316) = mat(k,3316) + rxt(k,230)*y(k,147)
         mat(k,367) = rxt(k,193)*y(k,293)
         mat(k,417) = .400_r8*rxt(k,423)*y(k,293)
         mat(k,1093) = .190_r8*rxt(k,424)*y(k,293)
         mat(k,1030) = rxt(k,453)*y(k,293)
         mat(k,1642) = .500_r8*rxt(k,455)*y(k,293)
         mat(k,1941) = .170_r8*rxt(k,460)*y(k,157) + .080_r8*rxt(k,461)*y(k,293)
         mat(k,580) = .150_r8*rxt(k,464)*y(k,293)
         mat(k,480) = .130_r8*rxt(k,467)*y(k,293)
         mat(k,1975) = .170_r8*rxt(k,470)*y(k,157) + .040_r8*rxt(k,471)*y(k,293)
         mat(k,1458) = .170_r8*rxt(k,485)*y(k,157) + .070_r8*rxt(k,486)*y(k,293)
         mat(k,1626) = .500_r8*rxt(k,381)*y(k,293)
         mat(k,2003) = .170_r8*rxt(k,502)*y(k,157) + .040_r8*rxt(k,503)*y(k,293)
         mat(k,2894) = rxt(k,262)*y(k,20) + rxt(k,230)*y(k,60) + 2.000_r8*rxt(k,203) &
                      *y(k,149) + rxt(k,209)*y(k,156) + rxt(k,208)*y(k,157) &
                      + rxt(k,543)*y(k,233) + rxt(k,411)*y(k,234) &
                      + 1.860_r8*rxt(k,590)*y(k,235) + .770_r8*rxt(k,598)*y(k,236) &
                      + 1.860_r8*rxt(k,610)*y(k,238) + .700_r8*rxt(k,618)*y(k,239) &
                      + rxt(k,546)*y(k,241) + 1.390_r8*rxt(k,630)*y(k,243) &
                      + .750_r8*rxt(k,638)*y(k,244) + rxt(k,551)*y(k,246) + rxt(k,328) &
                      *y(k,247) + rxt(k,358)*y(k,248) + rxt(k,553)*y(k,249) &
                      + rxt(k,339)*y(k,250) + rxt(k,305)*y(k,251) + rxt(k,557) &
                      *y(k,252) + rxt(k,378)*y(k,253) + rxt(k,343)*y(k,255) &
                      + rxt(k,207)*y(k,256) + rxt(k,315)*y(k,257) + rxt(k,504) &
                      *y(k,258) + rxt(k,506)*y(k,259) + rxt(k,508)*y(k,260) &
                      + rxt(k,510)*y(k,265) + rxt(k,512)*y(k,266) + rxt(k,514) &
                      *y(k,267) + 1.730_r8*rxt(k,516)*y(k,268) + rxt(k,518)*y(k,269) &
                      + rxt(k,520)*y(k,270) + rxt(k,522)*y(k,271) &
                      + 1.460_r8*rxt(k,524)*y(k,272) + rxt(k,526)*y(k,273) &
                      + rxt(k,528)*y(k,274) + rxt(k,531)*y(k,276) + rxt(k,534) &
                      *y(k,277) + 1.360_r8*rxt(k,650)*y(k,279) + .770_r8*rxt(k,658) &
                      *y(k,280) + rxt(k,536)*y(k,282) + rxt(k,560)*y(k,283) &
                      + rxt(k,393)*y(k,284) + rxt(k,563)*y(k,285) + rxt(k,396) &
                      *y(k,286) + rxt(k,538)*y(k,287) + 1.820_r8*rxt(k,670)*y(k,288) &
                      + .710_r8*rxt(k,678)*y(k,289) + rxt(k,540)*y(k,291) + rxt(k,566) &
                      *y(k,294) + rxt(k,367)*y(k,295) + rxt(k,371)*y(k,296) &
                      + .700_r8*rxt(k,689)*y(k,297) + .700_r8*rxt(k,693)*y(k,298) &
                      + .700_r8*rxt(k,697)*y(k,299) + rxt(k,705)*y(k,300) &
                      + .830_r8*rxt(k,713)*y(k,301) + rxt(k,723)*y(k,302) &
                      + .700_r8*rxt(k,732)*y(k,303) + .910_r8*rxt(k,742)*y(k,304) &
                      + rxt(k,753)*y(k,305) + .700_r8*rxt(k,762)*y(k,306) &
                      + .700_r8*rxt(k,767)*y(k,307) + .700_r8*rxt(k,774)*y(k,308) &
                      + .700_r8*rxt(k,778)*y(k,309) + .700_r8*rxt(k,782)*y(k,310) &
                      + .700_r8*rxt(k,786)*y(k,311) + rxt(k,573)*y(k,312) + rxt(k,579) &
                      *y(k,314) + rxt(k,582)*y(k,316)
         mat(k,3087) = mat(k,3087) + rxt(k,375)*y(k,16) + 2.000_r8*rxt(k,203)*y(k,147) &
                      + rxt(k,204)*y(k,156) + rxt(k,760)*y(k,210) + .500_r8*rxt(k,765) &
                      *y(k,211) + 2.000_r8*rxt(k,591)*y(k,235) + rxt(k,599)*y(k,236) &
                      + 2.000_r8*rxt(k,611)*y(k,238) + rxt(k,619)*y(k,239) &
                      + 1.500_r8*rxt(k,631)*y(k,243) + rxt(k,639)*y(k,244) &
                      + rxt(k,202)*y(k,256) + 1.460_r8*rxt(k,479)*y(k,272) &
                      + 1.460_r8*rxt(k,651)*y(k,279) + rxt(k,659)*y(k,280) &
                      + rxt(k,394)*y(k,284) + 1.950_r8*rxt(k,671)*y(k,288) &
                      + rxt(k,679)*y(k,289) + rxt(k,205)*y(k,293) + rxt(k,698) &
                      *y(k,299) + rxt(k,706)*y(k,300) + rxt(k,714)*y(k,301) &
                      + rxt(k,724)*y(k,302) + rxt(k,733)*y(k,303) + rxt(k,743) &
                      *y(k,304) + rxt(k,754)*y(k,305)
         mat(k,1274) = rxt(k,349)*y(k,293)
         mat(k,1347) = rxt(k,365)*y(k,293)
         mat(k,3461) = mat(k,3461) + rxt(k,209)*y(k,147) + rxt(k,204)*y(k,149)
         mat(k,2995) = mat(k,2995) + .170_r8*rxt(k,460)*y(k,115) + .170_r8*rxt(k,470) &
                      *y(k,118) + .170_r8*rxt(k,485)*y(k,121) + .170_r8*rxt(k,502) &
                      *y(k,139) + rxt(k,208)*y(k,147)
         mat(k,512) = rxt(k,719)*y(k,293)
         mat(k,520) = rxt(k,738)*y(k,293)
         mat(k,348) = rxt(k,758)*y(k,293)
         mat(k,2434) = rxt(k,760)*y(k,149)
         mat(k,2407) = .500_r8*rxt(k,765)*y(k,149)
         mat(k,1158) = rxt(k,770)*y(k,293)
         mat(k,1466) = rxt(k,784)*y(k,293)
         mat(k,1400) = rxt(k,788)*y(k,293)
         mat(k,466) = mat(k,466) + rxt(k,543)*y(k,147)
         mat(k,1140) = rxt(k,411)*y(k,147)
         mat(k,2134) = 1.860_r8*rxt(k,590)*y(k,147) + 2.000_r8*rxt(k,591)*y(k,149) &
                      + 3.280_r8*rxt(k,586)*y(k,235) + rxt(k,587)*y(k,250) &
                      + .820_r8*rxt(k,588)*y(k,251) + .700_r8*rxt(k,589)*y(k,256) &
                      + rxt(k,592)*y(k,300) + rxt(k,593)*y(k,302) + rxt(k,594) &
                      *y(k,305)
         mat(k,2230) = .770_r8*rxt(k,598)*y(k,147) + rxt(k,599)*y(k,149)
         mat(k,2067) = 1.860_r8*rxt(k,610)*y(k,147) + 2.000_r8*rxt(k,611)*y(k,149) &
                      + 3.280_r8*rxt(k,606)*y(k,238) + rxt(k,607)*y(k,250) &
                      + .820_r8*rxt(k,608)*y(k,251) + .500_r8*rxt(k,609)*y(k,256) &
                      + rxt(k,612)*y(k,300) + rxt(k,613)*y(k,302) + rxt(k,614) &
                      *y(k,305)
         mat(k,2112) = .700_r8*rxt(k,618)*y(k,147) + rxt(k,619)*y(k,149)
         mat(k,440) = rxt(k,546)*y(k,147)
         mat(k,2347) = 1.390_r8*rxt(k,630)*y(k,147) + 1.500_r8*rxt(k,631)*y(k,149) &
                      + 1.880_r8*rxt(k,626)*y(k,243) + .500_r8*rxt(k,627)*y(k,250) &
                      + .360_r8*rxt(k,628)*y(k,251) + .240_r8*rxt(k,629)*y(k,256) &
                      + .500_r8*rxt(k,632)*y(k,300) + .500_r8*rxt(k,633)*y(k,302) &
                      + .500_r8*rxt(k,634)*y(k,305)
         mat(k,2259) = .750_r8*rxt(k,638)*y(k,147) + rxt(k,639)*y(k,149)
         mat(k,362) = rxt(k,551)*y(k,147)
         mat(k,1250) = rxt(k,328)*y(k,147)
         mat(k,982) = rxt(k,358)*y(k,147)
         mat(k,608) = rxt(k,553)*y(k,147)
         mat(k,2709) = mat(k,2709) + rxt(k,339)*y(k,147) + rxt(k,587)*y(k,235) &
                      + rxt(k,607)*y(k,238) + .500_r8*rxt(k,627)*y(k,243) &
                      + .460_r8*rxt(k,475)*y(k,272) + .460_r8*rxt(k,646)*y(k,279) &
                      + .950_r8*rxt(k,666)*y(k,288)
         mat(k,3431) = rxt(k,305)*y(k,147) + .820_r8*rxt(k,588)*y(k,235) &
                      + .820_r8*rxt(k,608)*y(k,238) + .360_r8*rxt(k,628)*y(k,243) &
                      + .070_r8*rxt(k,476)*y(k,272) + .310_r8*rxt(k,647)*y(k,279) &
                      + .770_r8*rxt(k,667)*y(k,288)
         mat(k,795) = mat(k,795) + rxt(k,557)*y(k,147)
         mat(k,541) = rxt(k,378)*y(k,147)
         mat(k,749) = rxt(k,343)*y(k,147)
         mat(k,3290) = mat(k,3290) + rxt(k,207)*y(k,147) + rxt(k,202)*y(k,149) &
                      + .700_r8*rxt(k,589)*y(k,235) + .500_r8*rxt(k,609)*y(k,238) &
                      + .240_r8*rxt(k,629)*y(k,243) + .460_r8*rxt(k,462)*y(k,268) &
                      + .240_r8*rxt(k,477)*y(k,272) + .230_r8*rxt(k,648)*y(k,279) &
                      + .480_r8*rxt(k,668)*y(k,288)
         mat(k,599) = rxt(k,315)*y(k,147)
         mat(k,1412) = rxt(k,504)*y(k,147)
         mat(k,1841) = rxt(k,506)*y(k,147)
         mat(k,1743) = rxt(k,508)*y(k,147)
         mat(k,1563) = rxt(k,510)*y(k,147)
         mat(k,1584) = rxt(k,512)*y(k,147)
         mat(k,1008) = rxt(k,514)*y(k,147)
         mat(k,1081) = 1.730_r8*rxt(k,516)*y(k,147) + .460_r8*rxt(k,462)*y(k,256)
         mat(k,993) = rxt(k,518)*y(k,147)
         mat(k,1019) = rxt(k,520)*y(k,147)
         mat(k,1327) = rxt(k,522)*y(k,147)
         mat(k,2046) = 1.460_r8*rxt(k,524)*y(k,147) + 1.460_r8*rxt(k,479)*y(k,149) &
                      + .460_r8*rxt(k,475)*y(k,250) + .070_r8*rxt(k,476)*y(k,251) &
                      + .240_r8*rxt(k,477)*y(k,256) + .320_r8*rxt(k,478)*y(k,272)
         mat(k,1192) = rxt(k,526)*y(k,147)
         mat(k,1268) = rxt(k,528)*y(k,147)
         mat(k,1793) = rxt(k,531)*y(k,147)
         mat(k,1681) = rxt(k,534)*y(k,147)
         mat(k,2320) = 1.360_r8*rxt(k,650)*y(k,147) + 1.460_r8*rxt(k,651)*y(k,149) &
                      + .460_r8*rxt(k,646)*y(k,250) + .310_r8*rxt(k,647)*y(k,251) &
                      + .230_r8*rxt(k,648)*y(k,256) + 1.720_r8*rxt(k,649)*y(k,279) &
                      + .460_r8*rxt(k,652)*y(k,300) + .460_r8*rxt(k,653)*y(k,302) &
                      + .460_r8*rxt(k,654)*y(k,305)
         mat(k,2173) = .770_r8*rxt(k,658)*y(k,147) + rxt(k,659)*y(k,149)
         mat(k,1394) = rxt(k,536)*y(k,147)
         mat(k,756) = mat(k,756) + rxt(k,560)*y(k,147)
         mat(k,1507) = mat(k,1507) + rxt(k,393)*y(k,147) + rxt(k,394)*y(k,149)
         mat(k,819) = mat(k,819) + rxt(k,563)*y(k,147)
         mat(k,661) = rxt(k,396)*y(k,147)
         mat(k,1380) = rxt(k,538)*y(k,147)
         mat(k,2381) = 1.820_r8*rxt(k,670)*y(k,147) + 1.950_r8*rxt(k,671)*y(k,149) &
                      + .950_r8*rxt(k,666)*y(k,250) + .770_r8*rxt(k,667)*y(k,251) &
                      + .480_r8*rxt(k,668)*y(k,256) + 3.080_r8*rxt(k,669)*y(k,288) &
                      + .950_r8*rxt(k,672)*y(k,300) + .950_r8*rxt(k,673)*y(k,302) &
                      + .950_r8*rxt(k,674)*y(k,305)
         mat(k,2288) = .710_r8*rxt(k,678)*y(k,147) + rxt(k,679)*y(k,149)
         mat(k,1492) = rxt(k,540)*y(k,147)
         mat(k,3751) = mat(k,3751) + rxt(k,409)*y(k,1) + rxt(k,193)*y(k,94) &
                      + .400_r8*rxt(k,423)*y(k,107) + .190_r8*rxt(k,424)*y(k,108) &
                      + rxt(k,453)*y(k,111) + .500_r8*rxt(k,455)*y(k,112) &
                      + .080_r8*rxt(k,461)*y(k,115) + .150_r8*rxt(k,464)*y(k,116) &
                      + .130_r8*rxt(k,467)*y(k,117) + .040_r8*rxt(k,471)*y(k,118) &
                      + .070_r8*rxt(k,486)*y(k,121) + .500_r8*rxt(k,381)*y(k,127) &
                      + .040_r8*rxt(k,503)*y(k,139) + rxt(k,205)*y(k,149) + rxt(k,349) &
                      *y(k,150) + rxt(k,365)*y(k,151) + rxt(k,719)*y(k,202) &
                      + rxt(k,738)*y(k,204) + rxt(k,758)*y(k,208) + rxt(k,770) &
                      *y(k,212) + rxt(k,784)*y(k,219) + rxt(k,788)*y(k,221)
         mat(k,381) = rxt(k,566)*y(k,147)
         mat(k,828) = rxt(k,367)*y(k,147)
         mat(k,1233) = rxt(k,371)*y(k,147)
         mat(k,841) = .700_r8*rxt(k,689)*y(k,147)
         mat(k,923) = .700_r8*rxt(k,693)*y(k,147)
         mat(k,2459) = .700_r8*rxt(k,697)*y(k,147) + rxt(k,698)*y(k,149)
         mat(k,2545) = mat(k,2545) + rxt(k,705)*y(k,147) + rxt(k,706)*y(k,149) &
                      + rxt(k,592)*y(k,235) + rxt(k,612)*y(k,238) + .500_r8*rxt(k,632) &
                      *y(k,243) + .460_r8*rxt(k,652)*y(k,279) + .950_r8*rxt(k,672) &
                      *y(k,288)
         mat(k,2501) = .830_r8*rxt(k,713)*y(k,147) + rxt(k,714)*y(k,149)
         mat(k,2591) = mat(k,2591) + rxt(k,723)*y(k,147) + rxt(k,724)*y(k,149) &
                      + rxt(k,593)*y(k,235) + rxt(k,613)*y(k,238) + .500_r8*rxt(k,633) &
                      *y(k,243) + .460_r8*rxt(k,653)*y(k,279) + .950_r8*rxt(k,673) &
                      *y(k,288)
         mat(k,2089) = .700_r8*rxt(k,732)*y(k,147) + rxt(k,733)*y(k,149)
         mat(k,2480) = .910_r8*rxt(k,742)*y(k,147) + rxt(k,743)*y(k,149)
         mat(k,2638) = mat(k,2638) + rxt(k,753)*y(k,147) + rxt(k,754)*y(k,149) &
                      + rxt(k,594)*y(k,235) + rxt(k,614)*y(k,238) + .500_r8*rxt(k,634) &
                      *y(k,243) + .460_r8*rxt(k,654)*y(k,279) + .950_r8*rxt(k,674) &
                      *y(k,288)
         mat(k,686) = .700_r8*rxt(k,762)*y(k,147)
         mat(k,850) = .700_r8*rxt(k,767)*y(k,147)
         mat(k,1151) = .700_r8*rxt(k,774)*y(k,147)
         mat(k,932) = .700_r8*rxt(k,778)*y(k,147)
         mat(k,694) = .700_r8*rxt(k,782)*y(k,147)
         mat(k,702) = .700_r8*rxt(k,786)*y(k,147)
         mat(k,770) = rxt(k,573)*y(k,147)
         mat(k,787) = rxt(k,579)*y(k,147)
         mat(k,448) = rxt(k,582)*y(k,147)
      end do
      end subroutine nlnmat07
      subroutine nlnmat08( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,3080) = -(rxt(k,202)*y(k,256) + rxt(k,203)*y(k,147) + rxt(k,204) &
                      *y(k,156) + rxt(k,205)*y(k,293) + rxt(k,213)*y(k,148) + rxt(k,299) &
                      *y(k,43) + rxt(k,333)*y(k,46) + rxt(k,354)*y(k,30) + rxt(k,361) &
                      *y(k,50) + rxt(k,375)*y(k,16) + rxt(k,394)*y(k,284) + rxt(k,474) &
                      *y(k,109) + rxt(k,479)*y(k,272) + rxt(k,585)*y(k,4) + rxt(k,591) &
                      *y(k,235) + rxt(k,599)*y(k,236) + rxt(k,605)*y(k,7) + rxt(k,611) &
                      *y(k,238) + rxt(k,619)*y(k,239) + rxt(k,625)*y(k,17) + rxt(k,631) &
                      *y(k,243) + rxt(k,639)*y(k,244) + rxt(k,645)*y(k,125) + rxt(k,651) &
                      *y(k,279) + rxt(k,659)*y(k,280) + rxt(k,665)*y(k,135) + rxt(k,671) &
                      *y(k,288) + rxt(k,679)*y(k,289) + rxt(k,698)*y(k,299) + rxt(k,706) &
                      *y(k,300) + rxt(k,709)*y(k,201) + rxt(k,714)*y(k,301) + rxt(k,724) &
                      *y(k,302) + rxt(k,728)*y(k,203) + rxt(k,733)*y(k,303) + rxt(k,743) &
                      *y(k,304) + rxt(k,754)*y(k,305) + rxt(k,756)*y(k,200) + rxt(k,760) &
                      *y(k,210) + rxt(k,765)*y(k,211) + rxt(k,794)*y(k,69))
         mat(k,3283) = -rxt(k,202)*y(k,149)
         mat(k,2887) = -rxt(k,203)*y(k,149)
         mat(k,3454) = -rxt(k,204)*y(k,149)
         mat(k,3744) = -rxt(k,205)*y(k,149)
         mat(k,3504) = -rxt(k,213)*y(k,149)
         mat(k,3333) = -rxt(k,299)*y(k,149)
         mat(k,1309) = -rxt(k,333)*y(k,149)
         mat(k,1204) = -rxt(k,354)*y(k,149)
         mat(k,1849) = -rxt(k,361)*y(k,149)
         mat(k,312) = -rxt(k,375)*y(k,149)
         mat(k,1503) = -rxt(k,394)*y(k,149)
         mat(k,1299) = -rxt(k,474)*y(k,149)
         mat(k,2041) = -rxt(k,479)*y(k,149)
         mat(k,1114) = -rxt(k,585)*y(k,149)
         mat(k,2130) = -rxt(k,591)*y(k,149)
         mat(k,2226) = -rxt(k,599)*y(k,149)
         mat(k,867) = -rxt(k,605)*y(k,149)
         mat(k,2063) = -rxt(k,611)*y(k,149)
         mat(k,2108) = -rxt(k,619)*y(k,149)
         mat(k,951) = -rxt(k,625)*y(k,149)
         mat(k,2343) = -rxt(k,631)*y(k,149)
         mat(k,2255) = -rxt(k,639)*y(k,149)
         mat(k,971) = -rxt(k,645)*y(k,149)
         mat(k,2316) = -rxt(k,651)*y(k,149)
         mat(k,2169) = -rxt(k,659)*y(k,149)
         mat(k,717) = -rxt(k,665)*y(k,149)
         mat(k,2377) = -rxt(k,671)*y(k,149)
         mat(k,2284) = -rxt(k,679)*y(k,149)
         mat(k,2455) = -rxt(k,698)*y(k,149)
         mat(k,2540) = -rxt(k,706)*y(k,149)
         mat(k,1172) = -rxt(k,709)*y(k,149)
         mat(k,2497) = -rxt(k,714)*y(k,149)
         mat(k,2586) = -rxt(k,724)*y(k,149)
         mat(k,1650) = -rxt(k,728)*y(k,149)
         mat(k,2085) = -rxt(k,733)*y(k,149)
         mat(k,2476) = -rxt(k,743)*y(k,149)
         mat(k,2633) = -rxt(k,754)*y(k,149)
         mat(k,2199) = -rxt(k,756)*y(k,149)
         mat(k,2430) = -rxt(k,760)*y(k,149)
         mat(k,2403) = -rxt(k,765)*y(k,149)
         mat(k,241) = -rxt(k,794)*y(k,149)
         mat(k,494) = rxt(k,264)*y(k,156)
         mat(k,3825) = rxt(k,231)*y(k,61)
         mat(k,1215) = rxt(k,231)*y(k,57) + rxt(k,233)*y(k,156) + rxt(k,234)*y(k,293)
         mat(k,901) = rxt(k,278)*y(k,93)
         mat(k,2719) = rxt(k,278)*y(k,75) + rxt(k,215)*y(k,293)
         mat(k,395) = rxt(k,399)*y(k,293)
         mat(k,3504) = mat(k,3504) + rxt(k,201)*y(k,156) + rxt(k,200)*y(k,157)
         mat(k,3454) = mat(k,3454) + rxt(k,264)*y(k,21) + rxt(k,233)*y(k,61) &
                      + rxt(k,201)*y(k,148)
         mat(k,2988) = rxt(k,200)*y(k,148)
         mat(k,400) = rxt(k,350)*y(k,293)
         mat(k,3744) = mat(k,3744) + rxt(k,234)*y(k,61) + rxt(k,215)*y(k,93) &
                      + rxt(k,399)*y(k,131) + rxt(k,350)*y(k,162)
         mat(k,1270) = -(rxt(k,349)*y(k,293))
         mat(k,3672) = -rxt(k,349)*y(k,150)
         mat(k,1950) = .830_r8*rxt(k,470)*y(k,157)
         mat(k,1434) = .130_r8*rxt(k,485)*y(k,157)
         mat(k,1982) = .220_r8*rxt(k,502)*y(k,157) + .100_r8*rxt(k,503)*y(k,293)
         mat(k,2819) = .870_r8*rxt(k,520)*y(k,270) + .330_r8*rxt(k,522)*y(k,271) &
                      + .070_r8*rxt(k,526)*y(k,273) + .150_r8*rxt(k,528)*y(k,274) &
                      + .120_r8*rxt(k,540)*y(k,291)
         mat(k,2929) = .830_r8*rxt(k,470)*y(k,118) + .130_r8*rxt(k,485)*y(k,121) &
                      + .220_r8*rxt(k,502)*y(k,139)
         mat(k,3212) = .440_r8*rxt(k,468)*y(k,270) + .150_r8*rxt(k,472)*y(k,271) &
                      + .060_r8*rxt(k,480)*y(k,273) + .120_r8*rxt(k,483)*y(k,274) &
                      + .100_r8*rxt(k,500)*y(k,291)
         mat(k,1011) = .870_r8*rxt(k,520)*y(k,147) + .440_r8*rxt(k,468)*y(k,256)
         mat(k,1314) = .330_r8*rxt(k,522)*y(k,147) + .150_r8*rxt(k,472)*y(k,256)
         mat(k,1181) = .070_r8*rxt(k,526)*y(k,147) + .060_r8*rxt(k,480)*y(k,256)
         mat(k,1256) = .150_r8*rxt(k,528)*y(k,147) + .120_r8*rxt(k,483)*y(k,256)
         mat(k,1476) = .120_r8*rxt(k,540)*y(k,147) + .100_r8*rxt(k,500)*y(k,256)
         mat(k,3672) = mat(k,3672) + .100_r8*rxt(k,503)*y(k,139)
         mat(k,1343) = -(rxt(k,365)*y(k,293))
         mat(k,3678) = -rxt(k,365)*y(k,151)
         mat(k,1199) = rxt(k,354)*y(k,149)
         mat(k,1085) = .350_r8*rxt(k,424)*y(k,293)
         mat(k,1918) = .830_r8*rxt(k,460)*y(k,157)
         mat(k,1436) = .700_r8*rxt(k,485)*y(k,157)
         mat(k,1617) = .500_r8*rxt(k,381)*y(k,293)
         mat(k,1798) = .500_r8*rxt(k,400)*y(k,293)
         mat(k,1983) = .610_r8*rxt(k,502)*y(k,157) + .350_r8*rxt(k,503)*y(k,293)
         mat(k,2824) = .940_r8*rxt(k,514)*y(k,267) + .340_r8*rxt(k,522)*y(k,271) &
                      + .400_r8*rxt(k,526)*y(k,273) + .810_r8*rxt(k,528)*y(k,274) &
                      + .130_r8*rxt(k,540)*y(k,291)
         mat(k,3023) = rxt(k,354)*y(k,30)
         mat(k,2932) = .830_r8*rxt(k,460)*y(k,115) + .700_r8*rxt(k,485)*y(k,121) &
                      + .610_r8*rxt(k,502)*y(k,139)
         mat(k,3217) = .550_r8*rxt(k,458)*y(k,267) + .150_r8*rxt(k,472)*y(k,271) &
                      + .280_r8*rxt(k,480)*y(k,273) + .680_r8*rxt(k,483)*y(k,274) &
                      + .100_r8*rxt(k,500)*y(k,291)
         mat(k,1001) = .940_r8*rxt(k,514)*y(k,147) + .550_r8*rxt(k,458)*y(k,256)
         mat(k,1317) = .340_r8*rxt(k,522)*y(k,147) + .150_r8*rxt(k,472)*y(k,256)
         mat(k,1183) = .400_r8*rxt(k,526)*y(k,147) + .280_r8*rxt(k,480)*y(k,256)
         mat(k,1258) = .810_r8*rxt(k,528)*y(k,147) + .680_r8*rxt(k,483)*y(k,256)
         mat(k,1478) = .130_r8*rxt(k,540)*y(k,147) + .100_r8*rxt(k,500)*y(k,256)
         mat(k,3678) = mat(k,3678) + .350_r8*rxt(k,424)*y(k,108) + .500_r8*rxt(k,381) &
                      *y(k,127) + .500_r8*rxt(k,400)*y(k,133) + .350_r8*rxt(k,503) &
                      *y(k,139)
         mat(k,3460) = -(rxt(k,173)*y(k,157) + 4._r8*rxt(k,174)*y(k,156) + rxt(k,176) &
                      *y(k,79) + rxt(k,177)*y(k,81) + rxt(k,182)*y(k,256) + rxt(k,188) &
                      *y(k,293) + (rxt(k,199) + rxt(k,201)) * y(k,148) + rxt(k,204) &
                      *y(k,149) + rxt(k,209)*y(k,147) + rxt(k,233)*y(k,61) + rxt(k,235) &
                      *y(k,60) + rxt(k,238)*y(k,87) + rxt(k,241)*y(k,96) + rxt(k,264) &
                      *y(k,21) + rxt(k,265)*y(k,20) + rxt(k,267)*y(k,83) + rxt(k,269) &
                      *y(k,95) + rxt(k,300)*y(k,43) + rxt(k,796)*y(k,160))
         mat(k,2994) = -rxt(k,173)*y(k,156)
         mat(k,1422) = -rxt(k,176)*y(k,156)
         mat(k,1351) = -rxt(k,177)*y(k,156)
         mat(k,3289) = -rxt(k,182)*y(k,156)
         mat(k,3750) = -rxt(k,188)*y(k,156)
         mat(k,3510) = -(rxt(k,199) + rxt(k,201)) * y(k,156)
         mat(k,3086) = -rxt(k,204)*y(k,156)
         mat(k,2893) = -rxt(k,209)*y(k,156)
         mat(k,1217) = -rxt(k,233)*y(k,156)
         mat(k,3315) = -rxt(k,235)*y(k,156)
         mat(k,3772) = -rxt(k,238)*y(k,156)
         mat(k,1066) = -rxt(k,241)*y(k,156)
         mat(k,495) = -rxt(k,264)*y(k,156)
         mat(k,3796) = -rxt(k,265)*y(k,156)
         mat(k,1043) = -rxt(k,267)*y(k,156)
         mat(k,908) = -rxt(k,269)*y(k,156)
         mat(k,3339) = -rxt(k,300)*y(k,156)
         mat(k,306) = -rxt(k,796)*y(k,156)
         mat(k,2736) = rxt(k,180)*y(k,256)
         mat(k,319) = rxt(k,194)*y(k,147) + rxt(k,195)*y(k,148)
         mat(k,2893) = mat(k,2893) + rxt(k,194)*y(k,136)
         mat(k,3510) = mat(k,3510) + rxt(k,195)*y(k,136)
         mat(k,3289) = mat(k,3289) + rxt(k,180)*y(k,78)
         mat(k,3750) = mat(k,3750) + 2.000_r8*rxt(k,190)*y(k,293)
         mat(k,2987) = -(rxt(k,172)*y(k,292) + rxt(k,173)*y(k,156) + rxt(k,183) &
                      *y(k,256) + rxt(k,184)*y(k,78) + rxt(k,189)*y(k,293) + rxt(k,200) &
                      *y(k,148) + rxt(k,208)*y(k,147) + rxt(k,224)*y(k,57) + rxt(k,256) &
                      *y(k,18) + rxt(k,324)*y(k,26) + rxt(k,355)*y(k,30) + rxt(k,386) &
                      *y(k,126) + rxt(k,404)*y(k,132) + rxt(k,460)*y(k,115) + rxt(k,470) &
                      *y(k,118) + rxt(k,485)*y(k,121) + rxt(k,487)*y(k,109) + rxt(k,502) &
                      *y(k,139) + rxt(k,569)*y(k,164) + rxt(k,603)*y(k,4) + rxt(k,623) &
                      *y(k,7) + rxt(k,643)*y(k,17) + rxt(k,663)*y(k,125) + rxt(k,683) &
                      *y(k,135) + rxt(k,763)*y(k,210) + rxt(k,768)*y(k,211) + rxt(k,799) &
                      *y(k,171) + rxt(k,805)*y(k,173))
         mat(k,3103) = -rxt(k,172)*y(k,157)
         mat(k,3453) = -rxt(k,173)*y(k,157)
         mat(k,3282) = -rxt(k,183)*y(k,157)
         mat(k,2731) = -rxt(k,184)*y(k,157)
         mat(k,3743) = -rxt(k,189)*y(k,157)
         mat(k,3503) = -rxt(k,200)*y(k,157)
         mat(k,2886) = -rxt(k,208)*y(k,157)
         mat(k,3824) = -rxt(k,224)*y(k,157)
         mat(k,1687) = -rxt(k,256)*y(k,157)
         mat(k,502) = -rxt(k,324)*y(k,157)
         mat(k,1203) = -rxt(k,355)*y(k,157)
         mat(k,1757) = -rxt(k,386)*y(k,157)
         mat(k,1868) = -rxt(k,404)*y(k,157)
         mat(k,1936) = -rxt(k,460)*y(k,157)
         mat(k,1970) = -rxt(k,470)*y(k,157)
         mat(k,1454) = -rxt(k,485)*y(k,157)
         mat(k,1298) = -rxt(k,487)*y(k,157)
         mat(k,1998) = -rxt(k,502)*y(k,157)
         mat(k,407) = -rxt(k,569)*y(k,157)
         mat(k,1113) = -rxt(k,603)*y(k,157)
         mat(k,866) = -rxt(k,623)*y(k,157)
         mat(k,950) = -rxt(k,643)*y(k,157)
         mat(k,970) = -rxt(k,663)*y(k,157)
         mat(k,716) = -rxt(k,683)*y(k,157)
         mat(k,2429) = -rxt(k,763)*y(k,157)
         mat(k,2402) = -rxt(k,768)*y(k,157)
         mat(k,458) = -rxt(k,799)*y(k,157)
         mat(k,1517) = -rxt(k,805)*y(k,157)
         mat(k,2703) = .150_r8*rxt(k,338)*y(k,256)
         mat(k,3282) = mat(k,3282) + .150_r8*rxt(k,338)*y(k,250) + .150_r8*rxt(k,391) &
                      *y(k,284) + .150_r8*rxt(k,704)*y(k,300) + .150_r8*rxt(k,722) &
                      *y(k,302) + .150_r8*rxt(k,752)*y(k,305)
         mat(k,1502) = .150_r8*rxt(k,391)*y(k,256)
         mat(k,2539) = .150_r8*rxt(k,704)*y(k,256)
         mat(k,2585) = .150_r8*rxt(k,722)*y(k,256)
         mat(k,2632) = .150_r8*rxt(k,752)*y(k,256)
         mat(k,275) = -(rxt(k,806)*y(k,173))
         mat(k,1510) = -rxt(k,806)*y(k,159)
         mat(k,3780) = rxt(k,258)*y(k,60)
         mat(k,3299) = rxt(k,258)*y(k,20) + 2.000_r8*rxt(k,228)*y(k,60)
         mat(k,300) = -(rxt(k,796)*y(k,156) + rxt(k,797)*y(k,293))
         mat(k,3437) = -rxt(k,796)*y(k,160)
         mat(k,3568) = -rxt(k,797)*y(k,160)
         mat(k,875) = rxt(k,380)*y(k,293)
         mat(k,1796) = .500_r8*rxt(k,400)*y(k,293)
         mat(k,3542) = rxt(k,380)*y(k,97) + .500_r8*rxt(k,400)*y(k,133)
         mat(k,398) = -(rxt(k,350)*y(k,293))
         mat(k,3583) = -rxt(k,350)*y(k,162)
         mat(k,3473) = rxt(k,352)*y(k,250)
         mat(k,2643) = rxt(k,352)*y(k,148)
      end do
      end subroutine nlnmat08
      subroutine nlnmat09( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,3467) = rxt(k,571)*y(k,233)
         mat(k,461) = rxt(k,571)*y(k,148)
         mat(k,405) = -(rxt(k,568)*y(k,148) + rxt(k,569)*y(k,157))
         mat(k,3474) = -rxt(k,568)*y(k,164)
         mat(k,2906) = -rxt(k,569)*y(k,164)
         mat(k,170) = .070_r8*rxt(k,555)*y(k,293)
         mat(k,2767) = rxt(k,553)*y(k,249)
         mat(k,143) = .060_r8*rxt(k,567)*y(k,293)
         mat(k,188) = .070_r8*rxt(k,583)*y(k,293)
         mat(k,603) = rxt(k,553)*y(k,147)
         mat(k,3584) = .070_r8*rxt(k,555)*y(k,67) + .060_r8*rxt(k,567)*y(k,165) &
                      + .070_r8*rxt(k,583)*y(k,229)
         mat(k,141) = -(rxt(k,567)*y(k,293))
         mat(k,3540) = -rxt(k,567)*y(k,165)
         mat(k,133) = .530_r8*rxt(k,544)*y(k,293)
         mat(k,3540) = mat(k,3540) + .530_r8*rxt(k,544)*y(k,8)
         mat(k,280) = -(rxt(k,570)*y(k,293))
         mat(k,3564) = -rxt(k,570)*y(k,166)
         mat(k,3139) = rxt(k,565)*y(k,294)
         mat(k,376) = rxt(k,565)*y(k,256)
         mat(k,482) = -(rxt(k,368)*y(k,293))
         mat(k,3595) = -rxt(k,368)*y(k,169)
         mat(k,3158) = rxt(k,366)*y(k,295)
         mat(k,821) = rxt(k,366)*y(k,256)
         mat(k,332) = -(rxt(k,372)*y(k,293))
         mat(k,3572) = -rxt(k,372)*y(k,170)
         mat(k,3144) = .850_r8*rxt(k,370)*y(k,296)
         mat(k,1223) = .850_r8*rxt(k,370)*y(k,256)
         mat(k,455) = -(rxt(k,799)*y(k,157) + rxt(k,802)*y(k,293))
         mat(k,2907) = -rxt(k,799)*y(k,171)
         mat(k,3591) = -rxt(k,802)*y(k,171)
         mat(k,1513) = -(rxt(k,800)*y(k,20) + rxt(k,801)*y(k,60) + rxt(k,803)*y(k,148) &
                      + rxt(k,805)*y(k,157) + rxt(k,806)*y(k,159) + rxt(k,807) &
                      *y(k,293))
         mat(k,3784) = -rxt(k,800)*y(k,173)
         mat(k,3303) = -rxt(k,801)*y(k,173)
         mat(k,3489) = -rxt(k,803)*y(k,173)
         mat(k,2938) = -rxt(k,805)*y(k,173)
         mat(k,277) = -rxt(k,806)*y(k,173)
         mat(k,3692) = -rxt(k,807)*y(k,173)
         mat(k,3447) = rxt(k,796)*y(k,160)
         mat(k,2938) = mat(k,2938) + rxt(k,799)*y(k,171)
         mat(k,303) = rxt(k,796)*y(k,156)
         mat(k,456) = rxt(k,799)*y(k,157) + rxt(k,802)*y(k,293)
         mat(k,3692) = mat(k,3692) + rxt(k,802)*y(k,171)
         mat(k,1161) = -(rxt(k,809)*y(k,293))
         mat(k,3662) = -rxt(k,809)*y(k,174)
         mat(k,3783) = rxt(k,800)*y(k,173)
         mat(k,3301) = rxt(k,801)*y(k,173)
         mat(k,239) = rxt(k,794)*y(k,149) + (rxt(k,795)+.500_r8*rxt(k,808))*y(k,293)
         mat(k,3484) = rxt(k,803)*y(k,173)
         mat(k,3017) = rxt(k,794)*y(k,69)
         mat(k,2924) = rxt(k,805)*y(k,173)
         mat(k,276) = rxt(k,806)*y(k,173)
         mat(k,302) = rxt(k,797)*y(k,293)
         mat(k,1512) = rxt(k,800)*y(k,20) + rxt(k,801)*y(k,60) + rxt(k,803)*y(k,148) &
                      + rxt(k,805)*y(k,157) + rxt(k,806)*y(k,159) + rxt(k,807) &
                      *y(k,293)
         mat(k,3662) = mat(k,3662) + (rxt(k,795)+.500_r8*rxt(k,808))*y(k,69) &
                      + rxt(k,797)*y(k,160) + rxt(k,807)*y(k,173)
         mat(k,214) = -(rxt(k,810)*y(k,317))
         mat(k,3840) = -rxt(k,810)*y(k,175)
         mat(k,1160) = rxt(k,809)*y(k,293)
         mat(k,3555) = rxt(k,809)*y(k,174)
         mat(k,1095) = .0508005_r8*rxt(k,845)*y(k,157)
         mat(k,852) = .2202005_r8*rxt(k,850)*y(k,157)
         mat(k,934) = .0508005_r8*rxt(k,858)*y(k,157)
         mat(k,954) = .0508005_r8*rxt(k,871)*y(k,157)
         mat(k,704) = .0508005_r8*rxt(k,876)*y(k,157)
         mat(k,2742) = .0245005_r8*rxt(k,844)*y(k,237) + .1279005_r8*rxt(k,849) &
                      *y(k,240) + .0097005_r8*rxt(k,854)*y(k,242) &
                      + .0245005_r8*rxt(k,857)*y(k,245) + .0003005_r8*rxt(k,862) &
                      *y(k,275) + .1056005_r8*rxt(k,866)*y(k,278) &
                      + .0245005_r8*rxt(k,870)*y(k,281) + .0245005_r8*rxt(k,875) &
                      *y(k,290) + .0154005_r8*rxt(k,881)*y(k,313) &
                      + .0063005_r8*rxt(k,884)*y(k,315)
         mat(k,2900) = .0508005_r8*rxt(k,845)*y(k,4) + .2202005_r8*rxt(k,850)*y(k,7) &
                      + .0508005_r8*rxt(k,858)*y(k,17) + .0508005_r8*rxt(k,871) &
                      *y(k,125) + .0508005_r8*rxt(k,876)*y(k,135)
         mat(k,35) = .5931005_r8*rxt(k,878)*y(k,293)
         mat(k,41) = .0245005_r8*rxt(k,844)*y(k,147) + .0508005_r8*rxt(k,843)*y(k,256)
         mat(k,47) = .1279005_r8*rxt(k,849)*y(k,147) + .2202005_r8*rxt(k,848)*y(k,256)
         mat(k,53) = .0097005_r8*rxt(k,854)*y(k,147) + .0023005_r8*rxt(k,853)*y(k,256)
         mat(k,59) = .0245005_r8*rxt(k,857)*y(k,147) + .0508005_r8*rxt(k,856)*y(k,256)
         mat(k,3117) = .0508005_r8*rxt(k,843)*y(k,237) + .2202005_r8*rxt(k,848) &
                      *y(k,240) + .0023005_r8*rxt(k,853)*y(k,242) &
                      + .0508005_r8*rxt(k,856)*y(k,245) + .0031005_r8*rxt(k,861) &
                      *y(k,275) + .2381005_r8*rxt(k,865)*y(k,278) &
                      + .0508005_r8*rxt(k,869)*y(k,281) + .0508005_r8*rxt(k,874) &
                      *y(k,290) + .1364005_r8*rxt(k,880)*y(k,313) &
                      + .1677005_r8*rxt(k,883)*y(k,315)
         mat(k,65) = .0003005_r8*rxt(k,862)*y(k,147) + .0031005_r8*rxt(k,861)*y(k,256)
         mat(k,71) = .1056005_r8*rxt(k,866)*y(k,147) + .2381005_r8*rxt(k,865)*y(k,256)
         mat(k,79) = .0245005_r8*rxt(k,870)*y(k,147) + .0508005_r8*rxt(k,869)*y(k,256)
         mat(k,85) = .0245005_r8*rxt(k,875)*y(k,147) + .0508005_r8*rxt(k,874)*y(k,256)
         mat(k,3517) = .5931005_r8*rxt(k,878)*y(k,196)
         mat(k,91) = .0154005_r8*rxt(k,881)*y(k,147) + .1364005_r8*rxt(k,880)*y(k,256)
         mat(k,97) = .0063005_r8*rxt(k,884)*y(k,147) + .1677005_r8*rxt(k,883)*y(k,256)
         mat(k,1096) = .1149005_r8*rxt(k,845)*y(k,157)
         mat(k,853) = .2067005_r8*rxt(k,850)*y(k,157)
         mat(k,935) = .1149005_r8*rxt(k,858)*y(k,157)
         mat(k,955) = .1149005_r8*rxt(k,871)*y(k,157)
         mat(k,705) = .1149005_r8*rxt(k,876)*y(k,157)
         mat(k,2743) = .0082005_r8*rxt(k,844)*y(k,237) + .1792005_r8*rxt(k,849) &
                      *y(k,240) + .0034005_r8*rxt(k,854)*y(k,242) &
                      + .0082005_r8*rxt(k,857)*y(k,245) + .0003005_r8*rxt(k,862) &
                      *y(k,275) + .1026005_r8*rxt(k,866)*y(k,278) &
                      + .0082005_r8*rxt(k,870)*y(k,281) + .0082005_r8*rxt(k,875) &
                      *y(k,290) + .0452005_r8*rxt(k,881)*y(k,313) &
                      + .0237005_r8*rxt(k,884)*y(k,315)
         mat(k,2901) = .1149005_r8*rxt(k,845)*y(k,4) + .2067005_r8*rxt(k,850)*y(k,7) &
                      + .1149005_r8*rxt(k,858)*y(k,17) + .1149005_r8*rxt(k,871) &
                      *y(k,125) + .1149005_r8*rxt(k,876)*y(k,135)
         mat(k,36) = .1534005_r8*rxt(k,878)*y(k,293)
         mat(k,42) = .0082005_r8*rxt(k,844)*y(k,147) + .1149005_r8*rxt(k,843)*y(k,256)
         mat(k,48) = .1792005_r8*rxt(k,849)*y(k,147) + .2067005_r8*rxt(k,848)*y(k,256)
         mat(k,54) = .0034005_r8*rxt(k,854)*y(k,147) + .0008005_r8*rxt(k,853)*y(k,256)
         mat(k,60) = .0082005_r8*rxt(k,857)*y(k,147) + .1149005_r8*rxt(k,856)*y(k,256)
         mat(k,3118) = .1149005_r8*rxt(k,843)*y(k,237) + .2067005_r8*rxt(k,848) &
                      *y(k,240) + .0008005_r8*rxt(k,853)*y(k,242) &
                      + .1149005_r8*rxt(k,856)*y(k,245) + .0035005_r8*rxt(k,861) &
                      *y(k,275) + .1308005_r8*rxt(k,865)*y(k,278) &
                      + .1149005_r8*rxt(k,869)*y(k,281) + .1149005_r8*rxt(k,874) &
                      *y(k,290) + .0101005_r8*rxt(k,880)*y(k,313) &
                      + .0174005_r8*rxt(k,883)*y(k,315)
         mat(k,66) = .0003005_r8*rxt(k,862)*y(k,147) + .0035005_r8*rxt(k,861)*y(k,256)
         mat(k,72) = .1026005_r8*rxt(k,866)*y(k,147) + .1308005_r8*rxt(k,865)*y(k,256)
         mat(k,80) = .0082005_r8*rxt(k,870)*y(k,147) + .1149005_r8*rxt(k,869)*y(k,256)
         mat(k,86) = .0082005_r8*rxt(k,875)*y(k,147) + .1149005_r8*rxt(k,874)*y(k,256)
         mat(k,3518) = .1534005_r8*rxt(k,878)*y(k,196)
         mat(k,92) = .0452005_r8*rxt(k,881)*y(k,147) + .0101005_r8*rxt(k,880)*y(k,256)
         mat(k,98) = .0237005_r8*rxt(k,884)*y(k,147) + .0174005_r8*rxt(k,883)*y(k,256)
         mat(k,1097) = .0348005_r8*rxt(k,845)*y(k,157)
         mat(k,854) = .0653005_r8*rxt(k,850)*y(k,157)
         mat(k,936) = .0348005_r8*rxt(k,858)*y(k,157)
         mat(k,956) = .0348005_r8*rxt(k,871)*y(k,157)
         mat(k,706) = .0348005_r8*rxt(k,876)*y(k,157)
         mat(k,2744) = .0772005_r8*rxt(k,844)*y(k,237) + .0676005_r8*rxt(k,849) &
                      *y(k,240) + .1579005_r8*rxt(k,854)*y(k,242) &
                      + .0772005_r8*rxt(k,857)*y(k,245) + .0073005_r8*rxt(k,862) &
                      *y(k,275) + .0521005_r8*rxt(k,866)*y(k,278) &
                      + .0772005_r8*rxt(k,870)*y(k,281) + .0772005_r8*rxt(k,875) &
                      *y(k,290) + .0966005_r8*rxt(k,881)*y(k,313) &
                      + .0025005_r8*rxt(k,884)*y(k,315)
         mat(k,2902) = .0348005_r8*rxt(k,845)*y(k,4) + .0653005_r8*rxt(k,850)*y(k,7) &
                      + .0348005_r8*rxt(k,858)*y(k,17) + .0348005_r8*rxt(k,871) &
                      *y(k,125) + .0348005_r8*rxt(k,876)*y(k,135)
         mat(k,37) = .0459005_r8*rxt(k,878)*y(k,293)
         mat(k,43) = .0772005_r8*rxt(k,844)*y(k,147) + .0348005_r8*rxt(k,843)*y(k,256)
         mat(k,49) = .0676005_r8*rxt(k,849)*y(k,147) + .0653005_r8*rxt(k,848)*y(k,256)
         mat(k,55) = .1579005_r8*rxt(k,854)*y(k,147) + .0843005_r8*rxt(k,853)*y(k,256)
         mat(k,61) = .0772005_r8*rxt(k,857)*y(k,147) + .0348005_r8*rxt(k,856)*y(k,256)
         mat(k,3119) = .0348005_r8*rxt(k,843)*y(k,237) + .0653005_r8*rxt(k,848) &
                      *y(k,240) + .0843005_r8*rxt(k,853)*y(k,242) &
                      + .0348005_r8*rxt(k,856)*y(k,245) + .0003005_r8*rxt(k,861) &
                      *y(k,275) + .0348005_r8*rxt(k,865)*y(k,278) &
                      + .0348005_r8*rxt(k,869)*y(k,281) + .0348005_r8*rxt(k,874) &
                      *y(k,290) + .0763005_r8*rxt(k,880)*y(k,313) + .086_r8*rxt(k,883) &
                      *y(k,315)
         mat(k,67) = .0073005_r8*rxt(k,862)*y(k,147) + .0003005_r8*rxt(k,861)*y(k,256)
         mat(k,73) = .0521005_r8*rxt(k,866)*y(k,147) + .0348005_r8*rxt(k,865)*y(k,256)
         mat(k,81) = .0772005_r8*rxt(k,870)*y(k,147) + .0348005_r8*rxt(k,869)*y(k,256)
         mat(k,87) = .0772005_r8*rxt(k,875)*y(k,147) + .0348005_r8*rxt(k,874)*y(k,256)
         mat(k,3519) = .0459005_r8*rxt(k,878)*y(k,196)
         mat(k,93) = .0966005_r8*rxt(k,881)*y(k,147) + .0763005_r8*rxt(k,880)*y(k,256)
         mat(k,99) = .0025005_r8*rxt(k,884)*y(k,147) + .086_r8*rxt(k,883)*y(k,256)
         mat(k,1098) = .1749305_r8*rxt(k,842)*y(k,149) + .0554005_r8*rxt(k,845) &
                      *y(k,157)
         mat(k,855) = .1749305_r8*rxt(k,847)*y(k,149) + .1284005_r8*rxt(k,850) &
                      *y(k,157)
         mat(k,937) = .1749305_r8*rxt(k,855)*y(k,149) + .0554005_r8*rxt(k,858) &
                      *y(k,157)
         mat(k,1276) = .0590245_r8*rxt(k,860)*y(k,149) + .0033005_r8*rxt(k,863) &
                      *y(k,157)
         mat(k,957) = .1749305_r8*rxt(k,868)*y(k,149) + .0554005_r8*rxt(k,871) &
                      *y(k,157)
         mat(k,707) = .1749305_r8*rxt(k,873)*y(k,149) + .0554005_r8*rxt(k,876) &
                      *y(k,157)
         mat(k,2745) = .0332005_r8*rxt(k,844)*y(k,237) + .079_r8*rxt(k,849)*y(k,240) &
                      + .0059005_r8*rxt(k,854)*y(k,242) + .0332005_r8*rxt(k,857) &
                      *y(k,245) + .0057005_r8*rxt(k,862)*y(k,275) &
                      + .0143005_r8*rxt(k,866)*y(k,278) + .0332005_r8*rxt(k,870) &
                      *y(k,281) + .0332005_r8*rxt(k,875)*y(k,290) &
                      + .0073005_r8*rxt(k,881)*y(k,313) + .011_r8*rxt(k,884)*y(k,315)
         mat(k,3001) = .1749305_r8*rxt(k,842)*y(k,4) + .1749305_r8*rxt(k,847)*y(k,7) &
                      + .1749305_r8*rxt(k,855)*y(k,17) + .0590245_r8*rxt(k,860) &
                      *y(k,109) + .1749305_r8*rxt(k,868)*y(k,125) &
                      + .1749305_r8*rxt(k,873)*y(k,135)
         mat(k,2903) = .0554005_r8*rxt(k,845)*y(k,4) + .1284005_r8*rxt(k,850)*y(k,7) &
                      + .0554005_r8*rxt(k,858)*y(k,17) + .0033005_r8*rxt(k,863) &
                      *y(k,109) + .0554005_r8*rxt(k,871)*y(k,125) &
                      + .0554005_r8*rxt(k,876)*y(k,135)
         mat(k,38) = .0085005_r8*rxt(k,878)*y(k,293)
         mat(k,44) = .0332005_r8*rxt(k,844)*y(k,147) + .0554005_r8*rxt(k,843)*y(k,256)
         mat(k,50) = .079_r8*rxt(k,849)*y(k,147) + .1284005_r8*rxt(k,848)*y(k,256)
         mat(k,56) = .0059005_r8*rxt(k,854)*y(k,147) + .0443005_r8*rxt(k,853)*y(k,256)
         mat(k,62) = .0332005_r8*rxt(k,857)*y(k,147) + .0554005_r8*rxt(k,856)*y(k,256)
         mat(k,3120) = .0554005_r8*rxt(k,843)*y(k,237) + .1284005_r8*rxt(k,848) &
                      *y(k,240) + .0443005_r8*rxt(k,853)*y(k,242) &
                      + .0554005_r8*rxt(k,856)*y(k,245) + .0271005_r8*rxt(k,861) &
                      *y(k,275) + .0076005_r8*rxt(k,865)*y(k,278) &
                      + .0554005_r8*rxt(k,869)*y(k,281) + .0554005_r8*rxt(k,874) &
                      *y(k,290) + .2157005_r8*rxt(k,880)*y(k,313) &
                      + .0512005_r8*rxt(k,883)*y(k,315)
         mat(k,68) = .0057005_r8*rxt(k,862)*y(k,147) + .0271005_r8*rxt(k,861)*y(k,256)
         mat(k,74) = .0143005_r8*rxt(k,866)*y(k,147) + .0076005_r8*rxt(k,865)*y(k,256)
         mat(k,82) = .0332005_r8*rxt(k,870)*y(k,147) + .0554005_r8*rxt(k,869)*y(k,256)
         mat(k,88) = .0332005_r8*rxt(k,875)*y(k,147) + .0554005_r8*rxt(k,874)*y(k,256)
         mat(k,3520) = .0085005_r8*rxt(k,878)*y(k,196)
         mat(k,94) = .0073005_r8*rxt(k,881)*y(k,147) + .2157005_r8*rxt(k,880)*y(k,256)
         mat(k,100) = .011_r8*rxt(k,884)*y(k,147) + .0512005_r8*rxt(k,883)*y(k,256)
      end do
      end subroutine nlnmat09
      subroutine nlnmat10( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,1099) = .5901905_r8*rxt(k,842)*y(k,149) + .1278005_r8*rxt(k,845) &
                      *y(k,157)
         mat(k,856) = .5901905_r8*rxt(k,847)*y(k,149) + .114_r8*rxt(k,850)*y(k,157)
         mat(k,938) = .5901905_r8*rxt(k,855)*y(k,149) + .1278005_r8*rxt(k,858) &
                      *y(k,157)
         mat(k,1277) = .0250245_r8*rxt(k,860)*y(k,149)
         mat(k,958) = .5901905_r8*rxt(k,868)*y(k,149) + .1278005_r8*rxt(k,871) &
                      *y(k,157)
         mat(k,708) = .5901905_r8*rxt(k,873)*y(k,149) + .1278005_r8*rxt(k,876) &
                      *y(k,157)
         mat(k,2746) = .130_r8*rxt(k,844)*y(k,237) + .1254005_r8*rxt(k,849)*y(k,240) &
                      + .0536005_r8*rxt(k,854)*y(k,242) + .130_r8*rxt(k,857)*y(k,245) &
                      + .0623005_r8*rxt(k,862)*y(k,275) + .0166005_r8*rxt(k,866) &
                      *y(k,278) + .130_r8*rxt(k,870)*y(k,281) + .130_r8*rxt(k,875) &
                      *y(k,290) + .238_r8*rxt(k,881)*y(k,313) + .1185005_r8*rxt(k,884) &
                      *y(k,315)
         mat(k,3002) = .5901905_r8*rxt(k,842)*y(k,4) + .5901905_r8*rxt(k,847)*y(k,7) &
                      + .5901905_r8*rxt(k,855)*y(k,17) + .0250245_r8*rxt(k,860) &
                      *y(k,109) + .5901905_r8*rxt(k,868)*y(k,125) &
                      + .5901905_r8*rxt(k,873)*y(k,135)
         mat(k,2904) = .1278005_r8*rxt(k,845)*y(k,4) + .114_r8*rxt(k,850)*y(k,7) &
                      + .1278005_r8*rxt(k,858)*y(k,17) + .1278005_r8*rxt(k,871) &
                      *y(k,125) + .1278005_r8*rxt(k,876)*y(k,135)
         mat(k,39) = .0128005_r8*rxt(k,878)*y(k,293)
         mat(k,45) = .130_r8*rxt(k,844)*y(k,147) + .1278005_r8*rxt(k,843)*y(k,256)
         mat(k,51) = .1254005_r8*rxt(k,849)*y(k,147) + .114_r8*rxt(k,848)*y(k,256)
         mat(k,57) = .0536005_r8*rxt(k,854)*y(k,147) + .1621005_r8*rxt(k,853)*y(k,256)
         mat(k,63) = .130_r8*rxt(k,857)*y(k,147) + .1278005_r8*rxt(k,856)*y(k,256)
         mat(k,3121) = .1278005_r8*rxt(k,843)*y(k,237) + .114_r8*rxt(k,848)*y(k,240) &
                      + .1621005_r8*rxt(k,853)*y(k,242) + .1278005_r8*rxt(k,856) &
                      *y(k,245) + .0474005_r8*rxt(k,861)*y(k,275) &
                      + .0113005_r8*rxt(k,865)*y(k,278) + .1278005_r8*rxt(k,869) &
                      *y(k,281) + .1278005_r8*rxt(k,874)*y(k,290) &
                      + .0738005_r8*rxt(k,880)*y(k,313) + .1598005_r8*rxt(k,883) &
                      *y(k,315)
         mat(k,69) = .0623005_r8*rxt(k,862)*y(k,147) + .0474005_r8*rxt(k,861)*y(k,256)
         mat(k,75) = .0166005_r8*rxt(k,866)*y(k,147) + .0113005_r8*rxt(k,865)*y(k,256)
         mat(k,83) = .130_r8*rxt(k,870)*y(k,147) + .1278005_r8*rxt(k,869)*y(k,256)
         mat(k,89) = .130_r8*rxt(k,875)*y(k,147) + .1278005_r8*rxt(k,874)*y(k,256)
         mat(k,3521) = .0128005_r8*rxt(k,878)*y(k,196)
         mat(k,95) = .238_r8*rxt(k,881)*y(k,147) + .0738005_r8*rxt(k,880)*y(k,256)
         mat(k,101) = .1185005_r8*rxt(k,884)*y(k,147) + .1598005_r8*rxt(k,883) &
                      *y(k,256)
         mat(k,2747) = .070_r8*rxt(k,610)*y(k,238) + .300_r8*rxt(k,618)*y(k,239)
         mat(k,2051) = .070_r8*rxt(k,610)*y(k,147) + .720_r8*rxt(k,606)*y(k,238) &
                      + .180_r8*rxt(k,608)*y(k,251) + .500_r8*rxt(k,609)*y(k,256)
         mat(k,2091) = .300_r8*rxt(k,618)*y(k,147)
         mat(k,3346) = .180_r8*rxt(k,608)*y(k,238)
         mat(k,3122) = .500_r8*rxt(k,609)*y(k,238)
         mat(k,40) = -(rxt(k,878)*y(k,293))
         mat(k,3522) = -rxt(k,878)*y(k,196)
         mat(k,163) = .100_r8*rxt(k,575)*y(k,293)
         mat(k,178) = .230_r8*rxt(k,577)*y(k,293)
         mat(k,3547) = .100_r8*rxt(k,575)*y(k,226) + .230_r8*rxt(k,577)*y(k,227)
         mat(k,2179) = -(rxt(k,690)*y(k,293))
         mat(k,3723) = -rxt(k,690)*y(k,198)
         mat(k,2866) = .110_r8*rxt(k,598)*y(k,236) + .700_r8*rxt(k,693)*y(k,298)
         mat(k,3059) = .140_r8*rxt(k,599)*y(k,236)
         mat(k,2212) = .110_r8*rxt(k,598)*y(k,147) + .140_r8*rxt(k,599)*y(k,149) &
                      + .140_r8*rxt(k,595)*y(k,250) + .130_r8*rxt(k,596)*y(k,251) &
                      + .250_r8*rxt(k,597)*y(k,256) + .140_r8*rxt(k,600)*y(k,300) &
                      + .140_r8*rxt(k,601)*y(k,302) + .140_r8*rxt(k,602)*y(k,305)
         mat(k,2241) = .680_r8*rxt(k,637)*y(k,256)
         mat(k,2683) = .140_r8*rxt(k,595)*y(k,236)
         mat(k,3403) = .130_r8*rxt(k,596)*y(k,236)
         mat(k,3262) = .250_r8*rxt(k,597)*y(k,236) + .680_r8*rxt(k,637)*y(k,244) &
                      + .900_r8*rxt(k,657)*y(k,280) + .180_r8*rxt(k,692)*y(k,298) &
                      + .900_r8*rxt(k,766)*y(k,307)
         mat(k,2157) = .900_r8*rxt(k,657)*y(k,256)
         mat(k,919) = .700_r8*rxt(k,693)*y(k,147) + .180_r8*rxt(k,692)*y(k,256)
         mat(k,2519) = .140_r8*rxt(k,600)*y(k,236)
         mat(k,2565) = .140_r8*rxt(k,601)*y(k,236)
         mat(k,2612) = .140_r8*rxt(k,602)*y(k,236)
         mat(k,846) = .900_r8*rxt(k,766)*y(k,256)
         mat(k,386) = -(rxt(k,691)*y(k,293))
         mat(k,3581) = -rxt(k,691)*y(k,199)
         mat(k,2092) = .900_r8*rxt(k,617)*y(k,256)
         mat(k,3152) = .900_r8*rxt(k,617)*y(k,239) + .900_r8*rxt(k,677)*y(k,289)
         mat(k,2262) = .900_r8*rxt(k,677)*y(k,256)
         mat(k,2193) = -(rxt(k,756)*y(k,149) + rxt(k,757)*y(k,293))
         mat(k,3060) = -rxt(k,756)*y(k,200)
         mat(k,3724) = -rxt(k,757)*y(k,200)
         mat(k,1107) = .220_r8*rxt(k,603)*y(k,157)
         mat(k,2867) = .930_r8*rxt(k,590)*y(k,235) + .300_r8*rxt(k,598)*y(k,236)
         mat(k,3060) = mat(k,3060) + rxt(k,591)*y(k,235) + .390_r8*rxt(k,599)*y(k,236)
         mat(k,2968) = .220_r8*rxt(k,603)*y(k,4)
         mat(k,1464) = rxt(k,784)*y(k,293)
         mat(k,1397) = rxt(k,788)*y(k,293)
         mat(k,590) = rxt(k,790)*y(k,293)
         mat(k,2120) = .930_r8*rxt(k,590)*y(k,147) + rxt(k,591)*y(k,149) &
                      + 3.280_r8*rxt(k,586)*y(k,235) + rxt(k,587)*y(k,250) &
                      + .820_r8*rxt(k,588)*y(k,251) + .700_r8*rxt(k,589)*y(k,256) &
                      + rxt(k,592)*y(k,300) + rxt(k,593)*y(k,302) + rxt(k,594) &
                      *y(k,305)
         mat(k,2213) = .300_r8*rxt(k,598)*y(k,147) + .390_r8*rxt(k,599)*y(k,149) &
                      + .390_r8*rxt(k,595)*y(k,250) + .420_r8*rxt(k,596)*y(k,251) &
                      + .290_r8*rxt(k,597)*y(k,256) + .390_r8*rxt(k,600)*y(k,300) &
                      + .390_r8*rxt(k,601)*y(k,302) + .390_r8*rxt(k,602)*y(k,305)
         mat(k,2684) = rxt(k,587)*y(k,235) + .390_r8*rxt(k,595)*y(k,236)
         mat(k,3404) = .820_r8*rxt(k,588)*y(k,235) + .420_r8*rxt(k,596)*y(k,236)
         mat(k,3263) = .700_r8*rxt(k,589)*y(k,235) + .290_r8*rxt(k,597)*y(k,236)
         mat(k,3724) = mat(k,3724) + rxt(k,784)*y(k,219) + rxt(k,788)*y(k,221) &
                      + rxt(k,790)*y(k,223)
         mat(k,2520) = rxt(k,592)*y(k,235) + .390_r8*rxt(k,600)*y(k,236)
         mat(k,2566) = rxt(k,593)*y(k,235) + .390_r8*rxt(k,601)*y(k,236)
         mat(k,2613) = rxt(k,594)*y(k,235) + .390_r8*rxt(k,602)*y(k,236)
         mat(k,1167) = -(rxt(k,709)*y(k,149) + rxt(k,718)*y(k,293))
         mat(k,3018) = -rxt(k,709)*y(k,201)
         mat(k,3663) = -rxt(k,718)*y(k,201)
         mat(k,1103) = .170_r8*rxt(k,603)*y(k,157)
         mat(k,2925) = .170_r8*rxt(k,603)*y(k,4)
         mat(k,345) = rxt(k,758)*y(k,293)
         mat(k,3355) = .500_r8*rxt(k,695)*y(k,299)
         mat(k,3663) = mat(k,3663) + rxt(k,758)*y(k,208)
         mat(k,2440) = .500_r8*rxt(k,695)*y(k,251)
         mat(k,506) = -(rxt(k,719)*y(k,293))
         mat(k,3597) = -rxt(k,719)*y(k,202)
         mat(k,3477) = rxt(k,685)*y(k,300)
         mat(k,2505) = rxt(k,685)*y(k,148)
         mat(k,1645) = -(rxt(k,728)*y(k,149) + rxt(k,737)*y(k,293))
         mat(k,3037) = -rxt(k,728)*y(k,203)
         mat(k,3702) = -rxt(k,737)*y(k,203)
         mat(k,2844) = .270_r8*rxt(k,598)*y(k,236) + .440_r8*rxt(k,630)*y(k,243) &
                      + .310_r8*rxt(k,638)*y(k,244) + .700_r8*rxt(k,762)*y(k,306)
         mat(k,3037) = mat(k,3037) + rxt(k,760)*y(k,210) + .350_r8*rxt(k,599)*y(k,236) &
                      + .480_r8*rxt(k,631)*y(k,243) + .410_r8*rxt(k,639)*y(k,244)
         mat(k,2946) = rxt(k,763)*y(k,210)
         mat(k,2418) = rxt(k,760)*y(k,149) + rxt(k,763)*y(k,157)
         mat(k,527) = rxt(k,789)*y(k,293)
         mat(k,2210) = .270_r8*rxt(k,598)*y(k,147) + .350_r8*rxt(k,599)*y(k,149) &
                      + .350_r8*rxt(k,595)*y(k,250) + .200_r8*rxt(k,596)*y(k,251) &
                      + .350_r8*rxt(k,600)*y(k,300) + .350_r8*rxt(k,601)*y(k,302) &
                      + .350_r8*rxt(k,602)*y(k,305)
         mat(k,2330) = .440_r8*rxt(k,630)*y(k,147) + .480_r8*rxt(k,631)*y(k,149) &
                      + 1.800_r8*rxt(k,626)*y(k,243) + .480_r8*rxt(k,627)*y(k,250) &
                      + .340_r8*rxt(k,628)*y(k,251) + .220_r8*rxt(k,629)*y(k,256) &
                      + .480_r8*rxt(k,632)*y(k,300) + .480_r8*rxt(k,633)*y(k,302) &
                      + .480_r8*rxt(k,634)*y(k,305)
         mat(k,2239) = .310_r8*rxt(k,638)*y(k,147) + .410_r8*rxt(k,639)*y(k,149) &
                      + .410_r8*rxt(k,635)*y(k,250) + .310_r8*rxt(k,636)*y(k,251) &
                      + .410_r8*rxt(k,640)*y(k,300) + .410_r8*rxt(k,641)*y(k,302) &
                      + .410_r8*rxt(k,642)*y(k,305)
         mat(k,2662) = .350_r8*rxt(k,595)*y(k,236) + .480_r8*rxt(k,627)*y(k,243) &
                      + .410_r8*rxt(k,635)*y(k,244)
         mat(k,3382) = .200_r8*rxt(k,596)*y(k,236) + .340_r8*rxt(k,628)*y(k,243) &
                      + .310_r8*rxt(k,636)*y(k,244)
         mat(k,3240) = .220_r8*rxt(k,629)*y(k,243) + .100_r8*rxt(k,761)*y(k,306)
         mat(k,3702) = mat(k,3702) + rxt(k,789)*y(k,224)
         mat(k,2512) = .350_r8*rxt(k,600)*y(k,236) + .480_r8*rxt(k,632)*y(k,243) &
                      + .410_r8*rxt(k,640)*y(k,244)
         mat(k,2558) = .350_r8*rxt(k,601)*y(k,236) + .480_r8*rxt(k,633)*y(k,243) &
                      + .410_r8*rxt(k,641)*y(k,244)
         mat(k,2605) = .350_r8*rxt(k,602)*y(k,236) + .480_r8*rxt(k,634)*y(k,243) &
                      + .410_r8*rxt(k,642)*y(k,244)
         mat(k,682) = .700_r8*rxt(k,762)*y(k,147) + .100_r8*rxt(k,761)*y(k,256)
         mat(k,514) = -(rxt(k,738)*y(k,293))
         mat(k,3598) = -rxt(k,738)*y(k,204)
         mat(k,3478) = rxt(k,686)*y(k,302)
         mat(k,2551) = rxt(k,686)*y(k,148)
         mat(k,522) = -(rxt(k,749)*y(k,293))
         mat(k,3599) = -rxt(k,749)*y(k,205)
         mat(k,1101) = .010_r8*rxt(k,603)*y(k,157)
         mat(k,858) = .130_r8*rxt(k,623)*y(k,157)
         mat(k,960) = .010_r8*rxt(k,663)*y(k,157)
         mat(k,2909) = .010_r8*rxt(k,603)*y(k,4) + .130_r8*rxt(k,623)*y(k,7) &
                      + .010_r8*rxt(k,663)*y(k,125)
         mat(k,3159) = .510_r8*rxt(k,752)*y(k,305)
         mat(k,2597) = .510_r8*rxt(k,752)*y(k,256)
         mat(k,226) = -(rxt(k,747)*y(k,293))
         mat(k,3558) = -rxt(k,747)*y(k,206)
         mat(k,3135) = .510_r8*rxt(k,704)*y(k,300)
         mat(k,2504) = .510_r8*rxt(k,704)*y(k,256)
         mat(k,230) = -(rxt(k,748)*y(k,293))
         mat(k,3559) = -rxt(k,748)*y(k,207)
         mat(k,3136) = .510_r8*rxt(k,722)*y(k,302)
         mat(k,2550) = .510_r8*rxt(k,722)*y(k,256)
         mat(k,344) = -(rxt(k,758)*y(k,293))
         mat(k,3574) = -rxt(k,758)*y(k,208)
         mat(k,3470) = rxt(k,687)*y(k,305)
         mat(k,2596) = rxt(k,687)*y(k,148)
         mat(k,296) = -(rxt(k,759)*y(k,293))
         mat(k,3567) = -rxt(k,759)*y(k,209)
         mat(k,3142) = .820_r8*rxt(k,688)*y(k,297) + .820_r8*rxt(k,692)*y(k,298)
         mat(k,831) = .820_r8*rxt(k,688)*y(k,256)
         mat(k,914) = .820_r8*rxt(k,692)*y(k,256)
         mat(k,2420) = -(rxt(k,760)*y(k,149) + rxt(k,763)*y(k,157) + rxt(k,764) &
                      *y(k,293))
         mat(k,3068) = -rxt(k,760)*y(k,210)
         mat(k,2976) = -rxt(k,763)*y(k,210)
         mat(k,3732) = -rxt(k,764)*y(k,210)
         mat(k,965) = .660_r8*rxt(k,663)*y(k,157)
         mat(k,2875) = .090_r8*rxt(k,598)*y(k,236) + .200_r8*rxt(k,638)*y(k,244) &
                      + .430_r8*rxt(k,650)*y(k,279) + .770_r8*rxt(k,658)*y(k,280) &
                      + .700_r8*rxt(k,767)*y(k,307)
         mat(k,3068) = mat(k,3068) + .500_r8*rxt(k,765)*y(k,211) + .120_r8*rxt(k,599) &
                      *y(k,236) + .270_r8*rxt(k,639)*y(k,244) + .460_r8*rxt(k,651) &
                      *y(k,279) + rxt(k,659)*y(k,280)
         mat(k,2976) = mat(k,2976) + .660_r8*rxt(k,663)*y(k,125) + rxt(k,768)*y(k,211)
         mat(k,2393) = .500_r8*rxt(k,765)*y(k,149) + rxt(k,768)*y(k,157)
         mat(k,2215) = .090_r8*rxt(k,598)*y(k,147) + .120_r8*rxt(k,599)*y(k,149) &
                      + .120_r8*rxt(k,595)*y(k,250) + .140_r8*rxt(k,596)*y(k,251) &
                      + .060_r8*rxt(k,597)*y(k,256) + .120_r8*rxt(k,600)*y(k,300) &
                      + .120_r8*rxt(k,601)*y(k,302) + .120_r8*rxt(k,602)*y(k,305)
         mat(k,2244) = .200_r8*rxt(k,638)*y(k,147) + .270_r8*rxt(k,639)*y(k,149) &
                      + .270_r8*rxt(k,635)*y(k,250) + .370_r8*rxt(k,636)*y(k,251) &
                      + .270_r8*rxt(k,640)*y(k,300) + .270_r8*rxt(k,641)*y(k,302) &
                      + .270_r8*rxt(k,642)*y(k,305)
         mat(k,2692) = .120_r8*rxt(k,595)*y(k,236) + .270_r8*rxt(k,635)*y(k,244) &
                      + .460_r8*rxt(k,646)*y(k,279) + rxt(k,655)*y(k,280)
         mat(k,3412) = .140_r8*rxt(k,596)*y(k,236) + .370_r8*rxt(k,636)*y(k,244) &
                      + .310_r8*rxt(k,647)*y(k,279) + rxt(k,656)*y(k,280)
         mat(k,3271) = .060_r8*rxt(k,597)*y(k,236) + .230_r8*rxt(k,648)*y(k,279) &
                      + .100_r8*rxt(k,657)*y(k,280) + .100_r8*rxt(k,766)*y(k,307)
         mat(k,2305) = .430_r8*rxt(k,650)*y(k,147) + .460_r8*rxt(k,651)*y(k,149) &
                      + .460_r8*rxt(k,646)*y(k,250) + .310_r8*rxt(k,647)*y(k,251) &
                      + .230_r8*rxt(k,648)*y(k,256) + 1.720_r8*rxt(k,649)*y(k,279) &
                      + .460_r8*rxt(k,652)*y(k,300) + .460_r8*rxt(k,653)*y(k,302) &
                      + .460_r8*rxt(k,654)*y(k,305)
         mat(k,2159) = .770_r8*rxt(k,658)*y(k,147) + rxt(k,659)*y(k,149) + rxt(k,655) &
                      *y(k,250) + rxt(k,656)*y(k,251) + .100_r8*rxt(k,657)*y(k,256) &
                      + rxt(k,660)*y(k,300) + rxt(k,661)*y(k,302) + rxt(k,662) &
                      *y(k,305)
         mat(k,2528) = .120_r8*rxt(k,600)*y(k,236) + .270_r8*rxt(k,640)*y(k,244) &
                      + .460_r8*rxt(k,652)*y(k,279) + rxt(k,660)*y(k,280)
         mat(k,2574) = .120_r8*rxt(k,601)*y(k,236) + .270_r8*rxt(k,641)*y(k,244) &
                      + .460_r8*rxt(k,653)*y(k,279) + rxt(k,661)*y(k,280)
         mat(k,2621) = .120_r8*rxt(k,602)*y(k,236) + .270_r8*rxt(k,642)*y(k,244) &
                      + .460_r8*rxt(k,654)*y(k,279) + rxt(k,662)*y(k,280)
         mat(k,847) = .700_r8*rxt(k,767)*y(k,147) + .100_r8*rxt(k,766)*y(k,256)
      end do
      end subroutine nlnmat10
      subroutine nlnmat11( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,2392) = -(rxt(k,765)*y(k,149) + rxt(k,768)*y(k,157) + rxt(k,769) &
                      *y(k,293))
         mat(k,3067) = -rxt(k,765)*y(k,211)
         mat(k,2975) = -rxt(k,768)*y(k,211)
         mat(k,3731) = -rxt(k,769)*y(k,211)
         mat(k,863) = .870_r8*rxt(k,623)*y(k,157)
         mat(k,715) = rxt(k,683)*y(k,157)
         mat(k,2874) = .930_r8*rxt(k,610)*y(k,238) + .700_r8*rxt(k,618)*y(k,239) &
                      + .890_r8*rxt(k,670)*y(k,288) + .710_r8*rxt(k,678)*y(k,289)
         mat(k,3067) = mat(k,3067) + rxt(k,611)*y(k,238) + rxt(k,619)*y(k,239) &
                      + .950_r8*rxt(k,671)*y(k,288) + rxt(k,679)*y(k,289)
         mat(k,2975) = mat(k,2975) + .870_r8*rxt(k,623)*y(k,7) + rxt(k,683)*y(k,135)
         mat(k,2054) = .930_r8*rxt(k,610)*y(k,147) + rxt(k,611)*y(k,149) &
                      + 3.280_r8*rxt(k,606)*y(k,238) + rxt(k,607)*y(k,250) &
                      + .820_r8*rxt(k,608)*y(k,251) + .500_r8*rxt(k,609)*y(k,256) &
                      + rxt(k,612)*y(k,300) + rxt(k,613)*y(k,302) + rxt(k,614) &
                      *y(k,305)
         mat(k,2099) = .700_r8*rxt(k,618)*y(k,147) + rxt(k,619)*y(k,149) + rxt(k,615) &
                      *y(k,250) + rxt(k,616)*y(k,251) + .100_r8*rxt(k,617)*y(k,256) &
                      + rxt(k,620)*y(k,300) + rxt(k,621)*y(k,302) + rxt(k,622) &
                      *y(k,305)
         mat(k,2691) = rxt(k,607)*y(k,238) + rxt(k,615)*y(k,239) + .950_r8*rxt(k,666) &
                      *y(k,288) + rxt(k,675)*y(k,289)
         mat(k,3411) = .820_r8*rxt(k,608)*y(k,238) + rxt(k,616)*y(k,239) &
                      + .770_r8*rxt(k,667)*y(k,288) + rxt(k,676)*y(k,289)
         mat(k,3270) = .500_r8*rxt(k,609)*y(k,238) + .100_r8*rxt(k,617)*y(k,239) &
                      + .480_r8*rxt(k,668)*y(k,288) + .100_r8*rxt(k,677)*y(k,289)
         mat(k,2365) = .890_r8*rxt(k,670)*y(k,147) + .950_r8*rxt(k,671)*y(k,149) &
                      + .950_r8*rxt(k,666)*y(k,250) + .770_r8*rxt(k,667)*y(k,251) &
                      + .480_r8*rxt(k,668)*y(k,256) + 3.080_r8*rxt(k,669)*y(k,288) &
                      + .950_r8*rxt(k,672)*y(k,300) + .950_r8*rxt(k,673)*y(k,302) &
                      + .950_r8*rxt(k,674)*y(k,305)
         mat(k,2272) = .710_r8*rxt(k,678)*y(k,147) + rxt(k,679)*y(k,149) + rxt(k,675) &
                      *y(k,250) + rxt(k,676)*y(k,251) + .100_r8*rxt(k,677)*y(k,256) &
                      + rxt(k,680)*y(k,300) + rxt(k,681)*y(k,302) + rxt(k,682) &
                      *y(k,305)
         mat(k,2527) = rxt(k,612)*y(k,238) + rxt(k,620)*y(k,239) + .950_r8*rxt(k,672) &
                      *y(k,288) + rxt(k,680)*y(k,289)
         mat(k,2573) = rxt(k,613)*y(k,238) + rxt(k,621)*y(k,239) + .950_r8*rxt(k,673) &
                      *y(k,288) + rxt(k,681)*y(k,289)
         mat(k,2620) = rxt(k,614)*y(k,238) + rxt(k,622)*y(k,239) + .950_r8*rxt(k,674) &
                      *y(k,288) + rxt(k,682)*y(k,289)
         mat(k,1154) = -(rxt(k,770)*y(k,293))
         mat(k,3661) = -rxt(k,770)*y(k,212)
         mat(k,2812) = .070_r8*rxt(k,590)*y(k,235) + .070_r8*rxt(k,630)*y(k,243) &
                      + .070_r8*rxt(k,650)*y(k,279) + .070_r8*rxt(k,670)*y(k,288) &
                      + .300_r8*rxt(k,774)*y(k,308) + .300_r8*rxt(k,778)*y(k,309) &
                      + .300_r8*rxt(k,782)*y(k,310) + .300_r8*rxt(k,786)*y(k,311)
         mat(k,2115) = .070_r8*rxt(k,590)*y(k,147)
         mat(k,2326) = .070_r8*rxt(k,630)*y(k,147)
         mat(k,2296) = .070_r8*rxt(k,650)*y(k,147)
         mat(k,2355) = .070_r8*rxt(k,670)*y(k,147)
         mat(k,1145) = .300_r8*rxt(k,774)*y(k,147)
         mat(k,928) = .300_r8*rxt(k,778)*y(k,147)
         mat(k,690) = .300_r8*rxt(k,782)*y(k,147)
         mat(k,698) = .300_r8*rxt(k,786)*y(k,147)
         mat(k,871) = -(rxt(k,771)*y(k,293))
         mat(k,3636) = -rxt(k,771)*y(k,213)
         mat(k,2795) = .010_r8*rxt(k,598)*y(k,236) + .300_r8*rxt(k,689)*y(k,297) &
                      + .300_r8*rxt(k,693)*y(k,298) + .300_r8*rxt(k,762)*y(k,306)
         mat(k,2203) = .010_r8*rxt(k,598)*y(k,147)
         mat(k,3186) = .900_r8*rxt(k,773)*y(k,308) + .900_r8*rxt(k,777)*y(k,309) &
                      + .900_r8*rxt(k,781)*y(k,310) + .900_r8*rxt(k,785)*y(k,311)
         mat(k,835) = .300_r8*rxt(k,689)*y(k,147)
         mat(k,916) = .300_r8*rxt(k,693)*y(k,147)
         mat(k,681) = .300_r8*rxt(k,762)*y(k,147)
         mat(k,1142) = .900_r8*rxt(k,773)*y(k,256)
         mat(k,925) = .900_r8*rxt(k,777)*y(k,256)
         mat(k,689) = .900_r8*rxt(k,781)*y(k,256)
         mat(k,697) = .900_r8*rxt(k,785)*y(k,256)
         mat(k,995) = -(rxt(k,772)*y(k,293))
         mat(k,3646) = -rxt(k,772)*y(k,214)
         mat(k,942) = .510_r8*rxt(k,643)*y(k,157)
         mat(k,2802) = .020_r8*rxt(k,630)*y(k,243) + .240_r8*rxt(k,638)*y(k,244)
         mat(k,3012) = .020_r8*rxt(k,631)*y(k,243) + .320_r8*rxt(k,639)*y(k,244)
         mat(k,2919) = .510_r8*rxt(k,643)*y(k,17)
         mat(k,2204) = .110_r8*rxt(k,596)*y(k,251)
         mat(k,2324) = .020_r8*rxt(k,630)*y(k,147) + .020_r8*rxt(k,631)*y(k,149) &
                      + .080_r8*rxt(k,626)*y(k,243) + .020_r8*rxt(k,627)*y(k,250) &
                      + .020_r8*rxt(k,628)*y(k,251) + .020_r8*rxt(k,629)*y(k,256) &
                      + .020_r8*rxt(k,632)*y(k,300) + .020_r8*rxt(k,633)*y(k,302) &
                      + .020_r8*rxt(k,634)*y(k,305)
         mat(k,2234) = .240_r8*rxt(k,638)*y(k,147) + .320_r8*rxt(k,639)*y(k,149) &
                      + .320_r8*rxt(k,635)*y(k,250) + .320_r8*rxt(k,636)*y(k,251) &
                      + .030_r8*rxt(k,637)*y(k,256) + .320_r8*rxt(k,640)*y(k,300) &
                      + .320_r8*rxt(k,641)*y(k,302) + .320_r8*rxt(k,642)*y(k,305)
         mat(k,2646) = .020_r8*rxt(k,627)*y(k,243) + .320_r8*rxt(k,635)*y(k,244)
         mat(k,3353) = .110_r8*rxt(k,596)*y(k,236) + .020_r8*rxt(k,628)*y(k,243) &
                      + .320_r8*rxt(k,636)*y(k,244)
         mat(k,3193) = .020_r8*rxt(k,629)*y(k,243) + .030_r8*rxt(k,637)*y(k,244)
         mat(k,2506) = .020_r8*rxt(k,632)*y(k,243) + .320_r8*rxt(k,640)*y(k,244)
         mat(k,2552) = .020_r8*rxt(k,633)*y(k,243) + .320_r8*rxt(k,641)*y(k,244)
         mat(k,2598) = .020_r8*rxt(k,634)*y(k,243) + .320_r8*rxt(k,642)*y(k,244)
         mat(k,888) = -(rxt(k,776)*y(k,293))
         mat(k,3638) = -rxt(k,776)*y(k,215)
         mat(k,2797) = .700_r8*rxt(k,774)*y(k,308)
         mat(k,2323) = .450_r8*rxt(k,629)*y(k,256)
         mat(k,3187) = .450_r8*rxt(k,629)*y(k,243) + .100_r8*rxt(k,773)*y(k,308)
         mat(k,1143) = .700_r8*rxt(k,774)*y(k,147) + .100_r8*rxt(k,773)*y(k,256)
         mat(k,582) = -(rxt(k,775)*y(k,293))
         mat(k,3607) = -rxt(k,775)*y(k,216)
         mat(k,3162) = .320_r8*rxt(k,648)*y(k,279) + .360_r8*rxt(k,668)*y(k,288)
         mat(k,2291) = .320_r8*rxt(k,648)*y(k,256)
         mat(k,2350) = .360_r8*rxt(k,668)*y(k,256)
         mat(k,1032) = -(rxt(k,780)*y(k,293))
         mat(k,3650) = -rxt(k,780)*y(k,217)
         mat(k,2806) = .700_r8*rxt(k,778)*y(k,309)
         mat(k,2114) = .300_r8*rxt(k,589)*y(k,256)
         mat(k,2325) = .080_r8*rxt(k,629)*y(k,256)
         mat(k,3196) = .300_r8*rxt(k,589)*y(k,235) + .080_r8*rxt(k,629)*y(k,243) &
                      + .100_r8*rxt(k,777)*y(k,309)
         mat(k,927) = .700_r8*rxt(k,778)*y(k,147) + .100_r8*rxt(k,777)*y(k,256)
         mat(k,671) = -(rxt(k,779)*y(k,293))
         mat(k,3616) = -rxt(k,779)*y(k,218)
         mat(k,3170) = .180_r8*rxt(k,648)*y(k,279) + .160_r8*rxt(k,668)*y(k,288)
         mat(k,2292) = .180_r8*rxt(k,648)*y(k,256)
         mat(k,2351) = .160_r8*rxt(k,668)*y(k,256)
         mat(k,1463) = -(rxt(k,784)*y(k,293))
         mat(k,3688) = -rxt(k,784)*y(k,219)
         mat(k,2831) = .100_r8*rxt(k,598)*y(k,236) + .420_r8*rxt(k,630)*y(k,243) &
                      + .020_r8*rxt(k,638)*y(k,244) + .300_r8*rxt(k,697)*y(k,299) &
                      + .090_r8*rxt(k,742)*y(k,304) + .700_r8*rxt(k,782)*y(k,310)
         mat(k,3027) = .450_r8*rxt(k,631)*y(k,243)
         mat(k,1155) = rxt(k,770)*y(k,293)
         mat(k,872) = rxt(k,771)*y(k,293)
         mat(k,2118) = .180_r8*rxt(k,586)*y(k,235) + .090_r8*rxt(k,588)*y(k,251)
         mat(k,2207) = .100_r8*rxt(k,598)*y(k,147)
         mat(k,2329) = .420_r8*rxt(k,630)*y(k,147) + .450_r8*rxt(k,631)*y(k,149) &
                      + 1.840_r8*rxt(k,626)*y(k,243) + .450_r8*rxt(k,627)*y(k,250) &
                      + .560_r8*rxt(k,628)*y(k,251) + .230_r8*rxt(k,629)*y(k,256) &
                      + .450_r8*rxt(k,632)*y(k,300) + .450_r8*rxt(k,633)*y(k,302) &
                      + .450_r8*rxt(k,634)*y(k,305)
         mat(k,2236) = .020_r8*rxt(k,638)*y(k,147)
         mat(k,2652) = .450_r8*rxt(k,627)*y(k,243)
         mat(k,3369) = .090_r8*rxt(k,588)*y(k,235) + .560_r8*rxt(k,628)*y(k,243)
         mat(k,3227) = .230_r8*rxt(k,629)*y(k,243) + .100_r8*rxt(k,781)*y(k,310)
         mat(k,3688) = mat(k,3688) + rxt(k,770)*y(k,212) + rxt(k,771)*y(k,213)
         mat(k,2442) = .300_r8*rxt(k,697)*y(k,147)
         mat(k,2508) = .450_r8*rxt(k,632)*y(k,243)
         mat(k,2554) = .450_r8*rxt(k,633)*y(k,243)
         mat(k,2462) = .090_r8*rxt(k,742)*y(k,147)
         mat(k,2601) = .450_r8*rxt(k,634)*y(k,243)
         mat(k,691) = .700_r8*rxt(k,782)*y(k,147) + .100_r8*rxt(k,781)*y(k,256)
         mat(k,1590) = -(rxt(k,783)*y(k,293))
         mat(k,3697) = -rxt(k,783)*y(k,220)
         mat(k,2839) = .020_r8*rxt(k,598)*y(k,236) + .040_r8*rxt(k,638)*y(k,244) &
                      + .330_r8*rxt(k,650)*y(k,279) + .060_r8*rxt(k,658)*y(k,280) &
                      + .040_r8*rxt(k,670)*y(k,288) + .100_r8*rxt(k,678)*y(k,289) &
                      + .120_r8*rxt(k,767)*y(k,307)
         mat(k,3034) = .500_r8*rxt(k,765)*y(k,211) + .350_r8*rxt(k,651)*y(k,279) &
                      + .050_r8*rxt(k,671)*y(k,288)
         mat(k,2388) = .500_r8*rxt(k,765)*y(k,149)
         mat(k,2208) = .020_r8*rxt(k,598)*y(k,147)
         mat(k,2237) = .040_r8*rxt(k,638)*y(k,147)
         mat(k,2658) = .350_r8*rxt(k,646)*y(k,279) + .050_r8*rxt(k,666)*y(k,288)
         mat(k,3377) = .420_r8*rxt(k,647)*y(k,279) + .140_r8*rxt(k,667)*y(k,288)
         mat(k,3235) = .180_r8*rxt(k,648)*y(k,279)
         mat(k,2300) = .330_r8*rxt(k,650)*y(k,147) + .350_r8*rxt(k,651)*y(k,149) &
                      + .350_r8*rxt(k,646)*y(k,250) + .420_r8*rxt(k,647)*y(k,251) &
                      + .180_r8*rxt(k,648)*y(k,256) + 1.440_r8*rxt(k,649)*y(k,279) &
                      + .350_r8*rxt(k,652)*y(k,300) + .350_r8*rxt(k,653)*y(k,302) &
                      + .350_r8*rxt(k,654)*y(k,305)
         mat(k,2154) = .060_r8*rxt(k,658)*y(k,147)
         mat(k,2359) = .040_r8*rxt(k,670)*y(k,147) + .050_r8*rxt(k,671)*y(k,149) &
                      + .050_r8*rxt(k,666)*y(k,250) + .140_r8*rxt(k,667)*y(k,251) &
                      + .380_r8*rxt(k,669)*y(k,288) + .050_r8*rxt(k,672)*y(k,300) &
                      + .050_r8*rxt(k,673)*y(k,302) + .050_r8*rxt(k,674)*y(k,305)
         mat(k,2266) = .100_r8*rxt(k,678)*y(k,147)
         mat(k,2510) = .350_r8*rxt(k,652)*y(k,279) + .050_r8*rxt(k,672)*y(k,288)
         mat(k,2556) = .350_r8*rxt(k,653)*y(k,279) + .050_r8*rxt(k,673)*y(k,288)
         mat(k,2603) = .350_r8*rxt(k,654)*y(k,279) + .050_r8*rxt(k,674)*y(k,288)
         mat(k,844) = .120_r8*rxt(k,767)*y(k,147)
         mat(k,1396) = -(rxt(k,788)*y(k,293))
         mat(k,3684) = -rxt(k,788)*y(k,221)
         mat(k,2829) = .050_r8*rxt(k,598)*y(k,236) + .050_r8*rxt(k,630)*y(k,243) &
                      + .060_r8*rxt(k,638)*y(k,244) + .170_r8*rxt(k,713)*y(k,301) &
                      + .300_r8*rxt(k,732)*y(k,303) + .700_r8*rxt(k,786)*y(k,311)
         mat(k,3026) = .050_r8*rxt(k,631)*y(k,243)
         mat(k,1033) = rxt(k,780)*y(k,293)
         mat(k,2117) = .540_r8*rxt(k,586)*y(k,235) + .090_r8*rxt(k,588)*y(k,251)
         mat(k,2206) = .050_r8*rxt(k,598)*y(k,147)
         mat(k,2328) = .050_r8*rxt(k,630)*y(k,147) + .050_r8*rxt(k,631)*y(k,149) &
                      + .280_r8*rxt(k,626)*y(k,243) + .050_r8*rxt(k,627)*y(k,250) &
                      + .080_r8*rxt(k,628)*y(k,251) + .050_r8*rxt(k,632)*y(k,300) &
                      + .050_r8*rxt(k,633)*y(k,302) + .050_r8*rxt(k,634)*y(k,305)
         mat(k,2235) = .060_r8*rxt(k,638)*y(k,147)
         mat(k,2651) = .050_r8*rxt(k,627)*y(k,243)
         mat(k,3368) = .090_r8*rxt(k,588)*y(k,235) + .080_r8*rxt(k,628)*y(k,243)
         mat(k,3223) = .100_r8*rxt(k,785)*y(k,311)
         mat(k,3684) = mat(k,3684) + rxt(k,780)*y(k,217)
         mat(k,2507) = .050_r8*rxt(k,632)*y(k,243)
         mat(k,2483) = .170_r8*rxt(k,713)*y(k,147)
         mat(k,2553) = .050_r8*rxt(k,633)*y(k,243)
         mat(k,2070) = .300_r8*rxt(k,732)*y(k,147)
         mat(k,2600) = .050_r8*rxt(k,634)*y(k,243)
         mat(k,699) = .700_r8*rxt(k,786)*y(k,147) + .100_r8*rxt(k,785)*y(k,256)
         mat(k,1603) = -(rxt(k,787)*y(k,293))
         mat(k,3698) = -rxt(k,787)*y(k,222)
         mat(k,2840) = .050_r8*rxt(k,598)*y(k,236) + .130_r8*rxt(k,638)*y(k,244) &
                      + .170_r8*rxt(k,650)*y(k,279) + .170_r8*rxt(k,658)*y(k,280) &
                      + .190_r8*rxt(k,678)*y(k,289) + .180_r8*rxt(k,767)*y(k,307)
         mat(k,3035) = .190_r8*rxt(k,651)*y(k,279)
         mat(k,2209) = .050_r8*rxt(k,598)*y(k,147)
         mat(k,2238) = .130_r8*rxt(k,638)*y(k,147)
         mat(k,2659) = .190_r8*rxt(k,646)*y(k,279)
         mat(k,3378) = .270_r8*rxt(k,647)*y(k,279) + .090_r8*rxt(k,667)*y(k,288)
         mat(k,3236) = .090_r8*rxt(k,648)*y(k,279)
         mat(k,2301) = .170_r8*rxt(k,650)*y(k,147) + .190_r8*rxt(k,651)*y(k,149) &
                      + .190_r8*rxt(k,646)*y(k,250) + .270_r8*rxt(k,647)*y(k,251) &
                      + .090_r8*rxt(k,648)*y(k,256) + .840_r8*rxt(k,649)*y(k,279) &
                      + .190_r8*rxt(k,652)*y(k,300) + .190_r8*rxt(k,653)*y(k,302) &
                      + .190_r8*rxt(k,654)*y(k,305)
         mat(k,2155) = .170_r8*rxt(k,658)*y(k,147)
         mat(k,2360) = .090_r8*rxt(k,667)*y(k,251) + .540_r8*rxt(k,669)*y(k,288)
         mat(k,2267) = .190_r8*rxt(k,678)*y(k,147)
         mat(k,2511) = .190_r8*rxt(k,652)*y(k,279)
         mat(k,2557) = .190_r8*rxt(k,653)*y(k,279)
         mat(k,2604) = .190_r8*rxt(k,654)*y(k,279)
         mat(k,845) = .180_r8*rxt(k,767)*y(k,147)
      end do
      end subroutine nlnmat11
      subroutine nlnmat12( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,589) = -(rxt(k,790)*y(k,293))
         mat(k,3608) = -rxt(k,790)*y(k,223)
         mat(k,297) = rxt(k,759)*y(k,293)
         mat(k,2202) = .400_r8*rxt(k,597)*y(k,256)
         mat(k,2233) = .290_r8*rxt(k,637)*y(k,256)
         mat(k,3163) = .400_r8*rxt(k,597)*y(k,236) + .290_r8*rxt(k,637)*y(k,244) &
                      + rxt(k,696)*y(k,299) + .620_r8*rxt(k,712)*y(k,301)
         mat(k,3608) = mat(k,3608) + rxt(k,759)*y(k,209)
         mat(k,2439) = rxt(k,696)*y(k,256)
         mat(k,2482) = .620_r8*rxt(k,712)*y(k,256)
         mat(k,526) = -(rxt(k,789)*y(k,293))
         mat(k,3600) = -rxt(k,789)*y(k,224)
         mat(k,2773) = .700_r8*rxt(k,689)*y(k,297)
         mat(k,3160) = .180_r8*rxt(k,688)*y(k,297) + .850_r8*rxt(k,731)*y(k,303) &
                      + .470_r8*rxt(k,741)*y(k,304) + .900_r8*rxt(k,761)*y(k,306)
         mat(k,832) = .700_r8*rxt(k,689)*y(k,147) + .180_r8*rxt(k,688)*y(k,256)
         mat(k,2069) = .850_r8*rxt(k,731)*y(k,256)
         mat(k,2461) = .470_r8*rxt(k,741)*y(k,256)
         mat(k,679) = .900_r8*rxt(k,761)*y(k,256)
         mat(k,613) = -(rxt(k,574)*y(k,293))
         mat(k,3610) = -rxt(k,574)*y(k,225)
         mat(k,3166) = rxt(k,572)*y(k,312)
         mat(k,760) = rxt(k,572)*y(k,256)
         mat(k,161) = -(rxt(k,575)*y(k,293))
         mat(k,3545) = -rxt(k,575)*y(k,226)
         mat(k,179) = -(rxt(k,577)*y(k,293))
         mat(k,3548) = -rxt(k,577)*y(k,227)
         mat(k,731) = -(rxt(k,580)*y(k,293))
         mat(k,3622) = -rxt(k,580)*y(k,228)
         mat(k,3175) = rxt(k,578)*y(k,314)
         mat(k,776) = rxt(k,578)*y(k,256)
         mat(k,187) = -(rxt(k,583)*y(k,293))
         mat(k,3549) = -rxt(k,583)*y(k,229)
         mat(k,180) = .150_r8*rxt(k,577)*y(k,293)
         mat(k,3549) = mat(k,3549) + .150_r8*rxt(k,577)*y(k,227)
         mat(k,350) = -(rxt(k,584)*y(k,293))
         mat(k,3575) = -rxt(k,584)*y(k,230)
         mat(k,3146) = rxt(k,581)*y(k,316)
         mat(k,442) = rxt(k,581)*y(k,256)
         mat(k,462) = -(rxt(k,542)*y(k,256) + rxt(k,543)*y(k,147) + rxt(k,571) &
                      *y(k,148))
         mat(k,3156) = -rxt(k,542)*y(k,233)
         mat(k,2771) = -rxt(k,543)*y(k,233)
         mat(k,3475) = -rxt(k,571)*y(k,233)
         mat(k,199) = rxt(k,548)*y(k,293)
         mat(k,3592) = rxt(k,548)*y(k,23)
         mat(k,1132) = -(rxt(k,410)*y(k,256) + (rxt(k,411) + rxt(k,412)) * y(k,147))
         mat(k,3203) = -rxt(k,410)*y(k,234)
         mat(k,2810) = -(rxt(k,411) + rxt(k,412)) * y(k,234)
         mat(k,647) = rxt(k,413)*y(k,293)
         mat(k,154) = rxt(k,414)*y(k,293)
         mat(k,3659) = rxt(k,413)*y(k,2) + rxt(k,414)*y(k,15)
         mat(k,2119) = -(4._r8*rxt(k,586)*y(k,235) + rxt(k,587)*y(k,250) + rxt(k,588) &
                      *y(k,251) + rxt(k,589)*y(k,256) + rxt(k,590)*y(k,147) + rxt(k,591) &
                      *y(k,149) + rxt(k,592)*y(k,300) + rxt(k,593)*y(k,302) + rxt(k,594) &
                      *y(k,305))
         mat(k,2680) = -rxt(k,587)*y(k,235)
         mat(k,3400) = -rxt(k,588)*y(k,235)
         mat(k,3259) = -rxt(k,589)*y(k,235)
         mat(k,2863) = -rxt(k,590)*y(k,235)
         mat(k,3056) = -rxt(k,591)*y(k,235)
         mat(k,2516) = -rxt(k,592)*y(k,235)
         mat(k,2562) = -rxt(k,593)*y(k,235)
         mat(k,2609) = -rxt(k,594)*y(k,235)
         mat(k,1106) = rxt(k,585)*y(k,149)
         mat(k,3056) = mat(k,3056) + rxt(k,585)*y(k,4)
         mat(k,2214) = -(rxt(k,595)*y(k,250) + rxt(k,596)*y(k,251) + rxt(k,597) &
                      *y(k,256) + rxt(k,598)*y(k,147) + rxt(k,599)*y(k,149) + rxt(k,600) &
                      *y(k,300) + rxt(k,601)*y(k,302) + rxt(k,602)*y(k,305))
         mat(k,2685) = -rxt(k,595)*y(k,236)
         mat(k,3405) = -rxt(k,596)*y(k,236)
         mat(k,3264) = -rxt(k,597)*y(k,236)
         mat(k,2868) = -rxt(k,598)*y(k,236)
         mat(k,3061) = -rxt(k,599)*y(k,236)
         mat(k,2521) = -rxt(k,600)*y(k,236)
         mat(k,2567) = -rxt(k,601)*y(k,236)
         mat(k,2614) = -rxt(k,602)*y(k,236)
         mat(k,1108) = rxt(k,604)*y(k,293)
         mat(k,3725) = rxt(k,604)*y(k,4)
         mat(k,46) = -(rxt(k,843)*y(k,256) + rxt(k,844)*y(k,147))
         mat(k,3123) = -rxt(k,843)*y(k,237)
         mat(k,2748) = -rxt(k,844)*y(k,237)
         mat(k,1100) = rxt(k,846)*y(k,293)
         mat(k,3523) = rxt(k,846)*y(k,4)
         mat(k,2053) = -(4._r8*rxt(k,606)*y(k,238) + rxt(k,607)*y(k,250) + rxt(k,608) &
                      *y(k,251) + rxt(k,609)*y(k,256) + rxt(k,610)*y(k,147) + rxt(k,611) &
                      *y(k,149) + rxt(k,612)*y(k,300) + rxt(k,613)*y(k,302) + rxt(k,614) &
                      *y(k,305))
         mat(k,2677) = -rxt(k,607)*y(k,238)
         mat(k,3397) = -rxt(k,608)*y(k,238)
         mat(k,3256) = -rxt(k,609)*y(k,238)
         mat(k,2860) = -rxt(k,610)*y(k,238)
         mat(k,3053) = -rxt(k,611)*y(k,238)
         mat(k,2513) = -rxt(k,612)*y(k,238)
         mat(k,2559) = -rxt(k,613)*y(k,238)
         mat(k,2606) = -rxt(k,614)*y(k,238)
         mat(k,861) = rxt(k,605)*y(k,149)
         mat(k,3053) = mat(k,3053) + rxt(k,605)*y(k,7)
         mat(k,2096) = -(rxt(k,615)*y(k,250) + rxt(k,616)*y(k,251) + rxt(k,617) &
                      *y(k,256) + rxt(k,618)*y(k,147) + rxt(k,619)*y(k,149) + rxt(k,620) &
                      *y(k,300) + rxt(k,621)*y(k,302) + rxt(k,622)*y(k,305))
         mat(k,2679) = -rxt(k,615)*y(k,239)
         mat(k,3399) = -rxt(k,616)*y(k,239)
         mat(k,3258) = -rxt(k,617)*y(k,239)
         mat(k,2862) = -rxt(k,618)*y(k,239)
         mat(k,3055) = -rxt(k,619)*y(k,239)
         mat(k,2515) = -rxt(k,620)*y(k,239)
         mat(k,2561) = -rxt(k,621)*y(k,239)
         mat(k,2608) = -rxt(k,622)*y(k,239)
         mat(k,862) = rxt(k,624)*y(k,293)
         mat(k,3719) = rxt(k,624)*y(k,7)
         mat(k,52) = -(rxt(k,848)*y(k,256) + rxt(k,849)*y(k,147))
         mat(k,3124) = -rxt(k,848)*y(k,240)
         mat(k,2749) = -rxt(k,849)*y(k,240)
         mat(k,857) = rxt(k,851)*y(k,293)
         mat(k,3524) = rxt(k,851)*y(k,7)
         mat(k,435) = -(rxt(k,545)*y(k,256) + rxt(k,546)*y(k,147))
         mat(k,3154) = -rxt(k,545)*y(k,241)
         mat(k,2768) = -rxt(k,546)*y(k,241)
         mat(k,134) = .350_r8*rxt(k,544)*y(k,293)
         mat(k,324) = rxt(k,547)*y(k,293)
         mat(k,3588) = .350_r8*rxt(k,544)*y(k,8) + rxt(k,547)*y(k,9)
         mat(k,58) = -(rxt(k,853)*y(k,256) + rxt(k,854)*y(k,147))
         mat(k,3125) = -rxt(k,853)*y(k,242)
         mat(k,2750) = -rxt(k,854)*y(k,242)
         mat(k,130) = rxt(k,852)*y(k,293)
         mat(k,3525) = rxt(k,852)*y(k,8)
         mat(k,2332) = -(4._r8*rxt(k,626)*y(k,243) + rxt(k,627)*y(k,250) + rxt(k,628) &
                      *y(k,251) + rxt(k,629)*y(k,256) + rxt(k,630)*y(k,147) + rxt(k,631) &
                      *y(k,149) + rxt(k,632)*y(k,300) + rxt(k,633)*y(k,302) + rxt(k,634) &
                      *y(k,305))
         mat(k,2689) = -rxt(k,627)*y(k,243)
         mat(k,3409) = -rxt(k,628)*y(k,243)
         mat(k,3268) = -rxt(k,629)*y(k,243)
         mat(k,2872) = -rxt(k,630)*y(k,243)
         mat(k,3065) = -rxt(k,631)*y(k,243)
         mat(k,2525) = -rxt(k,632)*y(k,243)
         mat(k,2571) = -rxt(k,633)*y(k,243)
         mat(k,2618) = -rxt(k,634)*y(k,243)
         mat(k,948) = rxt(k,625)*y(k,149)
         mat(k,3065) = mat(k,3065) + rxt(k,625)*y(k,17)
         mat(k,891) = rxt(k,776)*y(k,293)
         mat(k,3729) = rxt(k,776)*y(k,215)
         mat(k,2243) = -(rxt(k,635)*y(k,250) + rxt(k,636)*y(k,251) + rxt(k,637) &
                      *y(k,256) + rxt(k,638)*y(k,147) + rxt(k,639)*y(k,149) + rxt(k,640) &
                      *y(k,300) + rxt(k,641)*y(k,302) + rxt(k,642)*y(k,305))
         mat(k,2686) = -rxt(k,635)*y(k,244)
         mat(k,3406) = -rxt(k,636)*y(k,244)
         mat(k,3265) = -rxt(k,637)*y(k,244)
         mat(k,2869) = -rxt(k,638)*y(k,244)
         mat(k,3062) = -rxt(k,639)*y(k,244)
         mat(k,2522) = -rxt(k,640)*y(k,244)
         mat(k,2568) = -rxt(k,641)*y(k,244)
         mat(k,2615) = -rxt(k,642)*y(k,244)
         mat(k,947) = rxt(k,644)*y(k,293)
         mat(k,3726) = rxt(k,644)*y(k,17)
         mat(k,64) = -(rxt(k,856)*y(k,256) + rxt(k,857)*y(k,147))
         mat(k,3126) = -rxt(k,856)*y(k,245)
         mat(k,2751) = -rxt(k,857)*y(k,245)
         mat(k,939) = rxt(k,859)*y(k,293)
         mat(k,3526) = rxt(k,859)*y(k,17)
         mat(k,358) = -(rxt(k,549)*y(k,256) + rxt(k,551)*y(k,147))
         mat(k,3147) = -rxt(k,549)*y(k,246)
         mat(k,2764) = -rxt(k,551)*y(k,246)
         mat(k,287) = rxt(k,550)*y(k,293)
         mat(k,164) = .070_r8*rxt(k,575)*y(k,293)
         mat(k,181) = .060_r8*rxt(k,577)*y(k,293)
         mat(k,3576) = rxt(k,550)*y(k,24) + .070_r8*rxt(k,575)*y(k,226) &
                      + .060_r8*rxt(k,577)*y(k,227)
         mat(k,1243) = -(4._r8*rxt(k,325)*y(k,247) + rxt(k,326)*y(k,251) + rxt(k,327) &
                      *y(k,256) + rxt(k,328)*y(k,147))
         mat(k,3358) = -rxt(k,326)*y(k,247)
         mat(k,3210) = -rxt(k,327)*y(k,247)
         mat(k,2817) = -rxt(k,328)*y(k,247)
         mat(k,292) = .500_r8*rxt(k,330)*y(k,293)
         mat(k,260) = rxt(k,331)*y(k,57) + rxt(k,332)*y(k,293)
         mat(k,3812) = rxt(k,331)*y(k,29)
         mat(k,3670) = .500_r8*rxt(k,330)*y(k,28) + rxt(k,332)*y(k,29)
         mat(k,975) = -(rxt(k,356)*y(k,251) + rxt(k,357)*y(k,256) + rxt(k,358) &
                      *y(k,147))
         mat(k,3352) = -rxt(k,356)*y(k,248)
         mat(k,3191) = -rxt(k,357)*y(k,248)
         mat(k,2800) = -rxt(k,358)*y(k,248)
         mat(k,339) = rxt(k,359)*y(k,293)
         mat(k,113) = rxt(k,360)*y(k,293)
         mat(k,3644) = rxt(k,359)*y(k,31) + rxt(k,360)*y(k,32)
         mat(k,604) = -(rxt(k,552)*y(k,256) + rxt(k,553)*y(k,147))
         mat(k,3165) = -rxt(k,552)*y(k,249)
         mat(k,2777) = -rxt(k,553)*y(k,249)
         mat(k,224) = rxt(k,554)*y(k,293)
         mat(k,2777) = mat(k,2777) + rxt(k,543)*y(k,233)
         mat(k,2911) = rxt(k,569)*y(k,164)
         mat(k,406) = rxt(k,569)*y(k,157)
         mat(k,463) = rxt(k,543)*y(k,147) + .400_r8*rxt(k,542)*y(k,256)
         mat(k,3165) = mat(k,3165) + .400_r8*rxt(k,542)*y(k,233)
         mat(k,3609) = rxt(k,554)*y(k,33)
         mat(k,2699) = -(4._r8*rxt(k,336)*y(k,250) + rxt(k,337)*y(k,251) + rxt(k,338) &
                      *y(k,256) + rxt(k,339)*y(k,147) + rxt(k,352)*y(k,148) + rxt(k,382) &
                      *y(k,282) + rxt(k,389)*y(k,284) + rxt(k,401)*y(k,287) + rxt(k,425) &
                      *y(k,259) + rxt(k,431)*y(k,260) + rxt(k,445)*y(k,265) + rxt(k,449) &
                      *y(k,266) + rxt(k,475)*y(k,272) + rxt(k,492)*y(k,276) + rxt(k,496) &
                      *y(k,277) + rxt(k,587)*y(k,235) + rxt(k,595)*y(k,236) + rxt(k,607) &
                      *y(k,238) + rxt(k,615)*y(k,239) + rxt(k,627)*y(k,243) + rxt(k,635) &
                      *y(k,244) + rxt(k,646)*y(k,279) + rxt(k,655)*y(k,280) + rxt(k,666) &
                      *y(k,288) + rxt(k,675)*y(k,289) + rxt(k,694)*y(k,299) + rxt(k,702) &
                      *y(k,300) + rxt(k,710)*y(k,301) + rxt(k,720)*y(k,302) + rxt(k,729) &
                      *y(k,303) + rxt(k,750)*y(k,305))
         mat(k,3419) = -rxt(k,337)*y(k,250)
         mat(k,3278) = -rxt(k,338)*y(k,250)
         mat(k,2882) = -rxt(k,339)*y(k,250)
         mat(k,3499) = -rxt(k,352)*y(k,250)
         mat(k,1389) = -rxt(k,382)*y(k,250)
         mat(k,1500) = -rxt(k,389)*y(k,250)
         mat(k,1375) = -rxt(k,401)*y(k,250)
         mat(k,1834) = -rxt(k,425)*y(k,250)
         mat(k,1736) = -rxt(k,431)*y(k,250)
         mat(k,1557) = -rxt(k,445)*y(k,250)
         mat(k,1578) = -rxt(k,449)*y(k,250)
         mat(k,2036) = -rxt(k,475)*y(k,250)
         mat(k,1787) = -rxt(k,492)*y(k,250)
         mat(k,1675) = -rxt(k,496)*y(k,250)
         mat(k,2127) = -rxt(k,587)*y(k,250)
         mat(k,2222) = -rxt(k,595)*y(k,250)
         mat(k,2061) = -rxt(k,607)*y(k,250)
         mat(k,2106) = -rxt(k,615)*y(k,250)
         mat(k,2339) = -rxt(k,627)*y(k,250)
         mat(k,2251) = -rxt(k,635)*y(k,250)
         mat(k,2312) = -rxt(k,646)*y(k,250)
         mat(k,2166) = -rxt(k,655)*y(k,250)
         mat(k,2373) = -rxt(k,666)*y(k,250)
         mat(k,2280) = -rxt(k,675)*y(k,250)
         mat(k,2451) = -rxt(k,694)*y(k,250)
         mat(k,2535) = -rxt(k,702)*y(k,250)
         mat(k,2493) = -rxt(k,710)*y(k,250)
         mat(k,2581) = -rxt(k,720)*y(k,250)
         mat(k,2081) = -rxt(k,729)*y(k,250)
         mat(k,2628) = -rxt(k,750)*y(k,250)
         mat(k,1307) = rxt(k,333)*y(k,149) + rxt(k,334)*y(k,293)
         mat(k,1846) = rxt(k,361)*y(k,149) + rxt(k,362)*y(k,293)
         mat(k,469) = .500_r8*rxt(k,341)*y(k,293)
         mat(k,550) = .060_r8*rxt(k,415)*y(k,293)
         mat(k,562) = .060_r8*rxt(k,416)*y(k,293)
         mat(k,809) = .300_r8*rxt(k,364)*y(k,293)
         mat(k,1297) = .070_r8*rxt(k,487)*y(k,157)
         mat(k,969) = .330_r8*rxt(k,663)*y(k,157)
         mat(k,1754) = .100_r8*rxt(k,386)*y(k,157)
         mat(k,1864) = .280_r8*rxt(k,404)*y(k,157)
         mat(k,1364) = .560_r8*rxt(k,406)*y(k,293)
         mat(k,1994) = .040_r8*rxt(k,502)*y(k,157) + .100_r8*rxt(k,503)*y(k,293)
         mat(k,2882) = mat(k,2882) + .350_r8*rxt(k,393)*y(k,284) + rxt(k,396)*y(k,286) &
                      + .760_r8*rxt(k,538)*y(k,287) + rxt(k,371)*y(k,296) &
                      + .910_r8*rxt(k,742)*y(k,304)
         mat(k,3075) = rxt(k,333)*y(k,46) + rxt(k,361)*y(k,50) + .350_r8*rxt(k,394) &
                      *y(k,284) + rxt(k,743)*y(k,304)
         mat(k,2983) = .070_r8*rxt(k,487)*y(k,109) + .330_r8*rxt(k,663)*y(k,125) &
                      + .100_r8*rxt(k,386)*y(k,126) + .280_r8*rxt(k,404)*y(k,132) &
                      + .040_r8*rxt(k,502)*y(k,139)
         mat(k,517) = 2.000_r8*rxt(k,738)*y(k,293)
         mat(k,2699) = mat(k,2699) + .350_r8*rxt(k,389)*y(k,284) + .750_r8*rxt(k,401) &
                      *y(k,287)
         mat(k,3419) = mat(k,3419) + .350_r8*rxt(k,390)*y(k,284) + .880_r8*rxt(k,402) &
                      *y(k,287) + .300_r8*rxt(k,369)*y(k,296) + rxt(k,740)*y(k,304)
         mat(k,3278) = mat(k,3278) + .170_r8*rxt(k,391)*y(k,284) + .200_r8*rxt(k,395) &
                      *y(k,286) + .490_r8*rxt(k,403)*y(k,287) + .150_r8*rxt(k,370) &
                      *y(k,296) + .530_r8*rxt(k,741)*y(k,304)
         mat(k,1500) = mat(k,1500) + .350_r8*rxt(k,393)*y(k,147) + .350_r8*rxt(k,394) &
                      *y(k,149) + .350_r8*rxt(k,389)*y(k,250) + .350_r8*rxt(k,390) &
                      *y(k,251) + .170_r8*rxt(k,391)*y(k,256) + 1.400_r8*rxt(k,392) &
                      *y(k,284)
         mat(k,658) = rxt(k,396)*y(k,147) + .200_r8*rxt(k,395)*y(k,256)
         mat(k,1375) = mat(k,1375) + .760_r8*rxt(k,538)*y(k,147) + .750_r8*rxt(k,401) &
                      *y(k,250) + .880_r8*rxt(k,402)*y(k,251) + .490_r8*rxt(k,403) &
                      *y(k,256)
         mat(k,3739) = rxt(k,334)*y(k,46) + rxt(k,362)*y(k,50) + .500_r8*rxt(k,341) &
                      *y(k,52) + .060_r8*rxt(k,415)*y(k,98) + .060_r8*rxt(k,416) &
                      *y(k,99) + .300_r8*rxt(k,364)*y(k,104) + .560_r8*rxt(k,406) &
                      *y(k,134) + .100_r8*rxt(k,503)*y(k,139) + 2.000_r8*rxt(k,738) &
                      *y(k,204)
         mat(k,1228) = rxt(k,371)*y(k,147) + .300_r8*rxt(k,369)*y(k,251) &
                      + .150_r8*rxt(k,370)*y(k,256)
         mat(k,2535) = mat(k,2535) + rxt(k,744)*y(k,304)
         mat(k,2581) = mat(k,2581) + rxt(k,745)*y(k,304)
         mat(k,2472) = .910_r8*rxt(k,742)*y(k,147) + rxt(k,743)*y(k,149) + rxt(k,740) &
                      *y(k,251) + .530_r8*rxt(k,741)*y(k,256) + rxt(k,744)*y(k,300) &
                      + rxt(k,745)*y(k,302) + rxt(k,746)*y(k,305)
         mat(k,2628) = mat(k,2628) + rxt(k,746)*y(k,304)
      end do
      end subroutine nlnmat12
      subroutine nlnmat13( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,3429) = -(rxt(k,225)*y(k,60) + (4._r8*rxt(k,302) + 4._r8*rxt(k,303) &
                      ) * y(k,251) + rxt(k,304)*y(k,256) + rxt(k,305)*y(k,147) &
                      + rxt(k,326)*y(k,247) + rxt(k,337)*y(k,250) + rxt(k,356) &
                      *y(k,248) + rxt(k,369)*y(k,296) + rxt(k,383)*y(k,282) + rxt(k,390) &
                      *y(k,284) + rxt(k,402)*y(k,287) + rxt(k,426)*y(k,259) + rxt(k,432) &
                      *y(k,260) + rxt(k,446)*y(k,265) + rxt(k,450)*y(k,266) + rxt(k,476) &
                      *y(k,272) + rxt(k,493)*y(k,276) + rxt(k,497)*y(k,277) + rxt(k,588) &
                      *y(k,235) + rxt(k,596)*y(k,236) + rxt(k,608)*y(k,238) + rxt(k,616) &
                      *y(k,239) + rxt(k,628)*y(k,243) + rxt(k,636)*y(k,244) + rxt(k,647) &
                      *y(k,279) + rxt(k,656)*y(k,280) + rxt(k,667)*y(k,288) + rxt(k,676) &
                      *y(k,289) + rxt(k,695)*y(k,299) + rxt(k,703)*y(k,300) + rxt(k,711) &
                      *y(k,301) + rxt(k,721)*y(k,302) + rxt(k,730)*y(k,303) + rxt(k,740) &
                      *y(k,304) + rxt(k,751)*y(k,305))
         mat(k,3314) = -rxt(k,225)*y(k,251)
         mat(k,3288) = -rxt(k,304)*y(k,251)
         mat(k,2892) = -rxt(k,305)*y(k,251)
         mat(k,1249) = -rxt(k,326)*y(k,251)
         mat(k,2707) = -rxt(k,337)*y(k,251)
         mat(k,981) = -rxt(k,356)*y(k,251)
         mat(k,1232) = -rxt(k,369)*y(k,251)
         mat(k,1393) = -rxt(k,383)*y(k,251)
         mat(k,1506) = -rxt(k,390)*y(k,251)
         mat(k,1379) = -rxt(k,402)*y(k,251)
         mat(k,1840) = -rxt(k,426)*y(k,251)
         mat(k,1742) = -rxt(k,432)*y(k,251)
         mat(k,1562) = -rxt(k,446)*y(k,251)
         mat(k,1583) = -rxt(k,450)*y(k,251)
         mat(k,2044) = -rxt(k,476)*y(k,251)
         mat(k,1792) = -rxt(k,493)*y(k,251)
         mat(k,1680) = -rxt(k,497)*y(k,251)
         mat(k,2133) = -rxt(k,588)*y(k,251)
         mat(k,2229) = -rxt(k,596)*y(k,251)
         mat(k,2066) = -rxt(k,608)*y(k,251)
         mat(k,2111) = -rxt(k,616)*y(k,251)
         mat(k,2346) = -rxt(k,628)*y(k,251)
         mat(k,2258) = -rxt(k,636)*y(k,251)
         mat(k,2319) = -rxt(k,647)*y(k,251)
         mat(k,2172) = -rxt(k,656)*y(k,251)
         mat(k,2380) = -rxt(k,667)*y(k,251)
         mat(k,2287) = -rxt(k,676)*y(k,251)
         mat(k,2458) = -rxt(k,695)*y(k,251)
         mat(k,2543) = -rxt(k,703)*y(k,251)
         mat(k,2500) = -rxt(k,711)*y(k,251)
         mat(k,2589) = -rxt(k,721)*y(k,251)
         mat(k,2088) = -rxt(k,730)*y(k,251)
         mat(k,2479) = -rxt(k,740)*y(k,251)
         mat(k,2636) = -rxt(k,751)*y(k,251)
         mat(k,1207) = .280_r8*rxt(k,355)*y(k,157)
         mat(k,531) = rxt(k,340)*y(k,293)
         mat(k,373) = .700_r8*rxt(k,307)*y(k,293)
         mat(k,552) = .060_r8*rxt(k,415)*y(k,293)
         mat(k,564) = .060_r8*rxt(k,416)*y(k,293)
         mat(k,1302) = .210_r8*rxt(k,487)*y(k,157)
         mat(k,2892) = mat(k,2892) + rxt(k,339)*y(k,250) + .830_r8*rxt(k,557)*y(k,252) &
                      + .650_r8*rxt(k,393)*y(k,284) + .170_r8*rxt(k,563)*y(k,285)
         mat(k,3085) = .650_r8*rxt(k,394)*y(k,284)
         mat(k,2993) = .280_r8*rxt(k,355)*y(k,30) + .210_r8*rxt(k,487)*y(k,109)
         mat(k,2133) = mat(k,2133) + rxt(k,587)*y(k,250)
         mat(k,2229) = mat(k,2229) + rxt(k,595)*y(k,250)
         mat(k,2066) = mat(k,2066) + rxt(k,607)*y(k,250)
         mat(k,2111) = mat(k,2111) + rxt(k,615)*y(k,250)
         mat(k,2346) = mat(k,2346) + rxt(k,627)*y(k,250)
         mat(k,2258) = mat(k,2258) + rxt(k,635)*y(k,250)
         mat(k,2707) = mat(k,2707) + rxt(k,339)*y(k,147) + rxt(k,587)*y(k,235) &
                      + rxt(k,595)*y(k,236) + rxt(k,607)*y(k,238) + rxt(k,615) &
                      *y(k,239) + rxt(k,627)*y(k,243) + rxt(k,635)*y(k,244) &
                      + 4.000_r8*rxt(k,336)*y(k,250) + .900_r8*rxt(k,337)*y(k,251) &
                      + .490_r8*rxt(k,338)*y(k,256) + rxt(k,425)*y(k,259) + rxt(k,431) &
                      *y(k,260) + rxt(k,445)*y(k,265) + rxt(k,449)*y(k,266) &
                      + rxt(k,475)*y(k,272) + rxt(k,492)*y(k,276) + rxt(k,496) &
                      *y(k,277) + rxt(k,646)*y(k,279) + rxt(k,655)*y(k,280) &
                      + rxt(k,382)*y(k,282) + 1.650_r8*rxt(k,389)*y(k,284) &
                      + rxt(k,401)*y(k,287) + rxt(k,666)*y(k,288) + rxt(k,675) &
                      *y(k,289) + rxt(k,694)*y(k,299) + rxt(k,702)*y(k,300) &
                      + rxt(k,710)*y(k,301) + rxt(k,720)*y(k,302) + rxt(k,729) &
                      *y(k,303) + rxt(k,739)*y(k,304) + rxt(k,750)*y(k,305)
         mat(k,3429) = mat(k,3429) + .900_r8*rxt(k,337)*y(k,250) + .650_r8*rxt(k,390) &
                      *y(k,284)
         mat(k,794) = .830_r8*rxt(k,557)*y(k,147) + .330_r8*rxt(k,556)*y(k,256)
         mat(k,3288) = mat(k,3288) + .490_r8*rxt(k,338)*y(k,250) + .330_r8*rxt(k,556) &
                      *y(k,252) + .320_r8*rxt(k,391)*y(k,284) + .070_r8*rxt(k,562) &
                      *y(k,285)
         mat(k,1840) = mat(k,1840) + rxt(k,425)*y(k,250)
         mat(k,1742) = mat(k,1742) + rxt(k,431)*y(k,250)
         mat(k,1562) = mat(k,1562) + rxt(k,445)*y(k,250)
         mat(k,1583) = mat(k,1583) + rxt(k,449)*y(k,250)
         mat(k,2044) = mat(k,2044) + rxt(k,475)*y(k,250)
         mat(k,1792) = mat(k,1792) + rxt(k,492)*y(k,250)
         mat(k,1680) = mat(k,1680) + rxt(k,496)*y(k,250)
         mat(k,2319) = mat(k,2319) + rxt(k,646)*y(k,250)
         mat(k,2172) = mat(k,2172) + rxt(k,655)*y(k,250)
         mat(k,1393) = mat(k,1393) + rxt(k,382)*y(k,250)
         mat(k,1506) = mat(k,1506) + .650_r8*rxt(k,393)*y(k,147) + .650_r8*rxt(k,394) &
                      *y(k,149) + 1.650_r8*rxt(k,389)*y(k,250) + .650_r8*rxt(k,390) &
                      *y(k,251) + .320_r8*rxt(k,391)*y(k,256) + 2.600_r8*rxt(k,392) &
                      *y(k,284)
         mat(k,818) = .170_r8*rxt(k,563)*y(k,147) + .070_r8*rxt(k,562)*y(k,256)
         mat(k,1379) = mat(k,1379) + rxt(k,401)*y(k,250)
         mat(k,2380) = mat(k,2380) + rxt(k,666)*y(k,250)
         mat(k,2287) = mat(k,2287) + rxt(k,675)*y(k,250)
         mat(k,3749) = rxt(k,340)*y(k,51) + .700_r8*rxt(k,307)*y(k,54) &
                      + .060_r8*rxt(k,415)*y(k,98) + .060_r8*rxt(k,416)*y(k,99)
         mat(k,2458) = mat(k,2458) + rxt(k,694)*y(k,250)
         mat(k,2543) = mat(k,2543) + rxt(k,702)*y(k,250)
         mat(k,2500) = mat(k,2500) + rxt(k,710)*y(k,250)
         mat(k,2589) = mat(k,2589) + rxt(k,720)*y(k,250)
         mat(k,2088) = mat(k,2088) + rxt(k,729)*y(k,250)
         mat(k,2479) = mat(k,2479) + rxt(k,739)*y(k,250)
         mat(k,2636) = mat(k,2636) + rxt(k,750)*y(k,250)
         mat(k,789) = -(rxt(k,556)*y(k,256) + rxt(k,557)*y(k,147) + rxt(k,558) &
                      *y(k,148))
         mat(k,3180) = -rxt(k,556)*y(k,252)
         mat(k,2788) = -rxt(k,557)*y(k,252)
         mat(k,3481) = -rxt(k,558)*y(k,252)
         mat(k,534) = -((rxt(k,378) + rxt(k,379)) * y(k,147))
         mat(k,2774) = -(rxt(k,378) + rxt(k,379)) * y(k,253)
         mat(k,309) = rxt(k,376)*y(k,293)
         mat(k,3602) = rxt(k,376)*y(k,16)
         mat(k,2759) = .750_r8*rxt(k,343)*y(k,255)
         mat(k,743) = .750_r8*rxt(k,343)*y(k,147)
         mat(k,744) = -(rxt(k,342)*y(k,256) + rxt(k,343)*y(k,147))
         mat(k,3176) = -rxt(k,342)*y(k,255)
         mat(k,2784) = -rxt(k,343)*y(k,255)
         mat(k,499) = rxt(k,351)*y(k,293)
         mat(k,3623) = rxt(k,351)*y(k,26)
         mat(k,3285) = -((rxt(k,178) + rxt(k,179) + rxt(k,180)) * y(k,78) + rxt(k,182) &
                      *y(k,156) + rxt(k,183)*y(k,157) + rxt(k,187)*y(k,293) &
                      + 4._r8*rxt(k,192)*y(k,256) + rxt(k,202)*y(k,149) + rxt(k,207) &
                      *y(k,147) + rxt(k,212)*y(k,148) + (rxt(k,222) + rxt(k,223) &
                      ) * y(k,57) + rxt(k,229)*y(k,60) + rxt(k,255)*y(k,18) + rxt(k,261) &
                      *y(k,20) + rxt(k,298)*y(k,43) + rxt(k,304)*y(k,251) + rxt(k,313) &
                      *y(k,257) + rxt(k,327)*y(k,247) + rxt(k,338)*y(k,250) + rxt(k,342) &
                      *y(k,255) + rxt(k,357)*y(k,248) + rxt(k,366)*y(k,295) + rxt(k,370) &
                      *y(k,296) + rxt(k,384)*y(k,282) + rxt(k,391)*y(k,284) + rxt(k,395) &
                      *y(k,286) + rxt(k,403)*y(k,287) + rxt(k,410)*y(k,234) + rxt(k,422) &
                      *y(k,258) + rxt(k,427)*y(k,259) + rxt(k,433)*y(k,260) + rxt(k,447) &
                      *y(k,265) + rxt(k,451)*y(k,266) + rxt(k,458)*y(k,267) + rxt(k,462) &
                      *y(k,268) + rxt(k,465)*y(k,269) + rxt(k,468)*y(k,270) + rxt(k,472) &
                      *y(k,271) + rxt(k,477)*y(k,272) + rxt(k,480)*y(k,273) + rxt(k,483) &
                      *y(k,274) + rxt(k,494)*y(k,276) + rxt(k,498)*y(k,277) + rxt(k,500) &
                      *y(k,291) + rxt(k,542)*y(k,233) + rxt(k,545)*y(k,241) + rxt(k,549) &
                      *y(k,246) + rxt(k,552)*y(k,249) + rxt(k,556)*y(k,252) + rxt(k,559) &
                      *y(k,283) + rxt(k,562)*y(k,285) + rxt(k,565)*y(k,294) + rxt(k,572) &
                      *y(k,312) + rxt(k,578)*y(k,314) + rxt(k,581)*y(k,316) + rxt(k,589) &
                      *y(k,235) + rxt(k,597)*y(k,236) + rxt(k,609)*y(k,238) + rxt(k,617) &
                      *y(k,239) + rxt(k,629)*y(k,243) + rxt(k,637)*y(k,244) + rxt(k,648) &
                      *y(k,279) + rxt(k,657)*y(k,280) + rxt(k,668)*y(k,288) + rxt(k,677) &
                      *y(k,289) + rxt(k,688)*y(k,297) + rxt(k,692)*y(k,298) + rxt(k,696) &
                      *y(k,299) + rxt(k,704)*y(k,300) + rxt(k,712)*y(k,301) + rxt(k,722) &
                      *y(k,302) + rxt(k,731)*y(k,303) + rxt(k,741)*y(k,304) + rxt(k,752) &
                      *y(k,305) + rxt(k,761)*y(k,306) + rxt(k,766)*y(k,307) + rxt(k,773) &
                      *y(k,308) + rxt(k,777)*y(k,309) + rxt(k,781)*y(k,310) + rxt(k,785) &
                      *y(k,311))
         mat(k,2734) = -(rxt(k,178) + rxt(k,179) + rxt(k,180)) * y(k,256)
         mat(k,3456) = -rxt(k,182)*y(k,256)
         mat(k,2990) = -rxt(k,183)*y(k,256)
         mat(k,3746) = -rxt(k,187)*y(k,256)
         mat(k,3082) = -rxt(k,202)*y(k,256)
         mat(k,2889) = -rxt(k,207)*y(k,256)
         mat(k,3506) = -rxt(k,212)*y(k,256)
         mat(k,3827) = -(rxt(k,222) + rxt(k,223)) * y(k,256)
         mat(k,3311) = -rxt(k,229)*y(k,256)
         mat(k,1689) = -rxt(k,255)*y(k,256)
         mat(k,3792) = -rxt(k,261)*y(k,256)
         mat(k,3335) = -rxt(k,298)*y(k,256)
         mat(k,3426) = -rxt(k,304)*y(k,256)
         mat(k,597) = -rxt(k,313)*y(k,256)
         mat(k,1247) = -rxt(k,327)*y(k,256)
         mat(k,2705) = -rxt(k,338)*y(k,256)
         mat(k,747) = -rxt(k,342)*y(k,256)
         mat(k,979) = -rxt(k,357)*y(k,256)
         mat(k,826) = -rxt(k,366)*y(k,256)
         mat(k,1230) = -rxt(k,370)*y(k,256)
         mat(k,1391) = -rxt(k,384)*y(k,256)
         mat(k,1504) = -rxt(k,391)*y(k,256)
         mat(k,660) = -rxt(k,395)*y(k,256)
         mat(k,1377) = -rxt(k,403)*y(k,256)
         mat(k,1138) = -rxt(k,410)*y(k,256)
         mat(k,1411) = -rxt(k,422)*y(k,256)
         mat(k,1838) = -rxt(k,427)*y(k,256)
         mat(k,1740) = -rxt(k,433)*y(k,256)
         mat(k,1560) = -rxt(k,447)*y(k,256)
         mat(k,1581) = -rxt(k,451)*y(k,256)
         mat(k,1006) = -rxt(k,458)*y(k,256)
         mat(k,1079) = -rxt(k,462)*y(k,256)
         mat(k,991) = -rxt(k,465)*y(k,256)
         mat(k,1017) = -rxt(k,468)*y(k,256)
         mat(k,1325) = -rxt(k,472)*y(k,256)
         mat(k,2042) = -rxt(k,477)*y(k,256)
         mat(k,1190) = -rxt(k,480)*y(k,256)
         mat(k,1266) = -rxt(k,483)*y(k,256)
         mat(k,1790) = -rxt(k,494)*y(k,256)
         mat(k,1678) = -rxt(k,498)*y(k,256)
         mat(k,1490) = -rxt(k,500)*y(k,256)
         mat(k,465) = -rxt(k,542)*y(k,256)
         mat(k,439) = -rxt(k,545)*y(k,256)
         mat(k,361) = -rxt(k,549)*y(k,256)
         mat(k,607) = -rxt(k,552)*y(k,256)
         mat(k,793) = -rxt(k,556)*y(k,256)
         mat(k,755) = -rxt(k,559)*y(k,256)
         mat(k,817) = -rxt(k,562)*y(k,256)
         mat(k,380) = -rxt(k,565)*y(k,256)
         mat(k,769) = -rxt(k,572)*y(k,256)
         mat(k,786) = -rxt(k,578)*y(k,256)
         mat(k,447) = -rxt(k,581)*y(k,256)
         mat(k,2131) = -rxt(k,589)*y(k,256)
         mat(k,2227) = -rxt(k,597)*y(k,256)
         mat(k,2064) = -rxt(k,609)*y(k,256)
         mat(k,2109) = -rxt(k,617)*y(k,256)
         mat(k,2344) = -rxt(k,629)*y(k,256)
         mat(k,2256) = -rxt(k,637)*y(k,256)
         mat(k,2317) = -rxt(k,648)*y(k,256)
         mat(k,2170) = -rxt(k,657)*y(k,256)
         mat(k,2378) = -rxt(k,668)*y(k,256)
         mat(k,2285) = -rxt(k,677)*y(k,256)
         mat(k,839) = -rxt(k,688)*y(k,256)
         mat(k,922) = -rxt(k,692)*y(k,256)
         mat(k,2456) = -rxt(k,696)*y(k,256)
         mat(k,2541) = -rxt(k,704)*y(k,256)
         mat(k,2498) = -rxt(k,712)*y(k,256)
         mat(k,2587) = -rxt(k,722)*y(k,256)
         mat(k,2086) = -rxt(k,731)*y(k,256)
         mat(k,2477) = -rxt(k,741)*y(k,256)
         mat(k,2634) = -rxt(k,752)*y(k,256)
         mat(k,684) = -rxt(k,761)*y(k,256)
         mat(k,849) = -rxt(k,766)*y(k,256)
         mat(k,1150) = -rxt(k,773)*y(k,256)
         mat(k,931) = -rxt(k,777)*y(k,256)
         mat(k,693) = -rxt(k,781)*y(k,256)
         mat(k,701) = -rxt(k,785)*y(k,256)
         mat(k,1115) = .170_r8*rxt(k,603)*y(k,157)
         mat(k,868) = .080_r8*rxt(k,623)*y(k,157)
         mat(k,135) = .650_r8*rxt(k,544)*y(k,293)
         mat(k,1689) = mat(k,1689) + rxt(k,254)*y(k,43)
         mat(k,3792) = mat(k,3792) + rxt(k,266)*y(k,293)
         mat(k,257) = .350_r8*rxt(k,322)*y(k,293)
         mat(k,503) = .130_r8*rxt(k,324)*y(k,157)
         mat(k,220) = rxt(k,329)*y(k,293)
         mat(k,1205) = .280_r8*rxt(k,355)*y(k,157)
         mat(k,3335) = mat(k,3335) + rxt(k,254)*y(k,18) + rxt(k,218)*y(k,57) &
                      + rxt(k,299)*y(k,149) + rxt(k,300)*y(k,156)
         mat(k,107) = rxt(k,335)*y(k,293)
         mat(k,1357) = rxt(k,306)*y(k,293)
         mat(k,3827) = mat(k,3827) + rxt(k,218)*y(k,43) + rxt(k,221)*y(k,81)
         mat(k,3311) = mat(k,3311) + rxt(k,225)*y(k,251) + rxt(k,236)*y(k,293)
         mat(k,1542) = rxt(k,309)*y(k,293)
         mat(k,171) = .730_r8*rxt(k,555)*y(k,293)
         mat(k,242) = .500_r8*rxt(k,808)*y(k,293)
         mat(k,1471) = rxt(k,346)*y(k,293)
         mat(k,1178) = rxt(k,347)*y(k,293)
         mat(k,1350) = rxt(k,221)*y(k,57) + rxt(k,177)*y(k,156) + rxt(k,186)*y(k,293)
         mat(k,148) = rxt(k,310)*y(k,293)
         mat(k,724) = .110_r8*rxt(k,348)*y(k,293)
         mat(k,1125) = rxt(k,311)*y(k,293)
         mat(k,1120) = .500_r8*rxt(k,312)*y(k,293)
         mat(k,884) = rxt(k,380)*y(k,293)
         mat(k,551) = .510_r8*rxt(k,415)*y(k,293)
         mat(k,563) = .410_r8*rxt(k,416)*y(k,293)
         mat(k,1614) = rxt(k,363)*y(k,293)
         mat(k,1706) = .320_r8*rxt(k,419)*y(k,293)
         mat(k,805) = .190_r8*rxt(k,421)*y(k,293)
         mat(k,1091) = .400_r8*rxt(k,424)*y(k,293)
         mat(k,1300) = .420_r8*rxt(k,487)*y(k,157)
         mat(k,1536) = rxt(k,454)*y(k,293)
         mat(k,1340) = rxt(k,456)*y(k,293)
         mat(k,1938) = .170_r8*rxt(k,460)*y(k,157) + .040_r8*rxt(k,461)*y(k,293)
         mat(k,1972) = .170_r8*rxt(k,470)*y(k,157) + .030_r8*rxt(k,471)*y(k,293)
         mat(k,629) = .050_r8*rxt(k,473)*y(k,293)
         mat(k,800) = rxt(k,489)*y(k,293)
         mat(k,1906) = .180_r8*rxt(k,490)*y(k,293)
         mat(k,1759) = .140_r8*rxt(k,386)*y(k,157)
         mat(k,1624) = .500_r8*rxt(k,381)*y(k,293)
         mat(k,1870) = .280_r8*rxt(k,404)*y(k,157)
         mat(k,1806) = rxt(k,400)*y(k,293)
         mat(k,1365) = .440_r8*rxt(k,406)*y(k,293)
         mat(k,718) = .630_r8*rxt(k,683)*y(k,157)
         mat(k,2000) = .130_r8*rxt(k,502)*y(k,157) + .630_r8*rxt(k,503)*y(k,293)
         mat(k,2889) = mat(k,2889) + rxt(k,411)*y(k,234) + .770_r8*rxt(k,598)*y(k,236) &
                      + .700_r8*rxt(k,618)*y(k,239) + rxt(k,546)*y(k,241) &
                      + .470_r8*rxt(k,630)*y(k,243) + .750_r8*rxt(k,638)*y(k,244) &
                      + rxt(k,551)*y(k,246) + rxt(k,328)*y(k,247) + rxt(k,358) &
                      *y(k,248) + rxt(k,305)*y(k,251) + .170_r8*rxt(k,557)*y(k,252) &
                      + rxt(k,378)*y(k,253) + .250_r8*rxt(k,343)*y(k,255) + rxt(k,315) &
                      *y(k,257) + rxt(k,504)*y(k,258) + rxt(k,506)*y(k,259) &
                      + rxt(k,508)*y(k,260) + .450_r8*rxt(k,510)*y(k,265) &
                      + .450_r8*rxt(k,512)*y(k,266) + rxt(k,514)*y(k,267) &
                      + .270_r8*rxt(k,516)*y(k,268) + rxt(k,518)*y(k,269) + rxt(k,520) &
                      *y(k,270) + rxt(k,522)*y(k,271) + .540_r8*rxt(k,524)*y(k,272) &
                      + .530_r8*rxt(k,526)*y(k,273) + .960_r8*rxt(k,528)*y(k,274) &
                      + .450_r8*rxt(k,531)*y(k,276) + .450_r8*rxt(k,534)*y(k,277) &
                      + .500_r8*rxt(k,650)*y(k,279) + .770_r8*rxt(k,658)*y(k,280) &
                      + rxt(k,536)*y(k,282) + .400_r8*rxt(k,560)*y(k,283) &
                      + .830_r8*rxt(k,563)*y(k,285) + .240_r8*rxt(k,538)*y(k,287) &
                      + .040_r8*rxt(k,670)*y(k,288) + .710_r8*rxt(k,678)*y(k,289) &
                      + rxt(k,540)*y(k,291) + rxt(k,566)*y(k,294) + rxt(k,367) &
                      *y(k,295) + .700_r8*rxt(k,689)*y(k,297) + .700_r8*rxt(k,693) &
                      *y(k,298) + .910_r8*rxt(k,742)*y(k,304) + .700_r8*rxt(k,762) &
                      *y(k,306) + .700_r8*rxt(k,767)*y(k,307) + .700_r8*rxt(k,774) &
                      *y(k,308) + .700_r8*rxt(k,778)*y(k,309) + .700_r8*rxt(k,782) &
                      *y(k,310) + .700_r8*rxt(k,786)*y(k,311) + rxt(k,573)*y(k,312) &
                      + rxt(k,579)*y(k,314) + rxt(k,582)*y(k,316)
         mat(k,3082) = mat(k,3082) + rxt(k,299)*y(k,43) + .500_r8*rxt(k,765)*y(k,211) &
                      + rxt(k,599)*y(k,236) + rxt(k,619)*y(k,239) + .500_r8*rxt(k,631) &
                      *y(k,243) + rxt(k,639)*y(k,244) + .540_r8*rxt(k,479)*y(k,272) &
                      + .540_r8*rxt(k,651)*y(k,279) + rxt(k,659)*y(k,280) &
                      + .050_r8*rxt(k,671)*y(k,288) + rxt(k,679)*y(k,289) + rxt(k,205) &
                      *y(k,293) + rxt(k,743)*y(k,304)
         mat(k,3456) = mat(k,3456) + rxt(k,300)*y(k,43) + rxt(k,177)*y(k,81)
         mat(k,2990) = mat(k,2990) + .170_r8*rxt(k,603)*y(k,4) + .080_r8*rxt(k,623) &
                      *y(k,7) + .130_r8*rxt(k,324)*y(k,26) + .280_r8*rxt(k,355) &
                      *y(k,30) + .420_r8*rxt(k,487)*y(k,109) + .170_r8*rxt(k,460) &
                      *y(k,115) + .170_r8*rxt(k,470)*y(k,118) + .140_r8*rxt(k,386) &
                      *y(k,126) + .280_r8*rxt(k,404)*y(k,132) + .630_r8*rxt(k,683) &
                      *y(k,135) + .130_r8*rxt(k,502)*y(k,139) + rxt(k,189)*y(k,293)
         mat(k,144) = .800_r8*rxt(k,567)*y(k,293)
         mat(k,1163) = rxt(k,809)*y(k,293)
         mat(k,510) = rxt(k,719)*y(k,293)
         mat(k,518) = rxt(k,738)*y(k,293)
         mat(k,2404) = .500_r8*rxt(k,765)*y(k,149)
         mat(k,166) = .280_r8*rxt(k,575)*y(k,293)
         mat(k,185) = .380_r8*rxt(k,577)*y(k,293)
         mat(k,190) = .630_r8*rxt(k,583)*y(k,293)
         mat(k,1138) = mat(k,1138) + rxt(k,411)*y(k,147)
         mat(k,2131) = mat(k,2131) + .820_r8*rxt(k,588)*y(k,251)
         mat(k,2227) = mat(k,2227) + .770_r8*rxt(k,598)*y(k,147) + rxt(k,599)*y(k,149) &
                      + rxt(k,595)*y(k,250) + 1.160_r8*rxt(k,596)*y(k,251) &
                      + .480_r8*rxt(k,597)*y(k,256) + rxt(k,600)*y(k,300) + rxt(k,601) &
                      *y(k,302) + rxt(k,602)*y(k,305)
         mat(k,2064) = mat(k,2064) + .820_r8*rxt(k,608)*y(k,251)
         mat(k,2109) = mat(k,2109) + .700_r8*rxt(k,618)*y(k,147) + rxt(k,619)*y(k,149) &
                      + rxt(k,615)*y(k,250) + rxt(k,616)*y(k,251) + .100_r8*rxt(k,617) &
                      *y(k,256) + rxt(k,620)*y(k,300) + rxt(k,621)*y(k,302) &
                      + rxt(k,622)*y(k,305)
         mat(k,439) = mat(k,439) + rxt(k,546)*y(k,147)
         mat(k,2344) = mat(k,2344) + .470_r8*rxt(k,630)*y(k,147) + .500_r8*rxt(k,631) &
                      *y(k,149) + 1.880_r8*rxt(k,626)*y(k,243) + .500_r8*rxt(k,627) &
                      *y(k,250) + 1.100_r8*rxt(k,628)*y(k,251) + .500_r8*rxt(k,632) &
                      *y(k,300) + .500_r8*rxt(k,633)*y(k,302) + .500_r8*rxt(k,634) &
                      *y(k,305)
         mat(k,2256) = mat(k,2256) + .750_r8*rxt(k,638)*y(k,147) + rxt(k,639)*y(k,149) &
                      + rxt(k,635)*y(k,250) + 1.500_r8*rxt(k,636)*y(k,251) &
                      + .030_r8*rxt(k,637)*y(k,256) + rxt(k,640)*y(k,300) + rxt(k,641) &
                      *y(k,302) + rxt(k,642)*y(k,305)
         mat(k,361) = mat(k,361) + rxt(k,551)*y(k,147)
         mat(k,1247) = mat(k,1247) + rxt(k,328)*y(k,147) + 2.400_r8*rxt(k,325) &
                      *y(k,247) + rxt(k,326)*y(k,251)
         mat(k,979) = mat(k,979) + rxt(k,358)*y(k,147) + rxt(k,356)*y(k,251)
         mat(k,2705) = mat(k,2705) + rxt(k,595)*y(k,236) + rxt(k,615)*y(k,239) &
                      + .500_r8*rxt(k,627)*y(k,243) + rxt(k,635)*y(k,244) &
                      + .900_r8*rxt(k,337)*y(k,251) + rxt(k,425)*y(k,259) + rxt(k,431) &
                      *y(k,260) + .450_r8*rxt(k,445)*y(k,265) + .450_r8*rxt(k,449) &
                      *y(k,266) + .540_r8*rxt(k,475)*y(k,272) + .450_r8*rxt(k,492) &
                      *y(k,276) + .450_r8*rxt(k,496)*y(k,277) + .540_r8*rxt(k,646) &
                      *y(k,279) + rxt(k,655)*y(k,280) + rxt(k,382)*y(k,282) &
                      + .250_r8*rxt(k,401)*y(k,287) + .050_r8*rxt(k,666)*y(k,288) &
                      + rxt(k,675)*y(k,289) + rxt(k,739)*y(k,304)
         mat(k,3426) = mat(k,3426) + rxt(k,225)*y(k,60) + rxt(k,305)*y(k,147) &
                      + .820_r8*rxt(k,588)*y(k,235) + 1.160_r8*rxt(k,596)*y(k,236) &
                      + .820_r8*rxt(k,608)*y(k,238) + rxt(k,616)*y(k,239) &
                      + 1.100_r8*rxt(k,628)*y(k,243) + 1.500_r8*rxt(k,636)*y(k,244) &
                      + rxt(k,326)*y(k,247) + rxt(k,356)*y(k,248) + .900_r8*rxt(k,337) &
                      *y(k,250) + 4.000_r8*rxt(k,302)*y(k,251) + 1.500_r8*rxt(k,426) &
                      *y(k,259) + rxt(k,432)*y(k,260) + .720_r8*rxt(k,446)*y(k,265) &
                      + .720_r8*rxt(k,450)*y(k,266) + .400_r8*rxt(k,476)*y(k,272) &
                      + .720_r8*rxt(k,493)*y(k,276) + .720_r8*rxt(k,497)*y(k,277) &
                      + 1.010_r8*rxt(k,647)*y(k,279) + rxt(k,656)*y(k,280) &
                      + 1.500_r8*rxt(k,383)*y(k,282) + rxt(k,390)*y(k,284) &
                      + .620_r8*rxt(k,402)*y(k,287) + .870_r8*rxt(k,667)*y(k,288) &
                      + rxt(k,676)*y(k,289) + .300_r8*rxt(k,369)*y(k,296) &
                      + .500_r8*rxt(k,695)*y(k,299) + rxt(k,703)*y(k,300) + rxt(k,711) &
                      *y(k,301) + rxt(k,721)*y(k,302) + rxt(k,730)*y(k,303) &
                      + 2.000_r8*rxt(k,740)*y(k,304) + rxt(k,751)*y(k,305)
         mat(k,793) = mat(k,793) + .170_r8*rxt(k,557)*y(k,147) + .070_r8*rxt(k,556) &
                      *y(k,256)
         mat(k,539) = rxt(k,378)*y(k,147)
         mat(k,747) = mat(k,747) + .250_r8*rxt(k,343)*y(k,147)
         mat(k,3285) = mat(k,3285) + .480_r8*rxt(k,597)*y(k,236) + .100_r8*rxt(k,617) &
                      *y(k,239) + .030_r8*rxt(k,637)*y(k,244) + .070_r8*rxt(k,556) &
                      *y(k,252) + .200_r8*rxt(k,313)*y(k,257) + .650_r8*rxt(k,422) &
                      *y(k,258) + .060_r8*rxt(k,427)*y(k,259) + .060_r8*rxt(k,433) &
                      *y(k,260) + .580_r8*rxt(k,458)*y(k,267) + .060_r8*rxt(k,462) &
                      *y(k,268) + .600_r8*rxt(k,465)*y(k,269) + .500_r8*rxt(k,468) &
                      *y(k,270) + .400_r8*rxt(k,472)*y(k,271) + .170_r8*rxt(k,480) &
                      *y(k,273) + .800_r8*rxt(k,483)*y(k,274) + .270_r8*rxt(k,648) &
                      *y(k,279) + .100_r8*rxt(k,657)*y(k,280) + .590_r8*rxt(k,384) &
                      *y(k,282) + .160_r8*rxt(k,559)*y(k,283) + .330_r8*rxt(k,562) &
                      *y(k,285) + .180_r8*rxt(k,403)*y(k,287) + .100_r8*rxt(k,677) &
                      *y(k,289) + .800_r8*rxt(k,500)*y(k,291) + .180_r8*rxt(k,688) &
                      *y(k,297) + .180_r8*rxt(k,692)*y(k,298) + .530_r8*rxt(k,741) &
                      *y(k,304) + .100_r8*rxt(k,761)*y(k,306) + .100_r8*rxt(k,766) &
                      *y(k,307) + .100_r8*rxt(k,773)*y(k,308) + .100_r8*rxt(k,777) &
                      *y(k,309) + .100_r8*rxt(k,781)*y(k,310) + .100_r8*rxt(k,785) &
                      *y(k,311)
         mat(k,597) = mat(k,597) + rxt(k,315)*y(k,147) + .200_r8*rxt(k,313)*y(k,256)
         mat(k,1411) = mat(k,1411) + rxt(k,504)*y(k,147) + .650_r8*rxt(k,422)*y(k,256)
         mat(k,1838) = mat(k,1838) + rxt(k,506)*y(k,147) + rxt(k,425)*y(k,250) &
                      + 1.500_r8*rxt(k,426)*y(k,251) + .060_r8*rxt(k,427)*y(k,256)
         mat(k,1740) = mat(k,1740) + rxt(k,508)*y(k,147) + rxt(k,431)*y(k,250) &
                      + rxt(k,432)*y(k,251) + .060_r8*rxt(k,433)*y(k,256)
         mat(k,1560) = mat(k,1560) + .450_r8*rxt(k,510)*y(k,147) + .450_r8*rxt(k,445) &
                      *y(k,250) + .720_r8*rxt(k,446)*y(k,251)
         mat(k,1581) = mat(k,1581) + .450_r8*rxt(k,512)*y(k,147) + .450_r8*rxt(k,449) &
                      *y(k,250) + .720_r8*rxt(k,450)*y(k,251)
         mat(k,1006) = mat(k,1006) + rxt(k,514)*y(k,147) + .580_r8*rxt(k,458)*y(k,256)
         mat(k,1079) = mat(k,1079) + .270_r8*rxt(k,516)*y(k,147) + .060_r8*rxt(k,462) &
                      *y(k,256)
         mat(k,991) = mat(k,991) + rxt(k,518)*y(k,147) + .600_r8*rxt(k,465)*y(k,256)
         mat(k,1017) = mat(k,1017) + rxt(k,520)*y(k,147) + .500_r8*rxt(k,468)*y(k,256)
         mat(k,1325) = mat(k,1325) + rxt(k,522)*y(k,147) + .400_r8*rxt(k,472)*y(k,256)
         mat(k,2042) = mat(k,2042) + .540_r8*rxt(k,524)*y(k,147) + .540_r8*rxt(k,479) &
                      *y(k,149) + .540_r8*rxt(k,475)*y(k,250) + .400_r8*rxt(k,476) &
                      *y(k,251) + .800_r8*rxt(k,478)*y(k,272)
         mat(k,1190) = mat(k,1190) + .530_r8*rxt(k,526)*y(k,147) + .170_r8*rxt(k,480) &
                      *y(k,256)
         mat(k,1266) = mat(k,1266) + .960_r8*rxt(k,528)*y(k,147) + .800_r8*rxt(k,483) &
                      *y(k,256)
         mat(k,1790) = mat(k,1790) + .450_r8*rxt(k,531)*y(k,147) + .450_r8*rxt(k,492) &
                      *y(k,250) + .720_r8*rxt(k,493)*y(k,251)
         mat(k,1678) = mat(k,1678) + .450_r8*rxt(k,534)*y(k,147) + .450_r8*rxt(k,496) &
                      *y(k,250) + .720_r8*rxt(k,497)*y(k,251)
         mat(k,2317) = mat(k,2317) + .500_r8*rxt(k,650)*y(k,147) + .540_r8*rxt(k,651) &
                      *y(k,149) + .540_r8*rxt(k,646)*y(k,250) + 1.010_r8*rxt(k,647) &
                      *y(k,251) + .270_r8*rxt(k,648)*y(k,256) + 1.980_r8*rxt(k,649) &
                      *y(k,279) + .540_r8*rxt(k,652)*y(k,300) + .540_r8*rxt(k,653) &
                      *y(k,302) + .540_r8*rxt(k,654)*y(k,305)
         mat(k,2170) = mat(k,2170) + .770_r8*rxt(k,658)*y(k,147) + rxt(k,659)*y(k,149) &
                      + rxt(k,655)*y(k,250) + rxt(k,656)*y(k,251) + .100_r8*rxt(k,657) &
                      *y(k,256) + rxt(k,660)*y(k,300) + rxt(k,661)*y(k,302) &
                      + rxt(k,662)*y(k,305)
         mat(k,1391) = mat(k,1391) + rxt(k,536)*y(k,147) + rxt(k,382)*y(k,250) &
                      + 1.500_r8*rxt(k,383)*y(k,251) + .590_r8*rxt(k,384)*y(k,256)
         mat(k,755) = mat(k,755) + .400_r8*rxt(k,560)*y(k,147) + .160_r8*rxt(k,559) &
                      *y(k,256)
         mat(k,1504) = mat(k,1504) + rxt(k,390)*y(k,251)
         mat(k,817) = mat(k,817) + .830_r8*rxt(k,563)*y(k,147) + .330_r8*rxt(k,562) &
                      *y(k,256)
         mat(k,1377) = mat(k,1377) + .240_r8*rxt(k,538)*y(k,147) + .250_r8*rxt(k,401) &
                      *y(k,250) + .620_r8*rxt(k,402)*y(k,251) + .180_r8*rxt(k,403) &
                      *y(k,256)
         mat(k,2378) = mat(k,2378) + .040_r8*rxt(k,670)*y(k,147) + .050_r8*rxt(k,671) &
                      *y(k,149) + .050_r8*rxt(k,666)*y(k,250) + .870_r8*rxt(k,667) &
                      *y(k,251) + .050_r8*rxt(k,672)*y(k,300) + .050_r8*rxt(k,673) &
                      *y(k,302) + .050_r8*rxt(k,674)*y(k,305)
         mat(k,2285) = mat(k,2285) + .710_r8*rxt(k,678)*y(k,147) + rxt(k,679)*y(k,149) &
                      + rxt(k,675)*y(k,250) + rxt(k,676)*y(k,251) + .100_r8*rxt(k,677) &
                      *y(k,256) + rxt(k,680)*y(k,300) + rxt(k,681)*y(k,302) &
                      + rxt(k,682)*y(k,305)
         mat(k,1490) = mat(k,1490) + rxt(k,540)*y(k,147) + .800_r8*rxt(k,500)*y(k,256)
         mat(k,3746) = mat(k,3746) + .650_r8*rxt(k,544)*y(k,8) + rxt(k,266)*y(k,20) &
                      + .350_r8*rxt(k,322)*y(k,25) + rxt(k,329)*y(k,27) + rxt(k,335) &
                      *y(k,48) + rxt(k,306)*y(k,53) + rxt(k,236)*y(k,60) + rxt(k,309) &
                      *y(k,63) + .730_r8*rxt(k,555)*y(k,67) + .500_r8*rxt(k,808) &
                      *y(k,69) + rxt(k,346)*y(k,76) + rxt(k,347)*y(k,77) + rxt(k,186) &
                      *y(k,81) + rxt(k,310)*y(k,88) + .110_r8*rxt(k,348)*y(k,89) &
                      + rxt(k,311)*y(k,90) + .500_r8*rxt(k,312)*y(k,92) + rxt(k,380) &
                      *y(k,97) + .510_r8*rxt(k,415)*y(k,98) + .410_r8*rxt(k,416) &
                      *y(k,99) + rxt(k,363)*y(k,102) + .320_r8*rxt(k,419)*y(k,103) &
                      + .190_r8*rxt(k,421)*y(k,106) + .400_r8*rxt(k,424)*y(k,108) &
                      + rxt(k,454)*y(k,110) + rxt(k,456)*y(k,113) + .040_r8*rxt(k,461) &
                      *y(k,115) + .030_r8*rxt(k,471)*y(k,118) + .050_r8*rxt(k,473) &
                      *y(k,119) + rxt(k,489)*y(k,122) + .180_r8*rxt(k,490)*y(k,123) &
                      + .500_r8*rxt(k,381)*y(k,127) + rxt(k,400)*y(k,133) &
                      + .440_r8*rxt(k,406)*y(k,134) + .630_r8*rxt(k,503)*y(k,139) &
                      + rxt(k,205)*y(k,149) + rxt(k,189)*y(k,157) + .800_r8*rxt(k,567) &
                      *y(k,165) + rxt(k,809)*y(k,174) + rxt(k,719)*y(k,202) &
                      + rxt(k,738)*y(k,204) + .280_r8*rxt(k,575)*y(k,226) &
                      + .380_r8*rxt(k,577)*y(k,227) + .630_r8*rxt(k,583)*y(k,229)
         mat(k,380) = mat(k,380) + rxt(k,566)*y(k,147)
         mat(k,826) = mat(k,826) + rxt(k,367)*y(k,147)
         mat(k,1230) = mat(k,1230) + .300_r8*rxt(k,369)*y(k,251)
         mat(k,839) = mat(k,839) + .700_r8*rxt(k,689)*y(k,147) + .180_r8*rxt(k,688) &
                      *y(k,256)
         mat(k,922) = mat(k,922) + .700_r8*rxt(k,693)*y(k,147) + .180_r8*rxt(k,692) &
                      *y(k,256)
         mat(k,2456) = mat(k,2456) + .500_r8*rxt(k,695)*y(k,251)
         mat(k,2541) = mat(k,2541) + rxt(k,600)*y(k,236) + rxt(k,620)*y(k,239) &
                      + .500_r8*rxt(k,632)*y(k,243) + rxt(k,640)*y(k,244) + rxt(k,703) &
                      *y(k,251) + .540_r8*rxt(k,652)*y(k,279) + rxt(k,660)*y(k,280) &
                      + .050_r8*rxt(k,672)*y(k,288) + rxt(k,680)*y(k,289) + rxt(k,744) &
                      *y(k,304)
         mat(k,2498) = mat(k,2498) + rxt(k,711)*y(k,251)
         mat(k,2587) = mat(k,2587) + rxt(k,601)*y(k,236) + rxt(k,621)*y(k,239) &
                      + .500_r8*rxt(k,633)*y(k,243) + rxt(k,641)*y(k,244) + rxt(k,721) &
                      *y(k,251) + .540_r8*rxt(k,653)*y(k,279) + rxt(k,661)*y(k,280) &
                      + .050_r8*rxt(k,673)*y(k,288) + rxt(k,681)*y(k,289) + rxt(k,745) &
                      *y(k,304)
         mat(k,2086) = mat(k,2086) + rxt(k,730)*y(k,251)
         mat(k,2477) = mat(k,2477) + .910_r8*rxt(k,742)*y(k,147) + rxt(k,743)*y(k,149) &
                      + rxt(k,739)*y(k,250) + 2.000_r8*rxt(k,740)*y(k,251) &
                      + .530_r8*rxt(k,741)*y(k,256) + rxt(k,744)*y(k,300) + rxt(k,745) &
                      *y(k,302) + rxt(k,746)*y(k,305)
         mat(k,2634) = mat(k,2634) + rxt(k,602)*y(k,236) + rxt(k,622)*y(k,239) &
                      + .500_r8*rxt(k,634)*y(k,243) + rxt(k,642)*y(k,244) + rxt(k,751) &
                      *y(k,251) + .540_r8*rxt(k,654)*y(k,279) + rxt(k,662)*y(k,280) &
                      + .050_r8*rxt(k,674)*y(k,288) + rxt(k,682)*y(k,289) + rxt(k,746) &
                      *y(k,304)
         mat(k,684) = mat(k,684) + .700_r8*rxt(k,762)*y(k,147) + .100_r8*rxt(k,761) &
                      *y(k,256)
         mat(k,849) = mat(k,849) + .700_r8*rxt(k,767)*y(k,147) + .100_r8*rxt(k,766) &
                      *y(k,256)
         mat(k,1150) = mat(k,1150) + .700_r8*rxt(k,774)*y(k,147) + .100_r8*rxt(k,773) &
                      *y(k,256)
         mat(k,931) = mat(k,931) + .700_r8*rxt(k,778)*y(k,147) + .100_r8*rxt(k,777) &
                      *y(k,256)
         mat(k,693) = mat(k,693) + .700_r8*rxt(k,782)*y(k,147) + .100_r8*rxt(k,781) &
                      *y(k,256)
         mat(k,701) = mat(k,701) + .700_r8*rxt(k,786)*y(k,147) + .100_r8*rxt(k,785) &
                      *y(k,256)
         mat(k,769) = mat(k,769) + rxt(k,573)*y(k,147)
         mat(k,786) = mat(k,786) + rxt(k,579)*y(k,147)
         mat(k,447) = mat(k,447) + rxt(k,582)*y(k,147)
      end do
      end subroutine nlnmat13
      subroutine nlnmat14( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,593) = -(rxt(k,313)*y(k,256) + rxt(k,315)*y(k,147))
         mat(k,3164) = -rxt(k,313)*y(k,257)
         mat(k,2776) = -rxt(k,315)*y(k,257)
         mat(k,3322) = rxt(k,298)*y(k,256)
         mat(k,3164) = mat(k,3164) + rxt(k,298)*y(k,43)
         mat(k,1404) = -(rxt(k,422)*y(k,256) + (rxt(k,504) + rxt(k,505)) * y(k,147))
         mat(k,3224) = -rxt(k,422)*y(k,258)
         mat(k,2830) = -(rxt(k,504) + rxt(k,505)) * y(k,258)
         mat(k,1695) = .320_r8*rxt(k,419)*y(k,293)
         mat(k,804) = .810_r8*rxt(k,421)*y(k,293)
         mat(k,3685) = .320_r8*rxt(k,419)*y(k,103) + .810_r8*rxt(k,421)*y(k,106)
         mat(k,1829) = -(rxt(k,425)*y(k,250) + rxt(k,426)*y(k,251) + rxt(k,427) &
                      *y(k,256) + (rxt(k,506) + rxt(k,507)) * y(k,147))
         mat(k,2669) = -rxt(k,425)*y(k,259)
         mat(k,3389) = -rxt(k,426)*y(k,259)
         mat(k,3248) = -rxt(k,427)*y(k,259)
         mat(k,2852) = -(rxt(k,506) + rxt(k,507)) * y(k,259)
         mat(k,1893) = .530_r8*rxt(k,490)*y(k,293)
         mat(k,3710) = .530_r8*rxt(k,490)*y(k,123)
         mat(k,1729) = -(rxt(k,431)*y(k,250) + rxt(k,432)*y(k,251) + rxt(k,433) &
                      *y(k,256) + (rxt(k,508) + rxt(k,509)) * y(k,147))
         mat(k,2665) = -rxt(k,431)*y(k,260)
         mat(k,3385) = -rxt(k,432)*y(k,260)
         mat(k,3244) = -rxt(k,433)*y(k,260)
         mat(k,2848) = -(rxt(k,508) + rxt(k,509)) * y(k,260)
         mat(k,1890) = .160_r8*rxt(k,490)*y(k,293)
         mat(k,3706) = .160_r8*rxt(k,490)*y(k,123)
         mat(k,1279) = .315_r8*rxt(k,488)*y(k,293)
         mat(k,3551) = .315_r8*rxt(k,488)*y(k,109)
         mat(k,1280) = .315_r8*rxt(k,488)*y(k,293)
         mat(k,3552) = .315_r8*rxt(k,488)*y(k,109)
         mat(k,1281) = .259_r8*rxt(k,488)*y(k,293)
         mat(k,3553) = .259_r8*rxt(k,488)*y(k,109)
         mat(k,1282) = .111_r8*rxt(k,488)*y(k,293)
         mat(k,3554) = .111_r8*rxt(k,488)*y(k,109)
         mat(k,1550) = -(rxt(k,445)*y(k,250) + rxt(k,446)*y(k,251) + rxt(k,447) &
                      *y(k,256) + (rxt(k,510) + rxt(k,511)) * y(k,147))
         mat(k,2656) = -rxt(k,445)*y(k,265)
         mat(k,3375) = -rxt(k,446)*y(k,265)
         mat(k,3233) = -rxt(k,447)*y(k,265)
         mat(k,2837) = -(rxt(k,510) + rxt(k,511)) * y(k,265)
         mat(k,1571) = -(rxt(k,449)*y(k,250) + rxt(k,450)*y(k,251) + rxt(k,451) &
                      *y(k,256) + (rxt(k,512) + rxt(k,513)) * y(k,147))
         mat(k,2657) = -rxt(k,449)*y(k,266)
         mat(k,3376) = -rxt(k,450)*y(k,266)
         mat(k,3234) = -rxt(k,451)*y(k,266)
         mat(k,2838) = -(rxt(k,512) + rxt(k,513)) * y(k,266)
         mat(k,999) = -(rxt(k,458)*y(k,256) + (rxt(k,514) + rxt(k,515)) * y(k,147))
         mat(k,3194) = -rxt(k,458)*y(k,267)
         mat(k,2803) = -(rxt(k,514) + rxt(k,515)) * y(k,267)
         mat(k,1913) = .820_r8*rxt(k,461)*y(k,293)
         mat(k,3647) = .820_r8*rxt(k,461)*y(k,115)
         mat(k,1071) = -(rxt(k,462)*y(k,256) + (rxt(k,516) + rxt(k,517)) * y(k,147))
         mat(k,3200) = -rxt(k,462)*y(k,268)
         mat(k,2807) = -(rxt(k,516) + rxt(k,517)) * y(k,268)
         mat(k,575) = .850_r8*rxt(k,464)*y(k,293)
         mat(k,3654) = .850_r8*rxt(k,464)*y(k,116)
         mat(k,985) = -(rxt(k,465)*y(k,256) + (rxt(k,518) + rxt(k,519)) * y(k,147))
         mat(k,3192) = -rxt(k,465)*y(k,269)
         mat(k,2801) = -(rxt(k,518) + rxt(k,519)) * y(k,269)
         mat(k,476) = .870_r8*rxt(k,467)*y(k,293)
         mat(k,3645) = .870_r8*rxt(k,467)*y(k,117)
         mat(k,1010) = -(rxt(k,468)*y(k,256) + (rxt(k,520) + rxt(k,521)) * y(k,147))
         mat(k,3195) = -rxt(k,468)*y(k,270)
         mat(k,2804) = -(rxt(k,520) + rxt(k,521)) * y(k,270)
         mat(k,1947) = .890_r8*rxt(k,471)*y(k,293)
         mat(k,3648) = .890_r8*rxt(k,471)*y(k,118)
         mat(k,1315) = -(rxt(k,472)*y(k,256) + (rxt(k,522) + rxt(k,523)) * y(k,147))
         mat(k,3214) = -rxt(k,472)*y(k,271)
         mat(k,2821) = -(rxt(k,522) + rxt(k,523)) * y(k,271)
         mat(k,625) = .920_r8*rxt(k,473)*y(k,293)
         mat(k,3675) = .920_r8*rxt(k,473)*y(k,119)
         mat(k,2034) = -(rxt(k,475)*y(k,250) + rxt(k,476)*y(k,251) + rxt(k,477) &
                      *y(k,256) + 4._r8*rxt(k,478)*y(k,272) + rxt(k,479)*y(k,149) &
                      + (rxt(k,524) + rxt(k,525)) * y(k,147))
         mat(k,2676) = -rxt(k,475)*y(k,272)
         mat(k,3396) = -rxt(k,476)*y(k,272)
         mat(k,3255) = -rxt(k,477)*y(k,272)
         mat(k,3052) = -rxt(k,479)*y(k,272)
         mat(k,2859) = -(rxt(k,524) + rxt(k,525)) * y(k,272)
         mat(k,1296) = rxt(k,474)*y(k,149)
         mat(k,1057) = .170_r8*rxt(k,482)*y(k,293)
         mat(k,1450) = .070_r8*rxt(k,486)*y(k,293)
         mat(k,3052) = mat(k,3052) + rxt(k,474)*y(k,109)
         mat(k,3717) = .170_r8*rxt(k,482)*y(k,120) + .070_r8*rxt(k,486)*y(k,121)
         mat(k,1180) = -(rxt(k,480)*y(k,256) + (rxt(k,526) + rxt(k,527)) * y(k,147))
         mat(k,3207) = -rxt(k,480)*y(k,273)
         mat(k,2814) = -(rxt(k,526) + rxt(k,527)) * y(k,273)
         mat(k,1050) = .410_r8*rxt(k,482)*y(k,293)
         mat(k,3665) = .410_r8*rxt(k,482)*y(k,120)
         mat(k,1255) = -(rxt(k,483)*y(k,256) + (rxt(k,528) + rxt(k,529)) * y(k,147))
         mat(k,3211) = -rxt(k,483)*y(k,274)
         mat(k,2818) = -(rxt(k,528) + rxt(k,529)) * y(k,274)
         mat(k,1433) = .570_r8*rxt(k,486)*y(k,293)
         mat(k,3671) = .570_r8*rxt(k,486)*y(k,121)
         mat(k,70) = -(rxt(k,861)*y(k,256) + rxt(k,862)*y(k,147))
         mat(k,3127) = -rxt(k,861)*y(k,275)
         mat(k,2752) = -rxt(k,862)*y(k,275)
         mat(k,1278) = rxt(k,864)*y(k,293)
         mat(k,3527) = rxt(k,864)*y(k,109)
         mat(k,1780) = -(rxt(k,492)*y(k,250) + rxt(k,493)*y(k,251) + rxt(k,494) &
                      *y(k,256) + (rxt(k,531) + rxt(k,532)) * y(k,147))
         mat(k,2667) = -rxt(k,492)*y(k,276)
         mat(k,3387) = -rxt(k,493)*y(k,276)
         mat(k,3246) = -rxt(k,494)*y(k,276)
         mat(k,2850) = -(rxt(k,531) + rxt(k,532)) * y(k,276)
         mat(k,1667) = -(rxt(k,496)*y(k,250) + rxt(k,497)*y(k,251) + rxt(k,498) &
                      *y(k,256) + (rxt(k,534) + rxt(k,535)) * y(k,147))
         mat(k,2663) = -rxt(k,496)*y(k,277)
         mat(k,3383) = -rxt(k,497)*y(k,277)
         mat(k,3241) = -rxt(k,498)*y(k,277)
         mat(k,2845) = -(rxt(k,534) + rxt(k,535)) * y(k,277)
         mat(k,76) = -(rxt(k,865)*y(k,256) + rxt(k,866)*y(k,147))
         mat(k,3128) = -rxt(k,865)*y(k,278)
         mat(k,2753) = -rxt(k,866)*y(k,278)
         mat(k,77) = rxt(k,867)*y(k,293)
         mat(k,3528) = rxt(k,867)*y(k,124)
         mat(k,2303) = -(rxt(k,646)*y(k,250) + rxt(k,647)*y(k,251) + rxt(k,648) &
                      *y(k,256) + 4._r8*rxt(k,649)*y(k,279) + rxt(k,650)*y(k,147) &
                      + rxt(k,651)*y(k,149) + rxt(k,652)*y(k,300) + rxt(k,653) &
                      *y(k,302) + rxt(k,654)*y(k,305))
         mat(k,2688) = -rxt(k,646)*y(k,279)
         mat(k,3408) = -rxt(k,647)*y(k,279)
         mat(k,3267) = -rxt(k,648)*y(k,279)
         mat(k,2871) = -rxt(k,650)*y(k,279)
         mat(k,3064) = -rxt(k,651)*y(k,279)
         mat(k,2524) = -rxt(k,652)*y(k,279)
         mat(k,2570) = -rxt(k,653)*y(k,279)
         mat(k,2617) = -rxt(k,654)*y(k,279)
         mat(k,964) = rxt(k,645)*y(k,149)
         mat(k,3064) = mat(k,3064) + rxt(k,645)*y(k,125)
         mat(k,2156) = -(rxt(k,655)*y(k,250) + rxt(k,656)*y(k,251) + rxt(k,657) &
                      *y(k,256) + rxt(k,658)*y(k,147) + rxt(k,659)*y(k,149) + rxt(k,660) &
                      *y(k,300) + rxt(k,661)*y(k,302) + rxt(k,662)*y(k,305))
         mat(k,2682) = -rxt(k,655)*y(k,280)
         mat(k,3402) = -rxt(k,656)*y(k,280)
         mat(k,3261) = -rxt(k,657)*y(k,280)
         mat(k,2865) = -rxt(k,658)*y(k,280)
         mat(k,3058) = -rxt(k,659)*y(k,280)
         mat(k,2518) = -rxt(k,660)*y(k,280)
         mat(k,2564) = -rxt(k,661)*y(k,280)
         mat(k,2611) = -rxt(k,662)*y(k,280)
         mat(k,963) = rxt(k,664)*y(k,293)
         mat(k,3722) = rxt(k,664)*y(k,125)
         mat(k,84) = -(rxt(k,869)*y(k,256) + rxt(k,870)*y(k,147))
         mat(k,3129) = -rxt(k,869)*y(k,281)
         mat(k,2754) = -rxt(k,870)*y(k,281)
         mat(k,959) = rxt(k,872)*y(k,293)
         mat(k,3530) = rxt(k,872)*y(k,125)
         mat(k,1383) = -(rxt(k,382)*y(k,250) + rxt(k,383)*y(k,251) + rxt(k,384) &
                      *y(k,256) + (rxt(k,536) + rxt(k,537)) * y(k,147))
         mat(k,2650) = -rxt(k,382)*y(k,282)
         mat(k,3367) = -rxt(k,383)*y(k,282)
         mat(k,3222) = -rxt(k,384)*y(k,282)
         mat(k,2828) = -(rxt(k,536) + rxt(k,537)) * y(k,282)
         mat(k,1746) = .550_r8*rxt(k,387)*y(k,293)
         mat(k,3683) = .550_r8*rxt(k,387)*y(k,126)
         mat(k,751) = -(rxt(k,559)*y(k,256) + rxt(k,560)*y(k,147) + rxt(k,561) &
                      *y(k,148))
         mat(k,3177) = -rxt(k,559)*y(k,283)
         mat(k,2785) = -rxt(k,560)*y(k,283)
         mat(k,3480) = -rxt(k,561)*y(k,283)
         mat(k,1497) = -(rxt(k,389)*y(k,250) + rxt(k,390)*y(k,251) + rxt(k,391) &
                      *y(k,256) + 4._r8*rxt(k,392)*y(k,284) + rxt(k,393)*y(k,147) &
                      + rxt(k,394)*y(k,149) + rxt(k,407)*y(k,148))
         mat(k,2654) = -rxt(k,389)*y(k,284)
         mat(k,3372) = -rxt(k,390)*y(k,284)
         mat(k,3230) = -rxt(k,391)*y(k,284)
         mat(k,2834) = -rxt(k,393)*y(k,284)
         mat(k,3029) = -rxt(k,394)*y(k,284)
         mat(k,3488) = -rxt(k,407)*y(k,284)
         mat(k,1747) = .450_r8*rxt(k,387)*y(k,293)
         mat(k,3691) = .450_r8*rxt(k,387)*y(k,126)
         mat(k,812) = -(rxt(k,562)*y(k,256) + rxt(k,563)*y(k,147) + rxt(k,564) &
                      *y(k,148))
         mat(k,3182) = -rxt(k,562)*y(k,285)
         mat(k,2791) = -rxt(k,563)*y(k,285)
         mat(k,3482) = -rxt(k,564)*y(k,285)
         mat(k,656) = -(rxt(k,395)*y(k,256) + rxt(k,396)*y(k,147))
         mat(k,3168) = -rxt(k,395)*y(k,286)
         mat(k,2779) = -rxt(k,396)*y(k,286)
         mat(k,451) = rxt(k,397)*y(k,293)
         mat(k,266) = rxt(k,398)*y(k,293)
         mat(k,3614) = rxt(k,397)*y(k,129) + rxt(k,398)*y(k,130)
         mat(k,1370) = -(rxt(k,401)*y(k,250) + rxt(k,402)*y(k,251) + rxt(k,403) &
                      *y(k,256) + (rxt(k,538) + rxt(k,539)) * y(k,147))
         mat(k,2649) = -rxt(k,401)*y(k,287)
         mat(k,3366) = -rxt(k,402)*y(k,287)
         mat(k,3221) = -rxt(k,403)*y(k,287)
         mat(k,2827) = -(rxt(k,538) + rxt(k,539)) * y(k,287)
         mat(k,1857) = rxt(k,405)*y(k,293)
         mat(k,3682) = rxt(k,405)*y(k,132)
         mat(k,2364) = -(rxt(k,666)*y(k,250) + rxt(k,667)*y(k,251) + rxt(k,668) &
                      *y(k,256) + 4._r8*rxt(k,669)*y(k,288) + rxt(k,670)*y(k,147) &
                      + rxt(k,671)*y(k,149) + rxt(k,672)*y(k,300) + rxt(k,673) &
                      *y(k,302) + rxt(k,674)*y(k,305))
         mat(k,2690) = -rxt(k,666)*y(k,288)
         mat(k,3410) = -rxt(k,667)*y(k,288)
         mat(k,3269) = -rxt(k,668)*y(k,288)
         mat(k,2873) = -rxt(k,670)*y(k,288)
         mat(k,3066) = -rxt(k,671)*y(k,288)
         mat(k,2526) = -rxt(k,672)*y(k,288)
         mat(k,2572) = -rxt(k,673)*y(k,288)
         mat(k,2619) = -rxt(k,674)*y(k,288)
         mat(k,714) = rxt(k,665)*y(k,149)
         mat(k,3066) = mat(k,3066) + rxt(k,665)*y(k,135)
      end do
      end subroutine nlnmat14
      subroutine nlnmat15( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,2271) = -(rxt(k,675)*y(k,250) + rxt(k,676)*y(k,251) + rxt(k,677) &
                      *y(k,256) + rxt(k,678)*y(k,147) + rxt(k,679)*y(k,149) + rxt(k,680) &
                      *y(k,300) + rxt(k,681)*y(k,302) + rxt(k,682)*y(k,305))
         mat(k,2687) = -rxt(k,675)*y(k,289)
         mat(k,3407) = -rxt(k,676)*y(k,289)
         mat(k,3266) = -rxt(k,677)*y(k,289)
         mat(k,2870) = -rxt(k,678)*y(k,289)
         mat(k,3063) = -rxt(k,679)*y(k,289)
         mat(k,2523) = -rxt(k,680)*y(k,289)
         mat(k,2569) = -rxt(k,681)*y(k,289)
         mat(k,2616) = -rxt(k,682)*y(k,289)
         mat(k,713) = rxt(k,684)*y(k,293)
         mat(k,3727) = rxt(k,684)*y(k,135)
         mat(k,90) = -(rxt(k,874)*y(k,256) + rxt(k,875)*y(k,147))
         mat(k,3130) = -rxt(k,874)*y(k,290)
         mat(k,2755) = -rxt(k,875)*y(k,290)
         mat(k,709) = rxt(k,877)*y(k,293)
         mat(k,3531) = rxt(k,877)*y(k,135)
         mat(k,1480) = -(rxt(k,500)*y(k,256) + (rxt(k,540) + rxt(k,541)) * y(k,147))
         mat(k,3229) = -rxt(k,500)*y(k,291)
         mat(k,2833) = -(rxt(k,540) + rxt(k,541)) * y(k,291)
         mat(k,412) = .400_r8*rxt(k,423)*y(k,293)
         mat(k,1086) = .350_r8*rxt(k,424)*y(k,293)
         mat(k,1985) = .230_r8*rxt(k,503)*y(k,293)
         mat(k,3690) = .400_r8*rxt(k,423)*y(k,107) + .350_r8*rxt(k,424)*y(k,108) &
                      + .230_r8*rxt(k,503)*y(k,139)
         mat(k,3105) = -(rxt(k,168)*y(k,79) + rxt(k,169)*y(k,317) + rxt(k,172) &
                      *y(k,157) + (rxt(k,250) + rxt(k,251)) * y(k,87) + (rxt(k,273) &
                      + rxt(k,274)) * y(k,83) + rxt(k,279)*y(k,65) + rxt(k,280) &
                      *y(k,66) + rxt(k,319)*y(k,88))
         mat(k,1420) = -rxt(k,168)*y(k,292)
         mat(k,3851) = -rxt(k,169)*y(k,292)
         mat(k,2989) = -rxt(k,172)*y(k,292)
         mat(k,3767) = -(rxt(k,250) + rxt(k,251)) * y(k,292)
         mat(k,1042) = -(rxt(k,273) + rxt(k,274)) * y(k,292)
         mat(k,124) = -rxt(k,279)*y(k,292)
         mat(k,158) = -rxt(k,280)*y(k,292)
         mat(k,147) = -rxt(k,319)*y(k,292)
         mat(k,3752) = -(rxt(k,185)*y(k,79) + rxt(k,186)*y(k,81) + rxt(k,187)*y(k,256) &
                      + rxt(k,188)*y(k,156) + rxt(k,189)*y(k,157) + (4._r8*rxt(k,190) &
                      + 4._r8*rxt(k,191)) * y(k,293) + rxt(k,193)*y(k,94) + rxt(k,205) &
                      *y(k,149) + rxt(k,206)*y(k,136) + rxt(k,214)*y(k,148) + rxt(k,215) &
                      *y(k,93) + rxt(k,234)*y(k,61) + (rxt(k,236) + rxt(k,237) &
                      ) * y(k,60) + rxt(k,239)*y(k,87) + rxt(k,242)*y(k,96) + rxt(k,266) &
                      *y(k,20) + rxt(k,268)*y(k,83) + rxt(k,301)*y(k,43) + rxt(k,306) &
                      *y(k,53) + rxt(k,307)*y(k,54) + (rxt(k,309) + rxt(k,320) &
                      ) * y(k,63) + rxt(k,310)*y(k,88) + rxt(k,311)*y(k,90) + rxt(k,312) &
                      *y(k,92) + rxt(k,322)*y(k,25) + rxt(k,329)*y(k,27) + rxt(k,330) &
                      *y(k,28) + rxt(k,332)*y(k,29) + rxt(k,334)*y(k,46) + rxt(k,335) &
                      *y(k,48) + rxt(k,340)*y(k,51) + rxt(k,341)*y(k,52) + rxt(k,346) &
                      *y(k,76) + rxt(k,347)*y(k,77) + rxt(k,348)*y(k,89) + rxt(k,349) &
                      *y(k,150) + rxt(k,350)*y(k,162) + rxt(k,351)*y(k,26) + rxt(k,359) &
                      *y(k,31) + rxt(k,360)*y(k,32) + rxt(k,362)*y(k,50) + rxt(k,363) &
                      *y(k,102) + rxt(k,364)*y(k,104) + rxt(k,365)*y(k,151) + rxt(k,368) &
                      *y(k,169) + rxt(k,372)*y(k,170) + rxt(k,373)*y(k,30) + rxt(k,374) &
                      *y(k,49) + rxt(k,376)*y(k,16) + rxt(k,380)*y(k,97) + rxt(k,381) &
                      *y(k,127) + rxt(k,387)*y(k,126) + rxt(k,397)*y(k,129) + rxt(k,398) &
                      *y(k,130) + rxt(k,399)*y(k,131) + rxt(k,400)*y(k,133) + rxt(k,405) &
                      *y(k,132) + rxt(k,406)*y(k,134) + rxt(k,409)*y(k,1) + rxt(k,413) &
                      *y(k,2) + rxt(k,414)*y(k,15) + rxt(k,415)*y(k,98) + rxt(k,416) &
                      *y(k,99) + rxt(k,419)*y(k,103) + rxt(k,421)*y(k,106) + rxt(k,423) &
                      *y(k,107) + rxt(k,424)*y(k,108) + rxt(k,453)*y(k,111) + rxt(k,454) &
                      *y(k,110) + rxt(k,455)*y(k,112) + rxt(k,456)*y(k,113) + rxt(k,461) &
                      *y(k,115) + rxt(k,464)*y(k,116) + rxt(k,467)*y(k,117) + rxt(k,471) &
                      *y(k,118) + rxt(k,473)*y(k,119) + rxt(k,482)*y(k,120) + rxt(k,486) &
                      *y(k,121) + rxt(k,488)*y(k,109) + rxt(k,489)*y(k,122) + (rxt(k,490) &
                      + rxt(k,491)) * y(k,123) + rxt(k,503)*y(k,139) + rxt(k,544) &
                      *y(k,8) + rxt(k,547)*y(k,9) + rxt(k,548)*y(k,23) + rxt(k,550) &
                      *y(k,24) + rxt(k,554)*y(k,33) + rxt(k,555)*y(k,67) + rxt(k,567) &
                      *y(k,165) + rxt(k,570)*y(k,166) + rxt(k,574)*y(k,225) + rxt(k,575) &
                      *y(k,226) + rxt(k,577)*y(k,227) + rxt(k,580)*y(k,228) + rxt(k,583) &
                      *y(k,229) + rxt(k,584)*y(k,230) + rxt(k,604)*y(k,4) + rxt(k,624) &
                      *y(k,7) + rxt(k,644)*y(k,17) + rxt(k,664)*y(k,125) + rxt(k,684) &
                      *y(k,135) + rxt(k,690)*y(k,198) + rxt(k,691)*y(k,199) + rxt(k,718) &
                      *y(k,201) + rxt(k,719)*y(k,202) + rxt(k,737)*y(k,203) + rxt(k,738) &
                      *y(k,204) + rxt(k,747)*y(k,206) + rxt(k,748)*y(k,207) + rxt(k,749) &
                      *y(k,205) + rxt(k,757)*y(k,200) + rxt(k,758)*y(k,208) + rxt(k,764) &
                      *y(k,210) + rxt(k,769)*y(k,211) + rxt(k,770)*y(k,212) + rxt(k,772) &
                      *y(k,214) + rxt(k,775)*y(k,216) + rxt(k,776)*y(k,215) + rxt(k,779) &
                      *y(k,218) + rxt(k,783)*y(k,220) + rxt(k,784)*y(k,219) + rxt(k,787) &
                      *y(k,222) + rxt(k,788)*y(k,221) + (rxt(k,795) + rxt(k,808) &
                      ) * y(k,69) + rxt(k,797)*y(k,160) + rxt(k,802)*y(k,171) &
                      + rxt(k,807)*y(k,173) + rxt(k,809)*y(k,174) + rxt(k,811) &
                      *y(k,143))
         mat(k,1423) = -rxt(k,185)*y(k,293)
         mat(k,1352) = -rxt(k,186)*y(k,293)
         mat(k,3291) = -rxt(k,187)*y(k,293)
         mat(k,3462) = -rxt(k,188)*y(k,293)
         mat(k,2996) = -rxt(k,189)*y(k,293)
         mat(k,368) = -rxt(k,193)*y(k,293)
         mat(k,3088) = -rxt(k,205)*y(k,293)
         mat(k,321) = -rxt(k,206)*y(k,293)
         mat(k,3512) = -rxt(k,214)*y(k,293)
         mat(k,2724) = -rxt(k,215)*y(k,293)
         mat(k,1219) = -rxt(k,234)*y(k,293)
         mat(k,3317) = -(rxt(k,236) + rxt(k,237)) * y(k,293)
         mat(k,3774) = -rxt(k,239)*y(k,293)
         mat(k,1067) = -rxt(k,242)*y(k,293)
         mat(k,3798) = -rxt(k,266)*y(k,293)
         mat(k,1044) = -rxt(k,268)*y(k,293)
         mat(k,3341) = -rxt(k,301)*y(k,293)
         mat(k,1359) = -rxt(k,306)*y(k,293)
         mat(k,374) = -rxt(k,307)*y(k,293)
         mat(k,1543) = -(rxt(k,309) + rxt(k,320)) * y(k,293)
         mat(k,149) = -rxt(k,310)*y(k,293)
         mat(k,1126) = -rxt(k,311)*y(k,293)
         mat(k,1122) = -rxt(k,312)*y(k,293)
         mat(k,258) = -rxt(k,322)*y(k,293)
         mat(k,221) = -rxt(k,329)*y(k,293)
         mat(k,295) = -rxt(k,330)*y(k,293)
         mat(k,261) = -rxt(k,332)*y(k,293)
         mat(k,1312) = -rxt(k,334)*y(k,293)
         mat(k,108) = -rxt(k,335)*y(k,293)
         mat(k,532) = -rxt(k,340)*y(k,293)
         mat(k,472) = -rxt(k,341)*y(k,293)
         mat(k,1473) = -rxt(k,346)*y(k,293)
         mat(k,1179) = -rxt(k,347)*y(k,293)
         mat(k,726) = -rxt(k,348)*y(k,293)
         mat(k,1275) = -rxt(k,349)*y(k,293)
         mat(k,404) = -rxt(k,350)*y(k,293)
         mat(k,505) = -rxt(k,351)*y(k,293)
         mat(k,342) = -rxt(k,359)*y(k,293)
         mat(k,114) = -rxt(k,360)*y(k,293)
         mat(k,1851) = -rxt(k,362)*y(k,293)
         mat(k,1616) = -rxt(k,363)*y(k,293)
         mat(k,811) = -rxt(k,364)*y(k,293)
         mat(k,1348) = -rxt(k,365)*y(k,293)
         mat(k,488) = -rxt(k,368)*y(k,293)
         mat(k,336) = -rxt(k,372)*y(k,293)
         mat(k,1209) = -rxt(k,373)*y(k,293)
         mat(k,2151) = -rxt(k,374)*y(k,293)
         mat(k,315) = -rxt(k,376)*y(k,293)
         mat(k,887) = -rxt(k,380)*y(k,293)
         mat(k,1627) = -rxt(k,381)*y(k,293)
         mat(k,1763) = -rxt(k,387)*y(k,293)
         mat(k,454) = -rxt(k,397)*y(k,293)
         mat(k,269) = -rxt(k,398)*y(k,293)
         mat(k,397) = -rxt(k,399)*y(k,293)
         mat(k,1809) = -rxt(k,400)*y(k,293)
         mat(k,1874) = -rxt(k,405)*y(k,293)
         mat(k,1367) = -rxt(k,406)*y(k,293)
         mat(k,643) = -rxt(k,409)*y(k,293)
         mat(k,654) = -rxt(k,413)*y(k,293)
         mat(k,155) = -rxt(k,414)*y(k,293)
         mat(k,553) = -rxt(k,415)*y(k,293)
         mat(k,565) = -rxt(k,416)*y(k,293)
         mat(k,1709) = -rxt(k,419)*y(k,293)
         mat(k,806) = -rxt(k,421)*y(k,293)
         mat(k,418) = -rxt(k,423)*y(k,293)
         mat(k,1094) = -rxt(k,424)*y(k,293)
         mat(k,1031) = -rxt(k,453)*y(k,293)
         mat(k,1539) = -rxt(k,454)*y(k,293)
         mat(k,1643) = -rxt(k,455)*y(k,293)
         mat(k,1342) = -rxt(k,456)*y(k,293)
         mat(k,1942) = -rxt(k,461)*y(k,293)
         mat(k,581) = -rxt(k,464)*y(k,293)
         mat(k,481) = -rxt(k,467)*y(k,293)
         mat(k,1976) = -rxt(k,471)*y(k,293)
         mat(k,632) = -rxt(k,473)*y(k,293)
         mat(k,1062) = -rxt(k,482)*y(k,293)
         mat(k,1459) = -rxt(k,486)*y(k,293)
         mat(k,1303) = -rxt(k,488)*y(k,293)
         mat(k,801) = -rxt(k,489)*y(k,293)
         mat(k,1910) = -(rxt(k,490) + rxt(k,491)) * y(k,293)
         mat(k,2004) = -rxt(k,503)*y(k,293)
         mat(k,136) = -rxt(k,544)*y(k,293)
         mat(k,327) = -rxt(k,547)*y(k,293)
         mat(k,200) = -rxt(k,548)*y(k,293)
         mat(k,290) = -rxt(k,550)*y(k,293)
         mat(k,225) = -rxt(k,554)*y(k,293)
         mat(k,172) = -rxt(k,555)*y(k,293)
         mat(k,145) = -rxt(k,567)*y(k,293)
         mat(k,284) = -rxt(k,570)*y(k,293)
         mat(k,622) = -rxt(k,574)*y(k,293)
         mat(k,167) = -rxt(k,575)*y(k,293)
         mat(k,186) = -rxt(k,577)*y(k,293)
         mat(k,741) = -rxt(k,580)*y(k,293)
         mat(k,191) = -rxt(k,583)*y(k,293)
         mat(k,355) = -rxt(k,584)*y(k,293)
         mat(k,1117) = -rxt(k,604)*y(k,293)
         mat(k,870) = -rxt(k,624)*y(k,293)
         mat(k,953) = -rxt(k,644)*y(k,293)
         mat(k,973) = -rxt(k,664)*y(k,293)
         mat(k,720) = -rxt(k,684)*y(k,293)
         mat(k,2191) = -rxt(k,690)*y(k,293)
         mat(k,390) = -rxt(k,691)*y(k,293)
         mat(k,1174) = -rxt(k,718)*y(k,293)
         mat(k,513) = -rxt(k,719)*y(k,293)
         mat(k,1652) = -rxt(k,737)*y(k,293)
         mat(k,521) = -rxt(k,738)*y(k,293)
         mat(k,229) = -rxt(k,747)*y(k,293)
         mat(k,233) = -rxt(k,748)*y(k,293)
         mat(k,525) = -rxt(k,749)*y(k,293)
         mat(k,2201) = -rxt(k,757)*y(k,293)
         mat(k,349) = -rxt(k,758)*y(k,293)
         mat(k,2435) = -rxt(k,764)*y(k,293)
         mat(k,2408) = -rxt(k,769)*y(k,293)
         mat(k,1159) = -rxt(k,770)*y(k,293)
         mat(k,998) = -rxt(k,772)*y(k,293)
         mat(k,588) = -rxt(k,775)*y(k,293)
         mat(k,894) = -rxt(k,776)*y(k,293)
         mat(k,678) = -rxt(k,779)*y(k,293)
         mat(k,1597) = -rxt(k,783)*y(k,293)
         mat(k,1467) = -rxt(k,784)*y(k,293)
         mat(k,1610) = -rxt(k,787)*y(k,293)
         mat(k,1401) = -rxt(k,788)*y(k,293)
         mat(k,243) = -(rxt(k,795) + rxt(k,808)) * y(k,293)
         mat(k,307) = -rxt(k,797)*y(k,293)
         mat(k,460) = -rxt(k,802)*y(k,293)
         mat(k,1522) = -rxt(k,807)*y(k,293)
         mat(k,1165) = -rxt(k,809)*y(k,293)
         mat(k,104) = -rxt(k,811)*y(k,293)
         mat(k,1117) = mat(k,1117) + .770_r8*rxt(k,603)*y(k,157)
         mat(k,870) = mat(k,870) + .080_r8*rxt(k,623)*y(k,157)
         mat(k,953) = mat(k,953) + .300_r8*rxt(k,643)*y(k,157)
         mat(k,258) = mat(k,258) + .650_r8*rxt(k,322)*y(k,293)
         mat(k,505) = mat(k,505) + .130_r8*rxt(k,324)*y(k,157)
         mat(k,295) = mat(k,295) + .500_r8*rxt(k,330)*y(k,293)
         mat(k,1209) = mat(k,1209) + .360_r8*rxt(k,355)*y(k,157)
         mat(k,3341) = mat(k,3341) + rxt(k,300)*y(k,156)
         mat(k,374) = mat(k,374) + .300_r8*rxt(k,307)*y(k,293)
         mat(k,3833) = rxt(k,223)*y(k,256)
         mat(k,903) = rxt(k,277)*y(k,317)
         mat(k,2738) = rxt(k,184)*y(k,157) + 2.000_r8*rxt(k,179)*y(k,256)
         mat(k,1423) = mat(k,1423) + rxt(k,176)*y(k,156) + rxt(k,168)*y(k,292)
         mat(k,1352) = mat(k,1352) + rxt(k,177)*y(k,156)
         mat(k,1044) = mat(k,1044) + rxt(k,267)*y(k,156) + rxt(k,273)*y(k,292)
         mat(k,3774) = mat(k,3774) + rxt(k,238)*y(k,156) + rxt(k,250)*y(k,292)
         mat(k,149) = mat(k,149) + rxt(k,319)*y(k,292)
         mat(k,726) = mat(k,726) + .890_r8*rxt(k,348)*y(k,293)
         mat(k,1122) = mat(k,1122) + .500_r8*rxt(k,312)*y(k,293)
         mat(k,909) = rxt(k,269)*y(k,156)
         mat(k,1067) = mat(k,1067) + rxt(k,241)*y(k,156)
         mat(k,553) = mat(k,553) + .430_r8*rxt(k,415)*y(k,293)
         mat(k,565) = mat(k,565) + .530_r8*rxt(k,416)*y(k,293)
         mat(k,1709) = mat(k,1709) + 1.080_r8*rxt(k,419)*y(k,293)
         mat(k,811) = mat(k,811) + .700_r8*rxt(k,364)*y(k,293)
         mat(k,1303) = mat(k,1303) + .250_r8*rxt(k,487)*y(k,157)
         mat(k,1643) = mat(k,1643) + .500_r8*rxt(k,455)*y(k,293)
         mat(k,1942) = mat(k,1942) + .340_r8*rxt(k,460)*y(k,157) + .060_r8*rxt(k,461) &
                      *y(k,293)
         mat(k,1976) = mat(k,1976) + .340_r8*rxt(k,470)*y(k,157) + .040_r8*rxt(k,471) &
                      *y(k,293)
         mat(k,632) = mat(k,632) + .030_r8*rxt(k,473)*y(k,293)
         mat(k,1062) = mat(k,1062) + .420_r8*rxt(k,482)*y(k,293)
         mat(k,1459) = mat(k,1459) + .510_r8*rxt(k,485)*y(k,157) + .290_r8*rxt(k,486) &
                      *y(k,293)
         mat(k,1910) = mat(k,1910) + (.130_r8*rxt(k,490)+.920_r8*rxt(k,491))*y(k,293)
         mat(k,973) = mat(k,973) + .660_r8*rxt(k,663)*y(k,157)
         mat(k,1763) = mat(k,1763) + .240_r8*rxt(k,386)*y(k,157)
         mat(k,1874) = mat(k,1874) + .360_r8*rxt(k,404)*y(k,157)
         mat(k,720) = mat(k,720) + .630_r8*rxt(k,683)*y(k,157)
         mat(k,2004) = mat(k,2004) + .340_r8*rxt(k,502)*y(k,157)
         mat(k,2895) = rxt(k,207)*y(k,256) + .550_r8*rxt(k,510)*y(k,265) &
                      + .550_r8*rxt(k,512)*y(k,266) + .470_r8*rxt(k,526)*y(k,273) &
                      + .040_r8*rxt(k,528)*y(k,274) + .550_r8*rxt(k,531)*y(k,276) &
                      + .550_r8*rxt(k,534)*y(k,277)
         mat(k,3088) = mat(k,3088) + rxt(k,202)*y(k,256)
         mat(k,3462) = mat(k,3462) + rxt(k,300)*y(k,43) + rxt(k,176)*y(k,79) &
                      + rxt(k,177)*y(k,81) + rxt(k,267)*y(k,83) + rxt(k,238)*y(k,87) &
                      + rxt(k,269)*y(k,95) + rxt(k,241)*y(k,96) + rxt(k,182)*y(k,256)
         mat(k,2996) = mat(k,2996) + .770_r8*rxt(k,603)*y(k,4) + .080_r8*rxt(k,623) &
                      *y(k,7) + .300_r8*rxt(k,643)*y(k,17) + .130_r8*rxt(k,324) &
                      *y(k,26) + .360_r8*rxt(k,355)*y(k,30) + rxt(k,184)*y(k,78) &
                      + .250_r8*rxt(k,487)*y(k,109) + .340_r8*rxt(k,460)*y(k,115) &
                      + .340_r8*rxt(k,470)*y(k,118) + .510_r8*rxt(k,485)*y(k,121) &
                      + .660_r8*rxt(k,663)*y(k,125) + .240_r8*rxt(k,386)*y(k,126) &
                      + .360_r8*rxt(k,404)*y(k,132) + .630_r8*rxt(k,683)*y(k,135) &
                      + .340_r8*rxt(k,502)*y(k,139) + .090_r8*rxt(k,763)*y(k,210) &
                      + rxt(k,183)*y(k,256)
         mat(k,488) = mat(k,488) + .500_r8*rxt(k,368)*y(k,293)
         mat(k,2435) = mat(k,2435) + .090_r8*rxt(k,763)*y(k,157)
         mat(k,467) = .400_r8*rxt(k,542)*y(k,256)
         mat(k,2135) = .700_r8*rxt(k,589)*y(k,256)
         mat(k,2231) = .350_r8*rxt(k,597)*y(k,256)
         mat(k,2068) = .500_r8*rxt(k,609)*y(k,256)
         mat(k,2113) = .100_r8*rxt(k,617)*y(k,256)
         mat(k,2348) = .470_r8*rxt(k,629)*y(k,256)
         mat(k,2260) = .030_r8*rxt(k,637)*y(k,256)
         mat(k,2710) = .490_r8*rxt(k,338)*y(k,256) + .550_r8*rxt(k,445)*y(k,265) &
                      + .550_r8*rxt(k,449)*y(k,266) + .550_r8*rxt(k,492)*y(k,276) &
                      + .550_r8*rxt(k,496)*y(k,277)
         mat(k,3432) = .280_r8*rxt(k,446)*y(k,265) + .280_r8*rxt(k,450)*y(k,266) &
                      + .280_r8*rxt(k,493)*y(k,276) + .280_r8*rxt(k,497)*y(k,277)
         mat(k,796) = .400_r8*rxt(k,556)*y(k,256)
         mat(k,3291) = mat(k,3291) + rxt(k,223)*y(k,57) + 2.000_r8*rxt(k,179)*y(k,78) &
                      + rxt(k,207)*y(k,147) + rxt(k,202)*y(k,149) + rxt(k,182) &
                      *y(k,156) + rxt(k,183)*y(k,157) + .400_r8*rxt(k,542)*y(k,233) &
                      + .700_r8*rxt(k,589)*y(k,235) + .350_r8*rxt(k,597)*y(k,236) &
                      + .500_r8*rxt(k,609)*y(k,238) + .100_r8*rxt(k,617)*y(k,239) &
                      + .470_r8*rxt(k,629)*y(k,243) + .030_r8*rxt(k,637)*y(k,244) &
                      + .490_r8*rxt(k,338)*y(k,250) + .400_r8*rxt(k,556)*y(k,252) &
                      + .200_r8*rxt(k,313)*y(k,257) + .650_r8*rxt(k,422)*y(k,258) &
                      + .060_r8*rxt(k,427)*y(k,259) + .060_r8*rxt(k,433)*y(k,260) &
                      + .580_r8*rxt(k,458)*y(k,267) + .520_r8*rxt(k,462)*y(k,268) &
                      + .600_r8*rxt(k,465)*y(k,269) + .500_r8*rxt(k,468)*y(k,270) &
                      + .400_r8*rxt(k,472)*y(k,271) + .240_r8*rxt(k,477)*y(k,272) &
                      + .850_r8*rxt(k,480)*y(k,273) + .860_r8*rxt(k,483)*y(k,274) &
                      + .500_r8*rxt(k,648)*y(k,279) + .100_r8*rxt(k,657)*y(k,280) &
                      + .590_r8*rxt(k,384)*y(k,282) + .490_r8*rxt(k,391)*y(k,284) &
                      + .400_r8*rxt(k,562)*y(k,285) + .200_r8*rxt(k,395)*y(k,286) &
                      + .540_r8*rxt(k,403)*y(k,287) + .480_r8*rxt(k,668)*y(k,288) &
                      + .100_r8*rxt(k,677)*y(k,289) + .800_r8*rxt(k,500)*y(k,291) &
                      + .150_r8*rxt(k,370)*y(k,296) + .180_r8*rxt(k,688)*y(k,297) &
                      + .180_r8*rxt(k,692)*y(k,298) + .490_r8*rxt(k,704)*y(k,300) &
                      + .380_r8*rxt(k,712)*y(k,301) + .490_r8*rxt(k,722)*y(k,302) &
                      + .150_r8*rxt(k,731)*y(k,303) + .530_r8*rxt(k,741)*y(k,304) &
                      + .490_r8*rxt(k,752)*y(k,305) + .100_r8*rxt(k,761)*y(k,306) &
                      + .100_r8*rxt(k,766)*y(k,307) + .100_r8*rxt(k,773)*y(k,308) &
                      + .100_r8*rxt(k,777)*y(k,309) + .100_r8*rxt(k,781)*y(k,310) &
                      + .100_r8*rxt(k,785)*y(k,311)
         mat(k,600) = .200_r8*rxt(k,313)*y(k,256)
         mat(k,1413) = .650_r8*rxt(k,422)*y(k,256)
         mat(k,1842) = .060_r8*rxt(k,427)*y(k,256)
         mat(k,1744) = .060_r8*rxt(k,433)*y(k,256)
         mat(k,1564) = .550_r8*rxt(k,510)*y(k,147) + .550_r8*rxt(k,445)*y(k,250) &
                      + .280_r8*rxt(k,446)*y(k,251)
         mat(k,1585) = .550_r8*rxt(k,512)*y(k,147) + .550_r8*rxt(k,449)*y(k,250) &
                      + .280_r8*rxt(k,450)*y(k,251)
         mat(k,1009) = .580_r8*rxt(k,458)*y(k,256)
         mat(k,1082) = .520_r8*rxt(k,462)*y(k,256)
         mat(k,994) = .600_r8*rxt(k,465)*y(k,256)
         mat(k,1020) = .500_r8*rxt(k,468)*y(k,256)
         mat(k,1328) = .400_r8*rxt(k,472)*y(k,256)
         mat(k,2047) = .240_r8*rxt(k,477)*y(k,256)
         mat(k,1193) = .470_r8*rxt(k,526)*y(k,147) + .850_r8*rxt(k,480)*y(k,256)
         mat(k,1269) = .040_r8*rxt(k,528)*y(k,147) + .860_r8*rxt(k,483)*y(k,256)
         mat(k,1794) = .550_r8*rxt(k,531)*y(k,147) + .550_r8*rxt(k,492)*y(k,250) &
                      + .280_r8*rxt(k,493)*y(k,251)
         mat(k,1682) = .550_r8*rxt(k,534)*y(k,147) + .550_r8*rxt(k,496)*y(k,250) &
                      + .280_r8*rxt(k,497)*y(k,251)
         mat(k,2321) = .500_r8*rxt(k,648)*y(k,256)
         mat(k,2174) = .100_r8*rxt(k,657)*y(k,256)
         mat(k,1395) = .590_r8*rxt(k,384)*y(k,256)
         mat(k,1508) = .490_r8*rxt(k,391)*y(k,256)
         mat(k,820) = .400_r8*rxt(k,562)*y(k,256)
         mat(k,662) = .200_r8*rxt(k,395)*y(k,256)
         mat(k,1381) = .540_r8*rxt(k,403)*y(k,256)
         mat(k,2382) = .480_r8*rxt(k,668)*y(k,256)
         mat(k,2289) = .100_r8*rxt(k,677)*y(k,256)
         mat(k,1493) = .800_r8*rxt(k,500)*y(k,256)
         mat(k,3112) = rxt(k,168)*y(k,79) + rxt(k,273)*y(k,83) + rxt(k,250)*y(k,87) &
                      + rxt(k,319)*y(k,88) + 2.000_r8*rxt(k,169)*y(k,317)
         mat(k,3752) = mat(k,3752) + .650_r8*rxt(k,322)*y(k,25) + .500_r8*rxt(k,330) &
                      *y(k,28) + .300_r8*rxt(k,307)*y(k,54) + .890_r8*rxt(k,348) &
                      *y(k,89) + .500_r8*rxt(k,312)*y(k,92) + .430_r8*rxt(k,415) &
                      *y(k,98) + .530_r8*rxt(k,416)*y(k,99) + 1.080_r8*rxt(k,419) &
                      *y(k,103) + .700_r8*rxt(k,364)*y(k,104) + .500_r8*rxt(k,455) &
                      *y(k,112) + .060_r8*rxt(k,461)*y(k,115) + .040_r8*rxt(k,471) &
                      *y(k,118) + .030_r8*rxt(k,473)*y(k,119) + .420_r8*rxt(k,482) &
                      *y(k,120) + .290_r8*rxt(k,486)*y(k,121) + (.130_r8*rxt(k,490) &
                       +.920_r8*rxt(k,491))*y(k,123) + .500_r8*rxt(k,368)*y(k,169)
         mat(k,1234) = .150_r8*rxt(k,370)*y(k,256)
         mat(k,842) = .180_r8*rxt(k,688)*y(k,256)
         mat(k,924) = .180_r8*rxt(k,692)*y(k,256)
         mat(k,2546) = .490_r8*rxt(k,704)*y(k,256)
         mat(k,2502) = .380_r8*rxt(k,712)*y(k,256)
         mat(k,2592) = .490_r8*rxt(k,722)*y(k,256)
         mat(k,2090) = .150_r8*rxt(k,731)*y(k,256)
         mat(k,2481) = .530_r8*rxt(k,741)*y(k,256)
         mat(k,2639) = .490_r8*rxt(k,752)*y(k,256)
         mat(k,687) = .100_r8*rxt(k,761)*y(k,256)
         mat(k,851) = .100_r8*rxt(k,766)*y(k,256)
         mat(k,1152) = .100_r8*rxt(k,773)*y(k,256)
         mat(k,933) = .100_r8*rxt(k,777)*y(k,256)
         mat(k,695) = .100_r8*rxt(k,781)*y(k,256)
         mat(k,703) = .100_r8*rxt(k,785)*y(k,256)
         mat(k,3858) = rxt(k,277)*y(k,75) + 2.000_r8*rxt(k,169)*y(k,292)
      end do
      end subroutine nlnmat15
      subroutine nlnmat16( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,377) = -(rxt(k,565)*y(k,256) + rxt(k,566)*y(k,147))
         mat(k,3150) = -rxt(k,565)*y(k,294)
         mat(k,2765) = -rxt(k,566)*y(k,294)
         mat(k,169) = .200_r8*rxt(k,555)*y(k,293)
         mat(k,142) = .140_r8*rxt(k,567)*y(k,293)
         mat(k,281) = rxt(k,570)*y(k,293)
         mat(k,3579) = .200_r8*rxt(k,555)*y(k,67) + .140_r8*rxt(k,567)*y(k,165) &
                      + rxt(k,570)*y(k,166)
         mat(k,822) = -(rxt(k,366)*y(k,256) + rxt(k,367)*y(k,147))
         mat(k,3183) = -rxt(k,366)*y(k,295)
         mat(k,2792) = -rxt(k,367)*y(k,295)
         mat(k,1195) = rxt(k,373)*y(k,293)
         mat(k,483) = .500_r8*rxt(k,368)*y(k,293)
         mat(k,3632) = rxt(k,373)*y(k,30) + .500_r8*rxt(k,368)*y(k,169)
         mat(k,1224) = -(rxt(k,369)*y(k,251) + rxt(k,370)*y(k,256) + rxt(k,371) &
                      *y(k,147))
         mat(k,3356) = -rxt(k,369)*y(k,296)
         mat(k,3208) = -rxt(k,370)*y(k,296)
         mat(k,2815) = -rxt(k,371)*y(k,296)
         mat(k,2137) = rxt(k,374)*y(k,293)
         mat(k,333) = rxt(k,372)*y(k,293)
         mat(k,3668) = rxt(k,374)*y(k,49) + rxt(k,372)*y(k,170)
         mat(k,834) = -(rxt(k,688)*y(k,256) + rxt(k,689)*y(k,147))
         mat(k,3184) = -rxt(k,688)*y(k,297)
         mat(k,2793) = -rxt(k,689)*y(k,297)
         mat(k,2175) = rxt(k,690)*y(k,293)
         mat(k,3633) = rxt(k,690)*y(k,198)
         mat(k,917) = -(rxt(k,692)*y(k,256) + rxt(k,693)*y(k,147))
         mat(k,3189) = -rxt(k,692)*y(k,298)
         mat(k,2798) = -rxt(k,693)*y(k,298)
         mat(k,387) = rxt(k,691)*y(k,293)
         mat(k,3640) = rxt(k,691)*y(k,199)
         mat(k,2445) = -(rxt(k,694)*y(k,250) + rxt(k,695)*y(k,251) + rxt(k,696) &
                      *y(k,256) + rxt(k,697)*y(k,147) + rxt(k,698)*y(k,149) + rxt(k,699) &
                      *y(k,300) + rxt(k,700)*y(k,302))
         mat(k,2693) = -rxt(k,694)*y(k,299)
         mat(k,3413) = -rxt(k,695)*y(k,299)
         mat(k,3272) = -rxt(k,696)*y(k,299)
         mat(k,2876) = -rxt(k,697)*y(k,299)
         mat(k,3069) = -rxt(k,698)*y(k,299)
         mat(k,2529) = -rxt(k,699)*y(k,299)
         mat(k,2575) = -rxt(k,700)*y(k,299)
         mat(k,2876) = mat(k,2876) + rxt(k,753)*y(k,305)
         mat(k,3069) = mat(k,3069) + rxt(k,754)*y(k,305)
         mat(k,523) = .290_r8*rxt(k,749)*y(k,293)
         mat(k,996) = .860_r8*rxt(k,772)*y(k,293)
         mat(k,2121) = rxt(k,594)*y(k,305)
         mat(k,2216) = rxt(k,602)*y(k,305)
         mat(k,2055) = rxt(k,614)*y(k,305)
         mat(k,2100) = rxt(k,622)*y(k,305)
         mat(k,2333) = rxt(k,634)*y(k,305)
         mat(k,2245) = rxt(k,642)*y(k,305)
         mat(k,2693) = mat(k,2693) + rxt(k,750)*y(k,305)
         mat(k,3413) = mat(k,3413) + rxt(k,751)*y(k,305)
         mat(k,3272) = mat(k,3272) + .490_r8*rxt(k,752)*y(k,305)
         mat(k,2306) = rxt(k,654)*y(k,305)
         mat(k,2160) = rxt(k,662)*y(k,305)
         mat(k,2367) = rxt(k,674)*y(k,305)
         mat(k,2274) = rxt(k,682)*y(k,305)
         mat(k,3733) = .290_r8*rxt(k,749)*y(k,205) + .860_r8*rxt(k,772)*y(k,214)
         mat(k,2529) = mat(k,2529) + rxt(k,708)*y(k,305)
         mat(k,2487) = rxt(k,717)*y(k,305)
         mat(k,2575) = mat(k,2575) + rxt(k,727)*y(k,305)
         mat(k,2075) = rxt(k,736)*y(k,305)
         mat(k,2466) = rxt(k,746)*y(k,305)
         mat(k,2622) = rxt(k,753)*y(k,147) + rxt(k,754)*y(k,149) + rxt(k,594)*y(k,235) &
                      + rxt(k,602)*y(k,236) + rxt(k,614)*y(k,238) + rxt(k,622) &
                      *y(k,239) + rxt(k,634)*y(k,243) + rxt(k,642)*y(k,244) &
                      + rxt(k,750)*y(k,250) + rxt(k,751)*y(k,251) + .490_r8*rxt(k,752) &
                      *y(k,256) + rxt(k,654)*y(k,279) + rxt(k,662)*y(k,280) &
                      + rxt(k,674)*y(k,288) + rxt(k,682)*y(k,289) + rxt(k,708) &
                      *y(k,300) + rxt(k,717)*y(k,301) + rxt(k,727)*y(k,302) &
                      + rxt(k,736)*y(k,303) + rxt(k,746)*y(k,304) &
                      + 4.000_r8*rxt(k,755)*y(k,305)
         mat(k,2532) = -(rxt(k,592)*y(k,235) + rxt(k,600)*y(k,236) + rxt(k,612) &
                      *y(k,238) + rxt(k,620)*y(k,239) + rxt(k,632)*y(k,243) + rxt(k,640) &
                      *y(k,244) + rxt(k,652)*y(k,279) + rxt(k,660)*y(k,280) + rxt(k,672) &
                      *y(k,288) + rxt(k,680)*y(k,289) + rxt(k,685)*y(k,148) + rxt(k,699) &
                      *y(k,299) + rxt(k,702)*y(k,250) + rxt(k,703)*y(k,251) + rxt(k,704) &
                      *y(k,256) + rxt(k,705)*y(k,147) + rxt(k,706)*y(k,149) &
                      + 4._r8*rxt(k,707)*y(k,300) + rxt(k,708)*y(k,305) + rxt(k,715) &
                      *y(k,301) + rxt(k,725)*y(k,302) + rxt(k,734)*y(k,303) + rxt(k,744) &
                      *y(k,304))
         mat(k,2124) = -rxt(k,592)*y(k,300)
         mat(k,2219) = -rxt(k,600)*y(k,300)
         mat(k,2058) = -rxt(k,612)*y(k,300)
         mat(k,2103) = -rxt(k,620)*y(k,300)
         mat(k,2336) = -rxt(k,632)*y(k,300)
         mat(k,2248) = -rxt(k,640)*y(k,300)
         mat(k,2309) = -rxt(k,652)*y(k,300)
         mat(k,2163) = -rxt(k,660)*y(k,300)
         mat(k,2370) = -rxt(k,672)*y(k,300)
         mat(k,2277) = -rxt(k,680)*y(k,300)
         mat(k,3496) = -rxt(k,685)*y(k,300)
         mat(k,2448) = -rxt(k,699)*y(k,300)
         mat(k,2696) = -rxt(k,702)*y(k,300)
         mat(k,3416) = -rxt(k,703)*y(k,300)
         mat(k,3275) = -rxt(k,704)*y(k,300)
         mat(k,2879) = -rxt(k,705)*y(k,300)
         mat(k,3072) = -rxt(k,706)*y(k,300)
         mat(k,2625) = -rxt(k,708)*y(k,300)
         mat(k,2490) = -rxt(k,715)*y(k,300)
         mat(k,2578) = -rxt(k,725)*y(k,300)
         mat(k,2078) = -rxt(k,734)*y(k,300)
         mat(k,2469) = -rxt(k,744)*y(k,300)
         mat(k,1111) = .270_r8*rxt(k,603)*y(k,157)
         mat(k,949) = .300_r8*rxt(k,643)*y(k,157)
         mat(k,3072) = mat(k,3072) + rxt(k,709)*y(k,201)
         mat(k,2980) = .270_r8*rxt(k,603)*y(k,4) + .300_r8*rxt(k,643)*y(k,17)
         mat(k,1170) = rxt(k,709)*y(k,149) + rxt(k,718)*y(k,293)
         mat(k,228) = .710_r8*rxt(k,747)*y(k,293)
         mat(k,997) = .140_r8*rxt(k,772)*y(k,293)
         mat(k,3736) = rxt(k,718)*y(k,201) + .710_r8*rxt(k,747)*y(k,206) &
                      + .140_r8*rxt(k,772)*y(k,214)
         mat(k,2489) = -(rxt(k,710)*y(k,250) + rxt(k,711)*y(k,251) + rxt(k,712) &
                      *y(k,256) + rxt(k,713)*y(k,147) + rxt(k,714)*y(k,149) + rxt(k,716) &
                      *y(k,302) + rxt(k,717)*y(k,305))
         mat(k,2695) = -rxt(k,710)*y(k,301)
         mat(k,3415) = -rxt(k,711)*y(k,301)
         mat(k,3274) = -rxt(k,712)*y(k,301)
         mat(k,2878) = -rxt(k,713)*y(k,301)
         mat(k,3071) = -rxt(k,714)*y(k,301)
         mat(k,2577) = -rxt(k,716)*y(k,301)
         mat(k,2624) = -rxt(k,717)*y(k,301)
         mat(k,1110) = .330_r8*rxt(k,603)*y(k,157)
         mat(k,2878) = mat(k,2878) + .700_r8*rxt(k,697)*y(k,299) + rxt(k,705)*y(k,300)
         mat(k,3071) = mat(k,3071) + rxt(k,698)*y(k,299) + rxt(k,706)*y(k,300)
         mat(k,2979) = .330_r8*rxt(k,603)*y(k,4)
         mat(k,2195) = .230_r8*rxt(k,757)*y(k,293)
         mat(k,227) = .290_r8*rxt(k,747)*y(k,293)
         mat(k,2123) = rxt(k,592)*y(k,300)
         mat(k,2218) = rxt(k,600)*y(k,300)
         mat(k,2057) = rxt(k,612)*y(k,300)
         mat(k,2102) = rxt(k,620)*y(k,300)
         mat(k,2335) = rxt(k,632)*y(k,300)
         mat(k,2247) = rxt(k,640)*y(k,300)
         mat(k,2695) = mat(k,2695) + rxt(k,694)*y(k,299) + rxt(k,702)*y(k,300)
         mat(k,3415) = mat(k,3415) + .500_r8*rxt(k,695)*y(k,299) + rxt(k,703)*y(k,300)
         mat(k,3274) = mat(k,3274) + .490_r8*rxt(k,704)*y(k,300)
         mat(k,2308) = rxt(k,652)*y(k,300)
         mat(k,2162) = rxt(k,660)*y(k,300)
         mat(k,2369) = rxt(k,672)*y(k,300)
         mat(k,2276) = rxt(k,680)*y(k,300)
         mat(k,3735) = .230_r8*rxt(k,757)*y(k,200) + .290_r8*rxt(k,747)*y(k,206)
         mat(k,2447) = .700_r8*rxt(k,697)*y(k,147) + rxt(k,698)*y(k,149) + rxt(k,694) &
                      *y(k,250) + .500_r8*rxt(k,695)*y(k,251) + 2.000_r8*rxt(k,699) &
                      *y(k,300) + rxt(k,700)*y(k,302) + rxt(k,701)*y(k,305)
         mat(k,2531) = rxt(k,705)*y(k,147) + rxt(k,706)*y(k,149) + rxt(k,592)*y(k,235) &
                      + rxt(k,600)*y(k,236) + rxt(k,612)*y(k,238) + rxt(k,620) &
                      *y(k,239) + rxt(k,632)*y(k,243) + rxt(k,640)*y(k,244) &
                      + rxt(k,702)*y(k,250) + rxt(k,703)*y(k,251) + .490_r8*rxt(k,704) &
                      *y(k,256) + rxt(k,652)*y(k,279) + rxt(k,660)*y(k,280) &
                      + rxt(k,672)*y(k,288) + rxt(k,680)*y(k,289) &
                      + 2.000_r8*rxt(k,699)*y(k,299) + 4.000_r8*rxt(k,707)*y(k,300) &
                      + rxt(k,725)*y(k,302) + rxt(k,734)*y(k,303) + rxt(k,744) &
                      *y(k,304) + rxt(k,708)*y(k,305)
         mat(k,2577) = mat(k,2577) + rxt(k,700)*y(k,299) + rxt(k,725)*y(k,300)
         mat(k,2077) = rxt(k,734)*y(k,300)
         mat(k,2468) = rxt(k,744)*y(k,300)
         mat(k,2624) = mat(k,2624) + rxt(k,701)*y(k,299) + rxt(k,708)*y(k,300)
         mat(k,2579) = -(rxt(k,593)*y(k,235) + rxt(k,601)*y(k,236) + rxt(k,613) &
                      *y(k,238) + rxt(k,621)*y(k,239) + rxt(k,633)*y(k,243) + rxt(k,641) &
                      *y(k,244) + rxt(k,653)*y(k,279) + rxt(k,661)*y(k,280) + rxt(k,673) &
                      *y(k,288) + rxt(k,681)*y(k,289) + rxt(k,686)*y(k,148) + rxt(k,700) &
                      *y(k,299) + rxt(k,716)*y(k,301) + rxt(k,720)*y(k,250) + rxt(k,721) &
                      *y(k,251) + rxt(k,722)*y(k,256) + rxt(k,723)*y(k,147) + rxt(k,724) &
                      *y(k,149) + rxt(k,725)*y(k,300) + 4._r8*rxt(k,726)*y(k,302) &
                      + rxt(k,727)*y(k,305) + rxt(k,735)*y(k,303) + rxt(k,745) &
                      *y(k,304))
         mat(k,2125) = -rxt(k,593)*y(k,302)
         mat(k,2220) = -rxt(k,601)*y(k,302)
         mat(k,2059) = -rxt(k,613)*y(k,302)
         mat(k,2104) = -rxt(k,621)*y(k,302)
         mat(k,2337) = -rxt(k,633)*y(k,302)
         mat(k,2249) = -rxt(k,641)*y(k,302)
         mat(k,2310) = -rxt(k,653)*y(k,302)
         mat(k,2164) = -rxt(k,661)*y(k,302)
         mat(k,2371) = -rxt(k,673)*y(k,302)
         mat(k,2278) = -rxt(k,681)*y(k,302)
         mat(k,3497) = -rxt(k,686)*y(k,302)
         mat(k,2449) = -rxt(k,700)*y(k,302)
         mat(k,2491) = -rxt(k,716)*y(k,302)
         mat(k,2697) = -rxt(k,720)*y(k,302)
         mat(k,3417) = -rxt(k,721)*y(k,302)
         mat(k,3276) = -rxt(k,722)*y(k,302)
         mat(k,2880) = -rxt(k,723)*y(k,302)
         mat(k,3073) = -rxt(k,724)*y(k,302)
         mat(k,2533) = -rxt(k,725)*y(k,302)
         mat(k,2626) = -rxt(k,727)*y(k,302)
         mat(k,2079) = -rxt(k,735)*y(k,302)
         mat(k,2470) = -rxt(k,745)*y(k,302)
         mat(k,967) = .330_r8*rxt(k,663)*y(k,157)
         mat(k,3073) = mat(k,3073) + rxt(k,728)*y(k,203)
         mat(k,2981) = .330_r8*rxt(k,663)*y(k,125)
         mat(k,1647) = rxt(k,728)*y(k,149) + .750_r8*rxt(k,737)*y(k,293)
         mat(k,232) = .710_r8*rxt(k,748)*y(k,293)
         mat(k,2424) = .170_r8*rxt(k,764)*y(k,293)
         mat(k,3737) = .750_r8*rxt(k,737)*y(k,203) + .710_r8*rxt(k,748)*y(k,207) &
                      + .170_r8*rxt(k,764)*y(k,210)
         mat(k,2072) = -(rxt(k,729)*y(k,250) + rxt(k,730)*y(k,251) + rxt(k,731) &
                      *y(k,256) + rxt(k,732)*y(k,147) + rxt(k,733)*y(k,149) + rxt(k,734) &
                      *y(k,300) + rxt(k,735)*y(k,302) + rxt(k,736)*y(k,305))
         mat(k,2678) = -rxt(k,729)*y(k,303)
         mat(k,3398) = -rxt(k,730)*y(k,303)
         mat(k,3257) = -rxt(k,731)*y(k,303)
         mat(k,2861) = -rxt(k,732)*y(k,303)
         mat(k,3054) = -rxt(k,733)*y(k,303)
         mat(k,2514) = -rxt(k,734)*y(k,303)
         mat(k,2560) = -rxt(k,735)*y(k,303)
         mat(k,2607) = -rxt(k,736)*y(k,303)
         mat(k,2861) = mat(k,2861) + .830_r8*rxt(k,713)*y(k,301)
         mat(k,3054) = mat(k,3054) + rxt(k,714)*y(k,301)
         mat(k,2678) = mat(k,2678) + rxt(k,710)*y(k,301)
         mat(k,3398) = mat(k,3398) + rxt(k,711)*y(k,301)
         mat(k,3257) = mat(k,3257) + .380_r8*rxt(k,712)*y(k,301)
         mat(k,2514) = mat(k,2514) + rxt(k,715)*y(k,301)
         mat(k,2484) = .830_r8*rxt(k,713)*y(k,147) + rxt(k,714)*y(k,149) + rxt(k,710) &
                      *y(k,250) + rxt(k,711)*y(k,251) + .380_r8*rxt(k,712)*y(k,256) &
                      + rxt(k,715)*y(k,300) + rxt(k,716)*y(k,302) + rxt(k,717) &
                      *y(k,305)
         mat(k,2560) = mat(k,2560) + rxt(k,716)*y(k,301)
         mat(k,2607) = mat(k,2607) + rxt(k,717)*y(k,301)
      end do
      end subroutine nlnmat16
      subroutine nlnmat17( avec_len, mat, y, rxt )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k,2467) = -(rxt(k,739)*y(k,250) + rxt(k,740)*y(k,251) + rxt(k,741) &
                      *y(k,256) + rxt(k,742)*y(k,147) + rxt(k,743)*y(k,149) + rxt(k,744) &
                      *y(k,300) + rxt(k,746)*y(k,305))
         mat(k,2694) = -rxt(k,739)*y(k,304)
         mat(k,3414) = -rxt(k,740)*y(k,304)
         mat(k,3273) = -rxt(k,741)*y(k,304)
         mat(k,2877) = -rxt(k,742)*y(k,304)
         mat(k,3070) = -rxt(k,743)*y(k,304)
         mat(k,2530) = -rxt(k,744)*y(k,304)
         mat(k,2623) = -rxt(k,746)*y(k,304)
         mat(k,2877) = mat(k,2877) + rxt(k,723)*y(k,302) + .700_r8*rxt(k,732)*y(k,303)
         mat(k,3070) = mat(k,3070) + rxt(k,724)*y(k,302) + rxt(k,733)*y(k,303)
         mat(k,1646) = .250_r8*rxt(k,737)*y(k,293)
         mat(k,231) = .290_r8*rxt(k,748)*y(k,293)
         mat(k,2122) = rxt(k,593)*y(k,302)
         mat(k,2217) = rxt(k,601)*y(k,302)
         mat(k,2056) = rxt(k,613)*y(k,302)
         mat(k,2101) = rxt(k,621)*y(k,302)
         mat(k,2334) = rxt(k,633)*y(k,302)
         mat(k,2246) = rxt(k,641)*y(k,302)
         mat(k,2694) = mat(k,2694) + rxt(k,720)*y(k,302) + rxt(k,729)*y(k,303)
         mat(k,3414) = mat(k,3414) + rxt(k,721)*y(k,302) + rxt(k,730)*y(k,303)
         mat(k,3273) = mat(k,3273) + .490_r8*rxt(k,722)*y(k,302) + .150_r8*rxt(k,731) &
                      *y(k,303)
         mat(k,2307) = rxt(k,653)*y(k,302)
         mat(k,2161) = rxt(k,661)*y(k,302)
         mat(k,2368) = rxt(k,673)*y(k,302)
         mat(k,2275) = rxt(k,681)*y(k,302)
         mat(k,3734) = .250_r8*rxt(k,737)*y(k,203) + .290_r8*rxt(k,748)*y(k,207)
         mat(k,2446) = rxt(k,700)*y(k,302)
         mat(k,2530) = mat(k,2530) + rxt(k,725)*y(k,302) + rxt(k,734)*y(k,303)
         mat(k,2488) = rxt(k,716)*y(k,302)
         mat(k,2576) = rxt(k,723)*y(k,147) + rxt(k,724)*y(k,149) + rxt(k,593)*y(k,235) &
                      + rxt(k,601)*y(k,236) + rxt(k,613)*y(k,238) + rxt(k,621) &
                      *y(k,239) + rxt(k,633)*y(k,243) + rxt(k,641)*y(k,244) &
                      + rxt(k,720)*y(k,250) + rxt(k,721)*y(k,251) + .490_r8*rxt(k,722) &
                      *y(k,256) + rxt(k,653)*y(k,279) + rxt(k,661)*y(k,280) &
                      + rxt(k,673)*y(k,288) + rxt(k,681)*y(k,289) + rxt(k,700) &
                      *y(k,299) + rxt(k,725)*y(k,300) + rxt(k,716)*y(k,301) &
                      + 4.000_r8*rxt(k,726)*y(k,302) + 2.000_r8*rxt(k,735)*y(k,303) &
                      + rxt(k,727)*y(k,305)
         mat(k,2076) = .700_r8*rxt(k,732)*y(k,147) + rxt(k,733)*y(k,149) + rxt(k,729) &
                      *y(k,250) + rxt(k,730)*y(k,251) + .150_r8*rxt(k,731)*y(k,256) &
                      + rxt(k,734)*y(k,300) + 2.000_r8*rxt(k,735)*y(k,302) &
                      + rxt(k,736)*y(k,305)
         mat(k,2623) = mat(k,2623) + rxt(k,727)*y(k,302) + rxt(k,736)*y(k,303)
         mat(k,2627) = -(rxt(k,594)*y(k,235) + rxt(k,602)*y(k,236) + rxt(k,614) &
                      *y(k,238) + rxt(k,622)*y(k,239) + rxt(k,634)*y(k,243) + rxt(k,642) &
                      *y(k,244) + rxt(k,654)*y(k,279) + rxt(k,662)*y(k,280) + rxt(k,674) &
                      *y(k,288) + rxt(k,682)*y(k,289) + rxt(k,687)*y(k,148) + rxt(k,701) &
                      *y(k,299) + rxt(k,708)*y(k,300) + rxt(k,717)*y(k,301) + rxt(k,727) &
                      *y(k,302) + rxt(k,736)*y(k,303) + rxt(k,746)*y(k,304) + rxt(k,750) &
                      *y(k,250) + rxt(k,751)*y(k,251) + rxt(k,752)*y(k,256) + rxt(k,753) &
                      *y(k,147) + rxt(k,754)*y(k,149) + 4._r8*rxt(k,755)*y(k,305))
         mat(k,2126) = -rxt(k,594)*y(k,305)
         mat(k,2221) = -rxt(k,602)*y(k,305)
         mat(k,2060) = -rxt(k,614)*y(k,305)
         mat(k,2105) = -rxt(k,622)*y(k,305)
         mat(k,2338) = -rxt(k,634)*y(k,305)
         mat(k,2250) = -rxt(k,642)*y(k,305)
         mat(k,2311) = -rxt(k,654)*y(k,305)
         mat(k,2165) = -rxt(k,662)*y(k,305)
         mat(k,2372) = -rxt(k,674)*y(k,305)
         mat(k,2279) = -rxt(k,682)*y(k,305)
         mat(k,3498) = -rxt(k,687)*y(k,305)
         mat(k,2450) = -rxt(k,701)*y(k,305)
         mat(k,2534) = -rxt(k,708)*y(k,305)
         mat(k,2492) = -rxt(k,717)*y(k,305)
         mat(k,2580) = -rxt(k,727)*y(k,305)
         mat(k,2080) = -rxt(k,736)*y(k,305)
         mat(k,2471) = -rxt(k,746)*y(k,305)
         mat(k,2698) = -rxt(k,750)*y(k,305)
         mat(k,3418) = -rxt(k,751)*y(k,305)
         mat(k,3277) = -rxt(k,752)*y(k,305)
         mat(k,2881) = -rxt(k,753)*y(k,305)
         mat(k,3074) = -rxt(k,754)*y(k,305)
         mat(k,3074) = mat(k,3074) + rxt(k,756)*y(k,200)
         mat(k,2196) = rxt(k,756)*y(k,149) + .770_r8*rxt(k,757)*y(k,293)
         mat(k,524) = .710_r8*rxt(k,749)*y(k,293)
         mat(k,3738) = .770_r8*rxt(k,757)*y(k,200) + .710_r8*rxt(k,749)*y(k,205)
         mat(k,680) = -(rxt(k,761)*y(k,256) + rxt(k,762)*y(k,147))
         mat(k,3171) = -rxt(k,761)*y(k,306)
         mat(k,2780) = -rxt(k,762)*y(k,306)
         mat(k,2412) = .830_r8*rxt(k,764)*y(k,293)
         mat(k,3617) = .830_r8*rxt(k,764)*y(k,210)
         mat(k,843) = -(rxt(k,766)*y(k,256) + rxt(k,767)*y(k,147))
         mat(k,3185) = -rxt(k,766)*y(k,307)
         mat(k,2794) = -rxt(k,767)*y(k,307)
         mat(k,2384) = rxt(k,769)*y(k,293)
         mat(k,3634) = rxt(k,769)*y(k,211)
         mat(k,1144) = -(rxt(k,773)*y(k,256) + rxt(k,774)*y(k,147))
         mat(k,3204) = -rxt(k,773)*y(k,308)
         mat(k,2811) = -rxt(k,774)*y(k,308)
         mat(k,583) = rxt(k,775)*y(k,293)
         mat(k,3660) = rxt(k,775)*y(k,216)
         mat(k,926) = -(rxt(k,777)*y(k,256) + rxt(k,778)*y(k,147))
         mat(k,3190) = -rxt(k,777)*y(k,309)
         mat(k,2799) = -rxt(k,778)*y(k,309)
         mat(k,672) = rxt(k,779)*y(k,293)
         mat(k,3641) = rxt(k,779)*y(k,218)
         mat(k,688) = -(rxt(k,781)*y(k,256) + rxt(k,782)*y(k,147))
         mat(k,3172) = -rxt(k,781)*y(k,310)
         mat(k,2781) = -rxt(k,782)*y(k,310)
         mat(k,1586) = rxt(k,783)*y(k,293)
         mat(k,3618) = rxt(k,783)*y(k,220)
         mat(k,696) = -(rxt(k,785)*y(k,256) + rxt(k,786)*y(k,147))
         mat(k,3173) = -rxt(k,785)*y(k,311)
         mat(k,2782) = -rxt(k,786)*y(k,311)
         mat(k,1598) = rxt(k,787)*y(k,293)
         mat(k,3619) = rxt(k,787)*y(k,222)
         mat(k,762) = -(rxt(k,572)*y(k,256) + rxt(k,573)*y(k,147))
         mat(k,3178) = -rxt(k,572)*y(k,312)
         mat(k,2786) = -rxt(k,573)*y(k,312)
         mat(k,615) = rxt(k,574)*y(k,293)
         mat(k,165) = .650_r8*rxt(k,575)*y(k,293)
         mat(k,3625) = rxt(k,574)*y(k,225) + .650_r8*rxt(k,575)*y(k,226)
         mat(k,96) = -(rxt(k,880)*y(k,256) + rxt(k,881)*y(k,147))
         mat(k,3131) = -rxt(k,880)*y(k,313)
         mat(k,2756) = -rxt(k,881)*y(k,313)
         mat(k,160) = rxt(k,879)*y(k,293)
         mat(k,3532) = rxt(k,879)*y(k,226)
         mat(k,778) = -(rxt(k,578)*y(k,256) + rxt(k,579)*y(k,147))
         mat(k,3179) = -rxt(k,578)*y(k,314)
         mat(k,2787) = -rxt(k,579)*y(k,314)
         mat(k,182) = .560_r8*rxt(k,577)*y(k,293)
         mat(k,733) = rxt(k,580)*y(k,293)
         mat(k,3626) = .560_r8*rxt(k,577)*y(k,227) + rxt(k,580)*y(k,228)
         mat(k,102) = -(rxt(k,883)*y(k,256) + rxt(k,884)*y(k,147))
         mat(k,3132) = -rxt(k,883)*y(k,315)
         mat(k,2757) = -rxt(k,884)*y(k,315)
         mat(k,177) = rxt(k,882)*y(k,293)
         mat(k,3533) = rxt(k,882)*y(k,227)
         mat(k,443) = -(rxt(k,581)*y(k,256) + rxt(k,582)*y(k,147))
         mat(k,3155) = -rxt(k,581)*y(k,316)
         mat(k,2769) = -rxt(k,582)*y(k,316)
         mat(k,189) = .300_r8*rxt(k,583)*y(k,293)
         mat(k,351) = rxt(k,584)*y(k,293)
         mat(k,3589) = .300_r8*rxt(k,583)*y(k,229) + rxt(k,584)*y(k,230)
         mat(k,3862) = -(rxt(k,169)*y(k,292) + rxt(k,277)*y(k,75) + rxt(k,810) &
                      *y(k,175))
         mat(k,3116) = -rxt(k,169)*y(k,317)
         mat(k,904) = -rxt(k,277)*y(k,317)
         mat(k,217) = -rxt(k,810)*y(k,317)
         mat(k,264) = rxt(k,332)*y(k,293)
         mat(k,343) = rxt(k,359)*y(k,293)
         mat(k,115) = rxt(k,360)*y(k,293)
         mat(k,3345) = rxt(k,301)*y(k,293)
         mat(k,1313) = rxt(k,334)*y(k,293)
         mat(k,2152) = rxt(k,374)*y(k,293)
         mat(k,1852) = rxt(k,362)*y(k,293)
         mat(k,533) = rxt(k,340)*y(k,293)
         mat(k,473) = rxt(k,341)*y(k,293)
         mat(k,375) = rxt(k,307)*y(k,293)
         mat(k,2741) = rxt(k,180)*y(k,256)
         mat(k,1426) = rxt(k,185)*y(k,293)
         mat(k,1355) = rxt(k,186)*y(k,293)
         mat(k,1046) = rxt(k,268)*y(k,293)
         mat(k,3778) = (rxt(k,893)+rxt(k,898))*y(k,95) + (rxt(k,886)+rxt(k,892) &
                       +rxt(k,897))*y(k,96) + rxt(k,239)*y(k,293)
         mat(k,1127) = rxt(k,311)*y(k,293)
         mat(k,1123) = rxt(k,312)*y(k,293)
         mat(k,2727) = rxt(k,215)*y(k,293)
         mat(k,369) = rxt(k,193)*y(k,293)
         mat(k,913) = (rxt(k,893)+rxt(k,898))*y(k,87)
         mat(k,1070) = (rxt(k,886)+rxt(k,892)+rxt(k,897))*y(k,87) + rxt(k,242) &
                      *y(k,293)
         mat(k,1764) = .450_r8*rxt(k,387)*y(k,293)
         mat(k,105) = rxt(k,811)*y(k,293)
         mat(k,489) = rxt(k,368)*y(k,293)
         mat(k,337) = rxt(k,372)*y(k,293)
         mat(k,895) = rxt(k,776)*y(k,293)
         mat(k,1038) = rxt(k,780)*y(k,293)
         mat(k,3295) = rxt(k,180)*y(k,78) + .300_r8*rxt(k,313)*y(k,257) + rxt(k,187) &
                      *y(k,293)
         mat(k,601) = .300_r8*rxt(k,313)*y(k,256)
         mat(k,3756) = rxt(k,332)*y(k,29) + rxt(k,359)*y(k,31) + rxt(k,360)*y(k,32) &
                      + rxt(k,301)*y(k,43) + rxt(k,334)*y(k,46) + rxt(k,374)*y(k,49) &
                      + rxt(k,362)*y(k,50) + rxt(k,340)*y(k,51) + rxt(k,341)*y(k,52) &
                      + rxt(k,307)*y(k,54) + rxt(k,185)*y(k,79) + rxt(k,186)*y(k,81) &
                      + rxt(k,268)*y(k,83) + rxt(k,239)*y(k,87) + rxt(k,311)*y(k,90) &
                      + rxt(k,312)*y(k,92) + rxt(k,215)*y(k,93) + rxt(k,193)*y(k,94) &
                      + rxt(k,242)*y(k,96) + .450_r8*rxt(k,387)*y(k,126) + rxt(k,811) &
                      *y(k,143) + rxt(k,368)*y(k,169) + rxt(k,372)*y(k,170) &
                      + rxt(k,776)*y(k,215) + rxt(k,780)*y(k,217) + rxt(k,187) &
                      *y(k,256) + 2.000_r8*rxt(k,190)*y(k,293)
      end do
      end subroutine nlnmat17
      subroutine nlnmat_finit( avec_len, mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: dti(veclen)
      real(r8), intent(in) :: lmat(veclen,nzcnt)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
      do k = 1,avec_len
         mat(k, 1) = lmat(k, 1)
         mat(k, 2) = lmat(k, 2)
         mat(k, 3) = lmat(k, 3)
         mat(k, 4) = lmat(k, 4)
         mat(k, 5) = lmat(k, 5)
         mat(k, 6) = lmat(k, 6)
         mat(k, 7) = lmat(k, 7)
         mat(k, 8) = lmat(k, 8)
         mat(k, 9) = lmat(k, 9)
         mat(k, 10) = lmat(k, 10)
         mat(k, 11) = lmat(k, 11)
         mat(k, 12) = lmat(k, 12)
         mat(k, 13) = lmat(k, 13)
         mat(k, 14) = lmat(k, 14)
         mat(k, 15) = lmat(k, 15)
         mat(k, 16) = lmat(k, 16)
         mat(k, 17) = lmat(k, 17)
         mat(k, 18) = lmat(k, 18)
         mat(k, 19) = lmat(k, 19)
         mat(k, 20) = lmat(k, 20)
         mat(k, 21) = lmat(k, 21)
         mat(k, 22) = lmat(k, 22)
         mat(k, 23) = lmat(k, 23)
         mat(k, 24) = lmat(k, 24)
         mat(k, 25) = lmat(k, 25)
         mat(k, 26) = lmat(k, 26)
         mat(k, 27) = lmat(k, 27)
         mat(k, 28) = lmat(k, 28)
         mat(k, 29) = lmat(k, 29)
         mat(k, 30) = lmat(k, 30)
         mat(k, 31) = lmat(k, 31)
         mat(k, 32) = lmat(k, 32)
         mat(k, 33) = lmat(k, 33)
         mat(k, 34) = lmat(k, 34)
         mat(k, 40) = mat(k, 40) + lmat(k, 40)
         mat(k, 46) = mat(k, 46) + lmat(k, 46)
         mat(k, 52) = mat(k, 52) + lmat(k, 52)
         mat(k, 58) = mat(k, 58) + lmat(k, 58)
         mat(k, 64) = mat(k, 64) + lmat(k, 64)
         mat(k, 70) = mat(k, 70) + lmat(k, 70)
         mat(k, 76) = mat(k, 76) + lmat(k, 76)
         mat(k, 78) = mat(k, 78) + lmat(k, 78)
         mat(k, 84) = mat(k, 84) + lmat(k, 84)
         mat(k, 90) = mat(k, 90) + lmat(k, 90)
         mat(k, 96) = mat(k, 96) + lmat(k, 96)
         mat(k, 102) = mat(k, 102) + lmat(k, 102)
         mat(k, 103) = mat(k, 103) + lmat(k, 103)
         mat(k, 106) = mat(k, 106) + lmat(k, 106)
         mat(k, 109) = lmat(k, 109)
         mat(k, 110) = lmat(k, 110)
         mat(k, 111) = lmat(k, 111)
         mat(k, 112) = mat(k, 112) + lmat(k, 112)
         mat(k, 116) = lmat(k, 116)
         mat(k, 117) = lmat(k, 117)
         mat(k, 118) = lmat(k, 118)
         mat(k, 119) = lmat(k, 119)
         mat(k, 120) = lmat(k, 120)
         mat(k, 121) = lmat(k, 121)
         mat(k, 122) = mat(k, 122) + lmat(k, 122)
         mat(k, 123) = mat(k, 123) + lmat(k, 123)
         mat(k, 125) = lmat(k, 125)
         mat(k, 126) = lmat(k, 126)
         mat(k, 127) = lmat(k, 127)
         mat(k, 128) = lmat(k, 128)
         mat(k, 129) = lmat(k, 129)
         mat(k, 131) = mat(k, 131) + lmat(k, 131)
         mat(k, 137) = lmat(k, 137)
         mat(k, 138) = lmat(k, 138)
         mat(k, 139) = lmat(k, 139)
         mat(k, 140) = lmat(k, 140)
         mat(k, 141) = mat(k, 141) + lmat(k, 141)
         mat(k, 146) = mat(k, 146) + lmat(k, 146)
         mat(k, 150) = lmat(k, 150)
         mat(k, 151) = lmat(k, 151)
         mat(k, 152) = lmat(k, 152)
         mat(k, 153) = mat(k, 153) + lmat(k, 153)
         mat(k, 156) = mat(k, 156) + lmat(k, 156)
         mat(k, 157) = mat(k, 157) + lmat(k, 157)
         mat(k, 159) = mat(k, 159) + lmat(k, 159)
         mat(k, 161) = mat(k, 161) + lmat(k, 161)
         mat(k, 168) = mat(k, 168) + lmat(k, 168)
         mat(k, 173) = lmat(k, 173)
         mat(k, 174) = lmat(k, 174)
         mat(k, 175) = lmat(k, 175)
         mat(k, 176) = lmat(k, 176)
         mat(k, 179) = mat(k, 179) + lmat(k, 179)
         mat(k, 187) = mat(k, 187) + lmat(k, 187)
         mat(k, 192) = lmat(k, 192)
         mat(k, 193) = lmat(k, 193)
         mat(k, 194) = lmat(k, 194)
         mat(k, 195) = lmat(k, 195)
         mat(k, 196) = lmat(k, 196)
         mat(k, 197) = lmat(k, 197)
         mat(k, 198) = mat(k, 198) + lmat(k, 198)
         mat(k, 201) = lmat(k, 201)
         mat(k, 202) = lmat(k, 202)
         mat(k, 203) = lmat(k, 203)
         mat(k, 204) = lmat(k, 204)
         mat(k, 205) = lmat(k, 205)
         mat(k, 206) = lmat(k, 206)
         mat(k, 207) = lmat(k, 207)
         mat(k, 208) = lmat(k, 208)
         mat(k, 209) = lmat(k, 209)
         mat(k, 210) = lmat(k, 210)
         mat(k, 211) = lmat(k, 211)
         mat(k, 212) = lmat(k, 212)
         mat(k, 214) = mat(k, 214) + lmat(k, 214)
         mat(k, 215) = lmat(k, 215)
         mat(k, 216) = lmat(k, 216)
         mat(k, 218) = mat(k, 218) + lmat(k, 218)
         mat(k, 222) = mat(k, 222) + lmat(k, 222)
         mat(k, 223) = lmat(k, 223)
         mat(k, 225) = mat(k, 225) + lmat(k, 225)
         mat(k, 226) = mat(k, 226) + lmat(k, 226)
         mat(k, 227) = mat(k, 227) + lmat(k, 227)
         mat(k, 229) = mat(k, 229) + lmat(k, 229)
         mat(k, 230) = mat(k, 230) + lmat(k, 230)
         mat(k, 231) = mat(k, 231) + lmat(k, 231)
         mat(k, 233) = mat(k, 233) + lmat(k, 233)
         mat(k, 234) = lmat(k, 234)
         mat(k, 235) = lmat(k, 235)
         mat(k, 236) = lmat(k, 236)
         mat(k, 237) = lmat(k, 237)
         mat(k, 238) = mat(k, 238) + lmat(k, 238)
         mat(k, 244) = lmat(k, 244)
         mat(k, 245) = lmat(k, 245)
         mat(k, 246) = lmat(k, 246)
         mat(k, 247) = lmat(k, 247)
         mat(k, 248) = lmat(k, 248)
         mat(k, 249) = lmat(k, 249)
         mat(k, 250) = lmat(k, 250)
         mat(k, 251) = lmat(k, 251)
         mat(k, 252) = lmat(k, 252)
         mat(k, 253) = mat(k, 253) + lmat(k, 253)
         mat(k, 259) = mat(k, 259) + lmat(k, 259)
         mat(k, 265) = mat(k, 265) + lmat(k, 265)
         mat(k, 267) = lmat(k, 267)
         mat(k, 268) = lmat(k, 268)
         mat(k, 269) = mat(k, 269) + lmat(k, 269)
         mat(k, 270) = lmat(k, 270)
         mat(k, 271) = lmat(k, 271)
         mat(k, 272) = lmat(k, 272)
         mat(k, 273) = lmat(k, 273)
         mat(k, 274) = lmat(k, 274)
         mat(k, 275) = mat(k, 275) + lmat(k, 275)
         mat(k, 278) = mat(k, 278) + lmat(k, 278)
         mat(k, 279) = lmat(k, 279)
         mat(k, 280) = mat(k, 280) + lmat(k, 280)
         mat(k, 282) = lmat(k, 282)
         mat(k, 283) = lmat(k, 283)
         mat(k, 284) = mat(k, 284) + lmat(k, 284)
         mat(k, 285) = lmat(k, 285)
         mat(k, 286) = mat(k, 286) + lmat(k, 286)
         mat(k, 289) = lmat(k, 289)
         mat(k, 290) = mat(k, 290) + lmat(k, 290)
         mat(k, 291) = mat(k, 291) + lmat(k, 291)
         mat(k, 293) = mat(k, 293) + lmat(k, 293)
         mat(k, 294) = lmat(k, 294)
         mat(k, 295) = mat(k, 295) + lmat(k, 295)
         mat(k, 296) = mat(k, 296) + lmat(k, 296)
         mat(k, 297) = mat(k, 297) + lmat(k, 297)
         mat(k, 298) = lmat(k, 298)
         mat(k, 299) = lmat(k, 299)
         mat(k, 300) = mat(k, 300) + lmat(k, 300)
         mat(k, 301) = lmat(k, 301)
         mat(k, 304) = mat(k, 304) + lmat(k, 304)
         mat(k, 308) = mat(k, 308) + lmat(k, 308)
         mat(k, 316) = mat(k, 316) + lmat(k, 316)
         mat(k, 318) = mat(k, 318) + lmat(k, 318)
         mat(k, 319) = mat(k, 319) + lmat(k, 319)
         mat(k, 322) = mat(k, 322) + lmat(k, 322)
         mat(k, 323) = lmat(k, 323)
         mat(k, 325) = lmat(k, 325)
         mat(k, 326) = lmat(k, 326)
         mat(k, 327) = mat(k, 327) + lmat(k, 327)
         mat(k, 328) = lmat(k, 328)
         mat(k, 329) = lmat(k, 329)
         mat(k, 330) = lmat(k, 330)
         mat(k, 331) = lmat(k, 331)
         mat(k, 332) = mat(k, 332) + lmat(k, 332)
         mat(k, 334) = lmat(k, 334)
         mat(k, 335) = lmat(k, 335)
         mat(k, 336) = mat(k, 336) + lmat(k, 336)
         mat(k, 338) = mat(k, 338) + lmat(k, 338)
         mat(k, 340) = lmat(k, 340)
         mat(k, 341) = lmat(k, 341)
         mat(k, 342) = mat(k, 342) + lmat(k, 342)
         mat(k, 344) = mat(k, 344) + lmat(k, 344)
         mat(k, 347) = lmat(k, 347)
         mat(k, 348) = mat(k, 348) + lmat(k, 348)
         mat(k, 350) = mat(k, 350) + lmat(k, 350)
         mat(k, 352) = lmat(k, 352)
         mat(k, 353) = lmat(k, 353)
         mat(k, 354) = lmat(k, 354)
         mat(k, 355) = mat(k, 355) + lmat(k, 355)
         mat(k, 358) = mat(k, 358) + lmat(k, 358)
         mat(k, 364) = mat(k, 364) + lmat(k, 364)
         mat(k, 365) = lmat(k, 365)
         mat(k, 366) = lmat(k, 366)
         mat(k, 367) = mat(k, 367) + lmat(k, 367)
         mat(k, 368) = mat(k, 368) + lmat(k, 368)
         mat(k, 370) = mat(k, 370) + lmat(k, 370)
         mat(k, 371) = lmat(k, 371)
         mat(k, 372) = mat(k, 372) + lmat(k, 372)
         mat(k, 374) = mat(k, 374) + lmat(k, 374)
         mat(k, 377) = mat(k, 377) + lmat(k, 377)
         mat(k, 383) = lmat(k, 383)
         mat(k, 384) = lmat(k, 384)
         mat(k, 385) = lmat(k, 385)
         mat(k, 386) = mat(k, 386) + lmat(k, 386)
         mat(k, 388) = lmat(k, 388)
         mat(k, 389) = lmat(k, 389)
         mat(k, 390) = mat(k, 390) + lmat(k, 390)
         mat(k, 391) = mat(k, 391) + lmat(k, 391)
         mat(k, 392) = lmat(k, 392)
         mat(k, 396) = lmat(k, 396)
         mat(k, 398) = mat(k, 398) + lmat(k, 398)
         mat(k, 399) = lmat(k, 399)
         mat(k, 400) = mat(k, 400) + lmat(k, 400)
         mat(k, 402) = lmat(k, 402)
         mat(k, 403) = lmat(k, 403)
         mat(k, 405) = mat(k, 405) + lmat(k, 405)
         mat(k, 409) = mat(k, 409) + lmat(k, 409)
         mat(k, 411) = lmat(k, 411)
         mat(k, 414) = lmat(k, 414)
         mat(k, 415) = lmat(k, 415)
         mat(k, 417) = mat(k, 417) + lmat(k, 417)
         mat(k, 419) = mat(k, 419) + lmat(k, 419)
         mat(k, 422) = mat(k, 422) + lmat(k, 422)
         mat(k, 423) = mat(k, 423) + lmat(k, 423)
         mat(k, 424) = lmat(k, 424)
         mat(k, 425) = lmat(k, 425)
         mat(k, 426) = mat(k, 426) + lmat(k, 426)
         mat(k, 429) = mat(k, 429) + lmat(k, 429)
         mat(k, 430) = mat(k, 430) + lmat(k, 430)
         mat(k, 431) = lmat(k, 431)
         mat(k, 432) = lmat(k, 432)
         mat(k, 435) = mat(k, 435) + lmat(k, 435)
         mat(k, 443) = mat(k, 443) + lmat(k, 443)
         mat(k, 450) = mat(k, 450) + lmat(k, 450)
         mat(k, 452) = lmat(k, 452)
         mat(k, 453) = lmat(k, 453)
         mat(k, 455) = mat(k, 455) + lmat(k, 455)
         mat(k, 456) = mat(k, 456) + lmat(k, 456)
         mat(k, 459) = lmat(k, 459)
         mat(k, 462) = mat(k, 462) + lmat(k, 462)
         mat(k, 468) = mat(k, 468) + lmat(k, 468)
         mat(k, 471) = lmat(k, 471)
         mat(k, 472) = mat(k, 472) + lmat(k, 472)
         mat(k, 474) = mat(k, 474) + lmat(k, 474)
         mat(k, 477) = lmat(k, 477)
         mat(k, 478) = lmat(k, 478)
         mat(k, 479) = lmat(k, 479)
         mat(k, 480) = mat(k, 480) + lmat(k, 480)
         mat(k, 482) = mat(k, 482) + lmat(k, 482)
         mat(k, 484) = lmat(k, 484)
         mat(k, 486) = lmat(k, 486)
         mat(k, 487) = lmat(k, 487)
         mat(k, 488) = mat(k, 488) + lmat(k, 488)
         mat(k, 490) = mat(k, 490) + lmat(k, 490)
         mat(k, 491) = lmat(k, 491)
         mat(k, 492) = lmat(k, 492)
         mat(k, 493) = lmat(k, 493)
         mat(k, 494) = mat(k, 494) + lmat(k, 494)
         mat(k, 496) = lmat(k, 496)
         mat(k, 497) = mat(k, 497) + lmat(k, 497)
         mat(k, 498) = mat(k, 498) + lmat(k, 498)
         mat(k, 506) = mat(k, 506) + lmat(k, 506)
         mat(k, 509) = lmat(k, 509)
         mat(k, 512) = mat(k, 512) + lmat(k, 512)
         mat(k, 514) = mat(k, 514) + lmat(k, 514)
         mat(k, 516) = lmat(k, 516)
         mat(k, 520) = mat(k, 520) + lmat(k, 520)
         mat(k, 522) = mat(k, 522) + lmat(k, 522)
         mat(k, 523) = mat(k, 523) + lmat(k, 523)
         mat(k, 525) = mat(k, 525) + lmat(k, 525)
         mat(k, 526) = mat(k, 526) + lmat(k, 526)
         mat(k, 527) = mat(k, 527) + lmat(k, 527)
         mat(k, 528) = lmat(k, 528)
         mat(k, 529) = lmat(k, 529)
         mat(k, 530) = mat(k, 530) + lmat(k, 530)
         mat(k, 534) = mat(k, 534) + lmat(k, 534)
         mat(k, 542) = mat(k, 542) + lmat(k, 542)
         mat(k, 544) = lmat(k, 544)
         mat(k, 546) = lmat(k, 546)
         mat(k, 547) = mat(k, 547) + lmat(k, 547)
         mat(k, 548) = mat(k, 548) + lmat(k, 548)
         mat(k, 550) = mat(k, 550) + lmat(k, 550)
         mat(k, 551) = mat(k, 551) + lmat(k, 551)
         mat(k, 552) = mat(k, 552) + lmat(k, 552)
         mat(k, 553) = mat(k, 553) + lmat(k, 553)
         mat(k, 554) = mat(k, 554) + lmat(k, 554)
         mat(k, 558) = lmat(k, 558)
         mat(k, 559) = mat(k, 559) + lmat(k, 559)
         mat(k, 561) = mat(k, 561) + lmat(k, 561)
         mat(k, 562) = mat(k, 562) + lmat(k, 562)
         mat(k, 563) = mat(k, 563) + lmat(k, 563)
         mat(k, 564) = mat(k, 564) + lmat(k, 564)
         mat(k, 565) = mat(k, 565) + lmat(k, 565)
         mat(k, 566) = mat(k, 566) + lmat(k, 566)
         mat(k, 567) = mat(k, 567) + lmat(k, 567)
         mat(k, 568) = mat(k, 568) + lmat(k, 568)
         mat(k, 569) = lmat(k, 569)
         mat(k, 570) = lmat(k, 570)
         mat(k, 571) = lmat(k, 571)
         mat(k, 572) = lmat(k, 572)
         mat(k, 573) = mat(k, 573) + lmat(k, 573)
         mat(k, 576) = lmat(k, 576)
         mat(k, 577) = lmat(k, 577)
         mat(k, 578) = lmat(k, 578)
         mat(k, 579) = lmat(k, 579)
         mat(k, 580) = mat(k, 580) + lmat(k, 580)
         mat(k, 582) = mat(k, 582) + lmat(k, 582)
         mat(k, 584) = lmat(k, 584)
         mat(k, 585) = lmat(k, 585)
         mat(k, 586) = lmat(k, 586)
         mat(k, 587) = lmat(k, 587)
         mat(k, 588) = mat(k, 588) + lmat(k, 588)
         mat(k, 589) = mat(k, 589) + lmat(k, 589)
         mat(k, 590) = mat(k, 590) + lmat(k, 590)
         mat(k, 591) = lmat(k, 591)
         mat(k, 592) = lmat(k, 592)
         mat(k, 593) = mat(k, 593) + lmat(k, 593)
         mat(k, 597) = mat(k, 597) + lmat(k, 597)
         mat(k, 598) = lmat(k, 598)
         mat(k, 604) = mat(k, 604) + lmat(k, 604)
         mat(k, 610) = lmat(k, 610)
         mat(k, 611) = lmat(k, 611)
         mat(k, 612) = lmat(k, 612)
         mat(k, 613) = mat(k, 613) + lmat(k, 613)
         mat(k, 618) = lmat(k, 618)
         mat(k, 620) = lmat(k, 620)
         mat(k, 621) = lmat(k, 621)
         mat(k, 622) = mat(k, 622) + lmat(k, 622)
         mat(k, 623) = mat(k, 623) + lmat(k, 623)
         mat(k, 626) = lmat(k, 626)
         mat(k, 627) = lmat(k, 627)
         mat(k, 629) = mat(k, 629) + lmat(k, 629)
         mat(k, 630) = lmat(k, 630)
         mat(k, 631) = lmat(k, 631)
         mat(k, 633) = lmat(k, 633)
         mat(k, 634) = mat(k, 634) + lmat(k, 634)
         mat(k, 637) = mat(k, 637) + lmat(k, 637)
         mat(k, 638) = mat(k, 638) + lmat(k, 638)
         mat(k, 640) = lmat(k, 640)
         mat(k, 641) = mat(k, 641) + lmat(k, 641)
         mat(k, 642) = mat(k, 642) + lmat(k, 642)
         mat(k, 644) = lmat(k, 644)
         mat(k, 645) = mat(k, 645) + lmat(k, 645)
         mat(k, 649) = lmat(k, 649)
         mat(k, 650) = lmat(k, 650)
         mat(k, 652) = lmat(k, 652)
         mat(k, 653) = lmat(k, 653)
         mat(k, 654) = mat(k, 654) + lmat(k, 654)
         mat(k, 656) = mat(k, 656) + lmat(k, 656)
         mat(k, 663) = mat(k, 663) + lmat(k, 663)
         mat(k, 664) = lmat(k, 664)
         mat(k, 665) = lmat(k, 665)
         mat(k, 667) = mat(k, 667) + lmat(k, 667)
         mat(k, 668) = mat(k, 668) + lmat(k, 668)
         mat(k, 669) = lmat(k, 669)
         mat(k, 670) = lmat(k, 670)
         mat(k, 671) = mat(k, 671) + lmat(k, 671)
         mat(k, 673) = lmat(k, 673)
         mat(k, 674) = lmat(k, 674)
         mat(k, 675) = lmat(k, 675)
         mat(k, 676) = lmat(k, 676)
         mat(k, 677) = lmat(k, 677)
         mat(k, 678) = mat(k, 678) + lmat(k, 678)
         mat(k, 680) = mat(k, 680) + lmat(k, 680)
         mat(k, 688) = mat(k, 688) + lmat(k, 688)
         mat(k, 696) = mat(k, 696) + lmat(k, 696)
         mat(k, 710) = mat(k, 710) + lmat(k, 710)
         mat(k, 721) = mat(k, 721) + lmat(k, 721)
         mat(k, 723) = mat(k, 723) + lmat(k, 723)
         mat(k, 724) = mat(k, 724) + lmat(k, 724)
         mat(k, 725) = mat(k, 725) + lmat(k, 725)
         mat(k, 726) = mat(k, 726) + lmat(k, 726)
         mat(k, 727) = lmat(k, 727)
         mat(k, 728) = lmat(k, 728)
         mat(k, 729) = lmat(k, 729)
         mat(k, 730) = lmat(k, 730)
         mat(k, 731) = mat(k, 731) + lmat(k, 731)
         mat(k, 736) = lmat(k, 736)
         mat(k, 738) = lmat(k, 738)
         mat(k, 740) = lmat(k, 740)
         mat(k, 741) = mat(k, 741) + lmat(k, 741)
         mat(k, 744) = mat(k, 744) + lmat(k, 744)
         mat(k, 751) = mat(k, 751) + lmat(k, 751)
         mat(k, 762) = mat(k, 762) + lmat(k, 762)
         mat(k, 778) = mat(k, 778) + lmat(k, 778)
         mat(k, 789) = mat(k, 789) + lmat(k, 789)
         mat(k, 797) = mat(k, 797) + lmat(k, 797)
         mat(k, 802) = mat(k, 802) + lmat(k, 802)
         mat(k, 807) = mat(k, 807) + lmat(k, 807)
         mat(k, 809) = mat(k, 809) + lmat(k, 809)
         mat(k, 810) = mat(k, 810) + lmat(k, 810)
         mat(k, 811) = mat(k, 811) + lmat(k, 811)
         mat(k, 812) = mat(k, 812) + lmat(k, 812)
         mat(k, 822) = mat(k, 822) + lmat(k, 822)
         mat(k, 834) = mat(k, 834) + lmat(k, 834)
         mat(k, 843) = mat(k, 843) + lmat(k, 843)
         mat(k, 859) = mat(k, 859) + lmat(k, 859)
         mat(k, 871) = mat(k, 871) + lmat(k, 871)
         mat(k, 872) = mat(k, 872) + lmat(k, 872)
         mat(k, 873) = lmat(k, 873)
         mat(k, 874) = lmat(k, 874)
         mat(k, 876) = mat(k, 876) + lmat(k, 876)
         mat(k, 877) = lmat(k, 877)
         mat(k, 878) = lmat(k, 878)
         mat(k, 879) = lmat(k, 879)
         mat(k, 880) = lmat(k, 880)
         mat(k, 881) = lmat(k, 881)
         mat(k, 882) = lmat(k, 882)
         mat(k, 883) = lmat(k, 883)
         mat(k, 884) = mat(k, 884) + lmat(k, 884)
         mat(k, 885) = lmat(k, 885)
         mat(k, 886) = lmat(k, 886)
         mat(k, 888) = mat(k, 888) + lmat(k, 888)
         mat(k, 889) = lmat(k, 889)
         mat(k, 890) = lmat(k, 890)
         mat(k, 892) = lmat(k, 892)
         mat(k, 893) = lmat(k, 893)
         mat(k, 894) = mat(k, 894) + lmat(k, 894)
         mat(k, 896) = mat(k, 896) + lmat(k, 896)
         mat(k, 897) = mat(k, 897) + lmat(k, 897)
         mat(k, 902) = lmat(k, 902)
         mat(k, 906) = mat(k, 906) + lmat(k, 906)
         mat(k, 907) = lmat(k, 907)
         mat(k, 909) = mat(k, 909) + lmat(k, 909)
         mat(k, 917) = mat(k, 917) + lmat(k, 917)
         mat(k, 926) = mat(k, 926) + lmat(k, 926)
         mat(k, 941) = mat(k, 941) + lmat(k, 941)
         mat(k, 961) = mat(k, 961) + lmat(k, 961)
         mat(k, 975) = mat(k, 975) + lmat(k, 975)
         mat(k, 985) = mat(k, 985) + lmat(k, 985)
         mat(k, 988) = lmat(k, 988)
         mat(k, 991) = mat(k, 991) + lmat(k, 991)
         mat(k, 995) = mat(k, 995) + lmat(k, 995)
         mat(k, 999) = mat(k, 999) + lmat(k, 999)
         mat(k,1000) = mat(k,1000) + lmat(k,1000)
         mat(k,1006) = mat(k,1006) + lmat(k,1006)
         mat(k,1010) = mat(k,1010) + lmat(k,1010)
         mat(k,1012) = mat(k,1012) + lmat(k,1012)
         mat(k,1017) = mat(k,1017) + lmat(k,1017)
         mat(k,1021) = mat(k,1021) + lmat(k,1021)
         mat(k,1022) = lmat(k,1022)
         mat(k,1023) = lmat(k,1023)
         mat(k,1025) = lmat(k,1025)
         mat(k,1028) = lmat(k,1028)
         mat(k,1029) = lmat(k,1029)
         mat(k,1030) = mat(k,1030) + lmat(k,1030)
         mat(k,1032) = mat(k,1032) + lmat(k,1032)
         mat(k,1034) = lmat(k,1034)
         mat(k,1035) = lmat(k,1035)
         mat(k,1036) = lmat(k,1036)
         mat(k,1037) = lmat(k,1037)
         mat(k,1039) = mat(k,1039) + lmat(k,1039)
         mat(k,1040) = mat(k,1040) + lmat(k,1040)
         mat(k,1041) = mat(k,1041) + lmat(k,1041)
         mat(k,1048) = mat(k,1048) + lmat(k,1048)
         mat(k,1053) = lmat(k,1053)
         mat(k,1055) = lmat(k,1055)
         mat(k,1060) = lmat(k,1060)
         mat(k,1061) = lmat(k,1061)
         mat(k,1062) = mat(k,1062) + lmat(k,1062)
         mat(k,1064) = mat(k,1064) + lmat(k,1064)
         mat(k,1067) = mat(k,1067) + lmat(k,1067)
         mat(k,1069) = mat(k,1069) + lmat(k,1069)
         mat(k,1071) = mat(k,1071) + lmat(k,1071)
         mat(k,1077) = lmat(k,1077)
         mat(k,1079) = mat(k,1079) + lmat(k,1079)
         mat(k,1083) = mat(k,1083) + lmat(k,1083)
         mat(k,1084) = lmat(k,1084)
         mat(k,1090) = lmat(k,1090)
         mat(k,1091) = mat(k,1091) + lmat(k,1091)
         mat(k,1093) = mat(k,1093) + lmat(k,1093)
         mat(k,1102) = mat(k,1102) + lmat(k,1102)
         mat(k,1118) = mat(k,1118) + lmat(k,1118)
         mat(k,1121) = mat(k,1121) + lmat(k,1121)
         mat(k,1122) = mat(k,1122) + lmat(k,1122)
         mat(k,1124) = mat(k,1124) + lmat(k,1124)
         mat(k,1132) = mat(k,1132) + lmat(k,1132)
         mat(k,1144) = mat(k,1144) + lmat(k,1144)
         mat(k,1154) = mat(k,1154) + lmat(k,1154)
         mat(k,1155) = mat(k,1155) + lmat(k,1155)
         mat(k,1156) = lmat(k,1156)
         mat(k,1157) = lmat(k,1157)
         mat(k,1158) = mat(k,1158) + lmat(k,1158)
         mat(k,1161) = mat(k,1161) + lmat(k,1161)
         mat(k,1162) = lmat(k,1162)
         mat(k,1164) = lmat(k,1164)
         mat(k,1167) = mat(k,1167) + lmat(k,1167)
         mat(k,1168) = lmat(k,1168)
         mat(k,1169) = lmat(k,1169)
         mat(k,1173) = lmat(k,1173)
         mat(k,1175) = lmat(k,1175)
         mat(k,1176) = mat(k,1176) + lmat(k,1176)
         mat(k,1177) = mat(k,1177) + lmat(k,1177)
         mat(k,1178) = mat(k,1178) + lmat(k,1178)
         mat(k,1180) = mat(k,1180) + lmat(k,1180)
         mat(k,1182) = mat(k,1182) + lmat(k,1182)
         mat(k,1193) = mat(k,1193) + lmat(k,1193)
         mat(k,1197) = mat(k,1197) + lmat(k,1197)
         mat(k,1212) = mat(k,1212) + lmat(k,1212)
         mat(k,1213) = mat(k,1213) + lmat(k,1213)
         mat(k,1214) = mat(k,1214) + lmat(k,1214)
         mat(k,1215) = mat(k,1215) + lmat(k,1215)
         mat(k,1216) = mat(k,1216) + lmat(k,1216)
         mat(k,1218) = lmat(k,1218)
         mat(k,1221) = mat(k,1221) + lmat(k,1221)
         mat(k,1224) = mat(k,1224) + lmat(k,1224)
         mat(k,1236) = mat(k,1236) + lmat(k,1236)
         mat(k,1243) = mat(k,1243) + lmat(k,1243)
         mat(k,1255) = mat(k,1255) + lmat(k,1255)
         mat(k,1257) = mat(k,1257) + lmat(k,1257)
         mat(k,1269) = mat(k,1269) + lmat(k,1269)
         mat(k,1270) = mat(k,1270) + lmat(k,1270)
         mat(k,1271) = lmat(k,1271)
         mat(k,1272) = lmat(k,1272)
         mat(k,1273) = mat(k,1273) + lmat(k,1273)
         mat(k,1274) = mat(k,1274) + lmat(k,1274)
         mat(k,1285) = mat(k,1285) + lmat(k,1285)
         mat(k,1305) = mat(k,1305) + lmat(k,1305)
         mat(k,1306) = lmat(k,1306)
         mat(k,1310) = lmat(k,1310)
         mat(k,1311) = lmat(k,1311)
         mat(k,1315) = mat(k,1315) + lmat(k,1315)
         mat(k,1329) = mat(k,1329) + lmat(k,1329)
         mat(k,1330) = mat(k,1330) + lmat(k,1330)
         mat(k,1331) = mat(k,1331) + lmat(k,1331)
         mat(k,1332) = lmat(k,1332)
         mat(k,1333) = lmat(k,1333)
         mat(k,1334) = lmat(k,1334)
         mat(k,1335) = lmat(k,1335)
         mat(k,1336) = mat(k,1336) + lmat(k,1336)
         mat(k,1337) = lmat(k,1337)
         mat(k,1338) = lmat(k,1338)
         mat(k,1341) = lmat(k,1341)
         mat(k,1342) = mat(k,1342) + lmat(k,1342)
         mat(k,1343) = mat(k,1343) + lmat(k,1343)
         mat(k,1345) = lmat(k,1345)
         mat(k,1346) = lmat(k,1346)
         mat(k,1347) = mat(k,1347) + lmat(k,1347)
         mat(k,1349) = mat(k,1349) + lmat(k,1349)
         mat(k,1352) = mat(k,1352) + lmat(k,1352)
         mat(k,1356) = mat(k,1356) + lmat(k,1356)
         mat(k,1360) = mat(k,1360) + lmat(k,1360)
         mat(k,1361) = lmat(k,1361)
         mat(k,1363) = mat(k,1363) + lmat(k,1363)
         mat(k,1364) = mat(k,1364) + lmat(k,1364)
         mat(k,1365) = mat(k,1365) + lmat(k,1365)
         mat(k,1366) = lmat(k,1366)
         mat(k,1367) = mat(k,1367) + lmat(k,1367)
         mat(k,1370) = mat(k,1370) + lmat(k,1370)
         mat(k,1383) = mat(k,1383) + lmat(k,1383)
         mat(k,1384) = mat(k,1384) + lmat(k,1384)
         mat(k,1385) = mat(k,1385) + lmat(k,1385)
         mat(k,1395) = mat(k,1395) + lmat(k,1395)
         mat(k,1396) = mat(k,1396) + lmat(k,1396)
         mat(k,1397) = mat(k,1397) + lmat(k,1397)
         mat(k,1398) = lmat(k,1398)
         mat(k,1399) = lmat(k,1399)
         mat(k,1400) = mat(k,1400) + lmat(k,1400)
         mat(k,1404) = mat(k,1404) + lmat(k,1404)
         mat(k,1416) = mat(k,1416) + lmat(k,1416)
         mat(k,1439) = mat(k,1439) + lmat(k,1439)
         mat(k,1449) = mat(k,1449) + lmat(k,1449)
         mat(k,1452) = lmat(k,1452)
         mat(k,1455) = lmat(k,1455)
         mat(k,1459) = mat(k,1459) + lmat(k,1459)
         mat(k,1463) = mat(k,1463) + lmat(k,1463)
         mat(k,1464) = mat(k,1464) + lmat(k,1464)
         mat(k,1465) = lmat(k,1465)
         mat(k,1466) = mat(k,1466) + lmat(k,1466)
         mat(k,1469) = mat(k,1469) + lmat(k,1469)
         mat(k,1470) = lmat(k,1470)
         mat(k,1471) = mat(k,1471) + lmat(k,1471)
         mat(k,1472) = mat(k,1472) + lmat(k,1472)
         mat(k,1480) = mat(k,1480) + lmat(k,1480)
         mat(k,1481) = mat(k,1481) + lmat(k,1481)
         mat(k,1483) = mat(k,1483) + lmat(k,1483)
         mat(k,1485) = mat(k,1485) + lmat(k,1485)
         mat(k,1493) = mat(k,1493) + lmat(k,1493)
         mat(k,1497) = mat(k,1497) + lmat(k,1497)
         mat(k,1511) = lmat(k,1511)
         mat(k,1512) = mat(k,1512) + lmat(k,1512)
         mat(k,1513) = mat(k,1513) + lmat(k,1513)
         mat(k,1520) = lmat(k,1520)
         mat(k,1528) = lmat(k,1528)
         mat(k,1529) = mat(k,1529) + lmat(k,1529)
         mat(k,1531) = lmat(k,1531)
         mat(k,1535) = lmat(k,1535)
         mat(k,1538) = lmat(k,1538)
         mat(k,1540) = mat(k,1540) + lmat(k,1540)
         mat(k,1544) = lmat(k,1544)
         mat(k,1550) = mat(k,1550) + lmat(k,1550)
         mat(k,1565) = lmat(k,1565)
         mat(k,1571) = mat(k,1571) + lmat(k,1571)
         mat(k,1590) = mat(k,1590) + lmat(k,1590)
         mat(k,1592) = lmat(k,1592)
         mat(k,1595) = lmat(k,1595)
         mat(k,1596) = lmat(k,1596)
         mat(k,1603) = mat(k,1603) + lmat(k,1603)
         mat(k,1605) = lmat(k,1605)
         mat(k,1606) = lmat(k,1606)
         mat(k,1608) = lmat(k,1608)
         mat(k,1609) = lmat(k,1609)
         mat(k,1611) = mat(k,1611) + lmat(k,1611)
         mat(k,1613) = lmat(k,1613)
         mat(k,1614) = mat(k,1614) + lmat(k,1614)
         mat(k,1615) = lmat(k,1615)
         mat(k,1617) = mat(k,1617) + lmat(k,1617)
         mat(k,1618) = mat(k,1618) + lmat(k,1618)
         mat(k,1619) = mat(k,1619) + lmat(k,1619)
         mat(k,1620) = mat(k,1620) + lmat(k,1620)
         mat(k,1621) = lmat(k,1621)
         mat(k,1624) = mat(k,1624) + lmat(k,1624)
         mat(k,1625) = lmat(k,1625)
         mat(k,1626) = mat(k,1626) + lmat(k,1626)
         mat(k,1628) = lmat(k,1628)
         mat(k,1631) = lmat(k,1631)
         mat(k,1633) = lmat(k,1633)
         mat(k,1635) = mat(k,1635) + lmat(k,1635)
         mat(k,1637) = lmat(k,1637)
         mat(k,1642) = mat(k,1642) + lmat(k,1642)
         mat(k,1643) = mat(k,1643) + lmat(k,1643)
         mat(k,1644) = lmat(k,1644)
         mat(k,1645) = mat(k,1645) + lmat(k,1645)
         mat(k,1646) = mat(k,1646) + lmat(k,1646)
         mat(k,1651) = lmat(k,1651)
         mat(k,1653) = lmat(k,1653)
         mat(k,1654) = lmat(k,1654)
         mat(k,1655) = lmat(k,1655)
         mat(k,1656) = lmat(k,1656)
         mat(k,1664) = mat(k,1664) + lmat(k,1664)
         mat(k,1667) = mat(k,1667) + lmat(k,1667)
         mat(k,1678) = mat(k,1678) + lmat(k,1678)
         mat(k,1682) = mat(k,1682) + lmat(k,1682)
         mat(k,1685) = mat(k,1685) + lmat(k,1685)
         mat(k,1696) = lmat(k,1696)
         mat(k,1697) = mat(k,1697) + lmat(k,1697)
         mat(k,1698) = mat(k,1698) + lmat(k,1698)
         mat(k,1700) = mat(k,1700) + lmat(k,1700)
         mat(k,1702) = mat(k,1702) + lmat(k,1702)
         mat(k,1703) = lmat(k,1703)
         mat(k,1706) = mat(k,1706) + lmat(k,1706)
         mat(k,1709) = mat(k,1709) + lmat(k,1709)
         mat(k,1710) = lmat(k,1710)
         mat(k,1711) = lmat(k,1711)
         mat(k,1729) = mat(k,1729) + lmat(k,1729)
         mat(k,1730) = mat(k,1730) + lmat(k,1730)
         mat(k,1741) = mat(k,1741) + lmat(k,1741)
         mat(k,1744) = mat(k,1744) + lmat(k,1744)
         mat(k,1747) = mat(k,1747) + lmat(k,1747)
         mat(k,1748) = mat(k,1748) + lmat(k,1748)
         mat(k,1751) = mat(k,1751) + lmat(k,1751)
         mat(k,1754) = mat(k,1754) + lmat(k,1754)
         mat(k,1759) = mat(k,1759) + lmat(k,1759)
         mat(k,1760) = mat(k,1760) + lmat(k,1760)
         mat(k,1761) = lmat(k,1761)
         mat(k,1765) = lmat(k,1765)
         mat(k,1766) = lmat(k,1766)
         mat(k,1767) = lmat(k,1767)
         mat(k,1768) = lmat(k,1768)
         mat(k,1777) = mat(k,1777) + lmat(k,1777)
         mat(k,1780) = mat(k,1780) + lmat(k,1780)
         mat(k,1790) = mat(k,1790) + lmat(k,1790)
         mat(k,1794) = mat(k,1794) + lmat(k,1794)
         mat(k,1797) = lmat(k,1797)
         mat(k,1799) = lmat(k,1799)
         mat(k,1801) = mat(k,1801) + lmat(k,1801)
         mat(k,1802) = lmat(k,1802)
         mat(k,1803) = lmat(k,1803)
         mat(k,1806) = mat(k,1806) + lmat(k,1806)
         mat(k,1807) = lmat(k,1807)
         mat(k,1808) = lmat(k,1808)
         mat(k,1810) = lmat(k,1810)
         mat(k,1811) = lmat(k,1811)
         mat(k,1829) = mat(k,1829) + lmat(k,1829)
         mat(k,1831) = mat(k,1831) + lmat(k,1831)
         mat(k,1839) = mat(k,1839) + lmat(k,1839)
         mat(k,1842) = mat(k,1842) + lmat(k,1842)
         mat(k,1844) = mat(k,1844) + lmat(k,1844)
         mat(k,1845) = mat(k,1845) + lmat(k,1845)
         mat(k,1846) = mat(k,1846) + lmat(k,1846)
         mat(k,1850) = lmat(k,1850)
         mat(k,1854) = lmat(k,1854)
         mat(k,1859) = mat(k,1859) + lmat(k,1859)
         mat(k,1863) = mat(k,1863) + lmat(k,1863)
         mat(k,1864) = mat(k,1864) + lmat(k,1864)
         mat(k,1872) = lmat(k,1872)
         mat(k,1891) = lmat(k,1891)
         mat(k,1895) = lmat(k,1895)
         mat(k,1896) = mat(k,1896) + lmat(k,1896)
         mat(k,1906) = mat(k,1906) + lmat(k,1906)
         mat(k,1907) = lmat(k,1907)
         mat(k,1910) = mat(k,1910) + lmat(k,1910)
         mat(k,1916) = lmat(k,1916)
         mat(k,1923) = mat(k,1923) + lmat(k,1923)
         mat(k,1927) = lmat(k,1927)
         mat(k,1930) = mat(k,1930) + lmat(k,1930)
         mat(k,1933) = lmat(k,1933)
         mat(k,1938) = mat(k,1938) + lmat(k,1938)
         mat(k,1941) = mat(k,1941) + lmat(k,1941)
         mat(k,1942) = mat(k,1942) + lmat(k,1942)
         mat(k,1953) = lmat(k,1953)
         mat(k,1957) = mat(k,1957) + lmat(k,1957)
         mat(k,1961) = lmat(k,1961)
         mat(k,1964) = mat(k,1964) + lmat(k,1964)
         mat(k,1967) = lmat(k,1967)
         mat(k,1972) = mat(k,1972) + lmat(k,1972)
         mat(k,1975) = mat(k,1975) + lmat(k,1975)
         mat(k,1976) = mat(k,1976) + lmat(k,1976)
         mat(k,1990) = lmat(k,1990)
         mat(k,1993) = mat(k,1993) + lmat(k,1993)
         mat(k,1995) = lmat(k,1995)
         mat(k,2000) = mat(k,2000) + lmat(k,2000)
         mat(k,2003) = mat(k,2003) + lmat(k,2003)
         mat(k,2034) = mat(k,2034) + lmat(k,2034)
         mat(k,2053) = mat(k,2053) + lmat(k,2053)
         mat(k,2072) = mat(k,2072) + lmat(k,2072)
         mat(k,2096) = mat(k,2096) + lmat(k,2096)
         mat(k,2119) = mat(k,2119) + lmat(k,2119)
         mat(k,2141) = mat(k,2141) + lmat(k,2141)
         mat(k,2142) = lmat(k,2142)
         mat(k,2149) = lmat(k,2149)
         mat(k,2156) = mat(k,2156) + lmat(k,2156)
         mat(k,2179) = mat(k,2179) + lmat(k,2179)
         mat(k,2181) = lmat(k,2181)
         mat(k,2188) = lmat(k,2188)
         mat(k,2191) = mat(k,2191) + lmat(k,2191)
         mat(k,2192) = lmat(k,2192)
         mat(k,2193) = mat(k,2193) + lmat(k,2193)
         mat(k,2194) = lmat(k,2194)
         mat(k,2200) = lmat(k,2200)
         mat(k,2214) = mat(k,2214) + lmat(k,2214)
         mat(k,2243) = mat(k,2243) + lmat(k,2243)
         mat(k,2271) = mat(k,2271) + lmat(k,2271)
         mat(k,2303) = mat(k,2303) + lmat(k,2303)
         mat(k,2332) = mat(k,2332) + lmat(k,2332)
         mat(k,2364) = mat(k,2364) + lmat(k,2364)
         mat(k,2392) = mat(k,2392) + lmat(k,2392)
         mat(k,2420) = mat(k,2420) + lmat(k,2420)
         mat(k,2445) = mat(k,2445) + lmat(k,2445)
         mat(k,2467) = mat(k,2467) + lmat(k,2467)
         mat(k,2489) = mat(k,2489) + lmat(k,2489)
         mat(k,2532) = mat(k,2532) + lmat(k,2532)
         mat(k,2579) = mat(k,2579) + lmat(k,2579)
         mat(k,2627) = mat(k,2627) + lmat(k,2627)
         mat(k,2699) = mat(k,2699) + lmat(k,2699)
         mat(k,2717) = mat(k,2717) + lmat(k,2717)
         mat(k,2723) = lmat(k,2723)
         mat(k,2724) = mat(k,2724) + lmat(k,2724)
         mat(k,2730) = mat(k,2730) + lmat(k,2730)
         mat(k,2734) = mat(k,2734) + lmat(k,2734)
         mat(k,2762) = mat(k,2762) + lmat(k,2762)
         mat(k,2885) = mat(k,2885) + lmat(k,2885)
         mat(k,2893) = mat(k,2893) + lmat(k,2893)
         mat(k,2987) = mat(k,2987) + lmat(k,2987)
         mat(k,2989) = mat(k,2989) + lmat(k,2989)
         mat(k,2994) = mat(k,2994) + lmat(k,2994)
         mat(k,3076) = mat(k,3076) + lmat(k,3076)
         mat(k,3078) = mat(k,3078) + lmat(k,3078)
         mat(k,3080) = mat(k,3080) + lmat(k,3080)
         mat(k,3086) = mat(k,3086) + lmat(k,3086)
         mat(k,3087) = mat(k,3087) + lmat(k,3087)
         mat(k,3093) = mat(k,3093) + lmat(k,3093)
         mat(k,3095) = mat(k,3095) + lmat(k,3095)
         mat(k,3096) = mat(k,3096) + lmat(k,3096)
         mat(k,3098) = mat(k,3098) + lmat(k,3098)
         mat(k,3099) = mat(k,3099) + lmat(k,3099)
         mat(k,3101) = mat(k,3101) + lmat(k,3101)
         mat(k,3102) = lmat(k,3102)
         mat(k,3105) = mat(k,3105) + lmat(k,3105)
         mat(k,3106) = lmat(k,3106)
         mat(k,3108) = lmat(k,3108)
         mat(k,3109) = lmat(k,3109)
         mat(k,3110) = lmat(k,3110)
         mat(k,3112) = mat(k,3112) + lmat(k,3112)
         mat(k,3115) = mat(k,3115) + lmat(k,3115)
         mat(k,3218) = mat(k,3218) + lmat(k,3218)
         mat(k,3285) = mat(k,3285) + lmat(k,3285)
         mat(k,3312) = mat(k,3312) + lmat(k,3312)
         mat(k,3315) = mat(k,3315) + lmat(k,3315)
         mat(k,3320) = mat(k,3320) + lmat(k,3320)
         mat(k,3326) = lmat(k,3326)
         mat(k,3327) = mat(k,3327) + lmat(k,3327)
         mat(k,3330) = mat(k,3330) + lmat(k,3330)
         mat(k,3337) = mat(k,3337) + lmat(k,3337)
         mat(k,3429) = mat(k,3429) + lmat(k,3429)
         mat(k,3453) = mat(k,3453) + lmat(k,3453)
         mat(k,3460) = mat(k,3460) + lmat(k,3460)
         mat(k,3500) = mat(k,3500) + lmat(k,3500)
         mat(k,3502) = mat(k,3502) + lmat(k,3502)
         mat(k,3510) = mat(k,3510) + lmat(k,3510)
         mat(k,3511) = mat(k,3511) + lmat(k,3511)
         mat(k,3512) = mat(k,3512) + lmat(k,3512)
         mat(k,3537) = lmat(k,3537)
         mat(k,3544) = lmat(k,3544)
         mat(k,3704) = mat(k,3704) + lmat(k,3704)
         mat(k,3746) = mat(k,3746) + lmat(k,3746)
         mat(k,3749) = mat(k,3749) + lmat(k,3749)
         mat(k,3752) = mat(k,3752) + lmat(k,3752)
         mat(k,3755) = mat(k,3755) + lmat(k,3755)
         mat(k,3756) = mat(k,3756) + lmat(k,3756)
         mat(k,3764) = mat(k,3764) + lmat(k,3764)
         mat(k,3775) = mat(k,3775) + lmat(k,3775)
         mat(k,3777) = mat(k,3777) + lmat(k,3777)
         mat(k,3785) = mat(k,3785) + lmat(k,3785)
         mat(k,3796) = mat(k,3796) + lmat(k,3796)
         mat(k,3800) = mat(k,3800) + lmat(k,3800)
         mat(k,3818) = mat(k,3818) + lmat(k,3818)
         mat(k,3819) = lmat(k,3819)
         mat(k,3827) = mat(k,3827) + lmat(k,3827)
         mat(k,3830) = lmat(k,3830)
         mat(k,3834) = mat(k,3834) + lmat(k,3834)
         mat(k,3836) = mat(k,3836) + lmat(k,3836)
         mat(k,3843) = lmat(k,3843)
         mat(k,3847) = lmat(k,3847)
         mat(k,3851) = mat(k,3851) + lmat(k,3851)
         mat(k,3856) = lmat(k,3856)
         mat(k,3858) = mat(k,3858) + lmat(k,3858)
         mat(k,3862) = mat(k,3862) + lmat(k,3862)
         mat(k, 183) = 0._r8
         mat(k, 184) = 0._r8
         mat(k, 288) = 0._r8
         mat(k, 359) = 0._r8
         mat(k, 363) = 0._r8
         mat(k, 382) = 0._r8
         mat(k, 436) = 0._r8
         mat(k, 441) = 0._r8
         mat(k, 449) = 0._r8
         mat(k, 606) = 0._r8
         mat(k, 609) = 0._r8
         mat(k, 614) = 0._r8
         mat(k, 616) = 0._r8
         mat(k, 617) = 0._r8
         mat(k, 619) = 0._r8
         mat(k, 635) = 0._r8
         mat(k, 636) = 0._r8
         mat(k, 639) = 0._r8
         mat(k, 646) = 0._r8
         mat(k, 648) = 0._r8
         mat(k, 651) = 0._r8
         mat(k, 732) = 0._r8
         mat(k, 734) = 0._r8
         mat(k, 735) = 0._r8
         mat(k, 737) = 0._r8
         mat(k, 739) = 0._r8
         mat(k, 745) = 0._r8
         mat(k, 750) = 0._r8
         mat(k, 761) = 0._r8
         mat(k, 763) = 0._r8
         mat(k, 764) = 0._r8
         mat(k, 766) = 0._r8
         mat(k, 771) = 0._r8
         mat(k, 777) = 0._r8
         mat(k, 779) = 0._r8
         mat(k, 780) = 0._r8
         mat(k, 782) = 0._r8
         mat(k, 784) = 0._r8
         mat(k, 788) = 0._r8
         mat(k, 824) = 0._r8
         mat(k, 829) = 0._r8
         mat(k, 830) = 0._r8
         mat(k, 833) = 0._r8
         mat(k, 836) = 0._r8
         mat(k, 837) = 0._r8
         mat(k, 864) = 0._r8
         mat(k, 865) = 0._r8
         mat(k, 912) = 0._r8
         mat(k, 915) = 0._r8
         mat(k, 918) = 0._r8
         mat(k, 920) = 0._r8
         mat(k, 929) = 0._r8
         mat(k, 945) = 0._r8
         mat(k, 966) = 0._r8
         mat(k, 968) = 0._r8
         mat(k, 983) = 0._r8
         mat(k, 984) = 0._r8
         mat(k,1049) = 0._r8
         mat(k,1051) = 0._r8
         mat(k,1052) = 0._r8
         mat(k,1054) = 0._r8
         mat(k,1058) = 0._r8
         mat(k,1059) = 0._r8
         mat(k,1109) = 0._r8
         mat(k,1112) = 0._r8
         mat(k,1131) = 0._r8
         mat(k,1133) = 0._r8
         mat(k,1136) = 0._r8
         mat(k,1141) = 0._r8
         mat(k,1146) = 0._r8
         mat(k,1147) = 0._r8
         mat(k,1148) = 0._r8
         mat(k,1153) = 0._r8
         mat(k,1166) = 0._r8
         mat(k,1201) = 0._r8
         mat(k,1202) = 0._r8
         mat(k,1208) = 0._r8
         mat(k,1210) = 0._r8
         mat(k,1222) = 0._r8
         mat(k,1235) = 0._r8
         mat(k,1251) = 0._r8
         mat(k,1254) = 0._r8
         mat(k,1260) = 0._r8
         mat(k,1263) = 0._r8
         mat(k,1264) = 0._r8
         mat(k,1288) = 0._r8
         mat(k,1289) = 0._r8
         mat(k,1290) = 0._r8
         mat(k,1291) = 0._r8
         mat(k,1293) = 0._r8
         mat(k,1294) = 0._r8
         mat(k,1304) = 0._r8
         mat(k,1320) = 0._r8
         mat(k,1417) = 0._r8
         mat(k,1419) = 0._r8
         mat(k,1421) = 0._r8
         mat(k,1432) = 0._r8
         mat(k,1435) = 0._r8
         mat(k,1438) = 0._r8
         mat(k,1440) = 0._r8
         mat(k,1441) = 0._r8
         mat(k,1442) = 0._r8
         mat(k,1443) = 0._r8
         mat(k,1444) = 0._r8
         mat(k,1445) = 0._r8
         mat(k,1446) = 0._r8
         mat(k,1447) = 0._r8
         mat(k,1451) = 0._r8
         mat(k,1453) = 0._r8
         mat(k,1456) = 0._r8
         mat(k,1457) = 0._r8
         mat(k,1460) = 0._r8
         mat(k,1461) = 0._r8
         mat(k,1462) = 0._r8
         mat(k,1479) = 0._r8
         mat(k,1482) = 0._r8
         mat(k,1484) = 0._r8
         mat(k,1487) = 0._r8
         mat(k,1488) = 0._r8
         mat(k,1491) = 0._r8
         mat(k,1499) = 0._r8
         mat(k,1509) = 0._r8
         mat(k,1518) = 0._r8
         mat(k,1525) = 0._r8
         mat(k,1527) = 0._r8
         mat(k,1530) = 0._r8
         mat(k,1532) = 0._r8
         mat(k,1533) = 0._r8
         mat(k,1534) = 0._r8
         mat(k,1537) = 0._r8
         mat(k,1548) = 0._r8
         mat(k,1551) = 0._r8
         mat(k,1553) = 0._r8
         mat(k,1554) = 0._r8
         mat(k,1558) = 0._r8
         mat(k,1569) = 0._r8
         mat(k,1572) = 0._r8
         mat(k,1574) = 0._r8
         mat(k,1575) = 0._r8
         mat(k,1579) = 0._r8
         mat(k,1587) = 0._r8
         mat(k,1588) = 0._r8
         mat(k,1589) = 0._r8
         mat(k,1591) = 0._r8
         mat(k,1593) = 0._r8
         mat(k,1594) = 0._r8
         mat(k,1599) = 0._r8
         mat(k,1600) = 0._r8
         mat(k,1601) = 0._r8
         mat(k,1602) = 0._r8
         mat(k,1604) = 0._r8
         mat(k,1607) = 0._r8
         mat(k,1622) = 0._r8
         mat(k,1623) = 0._r8
         mat(k,1638) = 0._r8
         mat(k,1639) = 0._r8
         mat(k,1640) = 0._r8
         mat(k,1641) = 0._r8
         mat(k,1649) = 0._r8
         mat(k,1658) = 0._r8
         mat(k,1659) = 0._r8
         mat(k,1662) = 0._r8
         mat(k,1663) = 0._r8
         mat(k,1665) = 0._r8
         mat(k,1666) = 0._r8
         mat(k,1669) = 0._r8
         mat(k,1670) = 0._r8
         mat(k,1671) = 0._r8
         mat(k,1674) = 0._r8
         mat(k,1676) = 0._r8
         mat(k,1686) = 0._r8
         mat(k,1688) = 0._r8
         mat(k,1691) = 0._r8
         mat(k,1692) = 0._r8
         mat(k,1694) = 0._r8
         mat(k,1699) = 0._r8
         mat(k,1701) = 0._r8
         mat(k,1704) = 0._r8
         mat(k,1705) = 0._r8
         mat(k,1707) = 0._r8
         mat(k,1708) = 0._r8
         mat(k,1714) = 0._r8
         mat(k,1715) = 0._r8
         mat(k,1716) = 0._r8
         mat(k,1717) = 0._r8
         mat(k,1719) = 0._r8
         mat(k,1720) = 0._r8
         mat(k,1721) = 0._r8
         mat(k,1722) = 0._r8
         mat(k,1723) = 0._r8
         mat(k,1724) = 0._r8
         mat(k,1725) = 0._r8
         mat(k,1726) = 0._r8
         mat(k,1727) = 0._r8
         mat(k,1731) = 0._r8
         mat(k,1732) = 0._r8
         mat(k,1734) = 0._r8
         mat(k,1735) = 0._r8
         mat(k,1737) = 0._r8
         mat(k,1738) = 0._r8
         mat(k,1749) = 0._r8
         mat(k,1750) = 0._r8
         mat(k,1753) = 0._r8
         mat(k,1755) = 0._r8
         mat(k,1756) = 0._r8
         mat(k,1758) = 0._r8
         mat(k,1762) = 0._r8
         mat(k,1770) = 0._r8
         mat(k,1771) = 0._r8
         mat(k,1772) = 0._r8
         mat(k,1775) = 0._r8
         mat(k,1776) = 0._r8
         mat(k,1778) = 0._r8
         mat(k,1781) = 0._r8
         mat(k,1782) = 0._r8
         mat(k,1783) = 0._r8
         mat(k,1784) = 0._r8
         mat(k,1788) = 0._r8
         mat(k,1795) = 0._r8
         mat(k,1804) = 0._r8
         mat(k,1805) = 0._r8
         mat(k,1814) = 0._r8
         mat(k,1815) = 0._r8
         mat(k,1816) = 0._r8
         mat(k,1817) = 0._r8
         mat(k,1818) = 0._r8
         mat(k,1819) = 0._r8
         mat(k,1820) = 0._r8
         mat(k,1821) = 0._r8
         mat(k,1822) = 0._r8
         mat(k,1823) = 0._r8
         mat(k,1824) = 0._r8
         mat(k,1825) = 0._r8
         mat(k,1826) = 0._r8
         mat(k,1827) = 0._r8
         mat(k,1828) = 0._r8
         mat(k,1830) = 0._r8
         mat(k,1833) = 0._r8
         mat(k,1835) = 0._r8
         mat(k,1836) = 0._r8
         mat(k,1843) = 0._r8
         mat(k,1848) = 0._r8
         mat(k,1856) = 0._r8
         mat(k,1858) = 0._r8
         mat(k,1860) = 0._r8
         mat(k,1861) = 0._r8
         mat(k,1865) = 0._r8
         mat(k,1866) = 0._r8
         mat(k,1867) = 0._r8
         mat(k,1869) = 0._r8
         mat(k,1873) = 0._r8
         mat(k,1875) = 0._r8
         mat(k,1880) = 0._r8
         mat(k,1881) = 0._r8
         mat(k,1882) = 0._r8
         mat(k,1883) = 0._r8
         mat(k,1884) = 0._r8
         mat(k,1886) = 0._r8
         mat(k,1888) = 0._r8
         mat(k,1892) = 0._r8
         mat(k,1894) = 0._r8
         mat(k,1897) = 0._r8
         mat(k,1898) = 0._r8
         mat(k,1899) = 0._r8
         mat(k,1900) = 0._r8
         mat(k,1901) = 0._r8
         mat(k,1902) = 0._r8
         mat(k,1903) = 0._r8
         mat(k,1904) = 0._r8
         mat(k,1905) = 0._r8
         mat(k,1908) = 0._r8
         mat(k,1909) = 0._r8
         mat(k,1911) = 0._r8
         mat(k,1915) = 0._r8
         mat(k,1917) = 0._r8
         mat(k,1920) = 0._r8
         mat(k,1922) = 0._r8
         mat(k,1924) = 0._r8
         mat(k,1926) = 0._r8
         mat(k,1928) = 0._r8
         mat(k,1932) = 0._r8
         mat(k,1934) = 0._r8
         mat(k,1935) = 0._r8
         mat(k,1937) = 0._r8
         mat(k,1939) = 0._r8
         mat(k,1940) = 0._r8
         mat(k,1943) = 0._r8
         mat(k,1944) = 0._r8
         mat(k,1945) = 0._r8
         mat(k,1949) = 0._r8
         mat(k,1951) = 0._r8
         mat(k,1954) = 0._r8
         mat(k,1955) = 0._r8
         mat(k,1956) = 0._r8
         mat(k,1959) = 0._r8
         mat(k,1960) = 0._r8
         mat(k,1966) = 0._r8
         mat(k,1968) = 0._r8
         mat(k,1969) = 0._r8
         mat(k,1971) = 0._r8
         mat(k,1973) = 0._r8
         mat(k,1974) = 0._r8
         mat(k,1977) = 0._r8
         mat(k,1978) = 0._r8
         mat(k,1979) = 0._r8
         mat(k,1987) = 0._r8
         mat(k,1989) = 0._r8
         mat(k,1996) = 0._r8
         mat(k,1997) = 0._r8
         mat(k,1999) = 0._r8
         mat(k,2001) = 0._r8
         mat(k,2002) = 0._r8
         mat(k,2005) = 0._r8
         mat(k,2006) = 0._r8
         mat(k,2007) = 0._r8
         mat(k,2010) = 0._r8
         mat(k,2011) = 0._r8
         mat(k,2012) = 0._r8
         mat(k,2013) = 0._r8
         mat(k,2014) = 0._r8
         mat(k,2015) = 0._r8
         mat(k,2016) = 0._r8
         mat(k,2017) = 0._r8
         mat(k,2020) = 0._r8
         mat(k,2021) = 0._r8
         mat(k,2023) = 0._r8
         mat(k,2024) = 0._r8
         mat(k,2025) = 0._r8
         mat(k,2026) = 0._r8
         mat(k,2028) = 0._r8
         mat(k,2029) = 0._r8
         mat(k,2035) = 0._r8
         mat(k,2037) = 0._r8
         mat(k,2038) = 0._r8
         mat(k,2040) = 0._r8
         mat(k,2045) = 0._r8
         mat(k,2048) = 0._r8
         mat(k,2049) = 0._r8
         mat(k,2050) = 0._r8
         mat(k,2071) = 0._r8
         mat(k,2074) = 0._r8
         mat(k,2082) = 0._r8
         mat(k,2083) = 0._r8
         mat(k,2093) = 0._r8
         mat(k,2095) = 0._r8
         mat(k,2097) = 0._r8
         mat(k,2098) = 0._r8
         mat(k,2128) = 0._r8
         mat(k,2136) = 0._r8
         mat(k,2138) = 0._r8
         mat(k,2139) = 0._r8
         mat(k,2140) = 0._r8
         mat(k,2143) = 0._r8
         mat(k,2144) = 0._r8
         mat(k,2145) = 0._r8
         mat(k,2146) = 0._r8
         mat(k,2147) = 0._r8
         mat(k,2148) = 0._r8
         mat(k,2150) = 0._r8
         mat(k,2158) = 0._r8
         mat(k,2167) = 0._r8
         mat(k,2176) = 0._r8
         mat(k,2177) = 0._r8
         mat(k,2178) = 0._r8
         mat(k,2180) = 0._r8
         mat(k,2182) = 0._r8
         mat(k,2183) = 0._r8
         mat(k,2184) = 0._r8
         mat(k,2185) = 0._r8
         mat(k,2186) = 0._r8
         mat(k,2187) = 0._r8
         mat(k,2189) = 0._r8
         mat(k,2190) = 0._r8
         mat(k,2198) = 0._r8
         mat(k,2223) = 0._r8
         mat(k,2224) = 0._r8
         mat(k,2232) = 0._r8
         mat(k,2242) = 0._r8
         mat(k,2252) = 0._r8
         mat(k,2253) = 0._r8
         mat(k,2261) = 0._r8
         mat(k,2263) = 0._r8
         mat(k,2265) = 0._r8
         mat(k,2269) = 0._r8
         mat(k,2270) = 0._r8
         mat(k,2273) = 0._r8
         mat(k,2281) = 0._r8
         mat(k,2282) = 0._r8
         mat(k,2290) = 0._r8
         mat(k,2293) = 0._r8
         mat(k,2294) = 0._r8
         mat(k,2295) = 0._r8
         mat(k,2298) = 0._r8
         mat(k,2299) = 0._r8
         mat(k,2302) = 0._r8
         mat(k,2304) = 0._r8
         mat(k,2313) = 0._r8
         mat(k,2314) = 0._r8
         mat(k,2322) = 0._r8
         mat(k,2331) = 0._r8
         mat(k,2340) = 0._r8
         mat(k,2341) = 0._r8
         mat(k,2349) = 0._r8
         mat(k,2352) = 0._r8
         mat(k,2353) = 0._r8
         mat(k,2354) = 0._r8
         mat(k,2357) = 0._r8
         mat(k,2358) = 0._r8
         mat(k,2362) = 0._r8
         mat(k,2363) = 0._r8
         mat(k,2366) = 0._r8
         mat(k,2374) = 0._r8
         mat(k,2375) = 0._r8
         mat(k,2383) = 0._r8
         mat(k,2389) = 0._r8
         mat(k,2390) = 0._r8
         mat(k,2391) = 0._r8
         mat(k,2394) = 0._r8
         mat(k,2395) = 0._r8
         mat(k,2396) = 0._r8
         mat(k,2397) = 0._r8
         mat(k,2398) = 0._r8
         mat(k,2399) = 0._r8
         mat(k,2400) = 0._r8
         mat(k,2401) = 0._r8
         mat(k,2406) = 0._r8
         mat(k,2409) = 0._r8
         mat(k,2410) = 0._r8
         mat(k,2411) = 0._r8
         mat(k,2413) = 0._r8
         mat(k,2417) = 0._r8
         mat(k,2419) = 0._r8
         mat(k,2421) = 0._r8
         mat(k,2422) = 0._r8
         mat(k,2423) = 0._r8
         mat(k,2425) = 0._r8
         mat(k,2426) = 0._r8
         mat(k,2427) = 0._r8
         mat(k,2428) = 0._r8
         mat(k,2431) = 0._r8
         mat(k,2433) = 0._r8
         mat(k,2436) = 0._r8
         mat(k,2437) = 0._r8
         mat(k,2438) = 0._r8
         mat(k,2443) = 0._r8
         mat(k,2444) = 0._r8
         mat(k,2452) = 0._r8
         mat(k,2453) = 0._r8
         mat(k,2460) = 0._r8
         mat(k,2464) = 0._r8
         mat(k,2465) = 0._r8
         mat(k,2473) = 0._r8
         mat(k,2474) = 0._r8
         mat(k,2485) = 0._r8
         mat(k,2486) = 0._r8
         mat(k,2494) = 0._r8
         mat(k,2495) = 0._r8
         mat(k,2503) = 0._r8
         mat(k,2536) = 0._r8
         mat(k,2537) = 0._r8
         mat(k,2544) = 0._r8
         mat(k,2547) = 0._r8
         mat(k,2548) = 0._r8
         mat(k,2549) = 0._r8
         mat(k,2582) = 0._r8
         mat(k,2583) = 0._r8
         mat(k,2590) = 0._r8
         mat(k,2593) = 0._r8
         mat(k,2594) = 0._r8
         mat(k,2595) = 0._r8
         mat(k,2599) = 0._r8
         mat(k,2629) = 0._r8
         mat(k,2630) = 0._r8
         mat(k,2637) = 0._r8
         mat(k,2640) = 0._r8
         mat(k,2641) = 0._r8
         mat(k,2642) = 0._r8
         mat(k,2661) = 0._r8
         mat(k,2668) = 0._r8
         mat(k,2672) = 0._r8
         mat(k,2673) = 0._r8
         mat(k,2674) = 0._r8
         mat(k,2700) = 0._r8
         mat(k,2701) = 0._r8
         mat(k,2704) = 0._r8
         mat(k,2708) = 0._r8
         mat(k,2711) = 0._r8
         mat(k,2712) = 0._r8
         mat(k,2713) = 0._r8
         mat(k,2716) = 0._r8
         mat(k,2718) = 0._r8
         mat(k,2720) = 0._r8
         mat(k,2721) = 0._r8
         mat(k,2722) = 0._r8
         mat(k,2725) = 0._r8
         mat(k,2726) = 0._r8
         mat(k,2729) = 0._r8
         mat(k,2732) = 0._r8
         mat(k,2733) = 0._r8
         mat(k,2735) = 0._r8
         mat(k,2737) = 0._r8
         mat(k,2739) = 0._r8
         mat(k,2740) = 0._r8
         mat(k,2789) = 0._r8
         mat(k,2808) = 0._r8
         mat(k,2816) = 0._r8
         mat(k,2823) = 0._r8
         mat(k,2825) = 0._r8
         mat(k,2855) = 0._r8
         mat(k,2883) = 0._r8
         mat(k,2884) = 0._r8
         mat(k,2888) = 0._r8
         mat(k,2896) = 0._r8
         mat(k,2899) = 0._r8
         mat(k,2914) = 0._r8
         mat(k,2923) = 0._r8
         mat(k,2928) = 0._r8
         mat(k,2934) = 0._r8
         mat(k,2937) = 0._r8
         mat(k,2939) = 0._r8
         mat(k,2941) = 0._r8
         mat(k,2942) = 0._r8
         mat(k,2944) = 0._r8
         mat(k,2945) = 0._r8
         mat(k,2947) = 0._r8
         mat(k,2949) = 0._r8
         mat(k,2950) = 0._r8
         mat(k,2952) = 0._r8
         mat(k,2953) = 0._r8
         mat(k,2954) = 0._r8
         mat(k,2957) = 0._r8
         mat(k,2961) = 0._r8
         mat(k,2962) = 0._r8
         mat(k,2963) = 0._r8
         mat(k,2964) = 0._r8
         mat(k,2966) = 0._r8
         mat(k,2967) = 0._r8
         mat(k,2969) = 0._r8
         mat(k,2970) = 0._r8
         mat(k,2971) = 0._r8
         mat(k,2972) = 0._r8
         mat(k,2973) = 0._r8
         mat(k,2974) = 0._r8
         mat(k,2977) = 0._r8
         mat(k,2978) = 0._r8
         mat(k,2982) = 0._r8
         mat(k,2984) = 0._r8
         mat(k,2997) = 0._r8
         mat(k,3000) = 0._r8
         mat(k,3006) = 0._r8
         mat(k,3009) = 0._r8
         mat(k,3014) = 0._r8
         mat(k,3015) = 0._r8
         mat(k,3016) = 0._r8
         mat(k,3020) = 0._r8
         mat(k,3024) = 0._r8
         mat(k,3025) = 0._r8
         mat(k,3028) = 0._r8
         mat(k,3030) = 0._r8
         mat(k,3032) = 0._r8
         mat(k,3033) = 0._r8
         mat(k,3036) = 0._r8
         mat(k,3038) = 0._r8
         mat(k,3039) = 0._r8
         mat(k,3040) = 0._r8
         mat(k,3041) = 0._r8
         mat(k,3043) = 0._r8
         mat(k,3044) = 0._r8
         mat(k,3045) = 0._r8
         mat(k,3048) = 0._r8
         mat(k,3049) = 0._r8
         mat(k,3050) = 0._r8
         mat(k,3077) = 0._r8
         mat(k,3079) = 0._r8
         mat(k,3081) = 0._r8
         mat(k,3083) = 0._r8
         mat(k,3089) = 0._r8
         mat(k,3090) = 0._r8
         mat(k,3091) = 0._r8
         mat(k,3092) = 0._r8
         mat(k,3100) = 0._r8
         mat(k,3104) = 0._r8
         mat(k,3111) = 0._r8
         mat(k,3137) = 0._r8
         mat(k,3151) = 0._r8
         mat(k,3153) = 0._r8
         mat(k,3205) = 0._r8
         mat(k,3209) = 0._r8
         mat(k,3219) = 0._r8
         mat(k,3231) = 0._r8
         mat(k,3239) = 0._r8
         mat(k,3243) = 0._r8
         mat(k,3252) = 0._r8
         mat(k,3253) = 0._r8
         mat(k,3254) = 0._r8
         mat(k,3279) = 0._r8
         mat(k,3284) = 0._r8
         mat(k,3305) = 0._r8
         mat(k,3306) = 0._r8
         mat(k,3308) = 0._r8
         mat(k,3309) = 0._r8
         mat(k,3310) = 0._r8
         mat(k,3321) = 0._r8
         mat(k,3324) = 0._r8
         mat(k,3325) = 0._r8
         mat(k,3331) = 0._r8
         mat(k,3332) = 0._r8
         mat(k,3334) = 0._r8
         mat(k,3336) = 0._r8
         mat(k,3338) = 0._r8
         mat(k,3340) = 0._r8
         mat(k,3343) = 0._r8
         mat(k,3354) = 0._r8
         mat(k,3357) = 0._r8
         mat(k,3360) = 0._r8
         mat(k,3362) = 0._r8
         mat(k,3363) = 0._r8
         mat(k,3371) = 0._r8
         mat(k,3373) = 0._r8
         mat(k,3380) = 0._r8
         mat(k,3381) = 0._r8
         mat(k,3388) = 0._r8
         mat(k,3392) = 0._r8
         mat(k,3420) = 0._r8
         mat(k,3421) = 0._r8
         mat(k,3423) = 0._r8
         mat(k,3424) = 0._r8
         mat(k,3425) = 0._r8
         mat(k,3430) = 0._r8
         mat(k,3433) = 0._r8
         mat(k,3434) = 0._r8
         mat(k,3436) = 0._r8
         mat(k,3438) = 0._r8
         mat(k,3443) = 0._r8
         mat(k,3450) = 0._r8
         mat(k,3455) = 0._r8
         mat(k,3459) = 0._r8
         mat(k,3466) = 0._r8
         mat(k,3479) = 0._r8
         mat(k,3483) = 0._r8
         mat(k,3485) = 0._r8
         mat(k,3486) = 0._r8
         mat(k,3490) = 0._r8
         mat(k,3491) = 0._r8
         mat(k,3492) = 0._r8
         mat(k,3493) = 0._r8
         mat(k,3494) = 0._r8
         mat(k,3495) = 0._r8
         mat(k,3501) = 0._r8
         mat(k,3505) = 0._r8
         mat(k,3508) = 0._r8
         mat(k,3509) = 0._r8
         mat(k,3513) = 0._r8
         mat(k,3515) = 0._r8
         mat(k,3516) = 0._r8
         mat(k,3580) = 0._r8
         mat(k,3624) = 0._r8
         mat(k,3627) = 0._r8
         mat(k,3631) = 0._r8
         mat(k,3639) = 0._r8
         mat(k,3695) = 0._r8
         mat(k,3696) = 0._r8
         mat(k,3703) = 0._r8
         mat(k,3708) = 0._r8
         mat(k,3718) = 0._r8
         mat(k,3720) = 0._r8
         mat(k,3728) = 0._r8
         mat(k,3730) = 0._r8
         mat(k,3745) = 0._r8
         mat(k,3762) = 0._r8
         mat(k,3765) = 0._r8
         mat(k,3766) = 0._r8
         mat(k,3768) = 0._r8
         mat(k,3770) = 0._r8
         mat(k,3771) = 0._r8
         mat(k,3773) = 0._r8
         mat(k,3776) = 0._r8
         mat(k,3786) = 0._r8
         mat(k,3787) = 0._r8
         mat(k,3789) = 0._r8
         mat(k,3790) = 0._r8
         mat(k,3791) = 0._r8
         mat(k,3794) = 0._r8
         mat(k,3795) = 0._r8
         mat(k,3799) = 0._r8
         mat(k,3802) = 0._r8
         mat(k,3807) = 0._r8
         mat(k,3809) = 0._r8
         mat(k,3810) = 0._r8
         mat(k,3813) = 0._r8
         mat(k,3815) = 0._r8
         mat(k,3817) = 0._r8
         mat(k,3820) = 0._r8
         mat(k,3821) = 0._r8
         mat(k,3823) = 0._r8
         mat(k,3826) = 0._r8
         mat(k,3831) = 0._r8
         mat(k,3832) = 0._r8
         mat(k,3835) = 0._r8
         mat(k,3837) = 0._r8
         mat(k,3842) = 0._r8
         mat(k,3844) = 0._r8
         mat(k,3845) = 0._r8
         mat(k,3846) = 0._r8
         mat(k,3848) = 0._r8
         mat(k,3849) = 0._r8
         mat(k,3850) = 0._r8
         mat(k,3852) = 0._r8
         mat(k,3853) = 0._r8
         mat(k,3854) = 0._r8
         mat(k,3855) = 0._r8
         mat(k,3857) = 0._r8
         mat(k,3859) = 0._r8
         mat(k,3860) = 0._r8
         mat(k,3861) = 0._r8
         mat(k, 1) = mat(k, 1) - dti(k)
         mat(k, 2) = mat(k, 2) - dti(k)
         mat(k, 3) = mat(k, 3) - dti(k)
         mat(k, 4) = mat(k, 4) - dti(k)
         mat(k, 5) = mat(k, 5) - dti(k)
         mat(k, 6) = mat(k, 6) - dti(k)
         mat(k, 7) = mat(k, 7) - dti(k)
         mat(k, 8) = mat(k, 8) - dti(k)
         mat(k, 9) = mat(k, 9) - dti(k)
         mat(k, 10) = mat(k, 10) - dti(k)
         mat(k, 11) = mat(k, 11) - dti(k)
         mat(k, 12) = mat(k, 12) - dti(k)
         mat(k, 13) = mat(k, 13) - dti(k)
         mat(k, 14) = mat(k, 14) - dti(k)
         mat(k, 15) = mat(k, 15) - dti(k)
         mat(k, 16) = mat(k, 16) - dti(k)
         mat(k, 17) = mat(k, 17) - dti(k)
         mat(k, 18) = mat(k, 18) - dti(k)
         mat(k, 19) = mat(k, 19) - dti(k)
         mat(k, 20) = mat(k, 20) - dti(k)
         mat(k, 21) = mat(k, 21) - dti(k)
         mat(k, 22) = mat(k, 22) - dti(k)
         mat(k, 23) = mat(k, 23) - dti(k)
         mat(k, 24) = mat(k, 24) - dti(k)
         mat(k, 25) = mat(k, 25) - dti(k)
         mat(k, 26) = mat(k, 26) - dti(k)
         mat(k, 27) = mat(k, 27) - dti(k)
         mat(k, 28) = mat(k, 28) - dti(k)
         mat(k, 29) = mat(k, 29) - dti(k)
         mat(k, 30) = mat(k, 30) - dti(k)
         mat(k, 31) = mat(k, 31) - dti(k)
         mat(k, 32) = mat(k, 32) - dti(k)
         mat(k, 33) = mat(k, 33) - dti(k)
         mat(k, 34) = mat(k, 34) - dti(k)
         mat(k, 40) = mat(k, 40) - dti(k)
         mat(k, 46) = mat(k, 46) - dti(k)
         mat(k, 52) = mat(k, 52) - dti(k)
         mat(k, 58) = mat(k, 58) - dti(k)
         mat(k, 64) = mat(k, 64) - dti(k)
         mat(k, 70) = mat(k, 70) - dti(k)
         mat(k, 76) = mat(k, 76) - dti(k)
         mat(k, 78) = mat(k, 78) - dti(k)
         mat(k, 84) = mat(k, 84) - dti(k)
         mat(k, 90) = mat(k, 90) - dti(k)
         mat(k, 96) = mat(k, 96) - dti(k)
         mat(k, 102) = mat(k, 102) - dti(k)
         mat(k, 103) = mat(k, 103) - dti(k)
         mat(k, 106) = mat(k, 106) - dti(k)
         mat(k, 109) = mat(k, 109) - dti(k)
         mat(k, 112) = mat(k, 112) - dti(k)
         mat(k, 116) = mat(k, 116) - dti(k)
         mat(k, 119) = mat(k, 119) - dti(k)
         mat(k, 122) = mat(k, 122) - dti(k)
         mat(k, 125) = mat(k, 125) - dti(k)
         mat(k, 128) = mat(k, 128) - dti(k)
         mat(k, 131) = mat(k, 131) - dti(k)
         mat(k, 137) = mat(k, 137) - dti(k)
         mat(k, 141) = mat(k, 141) - dti(k)
         mat(k, 146) = mat(k, 146) - dti(k)
         mat(k, 150) = mat(k, 150) - dti(k)
         mat(k, 153) = mat(k, 153) - dti(k)
         mat(k, 156) = mat(k, 156) - dti(k)
         mat(k, 161) = mat(k, 161) - dti(k)
         mat(k, 168) = mat(k, 168) - dti(k)
         mat(k, 173) = mat(k, 173) - dti(k)
         mat(k, 179) = mat(k, 179) - dti(k)
         mat(k, 187) = mat(k, 187) - dti(k)
         mat(k, 192) = mat(k, 192) - dti(k)
         mat(k, 195) = mat(k, 195) - dti(k)
         mat(k, 198) = mat(k, 198) - dti(k)
         mat(k, 201) = mat(k, 201) - dti(k)
         mat(k, 204) = mat(k, 204) - dti(k)
         mat(k, 207) = mat(k, 207) - dti(k)
         mat(k, 210) = mat(k, 210) - dti(k)
         mat(k, 214) = mat(k, 214) - dti(k)
         mat(k, 218) = mat(k, 218) - dti(k)
         mat(k, 222) = mat(k, 222) - dti(k)
         mat(k, 226) = mat(k, 226) - dti(k)
         mat(k, 230) = mat(k, 230) - dti(k)
         mat(k, 234) = mat(k, 234) - dti(k)
         mat(k, 238) = mat(k, 238) - dti(k)
         mat(k, 244) = mat(k, 244) - dti(k)
         mat(k, 250) = mat(k, 250) - dti(k)
         mat(k, 253) = mat(k, 253) - dti(k)
         mat(k, 259) = mat(k, 259) - dti(k)
         mat(k, 265) = mat(k, 265) - dti(k)
         mat(k, 270) = mat(k, 270) - dti(k)
         mat(k, 275) = mat(k, 275) - dti(k)
         mat(k, 280) = mat(k, 280) - dti(k)
         mat(k, 286) = mat(k, 286) - dti(k)
         mat(k, 291) = mat(k, 291) - dti(k)
         mat(k, 296) = mat(k, 296) - dti(k)
         mat(k, 300) = mat(k, 300) - dti(k)
         mat(k, 308) = mat(k, 308) - dti(k)
         mat(k, 316) = mat(k, 316) - dti(k)
         mat(k, 322) = mat(k, 322) - dti(k)
         mat(k, 328) = mat(k, 328) - dti(k)
         mat(k, 332) = mat(k, 332) - dti(k)
         mat(k, 338) = mat(k, 338) - dti(k)
         mat(k, 344) = mat(k, 344) - dti(k)
         mat(k, 350) = mat(k, 350) - dti(k)
         mat(k, 358) = mat(k, 358) - dti(k)
         mat(k, 364) = mat(k, 364) - dti(k)
         mat(k, 370) = mat(k, 370) - dti(k)
         mat(k, 377) = mat(k, 377) - dti(k)
         mat(k, 383) = mat(k, 383) - dti(k)
         mat(k, 386) = mat(k, 386) - dti(k)
         mat(k, 391) = mat(k, 391) - dti(k)
         mat(k, 398) = mat(k, 398) - dti(k)
         mat(k, 405) = mat(k, 405) - dti(k)
         mat(k, 409) = mat(k, 409) - dti(k)
         mat(k, 419) = mat(k, 419) - dti(k)
         mat(k, 426) = mat(k, 426) - dti(k)
         mat(k, 435) = mat(k, 435) - dti(k)
         mat(k, 443) = mat(k, 443) - dti(k)
         mat(k, 450) = mat(k, 450) - dti(k)
         mat(k, 455) = mat(k, 455) - dti(k)
         mat(k, 462) = mat(k, 462) - dti(k)
         mat(k, 468) = mat(k, 468) - dti(k)
         mat(k, 474) = mat(k, 474) - dti(k)
         mat(k, 482) = mat(k, 482) - dti(k)
         mat(k, 490) = mat(k, 490) - dti(k)
         mat(k, 498) = mat(k, 498) - dti(k)
         mat(k, 506) = mat(k, 506) - dti(k)
         mat(k, 514) = mat(k, 514) - dti(k)
         mat(k, 522) = mat(k, 522) - dti(k)
         mat(k, 526) = mat(k, 526) - dti(k)
         mat(k, 530) = mat(k, 530) - dti(k)
         mat(k, 534) = mat(k, 534) - dti(k)
         mat(k, 542) = mat(k, 542) - dti(k)
         mat(k, 554) = mat(k, 554) - dti(k)
         mat(k, 566) = mat(k, 566) - dti(k)
         mat(k, 573) = mat(k, 573) - dti(k)
         mat(k, 582) = mat(k, 582) - dti(k)
         mat(k, 589) = mat(k, 589) - dti(k)
         mat(k, 593) = mat(k, 593) - dti(k)
         mat(k, 604) = mat(k, 604) - dti(k)
         mat(k, 613) = mat(k, 613) - dti(k)
         mat(k, 623) = mat(k, 623) - dti(k)
         mat(k, 634) = mat(k, 634) - dti(k)
         mat(k, 645) = mat(k, 645) - dti(k)
         mat(k, 656) = mat(k, 656) - dti(k)
         mat(k, 663) = mat(k, 663) - dti(k)
         mat(k, 671) = mat(k, 671) - dti(k)
         mat(k, 680) = mat(k, 680) - dti(k)
         mat(k, 688) = mat(k, 688) - dti(k)
         mat(k, 696) = mat(k, 696) - dti(k)
         mat(k, 710) = mat(k, 710) - dti(k)
         mat(k, 721) = mat(k, 721) - dti(k)
         mat(k, 731) = mat(k, 731) - dti(k)
         mat(k, 744) = mat(k, 744) - dti(k)
         mat(k, 751) = mat(k, 751) - dti(k)
         mat(k, 762) = mat(k, 762) - dti(k)
         mat(k, 778) = mat(k, 778) - dti(k)
         mat(k, 789) = mat(k, 789) - dti(k)
         mat(k, 797) = mat(k, 797) - dti(k)
         mat(k, 802) = mat(k, 802) - dti(k)
         mat(k, 807) = mat(k, 807) - dti(k)
         mat(k, 812) = mat(k, 812) - dti(k)
         mat(k, 822) = mat(k, 822) - dti(k)
         mat(k, 834) = mat(k, 834) - dti(k)
         mat(k, 843) = mat(k, 843) - dti(k)
         mat(k, 859) = mat(k, 859) - dti(k)
         mat(k, 871) = mat(k, 871) - dti(k)
         mat(k, 876) = mat(k, 876) - dti(k)
         mat(k, 888) = mat(k, 888) - dti(k)
         mat(k, 897) = mat(k, 897) - dti(k)
         mat(k, 906) = mat(k, 906) - dti(k)
         mat(k, 917) = mat(k, 917) - dti(k)
         mat(k, 926) = mat(k, 926) - dti(k)
         mat(k, 941) = mat(k, 941) - dti(k)
         mat(k, 961) = mat(k, 961) - dti(k)
         mat(k, 975) = mat(k, 975) - dti(k)
         mat(k, 985) = mat(k, 985) - dti(k)
         mat(k, 995) = mat(k, 995) - dti(k)
         mat(k, 999) = mat(k, 999) - dti(k)
         mat(k,1010) = mat(k,1010) - dti(k)
         mat(k,1021) = mat(k,1021) - dti(k)
         mat(k,1032) = mat(k,1032) - dti(k)
         mat(k,1039) = mat(k,1039) - dti(k)
         mat(k,1048) = mat(k,1048) - dti(k)
         mat(k,1064) = mat(k,1064) - dti(k)
         mat(k,1071) = mat(k,1071) - dti(k)
         mat(k,1083) = mat(k,1083) - dti(k)
         mat(k,1102) = mat(k,1102) - dti(k)
         mat(k,1118) = mat(k,1118) - dti(k)
         mat(k,1124) = mat(k,1124) - dti(k)
         mat(k,1132) = mat(k,1132) - dti(k)
         mat(k,1144) = mat(k,1144) - dti(k)
         mat(k,1154) = mat(k,1154) - dti(k)
         mat(k,1161) = mat(k,1161) - dti(k)
         mat(k,1167) = mat(k,1167) - dti(k)
         mat(k,1176) = mat(k,1176) - dti(k)
         mat(k,1180) = mat(k,1180) - dti(k)
         mat(k,1197) = mat(k,1197) - dti(k)
         mat(k,1213) = mat(k,1213) - dti(k)
         mat(k,1224) = mat(k,1224) - dti(k)
         mat(k,1236) = mat(k,1236) - dti(k)
         mat(k,1243) = mat(k,1243) - dti(k)
         mat(k,1255) = mat(k,1255) - dti(k)
         mat(k,1270) = mat(k,1270) - dti(k)
         mat(k,1285) = mat(k,1285) - dti(k)
         mat(k,1305) = mat(k,1305) - dti(k)
         mat(k,1315) = mat(k,1315) - dti(k)
         mat(k,1329) = mat(k,1329) - dti(k)
         mat(k,1336) = mat(k,1336) - dti(k)
         mat(k,1343) = mat(k,1343) - dti(k)
         mat(k,1349) = mat(k,1349) - dti(k)
         mat(k,1356) = mat(k,1356) - dti(k)
         mat(k,1360) = mat(k,1360) - dti(k)
         mat(k,1370) = mat(k,1370) - dti(k)
         mat(k,1383) = mat(k,1383) - dti(k)
         mat(k,1396) = mat(k,1396) - dti(k)
         mat(k,1404) = mat(k,1404) - dti(k)
         mat(k,1416) = mat(k,1416) - dti(k)
         mat(k,1439) = mat(k,1439) - dti(k)
         mat(k,1463) = mat(k,1463) - dti(k)
         mat(k,1469) = mat(k,1469) - dti(k)
         mat(k,1480) = mat(k,1480) - dti(k)
         mat(k,1497) = mat(k,1497) - dti(k)
         mat(k,1513) = mat(k,1513) - dti(k)
         mat(k,1529) = mat(k,1529) - dti(k)
         mat(k,1540) = mat(k,1540) - dti(k)
         mat(k,1550) = mat(k,1550) - dti(k)
         mat(k,1571) = mat(k,1571) - dti(k)
         mat(k,1590) = mat(k,1590) - dti(k)
         mat(k,1603) = mat(k,1603) - dti(k)
         mat(k,1611) = mat(k,1611) - dti(k)
         mat(k,1620) = mat(k,1620) - dti(k)
         mat(k,1635) = mat(k,1635) - dti(k)
         mat(k,1645) = mat(k,1645) - dti(k)
         mat(k,1667) = mat(k,1667) - dti(k)
         mat(k,1685) = mat(k,1685) - dti(k)
         mat(k,1700) = mat(k,1700) - dti(k)
         mat(k,1729) = mat(k,1729) - dti(k)
         mat(k,1751) = mat(k,1751) - dti(k)
         mat(k,1780) = mat(k,1780) - dti(k)
         mat(k,1801) = mat(k,1801) - dti(k)
         mat(k,1829) = mat(k,1829) - dti(k)
         mat(k,1845) = mat(k,1845) - dti(k)
         mat(k,1863) = mat(k,1863) - dti(k)
         mat(k,1896) = mat(k,1896) - dti(k)
         mat(k,1930) = mat(k,1930) - dti(k)
         mat(k,1964) = mat(k,1964) - dti(k)
         mat(k,1993) = mat(k,1993) - dti(k)
         mat(k,2034) = mat(k,2034) - dti(k)
         mat(k,2053) = mat(k,2053) - dti(k)
         mat(k,2072) = mat(k,2072) - dti(k)
         mat(k,2096) = mat(k,2096) - dti(k)
         mat(k,2119) = mat(k,2119) - dti(k)
         mat(k,2141) = mat(k,2141) - dti(k)
         mat(k,2156) = mat(k,2156) - dti(k)
         mat(k,2179) = mat(k,2179) - dti(k)
         mat(k,2193) = mat(k,2193) - dti(k)
         mat(k,2214) = mat(k,2214) - dti(k)
         mat(k,2243) = mat(k,2243) - dti(k)
         mat(k,2271) = mat(k,2271) - dti(k)
         mat(k,2303) = mat(k,2303) - dti(k)
         mat(k,2332) = mat(k,2332) - dti(k)
         mat(k,2364) = mat(k,2364) - dti(k)
         mat(k,2392) = mat(k,2392) - dti(k)
         mat(k,2420) = mat(k,2420) - dti(k)
         mat(k,2445) = mat(k,2445) - dti(k)
         mat(k,2467) = mat(k,2467) - dti(k)
         mat(k,2489) = mat(k,2489) - dti(k)
         mat(k,2532) = mat(k,2532) - dti(k)
         mat(k,2579) = mat(k,2579) - dti(k)
         mat(k,2627) = mat(k,2627) - dti(k)
         mat(k,2699) = mat(k,2699) - dti(k)
         mat(k,2717) = mat(k,2717) - dti(k)
         mat(k,2730) = mat(k,2730) - dti(k)
         mat(k,2885) = mat(k,2885) - dti(k)
         mat(k,2987) = mat(k,2987) - dti(k)
         mat(k,3080) = mat(k,3080) - dti(k)
         mat(k,3105) = mat(k,3105) - dti(k)
         mat(k,3285) = mat(k,3285) - dti(k)
         mat(k,3312) = mat(k,3312) - dti(k)
         mat(k,3337) = mat(k,3337) - dti(k)
         mat(k,3429) = mat(k,3429) - dti(k)
         mat(k,3460) = mat(k,3460) - dti(k)
         mat(k,3511) = mat(k,3511) - dti(k)
         mat(k,3752) = mat(k,3752) - dti(k)
         mat(k,3775) = mat(k,3775) - dti(k)
         mat(k,3800) = mat(k,3800) - dti(k)
         mat(k,3836) = mat(k,3836) - dti(k)
         mat(k,3862) = mat(k,3862) - dti(k)
      end do
      end subroutine nlnmat_finit
      subroutine nlnmat( avec_len, mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: dti(veclen)
      real(r8), intent(in) :: lmat(veclen,nzcnt)
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
      call nlnmat01( avec_len, mat, y, rxt )
      call nlnmat02( avec_len, mat, y, rxt )
      call nlnmat03( avec_len, mat, y, rxt )
      call nlnmat04( avec_len, mat, y, rxt )
      call nlnmat05( avec_len, mat, y, rxt )
      call nlnmat06( avec_len, mat, y, rxt )
      call nlnmat07( avec_len, mat, y, rxt )
      call nlnmat08( avec_len, mat, y, rxt )
      call nlnmat09( avec_len, mat, y, rxt )
      call nlnmat10( avec_len, mat, y, rxt )
      call nlnmat11( avec_len, mat, y, rxt )
      call nlnmat12( avec_len, mat, y, rxt )
      call nlnmat13( avec_len, mat, y, rxt )
      call nlnmat14( avec_len, mat, y, rxt )
      call nlnmat15( avec_len, mat, y, rxt )
      call nlnmat16( avec_len, mat, y, rxt )
      call nlnmat17( avec_len, mat, y, rxt )
      call nlnmat_finit( avec_len, mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
