# Climate reproducibility testing

Requiring model changes to pass stringent tests before being accepted as part of E3SM’s main development 
branch is critical for quickly and efficiently producing a trustworthy model.  Depending on their
impacts on model output, code modifications can be classified into three types:

1. Technical changes that continue to produce bit-for-bit identical solutions
2. Changes that cause the model solution to differ,  yet produce a statistically identical climate when
   averaged over a sufficiently long time
3. Changes that lead to a different model climate

Only (3) impacts model climate, and changes of this type should only be implemented within the code 
after an in-depth demonstration of improvement. However, distinguishing between (2) and (3) requires
a comprehensive analysis of both a baseline climate and the currently produced climate.   

Through the CMDV Software project, we've provided a set of climate reproducibility tests to determine
whether or not non-bit-for-bit (nb4b) model changes are climate changing. The current tests provided are:

 * **MVK** --  This tests the null hypothesis that the baseline (n) and modified (m) model Short Independent 
   Simulation Ensembles (SISE) represent the same climate state, based on the equality of distribution 
   of each variable's annual global average in the standard monthly model output between the two 
   simulations. The (per variable) null hypothesis uses the non-parametric, two-sample (n and m) 
   Kolmogorov-Smirnov test as the univariate test of of equality of distribution of global means.
  
 * **PGN** -- This tests the null hypothesis that the reference (n) and modified (m) model
   ensembles represent the same atmospheric state after each physics parameterization
   is applied within a single time-step using the two-sample (n and m) T-test for equal
   averages at a 95% confidence level. Ensembles are generated by repeating the
   simulation for many initial conditions, with each initial condition subject to
   multiple perturbations.
 
 * **TSC** -- This tests the null hypothesis that the convergence of the time stepping error
   for a set of key atmospheric variables is the same for a reference ensemble and
   a test ensemble. Both the reference and test ensemble are generated with a
   two-second time step, and for each variable the RMSD between each ensemble and
   a truth ensemble, generated with a one-second time step, is calculated. At each 
   10 second interval during the 10 minute long simulations, the difference
   in the reference and test RMSDs for each variable, each ensemble member, and each
   domain are calculated and these ΔRMSDs should be zero for identical climates. A
   one sided (due to self convergence) Student's T Test is used to test the null
   hypothesis that the ensemble mean ΔRMSD is statistically zero.
 
 
 
## Running the tests

These tests are built into E3SM-CIME as system tests and will be launched using the `create_test` scripts. 
*However*, because these tests use high level statistics, they have additional python dependencies which
need to be installed on your system and accessible via the compute nodes (if you're on a batch machine).
Primarily, the statistical analysis of the climates is done through [EVV](https://github.com/LIVVkit/evv4esm) 
which will generate a portable test website to describe the results (pass or fail) in detail (see the extended output 
section below). 

For E3SM supported machines, the `e3sm_simple` conda environment is provided for these tests and includes the `EVV` 
conda package. You can activate the `e3sm_simple` environment in the same way as `e3sm_unified` environment:   

```
source <activate_path>/load_latest_e3sm_simple.sh
```

where `<activate_path>` is the machine-specific location of the activation script as described on this confluence page:

https://acme-climate.atlassian.net/wiki/spaces/EIDMG/pages/780271950/Diagnostics+and+Analysis+Quickstart#DiagnosticsandAnalysisQuickstart-Accessingmetapackagesoftwarebyactivatingacondaenvironment

If you don't have access to confluence or are unable to activate this environment for whatever reason, you can install
your own `e3sm_simple` conda environment with this command (once you have anaconda/miniconda installed):  

```
conda create -n e3sm-simple -c conda-forge -c e3sm e3sm-simple
```

*NOTE: If you run into problems with getting this environment working on your machine, please open an issue on E3SM's 
Github and tag @jhkennedy, or send Joseph H. Kennedy <kennedyjh@ornl.gov> an email.*

After you've activated the `e3sm_simple` environment, change to the `$E3SM/cime/scripts` directory (where `$E3SM` is the 
directory containing E3SM). Then to run one of the tests, you will use the `create_test` script like normal. 
To run the `MVK` test and generate a baseline, you would run a command like: 

```
./create_test MVK_PL.ne4_oQU240.FC5AV1C-L -g --baseline-root "/PATH/TO/BASELINE" 
```

And to compare to the baseline, you would run a command like: 

```
./create_test MVK_PL.ne4_oQU240.FC5AV1C-L -c --baseline-root "/PATH/TO/BASELINE" 
```

*NOTE: The MVK run a 20 member ensemble for at least 13 months (using the last 12 for the 
statistical tests) and, depending on the machine, may take some fiddling to execute within a particular 
queue's wallclock time limit. You may want to over-ride the requested walltime using `--walltime HH:MM:SS` 
option to `create_test`.* 

The full set of commands to run the MVK test used on Cori are:

*Generate a baseline*
```
cd $E3SM/cime/scripts

source /global/project/projectdirs/acme/software/anaconda_envs/load_latest_e3sm_simple.sh

./create_test MVK_PL.ne4_ne4.FC5AV1C-L --baseline-root "${CSCRATCH}/baselines" --project acme -g -o --walltime 01:00:00
```

*Compare to a baseline*
```
cd $E3SM/cime/scripts

source /global/project/projectdirs/acme/software/anaconda_envs/load_latest_e3sm_simple.sh

./create_test MVK_PL.ne4_ne4.FC5AV1C-L --baseline-root "${CSCRATCH}/baselines" --project acme -c --walltime 01:00:00
```

## Test pass/fail and extended output

When you launch these tests and compare to a baseline, CIME will output the location of the case directory, which will look 
something like this:

```
# On cori-knl:
./create_test MVK_PL.ne4_ne4.FC5AV1C-L --baseline-root "${CSCRATCH}/baselines" --project acme -c --walltime 01:00:00
    Creating test directory /global/cscratch1/sd/${USER}/acme_scratch/cori-knl/MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID
```

Let's call that directory `$CASE_DIR`. Once all the jobs are finished, navigate to that directory and 
you can `cat TestStatus` to determine if the test passed or failed by looking at the `BASELINE` status:  

```
cd $CASE_DIR
cat TestStatus
    ...
    PASS MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel BASELINE
    ...

```

To get some basic summary statistics about the test that was run, look in the `TestStatus.log` file:

```
2019-08-14  22:09:02: BASELINE PASS for test 'YYYYMMDD_HHMMSS_RANDOMID'. 
    Case: YYYYMMDD_HHMMSS_RANDOMID; Test status: pass; Variables analyzed: 118; Rejecting: 0; Critical value: 13; Ensembles: statistically identical 
    EVV results can be viewed at: /global/cscratch1/sd/${USER}/acme_scratch/cori-knl/MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID/run/MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID.evv/ 
    EVV viewing instructions can be found at: https://github.com/E3SM-Project/E3SM/blob/master/cime/scripts/climate_reproducibility/README.md#test-passfail-and-extended-output 
```

EVV reports the location of the output website where you can see the details of the analysis. For 
the MVK test, you will be able to view per variable Q-Q plots, P-P plots, the K-S test statistic, and 
whether it rejects or accepts the null hypothesis, as well as a description of the test itself -- you 
can see an example of the output website [here](http://livvkit.github.io/evv4esm/).

To view the website, you can either tunnel the website to your local machine through ssh, or copy 
the website directory to your machine and view it using EVV. 

### View via ssh

For this example, we'll assume the tests were run on Cori at NERSC, but these instructions should be
easily adaptable to any E3SM supported machine. First, log into Cori via ssh and connect your local 
8080 port to the 8080 port on Cori: 

```
ssh -L 8080:localhost:8080 [USER]@cori.nersc.gov 
```

Activate the `e3sm_simple` environment:

```
source /global/project/projectdirs/acme/software/anaconda_envs/load_latest_e3sm_simple.sh
```

Navigate to the case's run directory:

```
pushd ${CASE_DIR}/run
```

Then, using EVV, serve the website over port 8080:

```
evv -o PGN_P1x1.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID.evv -s 8080
```

Evv will then report to you the URL where you can view the website:

```

--------------------------------------------------------------------
                   ______  __      __ __      __                    
                  |  ____| \ \    / / \ \    / /                    
                  | |__     \ \  / /   \ \  / /                     
                  |  __|     \ \/ /     \ \/ /                      
                  | |____     \  /       \  /                       
                  |______|     \/         \/                        
                                                                    
    Extended Verification and Validation for Earth System Models    
--------------------------------------------------------------------

  Current run: 2019-08-27 14:16:49
  User: kennedyj
  OS Type: Linux 4.12.14-150.27-default
  Machine: cori07
  

Serving HTTP on 0.0.0.0 port 8080 (http://0.0.0.0:8080/)

View the generated website by navigating to:

    http://0.0.0.0:8080/PGN_P1x1.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID.evv/index.html

Exit by pressing `ctrl+c` to send a keyboard interrupt.
```

You can now either click that link or copy-paste that link into your favorite web 
browser to view the output website.

### View a local copy

For this example, we'll assume the tests were run on Cori at NERSC, but these instructions should be
easily adaptable to any E3SM supported machine. Install `e3sm_simple` locally and activate it:

```
conda create -n e3sm_simple -c conda-forge -c e3sm e3sm-simple
conda activate e3sm_simple
``` 

Then, copy the website to your local machine, and view it: 

```
# on your local machine
scp -r /global/cscratch1/sd/${USER}/acme_scratch/cori-knl/MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID/run/MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID.evv . 
evv -o MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID.evv -s
    --------------------------------------------------------------------
                       ______  __      __ __      __                    
                      |  ____| \ \    / / \ \    / /                    
                      | |__     \ \  / /   \ \  / /                     
                      |  __|     \ \/ /     \ \/ /                      
                      | |____     \  /       \  /                       
                      |______|     \/         \/                        
                                                                        
        Extended Verification and Validation for Earth System Models    
    --------------------------------------------------------------------
    
      Current run: 2018-08-06 15:15:03
      User: ${USER}
      OS Type: Linux 4.15.0-29-generic
      Machine: pc0101123
      
    
    Serving HTTP on 0.0.0.0 port 8000 (http://0.0.0.0:8000/)
    
    View the generated website by navigating to:
    
        http://0.0.0.0:8000/MVK_PL.ne4_ne4.FC5AV1C-L.cori-knl_intel.C.YYYYMMDD_HHMMSS_RANDOMID.evv/index.html
    
    Exit by pressing `ctrl+c` to send a keyboard interrupt.
    
```

You can now either click that link or copy-paste that link into your favorite web 
browser to view the output website.


**Please note:** the output website uses some JavaScript to render elements of the page (especially figures), 
and opening up the `index.html` file using the `file://` protocol in a web browser will likely not work 
well (most browser have stopped allowing access to "local resources" like JavaScript through the `file://` 
protocol). You can view the website by either copying it to a hosted location (`~/WWW` which is hosted at 
`http://users.nccs.gov/~user` on Titan, for example) or copying it to your local machine and running a 
local http server (included in python!) and viewing it through an address like `http://0.0.0.0:8000/index.html`.  