# FATES Community Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors, maintainers, and users pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.  As the project is based around a science tool, we also pledge to support scientific norms of crediting intellectual contributions made by community members.

## Our Standards

Examples of behavior that contributes to creating a positive environment include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others’ private information, such as a physical or electronic address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Scientific Use and Publication Ethics

We aim to create an open development environment for FATES where scientists can be confident that all members of the community are conducting research in an ethical manner. In particular, writing scientific code is a form of intellectual contribution, and one should expect that all such intellectual contributions are respected and given credit in any resulting published scientific work. To support the FATES community and avoid issues of scientific misconduct related to the above principle, please respect the following rules:
 
* Document the version of the code used in any publication, preferably by  using a release tag (existing or newly created) if possible, or a commit hash if not.
* Do not use code from anywhere other than the central FATES development repository (the “master” branch of the “NGEET/fates“ github repository) without discussing with the author(s) of the modified code your intentions for using the code and receiving their permission to do so.
* When using model features that have recently been integrated into the central FATES development repository, be mindful of the contributions of others and, where the novel features qualitatively affect the results of a given simulation, involve the author(s) of these features in any resulting manuscripts.  Be particularly aware of the concerns of early career researchers, and ensure they have sufficient opportunities to lead publications using their developments.
* When discussing results arising from older model features that have been described in the literature, accurately cite the publications describing those features or releases. A list of some relevant publications can be found at [https://github.com/NGEET/fates/wiki/Relevant-References][wiki_ref_page]

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, unethical, or otherwise unacceptable behavior may be reported by contacting the project team at fates_core@googlegroups.com. All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project’s leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
[wiki_ref_page]: https://github.com/NGEET/fates/wiki/Relevant-References
