# Steps for interpolating out-of-the-box initial conditions

These are the steps that should be taken when interpolating (via
`init_interp`) out-of-the-box initial conditions files. This is often done
so that we'll have out-of-the-box initial conditions files that are
compatible with the current memory allocation, etc. (thus not requiring
`init_interp` to be run all the time).

Do the following for each initial conditions file you want to
interpolate:

1. From the latest master tag, create and run a test using the
   appropriate compset and resolution for this initial conditions
   file. Note that there may be other options (like carbon isotopes)
   that also need to be turned on. While doing this, generate
   baselines. e.g., run
   `SMS_Ld1.f09_g17.I1850Clm50Sp.cheyenne_intel.clm-default` or
   `SMS_Ld1.f09_g17.I1850Clm50BgcCrop.cheyenne_intel.clm-ciso`, with
   baseline generation.
   
   - Confirm that the test points to the desired, original finidat file,
     and that `use_init_interp` is .true. by default.
     
2. Rename the `finidat_interp_dest.nc` file that was generated by this
   test, giving it a name that matches the original initial conditions
   file, but with a new date stamp. Move this file into place
   (`$CESMDATAROOT/inputdata/lnd/clm2/initdata_map/`).

3. Add global metadata to the new file, mentioning the original file,
   the test used to generate this new file, the tag used to run this
   test, and a summary of what is different on this new version. For
   example:
   
   ```
   ncatted -h -a Notes_190111,global,c,c,'Interpolated from clmi.I1850Clm50BgcCrop.1366-01-01.0.9x1.25_gx1v6_simyr1850_c171213.nc. This is the finidat_interp_dest.nc file from SMS_Ln1.f09_g17.I1850Clm50BgcCrop.cheyenne_intel, run from ctsm1.0.dev022. Updates from the previous file are: (1) uses gx1v7 rather than gx1v6; (2) many inactive points are absent.'
   ```
   
4. Using `ncdump -h`, diff the headers of the new and old files, and
   make sure that there are no unexpected differences. Especially look
   for missing fields on the new file, which could indicate, for
   example, that carbon isotopes were turned on in the original run but
   not in your new run.
   
5. Update `namelist_defaults_ctsm.xml` to point to the new file.

   - Be sure to change any attributes in both the `finidat` entry and
     the `init_interp_attributes` entry for this file. In particular, if
     the old file had the attribute `use_init_interp=".true."`, this
     should now be removed.
     
6. Rerun the one-day test for which you generated baselines, comparing
   against these baselines. Check the following:
   
   - `use_init_interp` should be .false.
   
   - The test should use the new `finidat` file
   
   - The test should pass and be bit-for-bit with the baseline
