## How to contribute:

We recommend that you first open an issue (https://github.com/escomp/ctsm/issues/) to
discuss the changes or additions that you propose. Through the issue discussion, you can
work with other CTSM developers to think about the design and implementation of the changes
as well as the planning and scheduling for the change to come into CTSM. An alternative is
to contact the key software and science developers via ctsm-software@ucar.edu. Making
contact early in your project will increase the likelihood that your developments can come
into CTSM.

We also recommend that you join the ctsm-dev@ucar.edu google groups in order 
to be informed about the science that is happening in CTSM as well as the latest developments and tags.
The ctsm-dev group is here:

https://groups.google.com/a/ucar.edu/forum/#!forum/ctsm-dev

Use the help from the wiki below to setup a fork and personal branch in GitHub to put your developments
on and keep up to date with the master branch of CTSM. Once the changes are sufficiently advanced you
can form a Pull Request on GitHub. Either from your fork on GitHub, or from the main ESCOMP GitHub page
for CTSM (be sure to hit the "compare across forks" link at the top of the page when you first create
the pull request).

https://github.com/ESCOMP/ctsm/pulls

This allows you to show your proposed changes and start getting feedback on them (even if they aren't finished). 
This also allows your changes to be planned for and slated for a time to come into CTSM master. In most 
cases you won't merge the Pull Request yourself, but a software engineer responsible for CTSM will do 
additional testing and bring the changes to CTSM master.

### CTSM Developers Guide:

 https://wiki.ucar.edu/display/ccsm/Community+Land+Model+Developers+Guide

## Getting Started:

The following resources give you information on the project and how to get started.

#### CTSM Wiki:

https://github.com/ESCOMP/ctsm/wiki

#### Coding Practices and Style:

Code conventions: https://github.com/ESCOMP/ctsm/wiki/CTSM-coding-guidelines

#### Code of Conduct:

See the `CODE_OF_CONDUCT.md` file for expectations of how to work in the community.
