
      module mo_sim_dat

      private
      public :: set_sim_dat

      contains

      subroutine set_sim_dat

      use chem_mods,     only : clscnt, cls_rxt_cnt, clsmap, permute, adv_mass, fix_mass, crb_mass
      use chem_mods,     only : diag_map
      use chem_mods,     only : phtcnt, rxt_tag_cnt, rxt_tag_lst, rxt_tag_map
      use chem_mods,     only : pht_alias_lst, pht_alias_mult
      use chem_mods,     only : extfrc_lst, inv_lst, slvd_lst
      use chem_mods,     only : enthalpy_cnt, cph_enthalpy, cph_rid, num_rnts, rxntot
      use cam_abortutils,only : endrun
      use mo_tracname,   only : solsym
      use chem_mods,     only : frc_from_dataset
      use chem_mods,     only : is_scalar, is_vector
      use shr_kind_mod,  only : r8 => shr_kind_r8
      use cam_logfile,   only : iulog

      implicit none

!--------------------------------------------------------------
!      ... local variables
!--------------------------------------------------------------
      integer :: ios

      is_scalar = .false.
      is_vector = .true.

      clscnt(:) = (/     31,     0,     0,   201,     0 /)

      cls_rxt_cnt(:,1) = (/     37,    63,     0,    31 /)
      cls_rxt_cnt(:,4) = (/     30,   195,   353,   201 /)

      solsym(:232) = (/ 'ALKNIT          ','ALKOOH          ','AOA_NH          ','bc_a1           ','bc_a4           ', &
                        'BCARY           ','BENZENE         ','BENZOOH         ','BEPOMUC         ','BIGALD          ', &
                        'BIGALD1         ','BIGALD2         ','BIGALD3         ','BIGALD4         ','BIGALK          ', &
                        'BIGENE          ','BR              ','BRCL            ','BRO             ','BRONO2          ', &
                        'BRY             ','BZALD           ','BZOOH           ','C2H2            ','C2H4            ', &
                        'C2H5OH          ','C2H5OOH         ','C2H6            ','C3H6            ','C3H7OOH         ', &
                        'C3H8            ','C6H5OOH         ','CCL4            ','CF2CLBR         ','CF3BR           ', &
                        'CFC11           ','CFC113          ','CFC114          ','CFC115          ','CFC12           ', &
                        'CH2BR2          ','CH2O            ','CH3BR           ','CH3CCL3         ','CH3CHO          ', &
                        'CH3CL           ','CH3CN           ','CH3COCH3        ','CH3COCHO        ','CH3COOH         ', &
                        'CH3COOOH        ','CH3OH           ','CH3OOH          ','CH4             ','CHBR3           ', &
                        'CL              ','CL2             ','CL2O2           ','CLO             ','CLONO2          ', &
                        'CLY             ','CO              ','CO2             ','COF2            ','COFCL           ', &
                        'CRESOL          ','DMS             ','dst_a1          ','dst_a2          ','dst_a3          ', &
                        'E90             ','EOOH            ','F               ','GLYALD          ','GLYOXAL         ', &
                        'H               ','H2              ','H2402           ','H2O2            ','H2SO4           ', &
                        'HBR             ','HCFC141B        ','HCFC142B        ','HCFC22          ','HCL             ', &
                        'HCN             ','HCOOH           ','HF              ','HNO3            ','HO2NO2          ', &
                        'HOBR            ','HOCL            ','HONITR          ','HPALD           ','HYAC            ', &
                        'HYDRALD         ','IEPOX           ','ISOP            ','ISOPNITA        ','ISOPNITB        ', &
                        'ISOPNO3         ','ISOPNOOH        ','ISOPOOH         ','IVOC            ','MACR            ', &
                        'MACROOH         ','MEK             ','MEKOOH          ','MPAN            ','MTERP           ', &
                        'MVK             ','N               ','N2O             ','N2O5            ','NC4CH2OH        ', &
                        'NC4CHO          ','ncl_a1          ','ncl_a2          ','ncl_a3          ','NH3             ', &
                        'NH4             ','NH_5            ','NH_50           ','NO              ','NO2             ', &
                        'NO3             ','NOA             ','NTERPOOH        ','num_a1          ','num_a2          ', &
                        'num_a3          ','num_a4          ','O               ','O2              ','O3              ', &
                        'O3S             ','OCLO            ','OCS             ','ONITR           ','PAN             ', &
                        'PBZNIT          ','PHENO           ','PHENOL          ','PHENOOH         ','pom_a1          ', &
                        'pom_a4          ','POOH            ','ROOH            ','S               ','SF6             ', &
                        'SO              ','SO2             ','SO3             ','so4_a1          ','so4_a2          ', &
                        'so4_a3          ','soa1_a1         ','soa1_a2         ','soa2_a1         ','soa2_a2         ', &
                        'soa3_a1         ','soa3_a2         ','soa4_a1         ','soa4_a2         ','soa5_a1         ', &
                        'soa5_a2         ','SOAG0           ','SOAG1           ','SOAG2           ','SOAG3           ', &
                        'SOAG4           ','ST80_25         ','SVOC            ','TEPOMUC         ','TERP2OOH        ', &
                        'TERPNIT         ','TERPOOH         ','TERPROD1        ','TERPROD2        ','TOLOOH          ', &
                        'TOLUENE         ','XOOH            ','XYLENES         ','XYLENOOH        ','XYLOL           ', &
                        'XYLOLOOH        ','NHDEP           ','NDEP            ','ACBZO2          ','ALKO2           ', &
                        'BENZO2          ','BZOO            ','C2H5O2          ','C3H7O2          ','C6H5O2          ', &
                        'CH3CO3          ','CH3O2           ','DICARBO2        ','e               ','ENEO2           ', &
                        'EO              ','EO2             ','HO2             ','HOCH2OO         ','ISOPAO2         ', &
                        'ISOPBO2         ','MACRO2          ','MALO2           ','MCO3            ','MDIALO2         ', &
                        'MEKO2           ','N2D             ','N2p             ','NOp             ','Np              ', &
                        'NTERPO2         ','O1D             ','O2_1D           ','O2_1S           ','O2p             ', &
                        'OH              ','Op              ','PHENO2          ','PO2             ','RO2             ', &
                        'TERP2O2         ','TERPO2          ','TOLO2           ','XO2             ','XYLENO2         ', &
                        'XYLOLO2         ','H2O             ' /)

      adv_mass(:232) = (/   133.141340_r8,   104.142600_r8,    28.010400_r8,    12.011000_r8,    12.011000_r8, &
                            204.342600_r8,    78.110400_r8,   160.122200_r8,   126.108600_r8,    98.098200_r8, &
                             84.072400_r8,    98.098200_r8,    98.098200_r8,   112.124000_r8,    72.143800_r8, &
                             56.103200_r8,    79.904000_r8,   115.356700_r8,    95.903400_r8,   141.908940_r8, &
                             99.716850_r8,   106.120800_r8,   124.135000_r8,    26.036800_r8,    28.051600_r8, &
                             46.065800_r8,    62.065200_r8,    30.066400_r8,    42.077400_r8,    76.091000_r8, &
                             44.092200_r8,   110.109200_r8,   153.821800_r8,   165.364506_r8,   148.910210_r8, &
                            137.367503_r8,   187.375310_r8,   170.921013_r8,   154.466716_r8,   120.913206_r8, &
                            173.833800_r8,    30.025200_r8,    94.937200_r8,   133.402300_r8,    44.051000_r8, &
                             50.485900_r8,    41.050940_r8,    58.076800_r8,    72.061400_r8,    60.050400_r8, &
                             76.049800_r8,    32.040000_r8,    48.039400_r8,    16.040600_r8,   252.730400_r8, &
                             35.452700_r8,    70.905400_r8,   102.904200_r8,    51.452100_r8,    97.457640_r8, &
                            100.916850_r8,    28.010400_r8,    44.009800_r8,    66.007206_r8,    82.461503_r8, &
                            108.135600_r8,    62.132400_r8,   135.064039_r8,   135.064039_r8,   135.064039_r8, &
                             28.010400_r8,    78.064600_r8,    18.998403_r8,    60.050400_r8,    58.035600_r8, &
                              1.007400_r8,     2.014800_r8,   259.823613_r8,    34.013600_r8,    98.078400_r8, &
                             80.911400_r8,   116.948003_r8,   100.493706_r8,    86.467906_r8,    36.460100_r8, &
                             27.025140_r8,    46.024600_r8,    20.005803_r8,    63.012340_r8,    79.011740_r8, &
                             96.910800_r8,    52.459500_r8,   135.114940_r8,   116.112400_r8,    74.076200_r8, &
                            100.113000_r8,   118.127200_r8,    68.114200_r8,   147.125940_r8,   147.125940_r8, &
                            162.117940_r8,   163.125340_r8,   118.127200_r8,   184.350200_r8,    70.087800_r8, &
                            120.100800_r8,    72.102600_r8,   104.101400_r8,   147.084740_r8,   136.228400_r8, &
                             70.087800_r8,    14.006740_r8,    44.012880_r8,   108.010480_r8,   147.125940_r8, &
                            145.111140_r8,    58.442468_r8,    58.442468_r8,    58.442468_r8,    17.028940_r8, &
                             18.036340_r8,    28.010400_r8,    28.010400_r8,    30.006140_r8,    46.005540_r8, &
                             62.004940_r8,   119.074340_r8,   231.239540_r8,     1.007400_r8,     1.007400_r8, &
                              1.007400_r8,     1.007400_r8,    15.999400_r8,    31.998800_r8,    47.998200_r8, &
                             47.998200_r8,    67.451500_r8,    60.076400_r8,   133.100140_r8,   121.047940_r8, &
                            183.117740_r8,    93.102400_r8,    94.109800_r8,   176.121600_r8,    12.011000_r8, &
                             12.011000_r8,    92.090400_r8,    90.075600_r8,    32.066000_r8,   146.056419_r8, &
                             48.065400_r8,    64.064800_r8,    80.064200_r8,   115.107340_r8,   115.107340_r8, &
                            115.107340_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8, &
                            250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8, &
                            250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8,   250.445000_r8, &
                            250.445000_r8,    28.010400_r8,   310.582400_r8,   140.134400_r8,   200.226000_r8, &
                            215.240140_r8,   186.241400_r8,   168.227200_r8,   154.201400_r8,   174.148000_r8, &
                             92.136200_r8,   150.126000_r8,   106.162000_r8,   188.173800_r8,   122.161400_r8, &
                            204.173200_r8,    14.006740_r8,    14.006740_r8,   137.112200_r8,   103.135200_r8, &
                            159.114800_r8,   123.127600_r8,    61.057800_r8,    75.083600_r8,   109.101800_r8, &
                             75.042400_r8,    47.032000_r8,   129.089600_r8, 0.548567E-03_r8,   105.108800_r8, &
                             61.057800_r8,    77.057200_r8,    33.006200_r8,    63.031400_r8,   117.119800_r8, &
                            117.119800_r8,   119.093400_r8,   115.063800_r8,   101.079200_r8,   117.078600_r8, &
                            103.094000_r8,    14.006740_r8,    28.013480_r8,    30.006140_r8,    14.006740_r8, &
                            230.232140_r8,    15.999400_r8,    31.998800_r8,    31.998800_r8,    31.998800_r8, &
                             17.006800_r8,    15.999400_r8,   175.114200_r8,    91.083000_r8,    89.068200_r8, &
                            199.218600_r8,   185.234000_r8,   173.140600_r8,   149.118600_r8,   187.166400_r8, &
                            203.165800_r8,    18.014200_r8 /)

      crb_mass(:232) = (/    60.055000_r8,    60.055000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                            180.165000_r8,    72.066000_r8,    72.066000_r8,    72.066000_r8,    60.055000_r8, &
                             48.044000_r8,    60.055000_r8,    60.055000_r8,    72.066000_r8,    60.055000_r8, &
                             48.044000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    84.077000_r8,    84.077000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    72.066000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    24.022000_r8,    24.022000_r8, &
                             12.011000_r8,    24.022000_r8,    36.033000_r8,    36.033000_r8,    24.022000_r8, &
                             24.022000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             84.077000_r8,    24.022000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                             12.011000_r8,    24.022000_r8,     0.000000_r8,    24.022000_r8,    24.022000_r8, &
                              0.000000_r8,     0.000000_r8,    24.022000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    24.022000_r8,    24.022000_r8,    12.011000_r8,     0.000000_r8, &
                             12.011000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    48.044000_r8,    60.055000_r8,    36.033000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,   156.143000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,   120.110000_r8, &
                             48.044000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    60.055000_r8, &
                             60.055000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    36.033000_r8,   120.110000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    12.011000_r8,    48.044000_r8,    24.022000_r8, &
                             84.077000_r8,    72.066000_r8,    72.066000_r8,    72.066000_r8,    12.011000_r8, &
                             12.011000_r8,    36.033000_r8,    36.033000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8, &
                            180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8, &
                            180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8,   180.165000_r8, &
                            180.165000_r8,    12.011000_r8,   264.242000_r8,    84.077000_r8,   120.110000_r8, &
                            120.110000_r8,   120.110000_r8,   120.110000_r8,   108.099000_r8,    84.077000_r8, &
                             84.077000_r8,    60.055000_r8,    96.088000_r8,    96.088000_r8,    96.088000_r8, &
                             96.088000_r8,     0.000000_r8,     0.000000_r8,    84.077000_r8,    60.055000_r8, &
                             72.066000_r8,    84.077000_r8,    24.022000_r8,    36.033000_r8,    72.066000_r8, &
                             24.022000_r8,    12.011000_r8,    60.055000_r8,     0.000000_r8,    48.044000_r8, &
                             24.022000_r8,    24.022000_r8,     0.000000_r8,    12.011000_r8,    60.055000_r8, &
                             60.055000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                            120.110000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    72.066000_r8,    36.033000_r8,    36.033000_r8, &
                            120.110000_r8,   120.110000_r8,    84.077000_r8,    60.055000_r8,    96.088000_r8, &
                             96.088000_r8,     0.000000_r8 /)

      fix_mass(:  2) = (/ 0.00000000_r8, 28.0134800_r8 /)

      clsmap(: 31,1) = (/    3,  21,  33,  34,  35,  36,  37,  38,  39,  40, &
                            41,  43,  44,  46,  54,  55,  61,  63,  71,  78, &
                            82,  83,  84, 113, 122, 123, 150, 172, 187, 188, &
                           136 /)
      clsmap(:201,4) = (/    1,   2,   4,   5,   6,   7,   8,   9,  10,  11, &
                            12,  13,  14,  15,  16,  17,  18,  19,  20,  22, &
                            23,  24,  25,  26,  27,  28,  29,  30,  31,  32, &
                            42,  45,  47,  48,  49,  50,  51,  52,  53,  56, &
                            57,  58,  59,  60,  62,  64,  65,  66,  67,  68, &
                            69,  70,  72,  73,  74,  75,  76,  77,  79,  80, &
                            81,  85,  86,  87,  88,  89,  90,  91,  92,  93, &
                            94,  95,  96,  97,  98,  99, 100, 101, 102, 103, &
                           104, 105, 106, 107, 108, 109, 110, 111, 112, 114, &
                           115, 116, 117, 118, 119, 120, 121, 124, 125, 126, &
                           127, 128, 129, 130, 131, 132, 133, 134, 135, 137, &
                           138, 139, 140, 141, 142, 143, 144, 145, 146, 147, &
                           148, 149, 151, 152, 153, 154, 155, 156, 157, 158, &
                           159, 160, 161, 162, 163, 164, 165, 166, 167, 168, &
                           169, 170, 171, 173, 174, 175, 176, 177, 178, 179, &
                           180, 181, 182, 183, 184, 185, 186, 189, 190, 191, &
                           192, 193, 194, 195, 196, 197, 198, 199, 200, 201, &
                           202, 203, 204, 205, 206, 207, 208, 209, 210, 211, &
                           212, 213, 214, 215, 216, 217, 218, 219, 220, 221, &
                           222, 223, 224, 225, 226, 227, 228, 229, 230, 231, &
                           232 /)

      permute(:201,4) = (/  123, 124,   1,   2, 153,  48,  84,  49,  85,  95, &
                             70, 118,  76,  62,  82, 184,  63, 198, 110,  64, &
                             79,  71, 112,  66,  80,  72, 160,  89,  39,  67, &
                            193, 170,  38, 156, 175, 111, 105, 140,  90, 188, &
                             47,  36, 200, 157, 165,  40,  51,  54,  69,   3, &
                              4,   5,  41, 136, 161, 149, 195, 172, 115,  42, &
                            145, 183,  52, 141,  59, 196,  99, 134, 146, 162, &
                             60, 164,  73,  43, 148, 119, 108, 173,  88, 127, &
                             34, 174,  74, 107,  75, 114, 151, 179, 144,  68, &
                             83, 159,   6,   7,   8,  37,   9, 187, 197, 194, &
                            147,  86,  10,  11,  12,  13, 192, 186, 191,  77, &
                             81,  61,  97,  44,  98,  50,  78,  14,  15, 109, &
                             87, 129, 182, 155,  65,  16,  17,  18,  19,  20, &
                             21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                             31,  32,  33,  35,  55, 116, 121, 100, 158, 163, &
                            117,  53,  56,  57, 128,  58,  91, 104, 154, 101, &
                             92, 152, 143, 122, 181, 185, 133, 139, 113,  96, &
                            135, 199,  93, 176, 177, 178, 130, 180, 150, 125, &
                            106, 126, 138, 102, 168, 189,  45,  46, 137, 190, &
                            120,  94, 142, 169, 167, 166, 131, 171, 132, 103, &
                            201 /)

      diag_map(:201) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                            11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                            21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                            31,  32,  33,  39,  45,  46,  49,  52,  55,  59, &
                            62,  65,  68,  71,  74,  77,  79,  86,  92,  96, &
                           101, 105, 114, 121, 126, 130, 139, 147, 152, 155, &
                           160, 163, 166, 169, 173, 177, 181, 185, 191, 197, &
                           200, 206, 212, 215, 220, 225, 230, 235, 241, 246, &
                           251, 259, 267, 273, 279, 285, 291, 297, 303, 309, &
                           315, 323, 329, 336, 342, 345, 350, 357, 361, 368, &
                           377, 384, 392, 400, 406, 412, 417, 422, 430, 438, &
                           446, 450, 458, 466, 474, 481, 492, 501, 505, 514, &
                           521, 529, 536, 547, 558, 567, 578, 589, 600, 607, &
                           618, 634, 645, 654, 664, 673, 681, 690, 701, 708, &
                           712, 717, 728, 744, 753, 762, 769, 781, 798, 803, &
                           820, 840, 858, 880, 892, 898, 906, 916, 928, 943, &
                           960, 968, 982, 991, 997,1008,1030,1049,1065,1076, &
                          1091,1104,1124,1140,1152,1172,1206,1231,1251,1271, &
                          1302,1318,1337,1352,1396,1427,1507,1543,1570,1719, &
                          1782,1824,1849,1907,1928,1951,1994,2019,2115,2143, &
                          2170 /)

      extfrc_lst(: 23) = (/ 'NO2             ','NO              ','CO              ','SO2             ','SVOC            ', &
                            'so4_a1          ','so4_a2          ','pom_a1          ','pom_a4          ','num_a1          ', &
                            'num_a2          ','num_a4          ','bc_a1           ','bc_a4           ','AOA_NH          ', &
                            'O2p             ','Np              ','N2p             ','N2D             ','e               ', &
                            'N               ','OH              ','Op              ' /)

      frc_from_dataset(: 23) = (/ .true., .true., .true., .true., .true., &
                                  .true., .true., .true., .true., .true., &
                                  .true., .true., .true., .true., .false., &
                                  .false., .false., .false., .false., .false., &
                                  .false., .false., .false. /)

      inv_lst(:  2) = (/ 'M               ', 'N2              ' /)

      slvd_lst(: 43) = (/ 'ACBZO2          ', 'ALKO2           ', 'BENZO2          ', 'BZOO            ', 'C2H5O2          ', &
                          'C3H7O2          ', 'C6H5O2          ', 'CH3CO3          ', 'CH3O2           ', 'DICARBO2        ', &
                          'e               ', 'ENEO2           ', 'EO              ', 'EO2             ', 'HO2             ', &
                          'HOCH2OO         ', 'ISOPAO2         ', 'ISOPBO2         ', 'MACRO2          ', 'MALO2           ', &
                          'MCO3            ', 'MDIALO2         ', 'MEKO2           ', 'N2D             ', 'N2p             ', &
                          'NOp             ', 'Np              ', 'NTERPO2         ', 'O1D             ', 'O2_1D           ', &
                          'O2_1S           ', 'O2p             ', 'OH              ', 'Op              ', 'PHENO2          ', &
                          'PO2             ', 'RO2             ', 'TERP2O2         ', 'TERPO2          ', 'TOLO2           ', &
                          'XO2             ', 'XYLENO2         ', 'XYLOLO2         ' /)

      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(     1:   200) = (/ 'jh2o_b                          ', 'jh2o_c                          ', &
                                      'jh2o_a                          ', 'jh2o2                           ', &
                                      'jo2_b                           ', 'jo2_a                           ', &
                                      'jo3_a                           ', 'jo3_b                           ', &
                                      'jhno3                           ', 'jho2no2_a                       ', &
                                      'jho2no2_b                       ', 'jn2o                            ', &
                                      'jn2o5_a                         ', 'jn2o5_b                         ', &
                                      'jno                             ', 'jno_i                           ', &
                                      'jno2                            ', 'jno3_a                          ', &
                                      'jno3_b                          ', 'jalknit                         ', &
                                      'jalkooh                         ', 'jbenzooh                        ', &
                                      'jbepomuc                        ', 'jbigald                         ', &
                                      'jbigald1                        ', 'jbigald2                        ', &
                                      'jbigald3                        ', 'jbigald4                        ', &
                                      'jbzooh                          ', 'jc2h5ooh                        ', &
                                      'jc3h7ooh                        ', 'jc6h5ooh                        ', &
                                      'jch2o_a                         ', 'jch2o_b                         ', &
                                      'jch3cho                         ', 'jacet                           ', &
                                      'jmgly                           ', 'jch3co3h                        ', &
                                      'jch3ooh                         ', 'jch4_a                          ', &
                                      'jch4_b                          ', 'jco2                            ', &
                                      'jeooh                           ', 'jglyald                         ', &
                                      'jglyoxal                        ', 'jhonitr                         ', &
                                      'jhpald                          ', 'jhyac                           ', &
                                      'jisopnooh                       ', 'jisopooh                        ', &
                                      'jmacr_a                         ', 'jmacr_b                         ', &
                                      'jmek                            ', 'jmekooh                         ', &
                                      'jmpan                           ', 'jmvk                            ', &
                                      'jnc4cho                         ', 'jnoa                            ', &
                                      'jnterpooh                       ', 'jonitr                          ', &
                                      'jpan                            ', 'jphenooh                        ', &
                                      'jpooh                           ', 'jrooh                           ', &
                                      'jtepomuc                        ', 'jterp2ooh                       ', &
                                      'jterpnit                        ', 'jterpooh                        ', &
                                      'jterprd1                        ', 'jterprd2                        ', &
                                      'jtolooh                         ', 'jxooh                           ', &
                                      'jxylenooh                       ', 'jxylolooh                       ', &
                                      'jbrcl                           ', 'jbro                            ', &
                                      'jbrono2_b                       ', 'jbrono2_a                       ', &
                                      'jccl4                           ', 'jcf2clbr                        ', &
                                      'jcf3br                          ', 'jcfcl3                          ', &
                                      'jcfc113                         ', 'jcfc114                         ', &
                                      'jcfc115                         ', 'jcf2cl2                         ', &
                                      'jch2br2                         ', 'jch3br                          ', &
                                      'jch3ccl3                        ', 'jch3cl                          ', &
                                      'jchbr3                          ', 'jcl2                            ', &
                                      'jcl2o2                          ', 'jclo                            ', &
                                      'jclono2_a                       ', 'jclono2_b                       ', &
                                      'jcof2                           ', 'jcofcl                          ', &
                                      'jh2402                          ', 'jhbr                            ', &
                                      'jhcfc141b                       ', 'jhcfc142b                       ', &
                                      'jhcfc22                         ', 'jhcl                            ', &
                                      'jhf                             ', 'jhobr                           ', &
                                      'jhocl                           ', 'joclo                           ', &
                                      'jsf6                            ', 'jeuv_26                         ', &
                                      'jeuv_4                          ', 'jeuv_13                         ', &
                                      'jeuv_11                         ', 'jeuv_6                          ', &
                                      'jeuv_10                         ', 'jeuv_22                         ', &
                                      'jeuv_23                         ', 'jeuv_25                         ', &
                                      'jeuv_18                         ', 'jeuv_2                          ', &
                                      'jeuv_1                          ', 'jeuv_16                         ', &
                                      'jeuv_15                         ', 'jeuv_14                         ', &
                                      'jeuv_3                          ', 'jeuv_17                         ', &
                                      'jeuv_9                          ', 'jeuv_8                          ', &
                                      'jeuv_7                          ', 'jeuv_5                          ', &
                                      'jeuv_19                         ', 'jeuv_20                         ', &
                                      'jeuv_21                         ', 'jeuv_24                         ', &
                                      'jeuv_12                         ', 'jh2so4                          ', &
                                      'jocs                            ', 'jso                             ', &
                                      'jso2                            ', 'jso3                            ', &
                                      'jsoa1_a1                        ', 'jsoa1_a2                        ', &
                                      'jsoa2_a1                        ', 'jsoa2_a2                        ', &
                                      'jsoa3_a1                        ', 'jsoa3_a2                        ', &
                                      'jsoa4_a1                        ', 'jsoa4_a2                        ', &
                                      'jsoa5_a1                        ', 'jsoa5_a2                        ', &
                                      'ag1                             ', 'ag2                             ', &
                                      'O1D_H2                          ', 'O1D_H2O                         ', &
                                      'O1D_N2                          ', 'O1D_O2                          ', &
                                      'O1D_O2b                         ', 'O1D_O3                          ', &
                                      'O2_1D_N2                        ', 'O2_1D_O                         ', &
                                      'O2_1D_O2                        ', 'O2_1S_CO2                       ', &
                                      'O2_1S_N2                        ', 'O2_1S_O                         ', &
                                      'O2_1S_O2                        ', 'O2_1S_O3                        ', &
                                      'O_O3                            ', 'usr_O_O                         ', &
                                      'usr_O_O2                        ', 'H2_O                            ', &
                                      'H2O2_O                          ', 'H_HO2                           ', &
                                      'H_HO2a                          ', 'H_HO2b                          ', &
                                      'H_O2                            ', 'HO2_O                           ', &
                                      'HO2_O3                          ', 'H_O3                            ', &
                                      'OH_H2                           ', 'OH_H2O2                         ', &
                                      'OH_HO2                          ', 'OH_O                            ', &
                                      'OH_O3                           ', 'OH_OH                           ', &
                                      'OH_OH_M                         ', 'usr_HO2_HO2                     ', &
                                      'HO2NO2_OH                       ', 'N2D_O                           ', &
                                      'N2D_O2                          ', 'N_NO                            ', &
                                      'N_NO2a                          ', 'N_NO2b                          ', &
                                      'N_NO2c                          ', 'N_O2                            ', &
                                      'NO2_O                           ', 'NO2_O3                          ', &
                                      'NO2_O_M                         ', 'NO3_HO2                         ', &
                                      'NO3_NO                          ', 'NO3_O                           ' /)
      rxt_tag_lst(   201:   400) = (/ 'NO3_OH                          ', 'N_OH                            ', &
                                      'NO_HO2                          ', 'NO_O3                           ', &
                                      'NO_O_M                          ', 'O1D_N2Oa                        ', &
                                      'O1D_N2Ob                        ', 'tag_NO2_HO2                     ', &
                                      'tag_NO2_NO3                     ', 'tag_NO2_OH                      ', &
                                      'usr_HNO3_OH                     ', 'usr_HO2NO2_M                    ', &
                                      'usr_N2O5_M                      ', 'CL_CH2O                         ', &
                                      'CL_CH4                          ', 'CL_H2                           ', &
                                      'CL_H2O2                         ', 'CL_HO2a                         ', &
                                      'CL_HO2b                         ', 'CL_O3                           ', &
                                      'CLO_CH3O2                       ', 'CLO_CLOa                        ', &
                                      'CLO_CLOb                        ', 'CLO_CLOc                        ', &
                                      'CLO_HO2                         ', 'CLO_NO                          ', &
                                      'CLONO2_CL                       ', 'CLO_NO2_M                       ', &
                                      'CLONO2_O                        ', 'CLONO2_OH                       ', &
                                      'CLO_O                           ', 'CLO_OHa                         ', &
                                      'CLO_OHb                         ', 'HCL_O                           ', &
                                      'HCL_OH                          ', 'HOCL_CL                         ', &
                                      'HOCL_O                          ', 'HOCL_OH                         ', &
                                      'O1D_CCL4                        ', 'O1D_CF2CLBR                     ', &
                                      'O1D_CFC11                       ', 'O1D_CFC113                      ', &
                                      'O1D_CFC114                      ', 'O1D_CFC115                      ', &
                                      'O1D_CFC12                       ', 'O1D_HCLa                        ', &
                                      'O1D_HCLb                        ', 'tag_CLO_CLO_M                   ', &
                                      'usr_CL2O2_M                     ', 'BR_CH2O                         ', &
                                      'BR_HO2                          ', 'BR_O3                           ', &
                                      'BRO_BRO                         ', 'BRO_CLOa                        ', &
                                      'BRO_CLOb                        ', 'BRO_CLOc                        ', &
                                      'BRO_HO2                         ', 'BRO_NO                          ', &
                                      'BRO_NO2_M                       ', 'BRONO2_O                        ', &
                                      'BRO_O                           ', 'BRO_OH                          ', &
                                      'HBR_O                           ', 'HBR_OH                          ', &
                                      'HOBR_O                          ', 'O1D_CF3BR                       ', &
                                      'O1D_CHBR3                       ', 'O1D_H2402                       ', &
                                      'O1D_HBRa                        ', 'O1D_HBRb                        ', &
                                      'F_CH4                           ', 'F_H2                            ', &
                                      'F_H2O                           ', 'F_HNO3                          ', &
                                      'O1D_COF2                        ', 'O1D_COFCL                       ', &
                                      'CH2BR2_CL                       ', 'CH2BR2_OH                       ', &
                                      'CH3BR_CL                        ', 'CH3BR_OH                        ', &
                                      'CH3CCL3_OH                      ', 'CH3CL_CL                        ', &
                                      'CH3CL_OH                        ', 'CHBR3_CL                        ', &
                                      'CHBR3_OH                        ', 'HCFC141B_OH                     ', &
                                      'HCFC142B_OH                     ', 'HCFC22_OH                       ', &
                                      'O1D_CH2BR2                      ', 'O1D_CH3BR                       ', &
                                      'O1D_HCFC141B                    ', 'O1D_HCFC142B                    ', &
                                      'O1D_HCFC22                      ', 'CH2O_HO2                        ', &
                                      'CH2O_NO3                        ', 'CH2O_O                          ', &
                                      'CH2O_OH                         ', 'CH3O2_CH3O2a                    ', &
                                      'CH3O2_CH3O2b                    ', 'CH3O2_HO2                       ', &
                                      'CH3O2_NO                        ', 'CH3OH_OH                        ', &
                                      'CH3OOH_OH                       ', 'CH4_OH                          ', &
                                      'CO_OH_M                         ', 'HCN_OH                          ', &
                                      'HCOOH_OH                        ', 'HOCH2OO_HO2                     ', &
                                      'HOCH2OO_M                       ', 'HOCH2OO_NO                      ', &
                                      'O1D_CH4a                        ', 'O1D_CH4b                        ', &
                                      'O1D_CH4c                        ', 'O1D_HCN                         ', &
                                      'usr_CO_OH_b                     ', 'C2H2_CL_M                       ', &
                                      'C2H2_OH_M                       ', 'C2H4_CL_M                       ', &
                                      'C2H4_O3                         ', 'C2H5O2_C2H5O2                   ', &
                                      'C2H5O2_CH3O2                    ', 'C2H5O2_HO2                      ', &
                                      'C2H5O2_NO                       ', 'C2H5OH_OH                       ', &
                                      'C2H5OOH_OH                      ', 'C2H6_CL                         ', &
                                      'C2H6_OH                         ', 'CH3CHO_NO3                      ', &
                                      'CH3CHO_OH                       ', 'CH3CN_OH                        ', &
                                      'CH3CO3_CH3CO3                   ', 'CH3CO3_CH3O2                    ', &
                                      'CH3CO3_HO2                      ', 'CH3CO3_NO                       ', &
                                      'CH3COOH_OH                      ', 'CH3COOOH_OH                     ', &
                                      'EO2_HO2                         ', 'EO2_NO                          ', &
                                      'EO_M                            ', 'EO_O2                           ', &
                                      'GLYALD_OH                       ', 'GLYOXAL_OH                      ', &
                                      'PAN_OH                          ', 'tag_C2H4_OH                     ', &
                                      'tag_CH3CO3_NO2                  ', 'usr_PAN_M                       ', &
                                      'C3H6_NO3                        ', 'C3H6_O3                         ', &
                                      'C3H7O2_CH3O2                    ', 'C3H7O2_HO2                      ', &
                                      'C3H7O2_NO                       ', 'C3H7OOH_OH                      ', &
                                      'C3H8_OH                         ', 'CH3COCHO_NO3                    ', &
                                      'CH3COCHO_OH                     ', 'HYAC_OH                         ', &
                                      'NOA_OH                          ', 'PO2_HO2                         ', &
                                      'PO2_NO                          ', 'POOH_OH                         ', &
                                      'RO2_CH3O2                       ', 'RO2_HO2                         ', &
                                      'RO2_NO                          ', 'ROOH_OH                         ', &
                                      'tag_C3H6_OH                     ', 'usr_CH3COCH3_OH                 ', &
                                      'BIGENE_NO3                      ', 'BIGENE_OH                       ', &
                                      'ENEO2_NO                        ', 'ENEO2_NOb                       ', &
                                      'HONITR_OH                       ', 'MACRO2_CH3CO3                   ', &
                                      'MACRO2_CH3O2                    ', 'MACRO2_HO2                      ', &
                                      'MACRO2_NO3                      ', 'MACRO2_NOa                      ', &
                                      'MACRO2_NOb                      ', 'MACR_O3                         ', &
                                      'MACR_OH                         ', 'MACROOH_OH                      ', &
                                      'MCO3_CH3CO3                     ', 'MCO3_CH3O2                      ', &
                                      'MCO3_HO2                        ', 'MCO3_MCO3                       ', &
                                      'MCO3_NO                         ', 'MCO3_NO3                        ', &
                                      'MEKO2_HO2                       ', 'MEKO2_NO                        ', &
                                      'MEK_OH                          ', 'MEKOOH_OH                       ', &
                                      'MPAN_OH_M                       ', 'MVK_O3                          ', &
                                      'MVK_OH                          ', 'usr_MCO3_NO2                    ', &
                                      'usr_MPAN_M                      ', 'ALKNIT_OH                       ', &
                                      'ALKO2_HO2                       ', 'ALKO2_NO                        ', &
                                      'ALKO2_NOb                       ', 'ALKOOH_OH                       ' /)
      rxt_tag_lst(   401:   583) = (/ 'BIGALK_OH                       ', 'HPALD_OH                        ', &
                                      'HYDRALD_OH                      ', 'IEPOX_OH                        ', &
                                      'ISOPAO2_CH3CO3                  ', 'ISOPAO2_CH3O2                   ', &
                                      'ISOPAO2_HO2                     ', 'ISOPAO2_NO                      ', &
                                      'ISOPAO2_NO3                     ', 'ISOPBO2_CH3CO3                  ', &
                                      'ISOPBO2_CH3O2                   ', 'ISOPBO2_HO2                     ', &
                                      'ISOPBO2_M                       ', 'ISOPBO2_NO                      ', &
                                      'ISOPBO2_NO3                     ', 'ISOPNITA_OH                     ', &
                                      'ISOPNITB_OH                     ', 'ISOP_NO3                        ', &
                                      'ISOPNO3_CH3CO3                  ', 'ISOPNO3_CH3O2                   ', &
                                      'ISOPNO3_HO2                     ', 'ISOPNO3_NO                      ', &
                                      'ISOPNO3_NO3                     ', 'ISOPNOOH_OH                     ', &
                                      'ISOP_O3                         ', 'ISOP_OH                         ', &
                                      'ISOPOOH_OH                      ', 'NC4CH2OH_OH                     ', &
                                      'NC4CHO_OH                       ', 'XO2_CH3CO3                      ', &
                                      'XO2_CH3O2                       ', 'XO2_HO2                         ', &
                                      'XO2_NO                          ', 'XO2_NO3                         ', &
                                      'XOOH_OH                         ', 'ACBZO2_HO2                      ', &
                                      'ACBZO2_NO                       ', 'BENZENE_OH                      ', &
                                      'BENZO2_HO2                      ', 'BENZO2_NO                       ', &
                                      'BENZOOH_OH                      ', 'BZALD_OH                        ', &
                                      'BZOO_HO2                        ', 'BZOOH_OH                        ', &
                                      'BZOO_NO                         ', 'C6H5O2_HO2                      ', &
                                      'C6H5O2_NO                       ', 'C6H5OOH_OH                      ', &
                                      'CRESOL_OH                       ', 'DICARBO2_HO2                    ', &
                                      'DICARBO2_NO                     ', 'DICARBO2_NO2                    ', &
                                      'MALO2_HO2                       ', 'MALO2_NO                        ', &
                                      'MALO2_NO2                       ', 'MDIALO2_HO2                     ', &
                                      'MDIALO2_NO                      ', 'MDIALO2_NO2                     ', &
                                      'PHENO2_HO2                      ', 'PHENO2_NO                       ', &
                                      'PHENOL_OH                       ', 'PHENO_NO2                       ', &
                                      'PHENO_O3                        ', 'PHENOOH_OH                      ', &
                                      'tag_ACBZO2_NO2                  ', 'TOLO2_HO2                       ', &
                                      'TOLO2_NO                        ', 'TOLOOH_OH                       ', &
                                      'TOLUENE_OH                      ', 'usr_PBZNIT_M                    ', &
                                      'XYLENES_OH                      ', 'XYLENO2_HO2                     ', &
                                      'XYLENO2_NO                      ', 'XYLENOOH_OH                     ', &
                                      'XYLOLO2_HO2                     ', 'XYLOLO2_NO                      ', &
                                      'XYLOL_OH                        ', 'XYLOLOOH_OH                     ', &
                                      'BCARY_NO3                       ', 'BCARY_O3                        ', &
                                      'BCARY_OH                        ', 'MTERP_NO3                       ', &
                                      'MTERP_O3                        ', 'MTERP_OH                        ', &
                                      'NTERPO2_CH3O2                   ', 'NTERPO2_HO2                     ', &
                                      'NTERPO2_NO                      ', 'NTERPO2_NO3                     ', &
                                      'NTERPOOH_OH                     ', 'TERP2O2_CH3O2                   ', &
                                      'TERP2O2_HO2                     ', 'TERP2O2_NO                      ', &
                                      'TERP2OOH_OH                     ', 'TERPNIT_OH                      ', &
                                      'TERPO2_CH3O2                    ', 'TERPO2_HO2                      ', &
                                      'TERPO2_NO                       ', 'TERPOOH_OH                      ', &
                                      'TERPROD1_NO3                    ', 'TERPROD1_OH                     ', &
                                      'TERPROD2_OH                     ', 'DMS_NO3                         ', &
                                      'DMS_OHa                         ', 'OCS_O                           ', &
                                      'OCS_OH                          ', 'S_O2                            ', &
                                      'S_O3                            ', 'SO_BRO                          ', &
                                      'SO_CLO                          ', 'S_OH                            ', &
                                      'SO_NO2                          ', 'SO_O2                           ', &
                                      'SO_O3                           ', 'SO_OCLO                         ', &
                                      'SO_OH                           ', 'usr_DMS_OH                      ', &
                                      'usr_SO2_OH                      ', 'usr_SO3_H2O                     ', &
                                      'NH3_OH                          ', 'usr_GLYOXAL_aer                 ', &
                                      'usr_HO2_aer                     ', 'usr_HONITR_aer                  ', &
                                      'usr_ISOPNITA_aer                ', 'usr_ISOPNITB_aer                ', &
                                      'usr_N2O5_aer                    ', 'usr_NC4CH2OH_aer                ', &
                                      'usr_NC4CHO_aer                  ', 'usr_NH4_strat_tau               ', &
                                      'usr_NO2_aer                     ', 'usr_NO3_aer                     ', &
                                      'usr_NTERPOOH_aer                ', 'usr_ONITR_aer                   ', &
                                      'usr_TERPNIT_aer                 ', 'BCARY_NO3_vbs                   ', &
                                      'BCARY_O3_vbs                    ', 'BCARY_OH_vbs                    ', &
                                      'BENZENE_OH_vbs                  ', 'ISOP_NO3_vbs                    ', &
                                      'ISOP_O3_vbs                     ', 'ISOP_OH_vbs                     ', &
                                      'IVOC_OH                         ', 'MTERP_NO3_vbs                   ', &
                                      'MTERP_O3_vbs                    ', 'MTERP_OH_vbs                    ', &
                                      'SVOC_OH                         ', 'TOLUENE_OH_vbs                  ', &
                                      'XYLENES_OH_vbs                  ', 'het1                            ', &
                                      'het10                           ', 'het11                           ', &
                                      'het12                           ', 'het13                           ', &
                                      'het14                           ', 'het15                           ', &
                                      'het16                           ', 'het17                           ', &
                                      'het2                            ', 'het3                            ', &
                                      'het4                            ', 'het5                            ', &
                                      'het6                            ', 'het7                            ', &
                                      'het8                            ', 'het9                            ', &
                                      'elec1                           ', 'elec2                           ', &
                                      'elec3                           ', 'ion_N2p_O2                      ', &
                                      'ion_N2p_Oa                      ', 'ion_N2p_Ob                      ', &
                                      'ion_Np_O                        ', 'ion_Np_O2a                      ', &
                                      'ion_Np_O2b                      ', 'ion_O2p_N                       ', &
                                      'ion_O2p_N2                      ', 'ion_O2p_NO                      ', &
                                      'ion_Op_CO2                      ', 'ion_Op_N2                       ', &
                                      'ion_Op_O2                       ', 'E90_tau                         ', &
                                      'NH_50_tau                       ', 'NH_5_tau                        ', &
                                      'ST80_25_tau                     ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                                       11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                                       21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                                       31,  32,  33,  34,  35,  36,  37,  38,  39,  40, &
                                       41,  42,  43,  44,  45,  46,  47,  48,  49,  50, &
                                       51,  52,  53,  54,  55,  56,  57,  58,  59,  60, &
                                       61,  62,  63,  64,  65,  66,  67,  68,  69,  70, &
                                       71,  72,  73,  74,  75,  76,  77,  78,  79,  80, &
                                       81,  82,  83,  84,  85,  86,  87,  88,  89,  90, &
                                       91,  92,  93,  94,  95,  96,  97,  98,  99, 100, &
                                      101, 102, 103, 104, 105, 106, 107, 108, 109, 110, &
                                      111, 112, 113, 114, 115, 116, 117, 118, 119, 120, &
                                      121, 122, 123, 124, 125, 126, 127, 128, 129, 130, &
                                      131, 132, 133, 134, 135, 136, 137, 138, 139, 140, &
                                      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, &
                                      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, &
                                      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, &
                                      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, &
                                      181, 182, 183, 184, 185, 186, 187, 188, 189, 190, &
                                      191, 192, 193, 194, 195, 196, 197, 198, 199, 200, &
                                      201, 202, 203, 204, 205, 206, 207, 208, 209, 210, &
                                      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, &
                                      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, &
                                      231, 232, 233, 234, 235, 236, 237, 238, 239, 240, &
                                      241, 242, 243, 244, 245, 246, 247, 248, 249, 250, &
                                      251, 252, 253, 254, 255, 256, 257, 258, 259, 260, &
                                      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, &
                                      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, &
                                      281, 282, 283, 284, 285, 286, 287, 288, 289, 290, &
                                      291, 292, 293, 294, 295, 296, 297, 298, 299, 300, &
                                      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, &
                                      311, 312, 313, 314, 315, 316, 317, 318, 319, 320, &
                                      321, 322, 323, 324, 325, 326, 327, 328, 329, 330, &
                                      331, 332, 333, 334, 335, 336, 337, 338, 339, 340, &
                                      341, 342, 343, 344, 345, 346, 347, 348, 349, 350, &
                                      351, 352, 353, 354, 355, 356, 357, 358, 359, 360, &
                                      361, 362, 363, 364, 365, 366, 367, 368, 369, 370, &
                                      371, 372, 373, 374, 375, 376, 377, 378, 379, 380, &
                                      381, 382, 383, 384, 385, 386, 387, 388, 389, 390, &
                                      391, 392, 393, 394, 395, 396, 397, 398, 399, 400, &
                                      401, 402, 403, 404, 405, 406, 407, 408, 409, 410, &
                                      411, 412, 413, 414, 415, 416, 417, 418, 419, 420, &
                                      421, 422, 423, 424, 425, 426, 427, 428, 429, 430, &
                                      431, 432, 433, 434, 435, 436, 437, 438, 439, 440, &
                                      441, 442, 443, 444, 445, 446, 447, 448, 449, 450, &
                                      451, 452, 453, 454, 455, 456, 457, 458, 459, 460, &
                                      461, 462, 463, 464, 465, 466, 467, 468, 469, 470, &
                                      471, 472, 473, 474, 475, 476, 477, 478, 479, 480, &
                                      481, 482, 483, 484, 485, 486, 487, 488, 489, 490, &
                                      491, 492, 493, 494, 495, 496, 497, 498, 499, 500, &
                                      501, 502, 503, 504, 505, 506, 507, 508, 509, 510, &
                                      511, 512, 513, 514, 515, 516, 517, 518, 519, 520, &
                                      521, 522, 523, 524, 525, 526, 527, 528, 529, 530, &
                                      531, 532, 533, 534, 535, 536, 537, 538, 539, 540, &
                                      541, 542, 543, 544, 545, 546, 547, 548, 549, 550, &
                                      551, 552, 553, 554, 555, 556, 557, 558, 559, 560, &
                                      561, 562, 563, 564, 565, 566, 567, 568, 569, 570, &
                                      571, 572, 573, 574, 575, 576, 577, 578, 579, 580, &
                                      581, 582, 583 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ '                ', '                ', '                ', '                ', &
                              'userdefined     ', 'userdefined     ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', 'userdefined     ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ' /)
      pht_alias_lst(:,2) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jno2            ', 'jno2            ', &
                              'jno2            ', 'jno2            ', 'jno2            ', 'jno2            ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', 'jh2o2           ', '                ', '                ', &
                              '                ', '                ', 'jch3ooh         ', '                ', &
                              'jmgly           ', 'jch2o_a         ', 'jno2            ', '                ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', '                ', &
                              'jacet           ', 'jch3ooh         ', 'jpan            ', '                ', &
                              'jch2o_a         ', 'jch2o_a         ', 'jch3ooh         ', 'jch3cho         ', &
                              '                ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jno2            ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3cho         ', 'jch3cho         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              'jno2            ', 'jno2            ', 'jno2            ', 'jno2            ', &
                              'jno2            ', 'jno2            ', 'jno2            ', 'jno2            ', &
                              'jno2            ', 'jno2            ' /)
      pht_alias_mult(:,1) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8 /)
      pht_alias_mult(:,2) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, .10_r8, 0.2_r8, .14_r8, &
                          .20_r8, .20_r8, .006_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 0.28_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, .006_r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, .10_r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          .0004_r8, .0004_r8, .0004_r8, .0004_r8, .0004_r8, &
                          .0004_r8, .0004_r8, .0004_r8, .0004_r8, .0004_r8 /)
      allocate( cph_enthalpy(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_enthalpy; error = ',ios
         call endrun
      end if
      allocate( cph_rid(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_rid; error = ',ios
         call endrun
      end if
      cph_rid(:)      = (/             155,            156,            157,            159,            160, &
                                       161,            163,            164,            165,            166, &
                                       167,            168,            169,            172,            175, &
                                       176,            177,            178,            181,            182, &
                                       183,            186,            188,            189,            190, &
                                       194,            195,            203,            204,            565, &
                                       566,            567,            568,            569,            571, &
                                       572,            573,            574,            576,            578, &
                                       579 /)
      cph_enthalpy(:) = (/   189.810000_r8,   32.910000_r8,  189.810000_r8,   94.300000_r8,   94.300000_r8, &
                              94.300000_r8,   62.600000_r8,   62.600000_r8,   62.600000_r8,   62.600000_r8, &
                             392.190000_r8,  493.580000_r8,  101.390000_r8,  232.590000_r8,  203.400000_r8, &
                             226.580000_r8,  120.100000_r8,  194.710000_r8,  293.620000_r8,   67.670000_r8, &
                             165.300000_r8,  165.510000_r8,  229.610000_r8,  177.510000_r8,  313.750000_r8, &
                             133.750000_r8,  193.020000_r8,   34.470000_r8,  199.170000_r8,   82.389000_r8, &
                             508.950000_r8,  354.830000_r8,  339.590000_r8,   67.530000_r8,   95.550000_r8, &
                             239.840000_r8,  646.280000_r8,  406.160000_r8,  271.380000_r8,  105.040000_r8, &
                             150.110000_r8 /)
      allocate( num_rnts(rxntot-phtcnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate num_rnts; error = ',ios
         call endrun
      end if
      num_rnts(:) = (/      1,     1,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     3,     3,     2, &
                            2,     2,     2,     2,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     3,     2,     2,     2, &
                            2,     2,     2,     2,     3,     2,     2,     3,     3,     3, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     3,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     3,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     3,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     3,     3,     2,     2,     1,     2, &
                            2,     2,     2,     2,     2,     3,     3,     3,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     1,     2, &
                            2,     2,     2,     3,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            3,     2,     2,     3,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     1,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     3,     2,     2,     3,     2,     2,     3,     2,     2, &
                            2,     2,     2,     2,     3,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     1, &
                            1,     1,     1,     1,     1,     1,     1,     1,     1,     1, &
                            1,     1,     1,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     1,     2,     1, &
                            1,     1,     1,     2,     2,     2,     1,     1,     2,     2, &
                            2,     1,     1,     2,     2,     2,     2,     2,     2,     2, &
                            2,     2,     2,     2,     2,     2,     2,     2,     2,     1, &
                            1,     1,     1 /)

      end subroutine set_sim_dat

      end module mo_sim_dat
