module mo_rxt_rates_conv
  use shr_kind_mod, only : r8 => shr_kind_r8
  implicit none
  private
  public :: set_rates
contains
   subroutine set_rates( rxt_rates, sol, ncol )
      real(r8), intent(inout) :: rxt_rates(:,:,:)
      real(r8), intent(in) :: sol(:,:,:)
      integer, intent(in) :: ncol
      rxt_rates(:ncol,:,     1) = rxt_rates(:ncol,:,     1)*sol(:ncol,:,   110)                                                ! rate_const*H2O
      rxt_rates(:ncol,:,     2) = rxt_rates(:ncol,:,     2)*sol(:ncol,:,   110)                                                ! rate_const*H2O
      rxt_rates(:ncol,:,     3) = rxt_rates(:ncol,:,     3)*sol(:ncol,:,   110)                                                ! rate_const*H2O
      rxt_rates(:ncol,:,     4) = rxt_rates(:ncol,:,     4)*sol(:ncol,:,    35)                                                ! rate_const*H2O2
      rxt_rates(:ncol,:,     5) = rxt_rates(:ncol,:,     5)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,     6) = rxt_rates(:ncol,:,     6)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,     7) = rxt_rates(:ncol,:,     7)*sol(:ncol,:,    56)                                                ! rate_const*O3
      rxt_rates(:ncol,:,     8) = rxt_rates(:ncol,:,     8)*sol(:ncol,:,    56)                                                ! rate_const*O3
      rxt_rates(:ncol,:,     9) = rxt_rates(:ncol,:,     9)*sol(:ncol,:,    42)                                                ! rate_const*HNO3
      rxt_rates(:ncol,:,    10) = rxt_rates(:ncol,:,    10)*sol(:ncol,:,    44)                                                ! rate_const*HO2NO2
      rxt_rates(:ncol,:,    11) = rxt_rates(:ncol,:,    11)*sol(:ncol,:,    44)                                                ! rate_const*HO2NO2
      rxt_rates(:ncol,:,    12) = rxt_rates(:ncol,:,    12)*sol(:ncol,:,    47)                                                ! rate_const*HONO
      rxt_rates(:ncol,:,    13) = rxt_rates(:ncol,:,    13)*sol(:ncol,:,    49)                                                ! rate_const*N2O
      rxt_rates(:ncol,:,    14) = rxt_rates(:ncol,:,    14)*sol(:ncol,:,    50)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,    15) = rxt_rates(:ncol,:,    15)*sol(:ncol,:,    50)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,    16) = rxt_rates(:ncol,:,    16)*sol(:ncol,:,    51)                                                ! rate_const*NO
      rxt_rates(:ncol,:,    17) = rxt_rates(:ncol,:,    17)*sol(:ncol,:,    51)                                                ! rate_const*NO
      rxt_rates(:ncol,:,    18) = rxt_rates(:ncol,:,    18)*sol(:ncol,:,    52)                                                ! rate_const*NO2
      rxt_rates(:ncol,:,    19) = rxt_rates(:ncol,:,    19)*sol(:ncol,:,    53)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,    20) = rxt_rates(:ncol,:,    20)*sol(:ncol,:,    53)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,    21) = rxt_rates(:ncol,:,    21)*sol(:ncol,:,    14)                                                ! rate_const*CH2O
      rxt_rates(:ncol,:,    22) = rxt_rates(:ncol,:,    22)*sol(:ncol,:,    14)                                                ! rate_const*CH2O
      rxt_rates(:ncol,:,    23) = rxt_rates(:ncol,:,    23)*sol(:ncol,:,    19)                                                ! rate_const*CH3OOH
      rxt_rates(:ncol,:,    24) = rxt_rates(:ncol,:,    24)*sol(:ncol,:,    20)                                                ! rate_const*CH4
      rxt_rates(:ncol,:,    25) = rxt_rates(:ncol,:,    25)*sol(:ncol,:,    20)                                                ! rate_const*CH4
      rxt_rates(:ncol,:,    26) = rxt_rates(:ncol,:,    26)*sol(:ncol,:,    28)                                                ! rate_const*CO2
      rxt_rates(:ncol,:,    27) = rxt_rates(:ncol,:,    27)*sol(:ncol,:,     1)                                                ! rate_const*BRCL
      rxt_rates(:ncol,:,    28) = rxt_rates(:ncol,:,    28)*sol(:ncol,:,     2)                                                ! rate_const*BRO
      rxt_rates(:ncol,:,    29) = rxt_rates(:ncol,:,    29)*sol(:ncol,:,     3)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,    30) = rxt_rates(:ncol,:,    30)*sol(:ncol,:,     3)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,    31) = rxt_rates(:ncol,:,    31)*sol(:ncol,:,     5)                                                ! rate_const*CCL4
      rxt_rates(:ncol,:,    32) = rxt_rates(:ncol,:,    32)*sol(:ncol,:,     6)                                                ! rate_const*CF2CLBR
      rxt_rates(:ncol,:,    33) = rxt_rates(:ncol,:,    33)*sol(:ncol,:,     7)                                                ! rate_const*CF3BR
      rxt_rates(:ncol,:,    34) = rxt_rates(:ncol,:,    34)*sol(:ncol,:,     8)                                                ! rate_const*CFC11
      rxt_rates(:ncol,:,    35) = rxt_rates(:ncol,:,    35)*sol(:ncol,:,     9)                                                ! rate_const*CFC113
      rxt_rates(:ncol,:,    36) = rxt_rates(:ncol,:,    36)*sol(:ncol,:,    10)                                                ! rate_const*CFC114
      rxt_rates(:ncol,:,    37) = rxt_rates(:ncol,:,    37)*sol(:ncol,:,    11)                                                ! rate_const*CFC115
      rxt_rates(:ncol,:,    38) = rxt_rates(:ncol,:,    38)*sol(:ncol,:,    12)                                                ! rate_const*CFC12
      rxt_rates(:ncol,:,    39) = rxt_rates(:ncol,:,    39)*sol(:ncol,:,    13)                                                ! rate_const*CH2BR2
      rxt_rates(:ncol,:,    40) = rxt_rates(:ncol,:,    40)*sol(:ncol,:,    15)                                                ! rate_const*CH3BR
      rxt_rates(:ncol,:,    41) = rxt_rates(:ncol,:,    41)*sol(:ncol,:,    16)                                                ! rate_const*CH3CCL3
      rxt_rates(:ncol,:,    42) = rxt_rates(:ncol,:,    42)*sol(:ncol,:,    17)                                                ! rate_const*CH3CL
      rxt_rates(:ncol,:,    43) = rxt_rates(:ncol,:,    43)*sol(:ncol,:,    21)                                                ! rate_const*CHBR3
      rxt_rates(:ncol,:,    44) = rxt_rates(:ncol,:,    44)*sol(:ncol,:,    22)                                                ! rate_const*CL2
      rxt_rates(:ncol,:,    45) = rxt_rates(:ncol,:,    45)*sol(:ncol,:,    23)                                                ! rate_const*CL2O2
      rxt_rates(:ncol,:,    46) = rxt_rates(:ncol,:,    46)*sol(:ncol,:,    24)                                                ! rate_const*CLO
      rxt_rates(:ncol,:,    47) = rxt_rates(:ncol,:,    47)*sol(:ncol,:,    25)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,    48) = rxt_rates(:ncol,:,    48)*sol(:ncol,:,    25)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,    49) = rxt_rates(:ncol,:,    49)*sol(:ncol,:,    29)                                                ! rate_const*COF2
      rxt_rates(:ncol,:,    50) = rxt_rates(:ncol,:,    50)*sol(:ncol,:,    30)                                                ! rate_const*COFCL
      rxt_rates(:ncol,:,    51) = rxt_rates(:ncol,:,    51)*sol(:ncol,:,    34)                                                ! rate_const*H2402
      rxt_rates(:ncol,:,    52) = rxt_rates(:ncol,:,    52)*sol(:ncol,:,    36)                                                ! rate_const*HBR
      rxt_rates(:ncol,:,    53) = rxt_rates(:ncol,:,    53)*sol(:ncol,:,    37)                                                ! rate_const*HCFC141B
      rxt_rates(:ncol,:,    54) = rxt_rates(:ncol,:,    54)*sol(:ncol,:,    38)                                                ! rate_const*HCFC142B
      rxt_rates(:ncol,:,    55) = rxt_rates(:ncol,:,    55)*sol(:ncol,:,    39)                                                ! rate_const*HCFC22
      rxt_rates(:ncol,:,    56) = rxt_rates(:ncol,:,    56)*sol(:ncol,:,    40)                                                ! rate_const*HCL
      rxt_rates(:ncol,:,    57) = rxt_rates(:ncol,:,    57)*sol(:ncol,:,    41)                                                ! rate_const*HF
      rxt_rates(:ncol,:,    58) = rxt_rates(:ncol,:,    58)*sol(:ncol,:,    45)                                                ! rate_const*HOBR
      rxt_rates(:ncol,:,    59) = rxt_rates(:ncol,:,    59)*sol(:ncol,:,    46)                                                ! rate_const*HOCL
      rxt_rates(:ncol,:,    60) = rxt_rates(:ncol,:,    60)*sol(:ncol,:,    57)                                                ! rate_const*OCLO
      rxt_rates(:ncol,:,    61) = rxt_rates(:ncol,:,    61)*sol(:ncol,:,    58)                                                ! rate_const*SF6
      rxt_rates(:ncol,:,    62) = rxt_rates(:ncol,:,    62)*sol(:ncol,:,    28)                                                ! rate_const*CO2
      rxt_rates(:ncol,:,    63) = rxt_rates(:ncol,:,    63)*sol(:ncol,:,    65)                                                ! rate_const*CO3m
      rxt_rates(:ncol,:,    64) = rxt_rates(:ncol,:,    64)*sol(:ncol,:,    67)                                                ! rate_const*CO3m_H2O
      rxt_rates(:ncol,:,    65) = rxt_rates(:ncol,:,    65)*sol(:ncol,:,    68)                                                ! rate_const*CO4m
      rxt_rates(:ncol,:,    66) = rxt_rates(:ncol,:,    66)*sol(:ncol,:,    48)                                                ! rate_const*N
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
                                                                                                                               ! rate_const*N2
      rxt_rates(:ncol,:,    75) = rxt_rates(:ncol,:,    75)*sol(:ncol,:,    81)                                                ! rate_const*NO2m
      rxt_rates(:ncol,:,    76) = rxt_rates(:ncol,:,    76)*sol(:ncol,:,    83)                                                ! rate_const*NO3m
      rxt_rates(:ncol,:,    77) = rxt_rates(:ncol,:,    77)*sol(:ncol,:,    54)                                                ! rate_const*O
      rxt_rates(:ncol,:,    78) = rxt_rates(:ncol,:,    78)*sol(:ncol,:,    54)                                                ! rate_const*O
      rxt_rates(:ncol,:,    79) = rxt_rates(:ncol,:,    79)*sol(:ncol,:,    54)                                                ! rate_const*O
      rxt_rates(:ncol,:,    80) = rxt_rates(:ncol,:,    80)*sol(:ncol,:,    54)                                                ! rate_const*O
      rxt_rates(:ncol,:,    81) = rxt_rates(:ncol,:,    81)*sol(:ncol,:,    54)                                                ! rate_const*O
      rxt_rates(:ncol,:,    82) = rxt_rates(:ncol,:,    82)*sol(:ncol,:,    54)                                                ! rate_const*O
      rxt_rates(:ncol,:,    83) = rxt_rates(:ncol,:,    83)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    84) = rxt_rates(:ncol,:,    84)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    85) = rxt_rates(:ncol,:,    85)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    86) = rxt_rates(:ncol,:,    86)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    87) = rxt_rates(:ncol,:,    87)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    88) = rxt_rates(:ncol,:,    88)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    89) = rxt_rates(:ncol,:,    89)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    90) = rxt_rates(:ncol,:,    90)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    91) = rxt_rates(:ncol,:,    91)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    92) = rxt_rates(:ncol,:,    92)*sol(:ncol,:,    55)                                                ! rate_const*O2
      rxt_rates(:ncol,:,    93) = rxt_rates(:ncol,:,    93)*sol(:ncol,:,    98)                                                ! rate_const*O2m
      rxt_rates(:ncol,:,    94) = rxt_rates(:ncol,:,    94)*sol(:ncol,:,   100)                                                ! rate_const*O2p_H2O
      rxt_rates(:ncol,:,    95) = rxt_rates(:ncol,:,    95)*sol(:ncol,:,   101)                                                ! rate_const*O3m
      rxt_rates(:ncol,:,    96) = rxt_rates(:ncol,:,    96)*sol(:ncol,:,   101)                                                ! rate_const*O3m
      rxt_rates(:ncol,:,    97) = rxt_rates(:ncol,:,    97)*sol(:ncol,:,   102)                                                ! rate_const*O4m
      rxt_rates(:ncol,:,    98) = rxt_rates(:ncol,:,    98)*sol(:ncol,:,   105)                                                ! rate_const*OHm
      rxt_rates(:ncol,:,    99) = rxt_rates(:ncol,:,    99)*sol(:ncol,:,   106)                                                ! rate_const*Om
      rxt_rates(:ncol,:,   100) = rxt_rates(:ncol,:,   100)*sol(:ncol,:,    61)*sol(:ncol,:,    32)                            ! rate_const*CLm*H
      rxt_rates(:ncol,:,   101) = rxt_rates(:ncol,:,   101)*sol(:ncol,:,    62)*sol(:ncol,:,    40)                            ! rate_const*CLm_H2O*HCL
      rxt_rates(:ncol,:,   102) = rxt_rates(:ncol,:,   102)*sol(:ncol,:,    61)*sol(:ncol,:,   110)                            ! rate_const*M*CLm*H2O
      rxt_rates(:ncol,:,   103) = rxt_rates(:ncol,:,   103)*sol(:ncol,:,    40)*sol(:ncol,:,    61)                            ! rate_const*M*HCL*CLm
      rxt_rates(:ncol,:,   104) = rxt_rates(:ncol,:,   104)*sol(:ncol,:,    61)*sol(:ncol,:,    42)                            ! rate_const*CLm*HNO3
      rxt_rates(:ncol,:,   105) = rxt_rates(:ncol,:,   105)*sol(:ncol,:,    61)*sol(:ncol,:,    52)                            ! rate_const*CLm*NO2
      rxt_rates(:ncol,:,   106) = rxt_rates(:ncol,:,   106)*sol(:ncol,:,    64)*sol(:ncol,:,    51)                            ! rate_const*CLOm*NO
      rxt_rates(:ncol,:,   107) = rxt_rates(:ncol,:,   107)*sol(:ncol,:,    64)*sol(:ncol,:,    51)                            ! rate_const*CLOm*NO
      rxt_rates(:ncol,:,   108) = rxt_rates(:ncol,:,   108)*sol(:ncol,:,    64)*sol(:ncol,:,    54)                            ! rate_const*CLOm*O
      rxt_rates(:ncol,:,   109) = rxt_rates(:ncol,:,   109)*sol(:ncol,:,    60)*sol(:ncol,:,    65)                            ! rate_const*CL*CO3m
      rxt_rates(:ncol,:,   110) = rxt_rates(:ncol,:,   110)*sol(:ncol,:,    60)*sol(:ncol,:,    65)                            ! rate_const*CL*CO3m
      rxt_rates(:ncol,:,   111) = rxt_rates(:ncol,:,   111)*sol(:ncol,:,    24)*sol(:ncol,:,    65)                            ! rate_const*CLO*CO3m
      rxt_rates(:ncol,:,   112) = rxt_rates(:ncol,:,   112)*sol(:ncol,:,    32)*sol(:ncol,:,    65)                            ! rate_const*H*CO3m
      rxt_rates(:ncol,:,   113) = rxt_rates(:ncol,:,   113)*sol(:ncol,:,    67)*sol(:ncol,:,   110)                            ! rate_const*M*CO3m_H2O*H2O
      rxt_rates(:ncol,:,   114) = rxt_rates(:ncol,:,   114)*sol(:ncol,:,    65)*sol(:ncol,:,   110)                            ! rate_const*M*CO3m*H2O
      rxt_rates(:ncol,:,   115) = rxt_rates(:ncol,:,   115)*sol(:ncol,:,    67)*sol(:ncol,:,    52)                            ! rate_const*CO3m_H2O*NO2
      rxt_rates(:ncol,:,   116) = rxt_rates(:ncol,:,   116)*sol(:ncol,:,    67)*sol(:ncol,:,    52)                            ! rate_const*CO3m_H2O*NO2
      rxt_rates(:ncol,:,   117) = rxt_rates(:ncol,:,   117)*sol(:ncol,:,    67)*sol(:ncol,:,    51)                            ! rate_const*CO3m_H2O*NO
      rxt_rates(:ncol,:,   118) = rxt_rates(:ncol,:,   118)*sol(:ncol,:,    67)*sol(:ncol,:,    51)                            ! rate_const*CO3m_H2O*NO
      rxt_rates(:ncol,:,   119) = rxt_rates(:ncol,:,   119)*sol(:ncol,:,    65)*sol(:ncol,:,    42)                            ! rate_const*CO3m*HNO3
      rxt_rates(:ncol,:,   120) = rxt_rates(:ncol,:,   120)*sol(:ncol,:,    65)*sol(:ncol,:,    54)                            ! rate_const*CO3m*O
      rxt_rates(:ncol,:,   121) = rxt_rates(:ncol,:,   121)*sol(:ncol,:,    55)*sol(:ncol,:,    65)                            ! rate_const*O2*CO3m
      rxt_rates(:ncol,:,   122) = rxt_rates(:ncol,:,   122)*sol(:ncol,:,    60)*sol(:ncol,:,    68)                            ! rate_const*CL*CO4m
      rxt_rates(:ncol,:,   123) = rxt_rates(:ncol,:,   123)*sol(:ncol,:,    24)*sol(:ncol,:,    68)                            ! rate_const*CLO*CO4m
      rxt_rates(:ncol,:,   124) = rxt_rates(:ncol,:,   124)*sol(:ncol,:,    68)*sol(:ncol,:,    32)                            ! rate_const*CO4m*H
      rxt_rates(:ncol,:,   125) = rxt_rates(:ncol,:,   125)*sol(:ncol,:,    68)*sol(:ncol,:,    40)                            ! rate_const*CO4m*HCL
      rxt_rates(:ncol,:,   126) = rxt_rates(:ncol,:,   126)*sol(:ncol,:,    68)*sol(:ncol,:,    54)                            ! rate_const*CO4m*O
      rxt_rates(:ncol,:,   127) = rxt_rates(:ncol,:,   127)*sol(:ncol,:,    68)*sol(:ncol,:,    56)                            ! rate_const*CO4m*O3
      rxt_rates(:ncol,:,   128) = rxt_rates(:ncol,:,   128)*sol(:ncol,:,    69)*sol(:ncol,:,    55)                            ! rate_const*N2*e*O2
      rxt_rates(:ncol,:,   129) = rxt_rates(:ncol,:,   129)*sol(:ncol,:,    56)*sol(:ncol,:,    69)                            ! rate_const*O3*e
      rxt_rates(:ncol,:,   130) = rxt_rates(:ncol,:,   130)*sol(:ncol,:,    55)*sol(:ncol,:,    69)                            ! rate_const*M*O2*e
      rxt_rates(:ncol,:,   131) = rxt_rates(:ncol,:,   131)*sol(:ncol,:,    51)*sol(:ncol,:,   106)                            ! rate_const*NO*Om
      rxt_rates(:ncol,:,   132) = rxt_rates(:ncol,:,   132)*sol(:ncol,:,    98)                                                ! rate_const*N2*O2m
      rxt_rates(:ncol,:,   133) = rxt_rates(:ncol,:,   133)*sol(:ncol,:,    70)*sol(:ncol,:,    69)                            ! rate_const*H3Op_OH*e
      rxt_rates(:ncol,:,   134) = rxt_rates(:ncol,:,   134)*sol(:ncol,:,   110)*sol(:ncol,:,    70)                            ! rate_const*H2O*H3Op_OH
      rxt_rates(:ncol,:,   135) = rxt_rates(:ncol,:,   135)*sol(:ncol,:,   110)*sol(:ncol,:,    74)                            ! rate_const*H2O*Hp_3N1
      rxt_rates(:ncol,:,   136) = rxt_rates(:ncol,:,   136)*sol(:ncol,:,    75)*sol(:ncol,:,    69)                            ! rate_const*Hp_4H2O*e
      rxt_rates(:ncol,:,   137) = rxt_rates(:ncol,:,   137)*sol(:ncol,:,    75)*sol(:ncol,:,    50)                            ! rate_const*Hp_4H2O*N2O5
      rxt_rates(:ncol,:,   138) = rxt_rates(:ncol,:,   138)*sol(:ncol,:,   110)*sol(:ncol,:,    76)                            ! rate_const*H2O*Hp_4N1
      rxt_rates(:ncol,:,   139) = rxt_rates(:ncol,:,   139)*sol(:ncol,:,    77)*sol(:ncol,:,    69)                            ! rate_const*Hp_5H2O*e
      rxt_rates(:ncol,:,   140) = rxt_rates(:ncol,:,   140)*sol(:ncol,:,    77)*sol(:ncol,:,    50)                            ! rate_const*Hp_5H2O*N2O5
      rxt_rates(:ncol,:,   141) = rxt_rates(:ncol,:,   141)*sol(:ncol,:,    75)*sol(:ncol,:,    87)                            ! rate_const*Hp_4H2O*NO3mHNO3
      rxt_rates(:ncol,:,   142) = rxt_rates(:ncol,:,   142)*sol(:ncol,:,    61)*sol(:ncol,:,    75)                            ! rate_const*CLm*Hp_4H2O
      rxt_rates(:ncol,:,   143) = rxt_rates(:ncol,:,   143)*sol(:ncol,:,    83)*sol(:ncol,:,    99)                            ! rate_const*NO3m*O2p
      rxt_rates(:ncol,:,   144) = rxt_rates(:ncol,:,   144)*sol(:ncol,:,    71)*sol(:ncol,:,    99)                            ! rate_const*HCO3m*O2p
      rxt_rates(:ncol,:,   145) = rxt_rates(:ncol,:,   145)*sol(:ncol,:,    98)*sol(:ncol,:,    99)                            ! rate_const*O2m*O2p
      rxt_rates(:ncol,:,   146) = rxt_rates(:ncol,:,   146)*sol(:ncol,:,    68)*sol(:ncol,:,    99)                            ! rate_const*CO4m*O2p
      rxt_rates(:ncol,:,   147) = rxt_rates(:ncol,:,   147)*sol(:ncol,:,    85)*sol(:ncol,:,    99)                            ! rate_const*NO3m_H2O*O2p
      rxt_rates(:ncol,:,   148) = rxt_rates(:ncol,:,   148)*sol(:ncol,:,    66)*sol(:ncol,:,    99)                            ! rate_const*CO3m2H2O*O2p
      rxt_rates(:ncol,:,   149) = rxt_rates(:ncol,:,   149)*sol(:ncol,:,    61)*sol(:ncol,:,    99)                            ! rate_const*CLm*O2p
      rxt_rates(:ncol,:,   150) = rxt_rates(:ncol,:,   150)*sol(:ncol,:,    67)*sol(:ncol,:,    99)                            ! rate_const*CO3m_H2O*O2p
      rxt_rates(:ncol,:,   151) = rxt_rates(:ncol,:,   151)*sol(:ncol,:,    82)*sol(:ncol,:,    99)                            ! rate_const*NO2m_H2O*O2p
      rxt_rates(:ncol,:,   152) = rxt_rates(:ncol,:,   152)*sol(:ncol,:,    86)*sol(:ncol,:,    99)                            ! rate_const*NO3m_HCL*O2p
      rxt_rates(:ncol,:,   153) = rxt_rates(:ncol,:,   153)*sol(:ncol,:,    67)*sol(:ncol,:,    75)                            ! rate_const*CO3m_H2O*Hp_4H2O
      rxt_rates(:ncol,:,   154) = rxt_rates(:ncol,:,   154)*sol(:ncol,:,    99)*sol(:ncol,:,    62)                            ! rate_const*O2p*CLm_H2O
      rxt_rates(:ncol,:,   155) = rxt_rates(:ncol,:,   155)*sol(:ncol,:,    84)*sol(:ncol,:,    99)                            ! rate_const*NO3m2H2O*O2p
      rxt_rates(:ncol,:,   156) = rxt_rates(:ncol,:,   156)*sol(:ncol,:,    81)*sol(:ncol,:,    99)                            ! rate_const*NO2m*O2p
      rxt_rates(:ncol,:,   157) = rxt_rates(:ncol,:,   157)*sol(:ncol,:,    75)*sol(:ncol,:,    82)                            ! rate_const*Hp_4H2O*NO2m_H2O
      rxt_rates(:ncol,:,   158) = rxt_rates(:ncol,:,   158)*sol(:ncol,:,    75)*sol(:ncol,:,    86)                            ! rate_const*Hp_4H2O*NO3m_HCL
      rxt_rates(:ncol,:,   159) = rxt_rates(:ncol,:,   159)*sol(:ncol,:,    62)*sol(:ncol,:,    75)                            ! rate_const*CLm_H2O*Hp_4H2O
      rxt_rates(:ncol,:,   160) = rxt_rates(:ncol,:,   160)*sol(:ncol,:,    84)*sol(:ncol,:,    75)                            ! rate_const*NO3m2H2O*Hp_4H2O
      rxt_rates(:ncol,:,   161) = rxt_rates(:ncol,:,   161)*sol(:ncol,:,    75)*sol(:ncol,:,    81)                            ! rate_const*Hp_4H2O*NO2m
      rxt_rates(:ncol,:,   162) = rxt_rates(:ncol,:,   162)*sol(:ncol,:,    77)*sol(:ncol,:,    87)                            ! rate_const*Hp_5H2O*NO3mHNO3
      rxt_rates(:ncol,:,   163) = rxt_rates(:ncol,:,   163)*sol(:ncol,:,    65)*sol(:ncol,:,    77)                            ! rate_const*CO3m*Hp_5H2O
      rxt_rates(:ncol,:,   164) = rxt_rates(:ncol,:,   164)*sol(:ncol,:,    63)*sol(:ncol,:,    77)                            ! rate_const*CLm_HCL*Hp_5H2O
      rxt_rates(:ncol,:,   165) = rxt_rates(:ncol,:,   165)*sol(:ncol,:,    65)*sol(:ncol,:,    75)                            ! rate_const*CO3m*Hp_4H2O
      rxt_rates(:ncol,:,   166) = rxt_rates(:ncol,:,   166)*sol(:ncol,:,    83)*sol(:ncol,:,    77)                            ! rate_const*NO3m*Hp_5H2O
      rxt_rates(:ncol,:,   167) = rxt_rates(:ncol,:,   167)*sol(:ncol,:,    71)*sol(:ncol,:,    77)                            ! rate_const*HCO3m*Hp_5H2O
      rxt_rates(:ncol,:,   168) = rxt_rates(:ncol,:,   168)*sol(:ncol,:,    77)*sol(:ncol,:,    98)                            ! rate_const*Hp_5H2O*O2m
      rxt_rates(:ncol,:,   169) = rxt_rates(:ncol,:,   169)*sol(:ncol,:,    68)*sol(:ncol,:,    77)                            ! rate_const*CO4m*Hp_5H2O
      rxt_rates(:ncol,:,   170) = rxt_rates(:ncol,:,   170)*sol(:ncol,:,    77)*sol(:ncol,:,    85)                            ! rate_const*Hp_5H2O*NO3m_H2O
      rxt_rates(:ncol,:,   171) = rxt_rates(:ncol,:,   171)*sol(:ncol,:,    66)*sol(:ncol,:,    77)                            ! rate_const*CO3m2H2O*Hp_5H2O
      rxt_rates(:ncol,:,   172) = rxt_rates(:ncol,:,   172)*sol(:ncol,:,    61)*sol(:ncol,:,    77)                            ! rate_const*CLm*Hp_5H2O
      rxt_rates(:ncol,:,   173) = rxt_rates(:ncol,:,   173)*sol(:ncol,:,    67)*sol(:ncol,:,    77)                            ! rate_const*CO3m_H2O*Hp_5H2O
      rxt_rates(:ncol,:,   174) = rxt_rates(:ncol,:,   174)*sol(:ncol,:,    82)*sol(:ncol,:,    77)                            ! rate_const*NO2m_H2O*Hp_5H2O
      rxt_rates(:ncol,:,   175) = rxt_rates(:ncol,:,   175)*sol(:ncol,:,    77)*sol(:ncol,:,    86)                            ! rate_const*Hp_5H2O*NO3m_HCL
      rxt_rates(:ncol,:,   176) = rxt_rates(:ncol,:,   176)*sol(:ncol,:,    63)*sol(:ncol,:,    75)                            ! rate_const*CLm_HCL*Hp_4H2O
      rxt_rates(:ncol,:,   177) = rxt_rates(:ncol,:,   177)*sol(:ncol,:,    62)*sol(:ncol,:,    77)                            ! rate_const*CLm_H2O*Hp_5H2O
      rxt_rates(:ncol,:,   178) = rxt_rates(:ncol,:,   178)*sol(:ncol,:,    77)*sol(:ncol,:,    84)                            ! rate_const*Hp_5H2O*NO3m2H2O
      rxt_rates(:ncol,:,   179) = rxt_rates(:ncol,:,   179)*sol(:ncol,:,    77)*sol(:ncol,:,    81)                            ! rate_const*Hp_5H2O*NO2m
      rxt_rates(:ncol,:,   180) = rxt_rates(:ncol,:,   180)*sol(:ncol,:,    73)*sol(:ncol,:,    87)                            ! rate_const*Hp_3H2O*NO3mHNO3
      rxt_rates(:ncol,:,   181) = rxt_rates(:ncol,:,   181)*sol(:ncol,:,    73)*sol(:ncol,:,    65)                            ! rate_const*Hp_3H2O*CO3m
      rxt_rates(:ncol,:,   182) = rxt_rates(:ncol,:,   182)*sol(:ncol,:,    63)*sol(:ncol,:,    73)                            ! rate_const*CLm_HCL*Hp_3H2O
      rxt_rates(:ncol,:,   183) = rxt_rates(:ncol,:,   183)*sol(:ncol,:,    73)*sol(:ncol,:,    83)                            ! rate_const*Hp_3H2O*NO3m
      rxt_rates(:ncol,:,   184) = rxt_rates(:ncol,:,   184)*sol(:ncol,:,    71)*sol(:ncol,:,    73)                            ! rate_const*HCO3m*Hp_3H2O
      rxt_rates(:ncol,:,   185) = rxt_rates(:ncol,:,   185)*sol(:ncol,:,    73)*sol(:ncol,:,    98)                            ! rate_const*Hp_3H2O*O2m
      rxt_rates(:ncol,:,   186) = rxt_rates(:ncol,:,   186)*sol(:ncol,:,    68)*sol(:ncol,:,    73)                            ! rate_const*CO4m*Hp_3H2O
      rxt_rates(:ncol,:,   187) = rxt_rates(:ncol,:,   187)*sol(:ncol,:,    75)*sol(:ncol,:,    83)                            ! rate_const*Hp_4H2O*NO3m
      rxt_rates(:ncol,:,   188) = rxt_rates(:ncol,:,   188)*sol(:ncol,:,    73)*sol(:ncol,:,    85)                            ! rate_const*Hp_3H2O*NO3m_H2O
      rxt_rates(:ncol,:,   189) = rxt_rates(:ncol,:,   189)*sol(:ncol,:,    66)*sol(:ncol,:,    73)                            ! rate_const*CO3m2H2O*Hp_3H2O
      rxt_rates(:ncol,:,   190) = rxt_rates(:ncol,:,   190)*sol(:ncol,:,    61)*sol(:ncol,:,    73)                            ! rate_const*CLm*Hp_3H2O
      rxt_rates(:ncol,:,   191) = rxt_rates(:ncol,:,   191)*sol(:ncol,:,    67)*sol(:ncol,:,    73)                            ! rate_const*CO3m_H2O*Hp_3H2O
      rxt_rates(:ncol,:,   192) = rxt_rates(:ncol,:,   192)*sol(:ncol,:,    73)*sol(:ncol,:,    82)                            ! rate_const*Hp_3H2O*NO2m_H2O
      rxt_rates(:ncol,:,   193) = rxt_rates(:ncol,:,   193)*sol(:ncol,:,    73)*sol(:ncol,:,    86)                            ! rate_const*Hp_3H2O*NO3m_HCL
      rxt_rates(:ncol,:,   194) = rxt_rates(:ncol,:,   194)*sol(:ncol,:,    62)*sol(:ncol,:,    73)                            ! rate_const*CLm_H2O*Hp_3H2O
      rxt_rates(:ncol,:,   195) = rxt_rates(:ncol,:,   195)*sol(:ncol,:,    73)*sol(:ncol,:,    84)                            ! rate_const*Hp_3H2O*NO3m2H2O
      rxt_rates(:ncol,:,   196) = rxt_rates(:ncol,:,   196)*sol(:ncol,:,    73)*sol(:ncol,:,    81)                            ! rate_const*Hp_3H2O*NO2m
      rxt_rates(:ncol,:,   197) = rxt_rates(:ncol,:,   197)*sol(:ncol,:,    87)*sol(:ncol,:,    92)                            ! rate_const*NO3mHNO3*NOp_H2O
      rxt_rates(:ncol,:,   198) = rxt_rates(:ncol,:,   198)*sol(:ncol,:,    71)*sol(:ncol,:,    75)                            ! rate_const*HCO3m*Hp_4H2O
      rxt_rates(:ncol,:,   199) = rxt_rates(:ncol,:,   199)*sol(:ncol,:,    65)*sol(:ncol,:,    92)                            ! rate_const*CO3m*NOp_H2O
      rxt_rates(:ncol,:,   200) = rxt_rates(:ncol,:,   200)*sol(:ncol,:,    63)*sol(:ncol,:,    92)                            ! rate_const*CLm_HCL*NOp_H2O
      rxt_rates(:ncol,:,   201) = rxt_rates(:ncol,:,   201)*sol(:ncol,:,    83)*sol(:ncol,:,    92)                            ! rate_const*NO3m*NOp_H2O
      rxt_rates(:ncol,:,   202) = rxt_rates(:ncol,:,   202)*sol(:ncol,:,    71)*sol(:ncol,:,    92)                            ! rate_const*HCO3m*NOp_H2O
      rxt_rates(:ncol,:,   203) = rxt_rates(:ncol,:,   203)*sol(:ncol,:,    92)*sol(:ncol,:,    98)                            ! rate_const*NOp_H2O*O2m
      rxt_rates(:ncol,:,   204) = rxt_rates(:ncol,:,   204)*sol(:ncol,:,    68)*sol(:ncol,:,    92)                            ! rate_const*CO4m*NOp_H2O
      rxt_rates(:ncol,:,   205) = rxt_rates(:ncol,:,   205)*sol(:ncol,:,    85)*sol(:ncol,:,    92)                            ! rate_const*NO3m_H2O*NOp_H2O
      rxt_rates(:ncol,:,   206) = rxt_rates(:ncol,:,   206)*sol(:ncol,:,    66)*sol(:ncol,:,    92)                            ! rate_const*CO3m2H2O*NOp_H2O
      rxt_rates(:ncol,:,   207) = rxt_rates(:ncol,:,   207)*sol(:ncol,:,    61)*sol(:ncol,:,    92)                            ! rate_const*CLm*NOp_H2O
      rxt_rates(:ncol,:,   208) = rxt_rates(:ncol,:,   208)*sol(:ncol,:,    67)*sol(:ncol,:,    92)                            ! rate_const*CO3m_H2O*NOp_H2O
      rxt_rates(:ncol,:,   209) = rxt_rates(:ncol,:,   209)*sol(:ncol,:,    75)*sol(:ncol,:,    98)                            ! rate_const*Hp_4H2O*O2m
      rxt_rates(:ncol,:,   210) = rxt_rates(:ncol,:,   210)*sol(:ncol,:,    82)*sol(:ncol,:,    92)                            ! rate_const*NO2m_H2O*NOp_H2O
      rxt_rates(:ncol,:,   211) = rxt_rates(:ncol,:,   211)*sol(:ncol,:,    86)*sol(:ncol,:,    92)                            ! rate_const*NO3m_HCL*NOp_H2O
      rxt_rates(:ncol,:,   212) = rxt_rates(:ncol,:,   212)*sol(:ncol,:,    62)*sol(:ncol,:,    92)                            ! rate_const*CLm_H2O*NOp_H2O
      rxt_rates(:ncol,:,   213) = rxt_rates(:ncol,:,   213)*sol(:ncol,:,    84)*sol(:ncol,:,    92)                            ! rate_const*NO3m2H2O*NOp_H2O
      rxt_rates(:ncol,:,   214) = rxt_rates(:ncol,:,   214)*sol(:ncol,:,    81)*sol(:ncol,:,    92)                            ! rate_const*NO2m*NOp_H2O
      rxt_rates(:ncol,:,   215) = rxt_rates(:ncol,:,   215)*sol(:ncol,:,    87)*sol(:ncol,:,    89)                            ! rate_const*NO3mHNO3*NOp_2H2O
      rxt_rates(:ncol,:,   216) = rxt_rates(:ncol,:,   216)*sol(:ncol,:,    65)*sol(:ncol,:,    89)                            ! rate_const*CO3m*NOp_2H2O
      rxt_rates(:ncol,:,   217) = rxt_rates(:ncol,:,   217)*sol(:ncol,:,    63)*sol(:ncol,:,    89)                            ! rate_const*CLm_HCL*NOp_2H2O
      rxt_rates(:ncol,:,   218) = rxt_rates(:ncol,:,   218)*sol(:ncol,:,    89)*sol(:ncol,:,    83)                            ! rate_const*NOp_2H2O*NO3m
      rxt_rates(:ncol,:,   219) = rxt_rates(:ncol,:,   219)*sol(:ncol,:,    71)*sol(:ncol,:,    89)                            ! rate_const*HCO3m*NOp_2H2O
      rxt_rates(:ncol,:,   220) = rxt_rates(:ncol,:,   220)*sol(:ncol,:,    68)*sol(:ncol,:,    75)                            ! rate_const*CO4m*Hp_4H2O
      rxt_rates(:ncol,:,   221) = rxt_rates(:ncol,:,   221)*sol(:ncol,:,    89)*sol(:ncol,:,    98)                            ! rate_const*NOp_2H2O*O2m
      rxt_rates(:ncol,:,   222) = rxt_rates(:ncol,:,   222)*sol(:ncol,:,    89)*sol(:ncol,:,    68)                            ! rate_const*NOp_2H2O*CO4m
      rxt_rates(:ncol,:,   223) = rxt_rates(:ncol,:,   223)*sol(:ncol,:,    85)*sol(:ncol,:,    89)                            ! rate_const*NO3m_H2O*NOp_2H2O
      rxt_rates(:ncol,:,   224) = rxt_rates(:ncol,:,   224)*sol(:ncol,:,    66)*sol(:ncol,:,    89)                            ! rate_const*CO3m2H2O*NOp_2H2O
      rxt_rates(:ncol,:,   225) = rxt_rates(:ncol,:,   225)*sol(:ncol,:,    61)*sol(:ncol,:,    89)                            ! rate_const*CLm*NOp_2H2O
      rxt_rates(:ncol,:,   226) = rxt_rates(:ncol,:,   226)*sol(:ncol,:,    67)*sol(:ncol,:,    89)                            ! rate_const*CO3m_H2O*NOp_2H2O
      rxt_rates(:ncol,:,   227) = rxt_rates(:ncol,:,   227)*sol(:ncol,:,    89)*sol(:ncol,:,    82)                            ! rate_const*NOp_2H2O*NO2m_H2O
      rxt_rates(:ncol,:,   228) = rxt_rates(:ncol,:,   228)*sol(:ncol,:,    86)*sol(:ncol,:,    89)                            ! rate_const*NO3m_HCL*NOp_2H2O
      rxt_rates(:ncol,:,   229) = rxt_rates(:ncol,:,   229)*sol(:ncol,:,    89)*sol(:ncol,:,    62)                            ! rate_const*NOp_2H2O*CLm_H2O
      rxt_rates(:ncol,:,   230) = rxt_rates(:ncol,:,   230)*sol(:ncol,:,    89)*sol(:ncol,:,    84)                            ! rate_const*NOp_2H2O*NO3m2H2O
      rxt_rates(:ncol,:,   231) = rxt_rates(:ncol,:,   231)*sol(:ncol,:,    75)*sol(:ncol,:,    85)                            ! rate_const*Hp_4H2O*NO3m_H2O
      rxt_rates(:ncol,:,   232) = rxt_rates(:ncol,:,   232)*sol(:ncol,:,    89)*sol(:ncol,:,    81)                            ! rate_const*NOp_2H2O*NO2m
      rxt_rates(:ncol,:,   233) = rxt_rates(:ncol,:,   233)*sol(:ncol,:,    88)*sol(:ncol,:,    87)                            ! rate_const*NOp*NO3mHNO3
      rxt_rates(:ncol,:,   234) = rxt_rates(:ncol,:,   234)*sol(:ncol,:,    88)*sol(:ncol,:,    65)                            ! rate_const*NOp*CO3m
      rxt_rates(:ncol,:,   235) = rxt_rates(:ncol,:,   235)*sol(:ncol,:,    88)*sol(:ncol,:,    63)                            ! rate_const*NOp*CLm_HCL
      rxt_rates(:ncol,:,   236) = rxt_rates(:ncol,:,   236)*sol(:ncol,:,    83)*sol(:ncol,:,    88)                            ! rate_const*NO3m*NOp
      rxt_rates(:ncol,:,   237) = rxt_rates(:ncol,:,   237)*sol(:ncol,:,    88)*sol(:ncol,:,    71)                            ! rate_const*NOp*HCO3m
      rxt_rates(:ncol,:,   238) = rxt_rates(:ncol,:,   238)*sol(:ncol,:,    98)*sol(:ncol,:,    88)                            ! rate_const*O2m*NOp
      rxt_rates(:ncol,:,   239) = rxt_rates(:ncol,:,   239)*sol(:ncol,:,    88)*sol(:ncol,:,    68)                            ! rate_const*NOp*CO4m
      rxt_rates(:ncol,:,   240) = rxt_rates(:ncol,:,   240)*sol(:ncol,:,    88)*sol(:ncol,:,    85)                            ! rate_const*NOp*NO3m_H2O
      rxt_rates(:ncol,:,   241) = rxt_rates(:ncol,:,   241)*sol(:ncol,:,    88)*sol(:ncol,:,    66)                            ! rate_const*NOp*CO3m2H2O
      rxt_rates(:ncol,:,   242) = rxt_rates(:ncol,:,   242)*sol(:ncol,:,    66)*sol(:ncol,:,    75)                            ! rate_const*CO3m2H2O*Hp_4H2O
      rxt_rates(:ncol,:,   243) = rxt_rates(:ncol,:,   243)*sol(:ncol,:,    61)*sol(:ncol,:,    88)                            ! rate_const*CLm*NOp
      rxt_rates(:ncol,:,   244) = rxt_rates(:ncol,:,   244)*sol(:ncol,:,    67)*sol(:ncol,:,    88)                            ! rate_const*CO3m_H2O*NOp
      rxt_rates(:ncol,:,   245) = rxt_rates(:ncol,:,   245)*sol(:ncol,:,    82)*sol(:ncol,:,    88)                            ! rate_const*NO2m_H2O*NOp
      rxt_rates(:ncol,:,   246) = rxt_rates(:ncol,:,   246)*sol(:ncol,:,    86)*sol(:ncol,:,    88)                            ! rate_const*NO3m_HCL*NOp
      rxt_rates(:ncol,:,   247) = rxt_rates(:ncol,:,   247)*sol(:ncol,:,    62)*sol(:ncol,:,    88)                            ! rate_const*CLm_H2O*NOp
      rxt_rates(:ncol,:,   248) = rxt_rates(:ncol,:,   248)*sol(:ncol,:,    88)*sol(:ncol,:,    84)                            ! rate_const*NOp*NO3m2H2O
      rxt_rates(:ncol,:,   249) = rxt_rates(:ncol,:,   249)*sol(:ncol,:,    88)*sol(:ncol,:,    81)                            ! rate_const*NOp*NO2m
      rxt_rates(:ncol,:,   250) = rxt_rates(:ncol,:,   250)*sol(:ncol,:,    87)*sol(:ncol,:,    99)                            ! rate_const*NO3mHNO3*O2p
      rxt_rates(:ncol,:,   251) = rxt_rates(:ncol,:,   251)*sol(:ncol,:,    99)*sol(:ncol,:,    65)                            ! rate_const*O2p*CO3m
      rxt_rates(:ncol,:,   252) = rxt_rates(:ncol,:,   252)*sol(:ncol,:,    99)*sol(:ncol,:,    63)                            ! rate_const*O2p*CLm_HCL
      rxt_rates(:ncol,:,   253) = rxt_rates(:ncol,:,   253)*sol(:ncol,:,    75)*sol(:ncol,:,    65)                            ! rate_const*M*Hp_4H2O*CO3m
      rxt_rates(:ncol,:,   254) = rxt_rates(:ncol,:,   254)*sol(:ncol,:,    77)*sol(:ncol,:,    66)                            ! rate_const*M*Hp_5H2O*CO3m2H2O
      rxt_rates(:ncol,:,   255) = rxt_rates(:ncol,:,   255)*sol(:ncol,:,    67)*sol(:ncol,:,    75)                            ! rate_const*M*CO3m_H2O*Hp_4H2O
      rxt_rates(:ncol,:,   256) = rxt_rates(:ncol,:,   256)*sol(:ncol,:,    77)*sol(:ncol,:,    67)                            ! rate_const*M*Hp_5H2O*CO3m_H2O
      rxt_rates(:ncol,:,   257) = rxt_rates(:ncol,:,   257)*sol(:ncol,:,    85)*sol(:ncol,:,    75)                            ! rate_const*M*NO3m_H2O*Hp_4H2O
      rxt_rates(:ncol,:,   258) = rxt_rates(:ncol,:,   258)*sol(:ncol,:,    85)*sol(:ncol,:,    77)                            ! rate_const*M*NO3m_H2O*Hp_5H2O
      rxt_rates(:ncol,:,   259) = rxt_rates(:ncol,:,   259)*sol(:ncol,:,    83)*sol(:ncol,:,    75)                            ! rate_const*M*NO3m*Hp_4H2O
      rxt_rates(:ncol,:,   260) = rxt_rates(:ncol,:,   260)*sol(:ncol,:,    77)*sol(:ncol,:,    65)                            ! rate_const*M*Hp_5H2O*CO3m
      rxt_rates(:ncol,:,   261) = rxt_rates(:ncol,:,   261)*sol(:ncol,:,    77)*sol(:ncol,:,    83)                            ! rate_const*M*Hp_5H2O*NO3m
      rxt_rates(:ncol,:,   262) = rxt_rates(:ncol,:,   262)*sol(:ncol,:,    63)*sol(:ncol,:,    75)                            ! rate_const*M*CLm_HCL*Hp_4H2O
      rxt_rates(:ncol,:,   263) = rxt_rates(:ncol,:,   263)*sol(:ncol,:,    77)*sol(:ncol,:,    63)                            ! rate_const*M*Hp_5H2O*CLm_HCL
      rxt_rates(:ncol,:,   264) = rxt_rates(:ncol,:,   264)*sol(:ncol,:,    87)*sol(:ncol,:,    75)                            ! rate_const*M*NO3mHNO3*Hp_4H2O
      rxt_rates(:ncol,:,   265) = rxt_rates(:ncol,:,   265)*sol(:ncol,:,    77)*sol(:ncol,:,    87)                            ! rate_const*M*Hp_5H2O*NO3mHNO3
      rxt_rates(:ncol,:,   266) = rxt_rates(:ncol,:,   266)*sol(:ncol,:,    66)*sol(:ncol,:,    75)                            ! rate_const*M*CO3m2H2O*Hp_4H2O
      rxt_rates(:ncol,:,   267) = rxt_rates(:ncol,:,   267)*sol(:ncol,:,    51)*sol(:ncol,:,   101)                            ! rate_const*NO*O3m
      rxt_rates(:ncol,:,   268) = rxt_rates(:ncol,:,   268)*sol(:ncol,:,    82)                                                ! rate_const*M*NO2m_H2O
      rxt_rates(:ncol,:,   269) = rxt_rates(:ncol,:,   269)*sol(:ncol,:,    84)                                                ! rate_const*M*NO3m2H2O
      rxt_rates(:ncol,:,   270) = rxt_rates(:ncol,:,   270)*sol(:ncol,:,    87)                                                ! rate_const*M*NO3mHNO3
      rxt_rates(:ncol,:,   271) = rxt_rates(:ncol,:,   271)*sol(:ncol,:,    40)*sol(:ncol,:,    83)                            ! rate_const*M*HCL*NO3m
      rxt_rates(:ncol,:,   272) = rxt_rates(:ncol,:,   272)*sol(:ncol,:,    52)*sol(:ncol,:,   101)                            ! rate_const*NO2*O3m
      rxt_rates(:ncol,:,   273) = rxt_rates(:ncol,:,   273)*sol(:ncol,:,    52)*sol(:ncol,:,   101)                            ! rate_const*NO2*O3m
      rxt_rates(:ncol,:,   274) = rxt_rates(:ncol,:,   274)*sol(:ncol,:,    51)*sol(:ncol,:,   101)                            ! rate_const*NO*O3m
      rxt_rates(:ncol,:,   275) = rxt_rates(:ncol,:,   275)*sol(:ncol,:,    65)*sol(:ncol,:,    51)                            ! rate_const*CO3m*NO
      rxt_rates(:ncol,:,   276) = rxt_rates(:ncol,:,   276)*sol(:ncol,:,    65)*sol(:ncol,:,    52)                            ! rate_const*CO3m*NO2
      rxt_rates(:ncol,:,   277) = rxt_rates(:ncol,:,   277)*sol(:ncol,:,    85)                                                ! rate_const*M*NO3m_H2O
      rxt_rates(:ncol,:,   278) = rxt_rates(:ncol,:,   278)*sol(:ncol,:,    67)                                                ! rate_const*M*CO3m_H2O
      rxt_rates(:ncol,:,   279) = rxt_rates(:ncol,:,   279)*sol(:ncol,:,    66)                                                ! rate_const*M*CO3m2H2O
      rxt_rates(:ncol,:,   280) = rxt_rates(:ncol,:,   280)*sol(:ncol,:,    60)*sol(:ncol,:,    81)                            ! rate_const*CL*NO2m
      rxt_rates(:ncol,:,   281) = rxt_rates(:ncol,:,   281)*sol(:ncol,:,    24)*sol(:ncol,:,    81)                            ! rate_const*CLO*NO2m
      rxt_rates(:ncol,:,   282) = rxt_rates(:ncol,:,   282)*sol(:ncol,:,    32)*sol(:ncol,:,    81)                            ! rate_const*H*NO2m
      rxt_rates(:ncol,:,   283) = rxt_rates(:ncol,:,   283)*sol(:ncol,:,    81)*sol(:ncol,:,   110)                            ! rate_const*M*NO2m*H2O
      rxt_rates(:ncol,:,   284) = rxt_rates(:ncol,:,   284)*sol(:ncol,:,    40)*sol(:ncol,:,    81)                            ! rate_const*HCL*NO2m
      rxt_rates(:ncol,:,   285) = rxt_rates(:ncol,:,   285)*sol(:ncol,:,    42)*sol(:ncol,:,    81)                            ! rate_const*HNO3*NO2m
      rxt_rates(:ncol,:,   286) = rxt_rates(:ncol,:,   286)*sol(:ncol,:,    52)*sol(:ncol,:,    81)                            ! rate_const*NO2*NO2m
      rxt_rates(:ncol,:,   287) = rxt_rates(:ncol,:,   287)*sol(:ncol,:,    81)*sol(:ncol,:,    56)                            ! rate_const*NO2m*O3
      rxt_rates(:ncol,:,   288) = rxt_rates(:ncol,:,   288)*sol(:ncol,:,    84)*sol(:ncol,:,    50)                            ! rate_const*NO3m2H2O*N2O5
      rxt_rates(:ncol,:,   289) = rxt_rates(:ncol,:,   289)*sol(:ncol,:,    85)*sol(:ncol,:,   110)                            ! rate_const*M*NO3m_H2O*H2O
      rxt_rates(:ncol,:,   290) = rxt_rates(:ncol,:,   290)*sol(:ncol,:,    42)*sol(:ncol,:,    85)                            ! rate_const*HNO3*NO3m_H2O
      rxt_rates(:ncol,:,   291) = rxt_rates(:ncol,:,   291)*sol(:ncol,:,   110)*sol(:ncol,:,    83)                            ! rate_const*M*H2O*NO3m
      rxt_rates(:ncol,:,   292) = rxt_rates(:ncol,:,   292)*sol(:ncol,:,    85)*sol(:ncol,:,    50)                            ! rate_const*NO3m_H2O*N2O5
      rxt_rates(:ncol,:,   293) = rxt_rates(:ncol,:,   293)*sol(:ncol,:,    40)*sol(:ncol,:,    83)                            ! rate_const*HCL*NO3m
      rxt_rates(:ncol,:,   294) = rxt_rates(:ncol,:,   294)*sol(:ncol,:,    42)*sol(:ncol,:,    86)                            ! rate_const*HNO3*NO3m_HCL
      rxt_rates(:ncol,:,   295) = rxt_rates(:ncol,:,   295)*sol(:ncol,:,    83)*sol(:ncol,:,    42)                            ! rate_const*M*NO3m*HNO3
      rxt_rates(:ncol,:,   296) = rxt_rates(:ncol,:,   296)*sol(:ncol,:,    83)*sol(:ncol,:,    54)                            ! rate_const*NO3m*O
      rxt_rates(:ncol,:,   297) = rxt_rates(:ncol,:,   297)*sol(:ncol,:,    56)*sol(:ncol,:,    83)                            ! rate_const*O3*NO3m
      rxt_rates(:ncol,:,   298) = rxt_rates(:ncol,:,   298)*sol(:ncol,:,    89)*sol(:ncol,:,    69)                            ! rate_const*NOp_2H2O*e
      rxt_rates(:ncol,:,   299) = rxt_rates(:ncol,:,   299)*sol(:ncol,:,    90)*sol(:ncol,:,    69)                            ! rate_const*NOp_3H2O*e
      rxt_rates(:ncol,:,   300) = rxt_rates(:ncol,:,   300)*sol(:ncol,:,   110)*sol(:ncol,:,    90)                            ! rate_const*H2O*NOp_3H2O
      rxt_rates(:ncol,:,   301) = rxt_rates(:ncol,:,   301)*sol(:ncol,:,    91)*sol(:ncol,:,    69)                            ! rate_const*NOp_CO2*e
      rxt_rates(:ncol,:,   302) = rxt_rates(:ncol,:,   302)*sol(:ncol,:,    91)*sol(:ncol,:,   110)                            ! rate_const*NOp_CO2*H2O
      rxt_rates(:ncol,:,   303) = rxt_rates(:ncol,:,   303)*sol(:ncol,:,    92)*sol(:ncol,:,    69)                            ! rate_const*NOp_H2O*e
      rxt_rates(:ncol,:,   304) = rxt_rates(:ncol,:,   304)*sol(:ncol,:,    32)*sol(:ncol,:,    92)                            ! rate_const*H*NOp_H2O
      rxt_rates(:ncol,:,   305) = rxt_rates(:ncol,:,   305)*sol(:ncol,:,    92)*sol(:ncol,:,    43)                            ! rate_const*NOp_H2O*HO2
      rxt_rates(:ncol,:,   306) = rxt_rates(:ncol,:,   306)*sol(:ncol,:,    92)*sol(:ncol,:,   104)                            ! rate_const*NOp_H2O*OH
      rxt_rates(:ncol,:,   307) = rxt_rates(:ncol,:,   307)*sol(:ncol,:,    28)*sol(:ncol,:,    93)                            ! rate_const*CO2*NOp_N2
      rxt_rates(:ncol,:,   308) = rxt_rates(:ncol,:,   308)*sol(:ncol,:,    93)*sol(:ncol,:,   110)                            ! rate_const*NOp_N2*H2O
      rxt_rates(:ncol,:,   309) = rxt_rates(:ncol,:,   309)*sol(:ncol,:,    98)*sol(:ncol,:,    60)                            ! rate_const*O2m*CL
      rxt_rates(:ncol,:,   310) = rxt_rates(:ncol,:,   310)*sol(:ncol,:,    24)*sol(:ncol,:,    98)                            ! rate_const*CLO*O2m
      rxt_rates(:ncol,:,   311) = rxt_rates(:ncol,:,   311)*sol(:ncol,:,    28)*sol(:ncol,:,    98)                            ! rate_const*M*CO2*O2m
      rxt_rates(:ncol,:,   312) = rxt_rates(:ncol,:,   312)*sol(:ncol,:,    32)*sol(:ncol,:,    98)                            ! rate_const*H*O2m
      rxt_rates(:ncol,:,   313) = rxt_rates(:ncol,:,   313)*sol(:ncol,:,    98)*sol(:ncol,:,    40)                            ! rate_const*O2m*HCL
      rxt_rates(:ncol,:,   314) = rxt_rates(:ncol,:,   314)*sol(:ncol,:,    98)*sol(:ncol,:,    42)                            ! rate_const*O2m*HNO3
      rxt_rates(:ncol,:,   315) = rxt_rates(:ncol,:,   315)*sol(:ncol,:,    52)*sol(:ncol,:,    98)                            ! rate_const*NO2*O2m
      rxt_rates(:ncol,:,   316) = rxt_rates(:ncol,:,   316)*sol(:ncol,:,    96)*sol(:ncol,:,    98)                            ! rate_const*O2_1D*O2m
      rxt_rates(:ncol,:,   317) = rxt_rates(:ncol,:,   317)*sol(:ncol,:,    55)*sol(:ncol,:,    98)                            ! rate_const*M*O2*O2m
      rxt_rates(:ncol,:,   318) = rxt_rates(:ncol,:,   318)*sol(:ncol,:,    56)*sol(:ncol,:,    98)                            ! rate_const*O3*O2m
      rxt_rates(:ncol,:,   319) = rxt_rates(:ncol,:,   319)*sol(:ncol,:,    54)*sol(:ncol,:,    98)                            ! rate_const*O*O2m
      rxt_rates(:ncol,:,   320) = rxt_rates(:ncol,:,   320)*sol(:ncol,:,    98)*sol(:ncol,:,    54)                            ! rate_const*O2m*O
      rxt_rates(:ncol,:,   321) = rxt_rates(:ncol,:,   321)*sol(:ncol,:,   100)*sol(:ncol,:,    69)                            ! rate_const*O2p_H2O*e
      rxt_rates(:ncol,:,   322) = rxt_rates(:ncol,:,   322)*sol(:ncol,:,   100)*sol(:ncol,:,   110)                            ! rate_const*O2p_H2O*H2O
      rxt_rates(:ncol,:,   323) = rxt_rates(:ncol,:,   323)*sol(:ncol,:,   100)*sol(:ncol,:,   110)                            ! rate_const*O2p_H2O*H2O
      rxt_rates(:ncol,:,   324) = rxt_rates(:ncol,:,   324)*sol(:ncol,:,   110)*sol(:ncol,:,    99)                            ! rate_const*M*H2O*O2p
      rxt_rates(:ncol,:,   325) = rxt_rates(:ncol,:,   325)*sol(:ncol,:,   101)*sol(:ncol,:,    28)                            ! rate_const*O3m*CO2
      rxt_rates(:ncol,:,   326) = rxt_rates(:ncol,:,   326)*sol(:ncol,:,   101)*sol(:ncol,:,    32)                            ! rate_const*O3m*H
      rxt_rates(:ncol,:,   327) = rxt_rates(:ncol,:,   327)*sol(:ncol,:,    56)*sol(:ncol,:,   101)                            ! rate_const*O3*O3m
      rxt_rates(:ncol,:,   328) = rxt_rates(:ncol,:,   328)*sol(:ncol,:,   101)*sol(:ncol,:,    54)                            ! rate_const*O3m*O
      rxt_rates(:ncol,:,   329) = rxt_rates(:ncol,:,   329)*sol(:ncol,:,    54)*sol(:ncol,:,   101)                            ! rate_const*O*O3m
      rxt_rates(:ncol,:,   330) = rxt_rates(:ncol,:,   330)*sol(:ncol,:,    28)*sol(:ncol,:,   102)                            ! rate_const*CO2*O4m
      rxt_rates(:ncol,:,   331) = rxt_rates(:ncol,:,   331)*sol(:ncol,:,    54)*sol(:ncol,:,   102)                            ! rate_const*O*O4m
      rxt_rates(:ncol,:,   332) = rxt_rates(:ncol,:,   332)*sol(:ncol,:,   110)*sol(:ncol,:,   103)                            ! rate_const*H2O*O4p
      rxt_rates(:ncol,:,   333) = rxt_rates(:ncol,:,   333)*sol(:ncol,:,   103)*sol(:ncol,:,    54)                            ! rate_const*O4p*O
      rxt_rates(:ncol,:,   334) = rxt_rates(:ncol,:,   334)*sol(:ncol,:,   103)*sol(:ncol,:,    96)                            ! rate_const*O4p*O2_1D
      rxt_rates(:ncol,:,   335) = rxt_rates(:ncol,:,   335)*sol(:ncol,:,    47)*sol(:ncol,:,   104)                            ! rate_const*HONO*OH
      rxt_rates(:ncol,:,   336) = rxt_rates(:ncol,:,   336)*sol(:ncol,:,    60)*sol(:ncol,:,   105)                            ! rate_const*CL*OHm
      rxt_rates(:ncol,:,   337) = rxt_rates(:ncol,:,   337)*sol(:ncol,:,    24)*sol(:ncol,:,   105)                            ! rate_const*CLO*OHm
      rxt_rates(:ncol,:,   338) = rxt_rates(:ncol,:,   338)*sol(:ncol,:,    28)*sol(:ncol,:,   105)                            ! rate_const*M*CO2*OHm
      rxt_rates(:ncol,:,   339) = rxt_rates(:ncol,:,   339)*sol(:ncol,:,    32)*sol(:ncol,:,   105)                            ! rate_const*H*OHm
      rxt_rates(:ncol,:,   340) = rxt_rates(:ncol,:,   340)*sol(:ncol,:,   105)*sol(:ncol,:,    40)                            ! rate_const*OHm*HCL
      rxt_rates(:ncol,:,   341) = rxt_rates(:ncol,:,   341)*sol(:ncol,:,    52)*sol(:ncol,:,   105)                            ! rate_const*NO2*OHm
      rxt_rates(:ncol,:,   342) = rxt_rates(:ncol,:,   342)*sol(:ncol,:,   105)*sol(:ncol,:,    54)                            ! rate_const*OHm*O
      rxt_rates(:ncol,:,   343) = rxt_rates(:ncol,:,   343)*sol(:ncol,:,   105)*sol(:ncol,:,    56)                            ! rate_const*OHm*O3
      rxt_rates(:ncol,:,   344) = rxt_rates(:ncol,:,   344)*sol(:ncol,:,   104)*sol(:ncol,:,    51)                            ! rate_const*M*OH*NO
      rxt_rates(:ncol,:,   345) = rxt_rates(:ncol,:,   345)*sol(:ncol,:,   106)*sol(:ncol,:,    60)                            ! rate_const*Om*CL
      rxt_rates(:ncol,:,   346) = rxt_rates(:ncol,:,   346)*sol(:ncol,:,    24)*sol(:ncol,:,   106)                            ! rate_const*CLO*Om
      rxt_rates(:ncol,:,   347) = rxt_rates(:ncol,:,   347)*sol(:ncol,:,   106)*sol(:ncol,:,    28)                            ! rate_const*M*Om*CO2
      rxt_rates(:ncol,:,   348) = rxt_rates(:ncol,:,   348)*sol(:ncol,:,    33)*sol(:ncol,:,   106)                            ! rate_const*H2*Om
      rxt_rates(:ncol,:,   349) = rxt_rates(:ncol,:,   349)*sol(:ncol,:,   106)*sol(:ncol,:,    33)                            ! rate_const*Om*H2
      rxt_rates(:ncol,:,   350) = rxt_rates(:ncol,:,   350)*sol(:ncol,:,   106)*sol(:ncol,:,   110)                            ! rate_const*Om*H2O
      rxt_rates(:ncol,:,   351) = rxt_rates(:ncol,:,   351)*sol(:ncol,:,   106)*sol(:ncol,:,    40)                            ! rate_const*Om*HCL
      rxt_rates(:ncol,:,   352) = rxt_rates(:ncol,:,   352)*sol(:ncol,:,   106)*sol(:ncol,:,    42)                            ! rate_const*Om*HNO3
      rxt_rates(:ncol,:,   353) = rxt_rates(:ncol,:,   353)*sol(:ncol,:,   106)                                                ! rate_const*M*Om
      rxt_rates(:ncol,:,   354) = rxt_rates(:ncol,:,   354)*sol(:ncol,:,    52)*sol(:ncol,:,   106)                            ! rate_const*NO2*Om
      rxt_rates(:ncol,:,   355) = rxt_rates(:ncol,:,   355)*sol(:ncol,:,   106)*sol(:ncol,:,    54)                            ! rate_const*Om*O
      rxt_rates(:ncol,:,   356) = rxt_rates(:ncol,:,   356)*sol(:ncol,:,   106)*sol(:ncol,:,    96)                            ! rate_const*Om*O2_1D
      rxt_rates(:ncol,:,   357) = rxt_rates(:ncol,:,   357)*sol(:ncol,:,   106)*sol(:ncol,:,    55)                            ! rate_const*M*Om*O2
      rxt_rates(:ncol,:,   358) = rxt_rates(:ncol,:,   358)*sol(:ncol,:,    56)*sol(:ncol,:,   106)                            ! rate_const*O3*Om
      rxt_rates(:ncol,:,   359) = rxt_rates(:ncol,:,   359)*sol(:ncol,:,    99)*sol(:ncol,:,    55)                            ! rate_const*M*O2p*O2
      rxt_rates(:ncol,:,   360) = rxt_rates(:ncol,:,   360)*sol(:ncol,:,   110)*sol(:ncol,:,    88)                            ! rate_const*M*H2O*NOp
      rxt_rates(:ncol,:,   361) = rxt_rates(:ncol,:,   361)*sol(:ncol,:,   110)*sol(:ncol,:,    92)                            ! rate_const*M*H2O*NOp_H2O
      rxt_rates(:ncol,:,   362) = rxt_rates(:ncol,:,   362)*sol(:ncol,:,   110)*sol(:ncol,:,    89)                            ! rate_const*M*H2O*NOp_2H2O
      rxt_rates(:ncol,:,   363) = rxt_rates(:ncol,:,   363)*sol(:ncol,:,    88)*sol(:ncol,:,    28)                            ! rate_const*M*NOp*CO2
      rxt_rates(:ncol,:,   364) = rxt_rates(:ncol,:,   364)*sol(:ncol,:,    91)                                                ! rate_const*M*NOp_CO2
      rxt_rates(:ncol,:,   365) = rxt_rates(:ncol,:,   365)*sol(:ncol,:,    88)                                                ! rate_const*N2*M*NOp
      rxt_rates(:ncol,:,   366) = rxt_rates(:ncol,:,   366)*sol(:ncol,:,    93)                                                ! rate_const*M*NOp_N2
      rxt_rates(:ncol,:,   367) = rxt_rates(:ncol,:,   367)*sol(:ncol,:,    78)*sol(:ncol,:,   110)                            ! rate_const*M*Hp_H2O*H2O
      rxt_rates(:ncol,:,   368) = rxt_rates(:ncol,:,   368)*sol(:ncol,:,    72)                                                ! rate_const*M*Hp_2H2O
      rxt_rates(:ncol,:,   369) = rxt_rates(:ncol,:,   369)*sol(:ncol,:,   110)*sol(:ncol,:,    72)                            ! rate_const*M*H2O*Hp_2H2O
      rxt_rates(:ncol,:,   370) = rxt_rates(:ncol,:,   370)*sol(:ncol,:,    73)                                                ! rate_const*M*Hp_3H2O
      rxt_rates(:ncol,:,   371) = rxt_rates(:ncol,:,   371)*sol(:ncol,:,    73)*sol(:ncol,:,   110)                            ! rate_const*M*Hp_3H2O*H2O
      rxt_rates(:ncol,:,   372) = rxt_rates(:ncol,:,   372)*sol(:ncol,:,    75)                                                ! rate_const*M*Hp_4H2O
      rxt_rates(:ncol,:,   373) = rxt_rates(:ncol,:,   373)*sol(:ncol,:,    75)*sol(:ncol,:,   110)                            ! rate_const*M*Hp_4H2O*H2O
      rxt_rates(:ncol,:,   374) = rxt_rates(:ncol,:,   374)*sol(:ncol,:,    77)                                                ! rate_const*M*Hp_5H2O
      rxt_rates(:ncol,:,   375) = rxt_rates(:ncol,:,   375)*sol(:ncol,:,    69)*sol(:ncol,:,   103)                            ! rate_const*e*O4p
      rxt_rates(:ncol,:,   376) = rxt_rates(:ncol,:,   376)*sol(:ncol,:,    78)*sol(:ncol,:,    69)                            ! rate_const*Hp_H2O*e
      rxt_rates(:ncol,:,   377) = rxt_rates(:ncol,:,   377)*sol(:ncol,:,    72)*sol(:ncol,:,    69)                            ! rate_const*Hp_2H2O*e
      rxt_rates(:ncol,:,   378) = rxt_rates(:ncol,:,   378)*sol(:ncol,:,    73)*sol(:ncol,:,    69)                            ! rate_const*Hp_3H2O*e
      rxt_rates(:ncol,:,   379) = rxt_rates(:ncol,:,   379)*sol(:ncol,:,    69)*sol(:ncol,:,    93)                            ! rate_const*e*NOp_N2
      rxt_rates(:ncol,:,   380) = rxt_rates(:ncol,:,   380)*sol(:ncol,:,    62)                                                ! rate_const*M*CLm_H2O
      rxt_rates(:ncol,:,   381) = rxt_rates(:ncol,:,   381)*sol(:ncol,:,    63)                                                ! rate_const*M*CLm_HCL
      rxt_rates(:ncol,:,   382) = rxt_rates(:ncol,:,   382)*sol(:ncol,:,    96)                                                ! rate_const*O2_1D
      rxt_rates(:ncol,:,   383) = rxt_rates(:ncol,:,   383)*sol(:ncol,:,    97)                                                ! rate_const*O2_1S
      rxt_rates(:ncol,:,   384) = rxt_rates(:ncol,:,   384)*sol(:ncol,:,    95)*sol(:ncol,:,    33)                            ! rate_const*O1D*H2
      rxt_rates(:ncol,:,   385) = rxt_rates(:ncol,:,   385)*sol(:ncol,:,    95)*sol(:ncol,:,   110)                            ! rate_const*O1D*H2O
      rxt_rates(:ncol,:,   386) = rxt_rates(:ncol,:,   386)*sol(:ncol,:,    95)                                                ! rate_const*N2*O1D
      rxt_rates(:ncol,:,   387) = rxt_rates(:ncol,:,   387)*sol(:ncol,:,    95)*sol(:ncol,:,    55)                            ! rate_const*O1D*O2
      rxt_rates(:ncol,:,   388) = rxt_rates(:ncol,:,   388)*sol(:ncol,:,    95)*sol(:ncol,:,    55)                            ! rate_const*O1D*O2
      rxt_rates(:ncol,:,   389) = rxt_rates(:ncol,:,   389)*sol(:ncol,:,    95)*sol(:ncol,:,    56)                            ! rate_const*O1D*O3
      rxt_rates(:ncol,:,   390) = rxt_rates(:ncol,:,   390)*sol(:ncol,:,    96)                                                ! rate_const*N2*O2_1D
      rxt_rates(:ncol,:,   391) = rxt_rates(:ncol,:,   391)*sol(:ncol,:,    96)*sol(:ncol,:,    54)                            ! rate_const*O2_1D*O
      rxt_rates(:ncol,:,   392) = rxt_rates(:ncol,:,   392)*sol(:ncol,:,    96)*sol(:ncol,:,    55)                            ! rate_const*O2_1D*O2
      rxt_rates(:ncol,:,   393) = rxt_rates(:ncol,:,   393)*sol(:ncol,:,    97)*sol(:ncol,:,    28)                            ! rate_const*O2_1S*CO2
      rxt_rates(:ncol,:,   394) = rxt_rates(:ncol,:,   394)*sol(:ncol,:,    97)                                                ! rate_const*N2*O2_1S
      rxt_rates(:ncol,:,   395) = rxt_rates(:ncol,:,   395)*sol(:ncol,:,    97)*sol(:ncol,:,    54)                            ! rate_const*O2_1S*O
      rxt_rates(:ncol,:,   396) = rxt_rates(:ncol,:,   396)*sol(:ncol,:,    97)*sol(:ncol,:,    55)                            ! rate_const*O2_1S*O2
      rxt_rates(:ncol,:,   397) = rxt_rates(:ncol,:,   397)*sol(:ncol,:,    97)*sol(:ncol,:,    56)                            ! rate_const*O2_1S*O3
      rxt_rates(:ncol,:,   398) = rxt_rates(:ncol,:,   398)*sol(:ncol,:,    54)*sol(:ncol,:,    56)                            ! rate_const*O*O3
      rxt_rates(:ncol,:,   399) = rxt_rates(:ncol,:,   399)*sol(:ncol,:,    54)*sol(:ncol,:,    54)                            ! rate_const*M*O*O
      rxt_rates(:ncol,:,   400) = rxt_rates(:ncol,:,   400)*sol(:ncol,:,    54)*sol(:ncol,:,    55)                            ! rate_const*M*O*O2
      rxt_rates(:ncol,:,   401) = rxt_rates(:ncol,:,   401)*sol(:ncol,:,    33)*sol(:ncol,:,    54)                            ! rate_const*H2*O
      rxt_rates(:ncol,:,   402) = rxt_rates(:ncol,:,   402)*sol(:ncol,:,    35)*sol(:ncol,:,    54)                            ! rate_const*H2O2*O
      rxt_rates(:ncol,:,   403) = rxt_rates(:ncol,:,   403)*sol(:ncol,:,    32)*sol(:ncol,:,    43)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,   404) = rxt_rates(:ncol,:,   404)*sol(:ncol,:,    32)*sol(:ncol,:,    43)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,   405) = rxt_rates(:ncol,:,   405)*sol(:ncol,:,    32)*sol(:ncol,:,    43)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,   406) = rxt_rates(:ncol,:,   406)*sol(:ncol,:,    32)*sol(:ncol,:,    55)                            ! rate_const*M*H*O2
      rxt_rates(:ncol,:,   407) = rxt_rates(:ncol,:,   407)*sol(:ncol,:,    43)*sol(:ncol,:,    54)                            ! rate_const*HO2*O
      rxt_rates(:ncol,:,   408) = rxt_rates(:ncol,:,   408)*sol(:ncol,:,    43)*sol(:ncol,:,    56)                            ! rate_const*HO2*O3
      rxt_rates(:ncol,:,   409) = rxt_rates(:ncol,:,   409)*sol(:ncol,:,    32)*sol(:ncol,:,    56)                            ! rate_const*H*O3
      rxt_rates(:ncol,:,   410) = rxt_rates(:ncol,:,   410)*sol(:ncol,:,   104)*sol(:ncol,:,    33)                            ! rate_const*OH*H2
      rxt_rates(:ncol,:,   411) = rxt_rates(:ncol,:,   411)*sol(:ncol,:,   104)*sol(:ncol,:,    35)                            ! rate_const*OH*H2O2
      rxt_rates(:ncol,:,   412) = rxt_rates(:ncol,:,   412)*sol(:ncol,:,   104)*sol(:ncol,:,    43)                            ! rate_const*OH*HO2
      rxt_rates(:ncol,:,   413) = rxt_rates(:ncol,:,   413)*sol(:ncol,:,   104)*sol(:ncol,:,    54)                            ! rate_const*OH*O
      rxt_rates(:ncol,:,   414) = rxt_rates(:ncol,:,   414)*sol(:ncol,:,   104)*sol(:ncol,:,    56)                            ! rate_const*OH*O3
      rxt_rates(:ncol,:,   415) = rxt_rates(:ncol,:,   415)*sol(:ncol,:,   104)*sol(:ncol,:,   104)                            ! rate_const*OH*OH
      rxt_rates(:ncol,:,   416) = rxt_rates(:ncol,:,   416)*sol(:ncol,:,   104)*sol(:ncol,:,   104)                            ! rate_const*M*OH*OH
      rxt_rates(:ncol,:,   417) = rxt_rates(:ncol,:,   417)*sol(:ncol,:,    43)*sol(:ncol,:,    43)                            ! rate_const*HO2*HO2
      rxt_rates(:ncol,:,   418) = rxt_rates(:ncol,:,   418)*sol(:ncol,:,    44)*sol(:ncol,:,   104)                            ! rate_const*HO2NO2*OH
      rxt_rates(:ncol,:,   419) = rxt_rates(:ncol,:,   419)*sol(:ncol,:,    79)*sol(:ncol,:,    54)                            ! rate_const*N2D*O
      rxt_rates(:ncol,:,   420) = rxt_rates(:ncol,:,   420)*sol(:ncol,:,    79)*sol(:ncol,:,    55)                            ! rate_const*N2D*O2
      rxt_rates(:ncol,:,   421) = rxt_rates(:ncol,:,   421)*sol(:ncol,:,    48)*sol(:ncol,:,    51)                            ! rate_const*N*NO
      rxt_rates(:ncol,:,   422) = rxt_rates(:ncol,:,   422)*sol(:ncol,:,    48)*sol(:ncol,:,    52)                            ! rate_const*N*NO2
      rxt_rates(:ncol,:,   423) = rxt_rates(:ncol,:,   423)*sol(:ncol,:,    48)*sol(:ncol,:,    52)                            ! rate_const*N*NO2
      rxt_rates(:ncol,:,   424) = rxt_rates(:ncol,:,   424)*sol(:ncol,:,    48)*sol(:ncol,:,    52)                            ! rate_const*N*NO2
      rxt_rates(:ncol,:,   425) = rxt_rates(:ncol,:,   425)*sol(:ncol,:,    48)*sol(:ncol,:,    55)                            ! rate_const*N*O2
      rxt_rates(:ncol,:,   426) = rxt_rates(:ncol,:,   426)*sol(:ncol,:,    52)*sol(:ncol,:,    54)                            ! rate_const*NO2*O
      rxt_rates(:ncol,:,   427) = rxt_rates(:ncol,:,   427)*sol(:ncol,:,    52)*sol(:ncol,:,    56)                            ! rate_const*NO2*O3
      rxt_rates(:ncol,:,   428) = rxt_rates(:ncol,:,   428)*sol(:ncol,:,    52)*sol(:ncol,:,    54)                            ! rate_const*M*NO2*O
      rxt_rates(:ncol,:,   429) = rxt_rates(:ncol,:,   429)*sol(:ncol,:,    53)*sol(:ncol,:,    43)                            ! rate_const*NO3*HO2
      rxt_rates(:ncol,:,   430) = rxt_rates(:ncol,:,   430)*sol(:ncol,:,    53)*sol(:ncol,:,    51)                            ! rate_const*NO3*NO
      rxt_rates(:ncol,:,   431) = rxt_rates(:ncol,:,   431)*sol(:ncol,:,    53)*sol(:ncol,:,    54)                            ! rate_const*NO3*O
      rxt_rates(:ncol,:,   432) = rxt_rates(:ncol,:,   432)*sol(:ncol,:,    53)*sol(:ncol,:,   104)                            ! rate_const*NO3*OH
      rxt_rates(:ncol,:,   433) = rxt_rates(:ncol,:,   433)*sol(:ncol,:,    48)*sol(:ncol,:,   104)                            ! rate_const*N*OH
      rxt_rates(:ncol,:,   434) = rxt_rates(:ncol,:,   434)*sol(:ncol,:,    51)*sol(:ncol,:,    43)                            ! rate_const*NO*HO2
      rxt_rates(:ncol,:,   435) = rxt_rates(:ncol,:,   435)*sol(:ncol,:,    51)*sol(:ncol,:,    56)                            ! rate_const*NO*O3
      rxt_rates(:ncol,:,   436) = rxt_rates(:ncol,:,   436)*sol(:ncol,:,    51)*sol(:ncol,:,    54)                            ! rate_const*M*NO*O
      rxt_rates(:ncol,:,   437) = rxt_rates(:ncol,:,   437)*sol(:ncol,:,    95)*sol(:ncol,:,    49)                            ! rate_const*O1D*N2O
      rxt_rates(:ncol,:,   438) = rxt_rates(:ncol,:,   438)*sol(:ncol,:,    95)*sol(:ncol,:,    49)                            ! rate_const*O1D*N2O
      rxt_rates(:ncol,:,   439) = rxt_rates(:ncol,:,   439)*sol(:ncol,:,    52)*sol(:ncol,:,    43)                            ! rate_const*M*NO2*HO2
      rxt_rates(:ncol,:,   440) = rxt_rates(:ncol,:,   440)*sol(:ncol,:,    52)*sol(:ncol,:,    53)                            ! rate_const*M*NO2*NO3
      rxt_rates(:ncol,:,   441) = rxt_rates(:ncol,:,   441)*sol(:ncol,:,    52)*sol(:ncol,:,   104)                            ! rate_const*M*NO2*OH
      rxt_rates(:ncol,:,   442) = rxt_rates(:ncol,:,   442)*sol(:ncol,:,    42)*sol(:ncol,:,   104)                            ! rate_const*HNO3*OH
      rxt_rates(:ncol,:,   443) = rxt_rates(:ncol,:,   443)*sol(:ncol,:,    44)                                                ! rate_const*M*HO2NO2
      rxt_rates(:ncol,:,   444) = rxt_rates(:ncol,:,   444)*sol(:ncol,:,    50)                                                ! rate_const*M*N2O5
      rxt_rates(:ncol,:,   445) = rxt_rates(:ncol,:,   445)*sol(:ncol,:,    60)*sol(:ncol,:,    14)                            ! rate_const*CL*CH2O
      rxt_rates(:ncol,:,   446) = rxt_rates(:ncol,:,   446)*sol(:ncol,:,    60)*sol(:ncol,:,    20)                            ! rate_const*CL*CH4
      rxt_rates(:ncol,:,   447) = rxt_rates(:ncol,:,   447)*sol(:ncol,:,    60)*sol(:ncol,:,    33)                            ! rate_const*CL*H2
      rxt_rates(:ncol,:,   448) = rxt_rates(:ncol,:,   448)*sol(:ncol,:,    60)*sol(:ncol,:,    35)                            ! rate_const*CL*H2O2
      rxt_rates(:ncol,:,   449) = rxt_rates(:ncol,:,   449)*sol(:ncol,:,    60)*sol(:ncol,:,    43)                            ! rate_const*CL*HO2
      rxt_rates(:ncol,:,   450) = rxt_rates(:ncol,:,   450)*sol(:ncol,:,    60)*sol(:ncol,:,    43)                            ! rate_const*CL*HO2
      rxt_rates(:ncol,:,   451) = rxt_rates(:ncol,:,   451)*sol(:ncol,:,    60)*sol(:ncol,:,    56)                            ! rate_const*CL*O3
      rxt_rates(:ncol,:,   452) = rxt_rates(:ncol,:,   452)*sol(:ncol,:,    24)*sol(:ncol,:,    18)                            ! rate_const*CLO*CH3O2
      rxt_rates(:ncol,:,   453) = rxt_rates(:ncol,:,   453)*sol(:ncol,:,    24)*sol(:ncol,:,    24)                            ! rate_const*CLO*CLO
      rxt_rates(:ncol,:,   454) = rxt_rates(:ncol,:,   454)*sol(:ncol,:,    24)*sol(:ncol,:,    24)                            ! rate_const*CLO*CLO
      rxt_rates(:ncol,:,   455) = rxt_rates(:ncol,:,   455)*sol(:ncol,:,    24)*sol(:ncol,:,    24)                            ! rate_const*CLO*CLO
      rxt_rates(:ncol,:,   456) = rxt_rates(:ncol,:,   456)*sol(:ncol,:,    24)*sol(:ncol,:,    43)                            ! rate_const*CLO*HO2
      rxt_rates(:ncol,:,   457) = rxt_rates(:ncol,:,   457)*sol(:ncol,:,    24)*sol(:ncol,:,    51)                            ! rate_const*CLO*NO
      rxt_rates(:ncol,:,   458) = rxt_rates(:ncol,:,   458)*sol(:ncol,:,    25)*sol(:ncol,:,    60)                            ! rate_const*CLONO2*CL
      rxt_rates(:ncol,:,   459) = rxt_rates(:ncol,:,   459)*sol(:ncol,:,    24)*sol(:ncol,:,    52)                            ! rate_const*M*CLO*NO2
      rxt_rates(:ncol,:,   460) = rxt_rates(:ncol,:,   460)*sol(:ncol,:,    25)*sol(:ncol,:,    54)                            ! rate_const*CLONO2*O
      rxt_rates(:ncol,:,   461) = rxt_rates(:ncol,:,   461)*sol(:ncol,:,    25)*sol(:ncol,:,   104)                            ! rate_const*CLONO2*OH
      rxt_rates(:ncol,:,   462) = rxt_rates(:ncol,:,   462)*sol(:ncol,:,    24)*sol(:ncol,:,    54)                            ! rate_const*CLO*O
      rxt_rates(:ncol,:,   463) = rxt_rates(:ncol,:,   463)*sol(:ncol,:,    24)*sol(:ncol,:,   104)                            ! rate_const*CLO*OH
      rxt_rates(:ncol,:,   464) = rxt_rates(:ncol,:,   464)*sol(:ncol,:,    24)*sol(:ncol,:,   104)                            ! rate_const*CLO*OH
      rxt_rates(:ncol,:,   465) = rxt_rates(:ncol,:,   465)*sol(:ncol,:,    40)*sol(:ncol,:,    54)                            ! rate_const*HCL*O
      rxt_rates(:ncol,:,   466) = rxt_rates(:ncol,:,   466)*sol(:ncol,:,    40)*sol(:ncol,:,   104)                            ! rate_const*HCL*OH
      rxt_rates(:ncol,:,   467) = rxt_rates(:ncol,:,   467)*sol(:ncol,:,    46)*sol(:ncol,:,    60)                            ! rate_const*HOCL*CL
      rxt_rates(:ncol,:,   468) = rxt_rates(:ncol,:,   468)*sol(:ncol,:,    46)*sol(:ncol,:,    54)                            ! rate_const*HOCL*O
      rxt_rates(:ncol,:,   469) = rxt_rates(:ncol,:,   469)*sol(:ncol,:,    46)*sol(:ncol,:,   104)                            ! rate_const*HOCL*OH
      rxt_rates(:ncol,:,   470) = rxt_rates(:ncol,:,   470)*sol(:ncol,:,    95)*sol(:ncol,:,     5)                            ! rate_const*O1D*CCL4
      rxt_rates(:ncol,:,   471) = rxt_rates(:ncol,:,   471)*sol(:ncol,:,    95)*sol(:ncol,:,     6)                            ! rate_const*O1D*CF2CLBR
      rxt_rates(:ncol,:,   472) = rxt_rates(:ncol,:,   472)*sol(:ncol,:,    95)*sol(:ncol,:,     8)                            ! rate_const*O1D*CFC11
      rxt_rates(:ncol,:,   473) = rxt_rates(:ncol,:,   473)*sol(:ncol,:,    95)*sol(:ncol,:,     9)                            ! rate_const*O1D*CFC113
      rxt_rates(:ncol,:,   474) = rxt_rates(:ncol,:,   474)*sol(:ncol,:,    95)*sol(:ncol,:,    10)                            ! rate_const*O1D*CFC114
      rxt_rates(:ncol,:,   475) = rxt_rates(:ncol,:,   475)*sol(:ncol,:,    95)*sol(:ncol,:,    11)                            ! rate_const*O1D*CFC115
      rxt_rates(:ncol,:,   476) = rxt_rates(:ncol,:,   476)*sol(:ncol,:,    95)*sol(:ncol,:,    12)                            ! rate_const*O1D*CFC12
      rxt_rates(:ncol,:,   477) = rxt_rates(:ncol,:,   477)*sol(:ncol,:,    95)*sol(:ncol,:,    40)                            ! rate_const*O1D*HCL
      rxt_rates(:ncol,:,   478) = rxt_rates(:ncol,:,   478)*sol(:ncol,:,    95)*sol(:ncol,:,    40)                            ! rate_const*O1D*HCL
      rxt_rates(:ncol,:,   479) = rxt_rates(:ncol,:,   479)*sol(:ncol,:,    24)*sol(:ncol,:,    24)                            ! rate_const*M*CLO*CLO
      rxt_rates(:ncol,:,   480) = rxt_rates(:ncol,:,   480)*sol(:ncol,:,    23)                                                ! rate_const*M*CL2O2
      rxt_rates(:ncol,:,   481) = rxt_rates(:ncol,:,   481)*sol(:ncol,:,    59)*sol(:ncol,:,    14)                            ! rate_const*BR*CH2O
      rxt_rates(:ncol,:,   482) = rxt_rates(:ncol,:,   482)*sol(:ncol,:,    59)*sol(:ncol,:,    43)                            ! rate_const*BR*HO2
      rxt_rates(:ncol,:,   483) = rxt_rates(:ncol,:,   483)*sol(:ncol,:,    59)*sol(:ncol,:,    56)                            ! rate_const*BR*O3
      rxt_rates(:ncol,:,   484) = rxt_rates(:ncol,:,   484)*sol(:ncol,:,     2)*sol(:ncol,:,     2)                            ! rate_const*BRO*BRO
      rxt_rates(:ncol,:,   485) = rxt_rates(:ncol,:,   485)*sol(:ncol,:,     2)*sol(:ncol,:,    24)                            ! rate_const*BRO*CLO
      rxt_rates(:ncol,:,   486) = rxt_rates(:ncol,:,   486)*sol(:ncol,:,     2)*sol(:ncol,:,    24)                            ! rate_const*BRO*CLO
      rxt_rates(:ncol,:,   487) = rxt_rates(:ncol,:,   487)*sol(:ncol,:,     2)*sol(:ncol,:,    24)                            ! rate_const*BRO*CLO
      rxt_rates(:ncol,:,   488) = rxt_rates(:ncol,:,   488)*sol(:ncol,:,     2)*sol(:ncol,:,    43)                            ! rate_const*BRO*HO2
      rxt_rates(:ncol,:,   489) = rxt_rates(:ncol,:,   489)*sol(:ncol,:,     2)*sol(:ncol,:,    51)                            ! rate_const*BRO*NO
      rxt_rates(:ncol,:,   490) = rxt_rates(:ncol,:,   490)*sol(:ncol,:,     2)*sol(:ncol,:,    52)                            ! rate_const*M*BRO*NO2
      rxt_rates(:ncol,:,   491) = rxt_rates(:ncol,:,   491)*sol(:ncol,:,     3)*sol(:ncol,:,    54)                            ! rate_const*BRONO2*O
      rxt_rates(:ncol,:,   492) = rxt_rates(:ncol,:,   492)*sol(:ncol,:,     2)*sol(:ncol,:,    54)                            ! rate_const*BRO*O
      rxt_rates(:ncol,:,   493) = rxt_rates(:ncol,:,   493)*sol(:ncol,:,     2)*sol(:ncol,:,   104)                            ! rate_const*BRO*OH
      rxt_rates(:ncol,:,   494) = rxt_rates(:ncol,:,   494)*sol(:ncol,:,    36)*sol(:ncol,:,    54)                            ! rate_const*HBR*O
      rxt_rates(:ncol,:,   495) = rxt_rates(:ncol,:,   495)*sol(:ncol,:,    36)*sol(:ncol,:,   104)                            ! rate_const*HBR*OH
      rxt_rates(:ncol,:,   496) = rxt_rates(:ncol,:,   496)*sol(:ncol,:,    45)*sol(:ncol,:,    54)                            ! rate_const*HOBR*O
      rxt_rates(:ncol,:,   497) = rxt_rates(:ncol,:,   497)*sol(:ncol,:,    95)*sol(:ncol,:,     7)                            ! rate_const*O1D*CF3BR
      rxt_rates(:ncol,:,   498) = rxt_rates(:ncol,:,   498)*sol(:ncol,:,    95)*sol(:ncol,:,    21)                            ! rate_const*O1D*CHBR3
      rxt_rates(:ncol,:,   499) = rxt_rates(:ncol,:,   499)*sol(:ncol,:,    95)*sol(:ncol,:,    34)                            ! rate_const*O1D*H2402
      rxt_rates(:ncol,:,   500) = rxt_rates(:ncol,:,   500)*sol(:ncol,:,    95)*sol(:ncol,:,    36)                            ! rate_const*O1D*HBR
      rxt_rates(:ncol,:,   501) = rxt_rates(:ncol,:,   501)*sol(:ncol,:,    95)*sol(:ncol,:,    36)                            ! rate_const*O1D*HBR
      rxt_rates(:ncol,:,   502) = rxt_rates(:ncol,:,   502)*sol(:ncol,:,    31)*sol(:ncol,:,    20)                            ! rate_const*F*CH4
      rxt_rates(:ncol,:,   503) = rxt_rates(:ncol,:,   503)*sol(:ncol,:,    31)*sol(:ncol,:,    33)                            ! rate_const*F*H2
      rxt_rates(:ncol,:,   504) = rxt_rates(:ncol,:,   504)*sol(:ncol,:,    31)*sol(:ncol,:,   110)                            ! rate_const*F*H2O
      rxt_rates(:ncol,:,   505) = rxt_rates(:ncol,:,   505)*sol(:ncol,:,    31)*sol(:ncol,:,    42)                            ! rate_const*F*HNO3
      rxt_rates(:ncol,:,   506) = rxt_rates(:ncol,:,   506)*sol(:ncol,:,    95)*sol(:ncol,:,    29)                            ! rate_const*O1D*COF2
      rxt_rates(:ncol,:,   507) = rxt_rates(:ncol,:,   507)*sol(:ncol,:,    95)*sol(:ncol,:,    30)                            ! rate_const*O1D*COFCL
      rxt_rates(:ncol,:,   508) = rxt_rates(:ncol,:,   508)*sol(:ncol,:,    13)*sol(:ncol,:,    60)                            ! rate_const*CH2BR2*CL
      rxt_rates(:ncol,:,   509) = rxt_rates(:ncol,:,   509)*sol(:ncol,:,    13)*sol(:ncol,:,   104)                            ! rate_const*CH2BR2*OH
      rxt_rates(:ncol,:,   510) = rxt_rates(:ncol,:,   510)*sol(:ncol,:,    15)*sol(:ncol,:,    60)                            ! rate_const*CH3BR*CL
      rxt_rates(:ncol,:,   511) = rxt_rates(:ncol,:,   511)*sol(:ncol,:,    15)*sol(:ncol,:,   104)                            ! rate_const*CH3BR*OH
      rxt_rates(:ncol,:,   512) = rxt_rates(:ncol,:,   512)*sol(:ncol,:,    16)*sol(:ncol,:,   104)                            ! rate_const*CH3CCL3*OH
      rxt_rates(:ncol,:,   513) = rxt_rates(:ncol,:,   513)*sol(:ncol,:,    17)*sol(:ncol,:,    60)                            ! rate_const*CH3CL*CL
      rxt_rates(:ncol,:,   514) = rxt_rates(:ncol,:,   514)*sol(:ncol,:,    17)*sol(:ncol,:,   104)                            ! rate_const*CH3CL*OH
      rxt_rates(:ncol,:,   515) = rxt_rates(:ncol,:,   515)*sol(:ncol,:,    21)*sol(:ncol,:,    60)                            ! rate_const*CHBR3*CL
      rxt_rates(:ncol,:,   516) = rxt_rates(:ncol,:,   516)*sol(:ncol,:,    21)*sol(:ncol,:,   104)                            ! rate_const*CHBR3*OH
      rxt_rates(:ncol,:,   517) = rxt_rates(:ncol,:,   517)*sol(:ncol,:,    37)*sol(:ncol,:,   104)                            ! rate_const*HCFC141B*OH
      rxt_rates(:ncol,:,   518) = rxt_rates(:ncol,:,   518)*sol(:ncol,:,    38)*sol(:ncol,:,   104)                            ! rate_const*HCFC142B*OH
      rxt_rates(:ncol,:,   519) = rxt_rates(:ncol,:,   519)*sol(:ncol,:,    39)*sol(:ncol,:,   104)                            ! rate_const*HCFC22*OH
      rxt_rates(:ncol,:,   520) = rxt_rates(:ncol,:,   520)*sol(:ncol,:,    95)*sol(:ncol,:,    13)                            ! rate_const*O1D*CH2BR2
      rxt_rates(:ncol,:,   521) = rxt_rates(:ncol,:,   521)*sol(:ncol,:,    95)*sol(:ncol,:,    15)                            ! rate_const*O1D*CH3BR
      rxt_rates(:ncol,:,   522) = rxt_rates(:ncol,:,   522)*sol(:ncol,:,    95)*sol(:ncol,:,    37)                            ! rate_const*O1D*HCFC141B
      rxt_rates(:ncol,:,   523) = rxt_rates(:ncol,:,   523)*sol(:ncol,:,    95)*sol(:ncol,:,    38)                            ! rate_const*O1D*HCFC142B
      rxt_rates(:ncol,:,   524) = rxt_rates(:ncol,:,   524)*sol(:ncol,:,    95)*sol(:ncol,:,    39)                            ! rate_const*O1D*HCFC22
      rxt_rates(:ncol,:,   525) = rxt_rates(:ncol,:,   525)*sol(:ncol,:,    14)*sol(:ncol,:,    53)                            ! rate_const*CH2O*NO3
      rxt_rates(:ncol,:,   526) = rxt_rates(:ncol,:,   526)*sol(:ncol,:,    14)*sol(:ncol,:,    54)                            ! rate_const*CH2O*O
      rxt_rates(:ncol,:,   527) = rxt_rates(:ncol,:,   527)*sol(:ncol,:,    14)*sol(:ncol,:,   104)                            ! rate_const*CH2O*OH
      rxt_rates(:ncol,:,   528) = rxt_rates(:ncol,:,   528)*sol(:ncol,:,    18)*sol(:ncol,:,    43)                            ! rate_const*CH3O2*HO2
      rxt_rates(:ncol,:,   529) = rxt_rates(:ncol,:,   529)*sol(:ncol,:,    18)*sol(:ncol,:,    51)                            ! rate_const*CH3O2*NO
      rxt_rates(:ncol,:,   530) = rxt_rates(:ncol,:,   530)*sol(:ncol,:,    19)*sol(:ncol,:,   104)                            ! rate_const*CH3OOH*OH
      rxt_rates(:ncol,:,   531) = rxt_rates(:ncol,:,   531)*sol(:ncol,:,    20)*sol(:ncol,:,   104)                            ! rate_const*CH4*OH
      rxt_rates(:ncol,:,   532) = rxt_rates(:ncol,:,   532)*sol(:ncol,:,    27)*sol(:ncol,:,   104)                            ! rate_const*M*CO*OH
      rxt_rates(:ncol,:,   533) = rxt_rates(:ncol,:,   533)*sol(:ncol,:,    95)*sol(:ncol,:,    20)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,   534) = rxt_rates(:ncol,:,   534)*sol(:ncol,:,    95)*sol(:ncol,:,    20)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,   535) = rxt_rates(:ncol,:,   535)*sol(:ncol,:,    95)*sol(:ncol,:,    20)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,   536) = rxt_rates(:ncol,:,   536)*sol(:ncol,:,    27)*sol(:ncol,:,   104)                            ! rate_const*CO*OH
      rxt_rates(:ncol,:,   537) = rxt_rates(:ncol,:,   537)*sol(:ncol,:,    43)                                                ! rate_const*HO2
      rxt_rates(:ncol,:,   538) = rxt_rates(:ncol,:,   538)*sol(:ncol,:,    50)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   539) = rxt_rates(:ncol,:,   539)*sol(:ncol,:,    52)                                                ! rate_const*NO2
      rxt_rates(:ncol,:,   540) = rxt_rates(:ncol,:,   540)*sol(:ncol,:,    53)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,   541) = rxt_rates(:ncol,:,   541)*sol(:ncol,:,    50)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   542) = rxt_rates(:ncol,:,   542)*sol(:ncol,:,    46)*sol(:ncol,:,    40)                            ! rate_const*HOCL*HCL
      rxt_rates(:ncol,:,   543) = rxt_rates(:ncol,:,   543)*sol(:ncol,:,     3)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   544) = rxt_rates(:ncol,:,   544)*sol(:ncol,:,    50)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   545) = rxt_rates(:ncol,:,   545)*sol(:ncol,:,    25)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   546) = rxt_rates(:ncol,:,   546)*sol(:ncol,:,     3)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   547) = rxt_rates(:ncol,:,   547)*sol(:ncol,:,    25)*sol(:ncol,:,    40)                            ! rate_const*CLONO2*HCL
      rxt_rates(:ncol,:,   548) = rxt_rates(:ncol,:,   548)*sol(:ncol,:,    46)*sol(:ncol,:,    40)                            ! rate_const*HOCL*HCL
      rxt_rates(:ncol,:,   549) = rxt_rates(:ncol,:,   549)*sol(:ncol,:,    45)*sol(:ncol,:,    40)                            ! rate_const*HOBR*HCL
      rxt_rates(:ncol,:,   550) = rxt_rates(:ncol,:,   550)*sol(:ncol,:,    25)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   551) = rxt_rates(:ncol,:,   551)*sol(:ncol,:,     3)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   552) = rxt_rates(:ncol,:,   552)*sol(:ncol,:,    25)*sol(:ncol,:,    40)                            ! rate_const*CLONO2*HCL
      rxt_rates(:ncol,:,   553) = rxt_rates(:ncol,:,   553)*sol(:ncol,:,    46)*sol(:ncol,:,    40)                            ! rate_const*HOCL*HCL
      rxt_rates(:ncol,:,   554) = rxt_rates(:ncol,:,   554)*sol(:ncol,:,    45)*sol(:ncol,:,    40)                            ! rate_const*HOBR*HCL
      rxt_rates(:ncol,:,   555) = rxt_rates(:ncol,:,   555)*sol(:ncol,:,    50)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   556) = rxt_rates(:ncol,:,   556)*sol(:ncol,:,    25)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   557) = rxt_rates(:ncol,:,   557)*sol(:ncol,:,    25)*sol(:ncol,:,    40)                            ! rate_const*CLONO2*HCL
      rxt_rates(:ncol,:,   558) = rxt_rates(:ncol,:,   558)*sol(:ncol,:,   109)                                                ! rate_const*Op2P
      rxt_rates(:ncol,:,   559) = rxt_rates(:ncol,:,   559)*sol(:ncol,:,   108)                                                ! rate_const*Op2D
      rxt_rates(:ncol,:,   560) = rxt_rates(:ncol,:,   560)*sol(:ncol,:,   109)                                                ! rate_const*Op2P
      rxt_rates(:ncol,:,   561) = rxt_rates(:ncol,:,   561)*sol(:ncol,:,    88)*sol(:ncol,:,    69)                            ! rate_const*NOp*e
      rxt_rates(:ncol,:,   562) = rxt_rates(:ncol,:,   562)*sol(:ncol,:,    99)*sol(:ncol,:,    69)                            ! rate_const*O2p*e
      rxt_rates(:ncol,:,   563) = rxt_rates(:ncol,:,   563)*sol(:ncol,:,    80)*sol(:ncol,:,    69)                            ! rate_const*N2p*e
      rxt_rates(:ncol,:,   564) = rxt_rates(:ncol,:,   564)*sol(:ncol,:,    80)*sol(:ncol,:,    55)                            ! rate_const*N2p*O2
      rxt_rates(:ncol,:,   565) = rxt_rates(:ncol,:,   565)*sol(:ncol,:,    80)*sol(:ncol,:,    54)                            ! rate_const*N2p*O
      rxt_rates(:ncol,:,   566) = rxt_rates(:ncol,:,   566)*sol(:ncol,:,    80)*sol(:ncol,:,    54)                            ! rate_const*N2p*O
      rxt_rates(:ncol,:,   567) = rxt_rates(:ncol,:,   567)*sol(:ncol,:,    94)*sol(:ncol,:,    54)                            ! rate_const*Np*O
      rxt_rates(:ncol,:,   568) = rxt_rates(:ncol,:,   568)*sol(:ncol,:,    94)*sol(:ncol,:,    55)                            ! rate_const*Np*O2
      rxt_rates(:ncol,:,   569) = rxt_rates(:ncol,:,   569)*sol(:ncol,:,    94)*sol(:ncol,:,    55)                            ! rate_const*Np*O2
      rxt_rates(:ncol,:,   570) = rxt_rates(:ncol,:,   570)*sol(:ncol,:,    99)*sol(:ncol,:,    48)                            ! rate_const*O2p*N
      rxt_rates(:ncol,:,   571) = rxt_rates(:ncol,:,   571)*sol(:ncol,:,    99)                                                ! rate_const*N2*O2p
      rxt_rates(:ncol,:,   572) = rxt_rates(:ncol,:,   572)*sol(:ncol,:,    99)*sol(:ncol,:,    51)                            ! rate_const*O2p*NO
      rxt_rates(:ncol,:,   573) = rxt_rates(:ncol,:,   573)*sol(:ncol,:,   107)*sol(:ncol,:,    28)                            ! rate_const*Op*CO2
      rxt_rates(:ncol,:,   574) = rxt_rates(:ncol,:,   574)*sol(:ncol,:,   107)                                                ! rate_const*N2*Op
      rxt_rates(:ncol,:,   575) = rxt_rates(:ncol,:,   575)*sol(:ncol,:,   107)*sol(:ncol,:,    79)                            ! rate_const*Op*N2D
      rxt_rates(:ncol,:,   576) = rxt_rates(:ncol,:,   576)*sol(:ncol,:,   107)*sol(:ncol,:,    55)                            ! rate_const*Op*O2
      rxt_rates(:ncol,:,   577) = rxt_rates(:ncol,:,   577)*sol(:ncol,:,   108)*sol(:ncol,:,    69)                            ! rate_const*Op2D*e
      rxt_rates(:ncol,:,   578) = rxt_rates(:ncol,:,   578)*sol(:ncol,:,   108)                                                ! rate_const*N2*Op2D
      rxt_rates(:ncol,:,   579) = rxt_rates(:ncol,:,   579)*sol(:ncol,:,   108)*sol(:ncol,:,    54)                            ! rate_const*Op2D*O
      rxt_rates(:ncol,:,   580) = rxt_rates(:ncol,:,   580)*sol(:ncol,:,   108)*sol(:ncol,:,    55)                            ! rate_const*Op2D*O2
      rxt_rates(:ncol,:,   581) = rxt_rates(:ncol,:,   581)*sol(:ncol,:,   109)*sol(:ncol,:,    69)                            ! rate_const*Op2P*e
      rxt_rates(:ncol,:,   582) = rxt_rates(:ncol,:,   582)*sol(:ncol,:,   109)*sol(:ncol,:,    69)                            ! rate_const*Op2P*e
      rxt_rates(:ncol,:,   583) = rxt_rates(:ncol,:,   583)*sol(:ncol,:,   109)                                                ! rate_const*N2*Op2P
      rxt_rates(:ncol,:,   584) = rxt_rates(:ncol,:,   584)*sol(:ncol,:,   109)                                                ! rate_const*N2*Op2P
      rxt_rates(:ncol,:,   585) = rxt_rates(:ncol,:,   585)*sol(:ncol,:,   109)*sol(:ncol,:,    54)                            ! rate_const*Op2P*O
  end subroutine set_rates
end module mo_rxt_rates_conv
