module mo_rxt_rates_conv
  use shr_kind_mod, only : r8 => shr_kind_r8
  implicit none
  private
  public :: set_rates
contains
   subroutine set_rates( rxt_rates, sol, ncol )
      real(r8), intent(inout) :: rxt_rates(:,:,:)
      real(r8), intent(in) :: sol(:,:,:)
      integer, intent(in) :: ncol
      rxt_rates(:ncol,:,     1) = rxt_rates(:ncol,:,     1)*sol(:ncol,:,   317)                                                ! rate_const*H2O
      rxt_rates(:ncol,:,     2) = rxt_rates(:ncol,:,     2)*sol(:ncol,:,   317)                                                ! rate_const*H2O
      rxt_rates(:ncol,:,     3) = rxt_rates(:ncol,:,     3)*sol(:ncol,:,   317)                                                ! rate_const*H2O
      rxt_rates(:ncol,:,     4) = rxt_rates(:ncol,:,     4)*sol(:ncol,:,    81)                                                ! rate_const*H2O2
                                                                                                                               ! rate_const*O2
                                                                                                                               ! rate_const*O2
      rxt_rates(:ncol,:,     7) = rxt_rates(:ncol,:,     7)*sol(:ncol,:,   157)                                                ! rate_const*O3
      rxt_rates(:ncol,:,     8) = rxt_rates(:ncol,:,     8)*sol(:ncol,:,   157)                                                ! rate_const*O3
      rxt_rates(:ncol,:,     9) = rxt_rates(:ncol,:,     9)*sol(:ncol,:,    93)                                                ! rate_const*HNO3
      rxt_rates(:ncol,:,    10) = rxt_rates(:ncol,:,    10)*sol(:ncol,:,    94)                                                ! rate_const*HO2NO2
      rxt_rates(:ncol,:,    11) = rxt_rates(:ncol,:,    11)*sol(:ncol,:,    94)                                                ! rate_const*HO2NO2
      rxt_rates(:ncol,:,    12) = rxt_rates(:ncol,:,    12)*sol(:ncol,:,   137)                                                ! rate_const*N2O
      rxt_rates(:ncol,:,    13) = rxt_rates(:ncol,:,    13)*sol(:ncol,:,   138)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,    14) = rxt_rates(:ncol,:,    14)*sol(:ncol,:,   138)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,    15) = rxt_rates(:ncol,:,    15)*sol(:ncol,:,   147)                                                ! rate_const*NO
      rxt_rates(:ncol,:,    16) = rxt_rates(:ncol,:,    16)*sol(:ncol,:,   148)                                                ! rate_const*NO2
      rxt_rates(:ncol,:,    17) = rxt_rates(:ncol,:,    17)*sol(:ncol,:,   149)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,    18) = rxt_rates(:ncol,:,    18)*sol(:ncol,:,   149)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,    19) = rxt_rates(:ncol,:,    19)*sol(:ncol,:,     1)                                                ! rate_const*ALKNIT
      rxt_rates(:ncol,:,    20) = rxt_rates(:ncol,:,    20)*sol(:ncol,:,     2)                                                ! rate_const*ALKOOH
      rxt_rates(:ncol,:,    21) = rxt_rates(:ncol,:,    21)*sol(:ncol,:,     9)                                                ! rate_const*BENZOOH
      rxt_rates(:ncol,:,    22) = rxt_rates(:ncol,:,    22)*sol(:ncol,:,    10)                                                ! rate_const*BEPOMUC
      rxt_rates(:ncol,:,    23) = rxt_rates(:ncol,:,    23)*sol(:ncol,:,    11)                                                ! rate_const*BIGALD1
      rxt_rates(:ncol,:,    24) = rxt_rates(:ncol,:,    24)*sol(:ncol,:,    12)                                                ! rate_const*BIGALD2
      rxt_rates(:ncol,:,    25) = rxt_rates(:ncol,:,    25)*sol(:ncol,:,    13)                                                ! rate_const*BIGALD3
      rxt_rates(:ncol,:,    26) = rxt_rates(:ncol,:,    26)*sol(:ncol,:,    14)                                                ! rate_const*BIGALD4
      rxt_rates(:ncol,:,    27) = rxt_rates(:ncol,:,    27)*sol(:ncol,:,    24)                                                ! rate_const*BZOOH
      rxt_rates(:ncol,:,    28) = rxt_rates(:ncol,:,    28)*sol(:ncol,:,    28)                                                ! rate_const*C2H5OOH
      rxt_rates(:ncol,:,    29) = rxt_rates(:ncol,:,    29)*sol(:ncol,:,    31)                                                ! rate_const*C3H7OOH
      rxt_rates(:ncol,:,    30) = rxt_rates(:ncol,:,    30)*sol(:ncol,:,    33)                                                ! rate_const*C6H5OOH
      rxt_rates(:ncol,:,    31) = rxt_rates(:ncol,:,    31)*sol(:ncol,:,    43)                                                ! rate_const*CH2O
      rxt_rates(:ncol,:,    32) = rxt_rates(:ncol,:,    32)*sol(:ncol,:,    43)                                                ! rate_const*CH2O
      rxt_rates(:ncol,:,    33) = rxt_rates(:ncol,:,    33)*sol(:ncol,:,    46)                                                ! rate_const*CH3CHO
      rxt_rates(:ncol,:,    34) = rxt_rates(:ncol,:,    34)*sol(:ncol,:,    49)                                                ! rate_const*CH3COCH3
      rxt_rates(:ncol,:,    35) = rxt_rates(:ncol,:,    35)*sol(:ncol,:,    50)                                                ! rate_const*CH3COCHO
      rxt_rates(:ncol,:,    36) = rxt_rates(:ncol,:,    36)*sol(:ncol,:,    52)                                                ! rate_const*CH3COOOH
      rxt_rates(:ncol,:,    37) = rxt_rates(:ncol,:,    37)*sol(:ncol,:,    54)                                                ! rate_const*CH3OOH
      rxt_rates(:ncol,:,    38) = rxt_rates(:ncol,:,    38)*sol(:ncol,:,    55)                                                ! rate_const*CH4
      rxt_rates(:ncol,:,    39) = rxt_rates(:ncol,:,    39)*sol(:ncol,:,    55)                                                ! rate_const*CH4
      rxt_rates(:ncol,:,    40) = rxt_rates(:ncol,:,    40)*sol(:ncol,:,    64)                                                ! rate_const*CO2
      rxt_rates(:ncol,:,    41) = rxt_rates(:ncol,:,    41)*sol(:ncol,:,    68)                                                ! rate_const*DHPMPAL
      rxt_rates(:ncol,:,    42) = rxt_rates(:ncol,:,    42)*sol(:ncol,:,    74)                                                ! rate_const*EOOH
      rxt_rates(:ncol,:,    43) = rxt_rates(:ncol,:,    43)*sol(:ncol,:,    76)                                                ! rate_const*GLYALD
      rxt_rates(:ncol,:,    44) = rxt_rates(:ncol,:,    44)*sol(:ncol,:,    77)                                                ! rate_const*GLYOXAL
      rxt_rates(:ncol,:,    45) = rxt_rates(:ncol,:,    45)*sol(:ncol,:,    89)                                                ! rate_const*HCOCH2OOH
      rxt_rates(:ncol,:,    46) = rxt_rates(:ncol,:,    46)*sol(:ncol,:,    92)                                                ! rate_const*HMHP
      rxt_rates(:ncol,:,    47) = rxt_rates(:ncol,:,    47)*sol(:ncol,:,    97)                                                ! rate_const*HONITR
      rxt_rates(:ncol,:,    48) = rxt_rates(:ncol,:,    48)*sol(:ncol,:,    98)                                                ! rate_const*HPALD1
      rxt_rates(:ncol,:,    49) = rxt_rates(:ncol,:,    49)*sol(:ncol,:,    99)                                                ! rate_const*HPALD4
      rxt_rates(:ncol,:,    50) = rxt_rates(:ncol,:,    50)*sol(:ncol,:,   100)                                                ! rate_const*HPALDB1C
      rxt_rates(:ncol,:,    51) = rxt_rates(:ncol,:,    51)*sol(:ncol,:,   101)                                                ! rate_const*HPALDB4C
      rxt_rates(:ncol,:,    52) = rxt_rates(:ncol,:,    52)*sol(:ncol,:,   102)                                                ! rate_const*HYAC
      rxt_rates(:ncol,:,    53) = rxt_rates(:ncol,:,    53)*sol(:ncol,:,   103)                                                ! rate_const*HYDRALD
      rxt_rates(:ncol,:,    54) = rxt_rates(:ncol,:,    54)*sol(:ncol,:,   103)                                                ! rate_const*HYDRALD
      rxt_rates(:ncol,:,    55) = rxt_rates(:ncol,:,    55)*sol(:ncol,:,   104)                                                ! rate_const*HYPERACET
      rxt_rates(:ncol,:,    56) = rxt_rates(:ncol,:,    56)*sol(:ncol,:,   104)                                                ! rate_const*HYPERACET
      rxt_rates(:ncol,:,    57) = rxt_rates(:ncol,:,    57)*sol(:ncol,:,   107)                                                ! rate_const*INHEB
      rxt_rates(:ncol,:,    58) = rxt_rates(:ncol,:,    58)*sol(:ncol,:,   108)                                                ! rate_const*INHED
      rxt_rates(:ncol,:,    59) = rxt_rates(:ncol,:,    59)*sol(:ncol,:,   110)                                                ! rate_const*ISOPFDN
      rxt_rates(:ncol,:,    60) = rxt_rates(:ncol,:,    60)*sol(:ncol,:,   111)                                                ! rate_const*ISOPFDNC
      rxt_rates(:ncol,:,    61) = rxt_rates(:ncol,:,    61)*sol(:ncol,:,   112)                                                ! rate_const*ISOPFNC
      rxt_rates(:ncol,:,    62) = rxt_rates(:ncol,:,    62)*sol(:ncol,:,   113)                                                ! rate_const*ISOPFNP
      rxt_rates(:ncol,:,    63) = rxt_rates(:ncol,:,    63)*sol(:ncol,:,   114)                                                ! rate_const*ISOPHFP
      rxt_rates(:ncol,:,    64) = rxt_rates(:ncol,:,    64)*sol(:ncol,:,   115)                                                ! rate_const*ISOPN1D
      rxt_rates(:ncol,:,    65) = rxt_rates(:ncol,:,    65)*sol(:ncol,:,   116)                                                ! rate_const*ISOPN2B
      rxt_rates(:ncol,:,    66) = rxt_rates(:ncol,:,    66)*sol(:ncol,:,   117)                                                ! rate_const*ISOPN3B
      rxt_rates(:ncol,:,    67) = rxt_rates(:ncol,:,    67)*sol(:ncol,:,   118)                                                ! rate_const*ISOPN4D
      rxt_rates(:ncol,:,    68) = rxt_rates(:ncol,:,    68)*sol(:ncol,:,   119)                                                ! rate_const*ISOPNBNO3
      rxt_rates(:ncol,:,    69) = rxt_rates(:ncol,:,    69)*sol(:ncol,:,   120)                                                ! rate_const*ISOPNOOHB
      rxt_rates(:ncol,:,    70) = rxt_rates(:ncol,:,    70)*sol(:ncol,:,   121)                                                ! rate_const*ISOPNOOHD
      rxt_rates(:ncol,:,    71) = rxt_rates(:ncol,:,    71)*sol(:ncol,:,   123)                                                ! rate_const*ISOPOOH
      rxt_rates(:ncol,:,    72) = rxt_rates(:ncol,:,    72)*sol(:ncol,:,   126)                                                ! rate_const*MACR
      rxt_rates(:ncol,:,    73) = rxt_rates(:ncol,:,    73)*sol(:ncol,:,   126)                                                ! rate_const*MACR
      rxt_rates(:ncol,:,    74) = rxt_rates(:ncol,:,    74)*sol(:ncol,:,   127)                                                ! rate_const*MACRN
      rxt_rates(:ncol,:,    75) = rxt_rates(:ncol,:,    75)*sol(:ncol,:,   128)                                                ! rate_const*MACROOH
      rxt_rates(:ncol,:,    76) = rxt_rates(:ncol,:,    76)*sol(:ncol,:,   129)                                                ! rate_const*MEK
      rxt_rates(:ncol,:,    77) = rxt_rates(:ncol,:,    77)*sol(:ncol,:,   130)                                                ! rate_const*MEKOOH
      rxt_rates(:ncol,:,    78) = rxt_rates(:ncol,:,    78)*sol(:ncol,:,   131)                                                ! rate_const*MPAN
      rxt_rates(:ncol,:,    79) = rxt_rates(:ncol,:,    79)*sol(:ncol,:,   132)                                                ! rate_const*MVK
      rxt_rates(:ncol,:,    80) = rxt_rates(:ncol,:,    80)*sol(:ncol,:,   133)                                                ! rate_const*MVKN
      rxt_rates(:ncol,:,    81) = rxt_rates(:ncol,:,    81)*sol(:ncol,:,   134)                                                ! rate_const*MVKOOH
      rxt_rates(:ncol,:,    82) = rxt_rates(:ncol,:,    82)*sol(:ncol,:,   139)                                                ! rate_const*NC4CHO
      rxt_rates(:ncol,:,    83) = rxt_rates(:ncol,:,    83)*sol(:ncol,:,   150)                                                ! rate_const*NO3CH2CHO
      rxt_rates(:ncol,:,    84) = rxt_rates(:ncol,:,    84)*sol(:ncol,:,   151)                                                ! rate_const*NOA
      rxt_rates(:ncol,:,    85) = rxt_rates(:ncol,:,    85)*sol(:ncol,:,   161)                                                ! rate_const*ONITR
      rxt_rates(:ncol,:,    86) = rxt_rates(:ncol,:,    86)*sol(:ncol,:,   162)                                                ! rate_const*PAN
      rxt_rates(:ncol,:,    87) = rxt_rates(:ncol,:,    87)*sol(:ncol,:,   166)                                                ! rate_const*PHENOOH
      rxt_rates(:ncol,:,    88) = rxt_rates(:ncol,:,    88)*sol(:ncol,:,   169)                                                ! rate_const*POOH
      rxt_rates(:ncol,:,    89) = rxt_rates(:ncol,:,    89)*sol(:ncol,:,   170)                                                ! rate_const*ROOH
      rxt_rates(:ncol,:,    90) = rxt_rates(:ncol,:,    90)*sol(:ncol,:,   197)                                                ! rate_const*TEPOMUC
      rxt_rates(:ncol,:,    91) = rxt_rates(:ncol,:,    91)*sol(:ncol,:,   198)                                                ! rate_const*TERP1OOH
      rxt_rates(:ncol,:,    92) = rxt_rates(:ncol,:,    92)*sol(:ncol,:,   199)                                                ! rate_const*TERP2AOOH
      rxt_rates(:ncol,:,    93) = rxt_rates(:ncol,:,    93)*sol(:ncol,:,   200)                                                ! rate_const*TERPA
      rxt_rates(:ncol,:,    94) = rxt_rates(:ncol,:,    94)*sol(:ncol,:,   201)                                                ! rate_const*TERPA2
      rxt_rates(:ncol,:,    95) = rxt_rates(:ncol,:,    95)*sol(:ncol,:,   202)                                                ! rate_const*TERPA2PAN
      rxt_rates(:ncol,:,    96) = rxt_rates(:ncol,:,    96)*sol(:ncol,:,   203)                                                ! rate_const*TERPA3
      rxt_rates(:ncol,:,    97) = rxt_rates(:ncol,:,    97)*sol(:ncol,:,   204)                                                ! rate_const*TERPA3PAN
      rxt_rates(:ncol,:,    98) = rxt_rates(:ncol,:,    98)*sol(:ncol,:,   205)                                                ! rate_const*TERPACID
      rxt_rates(:ncol,:,    99) = rxt_rates(:ncol,:,    99)*sol(:ncol,:,   206)                                                ! rate_const*TERPACID2
      rxt_rates(:ncol,:,   100) = rxt_rates(:ncol,:,   100)*sol(:ncol,:,   207)                                                ! rate_const*TERPACID3
      rxt_rates(:ncol,:,   101) = rxt_rates(:ncol,:,   101)*sol(:ncol,:,   208)                                                ! rate_const*TERPAPAN
      rxt_rates(:ncol,:,   102) = rxt_rates(:ncol,:,   102)*sol(:ncol,:,   209)                                                ! rate_const*TERPDHDP
      rxt_rates(:ncol,:,   103) = rxt_rates(:ncol,:,   103)*sol(:ncol,:,   212)                                                ! rate_const*TERPFDN
      rxt_rates(:ncol,:,   104) = rxt_rates(:ncol,:,   104)*sol(:ncol,:,   213)                                                ! rate_const*TERPHFN
      rxt_rates(:ncol,:,   105) = rxt_rates(:ncol,:,   105)*sol(:ncol,:,   215)                                                ! rate_const*TERPNPS
      rxt_rates(:ncol,:,   106) = rxt_rates(:ncol,:,   106)*sol(:ncol,:,   216)                                                ! rate_const*TERPNPS1
      rxt_rates(:ncol,:,   107) = rxt_rates(:ncol,:,   107)*sol(:ncol,:,   217)                                                ! rate_const*TERPNPT
      rxt_rates(:ncol,:,   108) = rxt_rates(:ncol,:,   108)*sol(:ncol,:,   218)                                                ! rate_const*TERPNPT1
      rxt_rates(:ncol,:,   109) = rxt_rates(:ncol,:,   109)*sol(:ncol,:,   219)                                                ! rate_const*TERPNS
      rxt_rates(:ncol,:,   110) = rxt_rates(:ncol,:,   110)*sol(:ncol,:,   220)                                                ! rate_const*TERPNS1
      rxt_rates(:ncol,:,   111) = rxt_rates(:ncol,:,   111)*sol(:ncol,:,   221)                                                ! rate_const*TERPNT
      rxt_rates(:ncol,:,   112) = rxt_rates(:ncol,:,   112)*sol(:ncol,:,   222)                                                ! rate_const*TERPNT1
      rxt_rates(:ncol,:,   113) = rxt_rates(:ncol,:,   113)*sol(:ncol,:,   223)                                                ! rate_const*TERPOOH
      rxt_rates(:ncol,:,   114) = rxt_rates(:ncol,:,   114)*sol(:ncol,:,   224)                                                ! rate_const*TERPOOHL
      rxt_rates(:ncol,:,   115) = rxt_rates(:ncol,:,   115)*sol(:ncol,:,   225)                                                ! rate_const*TOLOOH
      rxt_rates(:ncol,:,   116) = rxt_rates(:ncol,:,   116)*sol(:ncol,:,   228)                                                ! rate_const*XYLENOOH
      rxt_rates(:ncol,:,   117) = rxt_rates(:ncol,:,   117)*sol(:ncol,:,   230)                                                ! rate_const*XYLOLOOH
      rxt_rates(:ncol,:,   118) = rxt_rates(:ncol,:,   118)*sol(:ncol,:,    19)                                                ! rate_const*BRCL
      rxt_rates(:ncol,:,   119) = rxt_rates(:ncol,:,   119)*sol(:ncol,:,    20)                                                ! rate_const*BRO
      rxt_rates(:ncol,:,   120) = rxt_rates(:ncol,:,   120)*sol(:ncol,:,    21)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   121) = rxt_rates(:ncol,:,   121)*sol(:ncol,:,    21)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   122) = rxt_rates(:ncol,:,   122)*sol(:ncol,:,    34)                                                ! rate_const*CCL4
      rxt_rates(:ncol,:,   123) = rxt_rates(:ncol,:,   123)*sol(:ncol,:,    35)                                                ! rate_const*CF2CLBR
      rxt_rates(:ncol,:,   124) = rxt_rates(:ncol,:,   124)*sol(:ncol,:,    36)                                                ! rate_const*CF3BR
      rxt_rates(:ncol,:,   125) = rxt_rates(:ncol,:,   125)*sol(:ncol,:,    37)                                                ! rate_const*CFC11
      rxt_rates(:ncol,:,   126) = rxt_rates(:ncol,:,   126)*sol(:ncol,:,    38)                                                ! rate_const*CFC113
      rxt_rates(:ncol,:,   127) = rxt_rates(:ncol,:,   127)*sol(:ncol,:,    39)                                                ! rate_const*CFC114
      rxt_rates(:ncol,:,   128) = rxt_rates(:ncol,:,   128)*sol(:ncol,:,    40)                                                ! rate_const*CFC115
      rxt_rates(:ncol,:,   129) = rxt_rates(:ncol,:,   129)*sol(:ncol,:,    41)                                                ! rate_const*CFC12
      rxt_rates(:ncol,:,   130) = rxt_rates(:ncol,:,   130)*sol(:ncol,:,    42)                                                ! rate_const*CH2BR2
      rxt_rates(:ncol,:,   131) = rxt_rates(:ncol,:,   131)*sol(:ncol,:,    44)                                                ! rate_const*CH3BR
      rxt_rates(:ncol,:,   132) = rxt_rates(:ncol,:,   132)*sol(:ncol,:,    45)                                                ! rate_const*CH3CCL3
      rxt_rates(:ncol,:,   133) = rxt_rates(:ncol,:,   133)*sol(:ncol,:,    47)                                                ! rate_const*CH3CL
      rxt_rates(:ncol,:,   134) = rxt_rates(:ncol,:,   134)*sol(:ncol,:,    56)                                                ! rate_const*CHBR3
      rxt_rates(:ncol,:,   135) = rxt_rates(:ncol,:,   135)*sol(:ncol,:,    58)                                                ! rate_const*CL2
      rxt_rates(:ncol,:,   136) = rxt_rates(:ncol,:,   136)*sol(:ncol,:,    59)                                                ! rate_const*CL2O2
      rxt_rates(:ncol,:,   137) = rxt_rates(:ncol,:,   137)*sol(:ncol,:,    60)                                                ! rate_const*CLO
      rxt_rates(:ncol,:,   138) = rxt_rates(:ncol,:,   138)*sol(:ncol,:,    61)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   139) = rxt_rates(:ncol,:,   139)*sol(:ncol,:,    61)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   140) = rxt_rates(:ncol,:,   140)*sol(:ncol,:,    65)                                                ! rate_const*COF2
      rxt_rates(:ncol,:,   141) = rxt_rates(:ncol,:,   141)*sol(:ncol,:,    66)                                                ! rate_const*COFCL
      rxt_rates(:ncol,:,   142) = rxt_rates(:ncol,:,   142)*sol(:ncol,:,    80)                                                ! rate_const*H2402
      rxt_rates(:ncol,:,   143) = rxt_rates(:ncol,:,   143)*sol(:ncol,:,    83)                                                ! rate_const*HBR
      rxt_rates(:ncol,:,   144) = rxt_rates(:ncol,:,   144)*sol(:ncol,:,    84)                                                ! rate_const*HCFC141B
      rxt_rates(:ncol,:,   145) = rxt_rates(:ncol,:,   145)*sol(:ncol,:,    85)                                                ! rate_const*HCFC142B
      rxt_rates(:ncol,:,   146) = rxt_rates(:ncol,:,   146)*sol(:ncol,:,    86)                                                ! rate_const*HCFC22
      rxt_rates(:ncol,:,   147) = rxt_rates(:ncol,:,   147)*sol(:ncol,:,    87)                                                ! rate_const*HCL
      rxt_rates(:ncol,:,   148) = rxt_rates(:ncol,:,   148)*sol(:ncol,:,    91)                                                ! rate_const*HF
      rxt_rates(:ncol,:,   149) = rxt_rates(:ncol,:,   149)*sol(:ncol,:,    95)                                                ! rate_const*HOBR
      rxt_rates(:ncol,:,   150) = rxt_rates(:ncol,:,   150)*sol(:ncol,:,    96)                                                ! rate_const*HOCL
      rxt_rates(:ncol,:,   151) = rxt_rates(:ncol,:,   151)*sol(:ncol,:,   159)                                                ! rate_const*OCLO
      rxt_rates(:ncol,:,   152) = rxt_rates(:ncol,:,   152)*sol(:ncol,:,   172)                                                ! rate_const*SF6
      rxt_rates(:ncol,:,   153) = rxt_rates(:ncol,:,   153)*sol(:ncol,:,    82)                                                ! rate_const*H2SO4
      rxt_rates(:ncol,:,   154) = rxt_rates(:ncol,:,   154)*sol(:ncol,:,   160)                                                ! rate_const*OCS
      rxt_rates(:ncol,:,   155) = rxt_rates(:ncol,:,   155)*sol(:ncol,:,   173)                                                ! rate_const*SO
      rxt_rates(:ncol,:,   156) = rxt_rates(:ncol,:,   156)*sol(:ncol,:,   174)                                                ! rate_const*SO2
      rxt_rates(:ncol,:,   157) = rxt_rates(:ncol,:,   157)*sol(:ncol,:,   175)                                                ! rate_const*SO3
      rxt_rates(:ncol,:,   158) = rxt_rates(:ncol,:,   158)*sol(:ncol,:,   179)                                                ! rate_const*soa1_a1
      rxt_rates(:ncol,:,   159) = rxt_rates(:ncol,:,   159)*sol(:ncol,:,   180)                                                ! rate_const*soa1_a2
      rxt_rates(:ncol,:,   160) = rxt_rates(:ncol,:,   160)*sol(:ncol,:,   181)                                                ! rate_const*soa2_a1
      rxt_rates(:ncol,:,   161) = rxt_rates(:ncol,:,   161)*sol(:ncol,:,   182)                                                ! rate_const*soa2_a2
      rxt_rates(:ncol,:,   162) = rxt_rates(:ncol,:,   162)*sol(:ncol,:,   183)                                                ! rate_const*soa3_a1
      rxt_rates(:ncol,:,   163) = rxt_rates(:ncol,:,   163)*sol(:ncol,:,   184)                                                ! rate_const*soa3_a2
      rxt_rates(:ncol,:,   164) = rxt_rates(:ncol,:,   164)*sol(:ncol,:,   185)                                                ! rate_const*soa4_a1
      rxt_rates(:ncol,:,   165) = rxt_rates(:ncol,:,   165)*sol(:ncol,:,   186)                                                ! rate_const*soa4_a2
      rxt_rates(:ncol,:,   166) = rxt_rates(:ncol,:,   166)*sol(:ncol,:,   187)                                                ! rate_const*soa5_a1
      rxt_rates(:ncol,:,   167) = rxt_rates(:ncol,:,   167)*sol(:ncol,:,   188)                                                ! rate_const*soa5_a2
      rxt_rates(:ncol,:,   168) = rxt_rates(:ncol,:,   168)*sol(:ncol,:,   292)*sol(:ncol,:,    79)                            ! rate_const*O1D*H2
      rxt_rates(:ncol,:,   169) = rxt_rates(:ncol,:,   169)*sol(:ncol,:,   292)*sol(:ncol,:,   317)                            ! rate_const*O1D*H2O
      rxt_rates(:ncol,:,   170) = rxt_rates(:ncol,:,   170)*sol(:ncol,:,   292)                                                ! rate_const*N2*O1D
      rxt_rates(:ncol,:,   171) = rxt_rates(:ncol,:,   171)*sol(:ncol,:,   292)                                                ! rate_const*O2*O1D
      rxt_rates(:ncol,:,   172) = rxt_rates(:ncol,:,   172)*sol(:ncol,:,   292)*sol(:ncol,:,   157)                            ! rate_const*O1D*O3
      rxt_rates(:ncol,:,   173) = rxt_rates(:ncol,:,   173)*sol(:ncol,:,   156)*sol(:ncol,:,   157)                            ! rate_const*O*O3
      rxt_rates(:ncol,:,   174) = rxt_rates(:ncol,:,   174)*sol(:ncol,:,   156)*sol(:ncol,:,   156)                            ! rate_const*M*O*O
      rxt_rates(:ncol,:,   175) = rxt_rates(:ncol,:,   175)*sol(:ncol,:,   156)                                                ! rate_const*O2*M*O
      rxt_rates(:ncol,:,   176) = rxt_rates(:ncol,:,   176)*sol(:ncol,:,    79)*sol(:ncol,:,   156)                            ! rate_const*H2*O
      rxt_rates(:ncol,:,   177) = rxt_rates(:ncol,:,   177)*sol(:ncol,:,    81)*sol(:ncol,:,   156)                            ! rate_const*H2O2*O
      rxt_rates(:ncol,:,   178) = rxt_rates(:ncol,:,   178)*sol(:ncol,:,    78)*sol(:ncol,:,   256)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,   179) = rxt_rates(:ncol,:,   179)*sol(:ncol,:,    78)*sol(:ncol,:,   256)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,   180) = rxt_rates(:ncol,:,   180)*sol(:ncol,:,    78)*sol(:ncol,:,   256)                            ! rate_const*H*HO2
      rxt_rates(:ncol,:,   181) = rxt_rates(:ncol,:,   181)*sol(:ncol,:,    78)                                                ! rate_const*O2*M*H
      rxt_rates(:ncol,:,   182) = rxt_rates(:ncol,:,   182)*sol(:ncol,:,   256)*sol(:ncol,:,   156)                            ! rate_const*HO2*O
      rxt_rates(:ncol,:,   183) = rxt_rates(:ncol,:,   183)*sol(:ncol,:,   256)*sol(:ncol,:,   157)                            ! rate_const*HO2*O3
      rxt_rates(:ncol,:,   184) = rxt_rates(:ncol,:,   184)*sol(:ncol,:,    78)*sol(:ncol,:,   157)                            ! rate_const*H*O3
      rxt_rates(:ncol,:,   185) = rxt_rates(:ncol,:,   185)*sol(:ncol,:,   293)*sol(:ncol,:,    79)                            ! rate_const*OH*H2
      rxt_rates(:ncol,:,   186) = rxt_rates(:ncol,:,   186)*sol(:ncol,:,   293)*sol(:ncol,:,    81)                            ! rate_const*OH*H2O2
      rxt_rates(:ncol,:,   187) = rxt_rates(:ncol,:,   187)*sol(:ncol,:,   293)*sol(:ncol,:,   256)                            ! rate_const*OH*HO2
      rxt_rates(:ncol,:,   188) = rxt_rates(:ncol,:,   188)*sol(:ncol,:,   293)*sol(:ncol,:,   156)                            ! rate_const*OH*O
      rxt_rates(:ncol,:,   189) = rxt_rates(:ncol,:,   189)*sol(:ncol,:,   293)*sol(:ncol,:,   157)                            ! rate_const*OH*O3
      rxt_rates(:ncol,:,   190) = rxt_rates(:ncol,:,   190)*sol(:ncol,:,   293)*sol(:ncol,:,   293)                            ! rate_const*OH*OH
      rxt_rates(:ncol,:,   191) = rxt_rates(:ncol,:,   191)*sol(:ncol,:,   293)*sol(:ncol,:,   293)                            ! rate_const*M*OH*OH
      rxt_rates(:ncol,:,   192) = rxt_rates(:ncol,:,   192)*sol(:ncol,:,   256)*sol(:ncol,:,   256)                            ! rate_const*HO2*HO2
      rxt_rates(:ncol,:,   193) = rxt_rates(:ncol,:,   193)*sol(:ncol,:,    94)*sol(:ncol,:,   293)                            ! rate_const*HO2NO2*OH
      rxt_rates(:ncol,:,   194) = rxt_rates(:ncol,:,   194)*sol(:ncol,:,   136)*sol(:ncol,:,   147)                            ! rate_const*N*NO
      rxt_rates(:ncol,:,   195) = rxt_rates(:ncol,:,   195)*sol(:ncol,:,   136)*sol(:ncol,:,   148)                            ! rate_const*N*NO2
      rxt_rates(:ncol,:,   196) = rxt_rates(:ncol,:,   196)*sol(:ncol,:,   136)*sol(:ncol,:,   148)                            ! rate_const*N*NO2
      rxt_rates(:ncol,:,   197) = rxt_rates(:ncol,:,   197)*sol(:ncol,:,   136)*sol(:ncol,:,   148)                            ! rate_const*N*NO2
      rxt_rates(:ncol,:,   198) = rxt_rates(:ncol,:,   198)*sol(:ncol,:,   136)                                                ! rate_const*O2*N
      rxt_rates(:ncol,:,   199) = rxt_rates(:ncol,:,   199)*sol(:ncol,:,   148)*sol(:ncol,:,   156)                            ! rate_const*NO2*O
      rxt_rates(:ncol,:,   200) = rxt_rates(:ncol,:,   200)*sol(:ncol,:,   148)*sol(:ncol,:,   157)                            ! rate_const*NO2*O3
      rxt_rates(:ncol,:,   201) = rxt_rates(:ncol,:,   201)*sol(:ncol,:,   148)*sol(:ncol,:,   156)                            ! rate_const*M*NO2*O
      rxt_rates(:ncol,:,   202) = rxt_rates(:ncol,:,   202)*sol(:ncol,:,   149)*sol(:ncol,:,   256)                            ! rate_const*NO3*HO2
      rxt_rates(:ncol,:,   203) = rxt_rates(:ncol,:,   203)*sol(:ncol,:,   149)*sol(:ncol,:,   147)                            ! rate_const*NO3*NO
      rxt_rates(:ncol,:,   204) = rxt_rates(:ncol,:,   204)*sol(:ncol,:,   149)*sol(:ncol,:,   156)                            ! rate_const*NO3*O
      rxt_rates(:ncol,:,   205) = rxt_rates(:ncol,:,   205)*sol(:ncol,:,   149)*sol(:ncol,:,   293)                            ! rate_const*NO3*OH
      rxt_rates(:ncol,:,   206) = rxt_rates(:ncol,:,   206)*sol(:ncol,:,   136)*sol(:ncol,:,   293)                            ! rate_const*N*OH
      rxt_rates(:ncol,:,   207) = rxt_rates(:ncol,:,   207)*sol(:ncol,:,   147)*sol(:ncol,:,   256)                            ! rate_const*NO*HO2
      rxt_rates(:ncol,:,   208) = rxt_rates(:ncol,:,   208)*sol(:ncol,:,   147)*sol(:ncol,:,   157)                            ! rate_const*NO*O3
      rxt_rates(:ncol,:,   209) = rxt_rates(:ncol,:,   209)*sol(:ncol,:,   147)*sol(:ncol,:,   156)                            ! rate_const*M*NO*O
      rxt_rates(:ncol,:,   210) = rxt_rates(:ncol,:,   210)*sol(:ncol,:,   292)*sol(:ncol,:,   137)                            ! rate_const*O1D*N2O
      rxt_rates(:ncol,:,   211) = rxt_rates(:ncol,:,   211)*sol(:ncol,:,   292)*sol(:ncol,:,   137)                            ! rate_const*O1D*N2O
      rxt_rates(:ncol,:,   212) = rxt_rates(:ncol,:,   212)*sol(:ncol,:,   148)*sol(:ncol,:,   256)                            ! rate_const*M*NO2*HO2
      rxt_rates(:ncol,:,   213) = rxt_rates(:ncol,:,   213)*sol(:ncol,:,   148)*sol(:ncol,:,   149)                            ! rate_const*M*NO2*NO3
      rxt_rates(:ncol,:,   214) = rxt_rates(:ncol,:,   214)*sol(:ncol,:,   148)*sol(:ncol,:,   293)                            ! rate_const*M*NO2*OH
      rxt_rates(:ncol,:,   215) = rxt_rates(:ncol,:,   215)*sol(:ncol,:,    93)*sol(:ncol,:,   293)                            ! rate_const*HNO3*OH
      rxt_rates(:ncol,:,   216) = rxt_rates(:ncol,:,   216)*sol(:ncol,:,    94)                                                ! rate_const*M*HO2NO2
      rxt_rates(:ncol,:,   217) = rxt_rates(:ncol,:,   217)*sol(:ncol,:,   138)                                                ! rate_const*M*N2O5
      rxt_rates(:ncol,:,   218) = rxt_rates(:ncol,:,   218)*sol(:ncol,:,    57)*sol(:ncol,:,    43)                            ! rate_const*CL*CH2O
      rxt_rates(:ncol,:,   219) = rxt_rates(:ncol,:,   219)*sol(:ncol,:,    57)*sol(:ncol,:,    55)                            ! rate_const*CL*CH4
      rxt_rates(:ncol,:,   220) = rxt_rates(:ncol,:,   220)*sol(:ncol,:,    57)*sol(:ncol,:,    79)                            ! rate_const*CL*H2
      rxt_rates(:ncol,:,   221) = rxt_rates(:ncol,:,   221)*sol(:ncol,:,    57)*sol(:ncol,:,    81)                            ! rate_const*CL*H2O2
      rxt_rates(:ncol,:,   222) = rxt_rates(:ncol,:,   222)*sol(:ncol,:,    57)*sol(:ncol,:,   256)                            ! rate_const*CL*HO2
      rxt_rates(:ncol,:,   223) = rxt_rates(:ncol,:,   223)*sol(:ncol,:,    57)*sol(:ncol,:,   256)                            ! rate_const*CL*HO2
      rxt_rates(:ncol,:,   224) = rxt_rates(:ncol,:,   224)*sol(:ncol,:,    57)*sol(:ncol,:,   157)                            ! rate_const*CL*O3
      rxt_rates(:ncol,:,   225) = rxt_rates(:ncol,:,   225)*sol(:ncol,:,    60)*sol(:ncol,:,   251)                            ! rate_const*CLO*CH3O2
      rxt_rates(:ncol,:,   226) = rxt_rates(:ncol,:,   226)*sol(:ncol,:,    60)*sol(:ncol,:,    60)                            ! rate_const*CLO*CLO
      rxt_rates(:ncol,:,   227) = rxt_rates(:ncol,:,   227)*sol(:ncol,:,    60)*sol(:ncol,:,    60)                            ! rate_const*CLO*CLO
      rxt_rates(:ncol,:,   228) = rxt_rates(:ncol,:,   228)*sol(:ncol,:,    60)*sol(:ncol,:,    60)                            ! rate_const*CLO*CLO
      rxt_rates(:ncol,:,   229) = rxt_rates(:ncol,:,   229)*sol(:ncol,:,    60)*sol(:ncol,:,   256)                            ! rate_const*CLO*HO2
      rxt_rates(:ncol,:,   230) = rxt_rates(:ncol,:,   230)*sol(:ncol,:,    60)*sol(:ncol,:,   147)                            ! rate_const*CLO*NO
      rxt_rates(:ncol,:,   231) = rxt_rates(:ncol,:,   231)*sol(:ncol,:,    61)*sol(:ncol,:,    57)                            ! rate_const*CLONO2*CL
      rxt_rates(:ncol,:,   232) = rxt_rates(:ncol,:,   232)*sol(:ncol,:,    60)*sol(:ncol,:,   148)                            ! rate_const*M*CLO*NO2
      rxt_rates(:ncol,:,   233) = rxt_rates(:ncol,:,   233)*sol(:ncol,:,    61)*sol(:ncol,:,   156)                            ! rate_const*CLONO2*O
      rxt_rates(:ncol,:,   234) = rxt_rates(:ncol,:,   234)*sol(:ncol,:,    61)*sol(:ncol,:,   293)                            ! rate_const*CLONO2*OH
      rxt_rates(:ncol,:,   235) = rxt_rates(:ncol,:,   235)*sol(:ncol,:,    60)*sol(:ncol,:,   156)                            ! rate_const*CLO*O
      rxt_rates(:ncol,:,   236) = rxt_rates(:ncol,:,   236)*sol(:ncol,:,    60)*sol(:ncol,:,   293)                            ! rate_const*CLO*OH
      rxt_rates(:ncol,:,   237) = rxt_rates(:ncol,:,   237)*sol(:ncol,:,    60)*sol(:ncol,:,   293)                            ! rate_const*CLO*OH
      rxt_rates(:ncol,:,   238) = rxt_rates(:ncol,:,   238)*sol(:ncol,:,    87)*sol(:ncol,:,   156)                            ! rate_const*HCL*O
      rxt_rates(:ncol,:,   239) = rxt_rates(:ncol,:,   239)*sol(:ncol,:,    87)*sol(:ncol,:,   293)                            ! rate_const*HCL*OH
      rxt_rates(:ncol,:,   240) = rxt_rates(:ncol,:,   240)*sol(:ncol,:,    96)*sol(:ncol,:,    57)                            ! rate_const*HOCL*CL
      rxt_rates(:ncol,:,   241) = rxt_rates(:ncol,:,   241)*sol(:ncol,:,    96)*sol(:ncol,:,   156)                            ! rate_const*HOCL*O
      rxt_rates(:ncol,:,   242) = rxt_rates(:ncol,:,   242)*sol(:ncol,:,    96)*sol(:ncol,:,   293)                            ! rate_const*HOCL*OH
      rxt_rates(:ncol,:,   243) = rxt_rates(:ncol,:,   243)*sol(:ncol,:,   292)*sol(:ncol,:,    34)                            ! rate_const*O1D*CCL4
      rxt_rates(:ncol,:,   244) = rxt_rates(:ncol,:,   244)*sol(:ncol,:,   292)*sol(:ncol,:,    35)                            ! rate_const*O1D*CF2CLBR
      rxt_rates(:ncol,:,   245) = rxt_rates(:ncol,:,   245)*sol(:ncol,:,   292)*sol(:ncol,:,    37)                            ! rate_const*O1D*CFC11
      rxt_rates(:ncol,:,   246) = rxt_rates(:ncol,:,   246)*sol(:ncol,:,   292)*sol(:ncol,:,    38)                            ! rate_const*O1D*CFC113
      rxt_rates(:ncol,:,   247) = rxt_rates(:ncol,:,   247)*sol(:ncol,:,   292)*sol(:ncol,:,    39)                            ! rate_const*O1D*CFC114
      rxt_rates(:ncol,:,   248) = rxt_rates(:ncol,:,   248)*sol(:ncol,:,   292)*sol(:ncol,:,    40)                            ! rate_const*O1D*CFC115
      rxt_rates(:ncol,:,   249) = rxt_rates(:ncol,:,   249)*sol(:ncol,:,   292)*sol(:ncol,:,    41)                            ! rate_const*O1D*CFC12
      rxt_rates(:ncol,:,   250) = rxt_rates(:ncol,:,   250)*sol(:ncol,:,   292)*sol(:ncol,:,    87)                            ! rate_const*O1D*HCL
      rxt_rates(:ncol,:,   251) = rxt_rates(:ncol,:,   251)*sol(:ncol,:,   292)*sol(:ncol,:,    87)                            ! rate_const*O1D*HCL
      rxt_rates(:ncol,:,   252) = rxt_rates(:ncol,:,   252)*sol(:ncol,:,    60)*sol(:ncol,:,    60)                            ! rate_const*M*CLO*CLO
      rxt_rates(:ncol,:,   253) = rxt_rates(:ncol,:,   253)*sol(:ncol,:,    59)                                                ! rate_const*M*CL2O2
      rxt_rates(:ncol,:,   254) = rxt_rates(:ncol,:,   254)*sol(:ncol,:,    18)*sol(:ncol,:,    43)                            ! rate_const*BR*CH2O
      rxt_rates(:ncol,:,   255) = rxt_rates(:ncol,:,   255)*sol(:ncol,:,    18)*sol(:ncol,:,   256)                            ! rate_const*BR*HO2
      rxt_rates(:ncol,:,   256) = rxt_rates(:ncol,:,   256)*sol(:ncol,:,    18)*sol(:ncol,:,   157)                            ! rate_const*BR*O3
      rxt_rates(:ncol,:,   257) = rxt_rates(:ncol,:,   257)*sol(:ncol,:,    20)*sol(:ncol,:,    20)                            ! rate_const*BRO*BRO
      rxt_rates(:ncol,:,   258) = rxt_rates(:ncol,:,   258)*sol(:ncol,:,    20)*sol(:ncol,:,    60)                            ! rate_const*BRO*CLO
      rxt_rates(:ncol,:,   259) = rxt_rates(:ncol,:,   259)*sol(:ncol,:,    20)*sol(:ncol,:,    60)                            ! rate_const*BRO*CLO
      rxt_rates(:ncol,:,   260) = rxt_rates(:ncol,:,   260)*sol(:ncol,:,    20)*sol(:ncol,:,    60)                            ! rate_const*BRO*CLO
      rxt_rates(:ncol,:,   261) = rxt_rates(:ncol,:,   261)*sol(:ncol,:,    20)*sol(:ncol,:,   256)                            ! rate_const*BRO*HO2
      rxt_rates(:ncol,:,   262) = rxt_rates(:ncol,:,   262)*sol(:ncol,:,    20)*sol(:ncol,:,   147)                            ! rate_const*BRO*NO
      rxt_rates(:ncol,:,   263) = rxt_rates(:ncol,:,   263)*sol(:ncol,:,    20)*sol(:ncol,:,   148)                            ! rate_const*M*BRO*NO2
      rxt_rates(:ncol,:,   264) = rxt_rates(:ncol,:,   264)*sol(:ncol,:,    21)*sol(:ncol,:,   156)                            ! rate_const*BRONO2*O
      rxt_rates(:ncol,:,   265) = rxt_rates(:ncol,:,   265)*sol(:ncol,:,    20)*sol(:ncol,:,   156)                            ! rate_const*BRO*O
      rxt_rates(:ncol,:,   266) = rxt_rates(:ncol,:,   266)*sol(:ncol,:,    20)*sol(:ncol,:,   293)                            ! rate_const*BRO*OH
      rxt_rates(:ncol,:,   267) = rxt_rates(:ncol,:,   267)*sol(:ncol,:,    83)*sol(:ncol,:,   156)                            ! rate_const*HBR*O
      rxt_rates(:ncol,:,   268) = rxt_rates(:ncol,:,   268)*sol(:ncol,:,    83)*sol(:ncol,:,   293)                            ! rate_const*HBR*OH
      rxt_rates(:ncol,:,   269) = rxt_rates(:ncol,:,   269)*sol(:ncol,:,    95)*sol(:ncol,:,   156)                            ! rate_const*HOBR*O
      rxt_rates(:ncol,:,   270) = rxt_rates(:ncol,:,   270)*sol(:ncol,:,   292)*sol(:ncol,:,    36)                            ! rate_const*O1D*CF3BR
      rxt_rates(:ncol,:,   271) = rxt_rates(:ncol,:,   271)*sol(:ncol,:,   292)*sol(:ncol,:,    56)                            ! rate_const*O1D*CHBR3
      rxt_rates(:ncol,:,   272) = rxt_rates(:ncol,:,   272)*sol(:ncol,:,   292)*sol(:ncol,:,    80)                            ! rate_const*O1D*H2402
      rxt_rates(:ncol,:,   273) = rxt_rates(:ncol,:,   273)*sol(:ncol,:,   292)*sol(:ncol,:,    83)                            ! rate_const*O1D*HBR
      rxt_rates(:ncol,:,   274) = rxt_rates(:ncol,:,   274)*sol(:ncol,:,   292)*sol(:ncol,:,    83)                            ! rate_const*O1D*HBR
      rxt_rates(:ncol,:,   275) = rxt_rates(:ncol,:,   275)*sol(:ncol,:,    75)*sol(:ncol,:,    55)                            ! rate_const*F*CH4
      rxt_rates(:ncol,:,   276) = rxt_rates(:ncol,:,   276)*sol(:ncol,:,    75)*sol(:ncol,:,    79)                            ! rate_const*F*H2
      rxt_rates(:ncol,:,   277) = rxt_rates(:ncol,:,   277)*sol(:ncol,:,    75)*sol(:ncol,:,   317)                            ! rate_const*F*H2O
      rxt_rates(:ncol,:,   278) = rxt_rates(:ncol,:,   278)*sol(:ncol,:,    75)*sol(:ncol,:,    93)                            ! rate_const*F*HNO3
      rxt_rates(:ncol,:,   279) = rxt_rates(:ncol,:,   279)*sol(:ncol,:,   292)*sol(:ncol,:,    65)                            ! rate_const*O1D*COF2
      rxt_rates(:ncol,:,   280) = rxt_rates(:ncol,:,   280)*sol(:ncol,:,   292)*sol(:ncol,:,    66)                            ! rate_const*O1D*COFCL
      rxt_rates(:ncol,:,   281) = rxt_rates(:ncol,:,   281)*sol(:ncol,:,    42)*sol(:ncol,:,    57)                            ! rate_const*CH2BR2*CL
      rxt_rates(:ncol,:,   282) = rxt_rates(:ncol,:,   282)*sol(:ncol,:,    42)*sol(:ncol,:,   293)                            ! rate_const*CH2BR2*OH
      rxt_rates(:ncol,:,   283) = rxt_rates(:ncol,:,   283)*sol(:ncol,:,    44)*sol(:ncol,:,    57)                            ! rate_const*CH3BR*CL
      rxt_rates(:ncol,:,   284) = rxt_rates(:ncol,:,   284)*sol(:ncol,:,    44)*sol(:ncol,:,   293)                            ! rate_const*CH3BR*OH
      rxt_rates(:ncol,:,   285) = rxt_rates(:ncol,:,   285)*sol(:ncol,:,    45)*sol(:ncol,:,   293)                            ! rate_const*CH3CCL3*OH
      rxt_rates(:ncol,:,   286) = rxt_rates(:ncol,:,   286)*sol(:ncol,:,    47)*sol(:ncol,:,    57)                            ! rate_const*CH3CL*CL
      rxt_rates(:ncol,:,   287) = rxt_rates(:ncol,:,   287)*sol(:ncol,:,    47)*sol(:ncol,:,   293)                            ! rate_const*CH3CL*OH
      rxt_rates(:ncol,:,   288) = rxt_rates(:ncol,:,   288)*sol(:ncol,:,    56)*sol(:ncol,:,    57)                            ! rate_const*CHBR3*CL
      rxt_rates(:ncol,:,   289) = rxt_rates(:ncol,:,   289)*sol(:ncol,:,    56)*sol(:ncol,:,   293)                            ! rate_const*CHBR3*OH
      rxt_rates(:ncol,:,   290) = rxt_rates(:ncol,:,   290)*sol(:ncol,:,    84)*sol(:ncol,:,   293)                            ! rate_const*HCFC141B*OH
      rxt_rates(:ncol,:,   291) = rxt_rates(:ncol,:,   291)*sol(:ncol,:,    85)*sol(:ncol,:,   293)                            ! rate_const*HCFC142B*OH
      rxt_rates(:ncol,:,   292) = rxt_rates(:ncol,:,   292)*sol(:ncol,:,    86)*sol(:ncol,:,   293)                            ! rate_const*HCFC22*OH
      rxt_rates(:ncol,:,   293) = rxt_rates(:ncol,:,   293)*sol(:ncol,:,   292)*sol(:ncol,:,    42)                            ! rate_const*O1D*CH2BR2
      rxt_rates(:ncol,:,   294) = rxt_rates(:ncol,:,   294)*sol(:ncol,:,   292)*sol(:ncol,:,    44)                            ! rate_const*O1D*CH3BR
      rxt_rates(:ncol,:,   295) = rxt_rates(:ncol,:,   295)*sol(:ncol,:,   292)*sol(:ncol,:,    84)                            ! rate_const*O1D*HCFC141B
      rxt_rates(:ncol,:,   296) = rxt_rates(:ncol,:,   296)*sol(:ncol,:,   292)*sol(:ncol,:,    85)                            ! rate_const*O1D*HCFC142B
      rxt_rates(:ncol,:,   297) = rxt_rates(:ncol,:,   297)*sol(:ncol,:,   292)*sol(:ncol,:,    86)                            ! rate_const*O1D*HCFC22
      rxt_rates(:ncol,:,   298) = rxt_rates(:ncol,:,   298)*sol(:ncol,:,    43)*sol(:ncol,:,   256)                            ! rate_const*CH2O*HO2
      rxt_rates(:ncol,:,   299) = rxt_rates(:ncol,:,   299)*sol(:ncol,:,    43)*sol(:ncol,:,   149)                            ! rate_const*CH2O*NO3
      rxt_rates(:ncol,:,   300) = rxt_rates(:ncol,:,   300)*sol(:ncol,:,    43)*sol(:ncol,:,   156)                            ! rate_const*CH2O*O
      rxt_rates(:ncol,:,   301) = rxt_rates(:ncol,:,   301)*sol(:ncol,:,    43)*sol(:ncol,:,   293)                            ! rate_const*CH2O*OH
      rxt_rates(:ncol,:,   302) = rxt_rates(:ncol,:,   302)*sol(:ncol,:,   251)*sol(:ncol,:,   251)                            ! rate_const*CH3O2*CH3O2
      rxt_rates(:ncol,:,   303) = rxt_rates(:ncol,:,   303)*sol(:ncol,:,   251)*sol(:ncol,:,   251)                            ! rate_const*CH3O2*CH3O2
      rxt_rates(:ncol,:,   304) = rxt_rates(:ncol,:,   304)*sol(:ncol,:,   251)*sol(:ncol,:,   256)                            ! rate_const*CH3O2*HO2
      rxt_rates(:ncol,:,   305) = rxt_rates(:ncol,:,   305)*sol(:ncol,:,   251)*sol(:ncol,:,   147)                            ! rate_const*CH3O2*NO
      rxt_rates(:ncol,:,   306) = rxt_rates(:ncol,:,   306)*sol(:ncol,:,    53)*sol(:ncol,:,   293)                            ! rate_const*CH3OH*OH
      rxt_rates(:ncol,:,   307) = rxt_rates(:ncol,:,   307)*sol(:ncol,:,    54)*sol(:ncol,:,   293)                            ! rate_const*CH3OOH*OH
      rxt_rates(:ncol,:,   308) = rxt_rates(:ncol,:,   308)*sol(:ncol,:,    55)*sol(:ncol,:,   293)                            ! rate_const*CH4*OH
      rxt_rates(:ncol,:,   309) = rxt_rates(:ncol,:,   309)*sol(:ncol,:,    63)*sol(:ncol,:,   293)                            ! rate_const*M*CO*OH
      rxt_rates(:ncol,:,   310) = rxt_rates(:ncol,:,   310)*sol(:ncol,:,    88)*sol(:ncol,:,   293)                            ! rate_const*M*HCN*OH
      rxt_rates(:ncol,:,   311) = rxt_rates(:ncol,:,   311)*sol(:ncol,:,    90)*sol(:ncol,:,   293)                            ! rate_const*HCOOH*OH
      rxt_rates(:ncol,:,   312) = rxt_rates(:ncol,:,   312)*sol(:ncol,:,    92)*sol(:ncol,:,   293)                            ! rate_const*HMHP*OH
      rxt_rates(:ncol,:,   313) = rxt_rates(:ncol,:,   313)*sol(:ncol,:,   257)*sol(:ncol,:,   256)                            ! rate_const*HOCH2OO*HO2
      rxt_rates(:ncol,:,   314) = rxt_rates(:ncol,:,   314)*sol(:ncol,:,   257)                                                ! rate_const*HOCH2OO
      rxt_rates(:ncol,:,   315) = rxt_rates(:ncol,:,   315)*sol(:ncol,:,   257)*sol(:ncol,:,   147)                            ! rate_const*HOCH2OO*NO
      rxt_rates(:ncol,:,   316) = rxt_rates(:ncol,:,   316)*sol(:ncol,:,   292)*sol(:ncol,:,    55)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,   317) = rxt_rates(:ncol,:,   317)*sol(:ncol,:,   292)*sol(:ncol,:,    55)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,   318) = rxt_rates(:ncol,:,   318)*sol(:ncol,:,   292)*sol(:ncol,:,    55)                            ! rate_const*O1D*CH4
      rxt_rates(:ncol,:,   319) = rxt_rates(:ncol,:,   319)*sol(:ncol,:,   292)*sol(:ncol,:,    88)                            ! rate_const*O1D*HCN
      rxt_rates(:ncol,:,   320) = rxt_rates(:ncol,:,   320)*sol(:ncol,:,    63)*sol(:ncol,:,   293)                            ! rate_const*CO*OH
      rxt_rates(:ncol,:,   321) = rxt_rates(:ncol,:,   321)*sol(:ncol,:,    25)*sol(:ncol,:,    57)                            ! rate_const*M*C2H2*CL
      rxt_rates(:ncol,:,   322) = rxt_rates(:ncol,:,   322)*sol(:ncol,:,    25)*sol(:ncol,:,   293)                            ! rate_const*M*C2H2*OH
      rxt_rates(:ncol,:,   323) = rxt_rates(:ncol,:,   323)*sol(:ncol,:,    26)*sol(:ncol,:,    57)                            ! rate_const*M*C2H4*CL
      rxt_rates(:ncol,:,   324) = rxt_rates(:ncol,:,   324)*sol(:ncol,:,    26)*sol(:ncol,:,   157)                            ! rate_const*C2H4*O3
      rxt_rates(:ncol,:,   325) = rxt_rates(:ncol,:,   325)*sol(:ncol,:,   247)*sol(:ncol,:,   247)                            ! rate_const*C2H5O2*C2H5O2
      rxt_rates(:ncol,:,   326) = rxt_rates(:ncol,:,   326)*sol(:ncol,:,   247)*sol(:ncol,:,   251)                            ! rate_const*C2H5O2*CH3O2
      rxt_rates(:ncol,:,   327) = rxt_rates(:ncol,:,   327)*sol(:ncol,:,   247)*sol(:ncol,:,   256)                            ! rate_const*C2H5O2*HO2
      rxt_rates(:ncol,:,   328) = rxt_rates(:ncol,:,   328)*sol(:ncol,:,   247)*sol(:ncol,:,   147)                            ! rate_const*C2H5O2*NO
      rxt_rates(:ncol,:,   329) = rxt_rates(:ncol,:,   329)*sol(:ncol,:,    27)*sol(:ncol,:,   293)                            ! rate_const*C2H5OH*OH
      rxt_rates(:ncol,:,   330) = rxt_rates(:ncol,:,   330)*sol(:ncol,:,    28)*sol(:ncol,:,   293)                            ! rate_const*C2H5OOH*OH
      rxt_rates(:ncol,:,   331) = rxt_rates(:ncol,:,   331)*sol(:ncol,:,    29)*sol(:ncol,:,    57)                            ! rate_const*C2H6*CL
      rxt_rates(:ncol,:,   332) = rxt_rates(:ncol,:,   332)*sol(:ncol,:,    29)*sol(:ncol,:,   293)                            ! rate_const*C2H6*OH
      rxt_rates(:ncol,:,   333) = rxt_rates(:ncol,:,   333)*sol(:ncol,:,    46)*sol(:ncol,:,   149)                            ! rate_const*CH3CHO*NO3
      rxt_rates(:ncol,:,   334) = rxt_rates(:ncol,:,   334)*sol(:ncol,:,    46)*sol(:ncol,:,   293)                            ! rate_const*CH3CHO*OH
      rxt_rates(:ncol,:,   335) = rxt_rates(:ncol,:,   335)*sol(:ncol,:,    48)*sol(:ncol,:,   293)                            ! rate_const*CH3CN*OH
      rxt_rates(:ncol,:,   336) = rxt_rates(:ncol,:,   336)*sol(:ncol,:,   250)*sol(:ncol,:,   250)                            ! rate_const*CH3CO3*CH3CO3
      rxt_rates(:ncol,:,   337) = rxt_rates(:ncol,:,   337)*sol(:ncol,:,   250)*sol(:ncol,:,   251)                            ! rate_const*CH3CO3*CH3O2
      rxt_rates(:ncol,:,   338) = rxt_rates(:ncol,:,   338)*sol(:ncol,:,   250)*sol(:ncol,:,   256)                            ! rate_const*CH3CO3*HO2
      rxt_rates(:ncol,:,   339) = rxt_rates(:ncol,:,   339)*sol(:ncol,:,   250)*sol(:ncol,:,   147)                            ! rate_const*CH3CO3*NO
      rxt_rates(:ncol,:,   340) = rxt_rates(:ncol,:,   340)*sol(:ncol,:,    51)*sol(:ncol,:,   293)                            ! rate_const*CH3COOH*OH
      rxt_rates(:ncol,:,   341) = rxt_rates(:ncol,:,   341)*sol(:ncol,:,    52)*sol(:ncol,:,   293)                            ! rate_const*CH3COOOH*OH
      rxt_rates(:ncol,:,   342) = rxt_rates(:ncol,:,   342)*sol(:ncol,:,   255)*sol(:ncol,:,   256)                            ! rate_const*EO2*HO2
      rxt_rates(:ncol,:,   343) = rxt_rates(:ncol,:,   343)*sol(:ncol,:,   255)*sol(:ncol,:,   147)                            ! rate_const*EO2*NO
      rxt_rates(:ncol,:,   344) = rxt_rates(:ncol,:,   344)*sol(:ncol,:,   254)                                                ! rate_const*EO
      rxt_rates(:ncol,:,   345) = rxt_rates(:ncol,:,   345)*sol(:ncol,:,   254)                                                ! rate_const*O2*EO
      rxt_rates(:ncol,:,   346) = rxt_rates(:ncol,:,   346)*sol(:ncol,:,    76)*sol(:ncol,:,   293)                            ! rate_const*GLYALD*OH
      rxt_rates(:ncol,:,   347) = rxt_rates(:ncol,:,   347)*sol(:ncol,:,    77)*sol(:ncol,:,   293)                            ! rate_const*GLYOXAL*OH
      rxt_rates(:ncol,:,   348) = rxt_rates(:ncol,:,   348)*sol(:ncol,:,    89)*sol(:ncol,:,   293)                            ! rate_const*HCOCH2OOH*OH
      rxt_rates(:ncol,:,   349) = rxt_rates(:ncol,:,   349)*sol(:ncol,:,   150)*sol(:ncol,:,   293)                            ! rate_const*NO3CH2CHO*OH
      rxt_rates(:ncol,:,   350) = rxt_rates(:ncol,:,   350)*sol(:ncol,:,   162)*sol(:ncol,:,   293)                            ! rate_const*PAN*OH
      rxt_rates(:ncol,:,   351) = rxt_rates(:ncol,:,   351)*sol(:ncol,:,    26)*sol(:ncol,:,   293)                            ! rate_const*M*C2H4*OH
      rxt_rates(:ncol,:,   352) = rxt_rates(:ncol,:,   352)*sol(:ncol,:,   250)*sol(:ncol,:,   148)                            ! rate_const*M*CH3CO3*NO2
      rxt_rates(:ncol,:,   353) = rxt_rates(:ncol,:,   353)*sol(:ncol,:,   162)                                                ! rate_const*M*PAN
      rxt_rates(:ncol,:,   354) = rxt_rates(:ncol,:,   354)*sol(:ncol,:,    30)*sol(:ncol,:,   149)                            ! rate_const*C3H6*NO3
      rxt_rates(:ncol,:,   355) = rxt_rates(:ncol,:,   355)*sol(:ncol,:,    30)*sol(:ncol,:,   157)                            ! rate_const*C3H6*O3
      rxt_rates(:ncol,:,   356) = rxt_rates(:ncol,:,   356)*sol(:ncol,:,   248)*sol(:ncol,:,   251)                            ! rate_const*C3H7O2*CH3O2
      rxt_rates(:ncol,:,   357) = rxt_rates(:ncol,:,   357)*sol(:ncol,:,   248)*sol(:ncol,:,   256)                            ! rate_const*C3H7O2*HO2
      rxt_rates(:ncol,:,   358) = rxt_rates(:ncol,:,   358)*sol(:ncol,:,   248)*sol(:ncol,:,   147)                            ! rate_const*C3H7O2*NO
      rxt_rates(:ncol,:,   359) = rxt_rates(:ncol,:,   359)*sol(:ncol,:,    31)*sol(:ncol,:,   293)                            ! rate_const*C3H7OOH*OH
      rxt_rates(:ncol,:,   360) = rxt_rates(:ncol,:,   360)*sol(:ncol,:,    32)*sol(:ncol,:,   293)                            ! rate_const*C3H8*OH
      rxt_rates(:ncol,:,   361) = rxt_rates(:ncol,:,   361)*sol(:ncol,:,    50)*sol(:ncol,:,   149)                            ! rate_const*CH3COCHO*NO3
      rxt_rates(:ncol,:,   362) = rxt_rates(:ncol,:,   362)*sol(:ncol,:,    50)*sol(:ncol,:,   293)                            ! rate_const*CH3COCHO*OH
      rxt_rates(:ncol,:,   363) = rxt_rates(:ncol,:,   363)*sol(:ncol,:,   102)*sol(:ncol,:,   293)                            ! rate_const*HYAC*OH
      rxt_rates(:ncol,:,   364) = rxt_rates(:ncol,:,   364)*sol(:ncol,:,   104)*sol(:ncol,:,   293)                            ! rate_const*HYPERACET*OH
      rxt_rates(:ncol,:,   365) = rxt_rates(:ncol,:,   365)*sol(:ncol,:,   151)*sol(:ncol,:,   293)                            ! rate_const*NOA*OH
      rxt_rates(:ncol,:,   366) = rxt_rates(:ncol,:,   366)*sol(:ncol,:,   295)*sol(:ncol,:,   256)                            ! rate_const*PO2*HO2
      rxt_rates(:ncol,:,   367) = rxt_rates(:ncol,:,   367)*sol(:ncol,:,   295)*sol(:ncol,:,   147)                            ! rate_const*PO2*NO
      rxt_rates(:ncol,:,   368) = rxt_rates(:ncol,:,   368)*sol(:ncol,:,   169)*sol(:ncol,:,   293)                            ! rate_const*POOH*OH
      rxt_rates(:ncol,:,   369) = rxt_rates(:ncol,:,   369)*sol(:ncol,:,   296)*sol(:ncol,:,   251)                            ! rate_const*RO2*CH3O2
      rxt_rates(:ncol,:,   370) = rxt_rates(:ncol,:,   370)*sol(:ncol,:,   296)*sol(:ncol,:,   256)                            ! rate_const*RO2*HO2
      rxt_rates(:ncol,:,   371) = rxt_rates(:ncol,:,   371)*sol(:ncol,:,   296)*sol(:ncol,:,   147)                            ! rate_const*RO2*NO
      rxt_rates(:ncol,:,   372) = rxt_rates(:ncol,:,   372)*sol(:ncol,:,   170)*sol(:ncol,:,   293)                            ! rate_const*ROOH*OH
      rxt_rates(:ncol,:,   373) = rxt_rates(:ncol,:,   373)*sol(:ncol,:,    30)*sol(:ncol,:,   293)                            ! rate_const*M*C3H6*OH
      rxt_rates(:ncol,:,   374) = rxt_rates(:ncol,:,   374)*sol(:ncol,:,    49)*sol(:ncol,:,   293)                            ! rate_const*CH3COCH3*OH
      rxt_rates(:ncol,:,   375) = rxt_rates(:ncol,:,   375)*sol(:ncol,:,    16)*sol(:ncol,:,   149)                            ! rate_const*BIGENE*NO3
      rxt_rates(:ncol,:,   376) = rxt_rates(:ncol,:,   376)*sol(:ncol,:,    16)*sol(:ncol,:,   293)                            ! rate_const*BIGENE*OH
      rxt_rates(:ncol,:,   377) = rxt_rates(:ncol,:,   377)*sol(:ncol,:,    68)*sol(:ncol,:,   293)                            ! rate_const*DHPMPAL*OH
      rxt_rates(:ncol,:,   378) = rxt_rates(:ncol,:,   378)*sol(:ncol,:,   253)*sol(:ncol,:,   147)                            ! rate_const*ENEO2*NO
      rxt_rates(:ncol,:,   379) = rxt_rates(:ncol,:,   379)*sol(:ncol,:,   253)*sol(:ncol,:,   147)                            ! rate_const*ENEO2*NO
      rxt_rates(:ncol,:,   380) = rxt_rates(:ncol,:,   380)*sol(:ncol,:,    97)*sol(:ncol,:,   293)                            ! rate_const*HONITR*OH
      rxt_rates(:ncol,:,   381) = rxt_rates(:ncol,:,   381)*sol(:ncol,:,   127)*sol(:ncol,:,   293)                            ! rate_const*MACRN*OH
      rxt_rates(:ncol,:,   382) = rxt_rates(:ncol,:,   382)*sol(:ncol,:,   282)*sol(:ncol,:,   250)                            ! rate_const*MACRO2*CH3CO3
      rxt_rates(:ncol,:,   383) = rxt_rates(:ncol,:,   383)*sol(:ncol,:,   282)*sol(:ncol,:,   251)                            ! rate_const*MACRO2*CH3O2
      rxt_rates(:ncol,:,   384) = rxt_rates(:ncol,:,   384)*sol(:ncol,:,   282)*sol(:ncol,:,   256)                            ! rate_const*MACRO2*HO2
      rxt_rates(:ncol,:,   385) = rxt_rates(:ncol,:,   385)*sol(:ncol,:,   282)                                                ! rate_const*MACRO2
      rxt_rates(:ncol,:,   386) = rxt_rates(:ncol,:,   386)*sol(:ncol,:,   126)*sol(:ncol,:,   157)                            ! rate_const*MACR*O3
      rxt_rates(:ncol,:,   387) = rxt_rates(:ncol,:,   387)*sol(:ncol,:,   126)*sol(:ncol,:,   293)                            ! rate_const*MACR*OH
      rxt_rates(:ncol,:,   388) = rxt_rates(:ncol,:,   388)*sol(:ncol,:,   128)*sol(:ncol,:,   293)                            ! rate_const*MACROOH*OH
      rxt_rates(:ncol,:,   389) = rxt_rates(:ncol,:,   389)*sol(:ncol,:,   284)*sol(:ncol,:,   250)                            ! rate_const*MCO3*CH3CO3
      rxt_rates(:ncol,:,   390) = rxt_rates(:ncol,:,   390)*sol(:ncol,:,   284)*sol(:ncol,:,   251)                            ! rate_const*MCO3*CH3O2
      rxt_rates(:ncol,:,   391) = rxt_rates(:ncol,:,   391)*sol(:ncol,:,   284)*sol(:ncol,:,   256)                            ! rate_const*MCO3*HO2
      rxt_rates(:ncol,:,   392) = rxt_rates(:ncol,:,   392)*sol(:ncol,:,   284)*sol(:ncol,:,   284)                            ! rate_const*MCO3*MCO3
      rxt_rates(:ncol,:,   393) = rxt_rates(:ncol,:,   393)*sol(:ncol,:,   284)*sol(:ncol,:,   147)                            ! rate_const*MCO3*NO
      rxt_rates(:ncol,:,   394) = rxt_rates(:ncol,:,   394)*sol(:ncol,:,   284)*sol(:ncol,:,   149)                            ! rate_const*MCO3*NO3
      rxt_rates(:ncol,:,   395) = rxt_rates(:ncol,:,   395)*sol(:ncol,:,   286)*sol(:ncol,:,   256)                            ! rate_const*MEKO2*HO2
      rxt_rates(:ncol,:,   396) = rxt_rates(:ncol,:,   396)*sol(:ncol,:,   286)*sol(:ncol,:,   147)                            ! rate_const*MEKO2*NO
      rxt_rates(:ncol,:,   397) = rxt_rates(:ncol,:,   397)*sol(:ncol,:,   129)*sol(:ncol,:,   293)                            ! rate_const*MEK*OH
      rxt_rates(:ncol,:,   398) = rxt_rates(:ncol,:,   398)*sol(:ncol,:,   130)*sol(:ncol,:,   293)                            ! rate_const*MEKOOH*OH
      rxt_rates(:ncol,:,   399) = rxt_rates(:ncol,:,   399)*sol(:ncol,:,   131)*sol(:ncol,:,   293)                            ! rate_const*M*MPAN*OH
      rxt_rates(:ncol,:,   400) = rxt_rates(:ncol,:,   400)*sol(:ncol,:,   133)*sol(:ncol,:,   293)                            ! rate_const*MVKN*OH
      rxt_rates(:ncol,:,   401) = rxt_rates(:ncol,:,   401)*sol(:ncol,:,   287)*sol(:ncol,:,   250)                            ! rate_const*MVKO2*CH3CO3
      rxt_rates(:ncol,:,   402) = rxt_rates(:ncol,:,   402)*sol(:ncol,:,   287)*sol(:ncol,:,   251)                            ! rate_const*MVKO2*CH3O2
      rxt_rates(:ncol,:,   403) = rxt_rates(:ncol,:,   403)*sol(:ncol,:,   287)*sol(:ncol,:,   256)                            ! rate_const*MVKO2*HO2
      rxt_rates(:ncol,:,   404) = rxt_rates(:ncol,:,   404)*sol(:ncol,:,   132)*sol(:ncol,:,   157)                            ! rate_const*MVK*O3
      rxt_rates(:ncol,:,   405) = rxt_rates(:ncol,:,   405)*sol(:ncol,:,   132)*sol(:ncol,:,   293)                            ! rate_const*MVK*OH
      rxt_rates(:ncol,:,   406) = rxt_rates(:ncol,:,   406)*sol(:ncol,:,   134)*sol(:ncol,:,   293)                            ! rate_const*MVKOOH*OH
      rxt_rates(:ncol,:,   407) = rxt_rates(:ncol,:,   407)*sol(:ncol,:,   284)*sol(:ncol,:,   148)                            ! rate_const*M*MCO3*NO2
      rxt_rates(:ncol,:,   408) = rxt_rates(:ncol,:,   408)*sol(:ncol,:,   131)                                                ! rate_const*M*MPAN
      rxt_rates(:ncol,:,   409) = rxt_rates(:ncol,:,   409)*sol(:ncol,:,     1)*sol(:ncol,:,   293)                            ! rate_const*ALKNIT*OH
      rxt_rates(:ncol,:,   410) = rxt_rates(:ncol,:,   410)*sol(:ncol,:,   234)*sol(:ncol,:,   256)                            ! rate_const*ALKO2*HO2
      rxt_rates(:ncol,:,   411) = rxt_rates(:ncol,:,   411)*sol(:ncol,:,   234)*sol(:ncol,:,   147)                            ! rate_const*ALKO2*NO
      rxt_rates(:ncol,:,   412) = rxt_rates(:ncol,:,   412)*sol(:ncol,:,   234)*sol(:ncol,:,   147)                            ! rate_const*ALKO2*NO
      rxt_rates(:ncol,:,   413) = rxt_rates(:ncol,:,   413)*sol(:ncol,:,     2)*sol(:ncol,:,   293)                            ! rate_const*ALKOOH*OH
      rxt_rates(:ncol,:,   414) = rxt_rates(:ncol,:,   414)*sol(:ncol,:,    15)*sol(:ncol,:,   293)                            ! rate_const*BIGALK*OH
      rxt_rates(:ncol,:,   415) = rxt_rates(:ncol,:,   415)*sol(:ncol,:,    98)*sol(:ncol,:,   293)                            ! rate_const*HPALD1*OH
      rxt_rates(:ncol,:,   416) = rxt_rates(:ncol,:,   416)*sol(:ncol,:,    99)*sol(:ncol,:,   293)                            ! rate_const*HPALD4*OH
      rxt_rates(:ncol,:,   417) = rxt_rates(:ncol,:,   417)*sol(:ncol,:,   100)*sol(:ncol,:,   293)                            ! rate_const*HPALDB1C*OH
      rxt_rates(:ncol,:,   418) = rxt_rates(:ncol,:,   418)*sol(:ncol,:,   101)*sol(:ncol,:,   293)                            ! rate_const*HPALDB4C*OH
      rxt_rates(:ncol,:,   419) = rxt_rates(:ncol,:,   419)*sol(:ncol,:,   103)*sol(:ncol,:,   293)                            ! rate_const*HYDRALD*OH
      rxt_rates(:ncol,:,   420) = rxt_rates(:ncol,:,   420)*sol(:ncol,:,   105)*sol(:ncol,:,   293)                            ! rate_const*ICHE*OH
      rxt_rates(:ncol,:,   421) = rxt_rates(:ncol,:,   421)*sol(:ncol,:,   106)*sol(:ncol,:,   293)                            ! rate_const*IEPOX*OH
      rxt_rates(:ncol,:,   422) = rxt_rates(:ncol,:,   422)*sol(:ncol,:,   258)*sol(:ncol,:,   256)                            ! rate_const*IEPOXOO*HO2
      rxt_rates(:ncol,:,   423) = rxt_rates(:ncol,:,   423)*sol(:ncol,:,   107)*sol(:ncol,:,   293)                            ! rate_const*INHEB*OH
      rxt_rates(:ncol,:,   424) = rxt_rates(:ncol,:,   424)*sol(:ncol,:,   108)*sol(:ncol,:,   293)                            ! rate_const*INHED*OH
      rxt_rates(:ncol,:,   425) = rxt_rates(:ncol,:,   425)*sol(:ncol,:,   259)*sol(:ncol,:,   250)                            ! rate_const*ISOPB1O2*CH3CO3
      rxt_rates(:ncol,:,   426) = rxt_rates(:ncol,:,   426)*sol(:ncol,:,   259)*sol(:ncol,:,   251)                            ! rate_const*ISOPB1O2*CH3O2
      rxt_rates(:ncol,:,   427) = rxt_rates(:ncol,:,   427)*sol(:ncol,:,   259)*sol(:ncol,:,   256)                            ! rate_const*ISOPB1O2*HO2
      rxt_rates(:ncol,:,   428) = rxt_rates(:ncol,:,   428)*sol(:ncol,:,   259)                                                ! rate_const*ISOPB1O2
      rxt_rates(:ncol,:,   429) = rxt_rates(:ncol,:,   429)*sol(:ncol,:,   259)                                                ! rate_const*ISOPB1O2
      rxt_rates(:ncol,:,   430) = rxt_rates(:ncol,:,   430)*sol(:ncol,:,   259)                                                ! rate_const*ISOPB1O2
      rxt_rates(:ncol,:,   431) = rxt_rates(:ncol,:,   431)*sol(:ncol,:,   260)*sol(:ncol,:,   250)                            ! rate_const*ISOPB4O2*CH3CO3
      rxt_rates(:ncol,:,   432) = rxt_rates(:ncol,:,   432)*sol(:ncol,:,   260)*sol(:ncol,:,   251)                            ! rate_const*ISOPB4O2*CH3O2
      rxt_rates(:ncol,:,   433) = rxt_rates(:ncol,:,   433)*sol(:ncol,:,   260)*sol(:ncol,:,   256)                            ! rate_const*ISOPB4O2*HO2
      rxt_rates(:ncol,:,   434) = rxt_rates(:ncol,:,   434)*sol(:ncol,:,   260)                                                ! rate_const*ISOPB4O2
      rxt_rates(:ncol,:,   435) = rxt_rates(:ncol,:,   435)*sol(:ncol,:,   260)                                                ! rate_const*ISOPB4O2
      rxt_rates(:ncol,:,   436) = rxt_rates(:ncol,:,   436)*sol(:ncol,:,   260)                                                ! rate_const*ISOPB4O2
      rxt_rates(:ncol,:,   437) = rxt_rates(:ncol,:,   437)*sol(:ncol,:,   261)                                                ! rate_const*O2*ISOPC1C
      rxt_rates(:ncol,:,   438) = rxt_rates(:ncol,:,   438)*sol(:ncol,:,   261)                                                ! rate_const*O2*ISOPC1C
      rxt_rates(:ncol,:,   439) = rxt_rates(:ncol,:,   439)*sol(:ncol,:,   262)                                                ! rate_const*O2*ISOPC1T
      rxt_rates(:ncol,:,   440) = rxt_rates(:ncol,:,   440)*sol(:ncol,:,   262)                                                ! rate_const*O2*ISOPC1T
      rxt_rates(:ncol,:,   441) = rxt_rates(:ncol,:,   441)*sol(:ncol,:,   263)                                                ! rate_const*O2*ISOPC4C
      rxt_rates(:ncol,:,   442) = rxt_rates(:ncol,:,   442)*sol(:ncol,:,   263)                                                ! rate_const*O2*ISOPC4C
      rxt_rates(:ncol,:,   443) = rxt_rates(:ncol,:,   443)*sol(:ncol,:,   264)                                                ! rate_const*O2*ISOPC4T
      rxt_rates(:ncol,:,   444) = rxt_rates(:ncol,:,   444)*sol(:ncol,:,   264)                                                ! rate_const*O2*ISOPC4T
      rxt_rates(:ncol,:,   445) = rxt_rates(:ncol,:,   445)*sol(:ncol,:,   265)*sol(:ncol,:,   250)                            ! rate_const*ISOPED1O2*CH3CO3
      rxt_rates(:ncol,:,   446) = rxt_rates(:ncol,:,   446)*sol(:ncol,:,   265)*sol(:ncol,:,   251)                            ! rate_const*ISOPED1O2*CH3O2
      rxt_rates(:ncol,:,   447) = rxt_rates(:ncol,:,   447)*sol(:ncol,:,   265)*sol(:ncol,:,   256)                            ! rate_const*ISOPED1O2*HO2
      rxt_rates(:ncol,:,   448) = rxt_rates(:ncol,:,   448)*sol(:ncol,:,   265)                                                ! rate_const*ISOPED1O2
      rxt_rates(:ncol,:,   449) = rxt_rates(:ncol,:,   449)*sol(:ncol,:,   266)*sol(:ncol,:,   250)                            ! rate_const*ISOPED4O2*CH3CO3
      rxt_rates(:ncol,:,   450) = rxt_rates(:ncol,:,   450)*sol(:ncol,:,   266)*sol(:ncol,:,   251)                            ! rate_const*ISOPED4O2*CH3O2
      rxt_rates(:ncol,:,   451) = rxt_rates(:ncol,:,   451)*sol(:ncol,:,   266)*sol(:ncol,:,   256)                            ! rate_const*ISOPED4O2*HO2
      rxt_rates(:ncol,:,   452) = rxt_rates(:ncol,:,   452)*sol(:ncol,:,   266)                                                ! rate_const*ISOPED4O2
      rxt_rates(:ncol,:,   453) = rxt_rates(:ncol,:,   453)*sol(:ncol,:,   111)*sol(:ncol,:,   293)                            ! rate_const*ISOPFDNC*OH
      rxt_rates(:ncol,:,   454) = rxt_rates(:ncol,:,   454)*sol(:ncol,:,   110)*sol(:ncol,:,   293)                            ! rate_const*ISOPFDN*OH
      rxt_rates(:ncol,:,   455) = rxt_rates(:ncol,:,   455)*sol(:ncol,:,   112)*sol(:ncol,:,   293)                            ! rate_const*ISOPFNC*OH
      rxt_rates(:ncol,:,   456) = rxt_rates(:ncol,:,   456)*sol(:ncol,:,   113)*sol(:ncol,:,   293)                            ! rate_const*ISOPFNP*OH
      rxt_rates(:ncol,:,   457) = rxt_rates(:ncol,:,   457)*sol(:ncol,:,   114)*sol(:ncol,:,   293)                            ! rate_const*ISOPHFP*OH
      rxt_rates(:ncol,:,   458) = rxt_rates(:ncol,:,   458)*sol(:ncol,:,   267)*sol(:ncol,:,   256)                            ! rate_const*ISOPN1DO2*HO2
      rxt_rates(:ncol,:,   459) = rxt_rates(:ncol,:,   459)*sol(:ncol,:,   267)                                                ! rate_const*ISOPN1DO2
      rxt_rates(:ncol,:,   460) = rxt_rates(:ncol,:,   460)*sol(:ncol,:,   115)*sol(:ncol,:,   157)                            ! rate_const*ISOPN1D*O3
      rxt_rates(:ncol,:,   461) = rxt_rates(:ncol,:,   461)*sol(:ncol,:,   115)*sol(:ncol,:,   293)                            ! rate_const*ISOPN1D*OH
      rxt_rates(:ncol,:,   462) = rxt_rates(:ncol,:,   462)*sol(:ncol,:,   268)*sol(:ncol,:,   256)                            ! rate_const*ISOPN2BO2*HO2
      rxt_rates(:ncol,:,   463) = rxt_rates(:ncol,:,   463)*sol(:ncol,:,   268)                                                ! rate_const*ISOPN2BO2
      rxt_rates(:ncol,:,   464) = rxt_rates(:ncol,:,   464)*sol(:ncol,:,   116)*sol(:ncol,:,   293)                            ! rate_const*ISOPN2B*OH
      rxt_rates(:ncol,:,   465) = rxt_rates(:ncol,:,   465)*sol(:ncol,:,   269)*sol(:ncol,:,   256)                            ! rate_const*ISOPN3BO2*HO2
      rxt_rates(:ncol,:,   466) = rxt_rates(:ncol,:,   466)*sol(:ncol,:,   269)                                                ! rate_const*ISOPN3BO2
      rxt_rates(:ncol,:,   467) = rxt_rates(:ncol,:,   467)*sol(:ncol,:,   117)*sol(:ncol,:,   293)                            ! rate_const*ISOPN3B*OH
      rxt_rates(:ncol,:,   468) = rxt_rates(:ncol,:,   468)*sol(:ncol,:,   270)*sol(:ncol,:,   256)                            ! rate_const*ISOPN4DO2*HO2
      rxt_rates(:ncol,:,   469) = rxt_rates(:ncol,:,   469)*sol(:ncol,:,   270)                                                ! rate_const*ISOPN4DO2
      rxt_rates(:ncol,:,   470) = rxt_rates(:ncol,:,   470)*sol(:ncol,:,   118)*sol(:ncol,:,   157)                            ! rate_const*ISOPN4D*O3
      rxt_rates(:ncol,:,   471) = rxt_rates(:ncol,:,   471)*sol(:ncol,:,   118)*sol(:ncol,:,   293)                            ! rate_const*ISOPN4D*OH
      rxt_rates(:ncol,:,   472) = rxt_rates(:ncol,:,   472)*sol(:ncol,:,   271)*sol(:ncol,:,   256)                            ! rate_const*ISOPNBNO3O2*HO2
      rxt_rates(:ncol,:,   473) = rxt_rates(:ncol,:,   473)*sol(:ncol,:,   119)*sol(:ncol,:,   293)                            ! rate_const*ISOPNBNO3*OH
      rxt_rates(:ncol,:,   474) = rxt_rates(:ncol,:,   474)*sol(:ncol,:,   109)*sol(:ncol,:,   149)                            ! rate_const*ISOP*NO3
      rxt_rates(:ncol,:,   475) = rxt_rates(:ncol,:,   475)*sol(:ncol,:,   272)*sol(:ncol,:,   250)                            ! rate_const*ISOPNO3*CH3CO3
      rxt_rates(:ncol,:,   476) = rxt_rates(:ncol,:,   476)*sol(:ncol,:,   272)*sol(:ncol,:,   251)                            ! rate_const*ISOPNO3*CH3O2
      rxt_rates(:ncol,:,   477) = rxt_rates(:ncol,:,   477)*sol(:ncol,:,   272)*sol(:ncol,:,   256)                            ! rate_const*ISOPNO3*HO2
      rxt_rates(:ncol,:,   478) = rxt_rates(:ncol,:,   478)*sol(:ncol,:,   272)*sol(:ncol,:,   272)                            ! rate_const*ISOPNO3*ISOPNO3
      rxt_rates(:ncol,:,   479) = rxt_rates(:ncol,:,   479)*sol(:ncol,:,   272)*sol(:ncol,:,   149)                            ! rate_const*ISOPNO3*NO3
      rxt_rates(:ncol,:,   480) = rxt_rates(:ncol,:,   480)*sol(:ncol,:,   273)*sol(:ncol,:,   256)                            ! rate_const*ISOPNOOHBO2*HO2
      rxt_rates(:ncol,:,   481) = rxt_rates(:ncol,:,   481)*sol(:ncol,:,   273)                                                ! rate_const*ISOPNOOHBO2
      rxt_rates(:ncol,:,   482) = rxt_rates(:ncol,:,   482)*sol(:ncol,:,   120)*sol(:ncol,:,   293)                            ! rate_const*ISOPNOOHB*OH
      rxt_rates(:ncol,:,   483) = rxt_rates(:ncol,:,   483)*sol(:ncol,:,   274)*sol(:ncol,:,   256)                            ! rate_const*ISOPNOOHDO2*HO2
      rxt_rates(:ncol,:,   484) = rxt_rates(:ncol,:,   484)*sol(:ncol,:,   274)                                                ! rate_const*ISOPNOOHDO2
      rxt_rates(:ncol,:,   485) = rxt_rates(:ncol,:,   485)*sol(:ncol,:,   121)*sol(:ncol,:,   157)                            ! rate_const*ISOPNOOHD*O3
      rxt_rates(:ncol,:,   486) = rxt_rates(:ncol,:,   486)*sol(:ncol,:,   121)*sol(:ncol,:,   293)                            ! rate_const*ISOPNOOHD*OH
      rxt_rates(:ncol,:,   487) = rxt_rates(:ncol,:,   487)*sol(:ncol,:,   109)*sol(:ncol,:,   157)                            ! rate_const*ISOP*O3
      rxt_rates(:ncol,:,   488) = rxt_rates(:ncol,:,   488)*sol(:ncol,:,   109)*sol(:ncol,:,   293)                            ! rate_const*ISOP*OH
      rxt_rates(:ncol,:,   489) = rxt_rates(:ncol,:,   489)*sol(:ncol,:,   122)*sol(:ncol,:,   293)                            ! rate_const*ISOPOH*OH
      rxt_rates(:ncol,:,   490) = rxt_rates(:ncol,:,   490)*sol(:ncol,:,   123)*sol(:ncol,:,   293)                            ! rate_const*ISOPOOH*OH
      rxt_rates(:ncol,:,   491) = rxt_rates(:ncol,:,   491)*sol(:ncol,:,   123)*sol(:ncol,:,   293)                            ! rate_const*ISOPOOH*OH
      rxt_rates(:ncol,:,   492) = rxt_rates(:ncol,:,   492)*sol(:ncol,:,   276)*sol(:ncol,:,   250)                            ! rate_const*ISOPZD1O2*CH3CO3
      rxt_rates(:ncol,:,   493) = rxt_rates(:ncol,:,   493)*sol(:ncol,:,   276)*sol(:ncol,:,   251)                            ! rate_const*ISOPZD1O2*CH3O2
      rxt_rates(:ncol,:,   494) = rxt_rates(:ncol,:,   494)*sol(:ncol,:,   276)*sol(:ncol,:,   256)                            ! rate_const*ISOPZD1O2*HO2
      rxt_rates(:ncol,:,   495) = rxt_rates(:ncol,:,   495)*sol(:ncol,:,   276)                                                ! rate_const*ISOPZD1O2
      rxt_rates(:ncol,:,   496) = rxt_rates(:ncol,:,   496)*sol(:ncol,:,   277)*sol(:ncol,:,   250)                            ! rate_const*ISOPZD4O2*CH3CO3
      rxt_rates(:ncol,:,   497) = rxt_rates(:ncol,:,   497)*sol(:ncol,:,   277)*sol(:ncol,:,   251)                            ! rate_const*ISOPZD4O2*CH3O2
      rxt_rates(:ncol,:,   498) = rxt_rates(:ncol,:,   498)*sol(:ncol,:,   277)*sol(:ncol,:,   256)                            ! rate_const*ISOPZD4O2*HO2
      rxt_rates(:ncol,:,   499) = rxt_rates(:ncol,:,   499)*sol(:ncol,:,   277)                                                ! rate_const*ISOPZD4O2
      rxt_rates(:ncol,:,   500) = rxt_rates(:ncol,:,   500)*sol(:ncol,:,   291)*sol(:ncol,:,   256)                            ! rate_const*NC4CHOO2*HO2
      rxt_rates(:ncol,:,   501) = rxt_rates(:ncol,:,   501)*sol(:ncol,:,   291)                                                ! rate_const*NC4CHOO2
      rxt_rates(:ncol,:,   502) = rxt_rates(:ncol,:,   502)*sol(:ncol,:,   139)*sol(:ncol,:,   157)                            ! rate_const*NC4CHO*O3
      rxt_rates(:ncol,:,   503) = rxt_rates(:ncol,:,   503)*sol(:ncol,:,   139)*sol(:ncol,:,   293)                            ! rate_const*NC4CHO*OH
      rxt_rates(:ncol,:,   504) = rxt_rates(:ncol,:,   504)*sol(:ncol,:,   258)*sol(:ncol,:,   147)                            ! rate_const*IEPOXOO*NO
      rxt_rates(:ncol,:,   505) = rxt_rates(:ncol,:,   505)*sol(:ncol,:,   258)*sol(:ncol,:,   147)                            ! rate_const*IEPOXOO*NO
      rxt_rates(:ncol,:,   506) = rxt_rates(:ncol,:,   506)*sol(:ncol,:,   259)*sol(:ncol,:,   147)                            ! rate_const*ISOPB1O2*NO
      rxt_rates(:ncol,:,   507) = rxt_rates(:ncol,:,   507)*sol(:ncol,:,   259)*sol(:ncol,:,   147)                            ! rate_const*ISOPB1O2*NO
      rxt_rates(:ncol,:,   508) = rxt_rates(:ncol,:,   508)*sol(:ncol,:,   260)*sol(:ncol,:,   147)                            ! rate_const*ISOPB4O2*NO
      rxt_rates(:ncol,:,   509) = rxt_rates(:ncol,:,   509)*sol(:ncol,:,   260)*sol(:ncol,:,   147)                            ! rate_const*ISOPB4O2*NO
      rxt_rates(:ncol,:,   510) = rxt_rates(:ncol,:,   510)*sol(:ncol,:,   265)*sol(:ncol,:,   147)                            ! rate_const*ISOPED1O2*NO
      rxt_rates(:ncol,:,   511) = rxt_rates(:ncol,:,   511)*sol(:ncol,:,   265)*sol(:ncol,:,   147)                            ! rate_const*ISOPED1O2*NO
      rxt_rates(:ncol,:,   512) = rxt_rates(:ncol,:,   512)*sol(:ncol,:,   266)*sol(:ncol,:,   147)                            ! rate_const*ISOPED4O2*NO
      rxt_rates(:ncol,:,   513) = rxt_rates(:ncol,:,   513)*sol(:ncol,:,   266)*sol(:ncol,:,   147)                            ! rate_const*ISOPED4O2*NO
      rxt_rates(:ncol,:,   514) = rxt_rates(:ncol,:,   514)*sol(:ncol,:,   267)*sol(:ncol,:,   147)                            ! rate_const*ISOPN1DO2*NO
      rxt_rates(:ncol,:,   515) = rxt_rates(:ncol,:,   515)*sol(:ncol,:,   267)*sol(:ncol,:,   147)                            ! rate_const*ISOPN1DO2*NO
      rxt_rates(:ncol,:,   516) = rxt_rates(:ncol,:,   516)*sol(:ncol,:,   268)*sol(:ncol,:,   147)                            ! rate_const*ISOPN2BO2*NO
      rxt_rates(:ncol,:,   517) = rxt_rates(:ncol,:,   517)*sol(:ncol,:,   268)*sol(:ncol,:,   147)                            ! rate_const*ISOPN2BO2*NO
      rxt_rates(:ncol,:,   518) = rxt_rates(:ncol,:,   518)*sol(:ncol,:,   269)*sol(:ncol,:,   147)                            ! rate_const*ISOPN3BO2*NO
      rxt_rates(:ncol,:,   519) = rxt_rates(:ncol,:,   519)*sol(:ncol,:,   269)*sol(:ncol,:,   147)                            ! rate_const*ISOPN3BO2*NO
      rxt_rates(:ncol,:,   520) = rxt_rates(:ncol,:,   520)*sol(:ncol,:,   270)*sol(:ncol,:,   147)                            ! rate_const*ISOPN4DO2*NO
      rxt_rates(:ncol,:,   521) = rxt_rates(:ncol,:,   521)*sol(:ncol,:,   270)*sol(:ncol,:,   147)                            ! rate_const*ISOPN4DO2*NO
      rxt_rates(:ncol,:,   522) = rxt_rates(:ncol,:,   522)*sol(:ncol,:,   271)*sol(:ncol,:,   147)                            ! rate_const*ISOPNBNO3O2*NO
      rxt_rates(:ncol,:,   523) = rxt_rates(:ncol,:,   523)*sol(:ncol,:,   271)*sol(:ncol,:,   147)                            ! rate_const*ISOPNBNO3O2*NO
      rxt_rates(:ncol,:,   524) = rxt_rates(:ncol,:,   524)*sol(:ncol,:,   272)*sol(:ncol,:,   147)                            ! rate_const*ISOPNO3*NO
      rxt_rates(:ncol,:,   525) = rxt_rates(:ncol,:,   525)*sol(:ncol,:,   272)*sol(:ncol,:,   147)                            ! rate_const*ISOPNO3*NO
      rxt_rates(:ncol,:,   526) = rxt_rates(:ncol,:,   526)*sol(:ncol,:,   273)*sol(:ncol,:,   147)                            ! rate_const*ISOPNOOHBO2*NO
      rxt_rates(:ncol,:,   527) = rxt_rates(:ncol,:,   527)*sol(:ncol,:,   273)*sol(:ncol,:,   147)                            ! rate_const*ISOPNOOHBO2*NO
      rxt_rates(:ncol,:,   528) = rxt_rates(:ncol,:,   528)*sol(:ncol,:,   274)*sol(:ncol,:,   147)                            ! rate_const*ISOPNOOHDO2*NO
      rxt_rates(:ncol,:,   529) = rxt_rates(:ncol,:,   529)*sol(:ncol,:,   274)*sol(:ncol,:,   147)                            ! rate_const*ISOPNOOHDO2*NO
      rxt_rates(:ncol,:,   530) = rxt_rates(:ncol,:,   530)*sol(:ncol,:,   276)                                                ! rate_const*ISOPZD1O2
      rxt_rates(:ncol,:,   531) = rxt_rates(:ncol,:,   531)*sol(:ncol,:,   276)*sol(:ncol,:,   147)                            ! rate_const*ISOPZD1O2*NO
      rxt_rates(:ncol,:,   532) = rxt_rates(:ncol,:,   532)*sol(:ncol,:,   276)*sol(:ncol,:,   147)                            ! rate_const*ISOPZD1O2*NO
      rxt_rates(:ncol,:,   533) = rxt_rates(:ncol,:,   533)*sol(:ncol,:,   277)                                                ! rate_const*ISOPZD4O2
      rxt_rates(:ncol,:,   534) = rxt_rates(:ncol,:,   534)*sol(:ncol,:,   277)*sol(:ncol,:,   147)                            ! rate_const*ISOPZD4O2*NO
      rxt_rates(:ncol,:,   535) = rxt_rates(:ncol,:,   535)*sol(:ncol,:,   277)*sol(:ncol,:,   147)                            ! rate_const*ISOPZD4O2*NO
      rxt_rates(:ncol,:,   536) = rxt_rates(:ncol,:,   536)*sol(:ncol,:,   282)*sol(:ncol,:,   147)                            ! rate_const*MACRO2*NO
      rxt_rates(:ncol,:,   537) = rxt_rates(:ncol,:,   537)*sol(:ncol,:,   282)*sol(:ncol,:,   147)                            ! rate_const*MACRO2*NO
      rxt_rates(:ncol,:,   538) = rxt_rates(:ncol,:,   538)*sol(:ncol,:,   287)*sol(:ncol,:,   147)                            ! rate_const*MVKO2*NO
      rxt_rates(:ncol,:,   539) = rxt_rates(:ncol,:,   539)*sol(:ncol,:,   287)*sol(:ncol,:,   147)                            ! rate_const*MVKO2*NO
      rxt_rates(:ncol,:,   540) = rxt_rates(:ncol,:,   540)*sol(:ncol,:,   291)*sol(:ncol,:,   147)                            ! rate_const*NC4CHOO2*NO
      rxt_rates(:ncol,:,   541) = rxt_rates(:ncol,:,   541)*sol(:ncol,:,   291)*sol(:ncol,:,   147)                            ! rate_const*NC4CHOO2*NO
      rxt_rates(:ncol,:,   542) = rxt_rates(:ncol,:,   542)*sol(:ncol,:,   233)*sol(:ncol,:,   256)                            ! rate_const*ACBZO2*HO2
      rxt_rates(:ncol,:,   543) = rxt_rates(:ncol,:,   543)*sol(:ncol,:,   233)*sol(:ncol,:,   147)                            ! rate_const*ACBZO2*NO
      rxt_rates(:ncol,:,   544) = rxt_rates(:ncol,:,   544)*sol(:ncol,:,     8)*sol(:ncol,:,   293)                            ! rate_const*BENZENE*OH
      rxt_rates(:ncol,:,   545) = rxt_rates(:ncol,:,   545)*sol(:ncol,:,   241)*sol(:ncol,:,   256)                            ! rate_const*BENZO2*HO2
      rxt_rates(:ncol,:,   546) = rxt_rates(:ncol,:,   546)*sol(:ncol,:,   241)*sol(:ncol,:,   147)                            ! rate_const*BENZO2*NO
      rxt_rates(:ncol,:,   547) = rxt_rates(:ncol,:,   547)*sol(:ncol,:,     9)*sol(:ncol,:,   293)                            ! rate_const*BENZOOH*OH
      rxt_rates(:ncol,:,   548) = rxt_rates(:ncol,:,   548)*sol(:ncol,:,    23)*sol(:ncol,:,   293)                            ! rate_const*BZALD*OH
      rxt_rates(:ncol,:,   549) = rxt_rates(:ncol,:,   549)*sol(:ncol,:,   246)*sol(:ncol,:,   256)                            ! rate_const*BZOO*HO2
      rxt_rates(:ncol,:,   550) = rxt_rates(:ncol,:,   550)*sol(:ncol,:,    24)*sol(:ncol,:,   293)                            ! rate_const*BZOOH*OH
      rxt_rates(:ncol,:,   551) = rxt_rates(:ncol,:,   551)*sol(:ncol,:,   246)*sol(:ncol,:,   147)                            ! rate_const*BZOO*NO
      rxt_rates(:ncol,:,   552) = rxt_rates(:ncol,:,   552)*sol(:ncol,:,   249)*sol(:ncol,:,   256)                            ! rate_const*C6H5O2*HO2
      rxt_rates(:ncol,:,   553) = rxt_rates(:ncol,:,   553)*sol(:ncol,:,   249)*sol(:ncol,:,   147)                            ! rate_const*C6H5O2*NO
      rxt_rates(:ncol,:,   554) = rxt_rates(:ncol,:,   554)*sol(:ncol,:,    33)*sol(:ncol,:,   293)                            ! rate_const*C6H5OOH*OH
      rxt_rates(:ncol,:,   555) = rxt_rates(:ncol,:,   555)*sol(:ncol,:,    67)*sol(:ncol,:,   293)                            ! rate_const*CRESOL*OH
      rxt_rates(:ncol,:,   556) = rxt_rates(:ncol,:,   556)*sol(:ncol,:,   252)*sol(:ncol,:,   256)                            ! rate_const*DICARBO2*HO2
      rxt_rates(:ncol,:,   557) = rxt_rates(:ncol,:,   557)*sol(:ncol,:,   252)*sol(:ncol,:,   147)                            ! rate_const*DICARBO2*NO
      rxt_rates(:ncol,:,   558) = rxt_rates(:ncol,:,   558)*sol(:ncol,:,   252)*sol(:ncol,:,   148)                            ! rate_const*M*DICARBO2*NO2
      rxt_rates(:ncol,:,   559) = rxt_rates(:ncol,:,   559)*sol(:ncol,:,   283)*sol(:ncol,:,   256)                            ! rate_const*MALO2*HO2
      rxt_rates(:ncol,:,   560) = rxt_rates(:ncol,:,   560)*sol(:ncol,:,   283)*sol(:ncol,:,   147)                            ! rate_const*MALO2*NO
      rxt_rates(:ncol,:,   561) = rxt_rates(:ncol,:,   561)*sol(:ncol,:,   283)*sol(:ncol,:,   148)                            ! rate_const*M*MALO2*NO2
      rxt_rates(:ncol,:,   562) = rxt_rates(:ncol,:,   562)*sol(:ncol,:,   285)*sol(:ncol,:,   256)                            ! rate_const*MDIALO2*HO2
      rxt_rates(:ncol,:,   563) = rxt_rates(:ncol,:,   563)*sol(:ncol,:,   285)*sol(:ncol,:,   147)                            ! rate_const*MDIALO2*NO
      rxt_rates(:ncol,:,   564) = rxt_rates(:ncol,:,   564)*sol(:ncol,:,   285)*sol(:ncol,:,   148)                            ! rate_const*M*MDIALO2*NO2
      rxt_rates(:ncol,:,   565) = rxt_rates(:ncol,:,   565)*sol(:ncol,:,   294)*sol(:ncol,:,   256)                            ! rate_const*PHENO2*HO2
      rxt_rates(:ncol,:,   566) = rxt_rates(:ncol,:,   566)*sol(:ncol,:,   294)*sol(:ncol,:,   147)                            ! rate_const*PHENO2*NO
      rxt_rates(:ncol,:,   567) = rxt_rates(:ncol,:,   567)*sol(:ncol,:,   165)*sol(:ncol,:,   293)                            ! rate_const*PHENOL*OH
      rxt_rates(:ncol,:,   568) = rxt_rates(:ncol,:,   568)*sol(:ncol,:,   164)*sol(:ncol,:,   148)                            ! rate_const*PHENO*NO2
      rxt_rates(:ncol,:,   569) = rxt_rates(:ncol,:,   569)*sol(:ncol,:,   164)*sol(:ncol,:,   157)                            ! rate_const*PHENO*O3
      rxt_rates(:ncol,:,   570) = rxt_rates(:ncol,:,   570)*sol(:ncol,:,   166)*sol(:ncol,:,   293)                            ! rate_const*PHENOOH*OH
      rxt_rates(:ncol,:,   571) = rxt_rates(:ncol,:,   571)*sol(:ncol,:,   233)*sol(:ncol,:,   148)                            ! rate_const*M*ACBZO2*NO2
      rxt_rates(:ncol,:,   572) = rxt_rates(:ncol,:,   572)*sol(:ncol,:,   312)*sol(:ncol,:,   256)                            ! rate_const*TOLO2*HO2
      rxt_rates(:ncol,:,   573) = rxt_rates(:ncol,:,   573)*sol(:ncol,:,   312)*sol(:ncol,:,   147)                            ! rate_const*TOLO2*NO
      rxt_rates(:ncol,:,   574) = rxt_rates(:ncol,:,   574)*sol(:ncol,:,   225)*sol(:ncol,:,   293)                            ! rate_const*TOLOOH*OH
      rxt_rates(:ncol,:,   575) = rxt_rates(:ncol,:,   575)*sol(:ncol,:,   226)*sol(:ncol,:,   293)                            ! rate_const*TOLUENE*OH
      rxt_rates(:ncol,:,   576) = rxt_rates(:ncol,:,   576)*sol(:ncol,:,   163)                                                ! rate_const*M*PBZNIT
      rxt_rates(:ncol,:,   577) = rxt_rates(:ncol,:,   577)*sol(:ncol,:,   227)*sol(:ncol,:,   293)                            ! rate_const*XYLENES*OH
      rxt_rates(:ncol,:,   578) = rxt_rates(:ncol,:,   578)*sol(:ncol,:,   314)*sol(:ncol,:,   256)                            ! rate_const*XYLENO2*HO2
      rxt_rates(:ncol,:,   579) = rxt_rates(:ncol,:,   579)*sol(:ncol,:,   314)*sol(:ncol,:,   147)                            ! rate_const*XYLENO2*NO
      rxt_rates(:ncol,:,   580) = rxt_rates(:ncol,:,   580)*sol(:ncol,:,   228)*sol(:ncol,:,   293)                            ! rate_const*XYLENOOH*OH
      rxt_rates(:ncol,:,   581) = rxt_rates(:ncol,:,   581)*sol(:ncol,:,   316)*sol(:ncol,:,   256)                            ! rate_const*XYLOLO2*HO2
      rxt_rates(:ncol,:,   582) = rxt_rates(:ncol,:,   582)*sol(:ncol,:,   316)*sol(:ncol,:,   147)                            ! rate_const*XYLOLO2*NO
      rxt_rates(:ncol,:,   583) = rxt_rates(:ncol,:,   583)*sol(:ncol,:,   229)*sol(:ncol,:,   293)                            ! rate_const*XYLOL*OH
      rxt_rates(:ncol,:,   584) = rxt_rates(:ncol,:,   584)*sol(:ncol,:,   230)*sol(:ncol,:,   293)                            ! rate_const*XYLOLOOH*OH
      rxt_rates(:ncol,:,   585) = rxt_rates(:ncol,:,   585)*sol(:ncol,:,     4)*sol(:ncol,:,   149)                            ! rate_const*APIN*NO3
      rxt_rates(:ncol,:,   586) = rxt_rates(:ncol,:,   586)*sol(:ncol,:,   235)*sol(:ncol,:,   235)                            ! rate_const*APINNO3*APINNO3
      rxt_rates(:ncol,:,   587) = rxt_rates(:ncol,:,   587)*sol(:ncol,:,   235)*sol(:ncol,:,   250)                            ! rate_const*APINNO3*CH3CO3
      rxt_rates(:ncol,:,   588) = rxt_rates(:ncol,:,   588)*sol(:ncol,:,   235)*sol(:ncol,:,   251)                            ! rate_const*APINNO3*CH3O2
      rxt_rates(:ncol,:,   589) = rxt_rates(:ncol,:,   589)*sol(:ncol,:,   235)*sol(:ncol,:,   256)                            ! rate_const*APINNO3*HO2
      rxt_rates(:ncol,:,   590) = rxt_rates(:ncol,:,   590)*sol(:ncol,:,   235)*sol(:ncol,:,   147)                            ! rate_const*APINNO3*NO
      rxt_rates(:ncol,:,   591) = rxt_rates(:ncol,:,   591)*sol(:ncol,:,   235)*sol(:ncol,:,   149)                            ! rate_const*APINNO3*NO3
      rxt_rates(:ncol,:,   592) = rxt_rates(:ncol,:,   592)*sol(:ncol,:,   235)*sol(:ncol,:,   300)                            ! rate_const*APINNO3*TERPA2CO3
      rxt_rates(:ncol,:,   593) = rxt_rates(:ncol,:,   593)*sol(:ncol,:,   235)*sol(:ncol,:,   302)                            ! rate_const*APINNO3*TERPA3CO3
      rxt_rates(:ncol,:,   594) = rxt_rates(:ncol,:,   594)*sol(:ncol,:,   235)*sol(:ncol,:,   305)                            ! rate_const*APINNO3*TERPACO3
      rxt_rates(:ncol,:,   595) = rxt_rates(:ncol,:,   595)*sol(:ncol,:,   236)*sol(:ncol,:,   250)                            ! rate_const*APINO2*CH3CO3
      rxt_rates(:ncol,:,   596) = rxt_rates(:ncol,:,   596)*sol(:ncol,:,   236)*sol(:ncol,:,   251)                            ! rate_const*APINO2*CH3O2
      rxt_rates(:ncol,:,   597) = rxt_rates(:ncol,:,   597)*sol(:ncol,:,   236)*sol(:ncol,:,   256)                            ! rate_const*APINO2*HO2
      rxt_rates(:ncol,:,   598) = rxt_rates(:ncol,:,   598)*sol(:ncol,:,   236)*sol(:ncol,:,   147)                            ! rate_const*APINO2*NO
      rxt_rates(:ncol,:,   599) = rxt_rates(:ncol,:,   599)*sol(:ncol,:,   236)*sol(:ncol,:,   149)                            ! rate_const*APINO2*NO3
      rxt_rates(:ncol,:,   600) = rxt_rates(:ncol,:,   600)*sol(:ncol,:,   236)*sol(:ncol,:,   300)                            ! rate_const*APINO2*TERPA2CO3
      rxt_rates(:ncol,:,   601) = rxt_rates(:ncol,:,   601)*sol(:ncol,:,   236)*sol(:ncol,:,   302)                            ! rate_const*APINO2*TERPA3CO3
      rxt_rates(:ncol,:,   602) = rxt_rates(:ncol,:,   602)*sol(:ncol,:,   236)*sol(:ncol,:,   305)                            ! rate_const*APINO2*TERPACO3
      rxt_rates(:ncol,:,   603) = rxt_rates(:ncol,:,   603)*sol(:ncol,:,     4)*sol(:ncol,:,   157)                            ! rate_const*APIN*O3
      rxt_rates(:ncol,:,   604) = rxt_rates(:ncol,:,   604)*sol(:ncol,:,     4)*sol(:ncol,:,   293)                            ! rate_const*APIN*OH
      rxt_rates(:ncol,:,   605) = rxt_rates(:ncol,:,   605)*sol(:ncol,:,     7)*sol(:ncol,:,   149)                            ! rate_const*BCARY*NO3
      rxt_rates(:ncol,:,   606) = rxt_rates(:ncol,:,   606)*sol(:ncol,:,   238)*sol(:ncol,:,   238)                            ! rate_const*BCARYNO3*BCARYNO3
      rxt_rates(:ncol,:,   607) = rxt_rates(:ncol,:,   607)*sol(:ncol,:,   238)*sol(:ncol,:,   250)                            ! rate_const*BCARYNO3*CH3CO3
      rxt_rates(:ncol,:,   608) = rxt_rates(:ncol,:,   608)*sol(:ncol,:,   238)*sol(:ncol,:,   251)                            ! rate_const*BCARYNO3*CH3O2
      rxt_rates(:ncol,:,   609) = rxt_rates(:ncol,:,   609)*sol(:ncol,:,   238)*sol(:ncol,:,   256)                            ! rate_const*BCARYNO3*HO2
      rxt_rates(:ncol,:,   610) = rxt_rates(:ncol,:,   610)*sol(:ncol,:,   238)*sol(:ncol,:,   147)                            ! rate_const*BCARYNO3*NO
      rxt_rates(:ncol,:,   611) = rxt_rates(:ncol,:,   611)*sol(:ncol,:,   238)*sol(:ncol,:,   149)                            ! rate_const*BCARYNO3*NO3
      rxt_rates(:ncol,:,   612) = rxt_rates(:ncol,:,   612)*sol(:ncol,:,   238)*sol(:ncol,:,   300)                            ! rate_const*BCARYNO3*TERPA2CO3
      rxt_rates(:ncol,:,   613) = rxt_rates(:ncol,:,   613)*sol(:ncol,:,   238)*sol(:ncol,:,   302)                            ! rate_const*BCARYNO3*TERPA3CO3
      rxt_rates(:ncol,:,   614) = rxt_rates(:ncol,:,   614)*sol(:ncol,:,   238)*sol(:ncol,:,   305)                            ! rate_const*BCARYNO3*TERPACO3
      rxt_rates(:ncol,:,   615) = rxt_rates(:ncol,:,   615)*sol(:ncol,:,   239)*sol(:ncol,:,   250)                            ! rate_const*BCARYO2*CH3CO3
      rxt_rates(:ncol,:,   616) = rxt_rates(:ncol,:,   616)*sol(:ncol,:,   239)*sol(:ncol,:,   251)                            ! rate_const*BCARYO2*CH3O2
      rxt_rates(:ncol,:,   617) = rxt_rates(:ncol,:,   617)*sol(:ncol,:,   239)*sol(:ncol,:,   256)                            ! rate_const*BCARYO2*HO2
      rxt_rates(:ncol,:,   618) = rxt_rates(:ncol,:,   618)*sol(:ncol,:,   239)*sol(:ncol,:,   147)                            ! rate_const*BCARYO2*NO
      rxt_rates(:ncol,:,   619) = rxt_rates(:ncol,:,   619)*sol(:ncol,:,   239)*sol(:ncol,:,   149)                            ! rate_const*BCARYO2*NO3
      rxt_rates(:ncol,:,   620) = rxt_rates(:ncol,:,   620)*sol(:ncol,:,   239)*sol(:ncol,:,   300)                            ! rate_const*BCARYO2*TERPA2CO3
      rxt_rates(:ncol,:,   621) = rxt_rates(:ncol,:,   621)*sol(:ncol,:,   239)*sol(:ncol,:,   302)                            ! rate_const*BCARYO2*TERPA3CO3
      rxt_rates(:ncol,:,   622) = rxt_rates(:ncol,:,   622)*sol(:ncol,:,   239)*sol(:ncol,:,   305)                            ! rate_const*BCARYO2*TERPACO3
      rxt_rates(:ncol,:,   623) = rxt_rates(:ncol,:,   623)*sol(:ncol,:,     7)*sol(:ncol,:,   157)                            ! rate_const*BCARY*O3
      rxt_rates(:ncol,:,   624) = rxt_rates(:ncol,:,   624)*sol(:ncol,:,     7)*sol(:ncol,:,   293)                            ! rate_const*BCARY*OH
      rxt_rates(:ncol,:,   625) = rxt_rates(:ncol,:,   625)*sol(:ncol,:,    17)*sol(:ncol,:,   149)                            ! rate_const*BPIN*NO3
      rxt_rates(:ncol,:,   626) = rxt_rates(:ncol,:,   626)*sol(:ncol,:,   243)*sol(:ncol,:,   243)                            ! rate_const*BPINNO3*BPINNO3
      rxt_rates(:ncol,:,   627) = rxt_rates(:ncol,:,   627)*sol(:ncol,:,   243)*sol(:ncol,:,   250)                            ! rate_const*BPINNO3*CH3CO3
      rxt_rates(:ncol,:,   628) = rxt_rates(:ncol,:,   628)*sol(:ncol,:,   243)*sol(:ncol,:,   251)                            ! rate_const*BPINNO3*CH3O2
      rxt_rates(:ncol,:,   629) = rxt_rates(:ncol,:,   629)*sol(:ncol,:,   243)*sol(:ncol,:,   256)                            ! rate_const*BPINNO3*HO2
      rxt_rates(:ncol,:,   630) = rxt_rates(:ncol,:,   630)*sol(:ncol,:,   243)*sol(:ncol,:,   147)                            ! rate_const*BPINNO3*NO
      rxt_rates(:ncol,:,   631) = rxt_rates(:ncol,:,   631)*sol(:ncol,:,   243)*sol(:ncol,:,   149)                            ! rate_const*BPINNO3*NO3
      rxt_rates(:ncol,:,   632) = rxt_rates(:ncol,:,   632)*sol(:ncol,:,   243)*sol(:ncol,:,   300)                            ! rate_const*BPINNO3*TERPA2CO3
      rxt_rates(:ncol,:,   633) = rxt_rates(:ncol,:,   633)*sol(:ncol,:,   243)*sol(:ncol,:,   302)                            ! rate_const*BPINNO3*TERPA3CO3
      rxt_rates(:ncol,:,   634) = rxt_rates(:ncol,:,   634)*sol(:ncol,:,   243)*sol(:ncol,:,   305)                            ! rate_const*BPINNO3*TERPACO3
      rxt_rates(:ncol,:,   635) = rxt_rates(:ncol,:,   635)*sol(:ncol,:,   244)*sol(:ncol,:,   250)                            ! rate_const*BPINO2*CH3CO3
      rxt_rates(:ncol,:,   636) = rxt_rates(:ncol,:,   636)*sol(:ncol,:,   244)*sol(:ncol,:,   251)                            ! rate_const*BPINO2*CH3O2
      rxt_rates(:ncol,:,   637) = rxt_rates(:ncol,:,   637)*sol(:ncol,:,   244)*sol(:ncol,:,   256)                            ! rate_const*BPINO2*HO2
      rxt_rates(:ncol,:,   638) = rxt_rates(:ncol,:,   638)*sol(:ncol,:,   244)*sol(:ncol,:,   147)                            ! rate_const*BPINO2*NO
      rxt_rates(:ncol,:,   639) = rxt_rates(:ncol,:,   639)*sol(:ncol,:,   244)*sol(:ncol,:,   149)                            ! rate_const*BPINO2*NO3
      rxt_rates(:ncol,:,   640) = rxt_rates(:ncol,:,   640)*sol(:ncol,:,   244)*sol(:ncol,:,   300)                            ! rate_const*BPINO2*TERPA2CO3
      rxt_rates(:ncol,:,   641) = rxt_rates(:ncol,:,   641)*sol(:ncol,:,   244)*sol(:ncol,:,   302)                            ! rate_const*BPINO2*TERPA3CO3
      rxt_rates(:ncol,:,   642) = rxt_rates(:ncol,:,   642)*sol(:ncol,:,   244)*sol(:ncol,:,   305)                            ! rate_const*BPINO2*TERPACO3
      rxt_rates(:ncol,:,   643) = rxt_rates(:ncol,:,   643)*sol(:ncol,:,    17)*sol(:ncol,:,   157)                            ! rate_const*BPIN*O3
      rxt_rates(:ncol,:,   644) = rxt_rates(:ncol,:,   644)*sol(:ncol,:,    17)*sol(:ncol,:,   293)                            ! rate_const*BPIN*OH
      rxt_rates(:ncol,:,   645) = rxt_rates(:ncol,:,   645)*sol(:ncol,:,   125)*sol(:ncol,:,   149)                            ! rate_const*LIMON*NO3
      rxt_rates(:ncol,:,   646) = rxt_rates(:ncol,:,   646)*sol(:ncol,:,   279)*sol(:ncol,:,   250)                            ! rate_const*LIMONNO3*CH3CO3
      rxt_rates(:ncol,:,   647) = rxt_rates(:ncol,:,   647)*sol(:ncol,:,   279)*sol(:ncol,:,   251)                            ! rate_const*LIMONNO3*CH3O2
      rxt_rates(:ncol,:,   648) = rxt_rates(:ncol,:,   648)*sol(:ncol,:,   279)*sol(:ncol,:,   256)                            ! rate_const*LIMONNO3*HO2
      rxt_rates(:ncol,:,   649) = rxt_rates(:ncol,:,   649)*sol(:ncol,:,   279)*sol(:ncol,:,   279)                            ! rate_const*LIMONNO3*LIMONNO3
      rxt_rates(:ncol,:,   650) = rxt_rates(:ncol,:,   650)*sol(:ncol,:,   279)*sol(:ncol,:,   147)                            ! rate_const*LIMONNO3*NO
      rxt_rates(:ncol,:,   651) = rxt_rates(:ncol,:,   651)*sol(:ncol,:,   279)*sol(:ncol,:,   149)                            ! rate_const*LIMONNO3*NO3
      rxt_rates(:ncol,:,   652) = rxt_rates(:ncol,:,   652)*sol(:ncol,:,   279)*sol(:ncol,:,   300)                            ! rate_const*LIMONNO3*TERPA2CO3
      rxt_rates(:ncol,:,   653) = rxt_rates(:ncol,:,   653)*sol(:ncol,:,   279)*sol(:ncol,:,   302)                            ! rate_const*LIMONNO3*TERPA3CO3
      rxt_rates(:ncol,:,   654) = rxt_rates(:ncol,:,   654)*sol(:ncol,:,   279)*sol(:ncol,:,   305)                            ! rate_const*LIMONNO3*TERPACO3
      rxt_rates(:ncol,:,   655) = rxt_rates(:ncol,:,   655)*sol(:ncol,:,   280)*sol(:ncol,:,   250)                            ! rate_const*LIMONO2*CH3CO3
      rxt_rates(:ncol,:,   656) = rxt_rates(:ncol,:,   656)*sol(:ncol,:,   280)*sol(:ncol,:,   251)                            ! rate_const*LIMONO2*CH3O2
      rxt_rates(:ncol,:,   657) = rxt_rates(:ncol,:,   657)*sol(:ncol,:,   280)*sol(:ncol,:,   256)                            ! rate_const*LIMONO2*HO2
      rxt_rates(:ncol,:,   658) = rxt_rates(:ncol,:,   658)*sol(:ncol,:,   280)*sol(:ncol,:,   147)                            ! rate_const*LIMONO2*NO
      rxt_rates(:ncol,:,   659) = rxt_rates(:ncol,:,   659)*sol(:ncol,:,   280)*sol(:ncol,:,   149)                            ! rate_const*LIMONO2*NO3
      rxt_rates(:ncol,:,   660) = rxt_rates(:ncol,:,   660)*sol(:ncol,:,   280)*sol(:ncol,:,   300)                            ! rate_const*LIMONO2*TERPA2CO3
      rxt_rates(:ncol,:,   661) = rxt_rates(:ncol,:,   661)*sol(:ncol,:,   280)*sol(:ncol,:,   302)                            ! rate_const*LIMONO2*TERPA3CO3
      rxt_rates(:ncol,:,   662) = rxt_rates(:ncol,:,   662)*sol(:ncol,:,   280)*sol(:ncol,:,   305)                            ! rate_const*LIMONO2*TERPACO3
      rxt_rates(:ncol,:,   663) = rxt_rates(:ncol,:,   663)*sol(:ncol,:,   125)*sol(:ncol,:,   157)                            ! rate_const*LIMON*O3
      rxt_rates(:ncol,:,   664) = rxt_rates(:ncol,:,   664)*sol(:ncol,:,   125)*sol(:ncol,:,   293)                            ! rate_const*LIMON*OH
      rxt_rates(:ncol,:,   665) = rxt_rates(:ncol,:,   665)*sol(:ncol,:,   135)*sol(:ncol,:,   149)                            ! rate_const*MYRC*NO3
      rxt_rates(:ncol,:,   666) = rxt_rates(:ncol,:,   666)*sol(:ncol,:,   288)*sol(:ncol,:,   250)                            ! rate_const*MYRCNO3*CH3CO3
      rxt_rates(:ncol,:,   667) = rxt_rates(:ncol,:,   667)*sol(:ncol,:,   288)*sol(:ncol,:,   251)                            ! rate_const*MYRCNO3*CH3O2
      rxt_rates(:ncol,:,   668) = rxt_rates(:ncol,:,   668)*sol(:ncol,:,   288)*sol(:ncol,:,   256)                            ! rate_const*MYRCNO3*HO2
      rxt_rates(:ncol,:,   669) = rxt_rates(:ncol,:,   669)*sol(:ncol,:,   288)*sol(:ncol,:,   288)                            ! rate_const*MYRCNO3*MYRCNO3
      rxt_rates(:ncol,:,   670) = rxt_rates(:ncol,:,   670)*sol(:ncol,:,   288)*sol(:ncol,:,   147)                            ! rate_const*MYRCNO3*NO
      rxt_rates(:ncol,:,   671) = rxt_rates(:ncol,:,   671)*sol(:ncol,:,   288)*sol(:ncol,:,   149)                            ! rate_const*MYRCNO3*NO3
      rxt_rates(:ncol,:,   672) = rxt_rates(:ncol,:,   672)*sol(:ncol,:,   288)*sol(:ncol,:,   300)                            ! rate_const*MYRCNO3*TERPA2CO3
      rxt_rates(:ncol,:,   673) = rxt_rates(:ncol,:,   673)*sol(:ncol,:,   288)*sol(:ncol,:,   302)                            ! rate_const*MYRCNO3*TERPA3CO3
      rxt_rates(:ncol,:,   674) = rxt_rates(:ncol,:,   674)*sol(:ncol,:,   288)*sol(:ncol,:,   305)                            ! rate_const*MYRCNO3*TERPACO3
      rxt_rates(:ncol,:,   675) = rxt_rates(:ncol,:,   675)*sol(:ncol,:,   289)*sol(:ncol,:,   250)                            ! rate_const*MYRCO2*CH3CO3
      rxt_rates(:ncol,:,   676) = rxt_rates(:ncol,:,   676)*sol(:ncol,:,   289)*sol(:ncol,:,   251)                            ! rate_const*MYRCO2*CH3O2
      rxt_rates(:ncol,:,   677) = rxt_rates(:ncol,:,   677)*sol(:ncol,:,   289)*sol(:ncol,:,   256)                            ! rate_const*MYRCO2*HO2
      rxt_rates(:ncol,:,   678) = rxt_rates(:ncol,:,   678)*sol(:ncol,:,   289)*sol(:ncol,:,   147)                            ! rate_const*MYRCO2*NO
      rxt_rates(:ncol,:,   679) = rxt_rates(:ncol,:,   679)*sol(:ncol,:,   289)*sol(:ncol,:,   149)                            ! rate_const*MYRCO2*NO3
      rxt_rates(:ncol,:,   680) = rxt_rates(:ncol,:,   680)*sol(:ncol,:,   289)*sol(:ncol,:,   300)                            ! rate_const*MYRCO2*TERPA2CO3
      rxt_rates(:ncol,:,   681) = rxt_rates(:ncol,:,   681)*sol(:ncol,:,   289)*sol(:ncol,:,   302)                            ! rate_const*MYRCO2*TERPA3CO3
      rxt_rates(:ncol,:,   682) = rxt_rates(:ncol,:,   682)*sol(:ncol,:,   289)*sol(:ncol,:,   305)                            ! rate_const*MYRCO2*TERPACO3
      rxt_rates(:ncol,:,   683) = rxt_rates(:ncol,:,   683)*sol(:ncol,:,   135)*sol(:ncol,:,   157)                            ! rate_const*MYRC*O3
      rxt_rates(:ncol,:,   684) = rxt_rates(:ncol,:,   684)*sol(:ncol,:,   135)*sol(:ncol,:,   293)                            ! rate_const*MYRC*OH
      rxt_rates(:ncol,:,   685) = rxt_rates(:ncol,:,   685)*sol(:ncol,:,   300)*sol(:ncol,:,   148)                            ! rate_const*M*TERPA2CO3*NO2
      rxt_rates(:ncol,:,   686) = rxt_rates(:ncol,:,   686)*sol(:ncol,:,   302)*sol(:ncol,:,   148)                            ! rate_const*M*TERPA3CO3*NO2
      rxt_rates(:ncol,:,   687) = rxt_rates(:ncol,:,   687)*sol(:ncol,:,   305)*sol(:ncol,:,   148)                            ! rate_const*M*TERPACO3*NO2
      rxt_rates(:ncol,:,   688) = rxt_rates(:ncol,:,   688)*sol(:ncol,:,   297)*sol(:ncol,:,   256)                            ! rate_const*TERP1OOHO2*HO2
      rxt_rates(:ncol,:,   689) = rxt_rates(:ncol,:,   689)*sol(:ncol,:,   297)*sol(:ncol,:,   147)                            ! rate_const*TERP1OOHO2*NO
      rxt_rates(:ncol,:,   690) = rxt_rates(:ncol,:,   690)*sol(:ncol,:,   198)*sol(:ncol,:,   293)                            ! rate_const*TERP1OOH*OH
      rxt_rates(:ncol,:,   691) = rxt_rates(:ncol,:,   691)*sol(:ncol,:,   199)*sol(:ncol,:,   293)                            ! rate_const*TERP2AOOH*OH
      rxt_rates(:ncol,:,   692) = rxt_rates(:ncol,:,   692)*sol(:ncol,:,   298)*sol(:ncol,:,   256)                            ! rate_const*TERP2OOHO2*HO2
      rxt_rates(:ncol,:,   693) = rxt_rates(:ncol,:,   693)*sol(:ncol,:,   298)*sol(:ncol,:,   147)                            ! rate_const*TERP2OOHO2*NO
      rxt_rates(:ncol,:,   694) = rxt_rates(:ncol,:,   694)*sol(:ncol,:,   299)*sol(:ncol,:,   250)                            ! rate_const*TERPA1O2*CH3CO3
      rxt_rates(:ncol,:,   695) = rxt_rates(:ncol,:,   695)*sol(:ncol,:,   299)*sol(:ncol,:,   251)                            ! rate_const*TERPA1O2*CH3O2
      rxt_rates(:ncol,:,   696) = rxt_rates(:ncol,:,   696)*sol(:ncol,:,   299)*sol(:ncol,:,   256)                            ! rate_const*TERPA1O2*HO2
      rxt_rates(:ncol,:,   697) = rxt_rates(:ncol,:,   697)*sol(:ncol,:,   299)*sol(:ncol,:,   147)                            ! rate_const*TERPA1O2*NO
      rxt_rates(:ncol,:,   698) = rxt_rates(:ncol,:,   698)*sol(:ncol,:,   299)*sol(:ncol,:,   149)                            ! rate_const*TERPA1O2*NO3
      rxt_rates(:ncol,:,   699) = rxt_rates(:ncol,:,   699)*sol(:ncol,:,   299)*sol(:ncol,:,   300)                            ! rate_const*TERPA1O2*TERPA2CO3
      rxt_rates(:ncol,:,   700) = rxt_rates(:ncol,:,   700)*sol(:ncol,:,   299)*sol(:ncol,:,   302)                            ! rate_const*TERPA1O2*TERPA3CO3
      rxt_rates(:ncol,:,   701) = rxt_rates(:ncol,:,   701)*sol(:ncol,:,   299)*sol(:ncol,:,   305)                            ! rate_const*TERPA1O2*TERPACO3
      rxt_rates(:ncol,:,   702) = rxt_rates(:ncol,:,   702)*sol(:ncol,:,   300)*sol(:ncol,:,   250)                            ! rate_const*TERPA2CO3*CH3CO3
      rxt_rates(:ncol,:,   703) = rxt_rates(:ncol,:,   703)*sol(:ncol,:,   300)*sol(:ncol,:,   251)                            ! rate_const*TERPA2CO3*CH3O2
      rxt_rates(:ncol,:,   704) = rxt_rates(:ncol,:,   704)*sol(:ncol,:,   300)*sol(:ncol,:,   256)                            ! rate_const*TERPA2CO3*HO2
      rxt_rates(:ncol,:,   705) = rxt_rates(:ncol,:,   705)*sol(:ncol,:,   300)*sol(:ncol,:,   147)                            ! rate_const*TERPA2CO3*NO
      rxt_rates(:ncol,:,   706) = rxt_rates(:ncol,:,   706)*sol(:ncol,:,   300)*sol(:ncol,:,   149)                            ! rate_const*TERPA2CO3*NO3
      rxt_rates(:ncol,:,   707) = rxt_rates(:ncol,:,   707)*sol(:ncol,:,   300)*sol(:ncol,:,   300)                            ! rate_const*TERPA2CO3*TERPA2CO3
      rxt_rates(:ncol,:,   708) = rxt_rates(:ncol,:,   708)*sol(:ncol,:,   300)*sol(:ncol,:,   305)                            ! rate_const*TERPA2CO3*TERPACO3
      rxt_rates(:ncol,:,   709) = rxt_rates(:ncol,:,   709)*sol(:ncol,:,   201)*sol(:ncol,:,   149)                            ! rate_const*TERPA2*NO3
      rxt_rates(:ncol,:,   710) = rxt_rates(:ncol,:,   710)*sol(:ncol,:,   301)*sol(:ncol,:,   250)                            ! rate_const*TERPA2O2*CH3CO3
      rxt_rates(:ncol,:,   711) = rxt_rates(:ncol,:,   711)*sol(:ncol,:,   301)*sol(:ncol,:,   251)                            ! rate_const*TERPA2O2*CH3O2
      rxt_rates(:ncol,:,   712) = rxt_rates(:ncol,:,   712)*sol(:ncol,:,   301)*sol(:ncol,:,   256)                            ! rate_const*TERPA2O2*HO2
      rxt_rates(:ncol,:,   713) = rxt_rates(:ncol,:,   713)*sol(:ncol,:,   301)*sol(:ncol,:,   147)                            ! rate_const*TERPA2O2*NO
      rxt_rates(:ncol,:,   714) = rxt_rates(:ncol,:,   714)*sol(:ncol,:,   301)*sol(:ncol,:,   149)                            ! rate_const*TERPA2O2*NO3
      rxt_rates(:ncol,:,   715) = rxt_rates(:ncol,:,   715)*sol(:ncol,:,   301)*sol(:ncol,:,   300)                            ! rate_const*TERPA2O2*TERPA2CO3
      rxt_rates(:ncol,:,   716) = rxt_rates(:ncol,:,   716)*sol(:ncol,:,   301)*sol(:ncol,:,   302)                            ! rate_const*TERPA2O2*TERPA3CO3
      rxt_rates(:ncol,:,   717) = rxt_rates(:ncol,:,   717)*sol(:ncol,:,   301)*sol(:ncol,:,   305)                            ! rate_const*TERPA2O2*TERPACO3
      rxt_rates(:ncol,:,   718) = rxt_rates(:ncol,:,   718)*sol(:ncol,:,   201)*sol(:ncol,:,   293)                            ! rate_const*TERPA2*OH
      rxt_rates(:ncol,:,   719) = rxt_rates(:ncol,:,   719)*sol(:ncol,:,   202)*sol(:ncol,:,   293)                            ! rate_const*TERPA2PAN*OH
      rxt_rates(:ncol,:,   720) = rxt_rates(:ncol,:,   720)*sol(:ncol,:,   302)*sol(:ncol,:,   250)                            ! rate_const*TERPA3CO3*CH3CO3
      rxt_rates(:ncol,:,   721) = rxt_rates(:ncol,:,   721)*sol(:ncol,:,   302)*sol(:ncol,:,   251)                            ! rate_const*TERPA3CO3*CH3O2
      rxt_rates(:ncol,:,   722) = rxt_rates(:ncol,:,   722)*sol(:ncol,:,   302)*sol(:ncol,:,   256)                            ! rate_const*TERPA3CO3*HO2
      rxt_rates(:ncol,:,   723) = rxt_rates(:ncol,:,   723)*sol(:ncol,:,   302)*sol(:ncol,:,   147)                            ! rate_const*TERPA3CO3*NO
      rxt_rates(:ncol,:,   724) = rxt_rates(:ncol,:,   724)*sol(:ncol,:,   302)*sol(:ncol,:,   149)                            ! rate_const*TERPA3CO3*NO3
      rxt_rates(:ncol,:,   725) = rxt_rates(:ncol,:,   725)*sol(:ncol,:,   302)*sol(:ncol,:,   300)                            ! rate_const*TERPA3CO3*TERPA2CO3
      rxt_rates(:ncol,:,   726) = rxt_rates(:ncol,:,   726)*sol(:ncol,:,   302)*sol(:ncol,:,   302)                            ! rate_const*TERPA3CO3*TERPA3CO3
      rxt_rates(:ncol,:,   727) = rxt_rates(:ncol,:,   727)*sol(:ncol,:,   302)*sol(:ncol,:,   305)                            ! rate_const*TERPA3CO3*TERPACO3
      rxt_rates(:ncol,:,   728) = rxt_rates(:ncol,:,   728)*sol(:ncol,:,   203)*sol(:ncol,:,   149)                            ! rate_const*TERPA3*NO3
      rxt_rates(:ncol,:,   729) = rxt_rates(:ncol,:,   729)*sol(:ncol,:,   303)*sol(:ncol,:,   250)                            ! rate_const*TERPA3O2*CH3CO3
      rxt_rates(:ncol,:,   730) = rxt_rates(:ncol,:,   730)*sol(:ncol,:,   303)*sol(:ncol,:,   251)                            ! rate_const*TERPA3O2*CH3O2
      rxt_rates(:ncol,:,   731) = rxt_rates(:ncol,:,   731)*sol(:ncol,:,   303)*sol(:ncol,:,   256)                            ! rate_const*TERPA3O2*HO2
      rxt_rates(:ncol,:,   732) = rxt_rates(:ncol,:,   732)*sol(:ncol,:,   303)*sol(:ncol,:,   147)                            ! rate_const*TERPA3O2*NO
      rxt_rates(:ncol,:,   733) = rxt_rates(:ncol,:,   733)*sol(:ncol,:,   303)*sol(:ncol,:,   149)                            ! rate_const*TERPA3O2*NO3
      rxt_rates(:ncol,:,   734) = rxt_rates(:ncol,:,   734)*sol(:ncol,:,   303)*sol(:ncol,:,   300)                            ! rate_const*TERPA3O2*TERPA2CO3
      rxt_rates(:ncol,:,   735) = rxt_rates(:ncol,:,   735)*sol(:ncol,:,   303)*sol(:ncol,:,   302)                            ! rate_const*TERPA3O2*TERPA3CO3
      rxt_rates(:ncol,:,   736) = rxt_rates(:ncol,:,   736)*sol(:ncol,:,   303)*sol(:ncol,:,   305)                            ! rate_const*TERPA3O2*TERPACO3
      rxt_rates(:ncol,:,   737) = rxt_rates(:ncol,:,   737)*sol(:ncol,:,   203)*sol(:ncol,:,   293)                            ! rate_const*TERPA3*OH
      rxt_rates(:ncol,:,   738) = rxt_rates(:ncol,:,   738)*sol(:ncol,:,   204)*sol(:ncol,:,   293)                            ! rate_const*TERPA3PAN*OH
      rxt_rates(:ncol,:,   739) = rxt_rates(:ncol,:,   739)*sol(:ncol,:,   304)*sol(:ncol,:,   250)                            ! rate_const*TERPA4O2*CH3CO3
      rxt_rates(:ncol,:,   740) = rxt_rates(:ncol,:,   740)*sol(:ncol,:,   304)*sol(:ncol,:,   251)                            ! rate_const*TERPA4O2*CH3O2
      rxt_rates(:ncol,:,   741) = rxt_rates(:ncol,:,   741)*sol(:ncol,:,   304)*sol(:ncol,:,   256)                            ! rate_const*TERPA4O2*HO2
      rxt_rates(:ncol,:,   742) = rxt_rates(:ncol,:,   742)*sol(:ncol,:,   304)*sol(:ncol,:,   147)                            ! rate_const*TERPA4O2*NO
      rxt_rates(:ncol,:,   743) = rxt_rates(:ncol,:,   743)*sol(:ncol,:,   304)*sol(:ncol,:,   149)                            ! rate_const*TERPA4O2*NO3
      rxt_rates(:ncol,:,   744) = rxt_rates(:ncol,:,   744)*sol(:ncol,:,   304)*sol(:ncol,:,   300)                            ! rate_const*TERPA4O2*TERPA2CO3
      rxt_rates(:ncol,:,   745) = rxt_rates(:ncol,:,   745)*sol(:ncol,:,   304)*sol(:ncol,:,   302)                            ! rate_const*TERPA4O2*TERPA3CO3
      rxt_rates(:ncol,:,   746) = rxt_rates(:ncol,:,   746)*sol(:ncol,:,   304)*sol(:ncol,:,   305)                            ! rate_const*TERPA4O2*TERPACO3
      rxt_rates(:ncol,:,   747) = rxt_rates(:ncol,:,   747)*sol(:ncol,:,   206)*sol(:ncol,:,   293)                            ! rate_const*TERPACID2*OH
      rxt_rates(:ncol,:,   748) = rxt_rates(:ncol,:,   748)*sol(:ncol,:,   207)*sol(:ncol,:,   293)                            ! rate_const*TERPACID3*OH
      rxt_rates(:ncol,:,   749) = rxt_rates(:ncol,:,   749)*sol(:ncol,:,   205)*sol(:ncol,:,   293)                            ! rate_const*TERPACID*OH
      rxt_rates(:ncol,:,   750) = rxt_rates(:ncol,:,   750)*sol(:ncol,:,   305)*sol(:ncol,:,   250)                            ! rate_const*TERPACO3*CH3CO3
      rxt_rates(:ncol,:,   751) = rxt_rates(:ncol,:,   751)*sol(:ncol,:,   305)*sol(:ncol,:,   251)                            ! rate_const*TERPACO3*CH3O2
      rxt_rates(:ncol,:,   752) = rxt_rates(:ncol,:,   752)*sol(:ncol,:,   305)*sol(:ncol,:,   256)                            ! rate_const*TERPACO3*HO2
      rxt_rates(:ncol,:,   753) = rxt_rates(:ncol,:,   753)*sol(:ncol,:,   305)*sol(:ncol,:,   147)                            ! rate_const*TERPACO3*NO
      rxt_rates(:ncol,:,   754) = rxt_rates(:ncol,:,   754)*sol(:ncol,:,   305)*sol(:ncol,:,   149)                            ! rate_const*TERPACO3*NO3
      rxt_rates(:ncol,:,   755) = rxt_rates(:ncol,:,   755)*sol(:ncol,:,   305)*sol(:ncol,:,   305)                            ! rate_const*TERPACO3*TERPACO3
      rxt_rates(:ncol,:,   756) = rxt_rates(:ncol,:,   756)*sol(:ncol,:,   200)*sol(:ncol,:,   149)                            ! rate_const*TERPA*NO3
      rxt_rates(:ncol,:,   757) = rxt_rates(:ncol,:,   757)*sol(:ncol,:,   200)*sol(:ncol,:,   293)                            ! rate_const*TERPA*OH
      rxt_rates(:ncol,:,   758) = rxt_rates(:ncol,:,   758)*sol(:ncol,:,   208)*sol(:ncol,:,   293)                            ! rate_const*TERPAPAN*OH
      rxt_rates(:ncol,:,   759) = rxt_rates(:ncol,:,   759)*sol(:ncol,:,   209)*sol(:ncol,:,   293)                            ! rate_const*TERPDHDP*OH
      rxt_rates(:ncol,:,   760) = rxt_rates(:ncol,:,   760)*sol(:ncol,:,   210)*sol(:ncol,:,   149)                            ! rate_const*TERPF1*NO3
      rxt_rates(:ncol,:,   761) = rxt_rates(:ncol,:,   761)*sol(:ncol,:,   306)*sol(:ncol,:,   256)                            ! rate_const*TERPF1O2*HO2
      rxt_rates(:ncol,:,   762) = rxt_rates(:ncol,:,   762)*sol(:ncol,:,   306)*sol(:ncol,:,   147)                            ! rate_const*TERPF1O2*NO
      rxt_rates(:ncol,:,   763) = rxt_rates(:ncol,:,   763)*sol(:ncol,:,   210)*sol(:ncol,:,   157)                            ! rate_const*TERPF1*O3
      rxt_rates(:ncol,:,   764) = rxt_rates(:ncol,:,   764)*sol(:ncol,:,   210)*sol(:ncol,:,   293)                            ! rate_const*TERPF1*OH
      rxt_rates(:ncol,:,   765) = rxt_rates(:ncol,:,   765)*sol(:ncol,:,   211)*sol(:ncol,:,   149)                            ! rate_const*TERPF2*NO3
      rxt_rates(:ncol,:,   766) = rxt_rates(:ncol,:,   766)*sol(:ncol,:,   307)*sol(:ncol,:,   256)                            ! rate_const*TERPF2O2*HO2
      rxt_rates(:ncol,:,   767) = rxt_rates(:ncol,:,   767)*sol(:ncol,:,   307)*sol(:ncol,:,   147)                            ! rate_const*TERPF2O2*NO
      rxt_rates(:ncol,:,   768) = rxt_rates(:ncol,:,   768)*sol(:ncol,:,   211)*sol(:ncol,:,   157)                            ! rate_const*TERPF2*O3
      rxt_rates(:ncol,:,   769) = rxt_rates(:ncol,:,   769)*sol(:ncol,:,   211)*sol(:ncol,:,   293)                            ! rate_const*TERPF2*OH
      rxt_rates(:ncol,:,   770) = rxt_rates(:ncol,:,   770)*sol(:ncol,:,   212)*sol(:ncol,:,   293)                            ! rate_const*TERPFDN*OH
      rxt_rates(:ncol,:,   771) = rxt_rates(:ncol,:,   771)*sol(:ncol,:,   213)*sol(:ncol,:,   293)                            ! rate_const*TERPHFN*OH
      rxt_rates(:ncol,:,   772) = rxt_rates(:ncol,:,   772)*sol(:ncol,:,   214)*sol(:ncol,:,   293)                            ! rate_const*TERPK*OH
      rxt_rates(:ncol,:,   773) = rxt_rates(:ncol,:,   773)*sol(:ncol,:,   308)*sol(:ncol,:,   256)                            ! rate_const*TERPNPS1O2*HO2
      rxt_rates(:ncol,:,   774) = rxt_rates(:ncol,:,   774)*sol(:ncol,:,   308)*sol(:ncol,:,   147)                            ! rate_const*TERPNPS1O2*NO
      rxt_rates(:ncol,:,   775) = rxt_rates(:ncol,:,   775)*sol(:ncol,:,   216)*sol(:ncol,:,   293)                            ! rate_const*TERPNPS1*OH
      rxt_rates(:ncol,:,   776) = rxt_rates(:ncol,:,   776)*sol(:ncol,:,   215)*sol(:ncol,:,   293)                            ! rate_const*TERPNPS*OH
      rxt_rates(:ncol,:,   777) = rxt_rates(:ncol,:,   777)*sol(:ncol,:,   309)*sol(:ncol,:,   256)                            ! rate_const*TERPNPT1O2*HO2
      rxt_rates(:ncol,:,   778) = rxt_rates(:ncol,:,   778)*sol(:ncol,:,   309)*sol(:ncol,:,   147)                            ! rate_const*TERPNPT1O2*NO
      rxt_rates(:ncol,:,   779) = rxt_rates(:ncol,:,   779)*sol(:ncol,:,   218)*sol(:ncol,:,   293)                            ! rate_const*TERPNPT1*OH
      rxt_rates(:ncol,:,   780) = rxt_rates(:ncol,:,   780)*sol(:ncol,:,   217)*sol(:ncol,:,   293)                            ! rate_const*TERPNPT*OH
      rxt_rates(:ncol,:,   781) = rxt_rates(:ncol,:,   781)*sol(:ncol,:,   310)*sol(:ncol,:,   256)                            ! rate_const*TERPNS1O2*HO2
      rxt_rates(:ncol,:,   782) = rxt_rates(:ncol,:,   782)*sol(:ncol,:,   310)*sol(:ncol,:,   147)                            ! rate_const*TERPNS1O2*NO
      rxt_rates(:ncol,:,   783) = rxt_rates(:ncol,:,   783)*sol(:ncol,:,   220)*sol(:ncol,:,   293)                            ! rate_const*TERPNS1*OH
      rxt_rates(:ncol,:,   784) = rxt_rates(:ncol,:,   784)*sol(:ncol,:,   219)*sol(:ncol,:,   293)                            ! rate_const*TERPNS*OH
      rxt_rates(:ncol,:,   785) = rxt_rates(:ncol,:,   785)*sol(:ncol,:,   311)*sol(:ncol,:,   256)                            ! rate_const*TERPNT1O2*HO2
      rxt_rates(:ncol,:,   786) = rxt_rates(:ncol,:,   786)*sol(:ncol,:,   311)*sol(:ncol,:,   147)                            ! rate_const*TERPNT1O2*NO
      rxt_rates(:ncol,:,   787) = rxt_rates(:ncol,:,   787)*sol(:ncol,:,   222)*sol(:ncol,:,   293)                            ! rate_const*TERPNT1*OH
      rxt_rates(:ncol,:,   788) = rxt_rates(:ncol,:,   788)*sol(:ncol,:,   221)*sol(:ncol,:,   293)                            ! rate_const*TERPNT*OH
      rxt_rates(:ncol,:,   789) = rxt_rates(:ncol,:,   789)*sol(:ncol,:,   224)*sol(:ncol,:,   293)                            ! rate_const*TERPOOHL*OH
      rxt_rates(:ncol,:,   790) = rxt_rates(:ncol,:,   790)*sol(:ncol,:,   223)*sol(:ncol,:,   293)                            ! rate_const*TERPOOH*OH
      rxt_rates(:ncol,:,   791) = rxt_rates(:ncol,:,   791)*sol(:ncol,:,   202)                                                ! rate_const*M*TERPA2PAN
      rxt_rates(:ncol,:,   792) = rxt_rates(:ncol,:,   792)*sol(:ncol,:,   204)                                                ! rate_const*M*TERPA3PAN
      rxt_rates(:ncol,:,   793) = rxt_rates(:ncol,:,   793)*sol(:ncol,:,   208)                                                ! rate_const*M*TERPAPAN
      rxt_rates(:ncol,:,   794) = rxt_rates(:ncol,:,   794)*sol(:ncol,:,    69)*sol(:ncol,:,   149)                            ! rate_const*DMS*NO3
      rxt_rates(:ncol,:,   795) = rxt_rates(:ncol,:,   795)*sol(:ncol,:,    69)*sol(:ncol,:,   293)                            ! rate_const*DMS*OH
      rxt_rates(:ncol,:,   796) = rxt_rates(:ncol,:,   796)*sol(:ncol,:,   160)*sol(:ncol,:,   156)                            ! rate_const*OCS*O
      rxt_rates(:ncol,:,   797) = rxt_rates(:ncol,:,   797)*sol(:ncol,:,   160)*sol(:ncol,:,   293)                            ! rate_const*OCS*OH
      rxt_rates(:ncol,:,   798) = rxt_rates(:ncol,:,   798)*sol(:ncol,:,   171)                                                ! rate_const*O2*S
      rxt_rates(:ncol,:,   799) = rxt_rates(:ncol,:,   799)*sol(:ncol,:,   171)*sol(:ncol,:,   157)                            ! rate_const*S*O3
      rxt_rates(:ncol,:,   800) = rxt_rates(:ncol,:,   800)*sol(:ncol,:,   173)*sol(:ncol,:,    20)                            ! rate_const*SO*BRO
      rxt_rates(:ncol,:,   801) = rxt_rates(:ncol,:,   801)*sol(:ncol,:,   173)*sol(:ncol,:,    60)                            ! rate_const*SO*CLO
      rxt_rates(:ncol,:,   802) = rxt_rates(:ncol,:,   802)*sol(:ncol,:,   171)*sol(:ncol,:,   293)                            ! rate_const*S*OH
      rxt_rates(:ncol,:,   803) = rxt_rates(:ncol,:,   803)*sol(:ncol,:,   173)*sol(:ncol,:,   148)                            ! rate_const*SO*NO2
      rxt_rates(:ncol,:,   804) = rxt_rates(:ncol,:,   804)*sol(:ncol,:,   173)                                                ! rate_const*O2*SO
      rxt_rates(:ncol,:,   805) = rxt_rates(:ncol,:,   805)*sol(:ncol,:,   173)*sol(:ncol,:,   157)                            ! rate_const*SO*O3
      rxt_rates(:ncol,:,   806) = rxt_rates(:ncol,:,   806)*sol(:ncol,:,   173)*sol(:ncol,:,   159)                            ! rate_const*SO*OCLO
      rxt_rates(:ncol,:,   807) = rxt_rates(:ncol,:,   807)*sol(:ncol,:,   173)*sol(:ncol,:,   293)                            ! rate_const*SO*OH
      rxt_rates(:ncol,:,   808) = rxt_rates(:ncol,:,   808)*sol(:ncol,:,    69)*sol(:ncol,:,   293)                            ! rate_const*DMS*OH
      rxt_rates(:ncol,:,   809) = rxt_rates(:ncol,:,   809)*sol(:ncol,:,   174)*sol(:ncol,:,   293)                            ! rate_const*SO2*OH
      rxt_rates(:ncol,:,   810) = rxt_rates(:ncol,:,   810)*sol(:ncol,:,   175)*sol(:ncol,:,   317)                            ! rate_const*SO3*H2O
      rxt_rates(:ncol,:,   811) = rxt_rates(:ncol,:,   811)*sol(:ncol,:,   143)*sol(:ncol,:,   293)                            ! rate_const*NH3*OH
      rxt_rates(:ncol,:,   812) = rxt_rates(:ncol,:,   812)*sol(:ncol,:,    77)                                                ! rate_const*GLYOXAL
      rxt_rates(:ncol,:,   813) = rxt_rates(:ncol,:,   813)*sol(:ncol,:,   256)                                                ! rate_const*HO2
      rxt_rates(:ncol,:,   814) = rxt_rates(:ncol,:,   814)*sol(:ncol,:,    97)                                                ! rate_const*HONITR
      rxt_rates(:ncol,:,   815) = rxt_rates(:ncol,:,   815)*sol(:ncol,:,   105)                                                ! rate_const*ICHE
      rxt_rates(:ncol,:,   816) = rxt_rates(:ncol,:,   816)*sol(:ncol,:,   106)                                                ! rate_const*IEPOX
      rxt_rates(:ncol,:,   817) = rxt_rates(:ncol,:,   817)*sol(:ncol,:,   107)                                                ! rate_const*INHEB
      rxt_rates(:ncol,:,   818) = rxt_rates(:ncol,:,   818)*sol(:ncol,:,   108)                                                ! rate_const*INHED
      rxt_rates(:ncol,:,   819) = rxt_rates(:ncol,:,   819)*sol(:ncol,:,   121)                                                ! rate_const*ISOPNOOHD
      rxt_rates(:ncol,:,   820) = rxt_rates(:ncol,:,   820)*sol(:ncol,:,   110)                                                ! rate_const*ISOPFDN
      rxt_rates(:ncol,:,   821) = rxt_rates(:ncol,:,   821)*sol(:ncol,:,   111)                                                ! rate_const*ISOPFDNC
      rxt_rates(:ncol,:,   822) = rxt_rates(:ncol,:,   822)*sol(:ncol,:,   112)                                                ! rate_const*ISOPFNC
      rxt_rates(:ncol,:,   823) = rxt_rates(:ncol,:,   823)*sol(:ncol,:,   113)                                                ! rate_const*ISOPFNP
      rxt_rates(:ncol,:,   824) = rxt_rates(:ncol,:,   824)*sol(:ncol,:,   114)                                                ! rate_const*ISOPHFP
      rxt_rates(:ncol,:,   825) = rxt_rates(:ncol,:,   825)*sol(:ncol,:,   115)                                                ! rate_const*ISOPN1D
      rxt_rates(:ncol,:,   826) = rxt_rates(:ncol,:,   826)*sol(:ncol,:,   116)                                                ! rate_const*ISOPN2B
      rxt_rates(:ncol,:,   827) = rxt_rates(:ncol,:,   827)*sol(:ncol,:,   118)                                                ! rate_const*ISOPN4D
      rxt_rates(:ncol,:,   828) = rxt_rates(:ncol,:,   828)*sol(:ncol,:,   138)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   829) = rxt_rates(:ncol,:,   829)*sol(:ncol,:,   139)                                                ! rate_const*NC4CHO
      rxt_rates(:ncol,:,   830) = rxt_rates(:ncol,:,   830)*sol(:ncol,:,   144)                                                ! rate_const*NH4
      rxt_rates(:ncol,:,   831) = rxt_rates(:ncol,:,   831)*sol(:ncol,:,   148)                                                ! rate_const*NO2
      rxt_rates(:ncol,:,   832) = rxt_rates(:ncol,:,   832)*sol(:ncol,:,   149)                                                ! rate_const*NO3
      rxt_rates(:ncol,:,   833) = rxt_rates(:ncol,:,   833)*sol(:ncol,:,   161)                                                ! rate_const*ONITR
      rxt_rates(:ncol,:,   834) = rxt_rates(:ncol,:,   834)*sol(:ncol,:,   194)                                                ! rate_const*SQTN
      rxt_rates(:ncol,:,   835) = rxt_rates(:ncol,:,   835)*sol(:ncol,:,   209)                                                ! rate_const*TERPDHDP
      rxt_rates(:ncol,:,   836) = rxt_rates(:ncol,:,   836)*sol(:ncol,:,   212)                                                ! rate_const*TERPFDN
      rxt_rates(:ncol,:,   837) = rxt_rates(:ncol,:,   837)*sol(:ncol,:,   213)                                                ! rate_const*TERPHFN
      rxt_rates(:ncol,:,   838) = rxt_rates(:ncol,:,   838)*sol(:ncol,:,   218)                                                ! rate_const*TERPNPT1
      rxt_rates(:ncol,:,   839) = rxt_rates(:ncol,:,   839)*sol(:ncol,:,   217)                                                ! rate_const*TERPNPT
      rxt_rates(:ncol,:,   840) = rxt_rates(:ncol,:,   840)*sol(:ncol,:,   222)                                                ! rate_const*TERPNT1
      rxt_rates(:ncol,:,   841) = rxt_rates(:ncol,:,   841)*sol(:ncol,:,   221)                                                ! rate_const*TERPNT
      rxt_rates(:ncol,:,   842) = rxt_rates(:ncol,:,   842)*sol(:ncol,:,     4)*sol(:ncol,:,   149)                            ! rate_const*APIN*NO3
      rxt_rates(:ncol,:,   843) = rxt_rates(:ncol,:,   843)*sol(:ncol,:,   237)*sol(:ncol,:,   256)                            ! rate_const*APINO2VBS*HO2
      rxt_rates(:ncol,:,   844) = rxt_rates(:ncol,:,   844)*sol(:ncol,:,   237)*sol(:ncol,:,   147)                            ! rate_const*APINO2VBS*NO
      rxt_rates(:ncol,:,   845) = rxt_rates(:ncol,:,   845)*sol(:ncol,:,     4)*sol(:ncol,:,   157)                            ! rate_const*APIN*O3
      rxt_rates(:ncol,:,   846) = rxt_rates(:ncol,:,   846)*sol(:ncol,:,     4)*sol(:ncol,:,   293)                            ! rate_const*APIN*OH
      rxt_rates(:ncol,:,   847) = rxt_rates(:ncol,:,   847)*sol(:ncol,:,     7)*sol(:ncol,:,   149)                            ! rate_const*BCARY*NO3
      rxt_rates(:ncol,:,   848) = rxt_rates(:ncol,:,   848)*sol(:ncol,:,   240)*sol(:ncol,:,   256)                            ! rate_const*BCARYO2VBS*HO2
      rxt_rates(:ncol,:,   849) = rxt_rates(:ncol,:,   849)*sol(:ncol,:,   240)*sol(:ncol,:,   147)                            ! rate_const*BCARYO2VBS*NO
      rxt_rates(:ncol,:,   850) = rxt_rates(:ncol,:,   850)*sol(:ncol,:,     7)*sol(:ncol,:,   157)                            ! rate_const*BCARY*O3
      rxt_rates(:ncol,:,   851) = rxt_rates(:ncol,:,   851)*sol(:ncol,:,     7)*sol(:ncol,:,   293)                            ! rate_const*BCARY*OH
      rxt_rates(:ncol,:,   852) = rxt_rates(:ncol,:,   852)*sol(:ncol,:,     8)*sol(:ncol,:,   293)                            ! rate_const*BENZENE*OH
      rxt_rates(:ncol,:,   853) = rxt_rates(:ncol,:,   853)*sol(:ncol,:,   242)*sol(:ncol,:,   256)                            ! rate_const*BENZO2VBS*HO2
      rxt_rates(:ncol,:,   854) = rxt_rates(:ncol,:,   854)*sol(:ncol,:,   242)*sol(:ncol,:,   147)                            ! rate_const*BENZO2VBS*NO
      rxt_rates(:ncol,:,   855) = rxt_rates(:ncol,:,   855)*sol(:ncol,:,    17)*sol(:ncol,:,   149)                            ! rate_const*BPIN*NO3
      rxt_rates(:ncol,:,   856) = rxt_rates(:ncol,:,   856)*sol(:ncol,:,   245)*sol(:ncol,:,   256)                            ! rate_const*BPINO2VBS*HO2
      rxt_rates(:ncol,:,   857) = rxt_rates(:ncol,:,   857)*sol(:ncol,:,   245)*sol(:ncol,:,   147)                            ! rate_const*BPINO2VBS*NO
      rxt_rates(:ncol,:,   858) = rxt_rates(:ncol,:,   858)*sol(:ncol,:,    17)*sol(:ncol,:,   157)                            ! rate_const*BPIN*O3
      rxt_rates(:ncol,:,   859) = rxt_rates(:ncol,:,   859)*sol(:ncol,:,    17)*sol(:ncol,:,   293)                            ! rate_const*BPIN*OH
      rxt_rates(:ncol,:,   860) = rxt_rates(:ncol,:,   860)*sol(:ncol,:,   109)*sol(:ncol,:,   149)                            ! rate_const*ISOP*NO3
      rxt_rates(:ncol,:,   861) = rxt_rates(:ncol,:,   861)*sol(:ncol,:,   275)*sol(:ncol,:,   256)                            ! rate_const*ISOPO2VBS*HO2
      rxt_rates(:ncol,:,   862) = rxt_rates(:ncol,:,   862)*sol(:ncol,:,   275)*sol(:ncol,:,   147)                            ! rate_const*ISOPO2VBS*NO
      rxt_rates(:ncol,:,   863) = rxt_rates(:ncol,:,   863)*sol(:ncol,:,   109)*sol(:ncol,:,   157)                            ! rate_const*ISOP*O3
      rxt_rates(:ncol,:,   864) = rxt_rates(:ncol,:,   864)*sol(:ncol,:,   109)*sol(:ncol,:,   293)                            ! rate_const*ISOP*OH
      rxt_rates(:ncol,:,   865) = rxt_rates(:ncol,:,   865)*sol(:ncol,:,   278)*sol(:ncol,:,   256)                            ! rate_const*IVOCO2VBS*HO2
      rxt_rates(:ncol,:,   866) = rxt_rates(:ncol,:,   866)*sol(:ncol,:,   278)*sol(:ncol,:,   147)                            ! rate_const*IVOCO2VBS*NO
      rxt_rates(:ncol,:,   867) = rxt_rates(:ncol,:,   867)*sol(:ncol,:,   124)*sol(:ncol,:,   293)                            ! rate_const*IVOC*OH
      rxt_rates(:ncol,:,   868) = rxt_rates(:ncol,:,   868)*sol(:ncol,:,   125)*sol(:ncol,:,   149)                            ! rate_const*LIMON*NO3
      rxt_rates(:ncol,:,   869) = rxt_rates(:ncol,:,   869)*sol(:ncol,:,   281)*sol(:ncol,:,   256)                            ! rate_const*LIMONO2VBS*HO2
      rxt_rates(:ncol,:,   870) = rxt_rates(:ncol,:,   870)*sol(:ncol,:,   281)*sol(:ncol,:,   147)                            ! rate_const*LIMONO2VBS*NO
      rxt_rates(:ncol,:,   871) = rxt_rates(:ncol,:,   871)*sol(:ncol,:,   125)*sol(:ncol,:,   157)                            ! rate_const*LIMON*O3
      rxt_rates(:ncol,:,   872) = rxt_rates(:ncol,:,   872)*sol(:ncol,:,   125)*sol(:ncol,:,   293)                            ! rate_const*LIMON*OH
      rxt_rates(:ncol,:,   873) = rxt_rates(:ncol,:,   873)*sol(:ncol,:,   135)*sol(:ncol,:,   149)                            ! rate_const*MYRC*NO3
      rxt_rates(:ncol,:,   874) = rxt_rates(:ncol,:,   874)*sol(:ncol,:,   290)*sol(:ncol,:,   256)                            ! rate_const*MYRCO2VBS*HO2
      rxt_rates(:ncol,:,   875) = rxt_rates(:ncol,:,   875)*sol(:ncol,:,   290)*sol(:ncol,:,   147)                            ! rate_const*MYRCO2VBS*NO
      rxt_rates(:ncol,:,   876) = rxt_rates(:ncol,:,   876)*sol(:ncol,:,   135)*sol(:ncol,:,   157)                            ! rate_const*MYRC*O3
      rxt_rates(:ncol,:,   877) = rxt_rates(:ncol,:,   877)*sol(:ncol,:,   135)*sol(:ncol,:,   293)                            ! rate_const*MYRC*OH
      rxt_rates(:ncol,:,   878) = rxt_rates(:ncol,:,   878)*sol(:ncol,:,   196)*sol(:ncol,:,   293)                            ! rate_const*SVOC*OH
      rxt_rates(:ncol,:,   879) = rxt_rates(:ncol,:,   879)*sol(:ncol,:,   226)*sol(:ncol,:,   293)                            ! rate_const*TOLUENE*OH
      rxt_rates(:ncol,:,   880) = rxt_rates(:ncol,:,   880)*sol(:ncol,:,   313)*sol(:ncol,:,   256)                            ! rate_const*TOLUO2VBS*HO2
      rxt_rates(:ncol,:,   881) = rxt_rates(:ncol,:,   881)*sol(:ncol,:,   313)*sol(:ncol,:,   147)                            ! rate_const*TOLUO2VBS*NO
      rxt_rates(:ncol,:,   882) = rxt_rates(:ncol,:,   882)*sol(:ncol,:,   227)*sol(:ncol,:,   293)                            ! rate_const*XYLENES*OH
      rxt_rates(:ncol,:,   883) = rxt_rates(:ncol,:,   883)*sol(:ncol,:,   315)*sol(:ncol,:,   256)                            ! rate_const*XYLEO2VBS*HO2
      rxt_rates(:ncol,:,   884) = rxt_rates(:ncol,:,   884)*sol(:ncol,:,   315)*sol(:ncol,:,   147)                            ! rate_const*XYLEO2VBS*NO
      rxt_rates(:ncol,:,   885) = rxt_rates(:ncol,:,   885)*sol(:ncol,:,   138)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   886) = rxt_rates(:ncol,:,   886)*sol(:ncol,:,    96)*sol(:ncol,:,    87)                            ! rate_const*HOCL*HCL
      rxt_rates(:ncol,:,   887) = rxt_rates(:ncol,:,   887)*sol(:ncol,:,    21)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   888) = rxt_rates(:ncol,:,   888)*sol(:ncol,:,   138)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   889) = rxt_rates(:ncol,:,   889)*sol(:ncol,:,    61)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   890) = rxt_rates(:ncol,:,   890)*sol(:ncol,:,    21)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   891) = rxt_rates(:ncol,:,   891)*sol(:ncol,:,    61)*sol(:ncol,:,    87)                            ! rate_const*CLONO2*HCL
      rxt_rates(:ncol,:,   892) = rxt_rates(:ncol,:,   892)*sol(:ncol,:,    96)*sol(:ncol,:,    87)                            ! rate_const*HOCL*HCL
      rxt_rates(:ncol,:,   893) = rxt_rates(:ncol,:,   893)*sol(:ncol,:,    95)*sol(:ncol,:,    87)                            ! rate_const*HOBR*HCL
      rxt_rates(:ncol,:,   894) = rxt_rates(:ncol,:,   894)*sol(:ncol,:,    61)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   895) = rxt_rates(:ncol,:,   895)*sol(:ncol,:,    21)                                                ! rate_const*BRONO2
      rxt_rates(:ncol,:,   896) = rxt_rates(:ncol,:,   896)*sol(:ncol,:,    61)*sol(:ncol,:,    87)                            ! rate_const*CLONO2*HCL
      rxt_rates(:ncol,:,   897) = rxt_rates(:ncol,:,   897)*sol(:ncol,:,    96)*sol(:ncol,:,    87)                            ! rate_const*HOCL*HCL
      rxt_rates(:ncol,:,   898) = rxt_rates(:ncol,:,   898)*sol(:ncol,:,    95)*sol(:ncol,:,    87)                            ! rate_const*HOBR*HCL
      rxt_rates(:ncol,:,   899) = rxt_rates(:ncol,:,   899)*sol(:ncol,:,   138)                                                ! rate_const*N2O5
      rxt_rates(:ncol,:,   900) = rxt_rates(:ncol,:,   900)*sol(:ncol,:,    61)                                                ! rate_const*CLONO2
      rxt_rates(:ncol,:,   901) = rxt_rates(:ncol,:,   901)*sol(:ncol,:,    61)*sol(:ncol,:,    87)                            ! rate_const*CLONO2*HCL
      rxt_rates(:ncol,:,   902) = rxt_rates(:ncol,:,   902)*sol(:ncol,:,    73)                                                ! rate_const*E90
      rxt_rates(:ncol,:,   903) = rxt_rates(:ncol,:,   903)*sol(:ncol,:,   146)                                                ! rate_const*NH_50
      rxt_rates(:ncol,:,   904) = rxt_rates(:ncol,:,   904)*sol(:ncol,:,   145)                                                ! rate_const*NH_5
      rxt_rates(:ncol,:,   905) = rxt_rates(:ncol,:,   905)*sol(:ncol,:,   195)                                                ! rate_const*ST80_25
  end subroutine set_rates
end module mo_rxt_rates_conv
