      module mo_lin_matrix
      use chem_mods, only: veclen
      private
      public :: linmat
      contains
      subroutine linmat01( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,634) = -( rxt(k,19) + het_rates(k,1) )
         mat(k,645) = -( rxt(k,20) + het_rates(k,2) )
         mat(k,1102) = -( het_rates(k,4) )
         mat(k,1) = -( het_rates(k,5) )
         mat(k,2) = -( het_rates(k,6) )
         mat(k,859) = -( het_rates(k,7) )
         mat(k,131) = -( het_rates(k,8) )
         mat(k,322) = -( rxt(k,21) + het_rates(k,9) )
         mat(k,137) = -( rxt(k,22) + het_rates(k,10) )
         mat(k,383) = -( rxt(k,23) + het_rates(k,11) )
         mat(k,323) = .500_r8*rxt(k,21)
         mat(k,138) = rxt(k,22)
         mat(k,612) = .200_r8*rxt(k,115)
         mat(k,730) = .060_r8*rxt(k,116)
         mat(k,250) = -( rxt(k,24) + het_rates(k,12) )
         mat(k,610) = .200_r8*rxt(k,115)
         mat(k,727) = .200_r8*rxt(k,116)
         mat(k,328) = -( rxt(k,25) + het_rates(k,13) )
         mat(k,611) = .200_r8*rxt(k,115)
         mat(k,729) = .150_r8*rxt(k,116)
         mat(k,270) = -( rxt(k,26) + het_rates(k,14) )
         mat(k,728) = .210_r8*rxt(k,116)
         mat(k,153) = -( het_rates(k,15) )
         mat(k,308) = -( het_rates(k,16) )
         mat(k,941) = -( het_rates(k,17) )
         mat(k,1685) = -( het_rates(k,18) )
         mat(k,196) = rxt(k,118)
         mat(k,3785) = rxt(k,119)
         mat(k,492) = rxt(k,121)
         mat(k,1040) = rxt(k,143)
         mat(k,907) = rxt(k,149)
         mat(k,3099) = rxt(k,244)*y(k,35) + rxt(k,270)*y(k,36) &
                      + 3.000_r8*rxt(k,271)*y(k,56) + 2.000_r8*rxt(k,272)*y(k,80) &
                      + 2.000_r8*rxt(k,293)*y(k,42) + rxt(k,294)*y(k,44)
         mat(k,3819) = 2.000_r8*rxt(k,281)*y(k,42) + rxt(k,283)*y(k,44) &
                      + 3.000_r8*rxt(k,288)*y(k,56)
         mat(k,3704) = 2.000_r8*rxt(k,282)*y(k,42) + rxt(k,284)*y(k,44) &
                      + 3.000_r8*rxt(k,289)*y(k,56)
         mat(k,195) = -( rxt(k,118) + het_rates(k,19) )
         mat(k,3800) = -( rxt(k,119) + het_rates(k,20) )
         mat(k,497) = rxt(k,120)
         mat(k,490) = -( rxt(k,120) + rxt(k,121) + rxt(k,887) + rxt(k,890) + rxt(k,895) &
                 + het_rates(k,21) )
         mat(k,198) = -( het_rates(k,23) )
         mat(k,285) = rxt(k,27)
         mat(k,286) = -( rxt(k,27) + het_rates(k,24) )
         mat(k,253) = -( het_rates(k,25) )
         mat(k,498) = -( het_rates(k,26) )
         mat(k,218) = -( het_rates(k,27) )
         mat(k,291) = -( rxt(k,28) + het_rates(k,28) )
         mat(k,259) = -( het_rates(k,29) )
         mat(k,1197) = -( het_rates(k,30) )
         mat(k,1854) = .700_r8*rxt(k,79)
         mat(k,338) = -( rxt(k,29) + het_rates(k,31) )
         mat(k,112) = -( het_rates(k,32) )
         mat(k,222) = -( rxt(k,30) + het_rates(k,33) )
         mat(k,3337) = -( rxt(k,31) + rxt(k,32) + het_rates(k,43) )
         mat(k,641) = .100_r8*rxt(k,19)
         mat(k,653) = .100_r8*rxt(k,20)
         mat(k,372) = rxt(k,37)
         mat(k,571) = .500_r8*rxt(k,41)
         mat(k,1472) = rxt(k,43)
         mat(k,725) = rxt(k,45)
         mat(k,1121) = rxt(k,46)
         mat(k,885) = .330_r8*rxt(k,47)
         mat(k,1615) = rxt(k,52)
         mat(k,810) = rxt(k,55) + rxt(k,56)
         mat(k,579) = rxt(k,65)
         mat(k,479) = rxt(k,66)
         mat(k,630) = rxt(k,68)
         mat(k,1060) = rxt(k,69)
         mat(k,1907) = rxt(k,71)
         mat(k,1760) = rxt(k,72)
         mat(k,1625) = .250_r8*rxt(k,74)
         mat(k,1334) = .140_r8*rxt(k,75)
         mat(k,1807) = .250_r8*rxt(k,80)
         mat(k,1366) = .440_r8*rxt(k,81)
         mat(k,1273) = rxt(k,83)
         mat(k,1346) = rxt(k,84)
         mat(k,487) = rxt(k,88)
         mat(k,335) = rxt(k,89)
         mat(k,598) = rxt(k,314)
         mat(k,237) = 2.000_r8*rxt(k,344)
         mat(k,1839) = rxt(k,428)
         mat(k,1741) = rxt(k,434)
         mat(k,3108) = rxt(k,317)*y(k,55) + rxt(k,318)*y(k,55)
         mat(k,1305) = -( rxt(k,33) + het_rates(k,46) )
         mat(k,637) = .400_r8*rxt(k,19)
         mat(k,649) = .400_r8*rxt(k,20)
         mat(k,293) = rxt(k,28)
         mat(k,877) = .330_r8*rxt(k,47)
         mat(k,267) = rxt(k,77)
         mat(k,484) = rxt(k,88)
         mat(k,106) = -( het_rates(k,48) )
         mat(k,2141) = -( rxt(k,34) + het_rates(k,49) )
         mat(k,638) = .250_r8*rxt(k,19)
         mat(k,650) = .250_r8*rxt(k,20)
         mat(k,340) = .820_r8*rxt(k,29)
         mat(k,881) = .170_r8*rxt(k,47)
         mat(k,1845) = -( rxt(k,35) + het_rates(k,50) )
         mat(k,272) = rxt(k,26)
         mat(k,569) = .500_r8*rxt(k,41)
         mat(k,548) = .680_r8*rxt(k,48)
         mat(k,561) = .670_r8*rxt(k,49)
         mat(k,1702) = rxt(k,54)
         mat(k,1028) = .500_r8*rxt(k,60)
         mat(k,1637) = .500_r8*rxt(k,61)
         mat(k,668) = .720_r8*rxt(k,63)
         mat(k,1621) = .250_r8*rxt(k,74)
         mat(k,1332) = .140_r8*rxt(k,75)
         mat(k,1802) = .250_r8*rxt(k,80)
         mat(k,1363) = .440_r8*rxt(k,81)
         mat(k,620) = .400_r8*rxt(k,115)
         mat(k,738) = .540_r8*rxt(k,116)
         mat(k,353) = .510_r8*rxt(k,117)
         mat(k,530) = -( het_rates(k,51) )
         mat(k,468) = -( rxt(k,36) + het_rates(k,52) )
         mat(k,1356) = -( het_rates(k,53) )
         mat(k,370) = -( rxt(k,37) + het_rates(k,54) )
         mat(k,3836) = -( rxt(k,219)*y(k,55) + rxt(k,281)*y(k,42) + rxt(k,283)*y(k,44) &
                      + rxt(k,286)*y(k,47) + rxt(k,288)*y(k,56) + het_rates(k,57) )
         mat(k,197) = rxt(k,118)
         mat(k,129) = 2.000_r8*rxt(k,135)
         mat(k,111) = 2.000_r8*rxt(k,136)
         mat(k,3320) = rxt(k,137)
         mat(k,1221) = rxt(k,138)
         mat(k,159) = rxt(k,141)
         mat(k,3777) = rxt(k,147)
         mat(k,1069) = rxt(k,150)
         mat(k,3115) = 4.000_r8*rxt(k,243)*y(k,34) + rxt(k,244)*y(k,35) &
                      + 2.000_r8*rxt(k,245)*y(k,37) + 2.000_r8*rxt(k,246)*y(k,38) &
                      + 2.000_r8*rxt(k,247)*y(k,39) + rxt(k,248)*y(k,40) &
                      + 2.000_r8*rxt(k,249)*y(k,41) + rxt(k,295)*y(k,84) &
                      + rxt(k,296)*y(k,85) + rxt(k,297)*y(k,86)
         mat(k,3755) = 3.000_r8*rxt(k,285)*y(k,45) + rxt(k,287)*y(k,47) &
                      + rxt(k,290)*y(k,84) + rxt(k,291)*y(k,85) + rxt(k,292)*y(k,86)
         mat(k,128) = -( rxt(k,135) + het_rates(k,58) )
         mat(k,109) = -( rxt(k,136) + rxt(k,253) + het_rates(k,59) )
         mat(k,3312) = -( rxt(k,137) + het_rates(k,60) )
         mat(k,1216) = rxt(k,139)
         mat(k,278) = rxt(k,151)
         mat(k,110) = 2.000_r8*rxt(k,253)
         mat(k,1213) = -( rxt(k,138) + rxt(k,139) + rxt(k,889) + rxt(k,894) + rxt(k,900) &
                 + het_rates(k,61) )
         mat(k,1540) = -( het_rates(k,63) )
         mat(k,139) = 1.500_r8*rxt(k,22)
         mat(k,330) = .600_r8*rxt(k,25)
         mat(k,271) = rxt(k,26)
         mat(k,3327) = rxt(k,31) + rxt(k,32)
         mat(k,1306) = rxt(k,33)
         mat(k,1844) = rxt(k,35)
         mat(k,568) = .500_r8*rxt(k,41)
         mat(k,1470) = rxt(k,43)
         mat(k,1177) = 2.000_r8*rxt(k,44)
         mat(k,723) = rxt(k,45)
         mat(k,879) = .330_r8*rxt(k,47)
         mat(k,547) = 1.320_r8*rxt(k,48)
         mat(k,559) = 1.740_r8*rxt(k,49)
         mat(k,422) = rxt(k,50)
         mat(k,429) = rxt(k,51)
         mat(k,1697) = 1.500_r8*rxt(k,53) + rxt(k,54)
         mat(k,1923) = .550_r8*rxt(k,64)
         mat(k,1957) = .550_r8*rxt(k,67)
         mat(k,1748) = 1.650_r8*rxt(k,72)
         mat(k,1618) = .750_r8*rxt(k,74)
         mat(k,1330) = .860_r8*rxt(k,75)
         mat(k,1859) = .700_r8*rxt(k,79)
         mat(k,1271) = rxt(k,83)
         mat(k,174) = 1.500_r8*rxt(k,90)
         mat(k,2192) = rxt(k,93)
         mat(k,1168) = rxt(k,94)
         mat(k,1644) = rxt(k,96)
         mat(k,304) = rxt(k,154)
         mat(k,1384) = rxt(k,385)
         mat(k,1481) = rxt(k,501)
         mat(k,1777) = .600_r8*rxt(k,530)
         mat(k,1664) = .600_r8*rxt(k,533)
         mat(k,3818) = rxt(k,286)*y(k,47)
         mat(k,122) = -( rxt(k,140) + het_rates(k,65) )
         mat(k,3093) = rxt(k,244)*y(k,35) + rxt(k,246)*y(k,38) &
                      + 2.000_r8*rxt(k,247)*y(k,39) + 2.000_r8*rxt(k,248)*y(k,40) &
                      + rxt(k,249)*y(k,41) + rxt(k,270)*y(k,36) &
                      + 2.000_r8*rxt(k,272)*y(k,80) + rxt(k,296)*y(k,85) &
                      + rxt(k,297)*y(k,86)
         mat(k,3537) = rxt(k,291)*y(k,85) + rxt(k,292)*y(k,86)
         mat(k,156) = -( rxt(k,141) + het_rates(k,66) )
         mat(k,3095) = rxt(k,245)*y(k,37) + rxt(k,246)*y(k,38) + rxt(k,295)*y(k,84)
         mat(k,3544) = rxt(k,290)*y(k,84)
         mat(k,168) = -( het_rates(k,67) )
         mat(k,566) = -( rxt(k,41) + het_rates(k,68) )
         mat(k,1768) = .600_r8*rxt(k,530)
         mat(k,1656) = .600_r8*rxt(k,533)
         mat(k,238) = -( het_rates(k,69) )
         mat(k,3) = -( het_rates(k,70) )
         mat(k,4) = -( het_rates(k,71) )
         mat(k,5) = -( het_rates(k,72) )
         mat(k,116) = -( rxt(k,42) + het_rates(k,74) )
         mat(k,897) = -( rxt(k,275)*y(k,55) + het_rates(k,75) )
         mat(k,123) = 2.000_r8*rxt(k,140)
         mat(k,157) = rxt(k,141)
         mat(k,193) = rxt(k,148)
         mat(k,3096) = rxt(k,248)*y(k,40) + rxt(k,270)*y(k,36)
      end do
      end subroutine linmat01
      subroutine linmat02( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,1469) = -( rxt(k,43) + het_rates(k,76) )
         mat(k,878) = .330_r8*rxt(k,47)
         mat(k,1696) = .500_r8*rxt(k,53)
         mat(k,1528) = rxt(k,59)
         mat(k,1023) = .500_r8*rxt(k,60)
         mat(k,1631) = .500_r8*rxt(k,61)
         mat(k,1337) = rxt(k,62)
         mat(k,665) = .720_r8*rxt(k,63)
         mat(k,1799) = .500_r8*rxt(k,80)
         mat(k,1361) = .560_r8*rxt(k,81)
         mat(k,235) = rxt(k,345)
         mat(k,1176) = -( rxt(k,44) + rxt(k,812) + het_rates(k,77) )
         mat(k,325) = rxt(k,21)
         mat(k,1022) = .500_r8*rxt(k,60)
         mat(k,1628) = .500_r8*rxt(k,61)
         mat(k,664) = .280_r8*rxt(k,63)
         mat(k,282) = .700_r8*rxt(k,87)
         mat(k,618) = .600_r8*rxt(k,115)
         mat(k,736) = .340_r8*rxt(k,116)
         mat(k,352) = .170_r8*rxt(k,117)
         mat(k,2730) = -( rxt(k,181) + het_rates(k,78) )
         mat(k,3847) = rxt(k,2) + 2.000_r8*rxt(k,3)
         mat(k,3330) = 2.000_r8*rxt(k,31)
         mat(k,371) = rxt(k,37)
         mat(k,1041) = rxt(k,143)
         mat(k,3764) = rxt(k,147)
         mat(k,194) = rxt(k,148)
         mat(k,3101) = rxt(k,317)*y(k,55)
         mat(k,1416) = -( het_rates(k,79) )
         mat(k,3843) = rxt(k,1)
         mat(k,3326) = rxt(k,32)
         mat(k,3098) = rxt(k,318)*y(k,55)
         mat(k,1349) = -( rxt(k,4) + het_rates(k,81) )
         mat(k,3218) = .500_r8*rxt(k,813)
         mat(k,119) = -( rxt(k,153) + het_rates(k,82) )
         mat(k,1039) = -( rxt(k,143) + het_rates(k,83) )
         mat(k,3775) = -( rxt(k,147) + het_rates(k,87) )
         mat(k,3834) = rxt(k,219)*y(k,55) + rxt(k,281)*y(k,42) + rxt(k,283)*y(k,44) &
                      + 2.000_r8*rxt(k,286)*y(k,47) + rxt(k,288)*y(k,56)
         mat(k,146) = -( het_rates(k,88) )
         mat(k,721) = -( rxt(k,45) + het_rates(k,89) )
         mat(k,1124) = -( het_rates(k,90) )
         mat(k,544) = .410_r8*rxt(k,48)
         mat(k,192) = -( rxt(k,148) + het_rates(k,91) )
         mat(k,896) = rxt(k,275)*y(k,55)
         mat(k,1118) = -( rxt(k,46) + het_rates(k,92) )
         mat(k,2717) = -( rxt(k,9) + het_rates(k,93) )
         mat(k,883) = rxt(k,814)
         mat(k,414) = rxt(k,817)
         mat(k,1090) = rxt(k,818)
         mat(k,1452) = rxt(k,819)
         mat(k,1535) = rxt(k,820)
         mat(k,1029) = rxt(k,821)
         mat(k,1933) = rxt(k,825)
         mat(k,577) = rxt(k,826)
         mat(k,1967) = rxt(k,827)
         mat(k,245) = 2.000_r8*rxt(k,828) + 2.000_r8*rxt(k,885) + 2.000_r8*rxt(k,888) &
                      + 2.000_r8*rxt(k,899)
         mat(k,1995) = rxt(k,829)
         mat(k,3500) = .500_r8*rxt(k,831)
         mat(k,3076) = rxt(k,832)
         mat(k,151) = rxt(k,833)
         mat(k,1156) = rxt(k,836)
         mat(k,675) = rxt(k,838)
         mat(k,1035) = rxt(k,839)
         mat(k,1606) = rxt(k,840)
         mat(k,1398) = rxt(k,841)
         mat(k,493) = rxt(k,887) + rxt(k,890) + rxt(k,895)
         mat(k,1214) = rxt(k,889) + rxt(k,894) + rxt(k,900)
         mat(k,364) = -( rxt(k,10) + rxt(k,11) + rxt(k,216) + het_rates(k,94) )
         mat(k,906) = -( rxt(k,149) + het_rates(k,95) )
         mat(k,491) = rxt(k,887) + rxt(k,890) + rxt(k,895)
         mat(k,1064) = -( rxt(k,150) + het_rates(k,96) )
         mat(k,1212) = rxt(k,889) + rxt(k,894) + rxt(k,900)
         mat(k,876) = -( rxt(k,47) + rxt(k,814) + het_rates(k,97) )
         mat(k,542) = -( rxt(k,48) + het_rates(k,98) )
         mat(k,1767) = .250_r8*rxt(k,530)
         mat(k,554) = -( rxt(k,49) + het_rates(k,99) )
         mat(k,1655) = .250_r8*rxt(k,533)
         mat(k,419) = -( rxt(k,50) + het_rates(k,100) )
         mat(k,1766) = .150_r8*rxt(k,530)
         mat(k,426) = -( rxt(k,51) + het_rates(k,101) )
         mat(k,1654) = .150_r8*rxt(k,533)
         mat(k,1611) = -( rxt(k,52) + het_rates(k,102) )
         mat(k,880) = .170_r8*rxt(k,47)
         mat(k,1698) = .500_r8*rxt(k,53)
         mat(k,1531) = rxt(k,59)
         mat(k,1025) = .500_r8*rxt(k,60)
         mat(k,1633) = .500_r8*rxt(k,61)
         mat(k,1338) = rxt(k,62)
         mat(k,667) = .280_r8*rxt(k,63)
         mat(k,1619) = .500_r8*rxt(k,74)
         mat(k,1331) = .860_r8*rxt(k,75)
         mat(k,1385) = rxt(k,385)
         mat(k,1700) = -( rxt(k,53) + rxt(k,54) + het_rates(k,103) )
         mat(k,1927) = .450_r8*rxt(k,64)
         mat(k,1961) = .450_r8*rxt(k,67)
         mat(k,1990) = rxt(k,82)
         mat(k,807) = -( rxt(k,55) + rxt(k,56) + het_rates(k,104) )
         mat(k,567) = .500_r8*rxt(k,41)
         mat(k,1236) = -( rxt(k,815) + het_rates(k,105) )
         mat(k,411) = rxt(k,57)
         mat(k,1084) = rxt(k,58)
         mat(k,802) = -( rxt(k,816) + het_rates(k,106) )
         mat(k,409) = -( rxt(k,57) + rxt(k,817) + het_rates(k,107) )
         mat(k,1083) = -( rxt(k,58) + rxt(k,818) + het_rates(k,108) )
         mat(k,1285) = -( het_rates(k,109) )
         mat(k,1529) = -( rxt(k,59) + rxt(k,820) + het_rates(k,110) )
         mat(k,1021) = -( rxt(k,60) + rxt(k,821) + het_rates(k,111) )
         mat(k,1635) = -( rxt(k,61) + rxt(k,822) + het_rates(k,112) )
         mat(k,1077) = rxt(k,463)
         mat(k,988) = rxt(k,466)
         mat(k,1336) = -( rxt(k,62) + rxt(k,823) + het_rates(k,113) )
         mat(k,1000) = rxt(k,459)
         mat(k,1012) = rxt(k,469)
         mat(k,1182) = rxt(k,481)
         mat(k,1257) = rxt(k,484)
         mat(k,663) = -( rxt(k,63) + rxt(k,824) + het_rates(k,114) )
         mat(k,1930) = -( rxt(k,64) + rxt(k,825) + het_rates(k,115) )
         mat(k,573) = -( rxt(k,65) + rxt(k,826) + het_rates(k,116) )
         mat(k,474) = -( rxt(k,66) + het_rates(k,117) )
         mat(k,1964) = -( rxt(k,67) + rxt(k,827) + het_rates(k,118) )
         mat(k,623) = -( rxt(k,68) + het_rates(k,119) )
         mat(k,1048) = -( rxt(k,69) + het_rates(k,120) )
         mat(k,1439) = -( rxt(k,70) + rxt(k,819) + het_rates(k,121) )
         mat(k,797) = -( het_rates(k,122) )
         mat(k,1896) = -( rxt(k,71) + het_rates(k,123) )
         mat(k,78) = -( het_rates(k,124) )
         mat(k,961) = -( het_rates(k,125) )
         mat(k,1751) = -( rxt(k,72) + rxt(k,73) + het_rates(k,126) )
         mat(k,430) = rxt(k,51)
         mat(k,477) = rxt(k,66)
         mat(k,626) = .500_r8*rxt(k,68)
         mat(k,1053) = .120_r8*rxt(k,69)
         mat(k,1891) = .300_r8*rxt(k,71)
         mat(k,1730) = rxt(k,434)
         mat(k,1620) = -( rxt(k,74) + het_rates(k,127) )
         mat(k,1483) = .510_r8*rxt(k,501)
         mat(k,1329) = -( rxt(k,75) + het_rates(k,128) )
         mat(k,1916) = .550_r8*rxt(k,64)
         mat(k,450) = -( rxt(k,76) + het_rates(k,129) )
         mat(k,633) = .800_r8*rxt(k,19)
         mat(k,644) = .800_r8*rxt(k,20)
         mat(k,265) = -( rxt(k,77) + het_rates(k,130) )
         mat(k,391) = -( rxt(k,78) + rxt(k,408) + het_rates(k,131) )
         mat(k,1863) = -( rxt(k,79) + het_rates(k,132) )
         mat(k,423) = rxt(k,50)
         mat(k,576) = rxt(k,65)
         mat(k,627) = .500_r8*rxt(k,68)
         mat(k,1055) = .880_r8*rxt(k,69)
         mat(k,1895) = .700_r8*rxt(k,71)
         mat(k,1831) = rxt(k,428)
         mat(k,1801) = -( rxt(k,80) + het_rates(k,133) )
         mat(k,1485) = .490_r8*rxt(k,501)
         mat(k,1360) = -( rxt(k,81) + het_rates(k,134) )
         mat(k,1953) = .550_r8*rxt(k,67)
         mat(k,710) = -( het_rates(k,135) )
         mat(k,316) = -( rxt(k,198) + het_rates(k,136) )
         mat(k,2762) = rxt(k,15)
         mat(k,244) = -( rxt(k,13) + rxt(k,14) + rxt(k,217) + rxt(k,828) + rxt(k,885) &
                      + rxt(k,888) + rxt(k,899) + het_rates(k,138) )
         mat(k,1993) = -( rxt(k,82) + rxt(k,829) + het_rates(k,139) )
         mat(k,1449) = rxt(k,70)
         mat(k,6) = -( het_rates(k,140) )
         mat(k,7) = -( het_rates(k,141) )
         mat(k,8) = -( het_rates(k,142) )
         mat(k,103) = -( het_rates(k,143) )
         mat(k,9) = -( rxt(k,830) + het_rates(k,144) )
         mat(k,2885) = -( rxt(k,15) + het_rates(k,147) )
         mat(k,246) = rxt(k,14)
         mat(k,3502) = rxt(k,16) + .500_r8*rxt(k,831)
         mat(k,3078) = rxt(k,17)
         mat(k,318) = rxt(k,198)
         mat(k,3102) = 2.000_r8*rxt(k,210)*y(k,137)
         mat(k,3511) = -( rxt(k,16) + rxt(k,831) + het_rates(k,148) )
         mat(k,2723) = rxt(k,9)
         mat(k,367) = rxt(k,11) + rxt(k,216)
         mat(k,249) = rxt(k,13) + rxt(k,217)
         mat(k,3087) = rxt(k,18)
         mat(k,642) = rxt(k,19)
         mat(k,886) = rxt(k,47)
         mat(k,417) = rxt(k,57)
         mat(k,1093) = rxt(k,58)
         mat(k,1538) = 2.000_r8*rxt(k,59)
         mat(k,1030) = 2.000_r8*rxt(k,60)
         mat(k,1642) = rxt(k,61)
         mat(k,1341) = rxt(k,62)
         mat(k,1941) = rxt(k,64)
         mat(k,580) = rxt(k,65)
         mat(k,480) = rxt(k,66)
         mat(k,1975) = rxt(k,67)
         mat(k,631) = rxt(k,68)
         mat(k,1061) = rxt(k,69)
         mat(k,1626) = .750_r8*rxt(k,74)
         mat(k,396) = rxt(k,78) + rxt(k,408)
         mat(k,1808) = .750_r8*rxt(k,80)
         mat(k,2003) = rxt(k,82)
         mat(k,1274) = rxt(k,83)
         mat(k,1347) = rxt(k,84)
         mat(k,152) = rxt(k,85)
         mat(k,403) = .600_r8*rxt(k,86) + rxt(k,353)
         mat(k,512) = rxt(k,95) + rxt(k,791)
         mat(k,520) = rxt(k,97) + rxt(k,792)
         mat(k,348) = rxt(k,101) + rxt(k,793)
         mat(k,1158) = rxt(k,103)
         mat(k,893) = .500_r8*rxt(k,105)
         mat(k,587) = .460_r8*rxt(k,106)
         mat(k,1036) = rxt(k,107)
         mat(k,677) = .460_r8*rxt(k,108)
         mat(k,1466) = rxt(k,109)
         mat(k,1596) = rxt(k,110)
         mat(k,1400) = rxt(k,111)
         mat(k,1609) = rxt(k,112)
         mat(k,496) = rxt(k,120)
         mat(k,1218) = rxt(k,139)
         mat(k,127) = rxt(k,576)
      end do
      end subroutine linmat02
      subroutine linmat03( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,3080) = -( rxt(k,17) + rxt(k,18) + rxt(k,832) + het_rates(k,149) )
         mat(k,365) = rxt(k,10)
         mat(k,247) = rxt(k,13) + rxt(k,14) + rxt(k,217)
         mat(k,400) = .400_r8*rxt(k,86)
         mat(k,494) = rxt(k,121)
         mat(k,1215) = rxt(k,138)
         mat(k,1270) = -( rxt(k,83) + het_rates(k,150) )
         mat(k,1797) = .250_r8*rxt(k,80)
         mat(k,1343) = -( rxt(k,84) + het_rates(k,151) )
         mat(k,1617) = .250_r8*rxt(k,74)
         mat(k,10) = -( het_rates(k,152) )
         mat(k,11) = -( het_rates(k,153) )
         mat(k,12) = -( het_rates(k,154) )
         mat(k,13) = -( het_rates(k,155) )
         mat(k,3460) = -( rxt(k,175) + het_rates(k,156) )
         mat(k,3856) = rxt(k,3)
         mat(k,2994) = rxt(k,8)
         mat(k,248) = rxt(k,14)
         mat(k,2893) = rxt(k,15)
         mat(k,3510) = rxt(k,16)
         mat(k,3086) = rxt(k,18)
         mat(k,3796) = rxt(k,119)
         mat(k,3315) = rxt(k,137)
         mat(k,279) = rxt(k,151)
         mat(k,1520) = rxt(k,155) + rxt(k,804)
         mat(k,1164) = rxt(k,156)
         mat(k,216) = rxt(k,157)
         mat(k,3110) = rxt(k,170) + rxt(k,171)
         mat(k,319) = rxt(k,198)
         mat(k,459) = rxt(k,798)
         mat(k,2987) = -( rxt(k,7) + rxt(k,8) + het_rates(k,157) )
         mat(k,3453) = rxt(k,175)
         mat(k,275) = -( rxt(k,151) + het_rates(k,159) )
         mat(k,300) = -( rxt(k,154) + het_rates(k,160) )
         mat(k,150) = -( rxt(k,85) + rxt(k,833) + het_rates(k,161) )
         mat(k,398) = -( rxt(k,86) + rxt(k,353) + het_rates(k,162) )
         mat(k,125) = -( rxt(k,576) + het_rates(k,163) )
         mat(k,405) = -( het_rates(k,164) )
         mat(k,223) = rxt(k,30)
         mat(k,141) = -( het_rates(k,165) )
         mat(k,280) = -( rxt(k,87) + het_rates(k,166) )
         mat(k,14) = -( het_rates(k,167) )
         mat(k,15) = -( het_rates(k,168) )
         mat(k,482) = -( rxt(k,88) + het_rates(k,169) )
         mat(k,332) = -( rxt(k,89) + het_rates(k,170) )
         mat(k,455) = -( rxt(k,798) + het_rates(k,171) )
         mat(k,301) = rxt(k,154)
         mat(k,1511) = rxt(k,155)
         mat(k,1513) = -( rxt(k,155) + rxt(k,804) + het_rates(k,173) )
         mat(k,1162) = rxt(k,156)
         mat(k,456) = rxt(k,798)
         mat(k,1161) = -( rxt(k,156) + het_rates(k,174) )
         mat(k,215) = rxt(k,157)
         mat(k,1512) = rxt(k,804)
         mat(k,214) = -( rxt(k,157) + het_rates(k,175) )
         mat(k,120) = rxt(k,153)
         mat(k,16) = -( het_rates(k,176) )
         mat(k,17) = -( het_rates(k,177) )
         mat(k,18) = -( het_rates(k,178) )
         mat(k,19) = -( rxt(k,158) + het_rates(k,179) )
         mat(k,20) = -( rxt(k,159) + het_rates(k,180) )
         mat(k,21) = -( rxt(k,160) + het_rates(k,181) )
         mat(k,22) = -( rxt(k,161) + het_rates(k,182) )
         mat(k,23) = -( rxt(k,162) + het_rates(k,183) )
         mat(k,24) = -( rxt(k,163) + het_rates(k,184) )
         mat(k,25) = -( rxt(k,164) + het_rates(k,185) )
         mat(k,26) = -( rxt(k,165) + het_rates(k,186) )
         mat(k,27) = -( rxt(k,166) + het_rates(k,187) )
         mat(k,28) = -( rxt(k,167) + het_rates(k,188) )
         mat(k,29) = -( het_rates(k,189) )
         mat(k,1175) = rxt(k,812)
         mat(k,30) = -( het_rates(k,190) )
         mat(k,31) = -( het_rates(k,191) )
         mat(k,32) = -( het_rates(k,192) )
         mat(k,33) = -( het_rates(k,193) )
         mat(k,34) = -( rxt(k,834) + het_rates(k,194) )
         mat(k,40) = -( het_rates(k,196) )
         mat(k,173) = -( rxt(k,90) + het_rates(k,197) )
         mat(k,2179) = -( rxt(k,91) + het_rates(k,198) )
         mat(k,386) = -( rxt(k,92) + het_rates(k,199) )
         mat(k,2193) = -( rxt(k,93) + het_rates(k,200) )
         mat(k,890) = .500_r8*rxt(k,105)
         mat(k,1034) = rxt(k,107)
         mat(k,1464) = rxt(k,109)
         mat(k,1397) = rxt(k,111)
         mat(k,590) = rxt(k,113)
         mat(k,1167) = -( rxt(k,94) + het_rates(k,201) )
         mat(k,506) = -( rxt(k,95) + rxt(k,791) + het_rates(k,202) )
         mat(k,1645) = -( rxt(k,96) + het_rates(k,203) )
         mat(k,527) = rxt(k,114)
         mat(k,514) = -( rxt(k,97) + rxt(k,792) + het_rates(k,204) )
         mat(k,522) = -( rxt(k,98) + het_rates(k,205) )
         mat(k,226) = -( rxt(k,99) + het_rates(k,206) )
         mat(k,230) = -( rxt(k,100) + het_rates(k,207) )
         mat(k,344) = -( rxt(k,101) + rxt(k,793) + het_rates(k,208) )
         mat(k,296) = -( rxt(k,102) + rxt(k,835) + het_rates(k,209) )
         mat(k,2420) = -( het_rates(k,210) )
         mat(k,2181) = rxt(k,91)
         mat(k,585) = .460_r8*rxt(k,106)
         mat(k,674) = .460_r8*rxt(k,108)
         mat(k,1592) = rxt(k,110)
         mat(k,1605) = rxt(k,112)
         mat(k,2392) = -( het_rates(k,211) )
         mat(k,388) = rxt(k,92)
         mat(k,1154) = -( rxt(k,103) + rxt(k,836) + het_rates(k,212) )
         mat(k,871) = -( rxt(k,104) + rxt(k,837) + het_rates(k,213) )
         mat(k,995) = -( het_rates(k,214) )
         mat(k,888) = -( rxt(k,105) + het_rates(k,215) )
         mat(k,582) = -( rxt(k,106) + het_rates(k,216) )
         mat(k,1032) = -( rxt(k,107) + rxt(k,839) + het_rates(k,217) )
         mat(k,671) = -( rxt(k,108) + rxt(k,838) + het_rates(k,218) )
         mat(k,1463) = -( rxt(k,109) + het_rates(k,219) )
         mat(k,1155) = rxt(k,103)
         mat(k,872) = rxt(k,104)
         mat(k,889) = .500_r8*rxt(k,105)
         mat(k,1590) = -( rxt(k,110) + het_rates(k,220) )
         mat(k,584) = .540_r8*rxt(k,106)
         mat(k,1396) = -( rxt(k,111) + rxt(k,841) + het_rates(k,221) )
         mat(k,1603) = -( rxt(k,112) + rxt(k,840) + het_rates(k,222) )
         mat(k,673) = .540_r8*rxt(k,108)
         mat(k,589) = -( rxt(k,113) + het_rates(k,223) )
         mat(k,297) = rxt(k,102)
         mat(k,526) = -( rxt(k,114) + het_rates(k,224) )
         mat(k,613) = -( rxt(k,115) + het_rates(k,225) )
         mat(k,161) = -( het_rates(k,226) )
         mat(k,179) = -( het_rates(k,227) )
         mat(k,731) = -( rxt(k,116) + het_rates(k,228) )
         mat(k,187) = -( het_rates(k,229) )
         mat(k,350) = -( rxt(k,117) + het_rates(k,230) )
         mat(k,462) = -( het_rates(k,233) )
         mat(k,126) = rxt(k,576)
         mat(k,1132) = -( het_rates(k,234) )
         mat(k,2119) = -( het_rates(k,235) )
         mat(k,2214) = -( het_rates(k,236) )
         mat(k,46) = -( het_rates(k,237) )
         mat(k,2053) = -( het_rates(k,238) )
         mat(k,2096) = -( het_rates(k,239) )
         mat(k,52) = -( het_rates(k,240) )
         mat(k,435) = -( het_rates(k,241) )
         mat(k,58) = -( het_rates(k,242) )
         mat(k,2332) = -( het_rates(k,243) )
         mat(k,2243) = -( het_rates(k,244) )
         mat(k,64) = -( het_rates(k,245) )
         mat(k,358) = -( het_rates(k,246) )
         mat(k,1243) = -( het_rates(k,247) )
         mat(k,452) = rxt(k,76)
         mat(k,975) = -( het_rates(k,248) )
         mat(k,604) = -( het_rates(k,249) )
         mat(k,2699) = -( het_rates(k,250) )
         mat(k,273) = rxt(k,26)
         mat(k,2142) = rxt(k,34)
         mat(k,1846) = rxt(k,35)
         mat(k,882) = .330_r8*rxt(k,47)
         mat(k,550) = .050_r8*rxt(k,48)
         mat(k,562) = .070_r8*rxt(k,49)
         mat(k,1613) = rxt(k,52)
         mat(k,1703) = .500_r8*rxt(k,53)
         mat(k,809) = rxt(k,55) + rxt(k,56)
         mat(k,1754) = .350_r8*rxt(k,72)
         mat(k,453) = rxt(k,76)
         mat(k,268) = rxt(k,77)
         mat(k,1864) = .300_r8*rxt(k,79)
         mat(k,1803) = .750_r8*rxt(k,80)
         mat(k,1364) = .560_r8*rxt(k,81)
         mat(k,1345) = rxt(k,84)
         mat(k,399) = .600_r8*rxt(k,86) + rxt(k,353)
         mat(k,334) = rxt(k,89)
         mat(k,175) = .500_r8*rxt(k,90)
         mat(k,3429) = -( het_rates(k,251) )
         mat(k,1311) = rxt(k,33)
         mat(k,2149) = rxt(k,34)
         mat(k,471) = rxt(k,36)
         mat(k,552) = .040_r8*rxt(k,48)
         mat(k,564) = .070_r8*rxt(k,49)
         mat(k,1761) = .650_r8*rxt(k,72)
         mat(k,1872) = .300_r8*rxt(k,79)
         mat(k,402) = .400_r8*rxt(k,86)
         mat(k,3830) = rxt(k,219)*y(k,55)
         mat(k,902) = rxt(k,275)*y(k,55)
         mat(k,3749) = rxt(k,308)*y(k,55)
         mat(k,3109) = rxt(k,316)*y(k,55)
         mat(k,789) = -( het_rates(k,252) )
         mat(k,251) = .600_r8*rxt(k,24)
         mat(k,534) = -( het_rates(k,253) )
         mat(k,234) = -( rxt(k,344) + rxt(k,345) + het_rates(k,254) )
         mat(k,117) = rxt(k,42)
         mat(k,744) = -( het_rates(k,255) )
         mat(k,3285) = -( rxt(k,813) + het_rates(k,256) )
         mat(k,366) = rxt(k,11) + rxt(k,216)
         mat(k,640) = rxt(k,19)
         mat(k,652) = .900_r8*rxt(k,20)
         mat(k,326) = rxt(k,21)
         mat(k,140) = 1.500_r8*rxt(k,22)
         mat(k,385) = rxt(k,23)
         mat(k,252) = .600_r8*rxt(k,24)
         mat(k,331) = .600_r8*rxt(k,25)
         mat(k,274) = rxt(k,26)
         mat(k,289) = rxt(k,27)
         mat(k,294) = rxt(k,28)
         mat(k,341) = rxt(k,29)
         mat(k,1310) = rxt(k,33)
         mat(k,1850) = rxt(k,35)
         mat(k,570) = .500_r8*rxt(k,41)
         mat(k,1471) = 2.000_r8*rxt(k,43)
         mat(k,1178) = 2.000_r8*rxt(k,44)
         mat(k,724) = rxt(k,45)
         mat(k,884) = .670_r8*rxt(k,47)
         mat(k,551) = .620_r8*rxt(k,48)
         mat(k,563) = .560_r8*rxt(k,49)
         mat(k,424) = rxt(k,50)
         mat(k,431) = rxt(k,51)
         mat(k,1614) = rxt(k,52)
         mat(k,1706) = 1.500_r8*rxt(k,53) + rxt(k,54)
         mat(k,415) = rxt(k,57)
         mat(k,1091) = rxt(k,58)
         mat(k,669) = rxt(k,63)
         mat(k,1938) = .450_r8*rxt(k,64)
         mat(k,578) = rxt(k,65)
         mat(k,478) = rxt(k,66)
         mat(k,1972) = .450_r8*rxt(k,67)
         mat(k,629) = rxt(k,68)
         mat(k,1455) = rxt(k,70)
         mat(k,1906) = rxt(k,71)
         mat(k,1759) = rxt(k,72) + rxt(k,73)
         mat(k,1624) = 1.250_r8*rxt(k,74)
         mat(k,1333) = rxt(k,75)
         mat(k,1806) = .500_r8*rxt(k,80)
         mat(k,1365) = .440_r8*rxt(k,81)
         mat(k,2000) = rxt(k,82)
         mat(k,1272) = rxt(k,83)
         mat(k,283) = rxt(k,87)
         mat(k,486) = rxt(k,88)
         mat(k,176) = rxt(k,90)
         mat(k,2188) = rxt(k,91)
         mat(k,389) = rxt(k,92)
         mat(k,2200) = rxt(k,93)
         mat(k,1173) = rxt(k,94)
         mat(k,1651) = rxt(k,96)
         mat(k,298) = rxt(k,102)
         mat(k,1157) = rxt(k,103)
         mat(k,873) = rxt(k,104)
         mat(k,892) = .500_r8*rxt(k,105)
         mat(k,586) = .540_r8*rxt(k,106)
         mat(k,676) = .540_r8*rxt(k,108)
         mat(k,1465) = rxt(k,109)
         mat(k,1595) = rxt(k,110)
         mat(k,1399) = rxt(k,111)
         mat(k,1608) = rxt(k,112)
         mat(k,591) = rxt(k,113)
         mat(k,528) = rxt(k,114)
         mat(k,621) = rxt(k,115)
         mat(k,740) = rxt(k,116)
         mat(k,354) = rxt(k,117)
         mat(k,2734) = rxt(k,181)
         mat(k,597) = rxt(k,314)
         mat(k,236) = rxt(k,344) + rxt(k,345)
         mat(k,1006) = rxt(k,459)
         mat(k,1079) = rxt(k,463)
         mat(k,991) = rxt(k,466)
         mat(k,1017) = rxt(k,469)
         mat(k,1790) = .400_r8*rxt(k,530)
         mat(k,1678) = .400_r8*rxt(k,533)
         mat(k,3827) = rxt(k,283)*y(k,44) + rxt(k,286)*y(k,47)
         mat(k,3746) = rxt(k,284)*y(k,44) + rxt(k,287)*y(k,47)
         mat(k,3106) = rxt(k,317)*y(k,55)
      end do
      end subroutine linmat03
      subroutine linmat04( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,593) = -( rxt(k,314) + het_rates(k,257) )
         mat(k,1404) = -( het_rates(k,258) )
         mat(k,1829) = -( rxt(k,428) + rxt(k,429) + rxt(k,430) + het_rates(k,259) )
         mat(k,203) = rxt(k,437)
         mat(k,206) = rxt(k,439)
         mat(k,1729) = -( rxt(k,434) + rxt(k,435) + rxt(k,436) + het_rates(k,260) )
         mat(k,209) = rxt(k,441)
         mat(k,212) = rxt(k,443)
         mat(k,201) = -( rxt(k,437) + rxt(k,438) + het_rates(k,261) )
         mat(k,1810) = rxt(k,429)
         mat(k,1765) = rxt(k,495)
         mat(k,204) = -( rxt(k,439) + rxt(k,440) + het_rates(k,262) )
         mat(k,1811) = rxt(k,430)
         mat(k,1544) = rxt(k,448)
         mat(k,207) = -( rxt(k,441) + rxt(k,442) + het_rates(k,263) )
         mat(k,1710) = rxt(k,435)
         mat(k,1653) = rxt(k,499)
         mat(k,210) = -( rxt(k,443) + rxt(k,444) + het_rates(k,264) )
         mat(k,1711) = rxt(k,436)
         mat(k,1565) = rxt(k,452)
         mat(k,1550) = -( rxt(k,448) + het_rates(k,265) )
         mat(k,205) = rxt(k,440)
         mat(k,1571) = -( rxt(k,452) + het_rates(k,266) )
         mat(k,211) = rxt(k,444)
         mat(k,999) = -( rxt(k,459) + het_rates(k,267) )
         mat(k,1071) = -( rxt(k,463) + het_rates(k,268) )
         mat(k,985) = -( rxt(k,466) + het_rates(k,269) )
         mat(k,1010) = -( rxt(k,469) + het_rates(k,270) )
         mat(k,1315) = -( het_rates(k,271) )
         mat(k,2034) = -( het_rates(k,272) )
         mat(k,1180) = -( rxt(k,481) + het_rates(k,273) )
         mat(k,1255) = -( rxt(k,484) + het_rates(k,274) )
         mat(k,70) = -( het_rates(k,275) )
         mat(k,1780) = -( rxt(k,495) + rxt(k,530) + het_rates(k,276) )
         mat(k,202) = rxt(k,438)
         mat(k,1667) = -( rxt(k,499) + rxt(k,533) + het_rates(k,277) )
         mat(k,208) = rxt(k,442)
         mat(k,76) = -( het_rates(k,278) )
         mat(k,2303) = -( het_rates(k,279) )
         mat(k,2156) = -( het_rates(k,280) )
         mat(k,84) = -( het_rates(k,281) )
         mat(k,1383) = -( rxt(k,385) + het_rates(k,282) )
         mat(k,558) = .190_r8*rxt(k,49)
         mat(k,751) = -( het_rates(k,283) )
         mat(k,384) = .600_r8*rxt(k,23)
         mat(k,1497) = -( het_rates(k,284) )
         mat(k,1747) = rxt(k,73)
         mat(k,392) = rxt(k,78) + rxt(k,408)
         mat(k,812) = -( het_rates(k,285) )
         mat(k,329) = .600_r8*rxt(k,25)
         mat(k,656) = -( het_rates(k,286) )
         mat(k,1370) = -( het_rates(k,287) )
         mat(k,546) = .230_r8*rxt(k,48)
         mat(k,2364) = -( het_rates(k,288) )
         mat(k,2271) = -( het_rates(k,289) )
         mat(k,90) = -( het_rates(k,290) )
         mat(k,1480) = -( rxt(k,501) + het_rates(k,291) )
         mat(k,3105) = -( rxt(k,170) + rxt(k,171) + rxt(k,210)*y(k,137) &
                      + rxt(k,211)*y(k,137) + rxt(k,243)*y(k,34) + rxt(k,244)*y(k,35) &
                      + rxt(k,245)*y(k,37) + rxt(k,246)*y(k,38) + rxt(k,247)*y(k,39) &
                      + rxt(k,248)*y(k,40) + rxt(k,249)*y(k,41) + rxt(k,270)*y(k,36) &
                      + rxt(k,271)*y(k,56) + rxt(k,272)*y(k,80) + rxt(k,293)*y(k,42) &
                      + rxt(k,294)*y(k,44) + rxt(k,295)*y(k,84) + rxt(k,296)*y(k,85) &
                      + rxt(k,297)*y(k,86) + rxt(k,316)*y(k,55) + rxt(k,317)*y(k,55) &
                      + rxt(k,318)*y(k,55) + het_rates(k,292) )
         mat(k,3851) = rxt(k,1)
         mat(k,2989) = rxt(k,7)
         mat(k,3752) = -( rxt(k,282)*y(k,42) + rxt(k,284)*y(k,44) + rxt(k,285)*y(k,45) &
                      + rxt(k,287)*y(k,47) + rxt(k,289)*y(k,56) + rxt(k,290)*y(k,84) &
                      + rxt(k,291)*y(k,85) + rxt(k,292)*y(k,86) + rxt(k,308)*y(k,55) &
                 + het_rates(k,293) )
         mat(k,3858) = rxt(k,2)
         mat(k,1352) = 2.000_r8*rxt(k,4)
         mat(k,2724) = rxt(k,9)
         mat(k,368) = rxt(k,10)
         mat(k,654) = rxt(k,20)
         mat(k,327) = rxt(k,21)
         mat(k,290) = rxt(k,27)
         mat(k,295) = rxt(k,28)
         mat(k,342) = rxt(k,29)
         mat(k,225) = rxt(k,30)
         mat(k,472) = rxt(k,36)
         mat(k,374) = rxt(k,37)
         mat(k,572) = 1.500_r8*rxt(k,41)
         mat(k,118) = rxt(k,42)
         mat(k,726) = rxt(k,45)
         mat(k,1122) = 2.000_r8*rxt(k,46)
         mat(k,553) = 1.110_r8*rxt(k,48)
         mat(k,565) = 1.180_r8*rxt(k,49)
         mat(k,425) = rxt(k,50)
         mat(k,432) = rxt(k,51)
         mat(k,1709) = 3.000_r8*rxt(k,54)
         mat(k,811) = rxt(k,55) + rxt(k,56)
         mat(k,1643) = rxt(k,61)
         mat(k,1342) = rxt(k,62)
         mat(k,670) = rxt(k,63)
         mat(k,1942) = .550_r8*rxt(k,64)
         mat(k,1976) = .550_r8*rxt(k,67)
         mat(k,1062) = rxt(k,69)
         mat(k,1459) = rxt(k,70)
         mat(k,1910) = rxt(k,71)
         mat(k,1335) = rxt(k,75)
         mat(k,269) = rxt(k,77)
         mat(k,1367) = rxt(k,81)
         mat(k,284) = rxt(k,87)
         mat(k,488) = rxt(k,88)
         mat(k,336) = rxt(k,89)
         mat(k,2191) = rxt(k,91)
         mat(k,390) = rxt(k,92)
         mat(k,525) = rxt(k,98)
         mat(k,229) = rxt(k,99)
         mat(k,233) = rxt(k,100)
         mat(k,299) = rxt(k,102)
         mat(k,874) = rxt(k,104)
         mat(k,894) = rxt(k,105)
         mat(k,588) = rxt(k,106)
         mat(k,1037) = rxt(k,107)
         mat(k,678) = rxt(k,108)
         mat(k,592) = rxt(k,113)
         mat(k,529) = rxt(k,114)
         mat(k,622) = rxt(k,115)
         mat(k,741) = rxt(k,116)
         mat(k,355) = rxt(k,117)
         mat(k,909) = rxt(k,149)
         mat(k,1067) = rxt(k,150)
         mat(k,1395) = rxt(k,385)
         mat(k,1842) = rxt(k,428)
         mat(k,1744) = rxt(k,434)
         mat(k,1193) = rxt(k,481)
         mat(k,1269) = rxt(k,484)
         mat(k,1493) = rxt(k,501)
         mat(k,1794) = .600_r8*rxt(k,530)
         mat(k,1682) = .600_r8*rxt(k,533)
         mat(k,3512) = .500_r8*rxt(k,831)
         mat(k,3112) = rxt(k,316)*y(k,55)
         mat(k,377) = -( het_rates(k,294) )
         mat(k,822) = -( het_rates(k,295) )
         mat(k,1224) = -( het_rates(k,296) )
         mat(k,834) = -( het_rates(k,297) )
         mat(k,917) = -( het_rates(k,298) )
         mat(k,2445) = -( het_rates(k,299) )
         mat(k,2194) = rxt(k,93)
         mat(k,523) = rxt(k,98)
         mat(k,2532) = -( het_rates(k,300) )
         mat(k,509) = rxt(k,95) + rxt(k,791)
         mat(k,2489) = -( het_rates(k,301) )
         mat(k,1169) = rxt(k,94)
         mat(k,227) = rxt(k,99)
         mat(k,2579) = -( het_rates(k,302) )
         mat(k,516) = rxt(k,97) + rxt(k,792)
         mat(k,2072) = -( het_rates(k,303) )
         mat(k,2467) = -( het_rates(k,304) )
         mat(k,1646) = rxt(k,96)
         mat(k,231) = rxt(k,100)
         mat(k,2627) = -( het_rates(k,305) )
         mat(k,347) = rxt(k,101) + rxt(k,793)
         mat(k,680) = -( het_rates(k,306) )
         mat(k,843) = -( het_rates(k,307) )
         mat(k,1144) = -( het_rates(k,308) )
         mat(k,926) = -( het_rates(k,309) )
         mat(k,688) = -( het_rates(k,310) )
         mat(k,696) = -( het_rates(k,311) )
         mat(k,762) = -( het_rates(k,312) )
         mat(k,96) = -( het_rates(k,313) )
         mat(k,778) = -( het_rates(k,314) )
         mat(k,102) = -( het_rates(k,315) )
         mat(k,443) = -( het_rates(k,316) )
         mat(k,3862) = -( rxt(k,1) + rxt(k,2) + rxt(k,3) + het_rates(k,317) )
         mat(k,121) = rxt(k,153)
         mat(k,3756) = rxt(k,282)*y(k,42) + rxt(k,284)*y(k,44) + rxt(k,285)*y(k,45) &
                      + rxt(k,287)*y(k,47) + rxt(k,292)*y(k,86) + rxt(k,308)*y(k,55)
      end do
      end subroutine linmat04
      subroutine linmat( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
      call linmat01( avec_len, mat, y, rxt, het_rates )
      call linmat02( avec_len, mat, y, rxt, het_rates )
      call linmat03( avec_len, mat, y, rxt, het_rates )
      call linmat04( avec_len, mat, y, rxt, het_rates )
      end subroutine linmat
      end module mo_lin_matrix
