#include "dtypes.h"
!===================================================
! DO NOT EDIT THIS FILE, it was generated using /opt/ncar/cesm/cime/src/externals/genf90/genf90.pl
! Any changes you make to this file may be lost
!===================================================
#define __PIO_FILE__ "pionfput_mod.F90"
!>
!! @file
!! $Revision$
!! $LastChangedDate$
!! @brief Write Routines for non-decomposed NetCDF data.
!<
module pionfput_mod
#ifdef TIMING
  use perf_mod, only : t_startf, t_stopf      ! _EXTERNAL
#endif
  use pio_kinds, only: i4,r4,r8,pio_offset
  use pio_types, only : file_desc_t, iosystem_desc_t, var_desc_t, &
	pio_iotype_pbinary, pio_iotype_binary, pio_iotype_direct_pbinary, &
	pio_iotype_netcdf, pio_iotype_pnetcdf, pio_iotype_netcdf4p, pio_iotype_netcdf4c, &
	pio_noerr

  use pio_utils, only : check_netcdf
  use pio_msg_mod
  use pio_support, only : Debug, DebugIO, piodie
#ifdef _NETCDF
  use netcdf            ! _EXTERNAL
#endif
#ifndef NO_MPIMOD
  use mpi   ! _EXTERNAL
#endif
#ifdef USE_PNETCDF_MOD
  use pnetcdf
#endif
  implicit none
  private
#ifdef _PNETCDF
#ifndef USE_PNETCDF_MOD
#include <pnetcdf.inc>
#endif
#endif
#ifdef _NETCDF
! Required for netcdf bug workaround
  integer, external :: nf_put_vars_text
#endif
#ifdef NO_MPIMOD
  include 'mpif.h'   ! _EXTERNAL
#endif
!>
!! @defgroup PIO_put_var PIO_put_var
!! @brief Writes netcdf metadata to a file
!! @details The put_var interface is provided as a simplified interface to
!!  write variables to a netcdf format file.
!! @warning Although this is a collective call the variable is written from the
!!  root IO task, no consistancy check is made with data passed on other tasks.
!!
!<
  public :: put_var
# 54 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  interface put_var
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_text, put_var_vdesc_0d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_text, put_var_vdesc_1d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_text, put_var_vdesc_2d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_text, put_var_vdesc_3d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_text, put_var_vdesc_4d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_text, put_var_vdesc_5d_text
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_real, put_var_vdesc_0d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_real, put_var_vdesc_1d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_real, put_var_vdesc_2d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_real, put_var_vdesc_3d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_real, put_var_vdesc_4d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_real, put_var_vdesc_5d_real
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_double, put_var_vdesc_0d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_double, put_var_vdesc_1d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_double, put_var_vdesc_2d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_double, put_var_vdesc_3d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_double, put_var_vdesc_4d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_double, put_var_vdesc_5d_double
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_0d_int, put_var_vdesc_0d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_1d_int, put_var_vdesc_1d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_2d_int, put_var_vdesc_2d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_3d_int, put_var_vdesc_3d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_4d_int, put_var_vdesc_4d_int
     !  DIMS 0,1,2,3,4,5
     module procedure put_var_5d_int, put_var_vdesc_5d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_text, put_vara_vdesc_1d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_text, put_vara_vdesc_2d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_text, put_vara_vdesc_3d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_text, put_vara_vdesc_4d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_text, put_vara_vdesc_5d_text
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_real, put_vara_vdesc_1d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_real, put_vara_vdesc_2d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_real, put_vara_vdesc_3d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_real, put_vara_vdesc_4d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_real, put_vara_vdesc_5d_real
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_double, put_vara_vdesc_1d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_double, put_vara_vdesc_2d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_double, put_vara_vdesc_3d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_double, put_vara_vdesc_4d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_double, put_vara_vdesc_5d_double
     !  DIMS 1,2,3,4,5
     module procedure put_vara_1d_int, put_vara_vdesc_1d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_2d_int, put_vara_vdesc_2d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_3d_int, put_vara_vdesc_3d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_4d_int, put_vara_vdesc_4d_int
     !  DIMS 1,2,3,4,5
     module procedure put_vara_5d_int, put_vara_vdesc_5d_int
     module procedure put_var1_text, put_var1_vdesc_text
     module procedure put_var1_real, put_var1_vdesc_real
     module procedure put_var1_double, put_var1_vdesc_double
     module procedure put_var1_int, put_var1_vdesc_int
  end interface
# 61 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
contains

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 74 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_text (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    character(len=*), intent(in) :: ival
    integer, allocatable :: count(:)
    integer :: iotype
    type(iosystem_desc_t), pointer :: ios
    integer :: xlen, msg, mpierr, isize, itype

#ifdef TIMING
    call t_startf("PIO:pio_put_var1_text")
#endif
    ierr=PIO_NOERR
    iotype = File%iotype
    if(debug) print *,__PIO_FILE__,__LINE__,ival,iotype, index

    ios=>File%iosystem

    xlen = len_trim(ival)
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       isize = size(index)
       call MPI_BCAST(isize,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,isize,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface) then
       call MPI_BCAST(ival,xlen,MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       allocate(count(size(index)))
!       if(Ios%io_rank == 0) then
          count(:) = 1
          count(1) = len(ival)
!       else
!          count(:) = 0
!       end if

       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
!#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)

          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara (File%fh, varid, int(index,kind=PIO_OFFSET), &
                  int(count,kind=PIO_OFFSET), ival, int(count,kind=PIO_OFFSET), &
                  MPI_CHARACTER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
!#else
!          print *,__PIO_FILE__,__LINE__,index,count,trim(ival)
!            ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), &
!                  int(count,kind=PIO_OFFSET), ival)
!#endif

#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case (pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=index)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
       deallocate(count)
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_var1_text")
#endif
# 165 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_text
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 178 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_int (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    integer(i4), intent(in) :: ival
    integer, allocatable :: count(:)
    integer :: iotype, isize
    type(iosystem_desc_t), pointer :: ios
    integer :: xlen, msg, mpierr, itype

#ifdef TIMING
    call t_startf("PIO:pio_put_var1_int")
#endif
    ierr=PIO_NOERR
    iotype = File%iotype
    if(debug) print *,__PIO_FILE__,__LINE__,ival,iotype, index

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       isize = size(index)
       call MPI_BCAST(isize,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,isize,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface) then
       call MPI_BCAST(ival,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then

       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(count(size(index)))
          if(Ios%io_rank == 0) then
             count(:) = 1
          else
             count(:) = 0
          end if
!#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara (File%fh, varid, int(index,kind=PIO_OFFSET), int(count,kind=PIO_OFFSET), &
                  ival, int(count,kind=PIO_OFFSET), MPI_INTEGER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
!#else
!          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), int(count,kind=PIO_OFFSET), &
!               ival)
!#endif
          deallocate(count)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case (pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=index)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_var1_int")
#endif
# 261 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_int
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 178 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_real (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    real(r4), intent(in) :: ival
    integer, allocatable :: count(:)
    integer :: iotype, isize
    type(iosystem_desc_t), pointer :: ios
    integer :: xlen, msg, mpierr, itype

#ifdef TIMING
    call t_startf("PIO:pio_put_var1_real")
#endif
    ierr=PIO_NOERR
    iotype = File%iotype
    if(debug) print *,__PIO_FILE__,__LINE__,ival,iotype, index

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       isize = size(index)
       call MPI_BCAST(isize,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,isize,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface) then
       call MPI_BCAST(ival,1,MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then

       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(count(size(index)))
          if(Ios%io_rank == 0) then
             count(:) = 1
          else
             count(:) = 0
          end if
!#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara (File%fh, varid, int(index,kind=PIO_OFFSET), int(count,kind=PIO_OFFSET), &
                  ival, int(count,kind=PIO_OFFSET), MPI_REAL4)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
!#else
!          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), int(count,kind=PIO_OFFSET), &
!               ival)
!#endif
          deallocate(count)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case (pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=index)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_var1_real")
#endif
# 261 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_real
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param index :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 178 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_double (File,varid, index, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, index(:)
    real(r8), intent(in) :: ival
    integer, allocatable :: count(:)
    integer :: iotype, isize
    type(iosystem_desc_t), pointer :: ios
    integer :: xlen, msg, mpierr, itype

#ifdef TIMING
    call t_startf("PIO:pio_put_var1_double")
#endif
    ierr=PIO_NOERR
    iotype = File%iotype
    if(debug) print *,__PIO_FILE__,__LINE__,ival,iotype, index

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR1
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       isize = size(index)
       call MPI_BCAST(isize,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(index,isize,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface) then
       call MPI_BCAST(ival,1,MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then

       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(count(size(index)))
          if(Ios%io_rank == 0) then
             count(:) = 1
          else
             count(:) = 0
          end if
!#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara (File%fh, varid, int(index,kind=PIO_OFFSET), int(count,kind=PIO_OFFSET), &
                  ival, int(count,kind=PIO_OFFSET), MPI_REAL8)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
!#else
!          ierr = nfmpi_put_vara_all (File%fh, varid, int(index,kind=PIO_OFFSET), int(count,kind=PIO_OFFSET), &
!               ival)
!#endif
          deallocate(count)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case (pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=index)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=index)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_var1_double")
#endif
# 261 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_double

!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 274 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_vdesc_text (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    character(len=*), intent(in) :: ival

    ierr = put_var1_text (File, vardesc%varid, start, ival)
# 281 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_vdesc_text
# 274 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_vdesc_real (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    real(r4), intent(in) :: ival

    ierr = put_var1_real (File, vardesc%varid, start, ival)
# 281 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_vdesc_real
# 274 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_vdesc_double (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    real(r8), intent(in) :: ival

    ierr = put_var1_double (File, vardesc%varid, start, ival)
# 281 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_vdesc_double
# 274 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var1_vdesc_int (File,vardesc, start, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:)
    integer(i4), intent(in) :: ival

    ierr = put_var1_int (File, vardesc%varid, start, ival)
# 281 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var1_vdesc_int

! DIMS 0,1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 296 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_0d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen, itype
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(0)
    integer :: start(0+1), count(0+1)
#ifdef TIMING
    call t_startf("PIO:pio_put_var_0d_text")
#endif
    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0


    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (0 > 0)
       do i=1,0
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,0,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       xlen = len(ival)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
#if(0==0)
       call MPI_BCAST(ival,len_trim(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#else
       call MPI_BCAST(ival,size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
    	  count(1)=len(ival)
	  is=1
#if (0 > 0)
          do i=1,0
             count(i+is) = size(ival,i)
          end do
#endif
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(ios%io_rank>0) count = 0
          ierr = nfmpi_put_vara_text_all (File%fh, varid,int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
#if (0==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
!          if (Ios%io_rank == 0) then
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
!          else
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/0/), (/1/), ival)
!          end if
#else
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c, pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then

#if (0==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_0d_text")
#endif
# 402 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_0d_text
! DIMS 0,1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 296 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_1d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:)
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen, itype
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1)
    integer :: start(1+1), count(1+1)
#ifdef TIMING
    call t_startf("PIO:pio_put_var_1d_text")
#endif
    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0


    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       xlen = len(ival)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
#if(1==0)
       call MPI_BCAST(ival,len_trim(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#else
       call MPI_BCAST(ival,size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
    	  count(1)=len(ival)
	  is=1
#if (1 > 0)
          do i=1,1
             count(i+is) = size(ival,i)
          end do
#endif
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(ios%io_rank>0) count = 0
          ierr = nfmpi_put_vara_text_all (File%fh, varid,int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
#if (1==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
!          if (Ios%io_rank == 0) then
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
!          else
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/0/), (/1/), ival)
!          end if
#else
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c, pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then

#if (1==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_1d_text")
#endif
# 402 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_1d_text
! DIMS 0,1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 296 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_2d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:)
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen, itype
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2)
    integer :: start(2+1), count(2+1)
#ifdef TIMING
    call t_startf("PIO:pio_put_var_2d_text")
#endif
    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0


    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       xlen = len(ival)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
#if(2==0)
       call MPI_BCAST(ival,len_trim(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#else
       call MPI_BCAST(ival,size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
    	  count(1)=len(ival)
	  is=1
#if (2 > 0)
          do i=1,2
             count(i+is) = size(ival,i)
          end do
#endif
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(ios%io_rank>0) count = 0
          ierr = nfmpi_put_vara_text_all (File%fh, varid,int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
#if (2==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
!          if (Ios%io_rank == 0) then
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
!          else
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/0/), (/1/), ival)
!          end if
#else
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c, pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then

#if (2==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_2d_text")
#endif
# 402 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_2d_text
! DIMS 0,1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 296 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_3d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:)
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen, itype
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3)
    integer :: start(3+1), count(3+1)
#ifdef TIMING
    call t_startf("PIO:pio_put_var_3d_text")
#endif
    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0


    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       xlen = len(ival)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
#if(3==0)
       call MPI_BCAST(ival,len_trim(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#else
       call MPI_BCAST(ival,size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
    	  count(1)=len(ival)
	  is=1
#if (3 > 0)
          do i=1,3
             count(i+is) = size(ival,i)
          end do
#endif
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(ios%io_rank>0) count = 0
          ierr = nfmpi_put_vara_text_all (File%fh, varid,int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
#if (3==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
!          if (Ios%io_rank == 0) then
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
!          else
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/0/), (/1/), ival)
!          end if
#else
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c, pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then

#if (3==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_3d_text")
#endif
# 402 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_3d_text
! DIMS 0,1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 296 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_4d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:,:)
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen, itype
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4)
    integer :: start(4+1), count(4+1)
#ifdef TIMING
    call t_startf("PIO:pio_put_var_4d_text")
#endif
    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0


    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       xlen = len(ival)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
#if(4==0)
       call MPI_BCAST(ival,len_trim(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#else
       call MPI_BCAST(ival,size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
    	  count(1)=len(ival)
	  is=1
#if (4 > 0)
          do i=1,4
             count(i+is) = size(ival,i)
          end do
#endif
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(ios%io_rank>0) count = 0
          ierr = nfmpi_put_vara_text_all (File%fh, varid,int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
#if (4==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
!          if (Ios%io_rank == 0) then
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
!          else
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/0/), (/1/), ival)
!          end if
#else
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c, pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then

#if (4==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_4d_text")
#endif
# 402 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_4d_text
! DIMS 0,1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 296 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_5d_text (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen, itype
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5)
    integer :: start(5+1), count(5+1)
#ifdef TIMING
    call t_startf("PIO:pio_put_var_5d_text")
#endif
    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0


    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       xlen = len(ival)
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
#if(5==0)
       call MPI_BCAST(ival,len_trim(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#else
       call MPI_BCAST(ival,size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
    	  count(1)=len(ival)
	  is=1
#if (5 > 0)
          do i=1,5
             count(i+is) = size(ival,i)
          end do
#endif
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(ios%io_rank>0) count = 0
          ierr = nfmpi_put_vara_text_all (File%fh, varid,int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
#if (5==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
!          if (Ios%io_rank == 0) then
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
!          else
!             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/0/), (/1/), ival)
!          end if
#else
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case( pio_iotype_netcdf,pio_iotype_netcdf4c, pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then

#if (5==0)
! This is a workaround for a bug in the netcdf f90 interface
! The netcdf bug is that when you use nf90_put_var
! to write a scalar string the trailing blanks are stripped by the specific
! function nf90_put_var_text before it calls nf_put_vars_text.
             ierr = nf_put_vars_text(File%fh, varid, (/1/), (/len(ival)/), (/1/), ival)
#else
             ierr = nf90_put_var(File%fh, varid, ival)
#endif
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_5d_text")
#endif
# 402 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_5d_text

! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_1d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1)
    integer :: start(1), count(1)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,1
          count(i) = size(ival,i)
       end do
       ierr = put_vara_1d_int (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_1d_int")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,1
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_int_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_1d_int")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_1d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_2d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2)
    integer :: start(2), count(2)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,2
          count(i) = size(ival,i)
       end do
       ierr = put_vara_2d_int (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_2d_int")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,2
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_int_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_2d_int")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_2d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_3d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3)
    integer :: start(3), count(3)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,3
          count(i) = size(ival,i)
       end do
       ierr = put_vara_3d_int (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_3d_int")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,3
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_int_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_3d_int")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_3d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_4d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4)
    integer :: start(4), count(4)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,4
          count(i) = size(ival,i)
       end do
       ierr = put_vara_4d_int (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_4d_int")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,4
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_int_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_4d_int")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_4d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_5d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5)
    integer :: start(5), count(5)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,5
          count(i) = size(ival,i)
       end do
       ierr = put_vara_5d_int (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_5d_int")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,5
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_int_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_5d_int")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_5d_int
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_1d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1)
    integer :: start(1), count(1)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,1
          count(i) = size(ival,i)
       end do
       ierr = put_vara_1d_real (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_1d_real")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,1
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_real_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_1d_real")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_1d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_2d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2)
    integer :: start(2), count(2)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,2
          count(i) = size(ival,i)
       end do
       ierr = put_vara_2d_real (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_2d_real")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,2
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_real_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_2d_real")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_2d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_3d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3)
    integer :: start(3), count(3)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,3
          count(i) = size(ival,i)
       end do
       ierr = put_vara_3d_real (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_3d_real")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,3
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_real_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_3d_real")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_3d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_4d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4)
    integer :: start(4), count(4)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,4
          count(i) = size(ival,i)
       end do
       ierr = put_vara_4d_real (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_4d_real")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,4
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_real_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_4d_real")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_4d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_5d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5)
    integer :: start(5), count(5)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,5
          count(i) = size(ival,i)
       end do
       ierr = put_vara_5d_real (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_5d_real")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,5
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_real_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_5d_real")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_5d_real
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_1d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1)
    integer :: start(1), count(1)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,1
          count(i) = size(ival,i)
       end do
       ierr = put_vara_1d_double (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_1d_double")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,1
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_double_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_1d_double")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_1d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_2d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2)
    integer :: start(2), count(2)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,2
          count(i) = size(ival,i)
       end do
       ierr = put_vara_2d_double (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_2d_double")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,2
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_double_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_2d_double")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_2d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_3d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3)
    integer :: start(3), count(3)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,3
          count(i) = size(ival,i)
       end do
       ierr = put_vara_3d_double (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_3d_double")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,3
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_double_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_3d_double")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_3d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_4d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4)
    integer :: start(4), count(4)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,4
          count(i) = size(ival,i)
       end do
       ierr = put_vara_4d_double (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_4d_double")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,4
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_double_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_4d_double")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_4d_double
! DIMS 1,2,3,4,5
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 417 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_5d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, itype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5)
    integer :: start(5), count(5)



    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 0
    is=0

#ifdef _PNETCDF
    if(iotype == pio_iotype_pnetcdf) then
       do i=1,5
          count(i) = size(ival,i)
       end do
       ierr = put_vara_5d_double (File, varid, start, count, ival)
       return
    end if
#endif
#ifdef TIMING
    call t_startf("PIO:pio_put_var_5d_double")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       if(Ios%io_rank==0) then
          do i=1,5
             count(i+is) = size(ival,i)
          end do
       end if
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_double_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_5d_double")
#endif
# 500 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_5d_double

! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 514 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_0d_int (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    integer(i4), intent(in) :: ival
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: start(1),count(1), itype

    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 1
    is=0

#ifdef TIMING
    call t_startf("PIO:pio_put_var_0d_int")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_int_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_0d_int")
#endif
# 576 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_0d_int
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 514 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_0d_real (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r4), intent(in) :: ival
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: start(1),count(1), itype

    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 1
    is=0

#ifdef TIMING
    call t_startf("PIO:pio_put_var_0d_real")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,1,MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_real_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_0d_real")
#endif
# 576 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_0d_real
! TYPE int,real,double
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param File : A file handle returne from \ref PIO_openfile or \ref PIO_createfile.
!! @param varid : The netcdf variable identifier
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 514 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_0d_double (File,varid, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid
    real(r8), intent(in) :: ival
    integer :: iotype
    integer :: i, is, msg, mpierr, xlen
    type(iosystem_desc_t), pointer :: ios
    integer :: start(1),count(1), itype

    ierr=PIO_NOERR

    iotype = File%iotype
    start = 1
    count = 1
    is=0

#ifdef TIMING
    call t_startf("PIO:pio_put_var_0d_double")
#endif

    ios=>File%iosystem
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVAR_0d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ival,1,MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if

    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          if(Ios%io_rank>0) count=0
          ierr = nfmpi_put_vara_double_all(File%fh, varid, int(start,kind=pio_offset),&
               int(count,kind=pio_offset),ival)
#endif
#ifdef _NETCDF
!       case(pio_iotype_netcdf4p)
!          ierr = nf90_put_var(File%fh, varid, ival)
       case( pio_iotype_netcdf,pio_iotype_netcdf4c,pio_iotype_netcdf4p)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival)
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified" )

       end select
    end if

    call check_netcdf(File,ierr,__PIO_FILE__,__LINE__)
#ifdef TIMING
    call t_stopf("PIO:pio_put_var_0d_double")
#endif
# 576 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_0d_double

! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_text (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_0d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_text (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_1d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_text (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_2d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_text (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_3d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_text (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_4d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_text (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    character(len=*), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_text (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_5d_text
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_real (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_0d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_real (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_1d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_real (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_2d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_real (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_3d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_real (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_4d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_real (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_real (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_5d_real
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_double (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_0d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_double (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_1d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_double (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_2d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_double (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_3d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_double (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_4d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_double (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    real(r8), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_double (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_5d_double
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_0d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival
    integer :: iotype

    ierr = put_var_0d_int (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_0d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_1d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:)
    integer :: iotype

    ierr = put_var_1d_int (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_1d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_2d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:)
    integer :: iotype

    ierr = put_var_2d_int (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_2d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_3d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:)
    integer :: iotype

    ierr = put_var_3d_int (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_3d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_4d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:,:)
    integer :: iotype

    ierr = put_var_4d_int (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_4d_int
! DIMS 0,1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 589 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_var_vdesc_5d_int (File, vardesc, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t) , intent(in) :: vardesc
    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype

    ierr = put_var_5d_int (File, vardesc%varid, ival)
# 596 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_var_vdesc_5d_int

! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 612 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_1d_text (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    character(len=*), intent(in) :: ival(:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_1d_text")
#endif
    ndims=0
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen = len(ival)
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if

    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count

    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
    end if




    if(Ios%IOProc) then
       allocate(pstart(ndims),pcount(ndims))
       if(Ios%io_rank==0) then
          pstart = start(1:ndims)
          pcount = count(1:ndims)
       else
          pstart=1 ! avoids an unessasary pnetcdf error
          pcount=0
       endif
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_text (File%fh, varid, pstart, &
                  pcount, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
             ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
                  pcount, ival)

#endif
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
       deallocate(pstart, pcount)
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_1d_text")
#endif
# 721 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_1d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 612 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_2d_text (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    character(len=*), intent(in) :: ival(:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_2d_text")
#endif
    ndims=0
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen = len(ival)
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if

    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count

    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
    end if




    if(Ios%IOProc) then
       allocate(pstart(ndims),pcount(ndims))
       if(Ios%io_rank==0) then
          pstart = start(1:ndims)
          pcount = count(1:ndims)
       else
          pstart=1 ! avoids an unessasary pnetcdf error
          pcount=0
       endif
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_text (File%fh, varid, pstart, &
                  pcount, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
             ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
                  pcount, ival)

#endif
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
       deallocate(pstart, pcount)
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_2d_text")
#endif
# 721 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_2d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 612 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_3d_text (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    character(len=*), intent(in) :: ival(:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_3d_text")
#endif
    ndims=0
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen = len(ival)
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if

    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count

    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
    end if




    if(Ios%IOProc) then
       allocate(pstart(ndims),pcount(ndims))
       if(Ios%io_rank==0) then
          pstart = start(1:ndims)
          pcount = count(1:ndims)
       else
          pstart=1 ! avoids an unessasary pnetcdf error
          pcount=0
       endif
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_text (File%fh, varid, pstart, &
                  pcount, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
             ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
                  pcount, ival)

#endif
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
       deallocate(pstart, pcount)
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_3d_text")
#endif
# 721 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_3d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 612 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_4d_text (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    character(len=*), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_4d_text")
#endif
    ndims=0
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen = len(ival)
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if

    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count

    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
    end if




    if(Ios%IOProc) then
       allocate(pstart(ndims),pcount(ndims))
       if(Ios%io_rank==0) then
          pstart = start(1:ndims)
          pcount = count(1:ndims)
       else
          pstart=1 ! avoids an unessasary pnetcdf error
          pcount=0
       endif
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_text (File%fh, varid, pstart, &
                  pcount, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
             ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
                  pcount, ival)

#endif
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
       deallocate(pstart, pcount)
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_4d_text")
#endif
# 721 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_4d_text
! DIMS 1,2,3,4,5
! TYPE text
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 612 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_5d_text (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    character(len=*), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_5d_text")
#endif
    ndims=0
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen = len(ival)
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if

    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count

    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = TYPETEXT
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
       call MPI_BCAST(xlen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_CHARACTER,ios%CompMaster, ios%my_comm , mpierr)
    end if




    if(Ios%IOProc) then
       allocate(pstart(ndims),pcount(ndims))
       if(Ios%io_rank==0) then
          pstart = start(1:ndims)
          pcount = count(1:ndims)
       else
          pstart=1 ! avoids an unessasary pnetcdf error
          pcount=0
       endif
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_text (File%fh, varid, pstart, &
                  pcount, ival)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
             ierr = nfmpi_put_vara_text_all (File%fh, varid, pstart, &
                  pcount, ival)

#endif
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=int(pstart), count=int(pcount))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
       deallocate(pstart, pcount)
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_5d_text")
#endif
# 721 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_5d_text
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_1d_int (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    integer(i4), intent(in) :: ival(:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_1d_int")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_int (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_INTEGER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_1d_int")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_1d_int
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_2d_int (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    integer(i4), intent(in) :: ival(:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_2d_int")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_int (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_INTEGER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_2d_int")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_2d_int
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_3d_int (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    integer(i4), intent(in) :: ival(:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_3d_int")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_int (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_INTEGER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_3d_int")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_3d_int
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_4d_int (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    integer(i4), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_4d_int")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_int (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_INTEGER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_4d_int")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_4d_int
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_5d_int (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    integer(i4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_5d_int")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 103
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_int (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_INTEGER)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_int_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_5d_int")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_5d_int
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_1d_real (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r4), intent(in) :: ival(:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_1d_real")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_real (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL4)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_1d_real")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_1d_real
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_2d_real (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r4), intent(in) :: ival(:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_2d_real")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_real (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL4)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_2d_real")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_2d_real
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_3d_real (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r4), intent(in) :: ival(:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_3d_real")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_real (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL4)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_3d_real")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_3d_real
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_4d_real (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r4), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_4d_real")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_real (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL4)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_4d_real")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_4d_real
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_5d_real (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r4), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_5d_real")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 101
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL4,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_real (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL4)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_real_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_5d_real")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_5d_real
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_1d_double (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r8), intent(in) :: ival(:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(1), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_1d_double")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_1d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (1 > 0)
       do i=1,1
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_double (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL8)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_1d_double")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_1d_double
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_2d_double (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r8), intent(in) :: ival(:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(2), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_2d_double")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_2d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (2 > 0)
       do i=1,2
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_double (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL8)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_2d_double")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_2d_double
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_3d_double (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r8), intent(in) :: ival(:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(3), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_3d_double")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_3d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (3 > 0)
       do i=1,3
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_double (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL8)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_3d_double")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_3d_double
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_4d_double (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r8), intent(in) :: ival(:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(4), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_4d_double")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_4d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (4 > 0)
       do i=1,4
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_double (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL8)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_4d_double")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_4d_double
! TYPE int,real,double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf attribute to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param varid : The netcdf variable identifier
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 736 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_5d_double (File,varid, start, count, ival) result(ierr)
    use nf_mod, only : pio_inq_varndims
    type (File_desc_t), intent(inout) :: File
    integer, intent(in) :: varid, start(:), count(:)

    integer(kind=PIO_OFFSET), allocatable :: pstart(:), pcount(:)

    real(r8), intent(in) :: ival(:,:,:,:,:)
    integer :: iotype, i, ndims, msg, mpierr
    integer(kind=pio_offset) :: clen
    type(iosystem_desc_t), pointer :: ios
    integer :: dims(5), xlen, itype, slen
#ifdef TIMING
    call t_startf("PIO:pio_put_vara_5d_double")
#endif
    ierr=0
    iotype = File%iotype
    ios=>File%iosystem
    xlen=1
    if(debug) print *,__PIO_FILE__,__LINE__,varid, iotype, start, count
    if(.not. ios%async_interface .or. .not. ios%ioproc ) then
       ierr = pio_inq_varndims(File, varid, ndims)
    end if
    if(ios%async_interface .and. .not. ios%ioproc ) then
       msg=PIO_MSG_PUTVARA_5d
       if(ios%comp_rank==0) call mpi_send(msg, 1, mpi_integer, ios%ioroot, 1, ios%union_comm, ierr)
       call MPI_BCAST(file%fh,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(varid,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       itype = 102
       call MPI_BCAST(itype,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       slen = size(start)
       call MPI_BCAST(slen,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(start,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(count,slen,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)

#if (5 > 0)
       do i=1,5
          dims(i)=size(ival,i)
       end do
       call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
#endif
    endif

    if(ios%async_interface ) then
       call MPI_BCAST(ndims,1,MPI_INTEGER,ios%CompMaster, ios%my_comm , mpierr)
       call MPI_BCAST(ival,xlen*size(ival),MPI_REAL8,ios%CompMaster, ios%my_comm , mpierr)
    end if



    if(Ios%IOProc) then
       select case (iotype)
#ifdef _PNETCDF
       case(pio_iotype_pnetcdf)
          allocate(pstart(ndims),pcount(ndims))
          if(Ios%io_rank==0) then
             pstart = start(1:ndims)
             pcount = count(1:ndims)
          else
             pstart=1 ! avoids an unessasary pnetcdf error
             pcount=0
          endif

          clen=count(1)
          do i=2,size(count)
             clen=clen*count(i)
          end do
#ifdef USE_INDEP_WRITE
          ierr = nfmpi_begin_indep_data(File%fh)
          if(Ios%io_rank==0 .and. (ierr==NF_EINDEP .or. ierr==PIO_NOERR)) then
             ierr = nfmpi_put_vara_double (File%fh, varid, pstart, &
                  pcount, ival, clen, MPI_REAL8)
          end if
          if(ierr==PIO_NOERR) then
             ierr = nfmpi_end_indep_data(File%fh)
          end if
#else
          ierr = nfmpi_put_vara_double_all (File%fh, varid, pstart, &
               pcount, ival)

#endif
          deallocate(pstart, pcount)
#endif
#ifdef _NETCDF
#ifdef _NETCDF4
       case(pio_iotype_netcdf4p)
          ierr=nf90_var_par_access(File%fh, varid, NF90_COLLECTIVE)
          ierr = nf90_put_var(File%fh, varid, ival, start=start, count=count)
#endif
       case(pio_iotype_netcdf, pio_iotype_netcdf4c)
          ! Only io proc 0 will do writing
          if (Ios%io_rank == 0) then
             ierr = nf90_put_var(File%fh, varid, ival, start=start(1:ndims), count=count(1:ndims))
          end if
#endif
       case default
          print *,__PIO_FILE__,__LINE__,iotype
          call piodie(__PIO_FILE__,__LINE__,"bad iotype specified")
       end select
    end if
    call check_netcdf(File, ierr,__PIO_FILE__,__LINE__)

#ifdef TIMING
    call t_stopf("PIO:pio_put_vara_5d_double")
#endif
# 841 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_5d_double

! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:)

    ierr = put_vara_1d_text (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:)

    ierr = put_vara_2d_text (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_text (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_text (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_text (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    character(len=*), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_text (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_text
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:)

    ierr = put_vara_1d_real (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:)

    ierr = put_vara_2d_real (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_real (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_real (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_real (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_real (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_real
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:)

    ierr = put_vara_1d_double (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:)

    ierr = put_vara_2d_double (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_double (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_double (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_double (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    real(r8), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_double (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_double
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_1d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:)

    ierr = put_vara_1d_int (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_1d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_2d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:)

    ierr = put_vara_2d_int (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_2d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_3d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:)

    ierr = put_vara_3d_int (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_3d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_4d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:,:)

    ierr = put_vara_4d_int (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_4d_int
! DIMS 1,2,3,4,5
!>
!! @public
!! @ingroup PIO_put_var
!! @brief Writes an netcdf variable to a file
!! @details
!! @param File @copydoc file_desc_t
!! @param vardesc @copydoc var_desc_t
!! @param start :
!! @param count :
!! @param ival : The value for the netcdf metadata
!! @retval ierr @copydoc error_return
!<
# 856 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  integer function put_vara_vdesc_5d_int (File,vardesc, start, count, ival) result(ierr)
    type (File_desc_t), intent(inout) :: File
    type(var_desc_t), intent(in) :: vardesc
    integer, intent(in) ::  start(:), count(:)
    integer(i4), intent(in) :: ival(:,:,:,:,:)

    ierr = put_vara_5d_int (File, vardesc%varid, start, count, ival)


# 865 "/opt/ncar/cesm/cime/src/externals/pio1/pio/pionfput_mod.F90.in"
  end function put_vara_vdesc_5d_int
end module pionfput_mod
