!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! WARNING: this file was automatically generated on
! Fri, 11 May 2018 19:36:06 +0000
! from ncdf_template.F90.in
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! WJS (1-30-12): The following (turning optimization off) is needed as a workaround for an
! xlf compiler bug, at least in IBM XL Fortran for AIX, V12.1 on bluefire
#ifdef CPRIBM
@PROCESS OPT(0)
#endif

!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!                                                             
!   ncdf_template.F90.in - part of the Community Ice Sheet Model (CISM)  
!                                                              
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
!
!   Copyright (C) 2005-2018
!   CISM contributors - see AUTHORS file for list of contributors
!
!   This file is part of CISM.
!
!   CISM is free software: you can redistribute it and/or modify it
!   under the terms of the Lesser GNU General Public License as published
!   by the Free Software Foundation, either version 3 of the License, or
!   (at your option) any later version.
!
!   CISM is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   Lesser GNU General Public License for more details.
!
!   You should have received a copy of the Lesser GNU General Public License
!   along with CISM. If not, see <http://www.gnu.org/licenses/>.
!
!+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#define NCO outfile%nc
#define NCI infile%nc


module glint_mbal_io
  ! template for creating subsystem specific I/O routines
  ! written by Magnus Hagdorn, 2004

  use glint_type
  use glimmer_ncdf

  implicit none

  private :: get_xtype, is_enabled, is_enabled_0dint, is_enabled_1dint, &
       is_enabled_2dint, is_enabled_0dreal, is_enabled_1dreal, is_enabled_2dreal, is_enabled_3dreal

  character(glimmer_nc_vars_len), save :: restart_variable_list=''    ! list of variables needed for a restart

  interface is_enabled  ! MJH 10/21/13: Interface needed for determining if arrays have been enabled.  See notes below in glint_mbal_io_create.
    module procedure is_enabled_0dint
    module procedure is_enabled_1dint
    module procedure is_enabled_2dint
    module procedure is_enabled_0dreal
    module procedure is_enabled_1dreal
    module procedure is_enabled_2dreal
    module procedure is_enabled_3dreal
  end interface is_enabled

contains

  !*****************************************************************************
  ! netCDF output
  !*****************************************************************************
  subroutine glint_mbal_io_createall(model,data,outfiles)
    ! open all netCDF files for output
    use glint_type
    use glide_types
    use glimmer_ncio
    implicit none
    type(glide_global_type) :: model
    type(glint_instance) :: data ! MJH 10/21/13: Making 'data' mandatory.  See notes below in glint_mbal_io_create
    type(glimmer_nc_output),optional,pointer :: outfiles
    
    ! local variables
    type(glimmer_nc_output), pointer :: oc

    if (present(outfiles)) then
       oc => outfiles
    else
       oc=>model%funits%out_first
    end if

    do while(associated(oc))
       call glint_mbal_io_create(oc,model,data)
       oc=>oc%next
    end do
  end subroutine glint_mbal_io_createall

  subroutine glint_mbal_io_writeall(data,model,atend,outfiles,time)
    ! if necessary write to netCDF files
    use glint_type
    use glide_types
    use glimmer_ncio
    implicit none
    type(glint_instance) :: data
    type(glide_global_type) :: model
    logical, optional :: atend
    type(glimmer_nc_output),optional,pointer :: outfiles
    real(dp),optional :: time

    ! local variables
    type(glimmer_nc_output), pointer :: oc
    logical :: forcewrite=.false.

    if (present(outfiles)) then
       oc => outfiles
    else
       oc=>model%funits%out_first
    end if

    if (present(atend)) then
       forcewrite = atend
    end if

    do while(associated(oc))
#ifdef HAVE_AVG
       if (oc%do_averages) then
          call glint_mbal_avg_accumulate(oc,data,model)
       end if
#endif
       call glimmer_nc_checkwrite(oc,model,forcewrite,time)
       if (oc%nc%just_processed) then
          ! write standard variables
          call glint_mbal_io_write(oc,data)
#ifdef HAVE_AVG
          if (oc%do_averages) then
             call glint_mbal_avg_reset(oc,data)
          end if
#endif
       end if
       oc=>oc%next
    end do
  end subroutine glint_mbal_io_writeall
  
  subroutine glint_mbal_io_create(outfile,model,data)
    use parallel
    use glide_types
    use glint_type
    use glimmer_ncio
    use glimmer_map_types
    use glimmer_log
    use glimmer_paramets
    use glimmer_scales
    use glimmer_log
    implicit none
    type(glimmer_nc_output), pointer :: outfile
    type(glide_global_type) :: model
    type(glint_instance) :: data    ! MJH 10/21/13: Making 'data' mandatory.  See note below

    integer status,varid,pos

    ! MJH 10/21/13: Local variables needed for checking if a variable is enabled.
    real(dp) :: tavgf
    integer :: up

    integer :: level_dimid
    integer :: lithoz_dimid
    integer :: staglevel_dimid
    integer :: stagwbndlevel_dimid
    integer :: time_dimid
    integer :: x0_dimid
    integer :: x1_dimid
    integer :: y0_dimid
    integer :: y1_dimid

    ! defining dimensions
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'level',model%general%upn,level_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'level',level_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'lithoz',model%lithot%nlayer,lithoz_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'lithoz',lithoz_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'staglevel',model%general%upn-1,staglevel_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'staglevel',staglevel_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'stagwbndlevel',model%general%upn+1,stagwbndlevel_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'stagwbndlevel',stagwbndlevel_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    status = parallel_inq_dimid(NCO%id,'time',time_dimid)
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'x0',global_ewn-1,x0_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'x0',x0_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'x1',global_ewn,x1_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'x1',x1_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'y0',global_nsn-1,y0_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'y0',y0_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)
    if (.not.outfile%append) then
       status = parallel_def_dim(NCO%id,'y1',global_nsn,y1_dimid)
    else
       status = parallel_inq_dimid(NCO%id,'y1',y1_dimid)
    endif
    call nc_errorhandle(__FILE__,__LINE__,status)

    ! Expanding restart variables: if 'restart' or 'hot' is present, we remove that
    ! word from the variable list, and flip the restartfile flag.  
    ! In CISM 2.0, 'restart' is the preferred name to represent restart variables, 
    ! but 'hot' is supported for backward compatibility.  Thus, we check for both.
    NCO%vars = ' '//trim(adjustl(NCO%vars))//' '  ! Need to maintain a space at beginning and end of list
    ! expanding restart variables
    pos = index(NCO%vars,' restart ') 
    if (pos.ne.0) then
       NCO%vars = NCO%vars(:pos)//NCO%vars(pos+8:)
       NCO%restartfile = .true.
    end if
    pos = index(NCO%vars,' hot ') 
    if (pos.ne.0) then
       NCO%vars = NCO%vars(:pos)//NCO%vars(pos+4:)
       NCO%restartfile = .true.
    end if
    ! Now apply necessary changes if the file is a restart file.
    if (NCO%restartfile) then
       if ((len_trim(NCO%vars) + len_trim(restart_variable_list) + 2) >= len(NCO%vars) ) then
          call write_log('Adding restart variables has made the list of output variables too long for file ' // NCO%filename, &
               GM_FATAL)
       else
          ! Expand the restart variable list 
          ! Need to maintain a space at beginning and end of list
          NCO%vars = trim(NCO%vars) // ' ' // trim(restart_variable_list) // ' ' ! (a module variable)  
          ! Set the xtype to be double (required for an exact restart)
          outfile%default_xtype = NF90_DOUBLE   
       endif
    end if

    ! Convert temp and flwa to versions on stag grid, if needed
    ! Note: this check must occur after restart variables are expanded which happens in glimmer_nc_readparams
    call check_for_tempstag(model%options%whichdycore,NCO)

    ! checking if we need to handle time averages
    pos = index(NCO%vars,"_tavg")
    if (pos.ne.0) then
       outfile%do_averages = .True.
    end if    

    ! Now that the output variable list is finalized, make sure we aren't truncating what the user intends to be output.
    ! Note: this only checks that the text in the variable list does not extend to within one character of the end of the variable.
    ! It does not handle the case where the user exactly fills the allowable length with variables or has a too-long list with more than one space between variable names.
    if ((len_trim(NCO%vars) + 1 ) >= len(NCO%vars)) then 
       call write_log('The list of output variables is too long for file ' // NCO%filename, GM_FATAL)
    endif


    ! MJH, 10/21/13: In the auto-generated code below, the creation of each output variable is wrapped by a check if the data for that 
    !   variable has a size greater than 0.  This is because of recently added checks in glide_types.F90 that don't fully allocate
    !   some variables if certain model options are disabled.  This is to lower memory requirements while running the model.
    !   The reason they have to be allocated with size zero rather than left unallocated is because the data for
    !   some netCDF output variables is defined with math, which causes an error if the operands are unallocated.
    !   Note that if a variable is not created, then it will not be subsequently written to.
    !   Also note that this change requires that data be a mandatory argument to this subroutine.

    ! Some output variables will need tavgf.  The value does not matter, but it must exist.  
    ! Nonetheless, for completeness give it the proper value that it has in glint_mbal_io_write.
    tavgf = outfile%total_time
    if (tavgf.ne.0.d0) then
       tavgf = 1.d0/tavgf
    end if
    ! Similarly, some output variables use the variable up.  Give it value of 0 here.
    up = 0

    !     level -- sigma layers
    if (.not.outfile%append) then
       call write_log('Creating variable level')
       status = parallel_def_var(NCO%id,'level',get_xtype(outfile,NF90_FLOAT), &
            (/level_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'formula_terms', &
            'sigma: level topo: topg thick: thk')
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'sigma layers')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'land_ice_sigma_coordinate')
       status = parallel_put_att(NCO%id, varid, 'units', &
            '1')
     end if

    !     lithoz -- vertical coordinate of lithosphere layer
    if (.not.outfile%append) then
       call write_log('Creating variable lithoz')
       status = parallel_def_var(NCO%id,'lithoz',get_xtype(outfile,NF90_FLOAT), &
            (/lithoz_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'vertical coordinate of lithosphere layer')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
     end if

    !     staglevel -- stag sigma layers
    if (.not.outfile%append) then
       call write_log('Creating variable staglevel')
       status = parallel_def_var(NCO%id,'staglevel',get_xtype(outfile,NF90_FLOAT), &
            (/staglevel_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'positive', &
            'down')
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'stag sigma layers')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'land_ice_stag_sigma_coordinate')
       status = parallel_put_att(NCO%id, varid, 'units', &
            '1')
     end if

    !     stagwbndlevel -- stag sigma layers with boundaries
    if (.not.outfile%append) then
       call write_log('Creating variable stagwbndlevel')
       status = parallel_def_var(NCO%id,'stagwbndlevel',get_xtype(outfile,NF90_FLOAT), &
            (/stagwbndlevel_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'positive', &
            'down')
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'stag sigma layers with boundaries')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'land_ice_stag_sigma_coordinate_with_bnd')
       status = parallel_put_att(NCO%id, varid, 'units', &
            '1')
     end if

    !     x0 -- Cartesian x-coordinate, velocity grid
    if (.not.outfile%append) then
       call write_log('Creating variable x0')
       status = parallel_def_var(NCO%id,'x0',get_xtype(outfile,NF90_FLOAT), &
            (/x0_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'Cartesian x-coordinate, velocity grid')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'projection_x_coordinate')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
     end if

    !     x1 -- Cartesian x-coordinate
    if (.not.outfile%append) then
       call write_log('Creating variable x1')
       status = parallel_def_var(NCO%id,'x1',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'Cartesian x-coordinate')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'projection_x_coordinate')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
     end if

    !     y0 -- Cartesian y-coordinate, velocity grid
    if (.not.outfile%append) then
       call write_log('Creating variable y0')
       status = parallel_def_var(NCO%id,'y0',get_xtype(outfile,NF90_FLOAT), &
            (/y0_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'Cartesian y-coordinate, velocity grid')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'projection_y_coordinate')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
     end if

    !     y1 -- Cartesian y-coordinate
    if (.not.outfile%append) then
       call write_log('Creating variable y1')
       status = parallel_def_var(NCO%id,'y1',get_xtype(outfile,NF90_FLOAT), &
            (/y1_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'Cartesian y-coordinate')
       status = parallel_put_att(NCO%id, varid, 'standard_name', &
            'projection_y_coordinate')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
     end if

    !     instant_ablt -- instantaneous ablation
    pos = index(NCO%vars,' instant_ablt ')
    status = parallel_inq_varid(NCO%id,'instant_ablt',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+12) = '            '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%ablt)) then
       call write_log('Creating variable instant_ablt')
       status = parallel_def_var(NCO%id,'instant_ablt',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous ablation')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_ablt was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_acab -- instantaneous mass-balance
    pos = index(NCO%vars,' instant_acab ')
    status = parallel_inq_varid(NCO%id,'instant_acab',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+12) = '            '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%acab)) then
       call write_log('Creating variable instant_acab')
       status = parallel_def_var(NCO%id,'instant_acab',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous mass-balance')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_acab was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_artm -- instantaneous air temperature
    pos = index(NCO%vars,' instant_artm ')
    status = parallel_inq_varid(NCO%id,'instant_artm',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+12) = '            '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%artm)) then
       call write_log('Creating variable instant_artm')
       status = parallel_def_var(NCO%id,'instant_artm',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous air temperature')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'degC')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_artm was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_humidity -- instantaneous humidity
    pos = index(NCO%vars,' instant_humidity ')
    status = parallel_inq_varid(NCO%id,'instant_humidity',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+16) = '                '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%humidity)) then
       call write_log('Creating variable instant_humidity')
       status = parallel_def_var(NCO%id,'instant_humidity',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous humidity')
       status = parallel_put_att(NCO%id, varid, 'units', &
            '1')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_humidity was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_lwdown -- instantaneous lw down
    pos = index(NCO%vars,' instant_lwdown ')
    status = parallel_inq_varid(NCO%id,'instant_lwdown',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+14) = '              '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%lwdown)) then
       call write_log('Creating variable instant_lwdown')
       status = parallel_def_var(NCO%id,'instant_lwdown',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous lw down')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'W/m2')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_lwdown was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_prcp -- instantaneous precip
    pos = index(NCO%vars,' instant_prcp ')
    status = parallel_inq_varid(NCO%id,'instant_prcp',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+12) = '            '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%prcp)) then
       call write_log('Creating variable instant_prcp')
       status = parallel_def_var(NCO%id,'instant_prcp',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous precip')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_prcp was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_psurf -- instantaneous surface pressure
    pos = index(NCO%vars,' instant_psurf ')
    status = parallel_inq_varid(NCO%id,'instant_psurf',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+13) = '             '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%psurf)) then
       call write_log('Creating variable instant_psurf')
       status = parallel_def_var(NCO%id,'instant_psurf',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous surface pressure')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'Pa')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_psurf was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_siced -- superimposed ice depth
    pos = index(NCO%vars,' instant_siced ')
    status = parallel_inq_varid(NCO%id,'instant_siced',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+13) = '             '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%siced)) then
       call write_log('Creating variable instant_siced')
       status = parallel_def_var(NCO%id,'instant_siced',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'superimposed ice depth')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_siced was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_snowd -- snow depth
    pos = index(NCO%vars,' instant_snowd ')
    status = parallel_inq_varid(NCO%id,'instant_snowd',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+13) = '             '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%snowd)) then
       call write_log('Creating variable instant_snowd')
       status = parallel_def_var(NCO%id,'instant_snowd',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'snow depth')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'meter')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_snowd was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_swdown -- instantaneous sw down
    pos = index(NCO%vars,' instant_swdown ')
    status = parallel_inq_varid(NCO%id,'instant_swdown',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+14) = '              '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%swdown)) then
       call write_log('Creating variable instant_swdown')
       status = parallel_def_var(NCO%id,'instant_swdown',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous sw down')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'W/m2')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_swdown was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_xwind -- instantaneous x-wind
    pos = index(NCO%vars,' instant_xwind ')
    status = parallel_inq_varid(NCO%id,'instant_xwind',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+13) = '             '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%xwind)) then
       call write_log('Creating variable instant_xwind')
       status = parallel_def_var(NCO%id,'instant_xwind',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous x-wind')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'm/s')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_xwind was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

    !     instant_ywind -- instantaneous y-wind
    pos = index(NCO%vars,' instant_ywind ')
    status = parallel_inq_varid(NCO%id,'instant_ywind',varid)
    if (pos.ne.0) then
      NCO%vars(pos+1:pos+13) = '             '
    end if
    if (pos.ne.0 .and. status.eq.nf90_enotvar) then
    if (is_enabled(data%mbal_accum%ywind)) then
       call write_log('Creating variable instant_ywind')
       status = parallel_def_var(NCO%id,'instant_ywind',get_xtype(outfile,NF90_FLOAT), &
            (/x1_dimid, y1_dimid, time_dimid/),varid)
       call nc_errorhandle(__FILE__,__LINE__,status)
       status = parallel_put_att(NCO%id, varid, 'long_name', &
            'instantaneous y-wind')
       status = parallel_put_att(NCO%id, varid, 'units', &
            'm/s')
       if (glimmap_allocated(model%projection)) then
          status = parallel_put_att(NCO%id, varid, 'grid_mapping',glimmer_nc_mapvarname)
          status = parallel_put_att(NCO%id, varid, 'coordinates', 'lon lat')
       end if
     else
     call write_log('Variable instant_ywind was specified for output but it is &
          &inappropriate for your config settings.  It will be excluded from the output.', GM_WARNING)
     end if
     end if

  end subroutine glint_mbal_io_create

  subroutine glint_mbal_io_write(outfile,data)
    use parallel
    use glint_type
    use glimmer_paramets
    use glimmer_scales
    implicit none
    type(glimmer_nc_output), pointer :: outfile
    ! structure containg output netCDF descriptor
    type(glint_instance) :: data
    ! the model instance

    ! local variables
    real(dp) :: tavgf
    integer status, varid
    integer up
     
    tavgf = outfile%total_time
    if (tavgf.ne.0.d0) then
       tavgf = 1.d0/tavgf
    end if

    ! write variables
    status = parallel_inq_varid(NCO%id,'instant_ablt',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%ablt, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_acab',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%acab, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_artm',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%artm, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_humidity',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%humidity, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_lwdown',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%lwdown, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_prcp',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%prcp, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_psurf',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%psurf, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_siced',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%siced, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_snowd',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%snowd, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_swdown',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%swdown, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_xwind',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%xwind, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

    status = parallel_inq_varid(NCO%id,'instant_ywind',varid)
    if (status .eq. nf90_noerr) then
       status = distributed_put_var(NCO%id, varid, &
            data%mbal_accum%ywind, (/1,1,outfile%timecounter/))
       call nc_errorhandle(__FILE__,__LINE__,status)
    end if

  end subroutine glint_mbal_io_write


  subroutine glint_mbal_add_to_restart_variable_list(vars_to_add)
    ! This subroutine adds variables to the list of variables needed for a restart.
    ! It is a public subroutine that allows other parts of the model to modify the list, 
    ! which is a module level variable.   MJH 1/17/2013

    use glimmer_log
    implicit none

    !------------------------------------------------------------------------------------
    ! Subroutine arguments
    !------------------------------------------------------------------------------------
    character(len=*), intent (in) :: vars_to_add  ! list of variable(s) to be added to the list of restart variables 
    !character(*), intent (inout) :: restart_variable_list  ! list of variables needed to perform an exact restart - module variable

    !------------------------------------------------------------------------------------
    ! Internal variables
    !------------------------------------------------------------------------------------

    !------------------------------------------------------------------------------------

    ! Add the variables to the list so long as they don't make the list too long.
    if ( (len_trim(restart_variable_list) + 1 + len_trim(vars_to_add)) > len(restart_variable_list)) then
       call write_log('Adding restart variables has made the restart variable list too long.',GM_FATAL)
    else
       restart_variable_list = trim(adjustl(restart_variable_list)) // ' ' // trim(vars_to_add)
       !call write_log('Adding to glint_mbal restart variable list: ' // trim(vars_to_add) )
    endif

  end subroutine glint_mbal_add_to_restart_variable_list


  ! Functions for the interface 'is_enabled'.  These are needed by the auto-generated code in glint_mbal_io_create
  !   to determine if a variable is 'turned on', and should be written.

  function is_enabled_0dint(var)
    integer, intent(in) :: var
    logical :: is_enabled_0dint
    is_enabled_0dint = .true.  ! scalars are always enabled
    return
  end function is_enabled_0dint

  function is_enabled_1dint(var)
    integer, dimension(:), pointer, intent(in) :: var
    logical :: is_enabled_1dint
    if (associated(var)) then
      is_enabled_1dint = .true.
    else
      is_enabled_1dint = .false.
    endif
    return
  end function is_enabled_1dint

  function is_enabled_2dint(var)
    integer, dimension(:,:), pointer, intent(in) :: var
    logical :: is_enabled_2dint
    if (associated(var)) then
      is_enabled_2dint = .true.
    else
      is_enabled_2dint = .false.
    endif
    return
  end function is_enabled_2dint

  function is_enabled_0dreal(var)
    real(dp), intent(in) :: var
    logical :: is_enabled_0dreal
    is_enabled_0dreal = .true.  ! scalars are always enabled
    return
  end function is_enabled_0dreal

  function is_enabled_1dreal(var)
    real(dp), dimension(:), pointer, intent(in) :: var
    logical :: is_enabled_1dreal
    if (associated(var)) then
      is_enabled_1dreal = .true.
    else
      is_enabled_1dreal = .false.
    endif
    return
  end function is_enabled_1dreal

  function is_enabled_2dreal(var)
    real(dp), dimension(:,:), pointer, intent(in) :: var
    logical :: is_enabled_2dreal
    if (associated(var)) then
      is_enabled_2dreal = .true.
    else
      is_enabled_2dreal = .false.
    endif
    return
  end function is_enabled_2dreal

  function is_enabled_3dreal(var)
    real(dp), dimension(:,:,:), pointer, intent(in) :: var
    logical :: is_enabled_3dreal
    if (associated(var)) then
      is_enabled_3dreal = .true.
    else
      is_enabled_3dreal = .false.
    endif
    return
  end function is_enabled_3dreal


  !*****************************************************************************
  ! netCDF input
  !*****************************************************************************  
  subroutine glint_mbal_io_readall(data, model, filetype)
    ! read from netCDF file
    use glint_type
    use glide_types
    use glimmer_ncio
    implicit none
    type(glint_instance) :: data
    type(glide_global_type) :: model
    integer, intent(in), optional :: filetype  ! 0 for input, 1 for forcing; defaults to input

    ! local variables
    type(glimmer_nc_input), pointer :: ic
    integer :: filetype_local

    if (present(filetype)) then
      filetype_local = filetype
    else
      filetype_local = 0 ! default to input type
    end if

    if (filetype_local == 0) then
      ic=>model%funits%in_first
    else
      ic=>model%funits%frc_first
    endif
    do while(associated(ic))
       call glimmer_nc_checkread(ic,model)
       if (ic%nc%just_processed) then
          call glint_mbal_io_read(ic,data)
       end if
       ic=>ic%next
    end do
  end subroutine glint_mbal_io_readall


  subroutine glint_mbal_read_forcing(data, model)
    ! Read data from forcing files
    use glimmer_log
    use glide_types

    implicit none
    type(glint_instance) :: data
    type(glide_global_type), intent(inout) :: model

    ! Locals
    type(glimmer_nc_input), pointer :: ic
    integer :: t
    real(dp) :: eps ! a tolerance to use for stepwise constant forcing

    ! Make eps a fraction of the time step.
    eps = model%numerics%tinc * 1.0d-4

    ! read forcing files
    ic=>model%funits%frc_first
    do while(associated(ic))

       !print *, 'possible forcing times', ic%times

       ic%nc%just_processed = .true. ! until we find an acceptable time, set this to true which will prevent the file from being read.
       ! Find the current time in the file
       do t = ic%nt, 1, -1  ! look through the time array backwards
          if ( ic%times(t) <= model%numerics%time + eps) then
            ! use the largest time that is smaller or equal to the current time (stepwise forcing)

            ! Set the desired time to be read
            ic%current_time = t
            ic%nc%just_processed = .false.  ! set this to false so file will be read.
            !print *, 'time, forcing index, forcing time', model%numerics%time, ic%current_time, ic%times(ic%current_time)
            exit  ! once we find the time, exit the loop
          endif
          end do  ! if we get to end of loop without exiting, then this file will not be read at this time.

       ! move on to the next forcing file
       ic=>ic%next
    end do

    ! Now that we've updated metadata for each forcing file, actually perform the read.
    ! This call will only read forcing files where just_processed=.false.
    call glint_mbal_io_readall(data, model, filetype=1)

  end subroutine glint_mbal_read_forcing


!------------------------------------------------------------------------------


  subroutine glint_mbal_io_read(infile,data)
    ! read variables from a netCDF file
    use parallel
    use glimmer_log
    use glint_type
    use glimmer_paramets
    use glimmer_scales
    implicit none
    type(glimmer_nc_input), pointer :: infile
    ! structure containg output netCDF descriptor
    type(glint_instance) :: data
    ! the model instance

    ! local variables
    integer status,varid
    integer up
    real(dp) :: scaling_factor

    ! read variables
  end subroutine glint_mbal_io_read

  subroutine glint_mbal_io_checkdim(infile,model,data)
    ! check if dimension sizes in file match dims of model
    use parallel
    use glimmer_log
    use glide_types
    use glint_type
    implicit none
    type(glimmer_nc_input), pointer :: infile
    ! structure containg output netCDF descriptor
    type(glide_global_type) :: model
    type(glint_instance), optional :: data

    integer status,dimid,dimsize
    character(len=150) message

    ! check dimensions
    status = parallel_inq_dimid(NCI%id,'level',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.model%general%upn) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size level does not match: ', &
               model%general%upn
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'lithoz',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.model%lithot%nlayer) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size lithoz does not match: ', &
               model%lithot%nlayer
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'staglevel',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.model%general%upn-1) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size staglevel does not match: ', &
               model%general%upn-1
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'stagwbndlevel',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.model%general%upn+1) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size stagwbndlevel does not match: ', &
               model%general%upn+1
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'x0',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.global_ewn-1) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size x0 does not match: ', &
               global_ewn-1
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'x1',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.global_ewn) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size x1 does not match: ', &
               global_ewn
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'y0',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.global_nsn-1) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size y0 does not match: ', &
               global_nsn-1
          call write_log(message,GM_FATAL)
       end if
    end if
    status = parallel_inq_dimid(NCI%id,'y1',dimid)
    if (dimid.gt.0) then
       status = parallel_inquire_dimension(NCI%id,dimid,len=dimsize)
       if (dimsize.ne.global_nsn) then
          write(message,*) 'Error, reading file ',trim(NCI%filename),' size y1 does not match: ', &
               global_nsn
          call write_log(message,GM_FATAL)
       end if
    end if
  end subroutine glint_mbal_io_checkdim

  !*****************************************************************************
  ! calculating time averages
  !*****************************************************************************  
#ifdef HAVE_AVG
  subroutine glint_mbal_avg_accumulate(outfile,data,model)

    ! Accumulate time averages for 'tavg' variables
    ! NOTE: This subroutine works for tavg variables that are written to exactly one output file.
    !       If we try to write tavg variables to multiple output files, the accumulated values
    !        will be too large, because this subroutine will be called more than once per time step.
    ! TODO: Write code to check for doubly listed tavg variables and throw a fatal error.

    use parallel
    use glide_types
    use glint_type
    implicit none
    type(glimmer_nc_output), pointer :: outfile
    ! structure containg output netCDF descriptor
    type(glide_global_type) :: model
    type(glint_instance) :: data

    ! local variables
    real(dp) :: factor
    integer status, varid

    ! increase total time
    outfile%total_time = outfile%total_time + model%numerics%tinc
    factor = model%numerics%tinc

  end subroutine glint_mbal_avg_accumulate

  subroutine glint_mbal_avg_reset(outfile,data)
    use parallel
    use glint_type
    implicit none
    type(glimmer_nc_output), pointer :: outfile
    ! structure containg output netCDF descriptor
    type(glint_instance) :: data

    ! local variables
    integer status, varid

    ! reset total time
    outfile%total_time = 0.d0

  end subroutine glint_mbal_avg_reset
#endif

  !*********************************************************************
  ! some private procedures
  !*********************************************************************

  !> apply default type to be used in netCDF file
  integer function get_xtype(outfile,xtype)
    implicit none
    type(glimmer_nc_output), pointer :: outfile !< derived type holding information about output file
    integer, intent(in) :: xtype                !< the external netCDF type

    get_xtype = xtype
    
    if (xtype.eq.NF90_REAL .and. outfile%default_xtype.eq.NF90_DOUBLE) then
       get_xtype = NF90_DOUBLE
    end if
    if (xtype.eq.NF90_DOUBLE .and. outfile%default_xtype.eq.NF90_REAL) then
       get_xtype = NF90_REAL
    end if
  end function get_xtype

  !*********************************************************************
  ! lots of accessor subroutines follow
  !*********************************************************************
  subroutine glint_mbal_get_instant_ablt(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%ablt
  end subroutine glint_mbal_get_instant_ablt

  subroutine glint_mbal_set_instant_ablt(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%ablt = inarray
  end subroutine glint_mbal_set_instant_ablt

  subroutine glint_mbal_get_instant_acab(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%acab
  end subroutine glint_mbal_get_instant_acab

  subroutine glint_mbal_set_instant_acab(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%acab = inarray
  end subroutine glint_mbal_set_instant_acab

  subroutine glint_mbal_get_instant_artm(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%artm
  end subroutine glint_mbal_get_instant_artm

  subroutine glint_mbal_set_instant_artm(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%artm = inarray
  end subroutine glint_mbal_set_instant_artm

  subroutine glint_mbal_get_instant_humidity(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%humidity
  end subroutine glint_mbal_get_instant_humidity

  subroutine glint_mbal_set_instant_humidity(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%humidity = inarray
  end subroutine glint_mbal_set_instant_humidity

  subroutine glint_mbal_get_instant_lwdown(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%lwdown
  end subroutine glint_mbal_get_instant_lwdown

  subroutine glint_mbal_set_instant_lwdown(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%lwdown = inarray
  end subroutine glint_mbal_set_instant_lwdown

  subroutine glint_mbal_get_instant_prcp(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%prcp
  end subroutine glint_mbal_get_instant_prcp

  subroutine glint_mbal_set_instant_prcp(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%prcp = inarray
  end subroutine glint_mbal_set_instant_prcp

  subroutine glint_mbal_get_instant_psurf(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%psurf
  end subroutine glint_mbal_get_instant_psurf

  subroutine glint_mbal_set_instant_psurf(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%psurf = inarray
  end subroutine glint_mbal_set_instant_psurf

  subroutine glint_mbal_get_instant_siced(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%siced
  end subroutine glint_mbal_get_instant_siced

  subroutine glint_mbal_set_instant_siced(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%siced = inarray
  end subroutine glint_mbal_set_instant_siced

  subroutine glint_mbal_get_instant_snowd(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%snowd
  end subroutine glint_mbal_get_instant_snowd

  subroutine glint_mbal_set_instant_snowd(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%snowd = inarray
  end subroutine glint_mbal_set_instant_snowd

  subroutine glint_mbal_get_instant_swdown(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%swdown
  end subroutine glint_mbal_get_instant_swdown

  subroutine glint_mbal_set_instant_swdown(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%swdown = inarray
  end subroutine glint_mbal_set_instant_swdown

  subroutine glint_mbal_get_instant_xwind(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%xwind
  end subroutine glint_mbal_get_instant_xwind

  subroutine glint_mbal_set_instant_xwind(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%xwind = inarray
  end subroutine glint_mbal_set_instant_xwind

  subroutine glint_mbal_get_instant_ywind(data,outarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(out) :: outarray

    outarray = data%mbal_accum%ywind
  end subroutine glint_mbal_get_instant_ywind

  subroutine glint_mbal_set_instant_ywind(data,inarray)
    use glimmer_scales
    use glimmer_paramets
    use glint_type
    implicit none
    type(glint_instance) :: data
    real(dp), dimension(:,:), intent(in) :: inarray

    data%mbal_accum%ywind = inarray
  end subroutine glint_mbal_set_instant_ywind


end module glint_mbal_io
