;=============================================================
; read in paleo rawdata that contains latixy, longxy, and 
; landmask and write out land fraction file...to be used in 
; mksurfdata only and is on the clm grid only.
;
; note: this is NOT the coupled atm-ocn fractional data file
; created using mkgriddata and this file is NOT used in
; the clm namelist for the coupled system. 
;
; cshields may 2010
;=============================================================


load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"


begin

;============== set parameters

frawdata =  "mksrf_soicol_paleo.nc"
ncfile   = "mksrf_ffrac_paleo_PERIOD.nc" ; output
write_nc = 1  ; 0 = no, 1 = yes

;==================> read data

fraw = addfile(frawdata,"r")

latixy  = fraw->LATIXY
longxy  = fraw->LONGXY
landmask = fraw->LANDMASK

;==================> create fractional land data
;old version of code...did this in on the fly in ccsm3)
;can read in old ccsm3 landfrac file, or set landfrac = landmask

landfrac = landmask


;===================> create numlon

dims = dimsizes(latixy)
nlat = dims(0)  
nlon = dims(1)
print("nlat = "+ nlat)
print("nlon = "+ nlon)

numlon = new(nlat,integer)
do n = 0,nlat-1
   numlon(n) =  nlon
end do
print(numlon)


;====== put landmask into integer format
landmask_int = floattoint(landmask)

;====== write netcdf file

if(write_nc.eq.1)then

system("rm "+ncfile)
cdf = addfile(ncfile, "c")
print("Creating zonal nc file....")

; define dimensions
dimNames = (/"lsmlat","lsmlon"/)
dimSizes = (/ nlat, nlon/)
dimUnlim = (/ False, False/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"NUMLON","integer",(/"lsmlat"/))
filevardef(cdf,"LONGXY","double",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LATIXY","double",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LANDMASK","integer",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LANDFRAC","double",(/"lsmlat","lsmlon"/))

; write variables
cdf->NUMLON    =  (/numlon/)
cdf->LONGXY    =  (/longxy/) 
cdf->LATIXY    =  (/latixy/) 
cdf->LANDMASK  =  (/landmask_int/) 
cdf->LANDFRAC  =  (/landfrac/)

; add new text
cdf@history = "mk_ffrac.ncl  latixy/longxy/landmask taken from " + frawdata 


end if

end  ; end ncl
