c
      subroutine open_cdf(ncid,filename,read_only)
c
      use definitions_netcdf_jfl, only : netcdf_file_name
c
c open existing netcdf file and return its ID number
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character*(200) filename
      logical, optional :: read_only
c
c local
c
      integer status
c
      if(present(read_only)) then
        if(read_only) then
          status = nf_open(filename,NF_NOWRITE,ncid)
          if(status.ne.nf_noerr) call handle_err(status)
        else
          status = nf_open(filename,NF_WRITE,ncid)
          if(status.ne.nf_noerr) call handle_err(status)
        endif
      else
        status = nf_open(filename,NF_WRITE,ncid)
        if(status.ne.nf_noerr) call handle_err(status)
      endif
c
c make sure the file ID is OK
c
      if(ncid.lt.0) then
        print *,'Problem opening ',filename,' ncid = ',ncid
        call abort()
      endif
c
      netcdf_file_name = filename
c
      return
      end
c
      subroutine create_cdf(ncid,filename)
c
      use definitions_netcdf_jfl, only : netcdf_file_name
c
c create new netcdf file and return its ID number
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character*(200) filename
c
c local
c
      integer status
c
      status = nf_create(filename,NF_CLOBBER,ncid)
      if(status.ne.nf_noerr) call handle_err(status)
c
c make sure the file ID is OK
c
      if(ncid.le.0) then
        print *,'Problem opening ',filename,' ncid = ',ncid
        call abort()
      endif
c
      netcdf_file_name = filename
c
      return
      end 
c
      subroutine end_def(ncid)
c
c end definition mode for netcdf file
c
      implicit none
c
      include 'netcdf.inc'
c
c argument
c
      integer ncid
c
c local
c
      integer status
c
      status = nf_enddef(ncid)
      if(status.ne.nf_noerr) call handle_err(status)
c
      return
      end
c
      subroutine close_cdf(ncid)
c
c create new netcdf file and return its ID number
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
c
c local
c
      integer status
c
      status = nf_close(ncid)
      if(status.ne.nf_noerr) call handle_err(status)
c
      return
      end
c
      subroutine def_dim(ncid,dim_name,dim_length)
c
c define dimension in netcdf file
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid,dim_length
      character(*) dim_name
c
c local
c
      integer status,dim_id
c
      if(dim_length.gt.0) then
        status = nf_def_dim(ncid,dim_name,dim_length  ,dim_id)
      else
        status = nf_def_dim(ncid,dim_name,nf_unlimited,dim_id)
      endif
      if(status.ne.nf_noerr) call handle_err(status)
c
      dim_counter = dim_counter + 1
      if(dim_counter.gt.dim_max) then
        print *,'maximum number of dimensions ',dim_max
        print *,'is reached, stopping'
        stop
      endif
      dim_info(dim_counter)%name      = dim_name
      dim_info(dim_counter)%id        = dim_id
      dim_info(dim_counter)%length    = dim_length
      dim_info(dim_counter)%file_name = netcdf_file_name
c
      return
      end
c
      subroutine def_var(ncid,var_name,format,type,units,long_name)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name,format,type,long_name
      character(*), optional :: units
c
c local
c
      integer i,j,n
      integer status,xtype,nvdims,var_id
      integer, dimension(:), allocatable :: vdims ,length
      character*1  :: comma = ','
      character*72 :: work
      integer pos1,pos2,pos3,position(100),ncomma
c
c remove possible comma at the end of format
c
      if(format(len(format):len(format)).eq.comma) then
        format(len(format):len(format)) = ' '
      endif
c
c special case for mif variables
c
      if(format(:len_trim(format)).eq.'mif') then
        if(type.eq.'character') then
          nvdims = 3
          allocate(vdims (nvdims))
          allocate(length(nvdims))
          do i=1,dim_counter
            if(dim_info(i)%name.eq.'mif1') then
              vdims (2) = dim_info(i)%id
              length(2) = dim_info(i)%length
            elseif(dim_info(i)%name.eq.'mif2') then
              vdims (3) = dim_info(i)%id
              length(3) = dim_info(i)%length
            elseif(dim_info(i)%name.eq.'mif3') then
              vdims (1) = dim_info(i)%id
              length(1) = dim_info(i)%length
            endif
          end do
        else
          nvdims = 2
          allocate(vdims (nvdims))
          allocate(length(nvdims))
          do i=1,dim_counter
            if(dim_info(i)%name.eq.'mif1') then
              vdims (1) = dim_info(i)%id
              length(1) = dim_info(i)%length
            elseif(dim_info(i)%name.eq.'mif2') then
              vdims (2) = dim_info(i)%id
              length(2) = dim_info(i)%length
            endif
          end do
        endif
      else
c
c default case
c
        if(len_trim(format).eq.0) then
          print *,'problem with defining ',var_name
          print *,'no format defined'
          stop
        endif
c
c find position of commas
c
        ncomma = 0
        do n=1,len_trim(format)
          if(format(n:n).eq.comma) then
            ncomma = ncomma + 1
            position(ncomma) = n
          endif
        end do
        ncomma = ncomma + 1
        position(ncomma) = len_trim(format) + 1
c
        nvdims = ncomma
        allocate(vdims (nvdims))
        allocate(length(nvdims))
        vdims = -1
c
        pos1 = 1
        do i=1,nvdims
          pos2 = position(i) - 1
          pos3 = pos2 - pos1 + 1
          work = ' '
          work(:pos3) = format(pos1:pos2)
          pos1 = pos2 + 2
          do j=1,dim_counter
            if(dim_info(j)%name.eq.work(:pos3).and.
     &         dim_info(j)%file_name.eq.netcdf_file_name) then
              vdims (i) = dim_info(j)%id
              length(i) = dim_info(j)%length
              exit
            endif
          end do
        end do
c
      endif
c
c define external type
c
      if(type.eq.'integer'  ) xtype = nf_int
      if(type.eq.'float'    ) xtype = nf_float
      if(type.eq.'double'   ) xtype = nf_double
      if(type.eq.'character') xtype = nf_char
c
c define variable
c
      status = nf_def_var(ncid,var_name,xtype,nvdims,vdims,var_id)
      if(status.ne.nf_noerr) call handle_err(status)
c
c declare attributes
c
      status = nf_put_att_text(ncid,var_id,'long_name'
     &                        ,len(long_name),long_name)
      if(status.ne.nf_noerr) call handle_err(status)
c
      if(present(units)) then
        status = nf_put_att_text(ncid,var_id,'units'
     &                          ,len(units),units)
        if(status.ne.nf_noerr) call handle_err(status)
      endif
c
c store information
c
      var_counter = var_counter + 1
      if(var_counter.gt.var_max) then
        print *,'maximum number of variables ',var_max
        print *,'is reached, stopping'
        stop
      endif
      var_info(var_counter)%name      = var_name
      var_info(var_counter)%format    = format
      var_info(var_counter)%type      = type
      var_info(var_counter)%id        = var_id
      var_info(var_counter)%file_name = netcdf_file_name
      var_info(var_counter)%nvdims    = nvdims
      do i=1,nvdims
        var_info(var_counter)%vdims(i) = length(i)
      end do
c
      deallocate(vdims )
      deallocate(length)
c
      return
      end
c
      subroutine get_dims(ncid)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
c
c local
c
      integer n,num_dim
      integer length
      integer status
      character*72 name
c
      status = nf_inq_ndims(ncid,num_dim)
      if(status.ne.nf_noerr) call handle_err(status)
c
      if(num_dim.gt.dim_max) then
        print *,'number of dimensions found = ',num_dim
        print *,'maximum allowed            = ',dim_max
        stop
      endif
c
      do n=1,num_dim
        name = ' '
        status = nf_inq_dim(ncid,n,name,length)
        if(status.ne.nf_noerr) call handle_err(status)
        dim_counter = dim_counter + 1
        dim_info(dim_counter)%id        = n
        dim_info(dim_counter)%name      = ' '
        dim_info(dim_counter)%name      = name
        dim_info(dim_counter)%length    = length
        dim_info(dim_counter)%file_name = ' '
        dim_info(dim_counter)%file_name = netcdf_file_name
      end do
c
      return
      end
c
      subroutine get_vars(ncid)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
c
c local
c
      integer i,j,n,num_var
      integer status
      integer xtype,nvdims,length
      integer pos1,pos2
      integer, dimension(:), allocatable :: dim_id
      character*72 name
      character*1 :: comma = ','
c
      status = nf_inq_nvars(ncid,num_var)
      if(status.ne.nf_noerr) call handle_err(status)
c
      if(num_var.gt.var_max) then
        print *,'number of variables found = ',num_var
        print *,'maximum allowed           = ',var_max
        stop
      endif
c
      do n=1,num_var
c
        name = ' '
        status = nf_inq_varname(ncid,n,name)
        if(status.ne.nf_noerr) call handle_err(status)
c
        status = nf_inq_vartype(ncid,n,xtype)
        if(status.ne.nf_noerr) call handle_err(status)
c
        status = nf_inq_varndims(ncid,n,nvdims)
        if(status.ne.nf_noerr) call handle_err(status)
c
        allocate(dim_id(nvdims))
        status = nf_inq_vardimid(ncid,n,dim_id)
        if(status.ne.nf_noerr) call handle_err(status)
c
        var_counter = var_counter + 1
        var_info(var_counter)%id        = n
        var_info(var_counter)%name      = ' '
        var_info(var_counter)%name      = name
        var_info(var_counter)%file_name = ' '
        var_info(var_counter)%file_name = netcdf_file_name
        select case ( xtype )
          case ( nf_int )
            var_info(var_counter)%type = 'integer'
          case ( nf_float )
            var_info(var_counter)%type = 'float'
          case ( nf_double )
            var_info(var_counter)%type = 'double'
          case ( nf_char )
            var_info(var_counter)%type = 'character'
        end select
        var_info(var_counter)%nvdims = nvdims
        pos1 = 1
        pos2 = 1
        var_info(var_counter)%format = ' '
        do i=1,nvdims
          do j=1,dim_counter
            if((dim_info(j)%id.eq.dim_id(i)).and.
     &         (dim_info(j)%file_name.eq.netcdf_file_name)) then
              length = dim_info(j)%length
              name = ' '
              name = dim_info(j)%name
              exit
            endif
          end do
          var_info(var_counter)%vdims(i) = length
          pos2 = pos1 + len_trim(name) - 1
          var_info(var_counter)%format(pos1:pos2)
     &                                = name(:len_trim(name))
          pos2 = pos2 + 1
          var_info(var_counter)%format(pos2:pos2) = comma
          pos1 = pos2 + 1
        end do
c
c remove last comma
c
        var_info(var_counter)%format(pos2:pos2) = ' '
c
c deallocate memory
c
        deallocate(dim_id)
c
      end do
c
      return
      end
c
      subroutine write_var_i_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array
c
      include 'put_var_int.prog'
c
      return
      end
c
      subroutine write_var_i_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:)
c
      include 'put_var_int.prog'
c
      return
      end
c
      subroutine write_var_i_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:,:)
c
      include 'put_var_int.prog'
c
      return
      end
c
      subroutine write_var_i_3(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:,:,:)
c
      include 'put_var_int.prog'
c
      return
      end
c
      subroutine write_var_i_4(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:,:,:,:)
c
      include 'put_var_int.prog'
c
      return
      end
c
      subroutine write_var_f_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array
c
      include 'put_var_real.prog'
c
      return
      end
c
      subroutine write_var_f_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:)
c
      include 'put_var_real.prog'
c
      return
      end
c
      subroutine write_var_f_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:)
c
      include 'put_var_real.prog'
c
      return
      end
c
      subroutine write_var_f_3(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:,:)
c
      include 'put_var_real.prog'
c
      return
      end
c
      subroutine write_var_f_4(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:,:,:)
c
      include 'put_var_real.prog'
c
      return
      end
c
      subroutine write_var_d_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real*8 array
c
      include 'put_var_dble.prog'
c
      return
      end
c
      subroutine write_var_d_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real*8 array(:)
c
      include 'put_var_dble.prog'
c
      return
      end
c
      subroutine write_var_d_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real*8 array(:,:)
c
      include 'put_var_dble.prog'
c
      return
      end
c
      subroutine write_var_d_3(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real*8 array(:,:,:)
c
      include 'put_var_dble.prog'
c
      return
      end
c
      subroutine write_var_c_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      character(*) array
c
      include 'put_var_text.prog'
c
      return
      end
c
      subroutine write_var_c_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      character(*) array(:)
c
      include 'put_var_text.prog'
c
      return
      end
c
      subroutine write_var_c_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      character(*) array(:,:)
c
      include 'put_var_text.prog'
c
      return
      end
c
      subroutine read_var_i_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array
c
      include 'get_var_int.prog'
c
      return
      end
c
      subroutine read_var_i_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:)
c
      include 'get_var_int.prog'
c
      return
      end
c
      subroutine read_var_i8_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer*8 array(:)
c
      include 'get_var_int.prog'
c
      return
      end
c
      subroutine read_var_i_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:,:)
c
      include 'get_var_int.prog'
c
      return
      end
c
      subroutine read_var_i_3(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:,:,:)
c
      include 'get_var_int.prog'
c
      return
      end
c
      subroutine read_var_i_4(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      integer array(:,:,:,:)
c
      include 'get_var_int.prog'
c
      return
      end
c
      subroutine read_var_f_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array
c
      include 'get_var_real.prog'
c
      return
      end
c
      subroutine read_var_f_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:)
c
      include 'get_var_real.prog'
c
      return
      end
c
      subroutine read_var_f_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:)
c
      include 'get_var_real.prog'
c
      return
      end
c
      subroutine read_var_f_3(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:,:)
c
      include 'get_var_real.prog'
c
      return
      end
c
      subroutine read_var_f_4(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:,:,:)
c
      include 'get_var_real.prog'
c
      return
      end
c
      subroutine read_var_f_5(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      real array(:,:,:,:,:)
c
      include 'get_var_real.prog'
c
      return
      end
c
      subroutine read_var_d_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      double precision array
c
      include 'get_var_double.prog'
c
      return
      end
c
      subroutine read_var_d_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      double precision array(:)
c
      include 'get_var_double.prog'
c
      return
      end
c
      subroutine read_var_d_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      double precision array(:,:)
c
      include 'get_var_double.prog'
c
      return
      end
c
      subroutine read_var_c_0(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      character(*) array
c
      include 'get_var_text.prog'
c
      return
      end
c
      subroutine read_var_c_1(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      character(*) array(:)
c
      include 'get_var_text.prog'
c
      return
      end
c
      subroutine read_var_c_2(ncid,var_name,array)
c
      use definitions_netcdf_jfl
      use counters_netcdf_jfl
c
      implicit none
c
      include 'netcdf.inc'
c
c arguments
c
      integer ncid
      character(*) var_name
      character(*) array(:,:)
c
      include 'get_var_text.prog'
c
      return
      end
