!
  use counters_netcdf_jfl
  use interfaces_netcdf_jfl
  use definitions_netcdf_jfl
!
  implicit none
!
  integer, parameter :: nlon = 96
  integer, parameter :: nlat = 48
  integer, parameter :: nlev = 26
!
  integer :: ncid,decade
  integer :: i,j,k,n,ios
  integer :: year,month
  integer :: cnt_dep,cnt_yr
!
  real                          :: time
  real, dimension(nlon)         :: lon
  real, dimension     (nlat)    :: lat
  real, dimension(nlon,nlat)    :: area,wk_2d
  real, dimension(nlon,nlat)    :: emi_dst_04
  real, dimension(nlon,nlat,12) :: bc_phi_wet,bc_phi_dry,bc_pho_dry
  real, dimension(nlon,nlat,12) :: oc_phi_wet,oc_phi_dry,oc_pho_dry
  real, dimension(nlon,nlat,12) :: dst_01_dry,dst_01_wet
  real, dimension(nlon,nlat,12) :: dst_02_dry,dst_02_wet
  real, dimension(nlon,nlat,12) :: dst_03_dry,dst_03_wet
  real, dimension(nlon,nlat,12) :: dst_04_dry,dst_04_wet
!
  real, dimension(nlev)           :: hyam,hybm
  real, dimension(nlev+1)         :: hyai,hybi
  real, dimension(nlon,nlat)      :: ps
  real                            :: p,dp,vol,rho
  real, dimension(nlon,nlat,nlev) :: wk_3d
!
  integer :: ier,system
  character*500 :: command
!
  character*3   :: label_decade
  character*200 :: file_name,last_file_name
  integer :: pos1,pos2
!
  real, parameter :: rad  = 6.37122e6   ! Earth radius (m)
  real :: pi,degrees_to_radians,dlat,dlon
!
  pi = acos(-1.)
  area = -9999.
!
  do decade=10,10,10
!
    write(label_decade,fmt='(i3.3)') decade/10
!
    bc_phi_wet = 0.
    bc_phi_dry = 0.
    bc_pho_dry = 0.
    oc_phi_wet = 0.
    oc_phi_dry = 0.
    oc_pho_dry = 0.
    dst_01_dry = 0.
    dst_01_wet = 0.
    dst_02_dry = 0.
    dst_02_wet = 0.
    dst_03_dry = 0.
    dst_03_wet = 0.
    dst_04_dry = 0.
    dst_04_wet = 0.
!
    command = ' '
!cas modifiy here for your logname and CASE; assumes standard ccsm path conventions
!cas use this line if your history data is on the even decade
!   command = 'ls -1 /ptmp/logname/archive/CASE/atm/hist/CASE.cam2.h0.'//label_decade//'* > file_list'
!cas use this line if not
    command = 'ls -1 /ptmp/logname/archive/CASE/atm/hist/CASE.cam2.h0.* > file_list'
    ier = system(command)
!
    open(10,file='file_list')
!
    cnt_dep = 0
    cnt_yr  = 0
!
    LOOP_FILES: do
      file_name = ' '
      read(10,fmt='(a)',iostat=ios) file_name
!
      if ( ios < 0 ) exit LOOP_FILES
      last_file_name = file_name
!
      cnt_dep = cnt_dep + 1
!
      pos1 = index(file_name,'-',back=.true.)
      read(file_name(pos1-4:pos1-1),fmt='(i4)') year
      read(file_name(pos1+1:pos1+2),fmt='(i2)') month
!
      if ( month == 12 ) then
        cnt_yr = cnt_yr + 1
      end if
!
      print '(a,a)','reading ',trim(file_name)
      call open_cdf(ncid,file_name,.true.)
      call get_dims(ncid)
      call get_vars(ncid)
!
      if ( maxval(area) < 0. ) then
        call read_var(ncid,'lat',lat)
        call read_var(ncid,'lon',lon)
        degrees_to_radians = pi/180.
        dlat = lat(2) - lat(1)
        dlon = lon(2) - lon(1)
        do j=2,nlat-1
          do i=1,nlon
            area(i,j) = rad**2 * cos(lat(j)*degrees_to_radians) * (dlat*degrees_to_radians) * (dlon*degrees_to_radians)
          end do
        end do
        area(:,   1) = area(:,2)
        area(:,nlat) = area(:,2)
!
        call read_var(ncid,'hyam',hyam)
        call read_var(ncid,'hybm',hybm)
        call read_var(ncid,'hyai',hyai)
        call read_var(ncid,'hybi',hybi)
!
      end if
!
      time_counter = 1
!
      call read_var(ncid,'PS',ps)
!
! OC/BC
!
      call read_var(ncid,'DF_CB1',wk_2d)
      bc_pho_dry(:,:,month) = bc_pho_dry(:,:,month) + wk_2d
      call read_var(ncid,'DF_CB2',wk_2d)
      bc_phi_dry(:,:,month) = bc_phi_dry(:,:,month) + wk_2d
      call read_var(ncid,'CB2SFWET',wk_2d)
      bc_phi_wet(:,:,month) = bc_phi_wet(:,:,month) + wk_2d * (-1.)
!
      call read_var(ncid,'DF_OC1',wk_2d)
      oc_pho_dry(:,:,month) = oc_pho_dry(:,:,month) + wk_2d
      call read_var(ncid,'DF_OC2',wk_2d)               
      oc_phi_dry(:,:,month) = oc_phi_dry(:,:,month) + wk_2d 
      call read_var(ncid,'OC2SFWET',wk_2d)
      oc_phi_wet(:,:,month) = oc_phi_wet(:,:,month) + wk_2d * (-1.)
!
! dust
!
      call read_var(ncid,'DST01DD',wk_2d)
      dst_01_dry(:,:,month) = dst_01_dry(:,:,month) + wk_2d
      call read_var(ncid,'DST02DD',wk_2d)
      dst_02_dry(:,:,month) = dst_02_dry(:,:,month) + wk_2d
      call read_var(ncid,'DST03DD',wk_2d)
      dst_03_dry(:,:,month) = dst_03_dry(:,:,month) + wk_2d
      call read_var(ncid,'DST04DD',wk_2d)
      dst_04_dry(:,:,month) = dst_04_dry(:,:,month) + wk_2d
!
      call read_var(ncid,'DST01PP',wk_3d)
      wk_2d = 0.
      do j=1,nlat
        do i=1,nlon
          do k=1,nlev
            dp  = (hyai(k+1)-hyai(k)) * 1.e5 + (hybi(k+1)-hybi(k)) * ps(i,j)
            wk_2d(i,j) = wk_2d(i,j) + wk_3d(i,j,k) * dp/9.81
          end do
        end do
      end do
      dst_01_wet(:,:,month) = dst_01_wet(:,:,month) + wk_2d * (-1.)
!
      call read_var(ncid,'DST02PP',wk_3d)
      wk_2d = 0.
      do j=1,nlat
        do i=1,nlon
          do k=1,nlev
            dp  = (hyai(k+1)-hyai(k)) * 1.e5 + (hybi(k+1)-hybi(k)) * ps(i,j)
            wk_2d(i,j) = wk_2d(i,j) + wk_3d(i,j,k) * dp/9.81
          end do
        end do
      end do
      dst_02_wet(:,:,month) = dst_02_wet(:,:,month) + wk_2d * (-1.)
!
      call read_var(ncid,'DST03PP',wk_3d)
      wk_2d = 0.
      do j=1,nlat
        do i=1,nlon
          do k=1,nlev
            dp  = (hyai(k+1)-hyai(k)) * 1.e5 + (hybi(k+1)-hybi(k)) * ps(i,j)
            wk_2d(i,j) = wk_2d(i,j) + wk_3d(i,j,k) * dp/9.81
          end do
        end do
      end do
      dst_03_wet(:,:,month) = dst_03_wet(:,:,month) + wk_2d * (-1.)
!
      call read_var(ncid,'DST04PP',wk_3d)
      wk_2d = 0.
      do j=1,nlat
        do i=1,nlon
          do k=1,nlev
            dp  = (hyai(k+1)-hyai(k)) * 1.e5 + (hybi(k+1)-hybi(k)) * ps(i,j)
            wk_2d(i,j) = wk_2d(i,j) + wk_3d(i,j,k) * dp/9.81
          end do
        end do
      end do
      dst_04_wet(:,:,month) = dst_04_wet(:,:,month) + wk_2d * (-1.)
!
      call close_cdf(ncid)
      dim_counter = 0
      var_counter = 0
!
    end do LOOP_FILES
!
    close(10)
!
! output
!
    file_name = ' '
!cas    file_name = 'aerosoldep_monthly_'//label_decade//'0-'//label_decade//'9_mean_1.9x2.5.nc'
    file_name = 'aerosoldep_monthly_12-21_mean.nc'
    call create_cdf(ncid,file_name)
    call def_dim(ncid,'lat',nlat)
    call def_dim(ncid,'lon',nlon)
    call def_dim(ncid,'time',0)
    call def_var(ncid,'BCDEPWET','lon,lat,time','float','kg/m2/s','hydrophilic BC wet deposition')
    call def_var(ncid,'BCPHIDRY','lon,lat,time','float','kg/m2/s','hydrophilic BC dry deposition')
    call def_var(ncid,'BCPHODRY','lon,lat,time','float','kg/m2/s','hydrophobic BC dry deposition')
    call def_var(ncid,'OCDEPWET','lon,lat,time','float','kg/m2/s','hydrophilic OC wet deposition')
    call def_var(ncid,'OCPHIDRY','lon,lat,time','float','kg/m2/s','hydrophilic OC dry deposition')
    call def_var(ncid,'OCPHODRY','lon,lat,time','float','kg/m2/s','hydrophobic OC dry deposition')
    call def_var(ncid,'DSTX01WD','lon,lat,time','float','kg/m2/s','DSTX01 wet deposition flux at bottom')
    call def_var(ncid,'DSTX01DD','lon,lat,time','float','kg/m2/s','DSTX01 dry deposition flux at bottom')
    call def_var(ncid,'DSTX02WD','lon,lat,time','float','kg/m2/s','DSTX02 wet deposition flux at bottom')
    call def_var(ncid,'DSTX02DD','lon,lat,time','float','kg/m2/s','DSTX02 dry deposition flux at bottom')
    call def_var(ncid,'DSTX03WD','lon,lat,time','float','kg/m2/s','DSTX03 wet deposition flux at bottom')
    call def_var(ncid,'DSTX03DD','lon,lat,time','float','kg/m2/s','DSTX03 dry deposition flux at bottom')
    call def_var(ncid,'DSTX04WD','lon,lat,time','float','kg/m2/s','DSTX04 wet deposition flux at bottom')
    call def_var(ncid,'DSTX04DD','lon,lat,time','float','kg/m2/s','DSTX04 dry deposition flux at bottom')
    call end_def(ncid)
!
    do n=1,12
      time_counter = n
      wk_2d = bc_phi_wet(:,:,n)/cnt_yr
      call write_var(ncid,'BCDEPWET',wk_2d)
      wk_2d = bc_phi_dry(:,:,n)/cnt_yr
      call write_var(ncid,'BCPHIDRY',wk_2d)
      wk_2d = bc_pho_dry(:,:,n)/cnt_yr
      call write_var(ncid,'BCPHODRY',wk_2d)
      wk_2d = oc_phi_wet(:,:,n)/cnt_yr
      call write_var(ncid,'OCDEPWET',wk_2d)
      wk_2d = oc_phi_dry(:,:,n)/cnt_yr
      call write_var(ncid,'OCPHIDRY',wk_2d)
      wk_2d = oc_pho_dry(:,:,n)/cnt_yr
      call write_var(ncid,'OCPHODRY',wk_2d)
      wk_2d = dst_01_wet(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX01WD',wk_2d)
      wk_2d = dst_01_dry(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX01DD',wk_2d)
      wk_2d = dst_02_wet(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX02WD',wk_2d)
      wk_2d = dst_02_dry(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX02DD',wk_2d)
      wk_2d = dst_03_wet(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX03WD',wk_2d)
      wk_2d = dst_03_dry(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX03DD',wk_2d)
      wk_2d = dst_04_wet(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX04WD',wk_2d)
      wk_2d = dst_04_dry(:,:,n)/cnt_yr
      call write_var(ncid,'DSTX04DD',wk_2d)
    end do
!
    call close_cdf(ncid)
    dim_counter = 0
    var_counter = 0
!
    command = ' '
!cas modifiy here for your logname and CASE; assumes standard ccsm path conventions
    command = 'ncrcat -h -A -v lat,lon,date,time,datesec /ptmp/logname/archive/CASE/atm/hist/CASE.cam2.h0.'//label_decade//'5-*nc wk_time.nc'
    ier = system(command)
!
    command = ' '
    command = 'ncks -h -A -v lat,lon,date,time,datesec wk_time.nc '//trim(file_name)
    ier = system(command)
!
  end do
!
  stop
end
