#!/bin/csh -f
set echo
set verbose

## run after run dep_snow.f90 and have aerodep dataset
## this script overwrites date and time to 1850 default values
## this script appends global attribute (metadata) to list source experiment
## "yb" = beginning year, "ye" = end year
## modify comments
## CAS mar 2011  


setenv CASE b40.t31x3.your.case
setenv AERODEP aerosoldep_monthly_yb-ye_mean.nc # change yb and ye to your begin/end years
setenv NEWNAME aerosoldep_monthly_yb-ye_mean_$CASE.nc


cp $AERODEP $NEWNAME
ncks --append -v date,time /your/path/here/presc_aero_files/default_1850/date_time_1850clim.nc $NEWNAME  
ncatted -a history,global,a,c,"$CASE.cam2.h0* files years yb yb logname yymmdd" $NEWNAME  # update your comments


exit

