; read in template cam prescribed aero file (fv2deg) 
; read in new (T31) prescribed aero file
; interopolate vars from new file resolution to default
; overwrite default vars;  write out to netcdf 
; assumes the same number of vertical levels
; cas march 2011
  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";

begin

;====================user defined parameters

filename_template= "/your/inputdata/default/aero_1.9x2.5_L26_1850clim_c091112.nc"    
filename_aero= "/your/path/here/aero.b40.t31x3.CASE.4.cam2.climo.yyddmm.nc" ;from aero.climo.csh   
new_cdf          = "aero_1.9x2.5_L26_CASE_cyymmdd.nc" 
modtext          = "data from CASE last 10 years, a bulk aerosol run, aero.climo.csh, add your comments"
kludge =  1  ;0 no kludge fixes  1 yes kludge fixes -- different for different rez interps, may need to code

;=============== read prescribed aerosol template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
slat = atm->slat
slon = atm->slon
lev  = atm->lev
ilev = atm->ilev
time = atm->time
hyai   = atm->hyai
hybi   = atm->hybi
hyam   = atm->hyam
hybm   = atm->hybm
gw     = atm->gw
date   = atm->date
datesec= atm->datesec
P0   = atm->P0

PS     = atm->PS
CB1    = atm->CB1
CB2    = atm->CB2
DST01  = atm->DST01
DST02  = atm->DST02
DST03  = atm->DST03
DST04  = atm->DST04
SO4    = atm->SO4
OC1    = atm->OC1
OC2    = atm->OC2
SSLT01 = atm->SSLT01
SSLT02 = atm->SSLT02
SSLT03 = atm->SSLT03
SSLT04 = atm->SSLT04
 
nlon  = dimsizes(lon)
nslon  = dimsizes(slon)
nlat  = dimsizes(lat)
nslat  = dimsizes(slat)
nlev  = dimsizes(lev)
nilev = dimsizes(ilev)
ntimes= dimsizes(time)


print("nlon = " + nlon)
print("nlat = " + nlat)
print("nlev = " + nlev)
print("nilev= " + nilev)
print("ntimes = " + ntimes)


;=============== read in new prescribed aero file
 
aero = addfile(filename_aero,"r")
plat  = aero->lat
plon  = aero->lon

pPS     = aero->PS
pCB1   = aero->CB1
pCB2    = aero->CB2
pDST01  = aero->DST01
pDST02  = aero->DST02
pDST03  = aero->DST03
pDST04  = aero->DST04
pOC1    = aero->OC1
pOC2    = aero->OC2
pSO4    = aero->SO4
pSSLT01 = aero->SSLT01
pSSLT02 = aero->SSLT02
pSSLT03 = aero->SSLT03
pSSLT04 = aero->SSLT04
 
pnlon  = dimsizes(plon)
pnlat  = dimsizes(plat)


print("pnlon = " + pnlon)
print("pnlat = " + pnlat)


;===== interpolate to fv2deg

ps  = linint2_Wrap (plon,plat,pPS, True, lon,lat, 0)
cb1 = linint2_Wrap (plon,plat,pCB1, True, lon,lat, 0)
cb2 = linint2_Wrap (plon,plat,pCB2, True, lon,lat, 0)
dst01 = linint2_Wrap (plon,plat,pDST01, True, lon,lat, 0)
dst02 = linint2_Wrap (plon,plat,pDST02, True, lon,lat, 0)
dst03 = linint2_Wrap (plon,plat,pDST03, True, lon,lat, 0)
dst04 = linint2_Wrap (plon,plat,pDST04, True, lon,lat, 0)
oc1 = linint2_Wrap (plon,plat,pOC1, True, lon,lat, 0)
oc2 = linint2_Wrap (plon,plat,pOC2, True, lon,lat, 0)
so4 = linint2_Wrap (plon,plat,pSO4, True, lon,lat, 0)
sslt01 = linint2_Wrap (plon,plat,pSSLT01, True, lon,lat, 0)
sslt02 = linint2_Wrap (plon,plat,pSSLT02, True, lon,lat, 0)
sslt03 = linint2_Wrap (plon,plat,pSSLT03, True, lon,lat, 0)
sslt04 = linint2_Wrap (plon,plat,pSSLT04, True, lon,lat, 0)
print("interpolation complete")

;kludge fixes for t31->fvdeg
if(kludge.eq.1)then
 ps(:,0,:) = (/ps(:,2,:)/)
 ps(:,1,:) = (/ps(:,2,:)/)
 cb1(:,:,0,:) = (/cb1(:,:,2,:)/)
 cb1(:,:,1,:) = (/cb1(:,:,2,:)/)
 cb2(:,:,0,:) = (/cb2(:,:,2,:)/)
 cb2(:,:,1,:) = (/cb2(:,:,2,:)/)
 dst01(:,:,0,:) = (/dst01(:,:,2,:)/)
 dst01(:,:,1,:) = (/dst01(:,:,2,:)/)
 dst02(:,:,0,:) = (/dst02(:,:,2,:)/)
 dst02(:,:,1,:) = (/dst02(:,:,2,:)/)
 dst03(:,:,0,:) = (/dst03(:,:,2,:)/)
 dst03(:,:,1,:) = (/dst03(:,:,2,:)/)
 dst04(:,:,0,:) = (/dst04(:,:,2,:)/)
 dst04(:,:,1,:) = (/dst04(:,:,2,:)/)
 oc1(:,:,0,:) = (/oc1(:,:,2,:)/)
 oc1(:,:,1,:) = (/oc1(:,:,2,:)/)
 oc2(:,:,0,:) = (/oc2(:,:,2,:)/)
 oc2(:,:,1,:) = (/oc2(:,:,2,:)/)
 so4(:,:,0,:) = (/so4(:,:,2,:)/)
 so4(:,:,1,:) = (/so4(:,:,2,:)/)
 sslt01(:,:,0,:) = (/sslt01(:,:,2,:)/)
 sslt01(:,:,1,:) = (/sslt01(:,:,2,:)/)
 sslt02(:,:,0,:) = (/sslt02(:,:,2,:)/)
 sslt02(:,:,1,:) = (/sslt02(:,:,2,:)/)
 sslt03(:,:,0,:) = (/sslt03(:,:,2,:)/)
 sslt03(:,:,1,:) = (/sslt03(:,:,2,:)/)
 sslt04(:,:,0,:) = (/sslt04(:,:,2,:)/)
 sslt04(:,:,1,:) = (/sslt04(:,:,2,:)/)

 ps(:,nlat-2,:) = (/ps(:,nlat-3,:)/)
 ps(:,nlat-1,:) = (/ps(:,nlat-3,:)/)
 cb1(:,:,nlat-2,:) = (/cb1(:,:,nlat-3,:)/)
 cb1(:,:,nlat-1,:) = (/cb1(:,:,nlat-3,:)/)
 cb2(:,:,nlat-2,:) = (/cb2(:,:,nlat-3,:)/)
 cb2(:,:,nlat-1,:) = (/cb2(:,:,nlat-3,:)/)
 dst01(:,:,nlat-1,:) = (/dst01(:,:,nlat-3,:)/)
 dst01(:,:,nlat-2,:) = (/dst01(:,:,nlat-3,:)/)
 dst02(:,:,nlat-1,:) = (/dst02(:,:,nlat-3,:)/)
 dst02(:,:,nlat-2,:) = (/dst02(:,:,nlat-3,:)/)
 dst03(:,:,nlat-1,:) = (/dst03(:,:,nlat-3,:)/)
 dst03(:,:,nlat-2,:) = (/dst03(:,:,nlat-3,:)/)
 dst04(:,:,nlat-1,:) = (/dst04(:,:,nlat-3,:)/)
 dst04(:,:,nlat-2,:) = (/dst04(:,:,nlat-3,:)/)
 oc1(:,:,nlat-2,:) = (/oc1(:,:,nlat-3,:)/)
 oc1(:,:,nlat-1,:) = (/oc1(:,:,nlat-3,:)/)
 oc2(:,:,nlat-2,:) = (/oc2(:,:,nlat-3,:)/)
 oc2(:,:,nlat-1,:) = (/oc2(:,:,nlat-3,:)/)
 so4(:,:,nlat-2,:) = (/so4(:,:,nlat-3,:)/)
 so4(:,:,nlat-1,:) = (/so4(:,:,nlat-3,:)/)
 sslt01(:,:,nlat-2,:) = (/sslt01(:,:,nlat-3,:)/)
 sslt01(:,:,nlat-1,:) = (/sslt01(:,:,nlat-3,:)/)
 sslt02(:,:,nlat-2,:) = (/sslt02(:,:,nlat-3,:)/)
 sslt02(:,:,nlat-1,:) = (/sslt02(:,:,nlat-3,:)/)
 sslt03(:,:,nlat-2,:) = (/sslt03(:,:,nlat-3,:)/)
 sslt03(:,:,nlat-1,:) = (/sslt03(:,:,nlat-3,:)/)
 sslt04(:,:,nlat-2,:) = (/sslt04(:,:,nlat-3,:)/)
 sslt04(:,:,nlat-1,:) = (/sslt04(:,:,nlat-3,:)/)
print("kludge for rez complete")

end if

printVarSummary(cb1)

;========create new file surface file, preserve old file
;        attributes, write out variables with no changes

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new aero file....")

; define dimensions
dimNames = (/"lat","lon","lev","ilev","slat","slon","time"/)
dimSizes = (/ nlat, nlon, nlev, nilev, nslat, nslon,  -1/)
dimUnlim = (/ False,False,False,False,False,False,True/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"gw","double",(/"lat"/))
filevardef(cdf,"hyai","double",(/"ilev"/))
filevardef(cdf,"hybi","double",(/"ilev"/))
filevardef(cdf,"hyam","double",(/"lev"/))
filevardef(cdf,"hybm","double",(/"lev"/))
filevardef(cdf,"ilev","double",(/"ilev"/))
filevardef(cdf,"lat","double",(/"lat"/))
filevardef(cdf,"lev","double",(/"lev"/))
filevardef(cdf,"lon","double",(/"lon"/))
filevardef(cdf,"slat","double",(/"slat"/))
filevardef(cdf,"slon","double",(/"slon"/))
filevardef(cdf,"time","double",(/"time"/))
filevardef(cdf,"date","integer",(/"time"/))
filevardef(cdf,"datesec","integer",(/"time"/))
filevardef(cdf,"CB1","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"CB2","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"DST01","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"DST02","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"DST03","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"DST04","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"OC1","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"OC2","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"PS","float",(/"time","lat","lon"/))
filevardef(cdf,"SO4","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"SSLT01","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"SSLT02","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"SSLT03","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"SSLT04","float",(/"time","lev","lat","lon"/))

; write variables
cdf->gw     = gw
cdf->hyai   = hyai
cdf->hybi   = hybi
cdf->hyam   = hyam
cdf->hybm   = hybm
cdf->lat    = lat
cdf->lon    = lon
cdf->lev    = lev
cdf->ilev   = ilev
cdf->slat   = slat
cdf->slon   = slon
cdf->P0 = P0
cdf->time   = time
cdf->date   = date
cdf->datesec= datesec

; add new text
cdf@template = filename_template
cdf@sourceaero = filename_aero
cdf@case = aero@case
cdf@logname = aero@logname
cdf@initial_file = aero@initial_file
cdf@topography_file = aero@topography_file
cdf@history = aero@history
cdf@Modifications = modtext

print("New file skeleton has been written...")

;== write new vars
  
cdf->CB1 = cb1
cdf->CB2 = cb2
cdf->DST01 = dst01 
cdf->DST02 = dst02 
cdf->DST03 = dst03 
cdf->DST04 = dst04 
cdf->OC1 =  oc1
cdf->OC2 =  oc2
cdf->PS  =  ps 
cdf->SO4 =  so4 
cdf->SSLT01 = sslt01 
cdf->SSLT02 = sslt02 
cdf->SSLT03 = sslt03 
cdf->SSLT04 = sslt04 


print(new_cdf + " has been written")



end
    


