; reads in default prescribed aero file and newly created paleo aero file
; computes avg/sum on both to check if global numbers are approximate
; use a possible check for your new file 
; modify for different variables if interested
  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";

begin

;====================user defined parameters

filename_old= "/your/inputdata/default_1850/aero_1.9x2.5_L26_1850clim_c091112.nc"    
filename_new= "/your/path/here/presc_aero_files/aero.CASE.cam2.climo.yymmdd.nc"   

;=============== read prescribed aerosol template netcdf file
 
atmo = addfile(filename_old,"r")
oCB1    = atmo->CB1
oCB2    = atmo->CB2
oOC1    = atmo->OC1
oOC2    = atmo->OC2
aocb1 = avg(oCB1)
aocb2 = avg(oCB2)
aooc1 = avg(oOC1)
aooc2 = avg(oOC2)
socb1 = sum(oCB1)
socb2 = sum(oCB2)
sooc1 = sum(oOC1)
sooc2 = sum(oOC2)

atmn = addfile(filename_new,"r")
nCB1    = atmn->CB1
nCB2    = atmn->CB2
nOC1    = atmn->OC1
nOC2    = atmn->OC2
ancb1 = avg(nCB1)
ancb2 = avg(nCB2)
anoc1 = avg(nOC1)
anoc2 = avg(nOC2)
sncb1 = sum(nCB1)
sncb2 = sum(nCB2)
snoc1 = sum(nOC1)
snoc2 = sum(nOC2)

print("avg cb1 default = " + aocb1 + " new = " + ancb1)
print("avg cb2 default = " + aocb2 + " new = " + ancb2)
print("avg oc1 default = " + aooc1 + " new = " + anoc1)
print("avg oc2 default = " + aooc2 + " new = " + anoc2)

print("sum cb1 default = " + socb1 + " new = " + sncb1)
print("sum cb2 default = " + socb2 + " new = " + sncb2)
print("sum oc1 default = " + sooc1 + " new = " + snoc1)
print("sum oc2 default = " + sooc2 + " new = " + snoc2)

end
    


