#!/bin/csh -f
set echo
set verbose

## run on bluefire (memory and speed required)
## place in working directory, i.e. where history files reside
## input is CAM4 atmosphere monthly history files
## creates climatology required for CAM prescribed aerosol forcing file
## years to average currently need to be HARDWIRED in ncra statement
## write intermediate and climo files to a seperate directory called WRITE2DIR

## CAS mar 2011   (using 10 years of history data)


setenv CASE b40.your.case 
set WRITE2DIR =  /ptmp/$LOGNAME/csm/$CASE/aero 
set MONTH = ( 01 02 03 04 05 06 07 08 09 10 11 12 )             # months to loop over

set AEROfields = gw,hyai,hyam,hybi,hybm,ilev,lat,lev,lon,P0,time,date,datesec,CB1,CB2,DST01,DST02,DST03,DST04,OC1,OC2,PS,SO4,SSLT01,SSLT02,SSLT03,SSLT04


if !(-d $WRITE2DIR)     mkdir -p $WRITE2DIR

@ nmon = 1

foreach MON ( $MONTH )

 set MM = $MONTH[$nmon] 

 ncra -h -v $AEROfields $CASE.cam2.h0.0012-$MM.nc $CASE.cam2.h0.0013-$MM.nc $CASE.cam2.h0.0014-$MM.nc $CASE.cam2.h0.0015-$MM.nc $CASE.cam2.h0.0016-$MM.nc $CASE.cam2.h0.0017-$MM.nc $CASE.cam2.h0.0018-$MM.nc $CASE.cam2.h0.0019-$MM.nc $CASE.cam2.h0.0020-$MM.nc $CASE.cam2.h0.0021-$MM.nc  $WRITE2DIR/aero.$CASE.cam2.$MM.nc

 @ nmon ++

end   # end foreach

cd $WRITE2DIR

ncrcat aero.$CASE.cam2.*.nc aero.$CASE.cam2.climo.nc
ncks --append -v date,time /your/path/here/default_1850/date_time_1850clim.nc aero.$CASE.cam2.climo.nc

exit

