;=========================================================; 
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";

begin

fili = "/your/path/here/yourtopo_2x2_topodepth_0-360.yymmdd.nc" ; further details see paleo docs or tech note
gridfile ="/your/inputdata/path/here/for/default_1850/cami_0000-09-01_1.9x2.5_L26_c040809.nc"
;any file with grid info will work, i.e. lat/lon 

filo = "yourtopo_1.9x2.5_topodepth_0-360.yyddmm.nc"  ;edit for your paleo file name

system("/bin/rm -f " + filo)
fout = addfile(filo,"c")

fin  = addfile(fili,"r")
ilat = fin->lat
ilon = fin->lon
topf = fin->topo_depth
print("topf = " + topf(0:4,0))

fg  = addfile(gridfile,"r")
lat = fg->lat
lon = fg->lon
nlat = dimsizes(lat)
nlon = dimsizes(lon)


  top = linint2_Wrap (ilon,ilat,topf, True, lon,lat, 0)
print("top = " + top(0:4,0))
  top@long_name = " topo/bathy fv2deg resolution"

printVarSummary(top)

; cas sometimes end lat/lon are missing if interpolating up...kludge fix
 top(0,:) = top(1,:)
 top(nlat-1,:) = top(nlat-2,:)


  fileAtt               = True
  fileAtt@creation_date = systemfunc("date")
  fileAtt@input         = fili 
  fileAtt@src           = "createfv2deg.ncl"
  fileAtt@contents      = " topo + bathymetry fv2deg"
  fileattdef(fout, fileAtt)

  dimNames = (/"lat","lon"/)
  dimSizes = (/nlat,nlon/)
  dimUnlim = (/False,False/)
  filedimdef(fout,dimNames,dimSizes,dimUnlim)
  filevardef(fout,"topo","float",(/"lat","lon"/))    
  filevardef(fout,"lat",typeof(lat),"lat")
  filevardef(fout,"lon",typeof(lon),"lon")
  fout->topo = (/top/)
  fout->lat = (/lat/)
  fout->lon = (/lon/)

  delete(filo)
  delete(fin)
end
    


