;=========================================================; 
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";

begin

fili = "/your/path/here/yourtopo_2x2_topodepth_0-360.yymmdd.nc" ;further details see paleo docs or tech note 
filo = "yourtopo_1deg_topodepth_0-360.yymmdd.nc"  ; edit for your file name

fin  = addfile(fili,"r")
system("/bin/rm -f " + filo)
fout = addfile(filo,"c")

ilat = fin->lat
ilon = fin->lon
topf = fin->topo_depth

 nlat = 180
 nlon = 360
 lon = new((/nlon/),float)
 lat = new((/nlat/),float)

 ; create lon
 sl = 0.5
 do i = 0,nlon-1
        lon(i) = sl 
	sl = sl + 1.0
  end do

  ; create lat
  sl = -89.5
  do i = 0,nlat-1
        lat(i) = sl
        sl = sl + 1.0
  end do

  lat!0="lat"
  lon!0="lon"

print("topf = " + topf(0:4,0))

  top = linint2_Wrap (ilon,ilat,topf, True, lon,lat, 0)
print("top = " + top(0:4,0))
  top@long_name = "pt topo/bathy 1x1 resolution"

printVarSummary(top)

; cas sometimes end lat/lon are missing if interpolating up...kludge fix
 top(0,:) = top(1,:)
 top(nlat-1,:) = top(nlat-2,:)


  fileAtt               = True
  fileAtt@creation_date = systemfunc("date")
  fileAtt@input         = fili 
  fileAtt@src           = "create0.5x0.5.ncl"
  fileAtt@contents      = "topo + bathymetry 0.5x0.5"
  fileattdef(fout, fileAtt)

  dimNames = (/"lat","lon"/)
  dimSizes = (/nlat,nlon/)
  dimUnlim = (/False,False/)
  filedimdef(fout,dimNames,dimSizes,dimUnlim)
  filevardef(fout,"topo","float",(/"lat","lon"/))    
  filevardef(fout,"lat",typeof(lat),"lat")
  filevardef(fout,"lon",typeof(lon),"lon")
  fout->topo = (/top/)
  fout->lat = (/lat/)
  fout->lon = (/lon/)

  delete(filo)
  delete(fin)
end
    


