;=========================================================; 
; for bulk aerosol cam4 forcing:
; read in template cam soil erodibilty (dust) (dst_*.nc)
; read in paleo surface_data set
; dst_*.nc and paleo file should both be on final model grid (i.e. t31)
; make modifications, interpolate back to original grid
; write out new files
; NOTE: mods are paleo period dependent
; USE as GUIDE, make changes appropriate for your paleo period
; this code uses generic value for dust
; all land points set to globl (wgt) avg from pre-I over land points only 
;
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters

filename_surf= "/your/path/here/lnd/mksurfdata/surfdata_48x96_PALEOCASE_ccsm4.yymmdd.nc" 
;your sfcdata file for your paleo case, computed using mksurfdata release tool.  
;for further details, see ccsm4 for paleo doc (ppt) or email shields@ucar.edu

filename_template= "/your/inputdata/path/here/for/default_1850/dst_48x96_c090203.nc" 

new_cdf         = "dst_48x96_PALEOCASE.cyymmdd.nc" ; edit paleocase and yymmdd


;=============== read in atm template netcdf files
; note: same grid for all
 
f = addfile(filename_template,"r")
lat  = f->lat
lon  = f->lon
mbl_bsn_fct_geo = f->mbl_bsn_fct_geo
nlat = dimsizes(lat) 
nlon = dimsizes(lon) 
print("nlon = " + nlon)
print("nlat = " + nlat)

;=============== read in land/topo on paleo grid
;                read in  modern landmask on same grid as paleo

;paleo 
pland = addfile(filename_surf,"r")
lf   = pland->LANDFRAC_PFT
lat2d = pland->LATIXY
lon2d = pland->LONGXY
dims = dimsizes(lat2d)
nplat = dims(0) 
nplon = dims(1) 

if(nplat.ne.nlat)then
 print("paleo and modern should be on same grid")
 exit
end if


;================= make mods

; dust is based on landuse and is computed within the model
; for soil erod forcing file apply zonal average from modern (n.mahowald)  

;compute zonal values for modern over land only
modern = mask(mbl_bsn_fct_geo,lf.ne.0,True)
rad    = 4.0*atan(1.0)/180.0
clat   = cos(lat*rad)
gmod = wgt_areaave(modern, clat, 1.0, 0)

;shape paleo array
pmbl_bsn_fct_geo = mbl_bsn_fct_geo
pmbl_bsn_fct_geo = 0.  ; initialize to zero
delete(mbl_bsn_fct_geo)

;assign dust factor, i.e. "surface area accumulation factor" 
do nlt = 0, nlat-1
do nln = 0, nlon-1
 if(lf(nlt,nln).gt.0)then
  pmbl_bsn_fct_geo(nlt,nln) = gmod 
 end if 
end do
end do 

;========create new file surface file

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new dst file....")

; define dimensions
dimNames = (/"lat","lon"/)
dimSizes = (/ nlat, nlon/)
dimUnlim = (/ False, False/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)
filevardef(cdf,"lat","double",(/"lat"/))
filevardef(cdf,"lon","double",(/"lon"/))
filevardef(cdf,"mbl_bsn_fct_geo","double",(/"lat","lon"/))

; write variables
cdf->lat    = lat
cdf->lon    = lon
cdf->mbl_bsn_fct_geo =  pmbl_bsn_fct_geo 

; create file attributes
cdf@template_hist = f@history
cdf@template = "template = " + filename_template 
cdf@surf = "surface_data = " + filename_surf
cdf@info = "based on modern zonal avg over land" ; add comments if desired, name date recommended



print(new_cdf + " has been written")


end
    


