;=========================================================; 
; for bulk aerosol cam4 forcing:
; read in template cam oxid (Netcdf) file
; read in default (2deg) landfrac valid for template file
; read in paleo 2 deg landmask (or same grid as template) 
; read in 2 deg ps (from old run, interpolated to 2deg grid 
; or you can compute ps from scratch
; makes modifications, writes out new file
; use modern land (zonal) avg to approx paleo land
; use modern ocean (zonal) avg to approx paleo ocean
; USE as GUIDE, make changes appropriate for your paleo period
; fine tune for pangea... fix 40S by implementing hemispheric symmetry 
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters

filename_land= "/your/path/here/yourtopo_1.9x2.5_topodepth_0-360.yymmdd.nc" 

filename_defland= "/your/inputpath/here/LANDFRAC_cami_0000-09-01_1.9x2.5_L26_c040809.nc" 

filename_ps= "/your/path/here/PS_b40.t31x3.pt.1_33-52_AC_climo.nc" 
;optional, can compute from scratch based on topo by setting flag_ps to 0 

filename_template= "/your/inputdata/path/for/default_1850/oxid_1.9x2.5_L26_1850clim_c091123.nc" 


new_cdf          = "oxid_1.9x2.5_l26_PALEOCASEclim_cyyddmm.nc"  ;edit paleocase and yymmdd

flag_ps  = 1; 0   ; 1 read in ps climo from file or
		 ; 0 compute from scratch...will be same for all monthts


;=============== read in atm template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
lev  = atm->lev
ilev = atm->ilev
time = atm->time
datesec = atm->datesec
date = atm->date
gw = atm->gw
hyai = atm->hyai
hyam = atm->hyam
hybi = atm->hybi
hybm = atm->hybm
slat  = atm->slat
slon  = atm->slon
P0    = atm->P0
PS    = atm->PS
H2O2  = atm->H2O2
HO2   = atm->HO2
NO3   = atm->NO3
O3   = atm->O3
OH   = atm->OH

nlat = dimsizes(lat) 
nlon = dimsizes(lon) 
nslon = dimsizes(slon) 
nslat = dimsizes(slat) 
nlev  = dimsizes(lev)
nilev = dimsizes(ilev)
ntimes=  dimsizes(time)
print("nlon = " + nlon)
print("nlat = " + nlat)

;=============== read in land/topo
 
land = addfile(filename_land,"r")
topo = land->topo

land2deg = addfile(filename_defland,"r")
lf = land2deg->LANDFRAC(0,:,:)
lfC = conform(H2O2,lf,(/2,3/))
printVarSummary(lfC)

;======== read in ps file

if(flag_ps.eq.1)then

psfile = addfile(filename_ps,"r")
psold  = psfile->PS  ; (time,lat,lon) climo
oldlat = psfile->lat
oldlon = psfile->lon

ps = linint2_Wrap (oldlon,oldlat,psold, True, lon,lat, 0)

;kludge when interpolating for up... end lats may be missing
ps(:,0,:) = ps(:,2,:)
ps(:,1,:) = ps(:,2,:)
ps(:,nlat-2,:) = ps(:,nlat-3,:)
ps(:,nlat-1,:) = ps(:,nlat-3,:)

else 

; ===OR ======== compute PS (same as for cami file)
; make eq-pole temp gradient = half cosine wave
; use for all 12 months...or, if you have monthly ps
; for previous experiment, read in and use this instead

ps = PS  ;copy shape and attributes
t = H2O2 ; give temp 3d shape 
; make ocean values 0 (no bathymetry values for ps calculation)
topo@_FillValue = 0.
topo = mask(topo,topo.lt.0,False)
delete(topo@_FillValue)

      cst = new(nlat,float)
      degrad = 0.0174533  ; conversion of degrees to radians
      temppole = 12.
      tempeq   = 28.
      latr = dble2flt(lat)*degrad
      cst= cos(latr) 
      cstC = conform(t,cst,2)
      t= temppole + (tempeq-temppole)*cstC
      t = t + 273.15
      topC = conform(ps,topo,(/1,2/))
      z1 = 0.
      slp = 101200.
      z2 = topC ;array(tim,elat,lon)
      H  = 29.3*( t(:,0,:,:) )  ; convert t to deg K
      ps = slp* ( exp(-(z2-z1)/H) )
      print("ps calculated")

end if

;================= make mods

;--computing 1850 (default) avg values over land and ocean per latitude

lh2o2 = mask(H2O2,lf.ne.0,True)
lho2 = mask(HO2,lf.ne.0,True)
lno3 = mask(NO3,lf.ne.0,True)
print("ocean pt should be missing: " +lh2o2(0,0,48,78))

oh2o2 = mask(H2O2,lf.ne.1,True)
oho2 = mask(HO2,lf.ne.1,True)
ono3 = mask(NO3,lf.ne.1,True)
print("ocean pt should have value: " +oh2o2(0,0,48,78))

;land lat avs for default
lh2o2av = new((/ntimes,nlev,nlat/),float)
lho2av = new((/ntimes,nlev,nlat/),float)
lno3av = new((/ntimes,nlev,nlat/),float)

;ocean lat avs for default
oh2o2av = new((/ntimes,nlev,nlat/),float)
oho2av = new((/ntimes,nlev,nlat/),float)
ono3av = new((/ntimes,nlev,nlat/),float)

;just zonal 
; compute zonal averages for all in case there are lats with either
; all land or ocean on default grid and the opposite on the paleo grid
; (avoid missing data)
; utlimately hand fix places for your individual needs

o3av = new((/ntimes,nlev,nlat/),float)
ohav = new((/ntimes,nlev,nlat/),float)
h2o2av = new((/ntimes,nlev,nlat/),float)
ho2av = new((/ntimes,nlev,nlat/),float)
no3av = new((/ntimes,nlev,nlat/),float)

;copy over attributes and shape
h2o2 = H2O2 
ho2 = HO2 
no3 = NO3 
o3 = O3 
oh = OH 

;zero out
h2o2 = 0.
ho2 = 0.
no3 = 0.
o3 = 0.
oh = 0.


;compute zonal averages from default grid
do nlt = 0,nlat-1
 o3av(:,:,nlt) = dim_avg(O3(:,:,nlt,:))
 ohav(:,:,nlt) = dim_avg(OH(:,:,nlt,:))
 h2o2av(:,:,nlt) = dim_avg(H2O2(:,:,nlt,:))
 ho2av(:,:,nlt) = dim_avg(HO2(:,:,nlt,:))
 no3av(:,:,nlt) = dim_avg(NO3(:,:,nlt,:))

 lh2o2av(:,:,nlt) = dim_avg(lh2o2(:,:,nlt,:))
 lho2av(:,:,nlt) = dim_avg(lho2(:,:,nlt,:))
 lno3av(:,:,nlt) = dim_avg(lno3(:,:,nlt,:))

 oh2o2av(:,:,nlt) = dim_avg(oh2o2(:,:,nlt,:))
 oho2av(:,:,nlt) = dim_avg(oho2(:,:,nlt,:))
 ono3av(:,:,nlt) = dim_avg(ono3(:,:,nlt,:))
end do

;--- assign paleo values over land/ocean per latitude


;modify over land/ocean
do nln = 0,nlon-1
do nlv = 0,nlev-1
 do nlt = 0,nlat-1
 if(topo(nlt,nln).gt.0)then ; fill in land
  h2o2(:,nlv,nlt,nln) = (/lh2o2av(:,nlv,nlt)/)
  ho2(:,nlv,nlt,nln) = (/lho2av(:,nlv,nlt)/)
  no3(:,nlv,nlt,nln) = (/lno3av(:,nlv,nlt)/)
 else
  h2o2(:,nlv,nlt,nln) = (/oh2o2av(:,nlv,nlt)/)
  ho2(:,nlv,nlt,nln) = (/oho2av(:,nlv,nlt)/)
  no3(:,nlv,nlt,nln) = (/ono3av(:,nlv,nlt)/)
 end if
 end do
end do
end do

;====== final general adjustments
; copy just zonal averages (o3 and oh)
; also test to see if both land and ocean data area missing, if so, fill in 
; with zonal average
datamiss = ismissing(h2o2)
do nt = 0,ntimes-1
do nlt = 0,nlat-1
do nln = 0,nlon-1
do nlv = 0,nlev-1
 o3(nt,nlv,nlt,nln) = (/o3av(nt,nlv,nlt)/)
 oh(nt,nlv,nlt,nln) = (/ohav(nt,nlv,nlt)/)
 if(datamiss(nt,nlv,nlt,nln).eq.True)then
  h2o2(nt,nlv,nlt,nln) = (/h2o2av(nt,nlv,nlt)/)
  ho2(nt,nlv,nlt,nln) = (/ho2av(nt,nlv,nlt)/)
  no3(nt,nlv,nlt,nln) = (/no3av(nt,nlv,nlt)/)
 end if
end do
end do
end do
end do


;===== P/T adjust, hemsipheric symmetry (account for seasonal symmetry) for h2o2

lh2o2av!2 = "lat"
lh2o2av&lat = lat
oh2o2av!2 = "lat"
oh2o2av&lat = lat
lho2av!2 = "lat"
lho2av&lat = lat
oho2av!2 = "lat"
oho2av&lat = lat
lno3av!2 = "lat"
lno3av&lat = lat
ono3av!2 = "lat"
ono3av&lat = lat
do nv = 0,nlev-1
do nt = 0,5
 flipseas = nt + 6
 do nlt= 0,nlat-1
 fliplat = lat(nlt)* -1.
 do nln= 0,nlon-1
 if(topo(nlt,nln).ge.0.and.lat(nlt).lt.-30.and.lat(nlt).gt.-80.)then
  h2o2(flipseas,nv,nlt,nln) =  (/lh2o2av(nt,nv,{fliplat})/)
  ho2(flipseas,nv,nlt,nln) =  (/lho2av(nt,nv,{fliplat})/)
  no3(flipseas,nv,nlt,nln) =  (/lno3av(nt,nv,{fliplat})/)
 else
 if(topo(nlt,nln).lt.0.and.lat(nlt).lt.-30.and.lat(nlt).gt.-80.)then
  h2o2(flipseas,nv,nlt,nln) =  (/oh2o2av(nt,nv,{fliplat})/)
  ho2(flipseas,nv,nlt,nln) =  (/oho2av(nt,nv,{fliplat})/)
  no3(flipseas,nv,nlt,nln) =  (/ono3av(nt,nv,{fliplat})/)
 end if
 end if
 end do
 end do
end do
do nt = 6,11
 flipseas = nt - 6
 do nlt= 0,nlat-1
 fliplat = lat(nlt)* -1.
 do nln= 0,nlon-1
 if(topo(nlt,nln).ge.0.and.lat(nlt).lt.-30.and.lat(nlt).gt.-80.)then
  h2o2(flipseas,nv,nlt,nln) =  (/lh2o2av(nt,nv,{fliplat})/)
  ho2(flipseas,nv,nlt,nln) =  (/lho2av(nt,nv,{fliplat})/)
  no3(flipseas,nv,nlt,nln) =  (/lno3av(nt,nv,{fliplat})/)
 else
 if(topo(nlt,nln).lt.0.and.lat(nlt).lt.-30.and.lat(nlt).gt.-80.)then
  h2o2(flipseas,nv,nlt,nln) =  (/oh2o2av(nt,nv,{fliplat})/)
  ho2(flipseas,nv,nlt,nln) =  (/oho2av(nt,nv,{fliplat})/)
  no3(flipseas,nv,nlt,nln) =  (/ono3av(nt,nv,{fliplat})/)
 end if
 end if
 end do
 end do
end do
end do


;=== apply a smoother to h2o2 (land signal)
p = .5
q = .25   ;  -.25 = light local smoothing... +.25 =heavy
cyclic = True
h2o2 = smth9_Wrap(h2o2,p,q,cyclic)

;========create new file surface file

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new oxid file....")

; define dimensions
dimNames = (/"lat","lon","slat","slon","lev","ilev","time"/)
dimSizes = (/ nlat, nlon,nslat,nslon,nlev,nilev,ntimes/)
dimUnlim = (/ False,False,False, False, False, False,True/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"gw","double",(/"lat"/))
filevardef(cdf,"hyai","double",(/"ilev"/))
filevardef(cdf,"hyam","double",(/"lev"/))
filevardef(cdf,"hybi","double",(/"ilev"/))
filevardef(cdf,"hybm","double",(/"lev"/))
filevardef(cdf,"lat","double",(/"lat"/))
filevardef(cdf,"lon","double",(/"lon"/))
filevardef(cdf,"slat","double",(/"slat"/))
filevardef(cdf,"slon","double",(/"slon"/))
filevardef(cdf,"lev","double",(/"lev"/))
filevardef(cdf,"ilev","double",(/"ilev"/))
filevardef(cdf,"time","double",(/"time"/))
filevardef(cdf,"date","integer",(/"time"/))
filevardef(cdf,"datesec","integer",(/"time"/))
filevardef(cdf,"PS","float",(/"time","lat","lon"/))
filevardef(cdf,"H2O2","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"HO2","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"NO3","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"O3","float",(/"time","lev","lat","lon"/))
filevardef(cdf,"OH","float",(/"time","lev","lat","lon"/))

; write variables
cdf->gw     = gw
cdf->hyai     = hyai 
cdf->hyam     = hyam 
cdf->hybi     = hybi 
cdf->hybm     = hybm 
cdf->lat    = lat
cdf->lon    = lon
cdf->slat    = slat
cdf->slon    = slon
cdf->lev    = lev
cdf->ilev    = ilev
cdf->time   = time 
cdf->date   = date
cdf->datesec = datesec
cdf->P0 =  P0
cdf->H2O2 =  h2o2 
cdf->HO2 = ho2
cdf->NO3 = no3 
cdf->O3 =  o3
cdf->OH =  oh 
cdf->PS =  ps 

; create file attributes
cdf@template_hist = atm@history
cdf@template = "template = " + filename_template 
cdf@topo = "topo = " + filename_land
if(flag_ps.eq.1)then
 cdf@psfile = "interpolated to fv2deg ps = " + filename_ps 
else
 cdf@psfile = "ps = computed from scratch using zonalt and topo template" 
end if
cdf@info = "your info here"  ;edit for your info


print(new_cdf + " has been written")


end
    


