;=========================================================; 
; for bulk aerosol cam4 forcing:
; read in template cam aerocom_SO2_vertical (Netcdf) file 
; read in paleo 1 deg landmaks (or same grid as template)
; makes modifications, writes out new file
; if volcanoes know, set point locales, otherwise zero.
; see comments for paleo details
; USE as GUIDE, make changes appropriate for your paleo period
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters

;filename_template= "/your/inputdata/path/here/for/default_1850/aerocom_SO2_vertical_1750.c080807.nc" 
;new_cdf          = "aerocom_S02_vertical_PALEOCASE.cyyddmm.nc" ; edit palecase and yymmdd

filename_template= "/your/inputdata/path/here/for/default_1850/aerocom_SO4_vertical_1750.c080807.nc" 
new_cdf          = "aerocom_S04_vertical_PALEOCASE.cyymmdd.nc" ;edit paleocase and yymmdd

filename_land= "/your/path/here/yourtopo_1deg_topodepth_0-360.yymmdd.nc"  ;edit topo location

izero = 1  ; 0 or 1  0=assign zero everywhere  1=give pt volcano locations

;=============== read in atm template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
time = atm->time
datesec = atm->datesec
date = atm->date
altitude = atm->altitude
altitude_int = atm->altitude_int
FIRE = atm->FIRE
VOLC = atm->VOLC
nlat = dimsizes(lat) 
nlon = dimsizes(lon) 
ntimes=  dimsizes(time)
nalt = dimsizes(altitude)
naltint = dimsizes(altitude_int)
print("nlon = " + nlon)
print("nlat = " + nlat)
printVarSummary(FIRE)
printVarSummary(VOLC)

;=============== read in land/topo

land = addfile(filename_land,"r")
topo = land->topo


;================= make mods
;Modern world default values had only small point values, assuming based on volcanoes.
;Paleo world set max modern SO2/SO4 value at altitude to a couple points in NH for siberain traps.
;If nothing is know about volcanoes, set to zero.

; initialize to zero
fire = FIRE
fire = 0.

volc = VOLC
volc = 0.
 

if (izero.ne.0)then

 print("assigning volcano points")

;find index (altitude) for max values
 firemax = max(FIRE)
 volmax = max(VOLC)

;divide by 2 to assign a low value
 fired2 = firemax/2.
 vold2  = volmax/2.
;assign point locations
;siberian trap points: max above 45n, at land, and topo > 1900
;                mod value "              " 1700 < topo > 1900 

 do nt = 0,ntimes-1
 do nlt = 0,nlat-1
 do nln = 0,nlon-1
  if(lat(nlt).gt.45.and.topo(nlt,nln).gt.1900)then  
   fire(nt,0,nlt,nln) = firemax
   volc(nt,0,nlt,nln) = volmax 
   print("mx volc at  nlt nln " + nlt + " " + nln)
  else
  if(lat(nlt).gt.45.and.topo(nlt,nln).gt.1700.and.topo(nlt,nln).le.1900)then  
   fire(nt,0,nlt,nln) = fired2
   volc(nt,0,nlt,nln) = vold2
   print("mod volc at  nlt nln " + nlt + " " + nln)
  end if
  end if
 end do
 end do
 end do

end if


;========create new file surface file

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new SO2/SO4 vertical file....")

; define dimensions
dimNames = (/"lat","lon","altitude","altitude_int","time"/)
dimSizes = (/ nlat, nlon,nalt,naltint,ntimes/)
dimUnlim = (/ False,  False, False, False, True/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"lat","float",(/"lat"/))
filevardef(cdf,"lon","float",(/"lon"/))
filevardef(cdf,"time","float",(/"time"/))
filevardef(cdf,"date","integer",(/"time"/))
filevardef(cdf,"datesec","integer",(/"time"/))
filevardef(cdf,"altitude","float",(/"altitude"/))
filevardef(cdf,"altitude_int","float",(/"altitude_int"/))
filevardef(cdf,"FIRE","double",(/"time","altitude","lat","lon"/))
filevardef(cdf,"VOLC","double",(/"time","altitude","lat","lon"/))

; write variables
cdf->lat    = lat
cdf->lon    = lon
cdf->time   = time 
cdf->date   = date
cdf->datesec = datesec
cdf->altitude   = altitude 
cdf->altitude_int   = altitude_int 
cdf->VOLC = volc 
cdf->FIRE  = fire 

; create file attributes
cdf@domxmin = atm@domxmin 
cdf@domxmax = atm@domxmax
cdf@domymax = atm@domymax
cdf@domymin = atm@domymin
cdf@domtminmax = atm@domtmin + " to " + atm@domtmax + " month"
cdf@template_hist = atm@history
cdf@template = "template = " + filename_template 
cdf@paleoSO2vert = "setting volcanos   name date"  ; edit name date

print(new_cdf + " has been written")


end
    


