;=========================================================; 
; for bulk aerosol cam4 forcing:
; read in template cam aerocom_SO2_surface (Netcdf) file (or SO4) 
; makes modifications, writes out new file
; generic paleo set to zero.
; USE as GUIDE, make changes appropriate for your paleo period
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters


;filename_template= "/your/inputdata/path/here/for/default_1850/aerocom_SO2_surface_1750.c080807.nc" 
filename_template= "/your/inputdata/path/here/for/default_1850/aerocom_SO4_surface_1750.c080807.nc" 

;new_cdf          = "aerocom_S02_surface_PALEOCASE.cyyddmm.nc"  ; edit paleocase and yymmdd
new_cdf          = "aerocom_S04_surface_PALEOCASE.cyyddmm.nc"


;=============== read in atm template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
time = atm->time
datesec = atm->datesec
date = atm->date
Domestic = atm->Domestic
nlat = dimsizes(lat) 
nlon = dimsizes(lon) 
ntimes=  dimsizes(time)
print("nlon = " + nlon)
print("nlat = " + nlat)


;================= make mods


domestic = Domestic; give shape and coords
domestic = 0.  ; zero out 


;========create new file surface file

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new SO2/SO4 surface file....")

; define dimensions
dimNames = (/"lat","lon","time"/)
dimSizes = (/ nlat, nlon,ntimes/)
dimUnlim = (/ False, False, True/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"lat","float",(/"lat"/))
filevardef(cdf,"lon","float",(/"lon"/))
filevardef(cdf,"time","float",(/"time"/))
filevardef(cdf,"date","integer",(/"time"/))
filevardef(cdf,"datesec","integer",(/"time"/))
filevardef(cdf,"Domestic","float",(/"time","lat","lon"/))

; write variables
cdf->lat    = lat
cdf->lon    = lon
cdf->time   = time 
cdf->date   = date
cdf->datesec = datesec
cdf->Domestic = domestic 

; create file attributes
cdf@template_hist = atm@history
cdf@template = "template = " + filename_template 
cdf@paleo = "set to zero   name date"  ;edit name date

print(new_cdf + " has been written")


end
    


