;=========================================================; 
; for bulk aerosol cam4 forcing:
; read in template cam DMS OC and CB (Netcdf) file
; read in paleo landmask
; read in landmask for default (modern) grid; same grid as paleo 
; interpolate DMS,OC,CB to landmask grid
; make modifications, interpolate back to original grid
; zero out human influnced bio fuels, only assign fire
; write out new files
; NOTE: mods are paleo period dependent. only use this code as a GUIDE
; originally written for PT (pangean style continent, symmetric about equator)
;
; cas thoughts on paleo design:
; fire where vegetation;  0 over oceans
; hxml indcators for dms (strong ocean mixing)
; pangean make fields symmetric about equator 
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters

filename_land= "/your/path/here//yourtopo_1.9x2.5_topodepth_0-360.yymmdd.nc" 

filename_defland= "/your/inputdata/here/LANDFRAC_cami_0000-09-01_1.9x2.5_L26_c040809.nc" 
; you can use any default file that has landfrac...

f_template_DMS= "/your/inputdata/path/here/for/default_1850/aerocom_DMS_2000.c080417.nc" 
f_template_CB= "/your/inputdata/path/here/for/default_1850/aerocom_CB1_1750.c080807.nc" 
f_template_OC= "/your/inputdata/path/here/for/default_1850/aerocom_OC1_1750.nosoa.c080807.nc" 


new_cdf_DMS         = "aerocom_DMS_PALEOCASE.cyymmdd.nc"  ;edit paleocase and yymmdd
new_cdf_CB          = "aerocom_CB1_PALEOCASE.cyymmdd.nc"
new_cdf_OC          = "aerocom_OC1_PALEOCASE.cyymmdd.nc"


;=============== read in atm template netcdf files
; note: same grid for all
 
fdms = addfile(f_template_DMS,"r")
foc = addfile(f_template_OC,"r")
fcb = addfile(f_template_CB,"r")
lat  = fdms->lat
lon  = fdms->lon
time = fdms->time
datesec = fdms->datesec
date = fdms->date
DMS = fdms->DMS
FIRE_cb = fcb->FIRE
BioFuel_cb = fcb->BioFuel
FIRE_oc = foc->FIRE
BioFuel_oc = foc->BioFuel

nlat = dimsizes(lat) 
nlon = dimsizes(lon) 
ntimes=  dimsizes(time)
print("nlon = " + nlon)
print("nlat = " + nlat)

;=============== read in land/topo on paleo grid
;                read in  modern landmask on same grid as paleo

;paleo 
pland = addfile(filename_land,"r")
topo = pland->topo
plat = pland->lat
plon = pland->lon
nplat = dimsizes(plat)
nplon = dimsizes(plon)

;modern 
mland = addfile(filename_defland,"r")
mlf = mland->LANDFRAC(0,:,:)
mlat = mland->lat
mlon = mland->lon

if(dimsizes(plat).ne.dimsizes(mlat))then
 print("paleo and modern should be on same grid")
 exit
end if

;==== interpolate dms,oc,bc to above grid

dmsI = linint2_Wrap (lon,lat,DMS, True, plon,plat, 0)
fire_cbI = linint2_Wrap (lon,lat,FIRE_cb, True, plon,plat, 0)
fire_ocI = linint2_Wrap (lon,lat,FIRE_oc, True, plon,plat, 0)
print("interopolating dms, oc, bc to modern/paleo landmask grid -- faster if lower rez")

;================= make mods

;-----computing DMS 1850 (default) avg values over land and ocean per latitude

;conform landmask to default array
lfC = conform(dmsI,mlf,(/1,2/))

;mask over ocean, land pts only
ldms = mask(dmsI,lfC.ne.0,True)
print("ocean pt should be missing: " +ldms(0,48,78))

;mask over land, ocean pts only
odms = mask(dmsI,lfC.eq.0,True)
print("ocean pt should have value: " +odms(0,48,78))

dmsav     = new((/ntimes,nplat/),float)
ldmsav = new((/ntimes,nplat/),float)
odmsav = new((/ntimes,nplat/),float)
do nlt = 0,nplat-1
 dmsav(:,nlt) = dim_avg(dmsI(:,nlt,:))
 ldmsav(:,nlt) = dim_avg(ldms(:,nlt,:))
 odmsav(:,nlt) = dim_avg(odms(:,nlt,:))
end do

;--computing OC, BC non-ocean, non zero average per latitude
lfire_cbav = new((/ntimes,nplat/),float)
lfire_ocav = new((/ntimes,nplat/),float)

; mask over ocean, land pts only
lfire_cb = mask(fire_cbI,lfC.ne.0.,True)
lfire_oc = mask(fire_ocI,lfC.ne.0.,True)
print("ocean pt should be missing: " +lfire_cb(0,48,78))

;mask over zero
;comment out if you wish to include zeros in average
lfire_cb = mask(lfire_cb,lfire_cb.eq.0,False)
lfire_oc = mask(lfire_oc,lfire_oc.eq.0,False)

;zonal avg
do nlt = 0,nplat-1
 lfire_cbav(:,nlt) = dim_avg(lfire_cb(:,nlt,:))
 lfire_ocav(:,nlt) = dim_avg(lfire_oc(:,nlt,:))
end do

;compute global non-zero average over land
rad    = 4.0*atan(1.0)/180.0
clat   = cos(plat*rad)
lfire_cb_g = wgt_areaave(lfire_cb, clat, 1.0, 0)
lfire_oc_g = wgt_areaave(lfire_oc, clat, 1.0, 0)

print("modern zonal averages computed")


;full paleo grid
pdms     = new((/ntimes,nplat,nplon/),float)
pfire_cb = new((/ntimes,nplat,nplon/),float)
pfire_oc = new((/ntimes,nplat,nplon/),float)

;zero out
pdms = 0.
pfire_cb = 0.
pfire_oc = 0.

;--- assign paleo values over land/ocean per latitude
;modify over land/ocean
do nln = 0,nplon-1
 do nlt = 0,nplat-1
 if(topo(nlt,nln).ge.0)then ; fill in land
  pdms(:,nlt,nln) = (/ldmsav(:,nlt)/)
  pfire_cb(:,nlt,nln) = (/lfire_cbav(:,nlt)/)
  pfire_oc(:,nlt,nln) = (/lfire_ocav(:,nlt)/)
 else
  pdms(:,nlt,nln) = (/odmsav(:,nlt)/)
 end if
 end do
end do
print("assigned to paleo over respective land/ocean pts")

; also test to see if both land and ocean data area missing, if so, fill in 
; with zonal average
dmsmiss = ismissing(pdms)
datamiss = ismissing(pfire_cb)
do nlt = 0,nplat-1
do nln = 0,nplon-1
 if(dmsmiss(0,nlt,nln).eq.True)then
  pdms(:,nlt,nln) = (/dmsav(:,nlt)/)
 end if
 if(datamiss(0,nlt,nln).eq.True)then
  pfire_cb(:,nlt,nln) = (/lfire_cbav(:,nlt)/)
  pfire_oc(:,nlt,nln) = (/lfire_ocav(:,nlt)/)
 end if
end do
end do
print("check/correction completed for missing where land/ocean inconsistenties")

;=== specific to permian/triassic (pangean),
;  correct over 39S (roaring 40s modern not comparable to 40S pangea) 
;  apply some hemispheric symmetric, account for seasonality 
;  carbons: fire already ~symmetric, don't adjust;  biofuel = 0  
;  reference for dms: high w/larger hxml 

topoC = conform(pdms,topo,(/1,2/))

topoC!1 = "lat"
topoC&lat = plat

; +/13degress at poles should be zero following modern
pdms!1 = "lat" 
pdms&lat = plat
dmsfillvalue = 0. 
pdms(:,{-90:-77},:) = 0.
pdms(:,{77:90},:) = 0.

;land dms fix @ 40S, get rid of high values over land
;keep seasonality so apply fix by month
do nt = 0, 5
 flipseas = nt + 6
 dmsfillvalue = pdms(nt,{30},0)
 pdms(flipseas,{-90:-30},:) = where(pdms(nt,{-90:-30},:).gt.1e8.and.topoC(nt,{-90:-30},:).ge.0, dmsfillvalue, pdms(nt,{-90:-30},:))
end do
do nt = 6, 11 
 flipseas = nt - 6
 dmsfillvalue = pdms(nt,{30},0)
 pdms(flipseas,{-90:-30},:) = where(pdms(nt,{-90:-30},:).gt.1e8.and.topoC(nt,{-90:-30},:).ge.0, dmsfillvalue, pdms(nt,{-90:-30},:))
end do

; ocean dms fixes: none for now, ocean has some symmetry already
;pdms!1 = "lat"
;pdms&lat = plat
;pdms(:,{-77:-67},:) = 

;lnd fire hemisphere symmetry fix 
lfire_cbav!1 = "lat" 
lfire_cbav&lat = plat
lfire_ocav!1 = "lat" 
lfire_ocav&lat = plat

do nlt = 0,nplat-1
do nln = 0,nplon-1

 if(topoC(1,nlt,nln).ge.0.and.lat(nlt).lt.-30.and.lat(nlt).gt.-80.)then
 pfire_cb(0:5,nlt,nln) = lfire_cbav(6:11,nplat-nlt-1)
 pfire_cb(6:11,nlt,nln) = lfire_cbav(0:5,nplat-nlt-1)
 pfire_oc(0:5,nlt,nln) = lfire_ocav(6:11,nplat-nlt-1)
 pfire_oc(6:11,nlt,nln) = lfire_ocav(0:5,nplat-nlt-1)
 end if

end do
end do


;missing data fixes
firecb_miss = ismissing(pfire_cb)
fireoc_miss = ismissing(pfire_oc)
do nt = 0,ntimes-1
do nlt = 0,nplat-1
do nln = 0,nplon-1
 if(firecb_miss(nt,nlt,nln).eq.True)then
   pfire_cb(nt,nlt,nln) = lfire_cb_g(nt) 
 end if
 if(fireoc_miss(nt,nlt,nln).eq.True)then
   pfire_oc(nt,nlt,nln) = lfire_oc_g(nt) 
 end if
end do
end do
end do

print("Making Pangean (P/T) specific changes")

;==== interopolate back to 1 deg grid

;copy over attributes and shape
dms = DMS 
fire_cb = FIRE_cb 
fire_oc = FIRE_oc 
bio_cb = BioFuel_cb 
bio_oc = BioFuel_oc 

dms = (/linint2_Wrap (plon,plat,pdms, True, lon,lat, 0)/)
fire_cb = (/linint2_Wrap (plon,plat,pfire_cb, True, lon,lat, 0)/)
fire_oc = (/linint2_Wrap (plon,plat,pfire_oc, True, lon,lat, 0)/)
bio_cb =  0.
bio_oc =  0.
print("interpolating dms, oc, bc back to 1 degree grid")

;kludge fix due to interpolating up
dms(:,0,:) = dms(:,2,:)
dms(:,1,:) = dms(:,2,:)
fire_cb(:,0,:) = fire_cb(:,2,:)
fire_cb(:,1,:) = fire_cb(:,2,:)
fire_oc(:,0,:) = fire_oc(:,2,:)
fire_oc(:,1,:) = fire_oc(:,2,:)

dms(:,nlat-1,:) = dms(:,nlat-3,:)
dms(:,nlat-2,:) = dms(:,nlat-3,:)
fire_cb(:,nlat-1,:) = fire_cb(:,nlat-3,:)
fire_cb(:,nlat-2,:) = fire_cb(:,nlat-3,:)
fire_oc(:,nlat-1,:) = fire_oc(:,nlat-3,:)
fire_oc(:,nlat-2,:) = fire_oc(:,nlat-3,:)

;=== apply smoother to fire carbons
p = .5
q = .25   ;  -.25 = light local smoothing... +.25 =heavy 
cyclic = True
fire_cb = smth9_Wrap(fire_cb,p,q,cyclic)
fire_oc = smth9_Wrap(fire_oc,p,q,cyclic)



;========create new file surface file

;----> write new .nc file

system("rm "+new_cdf_DMS)
system("rm "+new_cdf_CB)
system("rm "+new_cdf_OC)
cdf_dms = addfile(new_cdf_DMS, "c")
cdf_cb = addfile(new_cdf_CB, "c")
cdf_oc = addfile(new_cdf_OC, "c")
print("Creating new dms,oc,cb files....")

; define dimensions
dimNames = (/"lat","lon","time"/)
dimSizes = (/ nlat, nlon,ntimes/)
dimUnlim = (/ False, False,True/)
filedimdef(cdf_dms,dimNames,dimSizes,dimUnlim)
filedimdef(cdf_cb,dimNames,dimSizes,dimUnlim)
filedimdef(cdf_oc,dimNames,dimSizes,dimUnlim)

;define variable names for DMS
filevardef(cdf_dms,"lat","float",(/"lat"/))
filevardef(cdf_dms,"lon","float",(/"lon"/))
filevardef(cdf_dms,"time","float",(/"time"/))
filevardef(cdf_dms,"date","integer",(/"time"/))
filevardef(cdf_dms,"datesec","integer",(/"time"/))
filevardef(cdf_dms,"DMS","float",(/"time","lat","lon"/))

;define variable names for CB
filevardef(cdf_cb,"lat","float",(/"lat"/))
filevardef(cdf_cb,"lon","float",(/"lon"/))
filevardef(cdf_cb,"time","float",(/"time"/))
filevardef(cdf_cb,"date","integer",(/"time"/))
filevardef(cdf_cb,"datesec","integer",(/"time"/))
filevardef(cdf_cb,"FIRE","float",(/"time","lat","lon"/))
filevardef(cdf_cb,"BioFuel","float",(/"time","lat","lon"/))

;define variable names for OC 
filevardef(cdf_oc,"lat","float",(/"lat"/))
filevardef(cdf_oc,"lon","float",(/"lon"/))
filevardef(cdf_oc,"time","float",(/"time"/))
filevardef(cdf_oc,"date","integer",(/"time"/))
filevardef(cdf_oc,"datesec","integer",(/"time"/))
filevardef(cdf_oc,"FIRE","float",(/"time","lat","lon"/))
filevardef(cdf_oc,"BioFuel","float",(/"time","lat","lon"/))

; write variables
cdf_dms->lat    = lat
cdf_dms->lon    = lon
cdf_dms->time   = time 
cdf_dms->date   = date
cdf_dms->datesec = datesec
cdf_dms->DMS =  dms 

cdf_cb->lat    = lat
cdf_cb->lon    = lon
cdf_cb->time   = time 
cdf_cb->date   = date
cdf_cb->datesec = datesec
cdf_cb->FIRE =  fire_cb 
cdf_cb->BioFuel =  bio_cb 

cdf_oc->lat    = lat
cdf_oc->lon    = lon
cdf_oc->time   = time 
cdf_oc->date   = date
cdf_oc->datesec = datesec
cdf_oc->FIRE =  fire_oc 
cdf_oc->BioFuel =  bio_oc 


; create file attributes
cdf_dms@template_hist = fdms@history
cdf_dms@template = "template = " + f_template_DMS 
cdf_dms@topo = "topo = " + filename_land
cdf_dms@info = "pt given 1850 zonal avg (delineated by landmask), hem symmetry"

cdf_cb@template_hist = fcb@history
cdf_cb@template = "template = " + f_template_CB 
cdf_cb@topo = "topo = " + filename_land
cdf_cb@info = "pt given 1850 fire zonal avg (delineated by landmask), hem symmetry, bio = 0"

cdf_oc@template_hist = foc@history
cdf_oc@template = "template = " + f_template_CB 
cdf_oc@topo = "topo = " + filename_land
cdf_oc@info = "pt given 1850 fire zonal avg (delineated by landmask), hem symmetry, bio = 0"


print(new_cdf_DMS + " has been written")
print(new_cdf_CB + " has been written")
print(new_cdf_OC + " has been written")


end
    


