load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/popRemap.ncl"   

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; author:  nanr (revised from change_kmt.ncl + latlon2pop_1.ncl)
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  change_kmt_lgm21ka.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("setenv  NCL_POP_REMAP /fis/cgd/cseg/csm/mapping/maps")
 print ("=========================================")


 makePlot = 0
 dd= systemfunc("date -u +%y%m%d")

 IPATH = "/fis/cgd/cseg/csm/inputdata/ocn/pop/gx1v6/grid/"
 NPATH = "/mypath/"

 ifile1    = IPATH + "/topography_20090204.ieeei4" 	     ; kmt in bin format
 ifile2    = IPATH + "/region_mask_20090205.ieeei4"          ; region_mask in bin format
 ifile3    = NPATH + "mylandfrac.nc"			     ; landfrac: 1x1deg, bimodal 0,100; lon=0-360.
 ifile4    = NPATH + "popGridVars.nc"                        ; POP TGRID vars
 ofile     = "mykmt."+dd+".nc"
 ofilebin1 = "kmt_gx1v6_myrun."+dd+".ieeei4"
 ofilebin2 = "region_mask_gx1v6_myrun."+dd+".ieeei4"

 in3 = addfile(ifile3,"r")
 lat  = in3->lat
 lon  = in3->lon
 lfrac = in3->landfrac
 nlat = dimsizes(lat)
 mlon = dimsizes(lon)

 ; read pop grid params
 in4 = addfile(ifile4,"r")
 t       = in4->KMT
 t@lon2d = in4->TLONG
 t@lat2d = in4->TLAT
 tarea   = in4->TAREA

 vtype = "integer"
 npts = 0

; NOTE lat and lon are hardcoded to regular POP Grid
 nplon = 320
 nplat = 384 + npts
 dims = (/nplat,nplon/)

; ==============================================
; == Read in kmt from topography file
; ==============================================
; NOTE:  fortran is column major .... NCL [C] is row major
; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
; ==============================================

 if (.not. isbigendian()) then
 	setfileoption ("bin", "ReadByteOrder", "BigEndian")
 	setfileoption ("bin", "WriteByteOrder","BigEndian")
 end if
 
 pdkmt   = fbindirread(ifile1,0,dims,vtype)
 reg     = fbindirread(ifile2,0,dims,vtype)

; ==============================================
; remap lat/lon topo file to pop grid
; ==============================================
  rlfrac  =PopLatLon(lfrac,  "1x1d","gx1v6","bilin","da","100716")

  pdkmt!0 = "Y"
  pdkmt&Y = rlfrac&Y
  pdkmt!1 = "X"
  pdkmt&X = rlfrac&X

  reg!0 = "Y"
  reg&Y = rlfrac&Y
  reg!1 = "X"
  reg&X = rlfrac&X

; ==============================================
; overlap with old hires topo and filter by remapped lfrac
; ==============================================

  lgm50 = pdkmt
  oreg  = reg

  rlfrac   = where(ismissing(rlfrac),100,rlfrac)
  lgm50 = where(pdkmt.ne.0.and.rlfrac.gt.50, 0,pdkmt)
  ; lgm75 = where(pdkmt.ne.0.and.rlfrac.gt.75, 0,pdkmt)


; ==============================================
; use 50% land area criteria for lnd/ocn mask
; ==============================================

  lgm = lgm50
  mlgm = lgm

; ==============================================
; clean up ocn grid 
; i = lon
; j = lat
; ==============================================

e.g.;

;   loni = 126
;   latj = 361
;   mlgm(latj,loni) = pdkmt(latj,loni)


;  loni = 37
;  latj = 346
;  mlgm(latj,loni) = 0

;  nlatj = 266
;  xlatj = 270
;  mlgm(nlatj:xlatj,loni) = pdkmt(nlatj:xlatj,loni)

;  nloni = 29
;  xloni = 34
;  latj = 202
;  mlgm(latj,nloni:xloni) = pdkmt(latj,nloni:xloni)

; ====================================================
; ====================================================
; ====================================================
; ====================================================
; ====================================================
; ====================================================
; ====================================================
; look for differences in 50% landmask and present day
; ====================================================

   lgmDiff = pdkmt 
  mlgmDiff = pdkmt
   lgmDiff = 0
  mlgmDiff = 0
   lgmDiff = where(pdkmt .eq. 0, -60, lgm50)
  mlgmDiff = where(pdkmt .eq. 0, -60, mlgm)
   lgmDOH  = mlgm
   lgmDOH  = where(mlgm .eq. 0, -60, mlgm)

; ==============================================
; remake landmask
; ==============================================

  lgmmask = pdkmt 
  lmask50 = pdkmt
  lgmmask = 0
  lmask50 = 0
  mlmask50 = where(mlgm  .gt. 0, 0, 1)  
  lmask50  = where(lgm50 .gt. 0, 0, 1)

; ==============================================
;  Calc statistics:
;  make ocn mask for calculating statistics
; ==============================================
  re = 6371.220 ; [km] average radius of earth
  pi = 4.0*atan(1.0)
  rad = pi/180.0
  rr = re*rad
  ASPHERE= 4*pi*re^2 ; km^2 [theoretical sfc sphere]
  ALAND = 148940e3 ; km^2 land area
  AWATER = 361132e3 ; km^2 water area
  mmask50 = mlmask50
  mmask50 = 0
  mmask50 = where(mlmask50 .eq.1 ,0, 1)
  omask50 = lmask50
  omask50 = 0
  omask50 = where(lmask50 .eq.1 ,0, 1)
  opdmask = where( pdkmt .gt. 0, 1, 0)
  tarea = tarea * 1e-4
  rlfrac = rlfrac * 0.01

  ; globalsum = sum(tarea)
  ; can't use TAREA b/c Antarctica and part of Greenland aren't in pop grid.
  globalsum = ASPHERE * 1e6     
  gtarea = (sum(opdmask * tarea))/globalsum
  parea = sprintf("  %6.4e",gtarea)
  print("PresentDay ocn area = " + parea)
  gtarea = 1 - gtarea
  parea = sprintf("%6.4e",gtarea)
  print("PresentDay land area = " + parea)
  delete(gtarea)
  delete(parea)

  ; 50%
  gtarea = (sum(omask50 * tarea))/globalsum
  parea = sprintf("%6.4e",gtarea)
  ; print("Remap ocn area (50%) = " + parea)
  gtarea = 1 - gtarea
  parea = sprintf("%6.4e",gtarea)
  print("Remap land area (50%) = " + parea)
  delete(gtarea)
  delete(parea)

  ; modified 50%
  gtarea = (sum(mmask50 * tarea))/globalsum
  parea = sprintf("%6.4e",gtarea)
  ; print("Remap ocn area (50%) = " + parea)
  gtarea = 1 - gtarea
  parea = sprintf("%6.4e",gtarea)
  print("Remap land area (modified 50%) = " + parea)
  delete(gtarea)
  delete(parea)

  ; PMIP
  orlfrac = rlfrac
  orlfrac = 0
  newnum  = 1 - rlfrac
  gtarea = (sum(newnum * tarea))/globalsum
  parea = sprintf("%6.4e",gtarea)
  ; print("Remap PMIP ocn area  = " + parea)
  gtarea = 1 - gtarea
  parea = sprintf("%6.4e",gtarea)
  print("Remap PMIP land area = " + parea)
  delete(gtarea)
  delete(parea)
; ==============================================
;  Calc theoretical area of earth to compare to remapped numbers:
; ==============================================
 dxeq = (lon(2)-lon(1))*rr ; dx=dlon at equator [m]

  dx = dxeq*cos(lat*rad) ; dx[*] at each latitude
  ; print(dx)

  dy = new (nlat,typeof(lat),"No_FillValue")
  dy(0) = (90-abs((lat(1)+lat(0))*0.5))*rr
  dy(nlat-1)= dy(0)
  dy(1:nlat-2) = abs(lat(2:nlat-1)-lat(1:nlat-2))*rr

  carea = dx*dy ; [*] cell area function of latitude only
  ; print(carea)
  CAREA = conform_dims( (/nlat,mlon/), carea, 0)

  AREA = sum(CAREA) ; km^2
  areaDiff = ((AREA-ASPHERE)/ASPHERE)*100 ; %

;+++++++++++++++++++++++++++++++++++++++++++
  CAREA@_FillValue = 1e20

  oro = lfrac        ; "ocean (0), land (1)"
  oro = oro * 0.01      ; goes from 0-1
  print(max(max(oro)))

  CAREA_LAND  = where(oro.eq.1, CAREA, CAREA@_FillValue)
  CAREA_WATER = where(oro.eq.0, CAREA, CAREA@_FillValue)

  CLAND  = sum(CAREA_LAND)
  CWATER = sum(CAREA_WATER)
  print("=============> 1x1 degree <===========")
  ocnSfc = ((CWATER)/AREA)*100 ; %
  lndSfc = ((CLAND)/AREA)*100 ; %
  oocnSfc = ((CWATER)/AREA)
  olndSfc = ((CLAND)/AREA)
  print("LFRAC ocn surface area[%]="+ ocnSfc + " (" + oocnSfc + ")")
  print("LFRAC lnd surface area[%]="+ lndSfc + " (" + olndSfc + ")")

; ==============================================
;  write out new kmt and region_mask in direct access binary 
;  mask region mask to match ocn.
; ==============================================

  moreg  = oreg
  moreg  = where(mlgm .gt. 0, oreg,0)

  system("/bin/rm -f " + ofilebin1)
  fbindirwrite(ofilebin1,mlgm)

  system("/bin/rm -f " + ofilebin2)
  fbindirwrite(ofilebin2,moreg)

; ==============================================
;  write out new kmt and region_mask in netcdf to check 
; ==============================================

 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")

 fileAtt             = True
 fileAtt@title       = "Land/Ocn mask for myrun simulation"
 fileAtt@create_date = systemfunc("date")
 fileAtt@src_code = "change_kmt_myrun.ncl"
 fileAtt@author = systemfunc("echo $USER")
 fileAtt@input4 = "map_1x1d_to_gx1v6_bilin_da_100716.nc"
 fileAtt@input3 = ifile3
 fileAtt@input2 = ifile2
 fileAtt@input1 = ifile1
 fileattdef(fout,fileAtt)

 fout->kmt_PD   = pdkmt
 fout->rlfrac   = rlfrac
 fout->mkmt50   = mlgm
 fout->kmt50    = lgm50
 fout->lmask50  = lmask50
 fout->lgmDiff  = lgmDiff
 fout->mlgmDiff = mlgmDiff
 fout->PD_RegionMask  = oreg
 fout->LGM_RegionMask = moreg

end
