#!/bin/csh -fv 

set echo off
set verbose

set DATE    = "`date +%y%m%d`"

set MYSRC = /fis/cgd/ccr/paleo
set CASE  = b40.lgm21ka.1deg.001

setenv TOOLSDIR $MYSRC/setup_tools
setenv DATADIR  $TOOLSDIR/ocn/data

set mssout = /CCSM/csm/${CASE}/cpl_mapping
# set rundir = /fis/cgd/ccr/nanr/pmip3/lgm21ka/cpl_mapping
set rundir = /ptmp/nanr/lgm21ka/
set mygriddir = /fis/cgd/ccr/nanr/pmip3/lgm21ka/modify_kmt/
set popgriddir = /fis/cgd/cseg/csm/inputdata/ocn/pop/gx1v6/grid/
#set scripdir  = /fis/cgd/ccr/paleo/scrip1.4
set scripdir = /fis/cgd/oce/yeager/scrip1.4
set wkdir = $rundir/cpl 

if (! -e ${rundir}) then
  echo \$rundir ${rundir} does not exist: Creating
  mkdir $rundir
endif
if (! -e ${wkdir}) then
  echo \$wkdir ${wkdir} does not exist: Creating
  mkdir $wkdir
endif


set nx      = 320  			# number of i gridpoints (longitudes)
set ny      = 384   	 		# number of j gridpoints (latitudes)
# -----------------------------------------------------------------
# Input files -----------------------------------------------------
# -----------------------------------------------------------------
# /fis/cgd/cseg/csm/inputdata/ocn/pop/gx1v6/grid/horiz_grid_20010402.ieeer8 (gx1v6 version) nanr 30sep10
set popgrid = horiz_grid_20010402.ieeer8       		# binary grid file 
set popgridfile = $popgriddir/$popgrid

# /fis/cgd/ccr/nanr/pmip3/lgm21ka/modify_kmt/kmt_gx1v6_lgm21ka.101005.ieeei4
set kmtgrid = kmt_gx1v6_lgm21ka.101005.ieeei4 		# binary kmt file 
set kmtgridfile = $mygriddir/$kmtgrid

set atmdomain   = fv0.9x1.25_070727.nc			# finite volume atm domain
set atmgridfile = /fs/cgd/csm/mapping/grids/$atmdomain
# -----------------------------------------------------------------
# Output labels -----------------------------------------------------
# -----------------------------------------------------------------
set map1_name   = 'gx1v6-lgm21ka to fv_0.9x1.25 Mapping('${kmtgrid}' to '${atmdomain}')'
set map2_name   = 'fv_0.9x1.25 to gx1v6-lgm21ka Mapping('${atmdomain}' to '${kmtgrid}')'
set ocngridname = 'lgm21ka'

set ocnres = 'gx1p21k'
set atmres = 'fv09_1.25'

# -----------------------------------------------------------------
# Output filenames ------------------------------------------------
# -----------------------------------------------------------------
set ocngridfile = $wkdir/${ocnres}_$DATE.nc
set map1_filea  = $wkdir/map_${ocnres}_to_${atmres}_aave_da_$DATE.nc
set map2_filea  = $wkdir/map_${atmres}_to_${ocnres}_aave_da_$DATE.nc
set map1_fileb  = $wkdir/map_${ocnres}_to_${atmres}_bilin_da_$DATE.nc
set map2_fileb  = $wkdir/map_${atmres}_to_${ocnres}_bilin_da_$DATE.nc
set map_methoda   = conservative	# labelled with aave
set map_methodb   = bilinear		# labelled with bilin
set normalize_opt = destarea
set map1a  = map_${ocnres}_to_${atmres}_aave_da_$DATE.nc
set map2a  = map_${atmres}_to_${ocnres}_aave_da_$DATE.nc
set map1b  = map_${ocnres}_to_${atmres}_bilin_da_$DATE.nc
set map2b  = map_${atmres}_to_${ocnres}_bilin_da_$DATE.nc

#################################
# SET HERE FILE INPUT
#################################
cd $wkdir

cat >! input.scrip_grid << EOF
$nx $ny
${ocngridname}
${popgridfile}
${kmtgridfile}
${ocngridfile}
1
EOF

cat >! scrip_ina << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_filea'
    interp_file2 = '$map2_filea'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methoda'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10 
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

cat >! scrip_inb << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_fileb'
    interp_file2 = '$map2_fileb'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methodb'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

#################################
# RUN SCRIP ROUTINES
#################################
#if !(-e $ocngridfile) then
 ${scripdir}/create_grids/myconvertPOPT < input.scrip_grid
 # ${scripdir}/grids/convertPOPT < input.scrip_grid
#endif

mv scrip_ina scrip_in
${scripdir}/scrip
mv scrip_inb scrip_in
${scripdir}/scrip

#################################
# ADD DOCUMENTATION
#################################
foreach i ($ocngridfile $map1_filea $map2_filea $map1_fileb $map2_fileb)
  ncatted -O -h -a Created_by,global,a,c,"`whoami`, `date`" $i
  ncatted -O -h -a 1D_grid_indexing,global,a,c,"if n is 1D index, i runs fast, j runs slow: n=(j-1)*fast_grid_dim+i" $i
end

#################################
# CLEAN UP
#################################
# /usr/bin/rm -f input.scrip_grid

 msrcp -pe 3650 -wpwd nanr -pr 93300324 $map1_filea mss:$mssout/$map1a
 msrcp -pe 3650 -wpwd nanr -pr 93300324 $map2_filea mss:$mssout/$map2a
 msrcp -pe 3650 -wpwd nanr -pr 93300324 $map1_fileb mss:$mssout/$map1b
 msrcp -pe 3650 -wpwd nanr -pr 93300324 $map2_fileb mss:$mssout/$map2b

exit(0)
