;*************************************************
; 
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in netCDF file and access data
;************************************************

  ; open output file.
  dd = systemfunc("date -u +%y%m%d")

  ifile1 = "/fis/cgd/ccr/nanr/pliocene/topo/topo_pliocene_10min.110306.nc"
  ifile2 = "/fis/cgd/cseg/csm/inputdata/lnd/clm2/rawdata/mksrf_topo.10min.c080912.nc"

  ofile = "mksrf_topo.10min.plio." + dd + ".nc"
  system("/bin/rm -f " + ofile)
  fout = addfile(ofile,"c")

  in1 = addfile(ifile1,"r")
  htopo = flt2dble(in1->htopo)
  htopo!0 = "lsmlat"
  htopo!1 = "lsmlon"

  ; copy variables from standard file
  in2 = addfile(ifile2,"r")
  in2_global= getvaratts(in2)
  in2_vars = getfilevarnames(in2)

  ; copy global attributes
  print(" creating mksrf_topo_lgm21ka")
  if (.not.all(ismissing(in2_global))) then
  	do i = 0, dimsizes(in2_global) - 1
  		print("copy_fileatts: global attributes->" + in2_global )
  		fout@$in2_global$ = in2@$in2_global$
  	end do
  end if

  ; copy variables
  if (.not.all(ismissing(in2_vars))) then
  	do i = 0, dimsizes(in2_vars) - 1
		usevar = in2_vars(i)
		print("i = " + i + " in2vars = " + in2_vars(i))
  		if (in2_vars(i) .ne."TOPO_ICE".and.in2_vars(i) .ne."TOPO_BEDROCK") then
  			fout->$in2_vars(i)$ = in2->$in2_vars(i)$
  			; fout->$in2_vars(i)$ = (/in2->$in2_vars(i)$/)
  			print("writing var ->" + in2_vars(i) )
		else 
		   ; use  10min topography in for topo_ice
		   if (in2_vars(i) .eq. "TOPO_ICE") then
  			fout->$in2_vars(i)$ = htopo
  			print("writing var ->" + in2_vars(i) )
		   else 
			; use 10min topo for topo_bedrock b/c we aren't
			; using this variable anyway since we don't
			; have multi-level glaciers turned on.
		   	if (in2_vars(i) .eq. "TOPO_BEDROCK") then
  				fout->$in2_vars(i)$ = htopo
  				print("writing var ->" + in2_vars(i) )
			else
  				print("Done Writing")
  		        end if
  		   end if
  		end if
  	end do
  end if

end

