;*************************************************
; 
;************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
;************************************************
begin
;************************************************
; read in netCDF file and access data
;************************************************

  ; open output file.
  dd = systemfunc("date -u +%y%m%d")

  ifile1 = "/fis/cgd/cseg/csm/inputdata/lnd/clm2/rawdata/pftlandusedyn.0.5x0.5.simyr1850-2005.c090630/mksrf_landuse_rc2000_c090630.nc"
  ifile2 = "/fis/cgd/ccr/nanr/pliocene/mksrf/mksrf_pft_plio_hud2nc2.091015.nc"

  ofile = "mksrf_pft_plio_hud2nc2.harvest.091015.nc"
  system("/bin/rm -f " + ofile)
  fout = addfile(ofile,"c")

  in1 = addfile(ifile1,"r")
  in2 = addfile(ifile2,"r")
  lat = in2->LAT
  lon = in2->LON

  ; add harvest variables from standard CESM input file, and zero them out.
  ivars = (/"HARVEST_VH1","HARVEST_VH2", "HARVEST_SH1","HARVEST_SH2","HARVEST_SH3","GRAZING"/)

  ; copy variables from LGM pft file
  in2 = addfile(ifile2,"r")
  in2_global= getvaratts(in2)
  in2_vars = getfilevarnames(in2)

  ; copy global attributes
  print(" creating mksrf_topo_lgm21ka")
  if (.not.all(ismissing(in2_global))) then
  	do i = 0, dimsizes(in2_global) - 1
  		print("copy_fileatts: global attributes->" + in2_global )
  		fout@$in2_global$ = in2@$in2_global$
  	end do
  end if

  ; copy variables
  if (.not.all(ismissing(in2_vars))) then
  	do i = 0, dimsizes(in2_vars) - 1
  		print("writing var ->" + in2_vars(i) )
  		fout->$in2_vars(i)$ = in2->$in2_vars(i)$
  	end do
  end if

  ; add harvest vars
  do i = 0, dimsizes(ivars) - 1
  		print("writing var ->" + ivars(i) )
		usevar = in1->$ivars(i)$
		usevar = usevar * 0.0
		usevar!0 = "lat"
		usevar!1 = "lon"
		usevar&lat = lat
		usevar&lon = lon
  		fout->$ivars(i)$ = usevar
		delete(usevar)
  end do

end

