;====================================================================
; reads in  domain.camocn domain file and uses
; as template for paleo.
; keep area and lat/lon definitions but swap out mask and frac
; cshields (sep 2010)
;
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";


;==========================================================

begin

new_cdf = "domain.camocn.0.47x0.63_gx1v6_paleo.yymmdd.nc"  ; name for new .nc file
frac_cdf = "/your/path/for/mksurfdata/surfdata_0.47x0.63_paleo_ccsm4.yymmdd.nc"
template_cdf = "/fis/cgd/cseg/csm/inputdata/atm/cam/ocnfrac/domain.camocn.0.47x0.63_gx1v6_090408.nc"
modtext =  "swap out mask and frac from template and replace w/PALEO from mksurfdata " + frac_cdf


;==================> get dimension sizes from files and read data

tf  = addfile(template_cdf,"r")
xc = tf->xc 
yc = tf->yc 
xv = tf->xv 
yv = tf->yv 
area = tf->area
omask = tf->mask
frac = tf->frac

dims = dimsizes(xv)
nj = dims(0)
ni = dims(1)
nv = dims(2)

ff = addfile(frac_cdf,"r")
frac_petm = ff->LANDFRAC_PFT
lmask_petm = ff->PFTDATA_MASK


;============= make changes to var_to_change =================
; MAKE YOUR MODIFICATIONS IN THIS SECTION

;make ocean points 1, i.e. reverse land mask
;do same for frac, except compute ocean frac from landfrac

omask_new = omask  ; copy over attributes
frac_new = frac ;copy over attributes
frac_new = (/frac_petm/)
do njj = 0,nj-1
do nii = 0,ni-1
 if(lmask_petm(njj,nii).eq.0)then
   omask_new(njj,nii) = 1
   frac_new(njj,nii) = 1.
 else
 if(lmask_petm(njj,nii).eq.1)then
   omask_new(njj,nii) = 0
   frac_new(njj,nii) = 0.
 end if
 end if
end do
end do

do njj = 0,nj-1
do nii = 0,ni-1
 if(frac_petm(njj,nii).gt.0.and.frac_petm(njj,nii).lt.0.99999)then
   frac_new(njj,nii) = 1. - frac_petm(njj,nii) 
   omask_new(njj,nii) = 1
 end if
end do
end do

print("Changes complete")


;========create new file surface file, preserve old file
;        attributes, write out variables with no changes

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")

; define dimensions
dimNames = (/"nv","ni","nj"/)
dimSizes = (/ nv, ni, nj/)
dimUnlim = (/ False,  False, False/) 
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"xc","double",(/"nj","ni"/))
filevardef(cdf,"yc","double",(/"nj","ni"/))
filevardef(cdf,"xv","double",(/"nj","ni","nv"/))
filevardef(cdf,"yv","double",(/"nj","ni","nv"/))
filevardef(cdf,"mask","integer",(/"nj","ni"/))
filevardef(cdf,"frac","double",(/"nj","ni"/))
filevardef(cdf,"area","double",(/"nj","ni"/))

; write variables
cdf->xc    =  xc
cdf->yc    =  yc
cdf->xv    =  xv
cdf->yv    =  yv
cdf->mask = omask_new 
cdf->frac = frac_new 
cdf->area = area 


; preserve file attributes
cdf@Conventions = tf@Conventions
cdf@title = tf@title
cdf@user_comment = tf@user_comment
cdf@source = tf@source
cdf@history = tf@history
cdf@mkdatadomain_version = tf@mkdatadomain_version
cdf@SVN_url = tf@SVN_url
cdf@mkdatadomain_version_Id = tf@mkdatadomain_version_Id
cdf@source_code = tf@source_code
cdf@Land_Grid_Dataset = tf@Land_Grid_Dataset
cdf@Land_Fraction_Dataset = tf@Land_Fraction_Dataset

; add new text
cdf@Modifications = modtext
cdf@nclcode = "for petm mod: mk_docn.domain.ncl" 

print(new_cdf + " has been written")


end 
