; read in template cam initial (Netcdf) file 
; makes modifications, writes out new file
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";

begin

;====================user defined parameters

filename_topo    = getenv("INPUT_DATA_NC")
filename_template= getenv("INPUT_DATA_SKELETON")    
new_cdf          = getenv("OUTPUT_DATA_NC")
modtext          = getenv("MODTEXT")

;new inputs for calculated T profile
Tpole            = getenv("TPOLE") 
Teq              = getenv("TEQ") 

;============== read topo ascii file

topof = addfile(filename_topo,"r")
phis = topof->PHIS
print("Atm phis read")

;=============== read in atm template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
P0   = atm->P0
lev  = atm->lev
ilev = atm->ilev
time = atm->time
isccp_prs = atm->isccp_prs
isccp_tau = atm->isccp_tau
isccp_prstau = atm->isccp_prstau
time_bnds = atm->time_bnds
date_written = atm->date_written
time_written = atm->time_written
ntrm = atm->ntrm
ntrn = atm->ntrn
ntrk = atm->ntrk
ndbase = atm->ndbase
nsbase = atm->nsbase
nbdate = atm->nbdate
nbsec  = atm->nbsec
mdt    = atm->mdt
hyai   = atm->hyai
hybi   = atm->hybi
hyam   = atm->hyam
hybm   = atm->hybm
gw     = atm->gw
ndcur  = atm->ndcur
nscur  = atm->nscur
date   = atm->date
co2vmr = atm->co2vmr
ch4vmr = atm->ch4vmr
n2ovmr = atm->n2ovmr
f11vmr = atm->f11vmr
f12vmr = atm->f12vmr
sol_tsi = atm->sol_tsi
datesec= atm->datesec
nsteph = atm->nsteph
CLDICE = atm->CLDICE
CLDLIQ = atm->CLDLIQ
ICEFRAC = atm->ICEFRAC
PS     = atm->PS
Q      = atm->Q
SICTHK = atm->SICTHK
SNOWHICE = atm->SNOWHICE
T      = atm->T
TS1      = atm->TS1
TS2      = atm->TS2
TS3      = atm->TS3
TS4      = atm->TS4
TSOCN    = atm->TSOCN
TSICE    = atm->TSICE
U      = atm->U
V      = atm->V
 
nlon  = dimsizes(lon)
nlat  = dimsizes(lat)
nlev  = dimsizes(lev)
nilev = dimsizes(ilev)
ntimes= dimsizes(time)
dimsc = dimsizes(date_written)
chars = dimsc(1)
nisccp_prs = dimsizes(isccp_prs)
nisccp_prstau = dimsizes(isccp_prstau)
nisccp_tau = dimsizes(isccp_tau)
ntbnds = dimsizes(time_bnds)
tbnd = ntbnds(1)


print("nlon = " + nlon)
print("nlat = " + nlat)
print("nlev = " + nlev)
print("nilev= " + nilev)
print("ntimes = " + ntimes)
print("chars = "+ chars)


;====== compute new values for vars 

t = T
ps = PS
u = U
v = V
q = Q
cldice = CLDICE
cldliq = CLDLIQ

; vars necessary for cam/som...can set to 0 for coupled init
icefrac = ICEFRAC
sicthk = SICTHK
snowhice = SNOWHICE
ts1 = TS1
ts2 = TS2
ts3 = TS3
ts4 = TS4
tsocn  = TSOCN
tsice  = TSICE

copy_VarAtts(T,t)
copy_VarAtts(PS,ps)
copy_VarAtts(U,u)
copy_VarAtts(V,v)
copy_VarAtts(Q,q)
copy_VarAtts(CLDICE,cldice)
copy_VarAtts(CLDLIQ,cldliq)
copy_VarAtts(ICEFRAC,icefrac)
copy_VarAtts(SICTHK,sicthk)
copy_VarAtts(SNOWHICE,snowhice)
copy_VarAtts(TS1,ts1)
copy_VarAtts(TS2,ts2)
copy_VarAtts(TS3,ts3)
copy_VarAtts(TS4,ts4)
copy_VarAtts(TSOCN,tsocn)
copy_VarAtts(TSICE,tsice)

;t and ps calulation
; calculate zonal t
; make eq-pole temp gradient = half cosine wave

      cst = new(nlat,double)
      degrad = 0.0174533  ; conversion of degrees to radians
;     temppole = 12.
;     tempeq   = 28.
      temppole = stringtofloat(Tpole)
      tempeq   = stringtofloat(Teq)
      latr = lat*degrad 
      cst= cos(latr)
      cstC = conform(t,cst,2)
      t= temppole + (tempeq-temppole)*cstC
;     t = t + 273.   ;convert to deg K, Christine old ccsm2 script
;     t = t + 273.16  ;convert to deg K, compatible with ccsm3 conversion
      t = t + 273.15  ;new (3/28/07) convert to deg K, compatible with ccsm3 conversion
      print("zonal t calculated")

; calculate sfc prs from above temp and topo (units Pa)
      top = phis/9.8
      topC = conform(ps,top,(/1,2/))
      z1 = 0.
      slp = 101200.
      z2 = topC  ; array(0,lat,lon)
      H  = 29.3*( t(:,0,:,:) )  ; convert t to deg K
      ps = slp* ( exp(-(z2-z1)/H) )
      print("ps calculated")

; calcualte thermal wind
      dy = new(nlat,double)
      Rf = -287./1e-4 ; gas constant (J perdeg persec) / coriolis (persec)
      deg2m = 111000. ;m per deg lat
      pref = 992. ;mb (levels are in mb also...units cancel)
      do nlt = 1,nlat-2
       dy(nlt) = (lat(nlt+1)-lat(nlt-1))*deg2m
      end do
      dy(1) = dy(2)
      dy(nlat-1) = dy(nlat-1)
      nlatd2 = nlat/2

      do nlv = 0,nlev-1
      do nln = 0,nlon-1
      do nlt=1,nlatd2 
       u(:,nlv,nlt,nln)=  \
       -1*Rf*((t(:,nlv,nlt+1,nln)-t(:,nlv,nlt-1,nln))/dy(nlt))*(log(pref/lev(nlv)))
      end do
      do nlt=nlatd2+1,nlat-2 
       u(:,nlv,nlt,nln)=   \
         Rf*((t(:,nlv,nlt+1,nln)-t(:,nlv,nlt-1,nln))/dy(nlt))*(log(pref/lev(nlv)))
      end do
      end do
      end do
      u(:,:,0,:) = u(:,:,1,:)
      u(:,:,nlat-1,:) = u(:,:,nlat-2,:)
      print("u calculated")

; assign v and q and cwat
      v = 0.
      q(:,0:10,:,:)  = 1.e-06     ;top to 139 sigma/prs level
      q(:,11:16,:,:) = 1.e-05     ;139 to 368  
      q(:,17:19,:,:) = 1.e-04     ;433 to 600
      q(:,20:nlev-1,:,:)= 1.e-03  ;696 to 992
      print("v and q values assigned")

 ;ts vars 
 tsice = 271.35
 ts1  = t(:,nlev-1,:,:)
 ts2  = t(:,nlev-1,:,:)
 ts3  = t(:,nlev-1,:,:)
 ts4  = t(:,nlev-1,:,:)
 tsocn = ts1
 tsice = 273.15
do n =0,nlev-1
 print("n t" + n + " " + t(:,n,:,:))
end do 

; ice/snow  
;-- mods here for ice frac, if warm world, initialze to zero
 icefrac = 0.
 snowhice = 0.
 sicthk = 0.


;========create new file surface file, preserve old file
;        attributes, write out variables with no changes

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new init file....")

; define dimensions
dimNames = (/"lat","lon","lev","ilev","time","chars","isccp_prs","isccp_tau","isccp_prstau","tbnd"/)
dimSizes = (/ nlat, nlon, nlev, nilev,  -1, chars,nisccp_prs,nisccp_tau,nisccp_prstau,tbnd/)
dimUnlim = (/ False,  False,  False,   False,   True, False,False,False,False,False/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"lat","double",(/"lat"/))
filevardef(cdf,"lon","double",(/"lon"/))
filevardef(cdf,"lev","double",(/"lev"/))
filevardef(cdf,"ilev","double",(/"ilev"/))
filevardef(cdf,"isccp_prs","double",(/"isccp_prs"/))
filevardef(cdf,"isccp_tau","double",(/"isccp_tau"/))
filevardef(cdf,"isccp_prstau","double",(/"isccp_prstau"/))
filevardef(cdf,"time","double",(/"time"/))
filevardef(cdf,"time_bnds","double",(/"time","tbnd"/))
filevardef(cdf,"hyai","double",(/"ilev"/))
filevardef(cdf,"hybi","double",(/"ilev"/))
filevardef(cdf,"hyam","double",(/"lev"/))
filevardef(cdf,"hybm","double",(/"lev"/))
filevardef(cdf,"gw","double",(/"lat"/))
filevardef(cdf,"date_written","character",(/"time","chars"/))
filevardef(cdf,"time_written","character",(/"time","chars"/))
filevardef(cdf,"date","integer",(/"time"/))
filevardef(cdf,"datesec","integer",(/"time"/))
filevardef(cdf,"nsteph","integer",(/"time"/))
filevardef(cdf,"co2vmr","double",(/"time"/))
filevardef(cdf,"ch4vmr","double",(/"time"/))
filevardef(cdf,"n2ovmr","double",(/"time"/))
filevardef(cdf,"f11vmr","double",(/"time"/))
filevardef(cdf,"f12vmr","double",(/"time"/))
filevardef(cdf,"sol_tsi","double",(/"time"/))
filevardef(cdf,"U","double",(/"time","lev","lat","lon"/))
filevardef(cdf,"V","double",(/"time","lev","lat","lon"/))
filevardef(cdf,"T","double",(/"time","lev","lat","lon"/))
filevardef(cdf,"Q","double",(/"time","lev","lat","lon"/))
filevardef(cdf,"PS","double",(/"time","lat","lon"/))
filevardef(cdf,"CLDICE","double",(/"time","lev","lat","lon"/))
filevardef(cdf,"CLDLIQ","double",(/"time","lev","lat","lon"/))
filevardef(cdf,"ICEFRAC","double",(/"time","lat","lon"/))
filevardef(cdf,"SICTHK","double",(/"time","lat","lon"/))
filevardef(cdf,"SNOWHICE","double",(/"time","lat","lon"/))
filevardef(cdf,"TS1","double",(/"time","lat","lon"/))
filevardef(cdf,"TS2","double",(/"time","lat","lon"/))
filevardef(cdf,"TS3","double",(/"time","lat","lon"/))
filevardef(cdf,"TS4","double",(/"time","lat","lon"/))
filevardef(cdf,"TSOCN","double",(/"time","lat","lon"/))
filevardef(cdf,"TSICE","double",(/"time","lat","lon"/))

; write variables
cdf->lat    = lat
cdf->lon    = lon
cdf->lev    = lev
cdf->ilev   = ilev
cdf->time   = time
cdf->isccp_prs = isccp_prs
cdf->isccp_tau = isccp_tau
cdf->isccp_prstau = isccp_prstau
cdf->hyai   = hyai
cdf->hybi   = hybi
cdf->hyam   = hyam
cdf->hybm   = hybm
cdf->gw     = gw
cdf->co2vmr = co2vmr
cdf->ch4vmr = ch4vmr
cdf->n2ovmr = n2ovmr
cdf->f11vmr = f11vmr
cdf->f12vmr = f12vmr
cdf->sol_tsi = sol_tsi 
cdf->P0 = P0
cdf->date_written = date_written
cdf->time_written = time_written
cdf->time = time
cdf->time_bnds = time_bnds
cdf->ntrm = ntrm
cdf->ntrn = ntrn
cdf->ntrk = ntrk
cdf->ndbase = ndbase
cdf->nsbase = nsbase
cdf->nbdate = nbdate
cdf->nbsec  = nbsec
cdf->mdt    = mdt
cdf->ndcur  = ndcur
cdf->nscur  = nscur
cdf->date   = date
cdf->datesec= datesec
cdf->nsteph = nsteph

; preserve file attributes
cdf@Conventions = atm@Conventions
cdf@logname = atm@logname
cdf@host = atm@host
cdf@source = atm@source
cdf@case = atm@case
cdf@title = atm@title

; add new text
cdf@Modifications = modtext
cdf@history = "template b20.604gm.cam2.i.0400-01-01-00000.nc" 
cdf@topography_file = filename_topo 

print("New file skeleton has been written...")

;== write new vars
  
cdf->CLDICE = cldice
cdf->CLDLIQ = cldliq
cdf->SICTHK = sicthk 
cdf->SNOWHICE = snowhice 
cdf->ICEFRAC = icefrac 
cdf->TSOCN = tsocn 
cdf->TSICE = tsice
cdf->TS1= ts1
cdf->TS2= ts2
cdf->TS3= ts3
cdf->TS4= ts4
cdf->PS = ps
cdf->T = t 
cdf->U =  u 
cdf->V =  v
cdf->Q =  q 

print(new_cdf + " has been written")



end
    


