;=========================================================; 
; reads in data merged topo kmt file
; reads in landfrac from ccsm4 surface_data file 
; (run mksurfdata offline first)
; read in template cam bnd_topo (Netcdf) file 
; makes modifications, writes out new file
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters

filename_topo    = "/your/paleo/topo_depth/paleo_2x2_topodepth_0-360.nc"
filename_template= "USGS-gtopo30_48x96_c050520.nc" 
filename_surfdat= "/your/surfdata/from/mksurfdata/surfdata_48x96_paleo_ccsm4.yymmdd.nc"  
new_cdf          = "cami_bnd_topo_48x96_XXMa_cyymmdd.nc"
regrid           = 1     ; regrid topo data 0 no 1 yes
	         ; NOTE see ncl function/procedures to pick best interp.
		 ; scheme for your data, currently set up to interp.
		 ; from (2x2) to (T31) (bilinear interp, similar to definesurf)
hires            = "true" 
                 ; true/false: add from_hires attribute to phis, 
	         ; this will force model to do additional spectral
	         ; spectral filtering at runtime	 
standalone       = 0 
		 ; variables for cam standalone 0  1 no

;============== read atm topo file

nlat_2x2 = 90
nlon_2x2 = 180
topof = addfile(filename_topo,"r")
topf = topof->topo_depth
;topf = topof->TOPO
ilat = topof->lat
ilon = topof->lon
topf@_FillValue = 0.
topf = mask(topf,topf.lt.0,False)
delete(topf@_FillValue)
printVarSummary(topf)
print("Atm data read")

;=============== read in landfrac from paleo surface_data
; (should have already created this offline using mksurfdata tool)
 
lnd = addfile(filename_surfdat,"r")
landfrac_pft = lnd->LANDFRAC_PFT 

;=============== read in atm template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
nlat = dimsizes(lat) 
nlon = dimsizes(lon) 
print("nlon = " + nlon)
print("nlat = " + nlat)

; USING linint2: interpolate from one grid to another grid
; using bilinear interpolation. Missing values are allowed.
; produces similar interpolation used by jim's "definesurf"
 
if(regrid.eq.1)then
  top = linint2 (ilon,ilat,topf, True, lon,lat, 0)
  print("Atm topography interpolated")
else
  top = topf
end if 
top!0 = "lat"
top!1 = "lon"
top&lat = lat
top&lon = lon
top@long_name = "Topography"
printVarSummary(top)

;======= create landm_coslat field 

landm_sm = smth9(landfrac_pft,.5,.25,True)
landm_coslat = new((/nlat,nlon/),double)
degrad = 0.0174533  ; conversion of degrees to radians
latr = lat*degrad 
latrC = conform(landfrac_pft,latr,0)
landm_coslat = landfrac_pft
do nlt = 0, nlat-1
do nln = 0, nlon-1
 if(landfrac_pft(nlt,nln).lt.0.999)then 
  landm_coslat(nlt,nln) = landm_sm(nlt,nln)*cos(latrC(nlt,nln)) 
 end if
end do
end do
landm_coslat!0 = "lat"
landm_coslat!1 = "lon"
landm_coslat&lat = lat
landm_coslat&lon = lon
print("LANDM_COSLAT fields created from interpolated LANDFRAC_PFT")

;====== compute new values phis,sgh,sgh30

phis = new((/nlat,nlon/),double)
sgh  = new((/nlat,nlon/),double)
phis = top *9.80616
sgh  = top*0.3
sgh30 = top*0.1
copy_VarCoords(landm_coslat, phis)
copy_VarCoords(landm_coslat, sgh)
copy_VarCoords(landm_coslat, sgh30)
copy_VarCoords(landm_coslat, landfrac_pft)
printVarSummary(phis)

;===== fill out attributes for vars
msg = 1.e+36

;_FillValuse
phis@_FillValue = msg 
sgh@_FillValue = msg 
sgh30@_FillValue = msg 
landfrac_pft@_FillValue = msg 
landm_coslat@_FillValue = msg 

;missing_value
phis@missing_value = msg 
sgh@missing_value = msg 
sgh30@missing_value = msg 
landfrac_pft@missing_value = msg 
landm_coslat@missing_value = msg 

;long_name
phis@long_name = "surface geopotential"
sgh@long_name = "standard deviation of elevations top*.3"
sgh30@long_name = "standard deviation of elevations top *.1"
landfrac_pft@long_name = "gridbox land fraction"
landm_coslat@long_name =  "land ocean transition mask: ocean (0), continent (1), transition (0-1)"

;units
phis@units = "m2/s2" 
sgh@units = "m"
sgh30@units = "m"

;from hires 
;(only set to true of hasn't been thru cam/spectral filter yet)
phis@from_hires = "true"
sgh@from_hires = "true"
sgh30@from_hires = "true"


;========create new file surface file

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new topo file....")

; define dimensions
dimNames = (/"lat","lon"/)
dimSizes = (/ nlat, nlon/)
dimUnlim = (/ False,  False/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"lat","double",(/"lat"/))
filevardef(cdf,"lon","double",(/"lon"/))
filevardef(cdf,"PHIS","double",(/"lat","lon"/))
filevardef(cdf,"SGH","double",(/"lat","lon"/))
filevardef(cdf,"SGH30","double",(/"lat","lon"/))
filevardef(cdf,"LANDM_COSLAT","double",(/"lat","lon"/))
filevardef(cdf,"LANDFRAC","double",(/"lat","lon"/))

; write variables
cdf->lat    = lat
cdf->lon    = lon
cdf->PHIS = phis
cdf->SGH  = sgh 
cdf->SGH30  = sgh30 
cdf->LANDM_COSLAT= (/landm_coslat/) 
cdf->LANDFRAC= (/landfrac_pft/) 

; create file attributes
date_written = systemfunc("date -u +%y%m%d")
cdf@history = "created with ccsm4_cami_bnd_topo_paleo.ncl on " + date_written 
cdf@template = "template = " + filename_template 
cdf@paleotopo = "paleo topo = " +  filename_topo 
cdf@surfdat =  "landfrac from " +filename_surfdat 

print(new_cdf + " has been written")


end
    


