#!/bin/csh -f
set echo
set verbose
#----------------------- cami_create.ncl -----------------------------
#
# all work is done in directory where script and code resides 
#
# this cshell script runs the ncl code ccsm_cami_create_script.ncl  
#
# read in template (skeleton file) for cam initial file, a topo/bathemetry
# netcdf, makes modificatioins, writes out new file
#
#-----------------------------------------------------------------
# YOU NEED  : cesm_cami_create.ncl,cami_create_cesm.csh,surface_data file,skeleton file
# TO RUN    : cami_create_cesm.csh 
# NOTE      : make sure "limits" on your machine are set appropriately
#           : if not set large enough, the program may not have enough
#             space/memory to run
#-----------------------------------------------------------------
#
#----------------------------------------------------------------------------
# USER:  specify input/output pathnames as well as other user defined parameters
# with enviromental variables set in this script 
# NOTE:  Be sure to specify the path to your input topography (INFILE) 
#----------------------------------------------------------------------------

setenv INFILE cami_bnd_topo_48x96_paleo_cyymmdd.nc  
setenv OUTFILE paleo_cesm_cami_t31.nc
setenv CASE    XXma
setenv TOOLSDIR /your/toolsdir/here	# set to your local copy of tools

#--------------------------------------

setenv DATADIR  $TOOLSDIR/atm
setenv INPUT_DATA_SKELETON $DATADIR/cami_0000-01-01_48x96_L26_c091218.nc
setenv INPUT_DATA_NC $DATADIR/$INFILE
setenv OUTPUT_DATA_NC    $DATADIR/$OUTFILE

setenv MODTEXT basic_paleo_ic
setenv NCL $NCARG_ROOT/bin/ncl

#Must set for half-cosine Equator to Pole Temperature I.C.:
setenv TEQ     28.
setenv TPOLE   12.

#----------------------------------------------------------------------------
#  run 
# change NCL to where ever the latest version resides. 
#----------------------------------------------------------------------------
$NCL  $TOOLSDIR/atm/cesm_cami_create.ncl	# TOOLS copy

exit

