c
c define module with counters and maximum dimensions
c
      module counters_netcdf_jfl
c
      integer :: dim_counter  = 0
      integer :: var_counter  = 0
      integer :: time_counter = 0
      integer, parameter :: dim_max = 10000
      integer, parameter :: var_max = 10000
c
      end module counters_netcdf_jfl
c
c define module with structure definitions
c
      module definitions_netcdf_jfl
c
      use counters_netcdf_jfl
c
      type DimInfo
        character*32  name
        integer       id,length
        character*200 file_name
      end type DimInfo
c
      type VarInfo
        character*32  name,format,type
        integer       id,nvdims
        integer       vdims(10)
        character*200 file_name
      end type VarInfo
c
      type(DimInfo), dimension(dim_max) :: dim_info
      type(VarInfo), dimension(var_max) :: var_info
      character*200                     :: netcdf_file_name
c
      end module definitions_netcdf_jfl
c
c define module with explicit subroutine interface
c and definition of generic subroutines (read_var and
c write_var).
c
      module interfaces_netcdf_jfl
c
      interface
        subroutine def_dim(ncid,dim_name
     &                         ,dim_length)
          integer, intent(in) :: ncid,dim_length
          character(*), intent(in) :: dim_name
        end subroutine def_dim
      end interface
c
      interface
        subroutine def_var(ncid,var_name
     &                         ,format
     &                         ,type
     &                         ,units
     &                         ,long_name)
          integer, intent(in) :: ncid
          character(*), intent(in)           :: var_name
          character(*), intent(in)           :: format
          character(*), intent(in)           :: type
          character(*), intent(in), optional :: units
          character(*), intent(in)           :: long_name
        end subroutine def_var
      end interface
c
      interface write_var
        subroutine write_var_c_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          character(*), intent(in) :: array
        end subroutine write_var_c_0
        subroutine write_var_c_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          character(*), intent(in) :: array(:)
        end subroutine write_var_c_1
        subroutine write_var_c_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          character(*), intent(in) :: array(:,:)
        end subroutine write_var_c_2
        subroutine write_var_i_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array
        end subroutine write_var_i_0
        subroutine write_var_i_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:)
        end subroutine write_var_i_1
        subroutine write_var_i_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:,:)
        end subroutine write_var_i_2
        subroutine write_var_i_3(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:,:,:)
        end subroutine write_var_i_3
        subroutine write_var_i_4(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:,:,:,:)
        end subroutine write_var_i_4
        subroutine write_var_f_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array
        end subroutine write_var_f_0
        subroutine write_var_f_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:)
        end subroutine write_var_f_1
        subroutine write_var_f_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:)
        end subroutine write_var_f_2
        subroutine write_var_f_3(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:,:)
        end subroutine write_var_f_3
        subroutine write_var_f_4(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:,:,:)
        end subroutine write_var_f_4
        subroutine write_var_d_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real*8      , intent(in) :: array
        end subroutine write_var_d_0
        subroutine write_var_d_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real*8      , intent(in) :: array(:)
        end subroutine write_var_d_1
        subroutine write_var_d_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real*8      , intent(in) :: array(:,:)
        end subroutine write_var_d_2
        subroutine write_var_d_3(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real*8      , intent(in) :: array(:,:,:)
        end subroutine write_var_d_3
      end interface
c
      interface read_var
        subroutine read_var_c_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          character(*), intent(in) :: array
        end subroutine read_var_c_0
        subroutine read_var_c_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          character(*), intent(in) :: array(:)
        end subroutine read_var_c_1
        subroutine read_var_c_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          character(*), intent(in) :: array(:,:)
        end subroutine read_var_c_2
        subroutine read_var_i_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array
        end subroutine read_var_i_0
        subroutine read_var_i_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:)
        end subroutine read_var_i_1
        subroutine read_var_i8_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer*8   , intent(in) :: array(:)
        end subroutine read_var_i8_1
        subroutine read_var_i_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:,:)
        end subroutine read_var_i_2
        subroutine read_var_i_3(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:,:,:)
        end subroutine read_var_i_3
        subroutine read_var_i_4(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          integer     , intent(in) :: array(:,:,:,:)
        end subroutine read_var_i_4
        subroutine read_var_f_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array
        end subroutine read_var_f_0
        subroutine read_var_f_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:)
        end subroutine read_var_f_1
        subroutine read_var_f_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:)
        end subroutine read_var_f_2
        subroutine read_var_f_3(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:,:)
        end subroutine read_var_f_3
        subroutine read_var_f_4(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:,:,:)
        end subroutine read_var_f_4
        subroutine read_var_f_5(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          real        , intent(in) :: array(:,:,:,:,:)
        end subroutine read_var_f_5
        subroutine read_var_d_0(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          double precision, intent(in) :: array
        end subroutine read_var_d_0
        subroutine read_var_d_1(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          double precision, intent(in) :: array(:)
        end subroutine read_var_d_1
        subroutine read_var_d_2(ncid,var_name,array)
          integer     , intent(in) :: ncid
          character(*), intent(in) :: var_name
          double precision, intent(in) :: array(:,:)
        end subroutine read_var_d_2
      end interface
c
      end module interfaces_netcdf_jfl
c
