#!/usr/local/packages/expect-5.37-n32/bin/expectk

wm title . "kmt"

frame .top -borderwidth 10

menu .menubar
. config -menu .menubar

foreach m {File Help Bathymetry} {
    set $m [menu .menubar.m$m -tearoff 1]
    .menubar add cascade -label $m -menu .menubar.m$m
    .menubar.m$m config -activebackground yellow  -activeforeground red
}
      
$File add command -label "Quit Without Saving" -command exit
$Help add command -label "Do Nothing" -command " "
$Bathymetry add command -label "Do Nothing" -command " "

checkbutton .refreshall -text "Refresh After A Set of One or More Changes?" \
    -variable autorefreshall -onvalue "Y" -offvalue "N"

checkbutton .confirmchange -text "Confirm Editing Changes?" \
    -variable promptforundo -onvalue "Y" -offvalue "N"

set input_file "kmt_grid.nc"
set output_file "tmp.nc"
set ps_file "tmp.ps"
set hi_res_file "hires.ps"
set program "kmtEd"
set but [button .top.run -text "Run: " -command "Main"]

frame .variable_frame
label .variable_frame.data_label -text "NC Data Name" -anchor w
label .variable_frame.x_label -text "NC X Name" -anchor w
label .variable_frame.y_label -text "NC Y Name" -anchor w
entry .variable_frame.data_name -textvariable dataVar
entry .variable_frame.x_name -textvariable xVar
entry .variable_frame.y_name -textvariable yVar


frame .io_frame
label .io_frame.input_label -text "Input data file" -anchor w
label .io_frame.output_label -text "Output data file" -anchor w
entry .io_frame.input_file_name -textvariable input_file
entry .io_frame.output_file_name -textvariable output_file

frame .ps_frame
label .ps_frame.ps_label -text "PostScript image file" -anchor w
label .ps_frame.hi_res_label -text "High resolution file" -anchor w
entry .ps_frame.ps_file_name -textvariable ps_file
entry .ps_frame.hi_res_file_name -textvariable hi_res_file

scale .depthScale -from -100 -to 0 -length 400 -variable elevation \
       -orient horizontal \
       -label "Cell value setting for land" \
       -tickinterval 50 -showvalue false
.depthScale set 0

entry .eDepth -textvariable elevation -relief sunken -justify left

scale .latScale -from -90 -to 90 -length 400 -variable latitude \
             -orient horizontal -label "Default latitude" \
             -tickinterval 45 -showvalue false

entry .eLat -textvariable latitude -relief sunken -justify left

scale .lonScale -from -180 -to 180 -length 400 -variable longitude \
             -orient horizontal -label "Default longitude" \
             -tickinterval 60 -showvalue false

entry .eLon -textvariable longitude -relief sunken -justify left

pack .variable_frame.data_name .variable_frame.data_label -side bottom
pack .variable_frame.x_name .variable_frame.x_label -side right
pack .variable_frame.y_name .variable_frame.y_label -side right

pack .io_frame.output_file_name .io_frame.output_label -side right
pack .io_frame.input_file_name .io_frame.input_label -side right
pack .ps_frame.hi_res_file_name .ps_frame.hi_res_label -side right
pack .ps_frame.ps_file_name .ps_frame.ps_label -side right

pack .ps_frame -side top
pack .io_frame -side top
pack .variable_frame -side top

pack .depthScale -in .top -side top
pack .eDepth -in .top -side top

pack .latScale -in .top -side top
pack .eLat -in .top -side top

pack .lonScale -in .top -side top
pack .eLon -in .top -side top

pack .top -side top -fill x

pack .top.run -side top

pack .refreshall .confirmchange -side bottom

set timeout -1

set autorefreshall "Y"
set promptforundo "N"
set refresh "N"
set undo "N"
set save_work "N"
set dataVar "kmt"
set xVar "ULON"
set yVar "ULAT"

proc Main { } {
    global autorefreshall elevation latitude longitude \
        refresh autoundo save_work undo hi_res_file ps_file promptforundo \
        dataVar xVar yVar program input_file output_file but
        
    .io_frame.input_file_name config -state disabled -foreground gray
    .io_frame.output_file_name config -state disabled -foreground gray
    .ps_frame.ps_file_name config -state normal -foreground blue
    .ps_frame.hi_res_file_name config -state normal -foreground blue
    .variable_frame.data_name config -state disabled -foreground gray
    .variable_frame.x_name config -state disabled -foreground gray
    .variable_frame.y_name config -state disabled -foreground gray
    $but config -text "Quit Without Saving" \
       -activebackground yellow -activeforeground red -command exit
    spawn $program -i $input_file -o $output_file
    for {} {1} {} {
         expect {
	   "data variable"       { exp_send "$dataVar\r" }
	   "X variable"          { exp_send "$xVar\r" }
	   "Y variable"          { exp_send "$yVar\r" }
	   "Paint bullseye\?*"   { exp_send "$autorefreshall\r" }
           "Change elevation\?*" { exp_send "y\r" ; exp_send " $elevation\r" }
           "ENTER LAND VALUE"    { exp_send $elevation\r" }
           "Latitude:"           { exp_send " $latitude\r" }
           "Longitude:"          { exp_send " $longitude\r" }
           "Enter PostScript filename for saved image" \
                                 { exp_send "$ps_file\r" }
           "Enter PostScript filename for high-resolution image" \
                                 { exp_send "$hi_res_file\r" }
           "Refresh to show changes\?*"       {
                                 exp_send "$autorefreshall\r"
           }
           "Undo last set of changes\?*"          {
             if {$promptforundo}  {
               set undo [Undoing "Undo changes\? \[$undo\]: "];
               exp_send "$undo\r";
             } else {
               exp_send "n\r";
             }
           }
           "Save before exiting\?*"          {
             set save_work [Exiting "Save before exiting\? \[$save_work\]:  "];
             exp_send "$save_work\r";
           }
           eof                   { exit 0 }
         }
    } 
}

proc Dialog_Create {top title args} {
    global dialog
    if [winfo exists $top] {
        switch -- [wm state $top] {
            normal {
                raise $top
            }
            withdrawn -
            iconic {
                wm deiconify $top
                catch {wm geometry $top $dialog(geo,$top)}
            }
        }
        return 0
    } else {
        eval {toplevel $top} $args
        wm title $top $title
        return 1
    }
}
proc Dialog_Wait {top varName {focus {}}} {
    upvar $varName var
    bind $top <Destroy> [list set $varName cancel]

    if {[string length $focus] == 0} {
        set focus $top
    }
    set old [focus -displayof $top]
    focus $focus
    catch {tkwait visibility $top}
    catch {grab $top}

    tkwait variable $varName
    catch {grab release $top}
    focus $old
}
proc Dialog_Dismiss {top} {
    global dialog
    catch {
        set dialog(geo,$top) [wm geometry $top]
        wm withdraw $top
    }
}

proc Refreshing { string } {
    global refresh_prompt
    set f .refresh_prompt
    if [Dialog_Create $f "Prompt" -borderwidth 10] {
        message $f.msg -text $string -aspect 1000
        entry $f.entry -textvariable refresh_prompt(result)
        set b [frame $f.buttons]
        pack $f.msg $f.entry $f.buttons -side top -fill x
        pack $f.entry -pady 5
        button $b.ok -text OK -command {set refresh_prompt(ok) 1}
        button $b.cancel -text Cancel \
            -command {set refresh_prompt(ok) 0}
        pack $b.ok -side left
        pack $b.cancel -side right
        bind $f.entry <Return> {set refresh_prompt(ok) 1 ; break}
        bind $f.entry <Control-c> {set refresh_prompt(ok) 0 ; break}
    }
    set refresh_prompt(ok) 0
    Dialog_Wait $f refresh_prompt(ok) $f.entry
    Dialog_Dismiss $f
    if {$refresh_prompt(ok)} {
        return $refresh_prompt(result)
    } else {
        return {}
    }
}

proc Exiting { string } {
    global exit_prompt
    set f .exit_prompt
    if [Dialog_Create $f "Exit Dialog" -borderwidth 10] {
        message $f.msg -text $string -aspect 1000
        entry $f.entry -textvariable exit_prompt(result)
        set b [frame $f.buttons]
        pack $f.msg $f.entry $f.buttons -side top -fill x
        pack $f.entry -pady 5
        button $b.ok -text OK -command {set exit_prompt(ok) 1}
        button $b.cancel -text Cancel \
            -command {set exit_prompt(ok) 0}
        pack $b.ok -side left
        pack $b.cancel -side right
        bind $f.entry <Return> {set exit_prompt(ok) 1 ; break}
        bind $f.entry <Control-c> {set exit_prompt(ok) 0 ; break}
    }
    set exit_prompt(ok) 0
    Dialog_Wait $f exit_prompt(ok) $f.entry
    Dialog_Dismiss $f
    if {$exit_prompt(ok)} {
        return $exit_prompt(result)
    } else {
        return {}
    }
}

proc Undoing { string } {
    global undo_prompt
    set f .undo_prompt
    if [Dialog_Create $f "Undo Dialog" -borderwidth 10] {
        message $f.msg -text $string -aspect 1000
        entry $f.entry -textvariable undo_prompt(result)
        set b [frame $f.buttons]
        pack $f.msg $f.entry $f.buttons -side top -fill x
        pack $f.entry -pady 5
        button $b.ok -text OK -command {set undo_prompt(ok) 1}
        button $b.cancel -text Cancel \
            -command {set undo_prompt(ok) 0}
        pack $b.ok -side left
        pack $b.cancel -side right
        bind $f.entry <Return> {set undo_prompt(ok) 1 ; break}
        bind $f.entry <Control-c> {set undo_prompt(ok) 0 ; break}
    }
    set undo_prompt(ok) 0
    set undo_prompt(result) ""
    Dialog_Wait $f undo_prompt(ok) $f.entry
    Dialog_Dismiss $f
    if {$undo_prompt(ok)} {
        return $undo_prompt(result)
    } else {
        return {}
    }
}
