/*=========================================================================

  Program:   Visualization Toolkit
  Module:    visibility.cpp
  Language:  C++
  Date:      Date: 08/15/2002 17:00:00 
  Version:   Revision: 1.0 

Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "vtkActor.h"
#include "vtkPolyDataMapper.h"
#include "visibility.h"
#include "vtkLookupTable.h"
    

visibility::visibility()
{
    
    renderer = vtkRenderer::New();// Renderer
    renWin = vtkRenderWindow::New();// Window
    iren = vtkRenderWindowInteractor::New();

}

visibility::~visibility()
{
    
    renderer->Delete();
    renWin->Delete();
    iren->Delete();
    
}

void visibility::UpdateNow()
{

    renWin->AddRenderer(renderer);// A Window has a Renderer
    iren->SetRenderWindow(renWin);// An Interactor has a Window
    
        if (myText->getTextOn())//POPgrid->getTextOn() )
            myText->GetText()->VisibilityOn();
        else
        {
            myText->GetText()->VisibilityOff();
        }

        if (colorDepths->getTopographyOn())//POPgrid->getTopographyOn() )
            colorDepths->GetColorFill()->VisibilityOn();
        else
        {
            colorDepths->GetColorFill()->VisibilityOff();
        }

        if (presentEarth->getConOutlinesOn())//POPgrid->getConOutlinesOn() )
                presentEarth->GetLandShapes()->VisibilityOn();
        else
                presentEarth->GetLandShapes()->VisibilityOff();

        if (horizGrid->GetGridOn())//POPgrid->getTextOn() )
            horizGrid->GetGrid()->VisibilityOn();
        else
        {
            horizGrid->GetGrid()->VisibilityOff();
        }

        colorDepths->GetScalarBar()->VisibilityOn();

        //cout << "Refreshing in visibility UpdateNow" << endl;
        renWin->Render();


}

void visibility::Execute()
{
    vtkPolyData *output = this->GetOutput();
}



