/*=========================================================================

  Program:   Visualization Toolkit
  Module:    topography.cpp
  Language:  C++
  Date:      Date: 08/15/2002 17:00:00 
  Version:   Revision: 1.0 

Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "vtkActor.h"
#include "vtkLODActor.h"
#include "vtkScalarBarActor.h"
#include "vtkPolyDataMapper.h"
#include "topography.h"
#include "vtkLookupTable.h"
    
extern char* dataVar;

topography::topography()
{
    this->NumOfColors = 64;
    this->red = 0.5;
    this->green = 0.5;
    this->blue = 0.5;
    this->youWantItBlue = false;
    this->topographyOn = true;
    this->artificialLand = 0.0;
    colorFillMapper = vtkPolyDataMapper::New();
    colorFillActor = vtkLODActor::New();
    scalarBar = vtkScalarBarActor::New();
    MyLUT = vtkLookupTable::New();


}

topography::~topography()
{
    colorFillMapper->Delete();
    colorFillActor->Delete();
    scalarBar->Delete();
    MyLUT->Delete();

}
void topography::UpdateNow(grid3D *POPgrid)
{
    colorFillMapper->SetInput(POPgrid->GetOutput());
    MyLUT->SetNumberOfTableValues(NumOfColors);

    MyLUT->SetHueRange(.667, 0.0);
    MyLUT->Build();
            

    int k;
    if(youWantItBlue) //oceans mapped in sliding blue scale
    {
        for(k=0; k<(NumOfColors/2); k++)  //(NumOfColors-2) excludes extreme 
        {
            MyLUT->SetTableValue(k, 0.0, 0.0, ((float)(2*k)/(float)NumOfColors), 1.0);  //This gives blue shaded scale
            //cout<<"k is: "<<k<<"n is: "<<NumOfColors<<"      k over n is: "<<((float)k/NumOfColors)<<endl;
        }
        for(k=(NumOfColors/2); k<NumOfColors; k++)
        {
            MyLUT->SetTableValue(k, 0.5, 0.5, 0.5, 1.0 );
        }

   }
    else  //oceans mapped with four colors
    {
        //int temp = NumOfColors;
        int temp1 = 2*(NumOfColors)/16;
        int temp2 = 4*(NumOfColors)/16;
        int temp3 = 6*(NumOfColors)/16;
        cout << "Color scale boundaries 0, " 
            << temp1 << ", " << temp2 << ", " << temp3 << ", " << "\n";

        int k;
        float red_k, blue_k, green_k;
        for(k=0; k<temp1; k++)
        {
            red_k = 1.0;
            green_k = (float)(k)/(float)temp1;
            blue_k = 0.0;
            MyLUT->SetTableValue(k, red_k, blue_k, green_k, 1.0);
            cout << k << ": " 
			     << red_k << ", " << green_k << ", " << blue_k << "\n";
        }

        for(k=temp1; k<temp2; k++)  
        {
            red_k = (float)(temp2-k)/(float)(temp2-temp1);
            green_k = 1.0;
            blue_k = (float)(k-temp1)/(float)(temp2-temp1);
            MyLUT->SetTableValue(k, red_k, blue_k, green_k, 1.0);
            cout << k << ": " << red_k << ", " << green_k << ", " << blue_k << "\n";
        }
        cout << endl;

        for(k=temp2; k<temp3; k++)  
        {
            red_k = 0.0;
            green_k = (float)(temp3-k)/(float)(temp3-temp2);
            blue_k = 1.0;
            MyLUT->SetTableValue(k, red_k, blue_k, green_k, 1.0);
            cout << k << ": " << red_k << ", " << green_k << ", " << blue_k << "\n";
        } 
        cout << endl;

        for(k=temp3; k<NumOfColors; k++)  
        {
            red_k = (float)(k-temp3)/(float)(NumOfColors-temp3);
            green_k = 0.0;
            blue_k = 1.0;
            MyLUT->SetTableValue(k, red_k, blue_k, green_k, 1.0);
            cout << k << ": " << red_k << ", " << green_k << ", " << blue_k << "\n";
        } 
                
    } //end of else

    //sets the uppermost extreme (0 elevation), the continent color      
	// Ensure land will be gray
    for(k=0; k<3; k++)
    {
        MyLUT->SetTableValue( k, 0.5, 0.5, 0.5, 1.0 );
       //gray (0.5, 0.5, 0.5)
       //black is (0.0, 0.0, 0.0)
       //brown looks bad
    }
    cout << endl;

    colorFillMapper->SetLookupTable(MyLUT);  //uses custom color scale to color the PolyDataMapper
    //colorFillMapper->SetScalarRange(POPgrid->minElevation,POPgrid->maxElevation); //simulates a low ocean depth (meters) to just above surface
    //colorFillMapper->SetScalarRange(-7000.0, 7000.0);
    float upperLimit = 1.0;
    float multiplier = 1.0;
    while (upperLimit <= POPgrid->maxElevation)
    {
        multiplier *= 10.0;
        upperLimit = 1.0 * multiplier;
        while (upperLimit > POPgrid->maxElevation)
        {
            upperLimit -= multiplier/10;
        }
        upperLimit += multiplier/10;
    }
    cout << "Upper Limit " << upperLimit << "\n";

    float lowerLimit = -1.0;
    multiplier = 1.0;
    while (lowerLimit >= POPgrid->minElevation)
    {
        multiplier *= 10.0;
        lowerLimit = -1.0 * multiplier;
        while (lowerLimit < POPgrid->minElevation)
        {
            lowerLimit += multiplier/10;
        }
        lowerLimit -= multiplier/10;
    }
    cout << "Lower Limit " << lowerLimit << "\n";

    colorFillMapper->SetScalarRange(lowerLimit, upperLimit);

          colorFillActor->SetMapper(colorFillMapper);// colorFill Actor has-a Mapper
            //colorFillActor->SetTexture(aTexture);   // and has-a Texture 
            colorFillActor->GetProperty()->SetRepresentationToSurface();
            colorFillActor->PickableOff();
            colorFillActor->VisibilityOff();
            //colorFillActor->GetProperty()->SetColor(1.0, 0.0, 0.0);
    scalarBar->SetLookupTable(colorFillMapper->GetLookupTable());
    scalarBar->SetTitle(dataVar);
    scalarBar->GetPositionCoordinate()->SetCoordinateSystemToNormalizedViewport();
    scalarBar->GetPositionCoordinate()->SetValue(0.01, 0.2);
    scalarBar->SetOrientationToVertical();
    scalarBar->SetWidth(0.17);
    scalarBar->SetHeight(0.9);
    scalarBar->BoldOn();
    scalarBar->SetLabelFormat("%-#6.0f");
    cout << "Label format " << scalarBar->GetLabelFormat() << endl;
         
}



void topography::Execute()
{
    vtkPolyData *output = this->GetOutput();
}

vtkLODActor* topography::GetColorFill()
{
    return colorFillActor;
}

vtkScalarBarActor* topography::GetScalarBar()
{
    return scalarBar;
}

void topography::changeTopographyOn()
{
     topographyOn = !topographyOn; 
}

bool topography::getTopographyOn()
{
    return topographyOn;
}
