/*=========================================================================

    Program:   Visualization Toolkit
  Module:    textDisplay.cpp
  Language:  C++
  Date:      Date: 08/15/2002 17:00:00 
  Version:   Revision: 1.0 

Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "vtkActor.h"
#include "vtkLODActor.h"
#include "textDisplay.h"
#include "vtkPolyData.h"
#include "vtkActor2D.h"
#include "vtkTextMapper.h"

    

textDisplay::textDisplay()
{
    this->red = 56;        //change in range of 0-256  \ 
    this->green = 56;  //change in range of 0-256   } determines color of text
    this->blue = 256;       //change in range of 0-256  /
    this->colorBase = 256;
    this->textOn = false;

  textMapper = vtkTextMapper::New();
    textActor = vtkActor2D::New();
}
textDisplay::~textDisplay()
{
        textMapper->Delete();
        textActor->Delete();
}
void textDisplay::MakeText()
{
    // Text mapper and Actor

        textMapper->SetFontFamilyToArial();
        textMapper->SetFontSize(12);
        textMapper->BoldOn();

    textActor->SetMapper(textMapper);
    textActor->GetProperty()->SetColor( red/colorBase, 
                                         green/colorBase, 
                                         blue/colorBase); 
    textActor->VisibilityOff();
        //whenever a text object is created visibility must be turned on
         
}

void textDisplay::Execute()
{
    vtkPolyData *output = this->GetOutput(); //don't think this line is necessary but it runs!
}

//method by which other functions can change aspects of the actor
vtkActor2D* textDisplay::GetText()
{
    return textActor;
}

//method by which other functions and classes can change aspects of the mapper
vtkTextMapper* textDisplay::GetTextMapper()
{
    return textMapper;
}

void textDisplay::changeTextOn()
{
     textOn = !textOn; 
}

bool textDisplay::getTextOn()
{
    return textOn;
}

