/*=========================================================================

  Program:   Visualization Toolkit
  Module:    gridlines.cpp
  Language:  C++
  Date:      Date: 08/15/2002 17:00:00 
  Version:   Revision: 1.0 

Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "vtkEarthSource.h"
#include "vtkActor.h"
#include "vtkLODActor.h"
#include "vtkPolyDataMapper.h"
#include "gridlines.h"

    

gridlines::gridlines()
{
    this->red = 256;        //change in range of 0-256  \ 
    this->green = 256;  //change in range of 0-256   } determines color of gridlines
    this->blue = 256;       //change in range of 0-256  /
    this->colorBase = 256;
    this->fineGrid = true;
    this->gridOn = true;

    gridActor = vtkLODActor::New();
  gridMapper = vtkPolyDataMapper::New();
    plotActor = vtkLODActor::New();

}
gridlines::~gridlines()
{
        plotActor->Delete();
        gridMapper->Delete();
        gridActor->Delete();
}
void gridlines::MakeGrid(grid3D *POPgrid)
{
    /******************** fine and coarse grids ******************************/

    if(fineGrid) //using the fine grid
    {
        //Tripolar Grid and grid mapper
        vtkLookupTable* lut = vtkLookupTable::New();


            gridMapper->SetInput(POPgrid->GetOutput());
            //gridMapper->SetColorModeToDefault();
    
            lut->SetNumberOfColors(64);
            lut->SetHueRange(.667, 0.0);
            lut->Build();   

            gridMapper->SetLookupTable(lut);
            gridMapper->SetScalarModeToUseCellData();
            gridMapper->ScalarVisibilityOff();

            gridActor->SetMapper(gridMapper);// Grid Actor has-a Mapper 
            //gridActor->GetProperty()->SetOpacity(0.9);
            gridActor->GetProperty()->SetOpacity(0.3);
            gridActor->GetProperty()->SetColor(red/colorBase, green/colorBase, blue/colorBase);
            gridActor->GetProperty()->SetRepresentationToWireframe();
            //gridActor->GetProperty()->SetRepresentationToSurface();
            gridActor->PickableOn();
            gridActor->VisibilityOn();
            plotActor->VisibilityOff();
    }

    else  //using the coarse grid
    {   
        //Define plot actor and uses

        red = 255/colorBase; green = 1/colorBase; blue = 1/colorBase;
    
        //plotActor->SetMapper(plotMapper);
        plotActor->GetProperty()->SetOpacity(1.0);
        plotActor->GetProperty()->SetColor(red,green,blue);
        plotActor->GetProperty()->SetRepresentationToWireframe();
        plotActor->PickableOff();
        plotActor->VisibilityOn();
        gridActor->VisibilityOff();
    }
}

void gridlines::Execute()
{
    vtkPolyData *output = this->GetOutput();
}

vtkLODActor* gridlines::GetGrid()
{
    return gridActor;
}

vtkLODActor* gridlines::GetPlot()
{
    return plotActor;
}

void gridlines::changeGridOn()
{
     gridOn = !gridOn;
}

bool gridlines::GetGridOn()
{
    return gridOn;
}

bool gridlines::GetFineGrid()
{
    return fineGrid;
}

