/*=========================================================================

  Program:   Visualization Toolkit
  Module:    coastlines.cpp
  Language:  C++
  Date:      Date: 08/15/2002 17:00:00 
  Version:   Revision: 1.0 


Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "vtkEarthSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkProperty.h"
#include "coastlines.h"

//************See header file for detailed documentation**************\\ 

coastlines::coastlines()
{
    this->red = 256;    //range of 0-256  \ 
    this->green = 256;  //range of 0-256   } determines color of coastlines
    this->blue = 256;   //range of 0-256  /  to be white initially
    this->colorBase = 256;
    this->conOutlinesOn = true;
    landShapes = vtkEarthSource::New();     //vtkPoints for present day earth's continents
  landShapesMapper = vtkPolyDataMapper::New();
    landShapesActor = vtkLODActor::New();
}
coastlines::~coastlines()
{
        landShapes->Delete();
        landShapesMapper->Delete();
        landShapesActor->Delete();
}
void coastlines::MakeOutlines()
{
      landShapes->SetRadius(1.003);  //Displays outlines on top of other radii
        landShapes->SetOnRatio(1);      
        landShapes->OutlineOn();            //shows outlines instead of fill

        landShapesMapper->SetInput(landShapes->GetOutput());

        landShapesActor->SetMapper(landShapesMapper);
        landShapesActor->GetProperty()->SetOpacity(1.0);
        //landShapesActor->GetProperty()->SetColor(red/colorBase, green/colorBase, blue/colorBase); 
        landShapesActor->GetProperty()->SetColor(0.0,0.0,0.0); // Black
        landShapesActor->GetProperty()->SetRepresentationToSurface();
        landShapesActor->PickableOff();
        landShapesActor->VisibilityOn();
         
}

void coastlines::Execute()
{
    vtkPolyData *output = this->GetOutput();
}

vtkLODActor* coastlines::GetLandShapes()
{
    return landShapesActor;
}

void coastlines::changeConOutlinesOn()
{
     conOutlinesOn = !conOutlinesOn;
}

bool coastlines::getConOutlinesOn()
{
    return conOutlinesOn;
}

