//vtkLibrary header files
#include "vtkPolyData.h"
#include "vtkEarthSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkLookupTable.h"

//custom header files
#include "grid3D.h"
#include "textDisplay.h"
#include "topography.h"
#include "coastlines.h"
#include "gridlines.h"

//used in each header file to make sure includes are only included once
#ifndef __visibility_h
#define __visibility_h

extern vtkRenderWindow *renWin;
extern vtkRenderer *renderer;
extern vtkRenderWindowInteractor *iren;

extern grid3D *POPgrid;
extern textDisplay *myText;
extern coastlines *presentEarth;
extern topography *colorDepths;
extern gridlines *horizGrid;
/******************************************************************
This is a class that updates the visibility for all of the actors.  It
will get the boolean flags from each display actor and determine the 
visibility of that actor.  

to update all of the visibilities, make an object of visibility and 
simply call UpdateNow() 

ex.
        visibility *myVisibility = new visibility();
        myVisibility->UpdateNow();

When additional display features are added such as city lights for example,
add the .h file and extern here and use an additional if loop in the .cpp
file to turn that visibility on or off.  Then you can bind a key in controls.cpp
to tweak that new functionality.  
********************************************************************/

class visibility : public vtkPolyDataSource 
{
public:
  vtkTypeMacro(visibility,vtkPolyDataSource);

        //default constructor
  visibility();

        //default destructor
  ~visibility();

        // class where all of the action is
        void UpdateNow();
        void Execute();

        // Both created so compiler does not create machine specific functions
  visibility(const visibility&);
  void operator=(const visibility&);

private:

};
#endif
