//vtkLibrary header files
#include "vtkPolyData.h"
#include "vtkEarthSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkLODActor.h"
#include "vtkScalarBarActor.h"
#include "grid3D.h"
#include "textDisplay.h"
#include "vtkLookupTable.h"
#include "coastlines.h"

//used in each header file to make sure includes are only included once
#ifndef __topography_h
#define __topography_h


/******************************************************************
This is a class that will create the topography display that can be
turned on and off.  The class grid3D creates the cell elevations for
each cell on the custom grid.  This class allows the elevations mapper
to be turned on and off without affecting the visibility of the gridlines.  

This class can also be modified to change the color mapping scheme for 
the oceans and continents.  To change the colors tweak the 
vtkLookupTable and its parameters.  
********************************************************************/

class topography : public vtkPolyDataSource 
{
public:
  vtkTypeMacro(topography,vtkPolyDataSource);

        //default constructor
  topography();

        //default destructor
  ~topography();

        // mapps the ocean depths as colors
  void UpdateNow(grid3D *POPgrid);

        void Execute();

        vtkLODActor* GetColorFill();       //returns colorFillActor
        vtkScalarBarActor* GetScalarBar();       //returns scalarBar

        void  changeTopographyOn(); //changes flag
        bool  getTopographyOn();    // allows other classes to access current state of flag
        
        int NumOfColors;
        float red, green, blue;
        float artificialLand;



        // Both created so compiler does not create machine specific functions
  topography(const topography&);
  void operator=(const topography&);


private:
        //creates vtkObjects
        vtkPolyDataMapper *colorFillMapper;
        vtkLODActor *colorFillActor;
        vtkScalarBarActor *scalarBar;
        vtkLookupTable* MyLUT;

        bool youWantItBlue;             //allows ocean to be mapped in blue color range
        bool  topographyOn;             // turn elevation mapping on or off




};
#endif

