//vtkLibrary header files
#include "vtkPolyData.h"
#include "vtkTextMapper.h"
#include "vtkPolyDataMapper.h"
#include "vtkDataSetMapper.h"
#include "vtkActor.h"
#include "vtkLODActor.h"
#include "vtkActor2D.h"
//#include "vtkInteractorStyleMyPicker.h"
//#include "vtkInteractorStyleUser.h"

//used in each header file to make sure includes are only included once
#ifndef __textDisplay_h
#define __textDisplay_h

/******************************************************************
This is a class that will create the text when a certain cell is 
picked.  Note there is no default text that prints and the 
visibility is initially off.  Another function such as pick must 
modify an instance of textDisplay to set the input.  For example

textDisplay *myObject = new textDisplay();
myObject->GetTextMapper()->SetInput("trial text");
myObject->GetText()->VisibilityOn();

will display the string "trial text" in the default position.

To change the position of the text on screen and for other 
manipulations see the method SetPosition(floatx, float y) 
under vtkActor2D and its other methods.  

********************************************************************/

class textDisplay : public vtkPolyDataSource 
{
public:
  vtkTypeMacro(textDisplay,vtkPolyDataSource);

        //default constructor
  textDisplay();

        //default destructor
  ~textDisplay();

        // call to update Text characterixtics
  void MakeText();

        void Execute();

  vtkActor2D* GetText(); // returns textActor
        vtkTextMapper* GetTextMapper();  //returns textMapper
        
        // Both created so compiler does not create machine specific functions
  textDisplay(const textDisplay&);
  void operator=(const textDisplay&);

        void  changeTextOn();  // changes flag
        bool  getTextOn();               // allows other functions to get current condition of flag

private:
        //creates actors
        vtkActor2D *textActor;
        vtkTextMapper *textMapper;

        bool  textOn;           // flag that turns text on or off 
        float red, green, blue, colorBase;

};
#endif

