//vtkLibrary header files
#include "vtkPolyData.h"
#include "vtkEarthSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkLODActor.h"
#include "grid3D.h"

//used in each header file to make sure includes are only included once
#ifndef __gridlines_h
#define __gridlines_h


/******************************************************************
This is a class that will display the gridlines across the earth.  The 
custom grid can then be turned on and off (visibility) without affecting
the color mapping or any other visual aspect.  

gridActor gives a finer grid than the plotActor which can be used for 
quick lower computational models where a fine grid is unnecessary.

The boolean flag variables gridOn and fineGrid can be turned on and off 
or accessed by other classes through calls to their respective functions.  
********************************************************************/

class gridlines : public vtkPolyDataSource 
{
public:
  vtkTypeMacro(gridlines,vtkPolyDataSource);

        //default constructor
  gridlines();

        //default destructor
  ~gridlines();

        // Depending on the state of the fineGrid flag this makes a fine or coarse grid
        // and sets all of the parameters such as color, opacity, etc. 
  void MakeGrid(grid3D *POPgrid);


        void Execute();

  vtkLODActor* GetGrid();  //returns the gridActor to be manipulated by other classes
        vtkLODActor* GetPlot();  //returns the plotActor to be manipulated by other classes

        void  changeGridOn(); //alters state of grid flag
        
        // Both created so compiler does not create machine specific functions
  gridlines(const gridlines&);
  void operator=(const gridlines&);


        
        bool  GetGridOn();              //returns gridOn which determines visibility of grid on globe
        bool  GetFineGrid();    //returns fineGrid which determines if grid is fine or coarse


private:

        // Coarse grid actor 
        vtkLODActor *plotActor;

        // Fine grid actor
        vtkLODActor *gridActor;

        // allows gridActor to be mapped
        vtkPolyDataMapper *gridMapper;

        //i think we need a plotMapper but there is none as of now!

        
        float red, green, blue, colorBase;
        bool    fineGrid;               // pick fine or coarse grid
        bool gridOn;                    // turn grid visibility on or off


};
#endif

