//vtkLibrary header files
#include "vtkPolyData.h"
#include "vtkEarthSource.h"
#include "vtkPolyDataMapper.h"
#include "vtkActor.h"
#include "vtkLODActor.h"

//used in each header file to make sure includes are only included once
#ifndef __coastlines_h
#define __coastlines_h

/******************************************************************
This is a class that will create the coastlines around the 
continents.  It was isolated here and only coastlines.cpp must 
be modified to display new data for an ancient world for example.  
Simply replace the line

                landShapes = vtkEarthSource::New(); 
with 
                landShapes = new MyEarthData();

The color of the outlines can also be changed anywhere by calling 
properties of an instance of the coastlines object like so:

myObject->GetLandShapes()->GetProperty()->SetColor(red, green, blue);

**Make sure to call MakeOutlines() before calling GetLandShapes() to 
get the most updated characteristics of the object
********************************************************************/

class coastlines : public vtkPolyDataSource 
{
public:
  vtkTypeMacro(coastlines,vtkPolyDataSource);  //necessary vtkMacro--not sure what it does exactly

        // default constructor
  coastlines();

        // default destructor
  ~coastlines();

        // MakeOutlines() sets all of the properties of the landShapesActors
        // and Mappers and links the two together.  
  void MakeOutlines();

        // automatically called at instantiation
        // I prefer to be able to call methods manually which is why all the work is 
        // done in MakeOutlines() and not here
        void Execute();

        // GetLandShapes() will return a pointer to the actor to be 
        // manipulated in other classes--i.e. VisibilityOn()/Off()--
  vtkLODActor* GetLandShapes();

        void  changeConOutlinesOn();    //tweaks flag
        bool  getConOutlinesOn();                       //returns present state of flag

        // Both created so compiler does not create machine specific functions
  coastlines(const coastlines&);
  void operator=(const coastlines&);

        
private:
        vtkEarthSource *landShapes;
        vtkPolyDataMapper *landShapesMapper;
        vtkLODActor *landShapesActor;

        bool  conOutlinesOn;                                    // flag that turns con. outlines on or off

        
        float red, green, blue;                 // color manipulation
        float colorBase;                                                // set usually for 256 colors


};
#endif
